/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxform.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:27:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_TBXFORM_HXX
#define _SVX_TBXFORM_HXX

#ifndef _SFXTBXCTRL_HXX //autogen
#include <sfx2/tbxctrl.hxx>
#endif

#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

//========================================================================
class SvxFmAbsRecWin : public NumericField
{
	SfxToolBoxControl*	m_pController;
		// for invalidating our content whe losing the focus
public:
	SvxFmAbsRecWin( Window* _pParent, SfxToolBoxControl* _pController );
	~SvxFmAbsRecWin();

	virtual void KeyInput( const KeyEvent& rKeyEvt );
	virtual void LoseFocus();

protected:
	virtual void FirePosition( sal_Bool _bForce );
};


//========================================================================
class SvxFmConfigWin : public SfxPopupWindow
{
private:
	DECL_LINK( TbxSelectHdl, ToolBox* );

public:
	SvxFmConfigWin( USHORT nId, ResId aRIdWin, ResId aRIdTbx );
	~SvxFmConfigWin();

	void			Update();
	virtual void	PopupModeEnd();
};


//========================================================================
class SvxFmTbxCtlConfig : public SfxToolBoxControl
{
private:
	UINT16 nLastSlot;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlConfig( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxFmTbxCtlConfig() {}

	virtual void				Select( USHORT nModifier );
	virtual void				StateChanged( USHORT nSID, SfxItemState eState,
											  const SfxPoolItem* pState );
	virtual SfxPopupWindowType	GetPopupWindowType() const;
	virtual SfxPopupWindow*		CreatePopupWindow();
};

//========================================================================
class FixedText;
class SvxFmTbxCtlAbsRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlAbsRec( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxFmTbxCtlAbsRec();

	virtual Window*	CreateItemWindow( Window* pParent );

	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
};

//========================================================================
class SvxFmTbxCtlRecText : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecText( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecText();

	virtual Window*	CreateItemWindow( Window* pParent );
};

//========================================================================
class SvxFmTbxCtlRecFromText : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecFromText( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecFromText();

	virtual Window*	CreateItemWindow( Window* pParent );
};

//========================================================================
class SvxFmTbxCtlRecTotal : public SfxToolBoxControl
{
	FixedText* pFixedText;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFmTbxCtlRecTotal( USHORT nSlotId, USHORT nId, ToolBox& rTbx );
	~SvxFmTbxCtlRecTotal();

	virtual Window*	CreateItemWindow( Window* pParent );
	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
};

//========================================================================
class SvxFmTbxNextRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();											 
	SvxFmTbxNextRec( USHORT nSlotId, USHORT nId, ToolBox& rTbx );	
};

//========================================================================
class SvxFmTbxPrevRec : public SfxToolBoxControl
{
public:
	SFX_DECL_TOOLBOX_CONTROL();											 
	SvxFmTbxPrevRec( USHORT nSlotId, USHORT nId, ToolBox& rTbx );	
};					


#endif

