/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: formattedcontrol.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:48:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef TOOLKIT_FORMATTED_CONTROL_HXX
#define TOOLKIT_FORMATTED_CONTROL_HXX

#ifndef _TOOLKIT_HELPER_UNOCONTROLS_HXX_
#include <toolkit/controls/unocontrols.hxx>
#endif
#ifndef _TOOLKIT_AWT_UNOCONTROLMODEL_HXX_
#include <toolkit/controls/unocontrolmodel.hxx>
#endif
#ifndef _TOOLKIT_HELPER_SERVICENAMES_HXX_
#include <toolkit/helper/servicenames.hxx>
#endif

#ifndef _COM_SUN_STAR_AWT_XSPINFIELD_HPP_
#include <com/sun/star/awt/XSpinField.hpp>
#endif

//........................................................................
namespace toolkit
{
//........................................................................

	// ===================================================================
	// = UnoControlFormattedFieldModel
	// ===================================================================
	class UnoControlFormattedFieldModel : public UnoControlModel
	{
	protected:	
		::com::sun::star::uno::Any 		ImplGetDefaultValue( sal_uInt16 nPropId ) const;
		::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();

	protected:
		sal_Bool SAL_CALL convertFastPropertyValue(
					::com::sun::star::uno::Any& rConvertedValue,
					::com::sun::star::uno::Any& rOldValue,
					sal_Int32 nPropId,
					const ::com::sun::star::uno::Any& rValue
				) throw (::com::sun::star::lang::IllegalArgumentException);

	public:
							UnoControlFormattedFieldModel();
							UnoControlFormattedFieldModel( const UnoControlFormattedFieldModel& rModel ) : UnoControlModel( rModel ) {;}
							
		UnoControlModel*	Clone() const { return new UnoControlFormattedFieldModel( *this ); }
							
		// ::com::sun::star::io::XPersistObject
		::rtl::OUString SAL_CALL getServiceName() throw(::com::sun::star::uno::RuntimeException);

		// ::com::sun::star::beans::XMultiPropertySet
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException);


		// ::com::sun::star::lang::XServiceInfo
		DECLIMPL_SERVICEINFO_DERIVED( UnoControlFormattedFieldModel, UnoControlModel, szServiceName2_UnoControlFormattedFieldModel )
	};

	// ===================================================================
	// = UnoFormattedFieldControl
	// ===================================================================
	class UnoFormattedFieldControl : public UnoSpinFieldControl
	{
	public:
							UnoFormattedFieldControl();
		::rtl::OUString		GetComponentServiceName();

		// ::com::sun::star::awt::XTextListener
		void SAL_CALL textChanged( const ::com::sun::star::awt::TextEvent& rEvent ) throw(::com::sun::star::uno::RuntimeException);
		
		// ::com::sun::star::lang::XServiceInfo
		DECLIMPL_SERVICEINFO_DERIVED( UnoFormattedFieldControl, UnoEditControl, szServiceName2_UnoControlFormattedField )
	};

//........................................................................
}	// namespace toolkit
//........................................................................

#endif // TOOLKIT_FORMATTED_CONTROL_HXX
