/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intnmac.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:25:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "mac_start.h"

#include <script.h>
#include <IntlResources.h>
#include <TextUtils.h>
#include <Resources.h>

#include "mac_end.h"

#ifndef _INTNTAB_HXX
#include "intntab.hxx"
#endif

// =======================================================================

void SetSystemLanguage( LanguageType eLang )
{
}

// =======================================================================

static LanguageType MacRegionToSVLang( short nMacReg )
{
    switch ( nMacReg )
    {
        case verUS:
            return LANGUAGE_ENGLISH_US;
        case verFrance:
            return LANGUAGE_FRENCH;
        case verBritain:
            return LANGUAGE_ENGLISH_UK;
        case verGermany:
            return LANGUAGE_GERMAN;
        case verItaly:
            return LANGUAGE_ITALIAN;
        case verNetherlands:
            return LANGUAGE_DUTCH;
        case verFrBelgiumLux:
            return LANGUAGE_FRENCH_BELGIAN;
        case verSweden:
            return LANGUAGE_SWEDISH;
        case verDenmark:
            return LANGUAGE_DANISH;
        case verPortugal:
            return LANGUAGE_PORTUGUESE;
        case verFrCanada:
            return LANGUAGE_FRENCH_CANADIAN;
        case verIsrael:
            return LANGUAGE_HEBREW;
        case verJapan:
            return LANGUAGE_JAPANESE;
        case verAustralia:
            return LANGUAGE_ENGLISH_AUS;
        case verArabia:
            return LANGUAGE_ARABIC;
        case verFinland:
            return LANGUAGE_FINNISH;
        case verFrSwiss:
            return LANGUAGE_FRENCH_SWISS;
        case verGrSwiss:
            return LANGUAGE_GERMAN_SWISS;
        case verGreece:
            return LANGUAGE_GREEK;
        case verIceland:
            return LANGUAGE_ICELANDIC;
        case verMalta:
            return LANGUAGE_DONTKNOW;
        case verCyprus:
            return LANGUAGE_DONTKNOW;
        case verTurkey:
            return LANGUAGE_TURKISH;
        case verYugoCroatian:
            return LANGUAGE_CROATIAN;
        case verIndiaHindi:
            return LANGUAGE_DONTKNOW;
        case verPakistan:
            return LANGUAGE_DONTKNOW;
        case verLithuania:
            return LANGUAGE_LITHUANIAN;
        case verPoland:
            return LANGUAGE_POLISH;
        case verHungary:
            return LANGUAGE_HUNGARIAN;
        case verEstonia:
            return LANGUAGE_ESTONIAN;
        case verLatvia:
            return LANGUAGE_LATVIAN;
        case verLapland:
            return LANGUAGE_DONTKNOW;
        case verFaeroeIsl:
            return LANGUAGE_FAEROESE;
        case verIran:
            return LANGUAGE_FARSI;
        case verRussia:
            return LANGUAGE_RUSSIAN;
        case verIreland:
            return LANGUAGE_ENGLISH_EIRE;
        case verKorea:
            return LANGUAGE_KOREAN;
        case verChina:
            return LANGUAGE_CHINESE;
        case verTaiwan:
            return LANGUAGE_DONTKNOW;
        case verThailand:
            return LANGUAGE_THAI;
        default:
            return LANGUAGE_DONTKNOW;
    }
}

// =======================================================================

#pragma segment SV_ClickLoops

static StringCompare ImplSystemLanguageCompare( const char* pStr1,
                                                const char* pStr2,
                                                USHORT nFlags,
                                                CharSet eCharSet,
                                                LanguageType )
{
    USHORT  nLen1 = strlen( pStr1 );
    USHORT  nLen2 = strlen( pStr2 );
    int     nRet;

    // Falls es sich nicht um den ANSI-CharSet handelt, muessen wir
    // vorher konvertieren
    CharSet eSystenCharSet = GetSystemCharSet();
    if ( (eCharSet != eSystenCharSet) ||
         (nFlags & INTN_COMPARE_IGNORECASE) )
    {
        String aStr1( pStr1, nLen1 );
        String aStr2( pStr2, nLen2 );
        if ( eCharSet != eSystenCharSet )
        {
            aStr1.Convert( eCharSet, eSystenCharSet );
            aStr2.Convert( eCharSet, eSystenCharSet );
        }
        if ( nFlags & INTN_COMPARE_IGNORECASE )
        {
            aStr1.ToLower();
            aStr2.ToLower();
        }
        nRet = CompareText( aStr1, aStr2, nLen1, nLen2, nil );
    }
    else
        nRet = CompareText( pStr1, pStr2, nLen1, nLen2, nil );

    if ( nRet < 0 )
        return COMPARE_LESS;
    else if ( nRet > 0 )
        return COMPARE_GREATER;
    else
        return COMPARE_EQUAL;
}

#pragma segment intnsys

// =======================================================================

USHORT ImplGetSystemLanguageCount()
{
//    return (UHSORT)CountResources( 'itl1' );

    // Noch nicht implementiert !!
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemLanguage( USHORT nIndex )
{
    // Soll die im System eingestellte Sprache ermittelt werden
    if ( nIndex == INTERNATIONAL_SYSTEM_DEFAULT )
    {
        ItlcRecord **hItlcResource;
        hItlcResource = (ItlcRecord**) GetResource( 'itlc', 0 );
        short nRetVal = (**hItlcResource).itlcRegionCode;
        ReleaseResource( (Handle) hItlcResource );
        return MacRegionToSVLang( nRetVal );
//        long nRetVal = GetScriptManagerVariable( smRegionCode );
//        return MacRegionToSVLang( (short)nRetVal );
    }
    else
    {
/*
        Handle  hItl1;
        short   nVersion;

        // NumberResource holen( koennte auch eine andere sein )
        hItl1 = GetIndResource( 'itl1', nIndex + 1 );
        // in intl1Vers steht der RegionCode
        nVersion = (**(Intl1Hndl)(hItl1)).intl1Vers;
        // leider steht der RegionCode im HighByte, deshalb shiften
        nVersion >>= 8;
        nVersion &= 0x0FF;

        ReleaseResource( (Handle) hItl1 );
        return MacRegionToSVLang( (short)nVersion );
*/
        return LANGUAGE_DONTKNOW;
    }
}

// -----------------------------------------------------------------------

LanguageType GetSystemUILanguage( USHORT nIndex )
{
    // TODO: implementation (if it differs)
    return GetSystemLanguage( nIndex );
}

// -----------------------------------------------------------------------

void ImplUpdateSystemLanguage( LanguageType eLanguage, LanguageTable* pTable )
{
    // Wenn keine Table gesetzt ist, dann Cache-Sprache zuruecksetzen
    if ( !pTable )
        return;

    // Im System eingestellte Sprachinformationen werden uebernommen
    if ( eLanguage == LANGUAGE_SYSTEM )
        pTable->SetCompareProc( ImplSystemLanguageCompare );
    else
    {
        // !!! Noch nicht implementiert
    }
}

// =======================================================================

USHORT ImplGetSystemFormatCount()
{
//    return (UHSORT)CountResources( 'itl0' );

    // Noch nicht implementiert !!
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemFormatLanguage( USHORT nIndex )
{
    // Soll die im System eingestellte Sprache ermittelt werden
    if ( nIndex == INTERNATIONAL_SYSTEM_DEFAULT )
    {
        ItlcRecord **hItlcResource;
        hItlcResource = (ItlcRecord**) GetResource( 'itlc', 0 );
        short nRetVal = (**hItlcResource).itlcRegionCode;
        ReleaseResource( (Handle) hItlcResource );
        return MacRegionToSVLang( nRetVal );
//        long nRetVal = GetScriptManagerVariable( smRegionCode );
//        return MacRegionToSVLang( (short)nRetVal );
    }
    else
    {
/*
        Handle  hItl0;
        short   nVersion;

        // NumberResource holen( koennte auch eine andere sein )
        hItl0 = GetIndResource( 'itl0', nIndex + 1 );
        // in intl0Vers steht der RegionCode
        nVersion = (**(Intl0Hndl)(hItl0)).intl0Vers;
        // leider steht der RegionCode im HighByte, deshalb shiften
        nVersion >>= 8;
        nVersion &= 0x0FF;

        ReleaseResource( (Handle) hItl0 );
        return MacRegionToSVLang( (short)nVersion );
*/
        return LANGUAGE_DONTKNOW;
    }
}

// -----------------------------------------------------------------------

void ImplUpdateSystemFormat( LanguageType eLanguage, FormatTable* pTable )
{
    if ( !pTable )
        return;

    short       nRetVal, nDateID, nNumID;
    short       nDayPos, nWeekPos, nMonPos, nYearPos, i;
    char        nSepStrs[5][5];
    Intl0Hndl   hItl0 = NULL;
    Intl1Hndl   hItl1 = NULL;

    // Im System eingestellte Landesinformationen werden uebernommen
    if ( eLanguage == LANGUAGE_SYSTEM )
    {
        // Zuerst die SystemScript Nummer ermitteln, damit dann
        // ueber die itlb Resource die IDs der Date und Num Resourcen
        ItlcRecord **hItlcResource;
        ItlbRecord **hItlbResource;
        hItlcResource = (ItlcRecord**) GetResource( 'itlc', 0 );
        nRetVal = (**hItlcResource).itlcSystem;

        hItlbResource = (ItlbRecord**) GetResource( 'itlb', nRetVal );
        if ( hItlbResource )
        {
            nNumID = (**hItlbResource).itlbNumber;
            nDateID = (**hItlbResource).itlbDate;
            ReleaseResource( (Handle) hItlbResource );
        }
        else
        {
            nNumID = (**hItlcResource).itlcRegionCode;
            nDateID = (**hItlcResource).itlcRegionCode;
        }

        ReleaseResource( (Handle) hItlcResource );

        hItl0 = (Intl0Hndl) GetResource( 'itl0', nNumID );
        hItl1 = (Intl1Hndl) GetResource( 'itl1', nDateID );
    }
    else
    {
        // !!! Noch nicht implementiert
        return;
    }

    if ( hItl0 == NULL )
        return;
    if ( hItl1 == NULL )
    {
        ReleaseResource( (Handle) hItl0 );
        return;
    }

    pTable->SetDateFormat( (DateFormat) (**hItl0).dateOrder );
    pTable->SetDateSep( (DateFormat) (**hItl0).dateSep );
    pTable->SetDateDayLeadingZero( 0!=( (**hItl0).shrtDateFmt & dayLdingZ ));
    pTable->SetDateMonthLeadingZero( 0!=( (**hItl0).shrtDateFmt & mntLdingZ ));
    pTable->SetDateCentury( 0!=( (**hItl0).shrtDateFmt & century ));

    if ( (**hItl1).lngDateFmt == 0xFF )
    {
        pTable->SetLongDateFormat( MDY );
        nDayPos = 3;
        nMonPos = 2;
        nYearPos = 4;
        nWeekPos = 1;
    }
    else if ( (**hItl1).lngDateFmt == 0 )
    {
        pTable->SetLongDateFormat( DMY );
        nDayPos = 2;
        nMonPos = 3;
        nYearPos = 4;
        nWeekPos = 1;
    }
    else
    {
        // Stimmt so nicht
        pTable->SetLongDateFormat( DMY );
        nDayPos = 2;
        nMonPos = 3;
        nYearPos = 4;
        nWeekPos = 1;
    }

    if ( (**hItl1).suppressDay == 0 )
        pTable->SetLongDateDayOfWeekFormat( DAYOFWEEK_LONG );
    else
        pTable->SetLongDateDayOfWeekFormat( DAYOFWEEK_NONE );

    strncpy( nSepStrs[0], (**hItl1).st0, 4 );
    strncpy( nSepStrs[1], (**hItl1).st1, 4 );
    strncpy( nSepStrs[2], (**hItl1).st2, 4 );
    strncpy( nSepStrs[3], (**hItl1).st3, 4 );
    strncpy( nSepStrs[4], (**hItl1).st4, 4 );

    for ( i=0; i<5; i++ )
        nSepStrs[i][4] = 0;

    pTable->SetLongDateDayOfWeekSep( nSepStrs[nWeekPos] );
    pTable->SetLongDateDaySep( nSepStrs[nDayPos] );
    pTable->SetLongDateMonthSep( nSepStrs[nMonPos] );
    pTable->SetLongDateYearSep( nSepStrs[nYearPos] );

    pTable->SetLongDateDayLeadingZero( (**hItl1).dayLeading0 == 0xFF );
    pTable->SetLongDateMonthFormat( MONTH_LONG );
    pTable->SetLongDateCentury( TRUE );

    // Zeitformat setzen( 24 oder 12 std Zyklus ) und die Strings fuer
    // AM bzw PM vorbereiten
    if ( (**hItl0).timeCycle == 0 )
    {
        pTable->SetTimeFormat( HOUR_24 );
        nSepStrs[0][0] = (**hItl0).time1Suff;
        nSepStrs[0][1] = (**hItl0).time2Suff;
        nSepStrs[0][2] = (**hItl0).time3Suff;
        nSepStrs[0][3] = (**hItl0).time4Suff;
        nSepStrs[1][0] = (**hItl0).time5Suff;
        nSepStrs[1][1] = (**hItl0).time6Suff;
        nSepStrs[1][2] = (**hItl0).time7Suff;
        nSepStrs[1][3] = (**hItl0).time8Suff;
    }
    else
    {
        pTable->SetTimeFormat( HOUR_12 );
        strncpy( nSepStrs[0], (**hItl0).mornStr, 4 );
        strncpy( nSepStrs[1], (**hItl0).eveStr, 4 );
    }

    pTable->SetTimeSep( (**hItl0).timeSep );
    pTable->SetTimeLeadingZero( 0 != ((**hItl0).timeFmt & hrLeadingZ ) );

    pTable->SetTimeAM( nSepStrs[0] );
    pTable->SetTimePM( nSepStrs[1] );

    pTable->SetNumThousandSep( (**hItl0).thousSep );
    pTable->EnableNumThousandSep( (**hItl0).thousSep != 0 );
    pTable->SetNumDecimalSep( (**hItl0).decimalPt );
    pTable->SetNumLeadingZero( 0 != ( (**hItl0).currFmt & currLeadingZ ) );

    if ( (**hItl0).currFmt & currSymLead )
        i = 0;
    else
        i = 1;
    pTable->SetCurrPositiveFormat( i );

    if ( (**hItl0).currFmt & currSymLead )
        i = 0;
    else
        i = 4;
    if ( (**hItl0).currFmt & currNegSym )
        i += 1;
    pTable->SetCurrNegativeFormat( i );

    nSepStrs[0][0] = (**hItl0).currSym1;
    nSepStrs[0][1] = (**hItl0).currSym2;
    nSepStrs[0][2] = (**hItl0).currSym3;
    nSepStrs[0][3] = 0;
    pTable->SetCurrSymbol( nSepStrs[0] );

    pTable->SetListSep( (**hItl0).listSep );

    ReleaseResource( (Handle) hItl0 );
    ReleaseResource( (Handle) hItl1 );
}
