/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: VCLView.m,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:44:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#import <VCLView.h>
#import <VCLWindow.h>

#define _SV_VCLVIEW_M

// -------------
// - VCLView -
// -------------

@implementation VCLView

- (void)drawRect: (NSRect)aRect
{
}

- init
{
	qdRgnResized=0;
	return self;
}

- (void)lockFocus
{
	[super lockFocus];
	
	// [ed] 12/15/01 If we haven't done so yet, adjust the visRgn and clipRgn of the port
	// to match the view.  OS 10.1 changed the default behaviour of the clipping of
	// NSQDViews and they now require initialization.
	
	if(!qdRgnResized)
	{
		RgnHandle tempRgn;
		Rect r;
		
		r.left=0;
		r.top=0;
		r.right=[self bounds].size.width;
		r.bottom=[self bounds].size.height;
		
		SetPort([self qdPort]);
		
		tempRgn=NewRgn();
		RectRgn(tempRgn, &r);
		
		ClipRect(&r);
		SetPortVisibleRegion([self qdPort], tempRgn);
		PortChanged([self qdPort]);
		
		DisposeRgn(tempRgn);
		qdRgnResized=1;
	}
}

- (MacOSBOOL)isOpaque
{
	// Set background to white to avoid flickering when timer paints
	return YES;
}

@end

// -----------------------
// - C wrapper functions -
// -----------------------

