/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salstype.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:23:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALSTYPE_HXX
#define _SV_SALSTYPE_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

// -----------------
// - Sound defines -
// -----------------

#define SOUND_PLAYALL			(0xFFFFFFFFUL)

// -----------------
// - State defines -
// -----------------

#define SOUND_STATE_UNLOADED	(0x00000000UL)
#define SOUND_STATE_INVALID		(0x00000001UL)
#define	SOUND_STATE_VALID		(0x00000002UL)

// ---------------------
// - SoundNotification -
// ---------------------

enum SoundNotification 
{
	SOUND_NOTIFY_NOTHING, 
	SOUND_NOTIFY_SUCCESS,
	SOUND_NOTIFY_ABORTED,
	SOUND_NOTIFY_ERROR 
};

// ---------------
// - SoundErrors -
// ---------------

#define SOUNDERR_SUCCESS                (0x00000000UL)
#define SOUNDERR_GENERAL_ERROR          (0x00000001UL)
#define SOUNDERR_CANNOT_LOAD_DRIVER     (0x00000003UL)
#define SOUNDERR_DEVICE_LOCKED          (0x00000004UL)
#define SOUNDERR_SOUND_NOT_FOUND        (0x00000005UL)
#define SOUNDERR_HARDWARE_ERROR         (0x00000006UL)
#define SOUNDERR_OUT_OF_MEMORY          (0x00000007UL)
#define SOUNDERR_UNSUPPORTED_FUNCTION   (0x00000008UL)
#define SOUNDERR_DEVICE_NOT_FOUND       (0x00000009UL)
#define SOUNDERR_DEVICE_NOT_READY       (0x0000000aUL)
#define SOUNDERR_CANNOT_READ_SOUND      (0x0000000bUL)
#define SOUNDERR_INVALID_FILE           (0x0000000cUL)

// ------------------
// - Sound-Callback	-
// ------------------

typedef void (*SALSOUNDPROC)( void* pInst, SoundNotification eNotification, ULONG nError );

#endif // _SV_SALSTYPE_HXX
