/*
 * Debug.java
 *
 * Created on 7. Juli 2003, 16:35
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.io.OutputStream;
import java.io.PrintWriter;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.*;
import com.sun.star.lang.*;

// to get informations about interfaces and their methods
import com.sun.star.reflection.*;
import com.sun.star.uno.Type;
import com.sun.star.uno.Uik;
import com.sun.star.uno.UnoRuntime;

// base interface
import com.sun.star.uno.XInterface;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class Debug {
	// class of interfaceIDs in idl

	/**
	 * Prints the open XWindows information.
	 *
	 * @param xwins DOCUMENT ME!
	 */
	public static void printXWindows(XWindow[] xwins) {
		XWindow[] xWindows = xwins;
		Helper.log("***********  XWindows *****************");

		for (int i = 0; i < xWindows.length; i++) {
			XWindow xWindow = xWindows[i];

			XAccessible xRootTemp = AccessibilityTools.getAccessibleObject(xWindow);

			if (xRootTemp != null) {
				XAccessibleContext ac = xRootTemp.getAccessibleContext();

				if (ac == null) {
					continue;
				}

				while (ac.getAccessibleIndexInParent() > -1) {
					ac = ac.getAccessibleParent().getAccessibleContext();
				}

				Helper.log("i = " + i + " ### role : " + ac.getAccessibleRole() + " ###  Name : " + ac.getAccessibleName() + " ###  index : " + ac.getAccessibleIndexInParent());
			}
		}

		Helper.log("*******************************");
	}

	/**
	 * Prints information about the supported Interfaces for a given xTarget
	 *
	 * @param xTarget : com.sun.star.uno.XInterface (The given TestTarget)
	 */
	public static void printInterfaces(XInterface xTarget) {
		XTypeProvider xTypeProvider = (XTypeProvider) UnoRuntime.queryInterface(XTypeProvider.class, xTarget);

		if (xTypeProvider != null) {
			Type[] types = xTypeProvider.getTypes();

			if (null != types) {
				int nLen = types.length;

				for (int i = 0; i < nLen; i++) {
					System.out.println(types[i].getTypeName());
					printInterfaceInfo(types[i]);
				}
			}
		}
	}

	/**
	 * Prints information about a given Interfaces
	 *
	 * @param aType : com.sun.star.uno.Type (Type of the given Interface)
	 */
	static void printInterfaceInfo(Type aType) {
		/*try {
		    int anz = ((TypeDescription)aType.getTypeDescription()).getMethodDescriptions().length;
		    for (int i=0;i<anz;i++) {
		        System.out.print("\t"+aType.getTypeDescription().getMethodDescriptions()[i].getReturnSignature().getTypeName()+":");
		        System.out.println("\t"+aType.getTypeDescription().getMethodDescriptions()[i].getName());
		    }
		}
		catch (Exception ex) {
		    System.out.println("Exception occured while printing InterfaceInfo");
		    ex.printStackTrace();
		}*/
	}

	/**
	 * Prints String Array to Standard out
	 *
	 * @param entries : java.lang.String[] (The Array to be printed)
	 */
	public static void printArray(String[] entries) {
		for (int i = 0; i < entries.length; i++) {
			System.out.println(entries[i]);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param PS DOCUMENT ME!
	 * @param name DOCUMENT ME!
	 */
	public static void printPropertyInfo(XPropertySet PS, String name) {
		printPropertyInfo(PS, name, new PrintWriter(System.out));
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param PS DOCUMENT ME!
	 * @param name DOCUMENT ME!
	 * @param out DOCUMENT ME!
	 */
	public static void printPropertyInfo(XPropertySet PS, String name, PrintWriter out) {
		try {
			XPropertySetInfo PSI = PS.getPropertySetInfo();
			Property[] props = PSI.getProperties();
			Property prop = PSI.getPropertyByName(name);
			out.println("Property name is " + prop.Name);
			out.println("Property handle is " + prop.Handle);
			out.println("Property type is " + prop.Type.getTypeName());
			out.println("Property current value is " + PS.getPropertyValue(name));
			out.println("Attributes :");

			short attr = prop.Attributes;

			if ((attr & PropertyAttribute.BOUND) != 0) {
				out.println("\t-BOUND");
			}

			if ((attr & PropertyAttribute.CONSTRAINED) != 0) {
				out.println("\t-CONSTRAINED");
			}

			if ((attr & PropertyAttribute.MAYBEAMBIGUOUS) != 0) {
				out.println("\t-MAYBEAMBIGUOUS");
			}

			if ((attr & PropertyAttribute.MAYBEDEFAULT) != 0) {
				out.println("\t-MAYBEDEFAULT");
			}

			if ((attr & PropertyAttribute.MAYBEVOID) != 0) {
				out.println("\t-MAYBEVOID");
			}

			if ((attr & PropertyAttribute.READONLY) != 0) {
				out.println("\t-READONLY");
			}

			if ((attr & PropertyAttribute.REMOVEABLE) != 0) {
				out.println("\t-REMOVEABLE");
			}

			if ((attr & PropertyAttribute.TRANSIENT) != 0) {
				out.println("\t-TRANSIENT");
			}
		} catch (com.sun.star.uno.Exception e) {
			out.println("Exception!!!!");
			e.printStackTrace(out);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param ps DOCUMENT ME!
	 */
	public static void printPropertiesNames(XPropertySet ps) {
		XPropertySetInfo psi = ps.getPropertySetInfo();
		Property[] props = psi.getProperties();

		for (int i = 0; i < props.length; i++) {
			System.out.println(i + ".  " + props[i].Name);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param aObject DOCUMENT ME!
	 */
	public static void getSuppServices(Object aObject) {
		XServiceInfo xSI = (XServiceInfo) UnoRuntime.queryInterface(XServiceInfo.class, aObject);
		printArray(xSI.getSupportedServiceNames());
		System.out.println("Therein not Supported Service");

		String str = "none";

		for (int i = 0; i < xSI.getSupportedServiceNames().length; i++) {
			if (!xSI.supportsService(xSI.getSupportedServiceNames()[i])) {
				System.out.println(xSI.getSupportedServiceNames()[i]);
				str = "";
			}
		}

		System.out.println(str);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param xTarget DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static String getImplID(XInterface xTarget) {
		String str = "";
		XTypeProvider xTypeProvider = (XTypeProvider) UnoRuntime.queryInterface(XTypeProvider.class, xTarget);

		if (xTypeProvider != null) {
			byte[] id = xTypeProvider.getImplementationId();
			str = "ImplementationID: ";

			for (int i = 0; i < id.length; i++) {
				Byte b = new Byte(id[i]);
				str += b.intValue();
			}
		} else {
			str = "No Implementation ID available";
		}

		return str;
	}
}

// finish class dbg
