/**
 * Title:        <p>
 * Description:  <p>
 * Copyright:    Copyright (c) <p>
 * Company:      <p>
 * @author
 * @version 1.0
 */

package com.sun.star.help;

import java.io.*;

import com.sun.star.uno.*;
import com.sun.star.io.*;
import com.sun.star.beans.*;
import com.sun.star.ucb.*;
import com.sun.star.sdbc.*;
import com.sun.star.util.*;
import com.sun.star.container.*;
import com.sun.xmlsearch.xml.qe.QueryResults;

public class HelpContent implements XContent, XCommandProcessor {
	private int m_nFreeCommandIdentifier;
	private final HelpContentIdentifier m_xIdentifier;
	private final HelpURLParameter m_xParameter;
	private final HelpProvider m_xProvider;
	private HelpOutputStream m_xOutputStream;

	public HelpContent(
		HelpProvider xProvider,
		HelpContentIdentifier xIdentifier) {
		m_xIdentifier = xIdentifier;
		m_xProvider = xProvider;
		m_xParameter = m_xIdentifier.getParameter();
	}

	public XContentIdentifier getIdentifier()
		throws com.sun.star.uno.RuntimeException {
		return m_xIdentifier;
	}

	public String getContentType() throws com.sun.star.uno.RuntimeException {
		return "application/vnd.sun.star.xmlhelp";
	}

	public void addContentEventListener(XContentEventListener p0)
		throws com.sun.star.uno.RuntimeException {
		return; // Never changes properties
	}

	public void removeContentEventListener(XContentEventListener p0)
		throws com.sun.star.uno.RuntimeException {
		return; // Never changes properties
	}

	// XCommandProcessor

	public final synchronized int createCommandIdentifier()
		throws com.sun.star.uno.RuntimeException {
		return m_nFreeCommandIdentifier++;
	}

	private final class FactoryForQuery implements HelpResultSetFactory {
		HelpProvider m_xProvider;
		QueryResults m_xHitData;
		Property[] m_xProperty;
		HelpURLParameter m_xParameter;

		FactoryForQuery(
			HelpProvider xProvider,
			QueryResults xHitData,
			Property[] xProperty,
			HelpURLParameter xParameter) {
			m_xProvider = xProvider;
			m_xHitData = xHitData;
			m_xProperty = xProperty;
			m_xParameter = xParameter;
		}

		public HelpResultSetBase createResultSet() {
			return new HelpResultSet(
				m_xProvider,
				m_xHitData,
				m_xProperty,
				m_xParameter);
		}
	}

	private final class FactoryForRoot implements HelpResultSetFactory {
		HelpProvider m_xProvider;
		String[] m_xHitData;
		Property[] m_xProperty;
		HelpURLParameter m_xParameter;

		public FactoryForRoot(
			HelpProvider xProvider,
			String[] xHitData,
			Property[] xProperty,
			HelpURLParameter xParameter) {
			m_xProvider = xProvider;
			m_xHitData = xHitData;
			m_xProperty = xProperty;
			m_xParameter = xParameter;
		}

		public HelpResultSetBase createResultSet() {
			return new HelpResultSetForRoot(
				m_xProvider,
				m_xHitData,
				m_xProperty,
				m_xParameter);
		}
	}

	public final Object execute(
		Command aCommand,
		int CommandId,
		XCommandEnvironment Environment)
		throws
			com.sun.star.uno.Exception,
			com.sun.star.uno.RuntimeException,
			com.sun.star.ucb.CommandAbortedException {
		Object result = null;

		if (aCommand.Name.equals("open")) {
			OpenCommandArgument2 arg = (OpenCommandArgument2) aCommand.Argument;

			XOutputStream xoutputStream =
				(XOutputStream) UnoRuntime.queryInterface(
					XOutputStream.class,
					arg.Sink);
			if (xoutputStream != null) {
				if (m_xOutputStream == null) {
					m_xOutputStream = new HelpOutputStream();

					if (m_xParameter.isRoot())
						getPicture(
							HelpDatabases.getCssSheet(),
							m_xOutputStream);
					else if (m_xParameter.isPicture())
						getPicture(
							m_xParameter.getInputFromJarFile(),
							m_xOutputStream);
					else if (m_xParameter.isActive()) // a helptext
						m_xOutputStream.setBigBuffer(
							m_xParameter.getByteArrayText());
					else
						m_xProvider.writeHtmlStream(
							m_xParameter,
							m_xOutputStream);
				}
				m_xOutputStream.writeToXOutputStream(xoutputStream);
			}

			XActiveDataSink xactiveDataSink =
				(XActiveDataSink) UnoRuntime.queryInterface(
					XActiveDataSink.class,
					arg.Sink);
			if (xactiveDataSink != null) {
				if (m_xOutputStream == null) {
					m_xOutputStream = new HelpOutputStream();

					if (m_xParameter.isRoot())
						getPicture(
							HelpDatabases.getCssSheet(),
							m_xOutputStream);
					else if (m_xParameter.isPicture())
						getPicture(
							m_xParameter.getInputFromJarFile(),
							m_xOutputStream);
					else if (m_xParameter.isActive()) // This is a Helptext
						m_xOutputStream.setBigBuffer(
							m_xParameter.getByteArrayText());
					else
						m_xProvider.writeHtmlStream(
							m_xParameter,
							m_xOutputStream);
				}
				xactiveDataSink.setInputStream(
					m_xOutputStream.getNewInputStream());
			}

			// Now test, whether we have a query?

			if (m_xParameter.isRoot()) {
				String[] list =
					HelpDatabases.getModuleList(m_xParameter.get_language());
				if (list != null)
					result =
						new HelpDynamicResultSet(
							new FactoryForRoot(
								m_xProvider,
								list,
								arg.Properties,
								m_xParameter),
							m_xProvider.getXMultiServiceFactory());
			} else if (m_xParameter.isQuery()) {
				QueryResults queryResults =
					m_xProvider.queryResultSet(m_xParameter);
				if (queryResults != null)
					result =
						new HelpDynamicResultSet(
							new FactoryForQuery(
								m_xProvider,
								queryResults,
								arg.Properties,
								m_xParameter),
							m_xProvider.getXMultiServiceFactory());
			}
		} else if (aCommand.Name.equals("getCommandInfo")) {
			result = getCommandInfo();
		} else if (aCommand.Name.equals("getPropertySetInfo")) {
			result = getPropertySetInfo();
		} else if (aCommand.Name.equals("getPropertyValues")) {
			Property props[] = (Property[]) aCommand.Argument;
			result = getPropertyValues(props);
		} else if (aCommand.Name.equals("setPropertyValues")) {
			// All properties are readonly, so nothing need to be done
		} else {
			throw new CommandAbortedException();
		}

		return result;
	}

	public final void abort(int CommandId)
		throws com.sun.star.uno.RuntimeException {
		return; // Nothing to abort
	}

	// getCommandInfo()

	static private final class XCommandInfoImpl implements XCommandInfo {
		XCommandInfoImpl() {
		}

		public CommandInfo getCommandInfoByHandle(int p0)
			throws UnsupportedCommandException, com.sun.star.uno.RuntimeException {
			throw new UnsupportedCommandException();
		}

		public CommandInfo getCommandInfoByName(String p0)
			throws UnsupportedCommandException, com.sun.star.uno.RuntimeException {
			//       		try
			//         		{
			if (p0.equals("getCommandInfo"))
				return new CommandInfo(p0, -1, new Type(TypeClass.VOID));
			else if (p0.equals("getPropertySetInfo"))
				return new CommandInfo(p0, -1, new Type(TypeClass.VOID));
			else if (p0.equals("getPropertyValues"))
				return new CommandInfo(
					p0,
					-1,
					new Type((new Property[0]).getClass()));
			else if (p0.equals("setPropertyValues"))
				return new CommandInfo(
					p0,
					-1,
					new Type((new PropertyValue[0]).getClass()));
			else if (p0.equals("open"))
				return new CommandInfo(
					p0,
					-1,
					new Type((new OpenCommandArgument2()).getClass()));
			else
				throw new UnsupportedCommandException();
			//          	}
			//           	catch( com.sun.star.uno.Exception e )
			//            	{
			//             		//
			//             	}
			// return new CommandInfo();
		}

		public CommandInfo[] getCommands()
			throws com.sun.star.uno.RuntimeException {
			CommandInfo props[] = new CommandInfo[5];
			try {
				props[0] = getCommandInfoByName("getCommandInfo");
				props[1] = getCommandInfoByName("getPropertySetInfo");
				props[2] = getCommandInfoByName("getPropertyValues");
				props[3] = getCommandInfoByName("setPropertyValues");
				props[4] = getCommandInfoByName("open");
			} catch (UnsupportedCommandException e) {
				//
			}
			return props;
		}

		public boolean hasCommandByHandle(int p0)
			throws com.sun.star.uno.RuntimeException {
			return false;
		}

		public boolean hasCommandByName(String p0)
			throws com.sun.star.uno.RuntimeException {
			if (p0.equals("getCommandInfo"))
				return true;
			else if (p0.equals("getPropertySetInfo"))
				return true;
			else if (p0.equals("getPropertyValues"))
				return true;
			else if (p0.equals("setPropertyValues"))
				return true;
			else if (p0.equals("open"))
				return true;
			else
				return false;
		}
	}

	private XCommandInfo getCommandInfo() {
		return new XCommandInfoImpl();
	}

	// getPropertySetInfo()

	static private final class XPropertySetInfoImpl
		implements XPropertySetInfo {
		boolean m_bWithMediaType;
		boolean m_bModule;
		boolean m_bFile;

		public XPropertySetInfoImpl(
			boolean WithMediaType,
			boolean bModule,
			boolean bFile) {
			m_bWithMediaType = WithMediaType;
			m_bModule = bModule;
			m_bFile = bFile;
		}

		public Property[] getProperties()
			throws com.sun.star.uno.RuntimeException {
			int num = m_bWithMediaType ? 5 : 4;
			if (m_bModule)
				num += 5;
			if (m_bFile)
				num++;

			Property props[] = new Property[num];
			try {
				int i = 0;
				props[i++] = getPropertyByName("Title");
				props[i++] = getPropertyByName("IsDocument");
				props[i++] = getPropertyByName("IsFolder");
				props[i++] = getPropertyByName("ContentType");
				if (m_bWithMediaType)
					props[i++] = getPropertyByName("MediaType");
				if (m_bModule) {
					props[i++] = getPropertyByName("KeywordList");
					props[i++] = getPropertyByName("KeywordRef");
					props[i++] = getPropertyByName("KeywordTitleForRef");
					props[i++] = getPropertyByName("KeywordAnchorForRef");
					props[i++] = getPropertyByName("SearchScopes");
				}
				if (m_bFile)
					props[i++] = getPropertyByName("AnchorName");
			} catch (UnknownPropertyException e) {
				//
			}
			return props;
		}

		public Property getPropertyByName(String p0)
			throws UnknownPropertyException, com.sun.star.uno.RuntimeException {
			try {
				if (p0.equals("Title"))
					return new Property(
						p0,
						-1,
						new Type(TypeClass.STRING),
						PropertyAttribute.READONLY);
				else if (p0.equals("IsDocument") || p0.equals("IsFolder"))
					return new Property(
						p0,
						-1,
						new Type(TypeClass.BOOLEAN),
						PropertyAttribute.READONLY);
				else if (p0.equals("ContentType"))
					return new Property(
						p0,
						-1,
						new Type(TypeClass.STRING),
						PropertyAttribute.READONLY);
				else if (p0.equals("MediaType") && m_bWithMediaType)
					return new Property(
						p0,
						-1,
						new Type(TypeClass.STRING),
						PropertyAttribute.READONLY);
				else if (p0.equals("KeywordList") && m_bModule)
					return new Property(
						p0,
						-1,
						new Type(Class.forName("[Ljava.lang.String;")),
						PropertyAttribute.READONLY);
				else if (p0.equals("KeywordRef") && m_bModule)
					return new Property(
						p0,
						-1,
						new Type(Class.forName("[[Ljava.lang.String;")),
						PropertyAttribute.READONLY);
				else if (p0.equals("KeywordAnchorForRef") && m_bModule)
					return new Property(
						p0,
						-1,
						new Type(Class.forName("[[Ljava.lang.String;")),
						PropertyAttribute.READONLY);
				else if (p0.equals("KeywordTitleForRef") && m_bModule)
					return new Property(
						p0,
						-1,
						new Type(Class.forName("[[Ljava.lang.String;")),
						PropertyAttribute.READONLY);
				else if (p0.equals("SearchScopes") && m_bModule)
					return new Property(
						p0,
						-1,
						new Type(Class.forName("[Ljava.lang.String;")),
						PropertyAttribute.READONLY);
				else if (p0.equals("AnchorName") && m_bFile)
					return new Property(
						p0,
						-1,
						new Type(TypeClass.STRING),
						PropertyAttribute.READONLY);
				else
					throw new UnknownPropertyException();
			}
			//           	catch( com.sun.star.uno.Exception e )
			//            	{
			//  				// Should never happen
			//             		System.err.println( e.getMessage() );
			//  				throw new com.sun.star.uno.RuntimeException( e.getMessage() );
			//             	}
			catch (java.lang.Exception e) {
				System.err.println(e.getMessage());
				throw new com.sun.star.uno.RuntimeException(e.getMessage());
			}
		}

		public boolean hasPropertyByName(String p0)
			throws com.sun.star.uno.RuntimeException {
			if (p0.equals("Title"))
				return true;
			else if (p0.equals("IsFolder"))
				return true;
			else if (p0.equals("IsDocument"))
				return true;
			else if (p0.equals("ContentType"))
				return true;
			else if (p0.equals("MediaType") && m_bWithMediaType)
				return true;
			else if (p0.equals("KeywordList") && m_bModule)
				return true;
			else if (p0.equals("KeywordRef") && m_bModule)
				return true;
			else if (p0.equals("KeywordAnchorForRef") && m_bModule)
				return true;
			else if (p0.equals("KeywordTitleForRef") && m_bModule)
				return true;
			else if (p0.equals("SearchScopes") && m_bModule)
				return true;
			else if (p0.equals("AnchorName") && m_bFile)
				return true;
			else
				return false;
		}
	}

	private XPropertySetInfo getPropertySetInfo() {
		return new XPropertySetInfoImpl(
			m_xParameter.isFile() || m_xParameter.isRoot(),
			m_xParameter.isModule(),
			m_xParameter.isFile());
	}

	static final private class XRowImpl implements XRow {
		private boolean m_bWasNull;
		private Object[] V;

		public XRowImpl(Object val[]) {
			V = val;
		}

		public synchronized XArray getArray(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			try {
				XArray obj;
				m_bWasNull = (obj = (XArray) V[--p0]) == null ? true : false;
				return obj;
			} catch (ClassCastException e) {
				return null;
			}
		}

		public synchronized XInputStream getBinaryStream(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			XInputStream obj;
			m_bWasNull = (obj = (XInputStream) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized XBlob getBlob(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			XBlob obj;
			m_bWasNull = (obj = (XBlob) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized boolean getBoolean(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Boolean obj;
			m_bWasNull = (obj = (Boolean) V[--p0]) == null ? true : false;
			return obj.booleanValue();
		}

		public synchronized byte getByte(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Byte obj;
			m_bWasNull = (obj = (Byte) V[--p0]) == null ? true : false;
			return obj.byteValue();
		}

		public synchronized byte[] getBytes(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			byte obj[];
			m_bWasNull = (obj = (byte[]) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized XInputStream getCharacterStream(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			XInputStream obj;
			m_bWasNull = (obj = (XInputStream) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized XClob getClob(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			XClob obj;
			m_bWasNull = (obj = (XClob) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized Date getDate(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Date obj;
			m_bWasNull = (obj = (Date) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized double getDouble(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Double obj;
			m_bWasNull = (obj = (Double) V[--p0]) == null ? true : false;
			return obj.doubleValue();
		}

		public synchronized float getFloat(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Float obj;
			m_bWasNull = (obj = (Float) V[--p0]) == null ? true : false;
			return obj.floatValue();
		}

		public synchronized int getInt(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Integer obj;
			m_bWasNull = (obj = (Integer) V[--p0]) == null ? true : false;
			return obj.intValue();
		}

		public synchronized long getLong(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Long obj;
			m_bWasNull = (obj = (Long) V[--p0]) == null ? true : false;
			return obj.longValue();
		}

		public synchronized Object getObject(int p0, XNameAccess p1)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Object obj = V[--p0];
			m_bWasNull = obj == null;
			return obj;
		}

		public synchronized XRef getRef(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			return null;
		}

		public synchronized short getShort(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Short obj;
			m_bWasNull = (obj = (Short) V[--p0]) == null ? true : false;
			return obj.shortValue();
		}

		public synchronized String getString(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			String obj;
			m_bWasNull = (obj = (String) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized Time getTime(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			Time obj;
			m_bWasNull = (obj = (Time) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized DateTime getTimestamp(int p0)
			throws SQLException, com.sun.star.uno.RuntimeException {
			DateTime obj;
			m_bWasNull = (obj = (DateTime) V[--p0]) == null ? true : false;
			return obj;
		}

		public synchronized boolean wasNull()
			throws SQLException, com.sun.star.uno.RuntimeException {
			return m_bWasNull;
		}
	}

	private XRow getPropertyValues(Property props[]) {
		String name;
		Object[] val = new Object[props.length];

		for (int i = 0; i < props.length; ++i) {
			name = props[i].Name;

			if ("Title".equals(name))
				val[i] = m_xParameter.get_title();

			else if ("IsFolder".equals(name))
				val[i] =
					new Boolean(
						!m_xParameter.isFile() || m_xParameter.isRoot());
			else if ("IsDocument".equals(name))
				val[i] =
					new Boolean(m_xParameter.isFile() || m_xParameter.isRoot());

			else if ("ContentType".equals(name))
				val[i] = new String("application/vnd.sun.star.help");

			else if ("MediaType".equals(name) && m_xParameter.isPicture())
				val[i] = new String("image/gif");
			else if ("MediaType".equals(name) && m_xParameter.isFile())
				val[i] = new String("text/html");
			else if ("MediaType".equals(name) && m_xParameter.isRoot())
				val[i] = new String("text/css");

			else if ("KeywordList".equals(name) && m_xParameter.isModule()) {
				HelpDatabases.KeywordInfo info =
					HelpDatabases.getKeyword(
						m_xParameter.get_module(),
						m_xParameter.get_language());

				val[i] = info.getKeywordList();
			} else if ("KeywordRef".equals(name) && m_xParameter.isModule()) {
				HelpDatabases.KeywordInfo info =
					HelpDatabases.getKeyword(
						m_xParameter.get_module(),
						m_xParameter.get_language());

				val[i] = info.getIdList();
			} else if (
				"KeywordAnchorForRef".equals(name)
					&& m_xParameter.isModule()) {
				HelpDatabases.KeywordInfo info =
					HelpDatabases.getKeyword(
						m_xParameter.get_module(),
						m_xParameter.get_language());

				val[i] = info.getAnchorList();
			} else if (
				"KeywordTitleForRef".equals(name) && m_xParameter.isModule()) {
				HelpDatabases.KeywordInfo info =
					HelpDatabases.getKeyword(
						m_xParameter.get_module(),
						m_xParameter.get_language());

				val[i] = info.getTitleList();
			} else if (
				"SearchScopes".equals(name) && m_xParameter.isModule()) {
				String[] tmp = new String[2];
				tmp[0] = "Heading";
				tmp[1] = "FullText";
				val[i] = tmp;
			} else if ("AnchorName".equals(name) && m_xParameter.isFile())
				val[i] = m_xParameter.get_tag();
			else
				val[i] = null;
		}

		XRowImpl ret = new XRowImpl(val);

		return ret;
	}

	private final void getPicture(
		InputStream input,
		HelpOutputStream m_xOutputStream) {

		int size = 0;
		int arrint;
		byte[] temp;
		byte[] array = new byte[256];
		byte[] arr = new byte[256];

		try {
			while ((arrint = input.read(arr)) != -1) {
				// Don't reallocate buffer if not necessary
				size += arrint;

				if (arrint == 256) {
					temp = arr;
					arr = array;
					array = temp;
				} else {
					array = new byte[arrint];
					for (int i = 0; i < arrint; ++i)
						array[i] = arr[i];
				}
				m_xOutputStream.write(array);
			}
			System.out.println(size);
		} catch (java.io.IOException e) {
			System.out.println(e.getMessage());
		}
	}
}
