/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_fontsubs.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:19:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifdef PRECOMPILED
//STRIP001 #include "svxpch.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _SHL_HXX
//STRIP001 #include <tools/shl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CTRLTOOL_HXX //autogen
//STRIP001 #include <svtools/ctrltool.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_SVAPP_HXX //autogen
//STRIP001 #include <vcl/svapp.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_WRKWIN_HXX //autogen
//STRIP001 #include <vcl/wrkwin.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFF_APP_HXX //autogen
//STRIP001 #include "app.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _OFA_FONTSUBSTCONFIG_HXX
//STRIP001 #include <fontsubstconfig.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVTOOLS_SOURCEVIEWCONFIG_HXX
//STRIP001 #include <svtools/sourceviewconfig.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "resid.hxx"
//STRIP001 #include "fontsubs.hrc"
//STRIP001 #include "fontsubs.hxx"
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /* 	TabPage Fontersetzung                                            */
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 #define CBCOL_FIRST		0
//STRIP001 #define CBCOL_SECOND	1
//STRIP001 #define CBCOL_BOTH		2
//STRIP001 
//STRIP001 SvxFontSubstTabPage::SvxFontSubstTabPage( Window* pParent,
//STRIP001 								const SfxItemSet& rSet ) :
//STRIP001 	SfxTabPage(pParent, OffResId(RID_SVX_FONT_SUBSTITUTION), rSet),
//STRIP001 	aUseTableCB 		(this,	ResId(CB_USETABLE)),
//STRIP001 	aCheckLB			(this,	ResId(CLB_SUBSTITUTES)),
//STRIP001 	aFont1FT			(this,	ResId(FT_FONT1)),
//STRIP001 	aFont1CB			(this,	ResId(CB_FONT1)),
//STRIP001 	aFont2FT			(this,	ResId(FT_FONT2)),
//STRIP001 	aFont2CB			(this,	ResId(CB_FONT2)),
//STRIP001 	aNewDelTBX			(this,	ResId(TBX_SUBSTNEWDEL)),
//STRIP001 
//STRIP001     aSourceViewFontsFL (this,  ResId(FL_SOURCEVIEW  )),
//STRIP001     aFontNameFT        (this,  ResId(FT_FONTNAME    )),
//STRIP001     aFontNameLB        (this,  ResId(LB_FONTNAME    )),
//STRIP001     aNonPropFontsOnlyCB(this,  ResId(CB_NONPROP     )),
//STRIP001     aFontHeightFT      (this,  ResId(FT_FONTHEIGHT  )),
//STRIP001     aFontHeightLB      (this,  ResId(LB_FONTHEIGHT  )),
//STRIP001 
//STRIP001 	aImageList			(ResId(IL_ICON)),
//STRIP001 
//STRIP001 	sHeader1			(ResId( STR_HEADER1		)),
//STRIP001 	sHeader2			(ResId( STR_HEADER2		)),
//STRIP001 	sHeader3			(ResId( STR_HEADER3		)),
//STRIP001 	sHeader4			(ResId( STR_HEADER4		)),
//STRIP001 	sFontGroup			("FontSubstitution"),
//STRIP001     sAutomatic          (ResId( STR_AUTOMATIC  )),
//STRIP001 
//STRIP001 	aChkunBmp			(ResId(	CHKBUT_UNCHECKED)),
//STRIP001 	aChkchBmp			(ResId(	CHKBUT_CHECKED	)),
//STRIP001 	aChkchhiBmp			(ResId(	CHKBUT_HICHECKED)),
//STRIP001 	aChkunhiBmp			(ResId(	CHKBUT_HIUNCHECKED)),
//STRIP001 	aChktriBmp			(ResId(	CHKBUT_TRISTATE	)),
//STRIP001 	aChktrihiBmp		(ResId(	CHKBUT_HITRISTATE)),
//STRIP001 	pCheckButtonData(0),
//STRIP001     pConfig(new OfaFontSubstConfig),
//STRIP001     pSourceViewConfig(new svt::SourceViewConfig)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aTextColor = aCheckLB.GetTextColor();
//STRIP001 
//STRIP001 	for(USHORT k = 0; k < aNewDelTBX.GetItemCount(); k++)
//STRIP001 		aNewDelTBX.SetItemImage(aNewDelTBX.GetItemId(k),
//STRIP001 			aImageList.GetImage(aNewDelTBX.GetItemId(k)));
//STRIP001 
//STRIP001 	aNewDelTBX.SetSizePixel( aNewDelTBX.CalcWindowSizePixel() );
//STRIP001 
//STRIP001 	long nDelta = ( aFont1CB.GetSizePixel().Height() -
//STRIP001 					aNewDelTBX.GetSizePixel().Height() ) / 2;
//STRIP001 	Point aNewPnt = aNewDelTBX.GetPosPixel();
//STRIP001 	aNewPnt.Y() += nDelta;
//STRIP001 	aNewDelTBX.SetPosPixel( aNewPnt );
//STRIP001 
//STRIP001 	aCheckLB.SetHelpId(HID_OFA_FONT_SUBST_CLB);
//STRIP001 	aCheckLB.SetWindowBits(aCheckLB.GetStyle()|WB_HSCROLL|WB_VSCROLL);
//STRIP001 	aCheckLB.SetSelectionMode(MULTIPLE_SELECTION);
//STRIP001 	aCheckLB.SortByCol(2);
//STRIP001 
//STRIP001 	Link aLink(LINK(this, SvxFontSubstTabPage, SelectHdl));
//STRIP001 
//STRIP001 	aCheckLB.SetSelectHdl(aLink);
//STRIP001 	aUseTableCB.SetClickHdl(aLink);
//STRIP001 	aFont1CB.SetSelectHdl(aLink);
//STRIP001 	aFont1CB.SetModifyHdl(aLink);
//STRIP001 	aFont2CB.SetSelectHdl(aLink);
//STRIP001 	aFont2CB.SetModifyHdl(aLink);
//STRIP001 	aNewDelTBX.SetClickHdl(aLink);
//STRIP001 
//STRIP001     aNonPropFontsOnlyCB.SetClickHdl(LINK(this, SvxFontSubstTabPage, NonPropFontsHdl));
//STRIP001     static long aStaticTabs[]=
//STRIP001 	{
//STRIP001 		5, 0, 30, 60, 154, 248
//STRIP001 	};
//STRIP001 
//STRIP001 	aCheckLB.SvxSimpleTable::SetTabs(aStaticTabs);
//STRIP001 	String sHeader(sHeader1);
//STRIP001 	String sTab(String::CreateFromAscii("\t"));
//STRIP001 	String sTabSpace(String::CreateFromAscii("\t "));
//STRIP001 	sHeader += sTab;
//STRIP001 	sHeader += sHeader2;
//STRIP001 	sHeader += sTabSpace;
//STRIP001 	sHeader += sHeader3;
//STRIP001 	sHeader += sTabSpace;
//STRIP001 	sHeader += sHeader4;
//STRIP001 	sHeader += sTabSpace;
//STRIP001 	aCheckLB.InsertHeaderEntry(sHeader);
//STRIP001 
//STRIP001 	HeaderBar* pBar = aCheckLB.GetTheHeaderBar();
//STRIP001 
//STRIP001 	HeaderBarItemBits nBits = pBar->GetItemBits(1) | HIB_FIXEDPOS | HIB_FIXED;
//STRIP001 	nBits &= ~HIB_CLICKABLE;
//STRIP001 	pBar->SetItemBits(1, nBits);
//STRIP001 	pBar->SetItemBits(2, nBits);
//STRIP001 
//STRIP001     USHORT nHeight;
//STRIP001     for(nHeight = 6; nHeight <= 16; nHeight++)
//STRIP001         aFontHeightLB.InsertEntry(String::CreateFromInt32(nHeight));
//STRIP001     for(nHeight = 18; nHeight <= 28; nHeight+= 2)
//STRIP001         aFontHeightLB.InsertEntry(String::CreateFromInt32(nHeight));
//STRIP001     for(nHeight = 32; nHeight <= 48; nHeight+= 4)
//STRIP001         aFontHeightLB.InsertEntry(String::CreateFromInt32(nHeight));
//STRIP001     for(nHeight = 54; nHeight <= 72; nHeight+= 6)
//STRIP001         aFontHeightLB.InsertEntry(String::CreateFromInt32(nHeight));
//STRIP001     for(nHeight = 80; nHeight <= 96; nHeight+= 8)
//STRIP001         aFontHeightLB.InsertEntry(String::CreateFromInt32(nHeight));
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 SvLBoxEntry* SvxFontSubstTabPage::CreateEntry(String& rFont1, String& rFont2)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = new SvLBoxEntry;
//STRIP001 
//STRIP001 	if( !pCheckButtonData )
//STRIP001 		pCheckButtonData = new SvLBoxButtonData( &aCheckLB );
//STRIP001 
//STRIP001 	pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(), Image(), 0));	// Sonst Puff!
//STRIP001 
//STRIP001 	pEntry->AddItem( new SvLBoxButton( pEntry, 0, pCheckButtonData ) );
//STRIP001 	pEntry->AddItem( new SvLBoxButton( pEntry, 0, pCheckButtonData ) );
//STRIP001 
//STRIP001 	pEntry->AddItem( new SvLBoxString( pEntry, 0, rFont1 ) );
//STRIP001 	pEntry->AddItem( new SvLBoxString( pEntry, 0, rFont2 ) );
//STRIP001 
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 
//STRIP001  SvxFontSubstTabPage::~SvxFontSubstTabPage()
//STRIP001 {
//STRIP001 	delete pCheckButtonData;
//STRIP001 	delete pConfig;
//STRIP001     delete pSourceViewConfig;
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 SfxTabPage*  SvxFontSubstTabPage::Create( Window* pParent,
//STRIP001 								const SfxItemSet& rAttrSet)
//STRIP001 {
//STRIP001 	return new SvxFontSubstTabPage(pParent, rAttrSet);
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 BOOL  SvxFontSubstTabPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	pConfig->ClearSubstitutions();// remove all entries
//STRIP001 
//STRIP001 	pConfig->Enable(aUseTableCB.IsChecked());
//STRIP001 
//STRIP001 	SvLBoxEntry* pEntry = aCheckLB.First();
//STRIP001 	USHORT i = 0;
//STRIP001 
//STRIP001 	while (pEntry)
//STRIP001 	{
//STRIP001 		SubstitutionStruct aAdd;
//STRIP001 		aAdd.sFont = aCheckLB.GetEntryText(pEntry, 0);
//STRIP001 		aAdd.sReplaceBy = aCheckLB.GetEntryText(pEntry, 1);
//STRIP001 		aAdd.bReplaceAlways = aCheckLB.IsChecked(pEntry, 0);
//STRIP001 		aAdd.bReplaceOnScreenOnly = aCheckLB.IsChecked(pEntry, 1);
//STRIP001 		pConfig->AddSubstitution(aAdd);
//STRIP001 		pEntry = aCheckLB.Next(pEntry);
//STRIP001 	}
//STRIP001 	if(pConfig->IsModified())
//STRIP001 		pConfig->Commit();
//STRIP001 	OFF_APP()->UseFontSubst();
//STRIP001     if(aFontHeightLB.GetSavedValue() != aFontHeightLB.GetSelectEntryPos())
//STRIP001         pSourceViewConfig->SetFontHeight((sal_Int16)aFontHeightLB.GetSelectEntry().ToInt32());
//STRIP001     if(aNonPropFontsOnlyCB.GetSavedValue() != aNonPropFontsOnlyCB.IsChecked())
//STRIP001         pSourceViewConfig->SetShowProportionalFontsOnly(aNonPropFontsOnlyCB.IsChecked());
//STRIP001     //font name changes cannot be detected by saved values
//STRIP001     String sFontName;
//STRIP001     if(aFontNameLB.GetSelectEntryPos())
//STRIP001         sFontName = aFontNameLB.GetSelectEntry();
//STRIP001     pSourceViewConfig->SetFontName(sFontName);
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void  SvxFontSubstTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	aCheckLB.SetUpdateMode(FALSE);
//STRIP001 	aCheckLB.Clear();
//STRIP001 
//STRIP001 	FontList aFntLst( Application::GetDefaultDevice() );
//STRIP001 	aFont1CB.Fill( &aFntLst );
//STRIP001 	aFont2CB.Fill( &aFntLst );
//STRIP001 
//STRIP001 	sal_Int32 nCount = pConfig->SubstitutionCount();
//STRIP001 	if (nCount)
//STRIP001 		aUseTableCB.Check(pConfig->IsEnabled());
//STRIP001 
//STRIP001 	for (sal_Int32  i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		const SubstitutionStruct* pSubs = pConfig->GetSubstitution(i);
//STRIP001 		String aTmpStr1(pSubs->sFont);
//STRIP001         String aTmpStr2(pSubs->sReplaceBy);
//STRIP001         SvLBoxEntry* pEntry = CreateEntry(aTmpStr1, aTmpStr2);
//STRIP001 		aCheckLB.GetModel()->Insert(pEntry);
//STRIP001 		aCheckLB.CheckEntry(pEntry, 0, pSubs->bReplaceAlways);
//STRIP001 		aCheckLB.CheckEntry(pEntry, 1, pSubs->bReplaceOnScreenOnly);
//STRIP001 	}
//STRIP001 
//STRIP001 	CheckEnable();
//STRIP001 	aCheckLB.SetUpdateMode(TRUE);
//STRIP001 
//STRIP001     //fill font name box first
//STRIP001     aNonPropFontsOnlyCB.Check(pSourceViewConfig->IsShowProportionalFontsOnly());
//STRIP001     NonPropFontsHdl(&aNonPropFontsOnlyCB);
//STRIP001     String sFontName(pSourceViewConfig->GetFontName());
//STRIP001     if(sFontName.Len())
//STRIP001         aFontNameLB.SelectEntry(sFontName);
//STRIP001     else
//STRIP001         aFontNameLB.SelectEntryPos(0);
//STRIP001     short nFontHeight = pSourceViewConfig->GetFontHeight();
//STRIP001     aFontHeightLB.SelectEntry(String::CreateFromInt32(nFontHeight));
//STRIP001     aNonPropFontsOnlyCB.SaveValue();
//STRIP001     aFontHeightLB.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK(SvxFontSubstTabPage, SelectHdl, Window*, pWin)
//STRIP001 {
//STRIP001 	if (pWin == &aNewDelTBX)
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry;
//STRIP001 		// nCol ist behaemmerterweise die nCol'te Textspalte, werden nicht gezaehlt!
//STRIP001 		// Daher als Spalte "0".
//STRIP001 		ULONG nPos = aCheckLB.GetEntryPos(aFont1CB.GetText(), 0);
//STRIP001 
//STRIP001 		switch (aNewDelTBX.GetCurItemId())
//STRIP001 		{
//STRIP001 			case BT_SUBSTAPPLY:
//STRIP001 			{
//STRIP001 				if (nPos != 0xffffffff)
//STRIP001 				{
//STRIP001 					// Eintrag aendern
//STRIP001 					aCheckLB.SetEntryText(aFont2CB.GetText(), nPos, 1);
//STRIP001 					pEntry = aCheckLB.GetEntry(nPos);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Neuer Eintrag
//STRIP001 					String sFont1 = aFont1CB.GetText();
//STRIP001 					String sFont2 = aFont2CB.GetText();
//STRIP001 
//STRIP001 					pEntry = CreateEntry(sFont1, sFont2);
//STRIP001 					aCheckLB.GetModel()->Insert(pEntry);
//STRIP001 				}
//STRIP001 				aCheckLB.SelectAll(FALSE);
//STRIP001 				aCheckLB.Select(pEntry);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case BT_SUBSTDELETE:
//STRIP001 			{
//STRIP001 				if (nPos != 0xffffffff)
//STRIP001 				{
//STRIP001 					pEntry = aCheckLB.FirstSelected();
//STRIP001 					while (pEntry)
//STRIP001 					{
//STRIP001 						SvLBoxEntry* pDelEntry = pEntry;
//STRIP001 						pEntry = aCheckLB.NextSelected(pEntry);
//STRIP001 						aCheckLB.GetModel()->Remove(pDelEntry);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pWin == &aCheckLB)
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = aCheckLB.FirstSelected();
//STRIP001 
//STRIP001 		if (aCheckLB.NextSelected(pEntry) == 0)
//STRIP001 		{
//STRIP001 			aFont1CB.SetText(aCheckLB.GetEntryText(pEntry, 0));
//STRIP001 			aFont2CB.SetText(aCheckLB.GetEntryText(pEntry, 1));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pWin == &aFont1CB)
//STRIP001 	{
//STRIP001 		ULONG nPos = aCheckLB.GetEntryPos(aFont1CB.GetText(), 0);
//STRIP001 
//STRIP001 		if (nPos != 0xffffffff)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pEntry = aCheckLB.GetEntry(nPos);
//STRIP001 
//STRIP001 			if (pEntry != aCheckLB.FirstSelected())
//STRIP001 			{
//STRIP001 				aCheckLB.SelectAll(FALSE);
//STRIP001 				aCheckLB.Select(pEntry);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	CheckEnable();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------29.08.2002 11:47------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxFontSubstTabPage, NonPropFontsHdl, CheckBox*, pBox)
//STRIP001 {
//STRIP001     String sFontName = aFontNameLB.GetSelectEntry();
//STRIP001     BOOL bNonPropOnly = pBox->IsChecked();
//STRIP001     aFontNameLB.Clear();
//STRIP001     FontList aFntLst( Application::GetDefaultDevice() );
//STRIP001     aFontNameLB.InsertEntry(sAutomatic);
//STRIP001     USHORT nFontCount = aFntLst.GetFontNameCount();
//STRIP001     for(USHORT nFont = 0; nFont < nFontCount; nFont++)
//STRIP001     {
//STRIP001         const FontInfo& rInfo = aFntLst.GetFontName( nFont );
//STRIP001         if(!bNonPropOnly || rInfo.GetPitch() == PITCH_FIXED)
//STRIP001             aFontNameLB.InsertEntry(rInfo.GetName());
//STRIP001     }
//STRIP001     aFontNameLB.SelectEntry(sFontName);
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 void SvxFontSubstTabPage::CheckEnable()
//STRIP001 {
//STRIP001 	BOOL bEnableAll = aUseTableCB.IsChecked();
//STRIP001 
//STRIP001 	if (bEnableAll)
//STRIP001 	{
//STRIP001 		BOOL bApply, bDelete;
//STRIP001 
//STRIP001 		SvLBoxEntry* pEntry = aCheckLB.FirstSelected();
//STRIP001 
//STRIP001 		String sEntry = aFont1CB.GetText();
//STRIP001 		sEntry += '\t';
//STRIP001 		sEntry += aFont2CB.GetText();
//STRIP001 
//STRIP001 /*		if (!aFont1CB.GetText().Len() || !aFont2CB.GetText().Len() ||
//STRIP001 			aFont1CB.GetText() == aFont2CB.GetText() ||
//STRIP001 			aCheckLB.GetEntryPos(sEntry) != 0xffffffff ||
//STRIP001 			(pEntry != 0 && aCheckLB.NextSelected(pEntry) != 0))
//STRIP001 			bApply = FALSE;
//STRIP001 		else
//STRIP001 			bApply = TRUE;*/
//STRIP001 
//STRIP001 		// Wegen OS/2-Optimierungsfehler (Bug #56267) etwas umstaendlicher:
//STRIP001 		if (!aFont1CB.GetText().Len() || !aFont2CB.GetText().Len())
//STRIP001 			bApply = FALSE;
//STRIP001 		else if(aFont1CB.GetText() == aFont2CB.GetText())
//STRIP001 			bApply = FALSE;
//STRIP001 		else if(aCheckLB.GetEntryPos(sEntry) != 0xffffffff)
//STRIP001 			bApply = FALSE;
//STRIP001 		else if(pEntry != 0 && aCheckLB.NextSelected(pEntry) != 0)
//STRIP001 			bApply = FALSE;
//STRIP001 		else
//STRIP001 			bApply = TRUE;
//STRIP001 
//STRIP001 		bDelete = pEntry != 0;
//STRIP001 
//STRIP001 		aNewDelTBX.EnableItem(BT_SUBSTAPPLY, bApply);
//STRIP001 		aNewDelTBX.EnableItem(BT_SUBSTDELETE, bDelete);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bEnableAll)
//STRIP001 	{
//STRIP001 		if (!aCheckLB.IsEnabled())
//STRIP001 		{
//STRIP001 			aCheckLB.Enable();
//STRIP001 			aCheckLB.SetTextColor(aTextColor);
//STRIP001 			aCheckLB.Invalidate();
//STRIP001 			SelectHdl(&aFont1CB);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (aCheckLB.IsEnabled())
//STRIP001 		{
//STRIP001 			aCheckLB.Disable();
//STRIP001 			aCheckLB.SetTextColor(Color(COL_GRAY));
//STRIP001 			aCheckLB.Invalidate();
//STRIP001 			aCheckLB.SelectAll(FALSE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aNewDelTBX.Enable(bEnableAll);
//STRIP001 	aFont1FT.Enable(bEnableAll);
//STRIP001 	aFont1CB.Enable(bEnableAll);
//STRIP001 	aFont2FT.Enable(bEnableAll);
//STRIP001 	aFont2CB.Enable(bEnableAll);
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 void SvxFontSubstCheckListBox::SetTabs()
//STRIP001 {
//STRIP001 	SvxSimpleTable::SetTabs();
//STRIP001 	USHORT nAdjust = SV_LBOXTAB_ADJUST_RIGHT|SV_LBOXTAB_ADJUST_LEFT|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_ADJUST_NUMERIC|SV_LBOXTAB_FORCE;
//STRIP001 
//STRIP001 	SvLBoxTab* pTab = (SvLBoxTab*)aTabs.GetObject(1);
//STRIP001 	pTab->nFlags &= ~nAdjust;
//STRIP001 	pTab->nFlags |= SV_LBOXTAB_PUSHABLE|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_FORCE;
//STRIP001 
//STRIP001 	pTab = (SvLBoxTab*)aTabs.GetObject(2);
//STRIP001 	pTab->nFlags &= ~nAdjust;
//STRIP001 	pTab->nFlags |= SV_LBOXTAB_PUSHABLE|SV_LBOXTAB_ADJUST_CENTER|SV_LBOXTAB_FORCE;
//STRIP001 }
//STRIP001 /* -----------------------------22.05.2002 11:06------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void    SvxFontSubstCheckListBox::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if(!rKEvt.GetKeyCode().GetModifier() &&
//STRIP001         KEY_SPACE == rKEvt.GetKeyCode().GetCode())
//STRIP001     {
//STRIP001         ULONG nSelPos = GetModel()->GetAbsPos(GetCurEntry());
//STRIP001         USHORT nCheck = IsChecked(nSelPos, 1) ? 1 : 0;
//STRIP001         if(IsChecked(nSelPos, 0))
//STRIP001             nCheck += 2;
//STRIP001         nCheck--;
//STRIP001         nCheck &= 3;
//STRIP001         CheckEntryPos(nSelPos, 1, 0 != (nCheck & 1));
//STRIP001         CheckEntryPos(nSelPos, 0, 0 != (nCheck & 2));
//STRIP001     }
//STRIP001     else
//STRIP001         SvxSimpleTable::KeyInput(rKEvt);
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 void SvxFontSubstCheckListBox::CheckEntryPos(ULONG nPos, USHORT nCol, BOOL bChecked)
//STRIP001 {
//STRIP001 	if ( nPos < GetEntryCount() )
//STRIP001 		SetCheckButtonState(
//STRIP001 			GetEntry(nPos),
//STRIP001 			nCol,
//STRIP001 			bChecked ? SvButtonState( SV_BUTTON_CHECKED ) :
//STRIP001 									   SvButtonState( SV_BUTTON_UNCHECKED ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 void SvxFontSubstCheckListBox::CheckEntry(SvLBoxEntry* pEntry, USHORT nCol, BOOL bChecked)
//STRIP001 {
//STRIP001 	if ( pEntry )
//STRIP001 		SetCheckButtonState(
//STRIP001 			pEntry,
//STRIP001 			nCol,
//STRIP001 			bChecked ? SvButtonState( SV_BUTTON_CHECKED ) :
//STRIP001 									   SvButtonState( SV_BUTTON_UNCHECKED ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 BOOL SvxFontSubstCheckListBox::IsChecked(ULONG nPos, USHORT nCol)
//STRIP001 {
//STRIP001 	return GetCheckButtonState( GetEntry(nPos), nCol ) == SV_BUTTON_CHECKED;
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 BOOL SvxFontSubstCheckListBox::IsChecked(SvLBoxEntry* pEntry, USHORT nCol)
//STRIP001 {
//STRIP001 	return GetCheckButtonState( pEntry, nCol ) == SV_BUTTON_CHECKED;
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 void SvxFontSubstCheckListBox::SetCheckButtonState( SvLBoxEntry* pEntry, USHORT nCol, SvButtonState eState)
//STRIP001 {
//STRIP001 	SvLBoxButton* pItem = (SvLBoxButton*)(pEntry->GetItem(nCol + 1));
//STRIP001 
//STRIP001 	DBG_ASSERT(pItem,"SetCheckButton:Item not found")
//STRIP001 	if (((SvLBoxItem*)pItem)->IsA() == SV_ITEM_ID_LBOXBUTTON)
//STRIP001 	{
//STRIP001 		switch( eState )
//STRIP001 		{
//STRIP001 			case SV_BUTTON_CHECKED:
//STRIP001 				pItem->SetStateChecked();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SV_BUTTON_UNCHECKED:
//STRIP001 				pItem->SetStateUnchecked();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SV_BUTTON_TRISTATE:
//STRIP001 				pItem->SetStateTristate();
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		InvalidateEntry( pEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*********************************************************************/
//STRIP001 /*                                                                   */
//STRIP001 /*********************************************************************/
//STRIP001 
//STRIP001 SvButtonState SvxFontSubstCheckListBox::GetCheckButtonState( SvLBoxEntry* pEntry, USHORT nCol ) const
//STRIP001 {
//STRIP001 	SvButtonState eState = SV_BUTTON_UNCHECKED;
//STRIP001 	SvLBoxButton* pItem = (SvLBoxButton*)(pEntry->GetItem(nCol + 1));
//STRIP001 	DBG_ASSERT(pItem,"GetChButnState:Item not found")
//STRIP001 
//STRIP001 	if (((SvLBoxItem*)pItem)->IsA() == SV_ITEM_ID_LBOXBUTTON)
//STRIP001 	{
//STRIP001 		USHORT nButtonFlags = pItem->GetButtonFlags();
//STRIP001 		eState = pCheckButtonData->ConvertToButtonState( nButtonFlags );
//STRIP001 	}
//STRIP001 
//STRIP001 	return eState;
//STRIP001 }


}
