/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_csvruler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:56:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif
#pragma hdrstop

// ============================================================================

#ifndef _SC_CSVRULER_HXX
#include "csvruler.hxx"
#endif

// auto strip #ifndef _SC_ACCESSIBLECSVCONTROL_HXX
// auto strip #include "AccessibleCsvControl.hxx"
// auto strip #endif
namespace binfilter {


// ============================================================================

/*M*/ ScCsvRuler::ScCsvRuler( ScCsvControl& rParent ) :
/*M*/     ScCsvControl( rParent ),
/*M*/     mnPosCursorLast( 1 )
/*M*/ {
/*N*/     EnableRTL( false ); // #107812# RTL
/*M*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 InitColors();
//STRIP001     InitSizeData();
//STRIP001     maBackgrDev.SetFont( GetFont() );
//STRIP001     maRulerDev.SetFont( GetFont() );
/*M*/ }


// common ruler handling ------------------------------------------------------

//STRIP001 void ScCsvRuler::SetPosSizePixel(
//STRIP001         sal_Int32 nX, sal_Int32 nY, sal_Int32 nWidth, sal_Int32 nHeight, sal_uInt16 nFlags )
//STRIP001 {
//STRIP001     if( nFlags & WINDOW_POSSIZE_HEIGHT )
//STRIP001         nHeight = GetTextHeight() + mnSplitSize + 2;
//STRIP001     ScCsvControl::SetPosSizePixel( nX, nY, nWidth, nHeight, nFlags );
//STRIP001 }

//STRIP001 void ScCsvRuler::ApplyLayout( const ScCsvLayoutData& rOldData )
//STRIP001 {
//STRIP001     ScCsvDiff nDiff = GetLayoutData().GetDiff( rOldData ) & (CSV_DIFF_HORIZONTAL | CSV_DIFF_RULERCURSOR);
//STRIP001     if( nDiff == CSV_DIFF_EQUAL ) return;
//STRIP001 
//STRIP001     DisableRepaint();
//STRIP001     if( nDiff & CSV_DIFF_HORIZONTAL )
//STRIP001     {
//STRIP001         InitSizeData();
//STRIP001         if( GetRulerCursorPos() >= GetPosCount() )
//STRIP001             MoveCursor( GetPosCount() - 1 );
//STRIP001     }
//STRIP001     if( nDiff & CSV_DIFF_RULERCURSOR )
//STRIP001     {
//STRIP001         ImplInvertCursor( rOldData.mnPosCursor );
//STRIP001         ImplInvertCursor( GetRulerCursorPos() );
//STRIP001     }
//STRIP001     EnableRepaint();
//STRIP001 
//STRIP001     if( nDiff & CSV_DIFF_POSOFFSET )
//STRIP001         AccSendVisibleEvent();
//STRIP001 }

//STRIP001 void ScCsvRuler::InitColors()
//STRIP001 {
//STRIP001     const StyleSettings& rSett = GetSettings().GetStyleSettings();
//STRIP001     maBackColor = rSett.GetFaceColor();
//STRIP001     maActiveColor = rSett.GetWindowColor();
//STRIP001     maTextColor = rSett.GetLabelTextColor();
//STRIP001     maSplitColor = maBackColor.IsDark() ? maTextColor : Color( COL_LIGHTRED );
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 void ScCsvRuler::InitSizeData()
//STRIP001 {
//STRIP001     maWinSize = GetSizePixel();
//STRIP001 
//STRIP001     mnSplitSize = (GetCharWidth() * 3 / 5) | 1; // make an odd number
//STRIP001 
//STRIP001     sal_Int32 nActiveWidth = Min( GetWidth() - GetHdrWidth(), GetPosCount() * GetCharWidth() );
//STRIP001     sal_Int32 nActiveHeight = GetTextHeight();
//STRIP001 
//STRIP001     maActiveRect.SetPos( Point( GetFirstX(), (GetHeight() - nActiveHeight - 1) / 2 ) );
//STRIP001     maActiveRect.SetSize( Size( nActiveWidth, nActiveHeight ) );
//STRIP001 
//STRIP001     maBackgrDev.SetOutputSizePixel( maWinSize );
//STRIP001     maRulerDev.SetOutputSizePixel( maWinSize );
//STRIP001 
//STRIP001     InvalidateGfx();
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveCursor( sal_Int32 nPos, bool bScroll )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     if( bScroll )
//STRIP001         Execute( CSVCMD_MAKEPOSVISIBLE, nPos );
//STRIP001     Execute( CSVCMD_MOVERULERCURSOR, IsVisibleSplitPos( nPos ) ? nPos : CSV_POS_INVALID );
//STRIP001     EnableRepaint();
//STRIP001     AccSendCaretEvent();
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveCursorRel( ScMoveMode eDir )
//STRIP001 {
//STRIP001     if( GetRulerCursorPos() != CSV_POS_INVALID )
//STRIP001     {
//STRIP001         switch( eDir )
//STRIP001         {
//STRIP001             case MOVE_FIRST:
//STRIP001                 MoveCursor( 1 );
//STRIP001             break;
//STRIP001             case MOVE_LAST:
//STRIP001                 MoveCursor( GetPosCount() - 1 );
//STRIP001             break;
//STRIP001             case MOVE_PREV:
//STRIP001                 if( GetRulerCursorPos() > 1 )
//STRIP001                     MoveCursor( GetRulerCursorPos() - 1 );
//STRIP001             break;
//STRIP001             case MOVE_NEXT:
//STRIP001                 if( GetRulerCursorPos() < GetPosCount() - 1 )
//STRIP001                     MoveCursor( GetRulerCursorPos() + 1 );
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveCursorToSplit( ScMoveMode eDir )
//STRIP001 {
//STRIP001     if( GetRulerCursorPos() != CSV_POS_INVALID )
//STRIP001     {
//STRIP001         sal_uInt32 nIndex = CSV_VEC_NOTFOUND;
//STRIP001         switch( eDir )
//STRIP001         {
//STRIP001             case MOVE_FIRST:    nIndex = maSplits.LowerBound( 0 );                          break;
//STRIP001             case MOVE_LAST:     nIndex = maSplits.UpperBound( GetPosCount() );              break;
//STRIP001             case MOVE_PREV:     nIndex = maSplits.UpperBound( GetRulerCursorPos() - 1 );    break;
//STRIP001             case MOVE_NEXT:     nIndex = maSplits.LowerBound( GetRulerCursorPos() + 1 );    break;
//STRIP001         }
//STRIP001         sal_Int32 nPos = maSplits[ nIndex ];
//STRIP001         if( nPos != CSV_POS_INVALID )
//STRIP001             MoveCursor( nPos );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ScrollVertRel( ScMoveMode eDir )
//STRIP001 {
//STRIP001     sal_Int32 nLine = GetFirstVisLine();
//STRIP001     switch( eDir )
//STRIP001     {
//STRIP001         case MOVE_PREV:     --nLine;                        break;
//STRIP001         case MOVE_NEXT:     ++nLine;                        break;
//STRIP001         case MOVE_PREVPAGE: nLine -= GetVisLineCount() - 1; break;
//STRIP001         case MOVE_NEXTPAGE: nLine += GetVisLineCount() - 1; break;
//STRIP001     }
//STRIP001     Execute( CSVCMD_SETLINEOFFSET, nLine );
//STRIP001 }


// split handling -------------------------------------------------------------

//STRIP001 sal_Int32 ScCsvRuler::GetNoScrollPos( sal_Int32 nPos ) const
//STRIP001 {
//STRIP001     sal_Int32 nNewPos = nPos;
//STRIP001     if( nNewPos != CSV_POS_INVALID )
//STRIP001     {
//STRIP001         if( nNewPos < GetFirstVisPos() + CSV_SCROLL_DIST )
//STRIP001         {
//STRIP001             sal_Int32 nScroll = (GetFirstVisPos() > 0) ? CSV_SCROLL_DIST : 0;
//STRIP001             nNewPos = Max( nPos, GetFirstVisPos() + nScroll );
//STRIP001         }
//STRIP001         else if( nNewPos > GetLastVisPos() - CSV_SCROLL_DIST - 1L )
//STRIP001         {
//STRIP001             sal_Int32 nScroll = (GetFirstVisPos() < GetMaxPosOffset()) ? CSV_SCROLL_DIST : 0;
//STRIP001             nNewPos = Min( nNewPos, GetLastVisPos() - nScroll - 1L );
//STRIP001         }
//STRIP001     }
//STRIP001     return nNewPos;
//STRIP001 }

//STRIP001 void ScCsvRuler::InsertSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( maSplits.Insert( nPos ) )
//STRIP001     {
//STRIP001         ImplDrawSplit( nPos );
//STRIP001         Repaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::RemoveSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( maSplits.Remove( nPos ) )
//STRIP001     {
//STRIP001         ImplEraseSplit( nPos );
//STRIP001         Repaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveSplit( sal_Int32 nPos, sal_Int32 nNewPos )
//STRIP001 {
//STRIP001     bool bRemove = maSplits.Remove( nPos );
//STRIP001     bool bInsert = maSplits.Insert( nNewPos );
//STRIP001     if( bRemove || bInsert )
//STRIP001     {
//STRIP001         ImplEraseSplit( nPos );
//STRIP001         ImplDrawSplit( nNewPos );
//STRIP001         Repaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::RemoveAllSplits()
//STRIP001 {
//STRIP001     maSplits.Clear();
//STRIP001     Repaint( true );
//STRIP001 }

//STRIP001 sal_Int32 ScCsvRuler::FindEmptyPos( sal_Int32 nPos, ScMoveMode eDir ) const
//STRIP001 {
//STRIP001     sal_Int32 nNewPos = nPos;
//STRIP001     if( nNewPos != CSV_POS_INVALID )
//STRIP001     {
//STRIP001         switch( eDir )
//STRIP001         {
//STRIP001             case MOVE_FIRST:
//STRIP001                 nNewPos = Min( nPos, FindEmptyPos( 0, MOVE_NEXT ) );
//STRIP001             break;
//STRIP001             case MOVE_LAST:
//STRIP001                 nNewPos = Max( nPos, FindEmptyPos( GetPosCount(), MOVE_PREV ) );
//STRIP001             break;
//STRIP001             case MOVE_PREV:
//STRIP001                 while( HasSplit( --nNewPos ) );
//STRIP001             break;
//STRIP001             case MOVE_NEXT:
//STRIP001                 while( HasSplit( ++nNewPos ) );
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     return IsValidSplitPos( nNewPos ) ? nNewPos : CSV_POS_INVALID;
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveCurrSplit( sal_Int32 nNewPos )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     Execute( CSVCMD_MOVESPLIT, GetRulerCursorPos(), nNewPos );
//STRIP001     MoveCursor( nNewPos );
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveCurrSplitRel( ScMoveMode eDir )
//STRIP001 {
//STRIP001     if( HasSplit( GetRulerCursorPos() ) )
//STRIP001     {
//STRIP001         sal_Int32 nNewPos = FindEmptyPos( GetRulerCursorPos(), eDir );
//STRIP001         if( nNewPos != CSV_POS_INVALID )
//STRIP001             MoveCurrSplit( nNewPos );
//STRIP001     }
//STRIP001 }


// event handling -------------------------------------------------------------

//STRIP001 void ScCsvRuler::Resize()
//STRIP001 {
//STRIP001     ScCsvControl::Resize();
//STRIP001     InitSizeData();
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 void ScCsvRuler::GetFocus()
//STRIP001 {
//STRIP001     ScCsvControl::GetFocus();
//STRIP001     DisableRepaint();
//STRIP001     if( GetRulerCursorPos() == CSV_POS_INVALID )
//STRIP001         MoveCursor( GetNoScrollPos( mnPosCursorLast ) );
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvRuler::LoseFocus()
//STRIP001 {
//STRIP001     ScCsvControl::LoseFocus();
//STRIP001     mnPosCursorLast = GetRulerCursorPos();
//STRIP001     MoveCursor( CSV_POS_INVALID );
//STRIP001 }

//STRIP001 void ScCsvRuler::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         InitColors();
//STRIP001         Repaint();
//STRIP001     }
//STRIP001     ScCsvControl::DataChanged( rDCEvt );
//STRIP001 }

//STRIP001 void ScCsvRuler::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     DisableRepaint();
//STRIP001     if( !HasFocus() )
//STRIP001         GrabFocus();
//STRIP001     if( rMEvt.IsLeft() )
//STRIP001     {
//STRIP001         sal_Int32 nPos = GetPosFromX( rMEvt.GetPosPixel().X() );
//STRIP001         if( IsVisibleSplitPos( nPos ) )
//STRIP001             StartMouseTracking( nPos );
//STRIP001         ImplSetMousePointer( nPos );
//STRIP001     }
//STRIP001     EnableRepaint();
//STRIP001 }

//STRIP001 void ScCsvRuler::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if( !rMEvt.IsModifierChanged() )
//STRIP001     {
//STRIP001         sal_Int32 nPos = GetPosFromX( rMEvt.GetPosPixel().X() );
//STRIP001         if( IsTracking() )
//STRIP001         {
//STRIP001             // on mouse tracking: keep position valid
//STRIP001             nPos = Max( Min( nPos, GetPosCount() - 1L ), 1L );
//STRIP001             MoveMouseTracking( nPos );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             Point aPoint;
//STRIP001             Rectangle aRect( aPoint, maWinSize );
//STRIP001             if( !IsVisibleSplitPos( nPos ) || !aRect.IsInside( rMEvt.GetPosPixel() ) )
//STRIP001                 // if focused, keep old cursor position for key input
//STRIP001                 nPos = HasFocus() ? GetRulerCursorPos() : CSV_POS_INVALID;
//STRIP001             MoveCursor( nPos, false );
//STRIP001         }
//STRIP001         ImplSetMousePointer( nPos );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::Tracking( const TrackingEvent& rTEvt )
//STRIP001 {
//STRIP001     if( rTEvt.IsTrackingEnded() || rTEvt.IsTrackingRepeat() )
//STRIP001         MouseMove( rTEvt.GetMouseEvent() );
//STRIP001     if( rTEvt.IsTrackingEnded() )
//STRIP001         EndMouseTracking( !rTEvt.IsTrackingCanceled() );
//STRIP001 }

//STRIP001 void ScCsvRuler::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     const KeyCode& rKCode = rKEvt.GetKeyCode();
//STRIP001     sal_uInt16 nCode = rKCode.GetCode();
//STRIP001     bool bNoMod = !rKCode.GetModifier();
//STRIP001     bool bShift = (rKCode.GetModifier() == KEY_SHIFT);
//STRIP001     bool bJump = (rKCode.GetModifier() == KEY_MOD1);
//STRIP001     bool bMove = (rKCode.GetModifier() == (KEY_MOD1 | KEY_SHIFT));
//STRIP001 
//STRIP001     ScMoveMode eHDir = GetHorzDirection( nCode, true );
//STRIP001     ScMoveMode eVDir = GetVertDirection( nCode, false );
//STRIP001 
//STRIP001     if( bNoMod )
//STRIP001     {
//STRIP001         if( eHDir != MOVE_NONE )
//STRIP001             MoveCursorRel( eHDir );
//STRIP001         else if( eVDir != MOVE_NONE )
//STRIP001             ScrollVertRel( eVDir );
//STRIP001         else switch( nCode )
//STRIP001         {
//STRIP001             case KEY_SPACE:     Execute( CSVCMD_TOGGLESPLIT, GetRulerCursorPos() ); break;
//STRIP001             case KEY_INSERT:    Execute( CSVCMD_INSERTSPLIT, GetRulerCursorPos() ); break;
//STRIP001             case KEY_DELETE:    Execute( CSVCMD_REMOVESPLIT, GetRulerCursorPos() ); break;
//STRIP001         }
//STRIP001     }
//STRIP001     else if( bJump && (eHDir != MOVE_NONE) )
//STRIP001         MoveCursorToSplit( eHDir );
//STRIP001     else if( bMove && (eHDir != MOVE_NONE) )
//STRIP001         MoveCurrSplitRel( eHDir );
//STRIP001     else if( bShift && (nCode == KEY_DELETE) )
//STRIP001         Execute( CSVCMD_REMOVEALLSPLITS );
//STRIP001 
//STRIP001     if( rKCode.GetGroup() != KEYGROUP_CURSOR )
//STRIP001         ScCsvControl::KeyInput( rKEvt );
//STRIP001 }

//STRIP001 void ScCsvRuler::StartMouseTracking( sal_Int32 nPos )
//STRIP001 {
//STRIP001     mnPosMTStart = mnPosMTCurr = nPos;
//STRIP001     mbPosMTMoved = false;
//STRIP001     maOldSplits = maSplits;
//STRIP001     Execute( CSVCMD_INSERTSPLIT, nPos );
//STRIP001     if( HasSplit( nPos ) )
//STRIP001         StartTracking( STARTTRACK_BUTTONREPEAT );
//STRIP001 }

//STRIP001 void ScCsvRuler::MoveMouseTracking( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( mnPosMTCurr != nPos )
//STRIP001     {
//STRIP001         DisableRepaint();
//STRIP001         MoveCursor( nPos );
//STRIP001         if( (mnPosMTCurr != mnPosMTStart) && maOldSplits.HasSplit( mnPosMTCurr ) )
//STRIP001             Execute( CSVCMD_INSERTSPLIT, nPos );
//STRIP001         else
//STRIP001             Execute( CSVCMD_MOVESPLIT, mnPosMTCurr, nPos );
//STRIP001         mnPosMTCurr = nPos;
//STRIP001         mbPosMTMoved = true;
//STRIP001         EnableRepaint();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::EndMouseTracking( bool bApply )
//STRIP001 {
//STRIP001     if( bApply )    // tracking finished successfully
//STRIP001     {
//STRIP001         // remove on simple click on an existing split
//STRIP001         if( (mnPosMTCurr == mnPosMTStart) && maOldSplits.HasSplit( mnPosMTCurr ) && !mbPosMTMoved )
//STRIP001             Execute( CSVCMD_REMOVESPLIT, mnPosMTCurr );
//STRIP001     }
//STRIP001     else            // tracking cancelled
//STRIP001     {
//STRIP001         MoveCursor( mnPosMTStart );
//STRIP001         // move split to origin
//STRIP001         if( maOldSplits.HasSplit( mnPosMTStart ) )
//STRIP001             MoveMouseTracking( mnPosMTStart );
//STRIP001         // remove temporarily inserted split
//STRIP001         else if( !maOldSplits.HasSplit( mnPosMTCurr ) )
//STRIP001             Execute( CSVCMD_REMOVESPLIT, mnPosMTCurr );
//STRIP001     }
//STRIP001     mnPosMTStart = CSV_POS_INVALID;
//STRIP001 }


// painting -------------------------------------------------------------------

//STRIP001 void ScCsvRuler::Paint( const Rectangle& )
//STRIP001 {
//STRIP001     Repaint();
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplRedraw()
//STRIP001 {
//STRIP001     if( IsVisible() )
//STRIP001     {
//STRIP001         if( !IsValidGfx() )
//STRIP001         {
//STRIP001             ValidateGfx();
//STRIP001             ImplDrawBackgrDev();
//STRIP001             ImplDrawRulerDev();
//STRIP001         }
//STRIP001         DrawOutDev( Point(), maWinSize, Point(), maWinSize, maRulerDev );
//STRIP001         ImplDrawTrackingRect();
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplDrawArea( sal_Int32 nPosX, sal_Int32 nWidth )
//STRIP001 {
//STRIP001     maBackgrDev.SetLineColor();
//STRIP001     Rectangle aRect( Point( nPosX, 0 ), Size( nWidth, GetHeight() ) );
//STRIP001     maBackgrDev.SetFillColor( maBackColor );
//STRIP001     maBackgrDev.DrawRect( aRect );
//STRIP001 
//STRIP001     aRect = maActiveRect;
//STRIP001     aRect.Left() = Max( GetFirstX(), nPosX );
//STRIP001     aRect.Right() = Min( Min( GetX( GetPosCount() ), GetLastX() ), nPosX + nWidth - 1L );
//STRIP001     if( aRect.Left() <= aRect.Right() )
//STRIP001     {
//STRIP001         maBackgrDev.SetFillColor( maActiveColor );
//STRIP001         maBackgrDev.DrawRect( aRect );
//STRIP001     }
//STRIP001 
//STRIP001     maBackgrDev.SetLineColor( maTextColor );
//STRIP001     sal_Int32 nY = GetHeight() - 1;
//STRIP001     maBackgrDev.DrawLine( Point( nPosX, nY ), Point( nPosX + nWidth - 1, nY ) );
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplDrawBackgrDev()
//STRIP001 {
//STRIP001     ImplDrawArea( 0, GetWidth() );
//STRIP001 
//STRIP001     // scale
//STRIP001     maBackgrDev.SetLineColor( maTextColor );
//STRIP001     maBackgrDev.SetFillColor();
//STRIP001     sal_Int32 nPos;
//STRIP001 
//STRIP001     sal_Int32 nFirstPos = Max( GetPosFromX( 0 ) - 1L, 0L );
//STRIP001     sal_Int32 nLastPos = GetPosFromX( GetWidth() );
//STRIP001     sal_Int32 nY = (maActiveRect.Top() + maActiveRect.Bottom()) / 2;
//STRIP001     for( nPos = nFirstPos; nPos <= nLastPos; ++nPos )
//STRIP001     {
//STRIP001         sal_Int32 nX = GetX( nPos );
//STRIP001         if( nPos % 5 )
//STRIP001             maBackgrDev.DrawPixel( Point( nX, nY ) );
//STRIP001         else
//STRIP001             maBackgrDev.DrawLine( Point( nX, nY - 1 ), Point( nX, nY + 1 ) );
//STRIP001     }
//STRIP001 
//STRIP001     // texts
//STRIP001     maBackgrDev.SetTextColor( maTextColor );
//STRIP001     maBackgrDev.SetTextFillColor();
//STRIP001     for( nPos = ((nFirstPos + 9) / 10) * 10; nPos <= nLastPos; nPos += 10 )
//STRIP001     {
//STRIP001         String aText( String::CreateFromInt32( nPos ) );
//STRIP001         sal_Int32 nTextWidth = maBackgrDev.GetTextWidth( aText );
//STRIP001         sal_Int32 nTextX = GetX( nPos ) - nTextWidth / 2;
//STRIP001         ImplDrawArea( nTextX - 1, nTextWidth + 2 );
//STRIP001         maBackgrDev.DrawText( Point( nTextX, maActiveRect.Top() ), aText );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplDrawSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( IsVisibleSplitPos( nPos ) )
//STRIP001     {
//STRIP001         Point aPos( GetX( nPos ) - mnSplitSize / 2, GetHeight() - mnSplitSize - 2 );
//STRIP001         Size aSize( mnSplitSize, mnSplitSize );
//STRIP001         maRulerDev.SetLineColor( maTextColor );
//STRIP001         maRulerDev.SetFillColor( maSplitColor );
//STRIP001         maRulerDev.DrawEllipse( Rectangle( aPos, aSize ) );
//STRIP001         maRulerDev.DrawPixel( Point( GetX( nPos ), GetHeight() - 2 ) );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplEraseSplit( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( IsVisibleSplitPos( nPos ) )
//STRIP001     {
//STRIP001         ImplInvertCursor( GetRulerCursorPos() );
//STRIP001         Point aPos( GetX( nPos ) - mnSplitSize / 2, 0 );
//STRIP001         Size aSize( mnSplitSize, GetHeight() );
//STRIP001         maRulerDev.DrawOutDev( aPos, aSize, aPos, aSize, maBackgrDev );
//STRIP001         ImplInvertCursor( GetRulerCursorPos() );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplDrawRulerDev()
//STRIP001 {
//STRIP001     maRulerDev.DrawOutDev( Point(), maWinSize, Point(), maWinSize, maBackgrDev );
//STRIP001     ImplInvertCursor( GetRulerCursorPos() );
//STRIP001 
//STRIP001     sal_uInt32 nFirst = maSplits.LowerBound( GetFirstVisPos() );
//STRIP001     sal_uInt32 nLast = maSplits.UpperBound( GetLastVisPos() );
//STRIP001     if( (nFirst != CSV_POS_INVALID) && (nLast != CSV_POS_INVALID) )
//STRIP001         for( sal_uInt32 nIndex = nFirst; nIndex <= nLast; ++nIndex )
//STRIP001             ImplDrawSplit( GetSplitPos( nIndex ) );
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplInvertCursor( sal_Int32 nPos )
//STRIP001 {
//STRIP001     if( IsVisibleSplitPos( nPos ) )
//STRIP001     {
//STRIP001         ImplInvertRect( maRulerDev, Rectangle( Point( GetX( nPos ) - 1, 0 ), Size( 3, GetHeight() - 1 ) ) );
//STRIP001         if( HasSplit( nPos ) )
//STRIP001             ImplDrawSplit( nPos );
//STRIP001     }
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplDrawTrackingRect()
//STRIP001 {
//STRIP001     if( HasFocus() )
//STRIP001         InvertTracking( Rectangle( 0, 0, GetWidth() - 1, GetHeight() - 2 ),
//STRIP001             SHOWTRACK_SMALL | SHOWTRACK_WINDOW );
//STRIP001 }

//STRIP001 void ScCsvRuler::ImplSetMousePointer( sal_Int32 nPos )
//STRIP001 {
//STRIP001     SetPointer( Pointer( HasSplit( nPos ) ? POINTER_HSPLIT : POINTER_ARROW ) );
//STRIP001 }


// accessibility ==============================================================

//STRIP001 ScAccessibleCsvControl* ScCsvRuler::ImplCreateAccessible()
//STRIP001 {
//STRIP001     return new ScAccessibleCsvRuler( *this );
//STRIP001 }


// ============================================================================

}
