/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:06:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// System - Includes -----------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef PCH
// auto strip #include "scitems.hxx"              // SearchItem
//#include <segmentc.hxx>
#endif

// INCLUDE ---------------------------------------------------------------

#include "undoblk.hxx"
// auto strip #include "document.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
#include "olinetab.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
#include "target.hxx"

#include "undoolk.hxx"              //! GetUndo ins Document verschieben!
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

TYPEINIT1(ScUndoWidthOrHeight,		SfxUndoAction);

// -----------------------------------------------------------------------



//
//		Spaltenbreiten oder Zeilenhoehen aendern
//

/*N*/ ScUndoWidthOrHeight::ScUndoWidthOrHeight( ScDocShell* pNewDocShell,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				USHORT nNewStart, USHORT nNewStartTab, USHORT nNewEnd, USHORT nNewEndTab,
/*N*/ 				ScDocument* pNewUndoDoc, USHORT nNewCnt, USHORT* pNewRanges,
/*N*/ 				ScOutlineTable* pNewUndoTab,
/*N*/ 				ScSizeMode eNewMode, USHORT nNewSizeTwips, BOOL bNewWidth ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	nStart( nNewStart ),
/*N*/ 	nEnd( nNewEnd ),
/*N*/ 	nStartTab( nNewStartTab ),
/*N*/ 	nEndTab( nNewEndTab ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	nRangeCnt( nNewCnt ),
/*N*/ 	pRanges( pNewRanges ),
/*N*/ 	pUndoTab( pNewUndoTab ),
/*N*/ 	eMode( eNewMode ),
/*N*/ 	nNewSize( nNewSizeTwips ),
/*N*/ 	bWidth( bNewWidth ),
/*N*/ 	pDrawUndo( NULL )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ }

/*N*/ __EXPORT ScUndoWidthOrHeight::~ScUndoWidthOrHeight()
/*N*/ {
/*N*/ 	delete[] pRanges;
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pUndoTab;
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

/*N*/ String __EXPORT ScUndoWidthOrHeight::GetComment() const
/*N*/ {
/*N*/ 	// [ "optimale " ] "Spaltenbreite" | "Zeilenhoehe"
/*N*/ 	return ( bWidth ?
/*N*/ 		( ( eMode == SC_SIZE_OPTIMAL )?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_OPTCOLWIDTH ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_COLWIDTH )
/*N*/ 		) :
/*N*/ 		( ( eMode == SC_SIZE_OPTIMAL )?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_OPTROWHEIGHT ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_ROWHEIGHT )
/*N*/ 		) );
/*N*/ }

//STRIP001 void __EXPORT ScUndoWidthOrHeight::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	USHORT nPaintStart = nStart ? nStart-1 : 0;
//STRIP001 
//STRIP001 	if (eMode==SC_SIZE_OPTIMAL)
//STRIP001 	{
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->DoneBlockMode();
//STRIP001 			pViewShell->InitOwnBlockMode();
//STRIP001 			pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 
//STRIP001 			nPaintStart = 0;		// paint all, because of changed selection
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	outlines from all tables?
//STRIP001 	if (pUndoTab)											// Outlines mit gespeichert?
//STRIP001 		pDoc->SetOutlineTable( nStartTab, pUndoTab );
//STRIP001 
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nTab;
//STRIP001 	for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 		if (aMarkData.GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			if (bWidth)	// Width
//STRIP001 			{
//STRIP001 				pUndoDoc->CopyToDocument( nStart, 0, nTab, nEnd, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 				pDoc->UpdatePageBreaks( nTab );
//STRIP001 				pDocShell->PostPaint( nPaintStart, 0, nTab, MAXCOL, MAXROW, nTab, PAINT_GRID | PAINT_TOP );
//STRIP001 			}
//STRIP001 			else		// Height
//STRIP001 			{
//STRIP001 				pUndoDoc->CopyToDocument( 0, nStart, nTab, MAXCOL, nEnd, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 				pDoc->UpdatePageBreaks( nTab );
//STRIP001 				pDocShell->PostPaint( 0, nPaintStart, nTab, MAXCOL, MAXROW, nTab, PAINT_GRID | PAINT_LEFT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->UpdateScrollBars();
//STRIP001 
//STRIP001 		USHORT nCurrentTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nCurrentTab < nStartTab || nCurrentTab > nEndTab )
//STRIP001 			pViewShell->SetTabNo( nStartTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoWidthOrHeight::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	BOOL bPaintAll = FALSE;
//STRIP001 	if (eMode==SC_SIZE_OPTIMAL)
//STRIP001 	{
//STRIP001 		if (pViewShell)
//STRIP001 		{
//STRIP001 			pViewShell->DoneBlockMode();
//STRIP001 			pViewShell->InitOwnBlockMode();
//STRIP001 			pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 
//STRIP001 			bPaintAll = TRUE;		// paint all, because of changed selection
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nTab < nStartTab || nTab > nEndTab )
//STRIP001 			pViewShell->SetTabNo( nStartTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	// SetWidthOrHeight aendert aktuelle Tabelle !
//STRIP001 	pViewShell->SetWidthOrHeight( bWidth, nRangeCnt, pRanges, eMode, nNewSize, FALSE, TRUE, &aMarkData );
//STRIP001 
//STRIP001 	// paint grid if selection was changed directly at the MarkData
//STRIP001 	if (bPaintAll)
//STRIP001 		pDocShell->PostPaint( 0, 0, nStartTab, MAXCOL, MAXROW, nEndTab, PAINT_GRID );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoWidthOrHeight::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->SetMarkedWidthOrHeight( bWidth, eMode, nNewSize, TRUE );
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoWidthOrHeight::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

/*------------------------------------------------------------------------

	$Log: sc_undoblk2.cxx,v $
	Revision 1.4  2005/09/07 21:06:18  rt
	INTEGRATION: CWS ooo19126 (1.3.128); FILE MERGED
	2005/09/05 10:43:10 rt 1.3.128.1: #i54170# Change license header: remove SISSL
	
	Revision 1.3.128.1  2005/09/05 10:43:10  rt
	#i54170# Change license header: remove SISSL
	
	Revision 1.3  2004/08/03 12:16:42  hr
	INTEGRATION: CWS bff2 (1.2.20); FILE MERGED
	2004/07/13 08:38:47 aw 1.2.20.1: #117295# minimize_includes step2
	
	Revision 1.2.20.1  2004/07/13 08:38:47  aw
	#117295# minimize_includes step2
	
	Revision 1.2  2003/11/06 07:31:24  mwu
	adding namesapce binfilter
	
	Revision 1.1.1.1  2003/10/01 12:19:02  hjs
	initial import
	
	Revision 1.3.18.6  2003/01/21 01:54:22  mwu
	STRIP_unix_01212003
	
	Revision 1.3.18.2  2002/11/18 01:57:40  mwu
	STRIP001 20021118
	
	Revision 1.3  2001/07/06 12:52:29  nn
	#89240# repaint grid after modifying selection directly at the MarkData
	
	Revision 1.2  2000/11/16 13:15:06  nn
	#75222# UndoWidthOrHeight: allow several sheets
	
	Revision 1.1.1.1  2000/09/18 16:45:07  hr
	initial import
	
	Revision 1.18  2000/09/17 14:09:28  willem.vandorp
	OpenOffice header added.
	
	Revision 1.17  2000/08/31 16:38:39  willem.vandorp
	Header and footer replaced
	
	Revision 1.16  1999/10/27 14:46:07  hr
	#65293#: removed  SEG_EOFGLOBALS() SEG_FUNCDEF
	
	Revision 1.15  1996/09/04 17:46:18  RJ
	ueberarbeitet
	

	  Rev 1.14   04 Sep 1996 19:46:18   RJ
   ueberarbeitet

	  Rev 1.13   19 Aug 1996 21:29:44   NN
   Markierungen werden nicht mehr am Dokument gehalten

	  Rev 1.12   08 Dec 1995 14:31:46   NN
   ScSimpleUndo

	  Rev 1.11   10 Oct 1995 09:52:12   NN
   Paint beim Ausblenden

	  Rev 1.10   09 Oct 1995 15:49:16   NN
   ScTabViewTarget fuer Repeat

	  Rev 1.9   04 Oct 1995 19:51:52   NN
   Repeat mit ViewShell als RepeatTarget

	  Rev 1.8   12 Jul 1995 15:07:26   NN
   __EXPORT bei Destruktoren

	  Rev 1.7   11 Jul 1995 12:39:06   HJS
   add: __EXPORT

	  Rev 1.6	17 Jun 1995 14:00:04   TRI
   EXPORTS

	  Rev 1.5	15 Jun 1995 08:52:46   TRI
   EXPORT

	  Rev 1.4	06 Jun 1995 12:35:28   NN
   Abfrage, ob ViewShell vorhanden

	  Rev 1.3	24 Mar 1995 18:39:00   SC
   out of keys hack

	  Rev 1.2	22 Mar 1995 16:39:10   STE
   undoblk3 abgesplittet

	  Rev 1.1	21 Mar 1995 14:40:08   TRI
   Out of Keys - Defines eingebaut

	  Rev 1.0	08 Mar 1995 02:51:52   SC
   aufgeteilt

------------------------------------------------------------------------*/

#pragma SEG_EOFMODULE

}
