/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_dgrdata.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:18:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "dgrdata.hxx"
#include "dgrdata.hrc"

// for SID_DIAGRAM_DATA_WIN
#include "app.hrc"

#include "schresid.hxx"
#include "strings.hrc"
#include "memchrt.hxx"
#include "docshell.hxx"
#include "undgrdat.hxx"

#include <memory>

#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_TASKPANELIST_HXX
#include <vcl/taskpanelist.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
namespace binfilter {


// definition of the ChildWindow class that is passed to the dialog
//STRIP001 SFX_IMPL_FLOATINGWINDOW( SchDiagramDataWrapper, SID_DIAGRAM_DATA_WIN );
//STRIP001 
//STRIP001 
//STRIP001 // ----------------------------------------
//STRIP001 // SchDiagramDataWrapper
//STRIP001 //
//STRIP001 // This child window is passed to the SchDiagramDataWindow.  Its purpose is to
//STRIP001 // track and store the window position and size (stored in Views.xml)
//STRIP001 // ----------------------------------------
//STRIP001 
//STRIP001 SchDiagramDataWrapper::SchDiagramDataWrapper(Window* pParent, USHORT nId,
//STRIP001 											 SfxBindings* pBindings,
//STRIP001 											 SfxChildWinInfo* pInfo) :
//STRIP001 	SfxChildWindow(pParent, nId)
//STRIP001 {
//STRIP001     SchDiagramDataWindow * pDlg = new SchDiagramDataWindow( pParent, pBindings, this );
//STRIP001     // pWindow is a protected member of SfxChildWindow
//STRIP001 	pWindow = pDlg;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001     pDlg->Initialize( pInfo );
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------
//STRIP001 // SchDiagramDataWindow
//STRIP001 // ----------------------------------------
//STRIP001 
//STRIP001 SchDiagramDataWindow::SchDiagramDataWindow(Window* pWindow,
//STRIP001 										   SfxBindings* pBind,
//STRIP001 										   SfxChildWindow *pChild) :
//STRIP001 		SfxFloatingWindow(pBind, pChild, pWindow, SchResId(FLTWIN_DIAGRAM_DATA)),
//STRIP001 
//STRIP001 	aBrwData( this, ResId( CTL_DATA )),
//STRIP001 	aTbxData( this, ResId( TBX_DATA )),
//STRIP001     pBindings( pBind ),
//STRIP001     maToolboxImageList( ResId( IL_DIAGRAM_DATA )),
//STRIP001     maToolboxImageListHighContrast( ResId( IL_HC_DIAGRAM_DATA ))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     // set min size to current size
//STRIP001     SetMinOutputSizePixel( GetOutputSizePixel() );
//STRIP001 
//STRIP001 	ApplyImageList();
//STRIP001 
//STRIP001 	bReadOnly=FALSE;
//STRIP001 
//STRIP001 	aTbxData.SetSizePixel( aTbxData.CalcWindowSizePixel() );
//STRIP001     aTbxData.SetSelectHdl( LINK( this, SchDiagramDataWindow, ToolboxHdl ));
//STRIP001 
//STRIP001     aBrwData.SetCursorMovedHdl( LINK( this, SchDiagramDataWindow,
//STRIP001                                       BrowserCursorMovedHdl));
//STRIP001     aBrwData.SetCellModifiedHdl( LINK( this, SchDiagramDataWindow,
//STRIP001                                        CellModified ));
//STRIP001 
//STRIP001 	UpdateData();
//STRIP001 	StartListening(*pBindings);
//STRIP001 	GrabFocus();
//STRIP001     aBrwData.GrabFocus();
//STRIP001 
//STRIP001 	aTbxData.EnableItem( TBI_DATA_TRANSFER, FALSE );
//STRIP001 
//STRIP001 	SfxObjectShell *pShell = SfxObjectShell::Current();
//STRIP001 	if (pShell->ISA (SchChartDocShell))
//STRIP001 	{
//STRIP001 		SchChartDocShell* pDocShell = (SchChartDocShell*) pShell;
//STRIP001 
//STRIP001 		BOOL bReadOnlyData=FALSE;
//STRIP001 		ChartModel* pModel=(ChartModel *)(&pDocShell->GetDoc());
//STRIP001 		SchMemChart* pMemChart=pModel->GetChartData();
//STRIP001 		if(pMemChart)
//STRIP001 			bReadOnlyData=pMemChart->IsReadOnly();
//STRIP001 
//STRIP001 		SetReadOnly(pDocShell->IsReadOnly()  || bReadOnlyData);
//STRIP001 	}
//STRIP001 
//STRIP001     // #101228# change buttons to flat-look if set so by user
//STRIP001     SvtMiscOptions aMiscOptions;
//STRIP001     const sal_Int16 nStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001     // react on changes
//STRIP001     aMiscOptions.AddListener( LINK( this, SchDiagramDataWindow, MiscHdl ) );
//STRIP001     aTbxData.SetOutStyle( nStyle );
//STRIP001 
//STRIP001     // allow travelling to toolbar with F6
//STRIP001     notifySystemWindow( this, & aTbxData, ::comphelper::mem_fun( & TaskPaneList::AddWindow ));
//STRIP001 }
//STRIP001 
//STRIP001 SchDiagramDataWindow::~SchDiagramDataWindow()
//STRIP001 {
//STRIP001 	EndListening(*pBindings);
//STRIP001     notifySystemWindow( this, & aTbxData, ::comphelper::mem_fun( & TaskPaneList::RemoveWindow ));
//STRIP001 }
//STRIP001 
//STRIP001 // react on click (or keypress) on toolbar icon
//STRIP001 IMPL_LINK( SchDiagramDataWindow, ToolboxHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	switch( aTbxData.GetCurItemId() )
//STRIP001 	{
//STRIP001 		case TBI_DATA_TRANSFER:
//STRIP001 			Transfer ();
//STRIP001 			break;
//STRIP001         case TBI_DATA_INSERT_ROW:
//STRIP001 			aBrwData.InsertRow();
//STRIP001 			break;
//STRIP001         case TBI_DATA_INSERT_COL:
//STRIP001 			aBrwData.InsertColumn();
//STRIP001 			break;
//STRIP001         case TBI_DATA_DELETE_ROW:
//STRIP001 			aBrwData.RemoveRow();
//STRIP001 			break;
//STRIP001         case TBI_DATA_DELETE_COL:
//STRIP001 			aBrwData.RemoveColumn();
//STRIP001 			break;
//STRIP001         case TBI_DATA_SWAP_COL :
//STRIP001 			aBrwData.SwapColumn ();
//STRIP001 			break;
//STRIP001         case TBI_DATA_SWAP_ROW :
//STRIP001 			aBrwData.SwapRow ();
//STRIP001 			break;
//STRIP001         case TBI_DATA_SORT_COL :
//STRIP001 			aBrwData.QuickSortCol();
//STRIP001             break;
//STRIP001         case TBI_DATA_SORT_ROW :
//STRIP001 			aBrwData.QuickSortRow();
//STRIP001             break;
//STRIP001         case TBI_DATA_SORT_TABLE_COL :
//STRIP001 			aBrwData.QuickSortTableCols ();
//STRIP001             break;
//STRIP001         case TBI_DATA_SORT_TABLE_ROW :
//STRIP001 			aBrwData.QuickSortTableRows ();
//STRIP001             break;
//STRIP001     }
//STRIP001 
//STRIP001     if( ! bReadOnly )
//STRIP001 		aTbxData.EnableItem( TBI_DATA_TRANSFER, aBrwData.IsDirty() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // refresh toolbar icons according to currently selected cell in brwose box
//STRIP001 IMPL_LINK( SchDiagramDataWindow, BrowserCursorMovedHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001     if( bReadOnly )
//STRIP001         return 0;
//STRIP001 
//STRIP001 	aTbxData.EnableItem( TBI_DATA_INSERT_ROW, aBrwData.MayInsertRow() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_INSERT_COL, aBrwData.MayInsertColumn() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_DELETE_ROW, aBrwData.MayDeleteRow() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_DELETE_COL, aBrwData.MayDeleteColumn() );
//STRIP001 
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SWAP_COL,   aBrwData.MaySwapColumns() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SWAP_ROW,   aBrwData.MaySwapRows() );
//STRIP001 
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SORT_COL,       aBrwData.MaySortColumn() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SORT_ROW,       aBrwData.MaySortRow() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SORT_TABLE_COL, aBrwData.MaySortColumn() );
//STRIP001 	aTbxData.EnableItem( TBI_DATA_SORT_TABLE_ROW, aBrwData.MaySortRow() );
//STRIP001 
//STRIP001     aTbxData.EnableItem( TBI_DATA_TRANSFER,   aBrwData.IsDirty() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // disable all modifying controls
//STRIP001 void SchDiagramDataWindow::SetReadOnly(const BOOL b)
//STRIP001 {
//STRIP001 	bReadOnly=b;
//STRIP001 	if(bReadOnly)
//STRIP001 	{
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SORT_TABLE_ROW, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SORT_TABLE_COL, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_TRANSFER, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_INSERT_ROW, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_INSERT_COL, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_DELETE_ROW, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_DELETE_COL, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SWAP_COL, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SWAP_ROW, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SORT_COL, FALSE );
//STRIP001 		aTbxData.EnableItem( TBI_DATA_SORT_ROW, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001     aBrwData.SetReadOnly( bReadOnly );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SchDiagramDataWindow, MiscHdl, void*, p )
//STRIP001 {
//STRIP001    	SvtMiscOptions aMiscOptions;
//STRIP001     sal_Int16 nStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 
//STRIP001     aTbxData.SetOutStyle( nStyle );
//STRIP001 
//STRIP001     return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SchDiagramDataWindow, CellModified, void*, EMPTYARG )
//STRIP001 {
//STRIP001     aTbxData.EnableItem( TBI_DATA_TRANSFER, aBrwData.IsDirty() );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramDataWindow::UpdateData()
//STRIP001 {
//STRIP001 	SfxObjectShell * pShell = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if( pShell && pShell->ISA( SchChartDocShell ))
//STRIP001 	{
//STRIP001         // note: this is (in principle) a dynamic_cast
//STRIP001 		SchChartDocShell* pDocShell = static_cast< SchChartDocShell* >( pShell );
//STRIP001 		ChartModel* pModel = NULL;
//STRIP001 		BOOL bReadOnlyData = FALSE;
//STRIP001 
//STRIP001 		if( pDocShell )
//STRIP001 		{
//STRIP001 			pModel = & pDocShell->GetDoc();
//STRIP001 
//STRIP001 			SchMemChart* pMemChart=pModel->GetChartData();
//STRIP001 			if( pMemChart )
//STRIP001 				bReadOnlyData = pMemChart->IsReadOnly();
//STRIP001 		}
//STRIP001 
//STRIP001 		aBrwData.SetDataFromModel( pModel );
//STRIP001 		SetReadOnly( pDocShell->IsReadOnly() || bReadOnlyData );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // react on the change of the underlying document by displaying the new data
//STRIP001 void SchDiagramDataWindow::SFX_NOTIFY(
//STRIP001     SfxBroadcaster& rBC,
//STRIP001     const TypeId& rBCType,
//STRIP001     const SfxHint& rHint,
//STRIP001     const TypeId& rHintType )
//STRIP001 {
//STRIP001 	if( rHint.Type() == TYPE(SfxSimpleHint) )
//STRIP001     {
//STRIP001         // note: if dynamic_cast works this should be changed
//STRIP001         switch( static_cast< const SfxSimpleHint & >( rHint ).GetId())
//STRIP001 		{
//STRIP001 			case SFX_HINT_DOCCHANGED:
//STRIP001 				UpdateData();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_HINT_DYING:
//STRIP001 				break;
//STRIP001 		}
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SchDiagramDataWindow::Close()
//STRIP001 {
//STRIP001     BOOL bRet = TRUE;
//STRIP001 
//STRIP001     // confirm changes currently made and not saved
//STRIP001     aBrwData.EndEditing();
//STRIP001 
//STRIP001 	if( aBrwData.IsDirty() )
//STRIP001 	{
//STRIP001 		QueryBox aSafetyQuery( this, WB_YES_NO_CANCEL | WB_DEF_YES,
//STRIP001 							   String( SchResId( STR_DIAGRAM_DATA_SAFETY_QUERY )));
//STRIP001 		long nQueryResult = aSafetyQuery.Execute();
//STRIP001 
//STRIP001 		bRet = ( nQueryResult != RET_CANCEL );
//STRIP001 
//STRIP001 		if( nQueryResult == RET_YES )
//STRIP001 		{
//STRIP001 			// save changes
//STRIP001 			Transfer();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bRet )
//STRIP001 	{
//STRIP001 		// close child window
//STRIP001 		SfxBoolItem aItem( SID_DIAGRAM_DATA, FALSE );
//STRIP001 		if( pBindings )
//STRIP001 		{
//STRIP001 			SfxDispatcher* pDisp = pBindings->GetDispatcher();
//STRIP001 			if( pDisp )
//STRIP001 				pDisp->Execute( SID_DIAGRAM_DATA, SFX_CALLMODE_ASYNCHRON, &aItem, 0L);
//STRIP001 			else
//STRIP001 				DBG_ERROR( "Couldn't dispatch command" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( bRet? SfxFloatingWindow::Close(): FALSE );
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramDataWindow::Resize()
//STRIP001 {
//STRIP001     SfxFloatingWindow::Resize();
//STRIP001 
//STRIP001     Size aSize( PixelToLogic( GetResizeOutputSizePixel(), MAP_APPFONT ));
//STRIP001     Size aDataSize;
//STRIP001 
//STRIP001     aDataSize.setWidth( aSize.getWidth() - 12 );
//STRIP001     aDataSize.setHeight( aSize.getHeight() - 31 );
//STRIP001 
//STRIP001     aBrwData.SetSizePixel( LogicToPixel( aDataSize, MAP_APPFONT ));
//STRIP001 }
//STRIP001 
//STRIP001 // prevent reopening dialog for a new document
//STRIP001 void SchDiagramDataWindow::FillInfo( SfxChildWinInfo& rInfo ) const
//STRIP001 {
//STRIP001 	SfxFloatingWindow::FillInfo( rInfo );
//STRIP001 
//STRIP001 	rInfo.bVisible = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramDataWindow::Transfer()
//STRIP001 {
//STRIP001     // confirm changes currently made and not saved
//STRIP001     aBrwData.EndEditing();
//STRIP001 
//STRIP001     // note: if dynamic_cast works this should be changed
//STRIP001 	SchChartDocShell* pDocShell = static_cast< SchChartDocShell * >
//STRIP001         ( SfxObjectShell::Current());
//STRIP001 
//STRIP001 	if( pDocShell )
//STRIP001 	{
//STRIP001 		const SchMemChart* pData = aBrwData.GetData();
//STRIP001 		if( pData )
//STRIP001 		{
//STRIP001             // remember old model
//STRIP001 			ChartModel & rDoc = pDocShell->GetDoc();
//STRIP001             ::std::auto_ptr< SchModelData > apOldModelData( new SchModelData( rDoc ));
//STRIP001 
//STRIP001             // modify model
//STRIP001             rDoc.ChangeChartData( * new SchMemChart( *pData ), FALSE);
//STRIP001 
//STRIP001             // remember new model
//STRIP001             ::std::auto_ptr< SchModelData > apNewModelData( new SchModelData( rDoc ));
//STRIP001 
//STRIP001             // create undo-action
//STRIP001             SchUndoDiagramData * pUndo =
//STRIP001                 new SchUndoDiagramData( rDoc, apOldModelData, apNewModelData );
//STRIP001             pUndo->SetComment( String( SchResId( STR_UNDO_DIAGRAM_DATA )));
//STRIP001             pDocShell->GetUndoManager()->AddUndoAction( pUndo );
//STRIP001 
//STRIP001             aBrwData.SetClean();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // sets the correct toolbar icons depending on the current mode (e.g. high contrast)
//STRIP001 void SchDiagramDataWindow::ApplyImageList()
//STRIP001 {
//STRIP001     bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );
//STRIP001 
//STRIP001     ImageList& rImgLst = bIsHighContrast
//STRIP001         ? maToolboxImageListHighContrast
//STRIP001         : maToolboxImageList;
//STRIP001 
//STRIP001     aTbxData.SetImageList( rImgLst );
//STRIP001 }
//STRIP001 
//STRIP001 // add/remove a window (the toolbar) to/from the global list, so that F6
//STRIP001 // travels/no longer travels over this window.  _rMemFunc may be
//STRIP001 // TaskPaneList::AddWindow or TaskPaneList::RemoveWindow
//STRIP001 void SchDiagramDataWindow::notifySystemWindow(
//STRIP001     Window* _pWindow, Window* _pToRegister,
//STRIP001     ::comphelper::mem_fun1_t< TaskPaneList, Window* > _rMemFunc )
//STRIP001 {
//STRIP001 	OSL_ENSURE( _pWindow, "Window can not be null!" );
//STRIP001 	Window* pParent = _pWindow->GetParent();
//STRIP001 	while( pParent && ! pParent->IsSystemWindow() )
//STRIP001 	{
//STRIP001 		pParent = pParent->GetParent();
//STRIP001 	}
//STRIP001 	if ( pParent && pParent->IsSystemWindow())
//STRIP001 	{
//STRIP001 		SystemWindow* pSystemWindow = static_cast< SystemWindow* >( pParent );
//STRIP001 		_rMemFunc( pSystemWindow->GetTaskPaneList(),( _pToRegister ));
//STRIP001 	}
//STRIP001 }
}
