/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fader.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:08:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <math.h>
#include <stdlib.h>
#include <string.h>
// auto strip #include <tools/poly.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #include "fader.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "sdview.hxx"
#include "fuslshow.hxx"
#include <string>
#include <algorithm>
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------------

#define FADE_SPEED_SLOW_MS		1500UL
#define FADE_SPEED_MEDIUM_MS	 800UL
#define FADE_SPEED_FAST_MS		 300UL
#define FADESCROLL				(SCROLL_NOCHILDREN|SCROLL_NOERASE|SCROLL_NOINVALIDATE|SCROLL_NOWINDOWINVALIDATE)
#define TESTMAGIC()				if( FADER_MAGIC != nMagic ) return;
#define DIAG_WAIT(_def_eSpeed)	((FADE_SPEED_SLOW==(_def_eSpeed)) ? 30 : (FADE_SPEED_FAST==(_def_eSpeed)) ? 10 : 20)

// -----------------------------------------------------------------------------

//STRIP001 ULONG ImplGetUnitsPerSec( FadeSpeed eSpeed, ULONG nDist )
//STRIP001 {
//STRIP001 	ULONG nResult = nDist * 1000UL;
//STRIP001 
//STRIP001 	switch( eSpeed )
//STRIP001 	{
//STRIP001 		case( FADE_SPEED_SLOW ):
//STRIP001 			nResult /= FADE_SPEED_SLOW_MS;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( FADE_SPEED_MEDIUM ):
//STRIP001 			nResult /= FADE_SPEED_MEDIUM_MS;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( FADE_SPEED_FAST ):
//STRIP001 			nResult /= FADE_SPEED_FAST_MS;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nResult < 8 )
//STRIP001 		nResult = 8;
//STRIP001 
//STRIP001 	return nResult;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Fader::Fader( Window* pWindow, FuSlideShow* pShow ) :
//STRIP001 		pWin		( pWindow ),
//STRIP001 		pFuslShow	( pShow ),
//STRIP001 		pVDev		( NULL ),
//STRIP001 		pVDevOld	( NULL ),
//STRIP001 		eEffect		( presentation::FadeEffect_NONE ),
//STRIP001 		eSpeed		( FADE_SPEED_MEDIUM ),
//STRIP001 		nMagic		( FADER_MAGIC ),
//STRIP001 		nPushCount	( 0 ),
//STRIP001 		bPixelMode	( FALSE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Fader::~Fader()
//STRIP001 {
//STRIP001 	if( pWin )
//STRIP001 	{
//STRIP001 		while( nPushCount )
//STRIP001 		{
//STRIP001 			pWin->Pop();
//STRIP001 			nPushCount--;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nMagic = 0L;
//STRIP001 	SwitchToLogic();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* altes Bild als virtuelles Device setzen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::SetOldVirtualDevice( VirtualDevice* pDev )
//STRIP001 {
//STRIP001 	pVDevOld = pDev;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* neues Bild als virtuelles Device setzen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::SetNewVirtualDevice( VirtualDevice* pDev )
//STRIP001 {
//STRIP001 	pVDev = pDev;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ergibt die Schrittanzahl des Effektes fuer die uebergebene Geschwindigkeit
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 ULONG Fader::GetEffectSteps(FadeSpeed eSpeed) const
//STRIP001 {
//STRIP001 	ULONG nResult;
//STRIP001 
//STRIP001 	switch( eSpeed )
//STRIP001 	{
//STRIP001 		case FADE_SPEED_SLOW:	nResult = FADE_SPEED_SLOW_MS;	break;
//STRIP001 		case FADE_SPEED_MEDIUM: nResult = FADE_SPEED_MEDIUM_MS; break;
//STRIP001 		case FADE_SPEED_FAST:	nResult = FADE_SPEED_FAST_MS;	break;
//STRIP001 	}
//STRIP001 
//STRIP001 	nResult /= WAIT_IN_EFFECT_MS; // alle WAIT_IN_... ms ein Schritt
//STRIP001 
//STRIP001 	return nResult;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Warteroutine fuer die Zeitschleife im Ueberblendeffekt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::WaitInEffect( ULONG nMilliSeconds ) const
//STRIP001 {
//STRIP001 #ifdef WNT
//STRIP001 	Sleep( nMilliSeconds );
//STRIP001 #else
//STRIP001 	ULONG		nCurrent = Time::GetSystemTicks();
//STRIP001 	const ULONG	nEnd = nCurrent + nMilliSeconds;
//STRIP001 
//STRIP001 	while( nCurrent < nEnd )
//STRIP001 		nCurrent = Time::GetSystemTicks();
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* auf den Pixelmodus umstellen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::SwitchToPixel()
//STRIP001 {
//STRIP001 	if( !bPixelMode )
//STRIP001 	{
//STRIP001 		bPixelMode = TRUE;
//STRIP001 		aOldMMWin = pWin->GetMapMode();
//STRIP001 		aOldMMVDev = pVDev->GetMapMode();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 			aOldMMVDevOld = pVDevOld->GetMapMode();
//STRIP001 
//STRIP001 		aTarget = pWin->LogicToPixel(aTargetLog);
//STRIP001 		aSource = pVDev->LogicToPixel(aSourceLog);
//STRIP001 
//STRIP001 		Size aMinSize(aTarget.GetSize());
//STRIP001 		aMinSize.Width() = Min(aMinSize.Width(), aSource.GetWidth());
//STRIP001 		aMinSize.Height() = Min(aMinSize.Height(), aSource.GetHeight());
//STRIP001 		aSource.SetSize(aMinSize);
//STRIP001 		aTarget.SetSize(aMinSize);
//STRIP001 
//STRIP001 		MapMode aNewMM(aOldMMWin);
//STRIP001 		aNewMM.SetMapUnit(MAP_PIXEL);
//STRIP001 		Fraction aFrac(1, 1);
//STRIP001 		aNewMM.SetScaleX(aFrac);
//STRIP001 		aNewMM.SetScaleY(aFrac);
//STRIP001 		aNewMM.SetOrigin(Point(0, 0));
//STRIP001 
//STRIP001 		pWin->SetMapMode(aNewMM);
//STRIP001 		pVDev->SetMapMode(aNewMM);
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 			pVDevOld->SetMapMode( aNewMM );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* auf den logischen Koordinatenmodus umstellen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::SwitchToLogic()
//STRIP001 {
//STRIP001 	if( bPixelMode )
//STRIP001 	{
//STRIP001 		bPixelMode = FALSE;
//STRIP001 
//STRIP001 		if( pWin )
//STRIP001 			pWin->SetMapMode(aOldMMWin);
//STRIP001 
//STRIP001 		if( pVDev )
//STRIP001 			pVDev->SetMapMode(aOldMMVDev);
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 			pVDevOld->SetMapMode(aOldMMVDevOld);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Effekt durchfuehren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::Fade()
//STRIP001 
//STRIP001 {
//STRIP001 	DBG_ASSERT( pWin, "kein Fenster gesetzt" );
//STRIP001 	DBG_ASSERT( pVDev, "kein Quelldevice gesetzt" );
//STRIP001 	DBG_ASSERT( aSourceLog.GetSize() == aTargetLog.GetSize(), "Quell- und Zielbereich unterschiedlich gross" );
//STRIP001 
//STRIP001 	SdView*			pView;
//STRIP001 	BOOL			bGrid = FALSE;
//STRIP001 	const ULONG		nOldDrawMode = pWin->GetDrawMode();
//STRIP001 
//STRIP001 	if( pFuslShow && pFuslShow->GetAnimationMode() == ANIMATIONMODE_VIEW )
//STRIP001 	{
//STRIP001 		pView = pFuslShow->GetDocSh()->GetViewShell()->GetView();
//STRIP001 
//STRIP001 		if( pView->IsGridVisible() && pView->IsGridFront() )
//STRIP001 			bGrid = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	pWin->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 	SwitchToPixel();
//STRIP001 
//STRIP001 	switch( eEffect )
//STRIP001 	{
//STRIP001 		case presentation::FadeEffect_NONE:					None( FALSE ); break;
//STRIP001 		
//STRIP001 		case presentation::FadeEffect_FADE_FROM_LEFT:		FadeFromLeft(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_UPPERLEFT:	FadeFromUpperLeft(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_TOP:		FadeFromTop(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_UPPERRIGHT:	FadeFromUpperRight(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_RIGHT:		FadeFromRight(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_LOWERRIGHT:	FadeFromLowerRight(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_BOTTOM:		FadeFromBottom(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_LOWERLEFT:	FadeFromLowerLeft(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_LEFT:		MoveFromLeft(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_UPPERLEFT:	MoveFromUpperLeft(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_TOP:		MoveFromTop(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_UPPERRIGHT:	MoveFromUpperRight(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_RIGHT:		MoveFromRight(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_LOWERRIGHT:	MoveFromLowerRight(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_BOTTOM:		MoveFromBottom(); break;
//STRIP001 		case presentation::FadeEffect_MOVE_FROM_LOWERLEFT:	MoveFromLowerLeft(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_LEFT:		UncoverToLeft(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_UPPERLEFT:	UncoverToUpperLeft(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_TOP:		UncoverToTop(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_UPPERRIGHT:UncoverToUpperRight(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_RIGHT:		UncoverToRight(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_LOWERRIGHT:UncoverToLowerRight(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_BOTTOM:	UncoverToBottom(); break;
//STRIP001 		case presentation::FadeEffect_UNCOVER_TO_LOWERLEFT:	UncoverToLowerLeft(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_ROLL_FROM_LEFT:		RollFromLeft(); break;
//STRIP001 		case presentation::FadeEffect_ROLL_FROM_TOP:		RollFromTop(); break;
//STRIP001 		case presentation::FadeEffect_ROLL_FROM_RIGHT:		RollFromRight(); break;
//STRIP001 		case presentation::FadeEffect_ROLL_FROM_BOTTOM:		RollFromBottom(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_FADE_TO_CENTER:		FadeToCenter(); break;
//STRIP001 		case presentation::FadeEffect_FADE_FROM_CENTER:		FadeFromCenter(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_VERTICAL_STRIPES:		VerticalStripes(); break;
//STRIP001 		case presentation::FadeEffect_HORIZONTAL_STRIPES:	HorizontalStripes(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_HORIZONTAL_LINES:     HorizontalLines(); break;
//STRIP001 		case presentation::FadeEffect_VERTICAL_LINES:       VerticalLines(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_VERTICAL_CHECKERBOARD:	VerticalCheckerboard(); break;
//STRIP001 		case presentation::FadeEffect_HORIZONTAL_CHECKERBOARD:	HorizontalCheckerboard(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_CLOCKWISE:			Clockwise(); break;
//STRIP001 		case presentation::FadeEffect_COUNTERCLOCKWISE:		CounterClockwise(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_CLOSE_VERTICAL:		CloseVertical(); break;
//STRIP001 		case presentation::FadeEffect_CLOSE_HORIZONTAL:		CloseHorizontal(); break;
//STRIP001 		case presentation::FadeEffect_OPEN_VERTICAL:		OpenVertical(); break;
//STRIP001 		case presentation::FadeEffect_OPEN_HORIZONTAL:		OpenHorizontal(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_SPIRALIN_LEFT:		CellsSpiralInClockwise(); break;
//STRIP001 		case presentation::FadeEffect_SPIRALIN_RIGHT:		CellsSpiralInCounterClockwise(); break;
//STRIP001 		case presentation::FadeEffect_SPIRALOUT_LEFT:		CellsSpiralOutClockwise(); break;
//STRIP001 		case presentation::FadeEffect_SPIRALOUT_RIGHT:		CellsSpiralOutCounterClockwise(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_DISSOLVE:				CellsRandom(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_WAVYLINE_FROM_LEFT:	CellsWavyLineFromLeft(); break;
//STRIP001 		case presentation::FadeEffect_WAVYLINE_FROM_TOP:	CellsWavyLineFromTop(); break;
//STRIP001 		case presentation::FadeEffect_WAVYLINE_FROM_RIGHT:	CellsWavyLineFromRight(); break;
//STRIP001 		case presentation::FadeEffect_WAVYLINE_FROM_BOTTOM:	CellsWavyLineFromBottom(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_RANDOM:				RandomEffect(); break;
//STRIP001 
//STRIP001 		case presentation::FadeEffect_STRETCH_FROM_LEFT:    StretchFromLeft(); break;
//STRIP001 		case presentation::FadeEffect_STRETCH_FROM_TOP:     StretchFromTop(); break;
//STRIP001 		case presentation::FadeEffect_STRETCH_FROM_RIGHT:   StretchFromRight(); break;
//STRIP001 		case presentation::FadeEffect_STRETCH_FROM_BOTTOM:  StretchFromBottom(); break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			None( TRUE ); 
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// nicht im Reschedule des Effekts zerstoert?
//STRIP001 	if( nMagic == FADER_MAGIC )
//STRIP001 	{
//STRIP001 		SwitchToLogic();
//STRIP001 		pWin->SetDrawMode( nOldDrawMode );
//STRIP001         pWin->Sync();
//STRIP001 
//STRIP001 		if( bGrid )
//STRIP001 			pView->GetPageView( (SdrPage*) pFuslShow->GetActualPage() )->DrawGrid( *pWin, pView->GetGridColor() );
//STRIP001 	}
//STRIP001 }
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden ohne Effekt
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::None( BOOL bWithBeep )
//STRIP001 {
//STRIP001 	if( bWithBeep )
//STRIP001 		Sound::Beep();
//STRIP001 
//STRIP001 	pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 					  aSource.TopLeft(), aSource.GetSize(), *pVDev);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Move
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::MoveFromLeft()
//STRIP001 {
//STRIP001 	long		nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alten Hintergrund zeichnen, wenn vorhanden
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 						 *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( nOffset < aTarget.GetWidth() )
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 		Size  aSize;
//STRIP001 
//STRIP001 		if (!pVDevOld)
//STRIP001 		{
//STRIP001 			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
//STRIP001 			// Streifen dazuzeichnen
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Right() = aTarget.Left() + nOffset - 1;
//STRIP001 			pWin->Scroll( nThisStep, 0, aScroll, FADESCROLL );
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()   = nThisStep;
//STRIP001 			aSize.Height()  = aTarget.GetHeight();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()  = nOffset;
//STRIP001 			aSize.Height() =  aTarget.GetHeight();
//STRIP001 		}
//STRIP001 
//STRIP001 		pWin->DrawOutDev(
//STRIP001 				aTarget.TopLeft(), aSize,
//STRIP001 				Point(aSource.Right() - nOffset + 1, aSource.Top()), aSize,
//STRIP001 				*pVDev);
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromUpperLeft()
//STRIP001 {
//STRIP001 	const double fDiag = FRound( hypot( aTarget.GetWidth(), aTarget.GetHeight() ) );
//STRIP001 
//STRIP001 	if( fDiag > 0.0 )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		const long	nRight = aSource.Right(), nBottom = aSource.Bottom();
//STRIP001 		const long	nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight();
//STRIP001 		long		nOffset = 0L, nCurX, nCurY;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			const double fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			const Point aSrcPt( nRight - nCurX, nBottom - nCurY );
//STRIP001 			const Size	aSrcSz( nCurX + 1, nCurY + 1 );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aSrcSz, aSrcPt, aSrcSz, *pVDev );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromTop()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alten Hintergrund zeichnen, wenn vorhanden
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 						 *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nOffset < aTarget.GetHeight())
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 		Size  aSize;
//STRIP001 
//STRIP001 		if (!pVDevOld)
//STRIP001 		{
//STRIP001 			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
//STRIP001 			// Streifen dazuzeichnen
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Bottom() = aTarget.Top() + nOffset - 1;
//STRIP001 			pWin->Scroll( 0, nThisStep, aScroll, FADESCROLL );
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()  = aTarget.GetWidth();
//STRIP001 			aSize.Height() = nThisStep;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()  = aTarget.GetWidth();
//STRIP001 			aSize.Height() = nOffset;
//STRIP001 		}
//STRIP001 
//STRIP001 		pWin->DrawOutDev(
//STRIP001 				aTarget.TopLeft(), aSize,
//STRIP001 				Point(aSource.Left(), aSource.Bottom() - nOffset + 1), aSize,
//STRIP001 				*pVDev);
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromUpperRight()
//STRIP001 {
//STRIP001 	const double fDiag = FRound( hypot( aTarget.GetWidth(), aTarget.GetHeight() ) );
//STRIP001 
//STRIP001 	if( fDiag > 0.0 )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		const long	nRight = aSource.Right(), nBottom = aSource.Bottom();
//STRIP001 		const long	nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight();
//STRIP001 		long		nOffset = 0L, nCurX, nCurY;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			const double fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			const Point aSrcPt( 0, nBottom - nCurY );
//STRIP001 			const Point aDstPt( aTarget.Right() - nCurX, aTarget.Top() );
//STRIP001 			const Size	aSrcSz( nCurX + 1, nCurY + 1 );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aDstPt, aSrcSz, aSrcPt, aSrcSz, *pVDev );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromRight()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alten Hintergrund zeichnen, wenn vorhanden
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 						 *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( nOffset < aTarget.GetWidth() )
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 		Size  aSize;
//STRIP001 
//STRIP001 		if (!pVDevOld)
//STRIP001 		{
//STRIP001 			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
//STRIP001 			// Streifen dazuzeichnen
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Left() = aTarget.Right() - nOffset + 1;
//STRIP001 			pWin->Scroll( -(long)nThisStep, 0, aScroll, FADESCROLL );
//STRIP001 			aSize.Width() = nThisStep;
//STRIP001 			aSize.Height() = aTarget.GetHeight();
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					Point(aTarget.Right() - nThisStep + 1, aTarget.Top()),aSize,
//STRIP001 					Point(aSource.Left() + nOffset, aSource.Top()), aSize,
//STRIP001 					*pVDev);
//STRIP001 			nOffset += nThisStep;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()  = nOffset;
//STRIP001 			aSize.Height() =  aTarget.GetHeight();
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					Point(aTarget.Right() - nOffset + 1, aTarget.Top()), aSize,
//STRIP001 					aSource.TopLeft(), aSize,
//STRIP001 					*pVDev);
//STRIP001 		}
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromLowerRight()
//STRIP001 {
//STRIP001 	const double fDiag = FRound( hypot( aTarget.GetWidth(), aTarget.GetHeight() ) );
//STRIP001 
//STRIP001 	if( fDiag > 0.0 )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		const long	nRight = aSource.Right(), nBottom = aSource.Bottom();
//STRIP001 		const long	nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight();
//STRIP001 		long		nOffset = 0L, nCurX, nCurY;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			const double fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			const Point aSrcPt( 0, 0 );
//STRIP001 			const Point aDstPt( aTarget.Right() - nCurX, aTarget.Bottom() - nCurY );
//STRIP001 			const Size	aSrcSz( nCurX + 1, nCurY + 1 );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aDstPt, aSrcSz, aSrcPt, aSrcSz, *pVDev );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromBottom()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alten Hintergrund zeichnen, wenn vorhanden
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 						 *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nOffset < aTarget.GetHeight())
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 		Size  aSize;
//STRIP001 
//STRIP001 		if (!pVDevOld)
//STRIP001 		{
//STRIP001 			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
//STRIP001 			// Streifen dazuzeichnen
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Top() = aTarget.Bottom() - nOffset + 1;
//STRIP001 			pWin->Scroll( 0, -(long)nThisStep, aScroll, FADESCROLL );
//STRIP001 			aSize.Width() = aTarget.GetWidth();
//STRIP001 			aSize.Height() = nThisStep;
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					Point(aTarget.Left(), aTarget.Bottom() - nThisStep + 1),aSize,
//STRIP001 					Point(aSource.Left(), aSource.Top() + nOffset), aSize,
//STRIP001 					*pVDev);
//STRIP001 			nOffset += nThisStep;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
//STRIP001 			nOffset += nThisStep;
//STRIP001 			aSize.Width()  = aTarget.GetWidth();
//STRIP001 			aSize.Height() = nOffset;
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					Point(aTarget.Left(), aTarget.Bottom() - nOffset + 1), aSize,
//STRIP001 					aSource.TopLeft(), aSize,
//STRIP001 					*pVDev);
//STRIP001 		}
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::MoveFromLowerLeft()
//STRIP001 {
//STRIP001 	const double fDiag = FRound( hypot( aTarget.GetWidth(), aTarget.GetHeight() ) );
//STRIP001 
//STRIP001 	if( fDiag > 0.0 )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		const long	nRight = aSource.Right(), nBottom = aSource.Bottom();
//STRIP001 		const long	nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight();
//STRIP001 		long		nOffset = 0L, nCurX, nCurY;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			const double fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			const Point aSrcPt( nRight - nCurX, 0 );
//STRIP001 			const Point aDstPt( aTarget.Left(), aTarget.Bottom() - nCurY );
//STRIP001 			const Size	aSrcSz( nCurX + 1, nCurY + 1 );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aDstPt, aSrcSz, aSrcPt, aSrcSz, *pVDev );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Uncover
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::UncoverToLeft()
//STRIP001 {
//STRIP001 	long			nCurX = 0, nWidth = aSource.GetWidth(), nRight = nWidth - 1;
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( nWidth && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nWidth ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			nCurX += nStep;
//STRIP001 			nCurX = Min( nCurX, nRight );
//STRIP001 
//STRIP001 			Size aSizeOfNew( nCurX + 1, aTarget.GetHeight() );
//STRIP001 			Size aSizeOfOld( nWidth - aSizeOfNew.Width(), aSizeOfNew.Height() );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( Point( aTarget.Left() + aSizeOfOld.Width(), aTarget.Top() ), aSizeOfNew,
//STRIP001 							  Point( aSource.Left() + aSizeOfOld.Width(), aSource.Top() ), aSizeOfNew,
//STRIP001 							  *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aSizeOfOld,
//STRIP001 							  Point( aSource.Left() + nCurX, aSource.Top() ), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurX < nRight );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToUpperLeft()
//STRIP001 {
//STRIP001 	long			nOffset = 0, nCurX = 0, nCurY = 0;
//STRIP001 	const long		nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight(), nRight = nWidth - 1, nBottom = nHeight - 1;
//STRIP001 	const double	fDiag = hypot( nWidth, nHeight );
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( ( fDiag > 0.0 ) && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Region			aClip( aTarget );
//STRIP001 			const double	fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			Size		aSizeOfNewX( nCurX + 1, nHeight );
//STRIP001 			Size		aSizeOfNewY( nWidth, nCurY + 1 );
//STRIP001 			Size		aSizeOfOld( nWidth - aSizeOfNewX.Width(), nHeight - aSizeOfNewY.Height() );
//STRIP001 			Rectangle	aOldRect( aTarget.TopLeft(), aSizeOfOld );
//STRIP001 
//STRIP001 			pWin->Push( PUSH_CLIPREGION );
//STRIP001 			aClip.Exclude( aOldRect );
//STRIP001 			pWin->IntersectClipRegion( aClip );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							  *pVDev);
//STRIP001 			pWin->Pop();
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aOldRect.TopLeft(), aSizeOfOld,
//STRIP001 							  Point( aSource.Left() + aSizeOfNewX.Width(), aSource.Top() + aSizeOfNewY.Height() ), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToTop()
//STRIP001 {
//STRIP001 	long			nCurY = 0, nHeight = aSource.GetHeight(), nBottom = nHeight - 1;
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( nHeight && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nHeight ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			nCurY += nStep;
//STRIP001 			nCurY = Min( nCurY, nBottom );
//STRIP001 
//STRIP001 			Size aSizeOfNew( aTarget.GetWidth(), nCurY + 1 );
//STRIP001 			Size aSizeOfOld( aSizeOfNew.Width(), nHeight - aSizeOfNew.Height() );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( Point( aTarget.Left(), aTarget.Top() + aSizeOfOld.Height() ), aSizeOfNew,
//STRIP001 							  Point( aSource.Left(), aSource.Top() + aSizeOfOld.Height() ), aSizeOfNew,
//STRIP001 							  *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aSizeOfOld,
//STRIP001 							  Point( aSource.Left(), aSource.Top() + nCurY ), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurY < nBottom );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToUpperRight()
//STRIP001 {
//STRIP001 	long			nOffset = 0, nCurX = 0, nCurY = 0;
//STRIP001 	const long		nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight(), nRight = nWidth - 1, nBottom = nHeight - 1;
//STRIP001 	const double	fDiag = hypot( nWidth, nHeight );
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( ( fDiag > 0.0 ) && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Region			aClip( aTarget );
//STRIP001 			const double	fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			Size		aSizeOfNewX( nCurX + 1, nHeight );
//STRIP001 			Size		aSizeOfNewY( nWidth, nCurY + 1 );
//STRIP001 			Size		aSizeOfOld( nWidth - aSizeOfNewX.Width(), nHeight - aSizeOfNewY.Height() );
//STRIP001 			Rectangle	aOldRect( Point( aTarget.Left() + aSizeOfNewX.Width(), aTarget.Top() ), aSizeOfOld );
//STRIP001 
//STRIP001 			pWin->Push( PUSH_CLIPREGION );
//STRIP001 			aClip.Exclude( aOldRect );
//STRIP001 			pWin->IntersectClipRegion( aClip );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							  *pVDev);
//STRIP001 			pWin->Pop();
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aOldRect.TopLeft(), aSizeOfOld,
//STRIP001 							  Point( aSource.Left(), aSource.Top() + aSizeOfNewY.Height() ), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToRight()
//STRIP001 {
//STRIP001 	long			nCurX = 0, nWidth = aSource.GetWidth(), nRight = nWidth - 1;
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( nWidth && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nWidth ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			nCurX += nStep;
//STRIP001 			nCurX = Min( nCurX, nRight );
//STRIP001 
//STRIP001 			Size aSizeOfNew( nCurX + 1, aTarget.GetHeight() );
//STRIP001 			Size aSizeOfOld( nWidth - aSizeOfNew.Width(), aSizeOfNew.Height() );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aSizeOfNew,
//STRIP001 							  aSource.TopLeft(), aSizeOfNew,
//STRIP001 							  *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev( Point( aTarget.Left() + aSizeOfNew.Width(), aTarget.Top() ), aSizeOfOld,
//STRIP001 							  aSource.TopLeft(), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurX < nRight );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToLowerRight()
//STRIP001 {
//STRIP001 	long			nOffset = 0, nCurX = 0, nCurY = 0;
//STRIP001 	const long		nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight(), nRight = nWidth - 1, nBottom = nHeight - 1;
//STRIP001 	const double	fDiag = hypot( nWidth, nHeight );
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( ( fDiag > 0.0 ) && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Region			aClip( aTarget );
//STRIP001 			const double	fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			Size		aSizeOfNewX( nCurX + 1, nHeight );
//STRIP001 			Size		aSizeOfNewY( nWidth, nCurY + 1 );
//STRIP001 			Size		aSizeOfOld( nWidth - aSizeOfNewX.Width(), nHeight - aSizeOfNewY.Height() );
//STRIP001 			Rectangle	aOldRect( Point( aTarget.Left() + aSizeOfNewX.Width(), aTarget.Top() + aSizeOfNewY.Height() ), aSizeOfOld );
//STRIP001 
//STRIP001 			pWin->Push( PUSH_CLIPREGION );
//STRIP001 			aClip.Exclude( aOldRect );
//STRIP001 			pWin->IntersectClipRegion( aClip );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							  *pVDev);
//STRIP001 			pWin->Pop();
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aOldRect.TopLeft(), aSizeOfOld,
//STRIP001 							  aSource.TopLeft(), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToBottom()
//STRIP001 {
//STRIP001 	long			nCurY = 0, nHeight = aSource.GetHeight(), nBottom = nHeight - 1;
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( nHeight && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nHeight ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			nCurY += nStep;
//STRIP001 			nCurY = Min( nCurY, nBottom );
//STRIP001 
//STRIP001 			Size aSizeOfNew( aTarget.GetWidth(), nCurY + 1 );
//STRIP001 			Size aSizeOfOld( aSizeOfNew.Width(), nHeight - aSizeOfNew.Height() );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aSizeOfNew,
//STRIP001 							  aSource.TopLeft(), aSizeOfNew,
//STRIP001 							  *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev( Point( aTarget.Left(), aTarget.Top() + aSizeOfNew.Height() ), aSizeOfOld,
//STRIP001 							  aSource.TopLeft(), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurY < nBottom );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::UncoverToLowerLeft()
//STRIP001 {
//STRIP001 	long			nOffset = 0, nCurX = 0, nCurY = 0;
//STRIP001 	const long		nWidth = aSource.GetWidth(), nHeight = aSource.GetHeight(), nRight = nWidth - 1, nBottom = nHeight - 1;
//STRIP001 	const double	fDiag = hypot( nWidth, nHeight );
//STRIP001 	VirtualDevice	aOld( *pWin );
//STRIP001 
//STRIP001 	if( ( fDiag > 0.0 ) && aOld.SetOutputSizePixel( aSource.GetSize() ) )
//STRIP001 	{
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, FRound( fDiag ) ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							 *pVDevOld );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  Point(), aSource.GetSize(), 
//STRIP001 							  aOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aOld.DrawOutDev( Point(), aSource.GetSize(), 
//STRIP001 							 aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 *pWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Region			aClip( aTarget );
//STRIP001 			const double	fTau = ( nOffset += nStep ) / fDiag;
//STRIP001 
//STRIP001 			nCurX = Min( nRight, FRound( fTau * nRight ) );
//STRIP001 			nCurY = Min( nBottom, FRound( fTau * nBottom ) );
//STRIP001 
//STRIP001 			Size		aSizeOfNewX( nCurX + 1, nHeight );
//STRIP001 			Size		aSizeOfNewY( nWidth, nCurY + 1 );
//STRIP001 			Size		aSizeOfOld( nWidth - aSizeOfNewX.Width(), nHeight - aSizeOfNewY.Height() );
//STRIP001 			Rectangle	aOldRect( Point( aTarget.Left(), aTarget.Top() + aSizeOfNewY.Height() ), aSizeOfOld );
//STRIP001 
//STRIP001 			pWin->Push( PUSH_CLIPREGION );
//STRIP001 			aClip.Exclude( aOldRect );
//STRIP001 			pWin->IntersectClipRegion( aClip );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(),
//STRIP001 							  *pVDev);
//STRIP001 			pWin->Pop();
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aOldRect.TopLeft(), aSizeOfOld,
//STRIP001 							  Point( aSource.Left() + aSizeOfNewX.Width(), aSource.Top() ), aSizeOfOld,
//STRIP001 							  aOld );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( ( nCurX < nRight ) || ( nCurY < nBottom ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von links druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromLeft()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( nOffset != aTarget.GetWidth() )
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ( (long) nStep, aTarget.GetWidth() - nOffset );
//STRIP001 
//STRIP001 		nOffset += nThisStep;
//STRIP001 
//STRIP001 		Size aSize( nThisStep, aTarget.GetHeight() );
//STRIP001 
//STRIP001 		pWin->DrawOutDev(
//STRIP001 			Point(aTarget.Left() + nOffset - nThisStep, aTarget.Top()), aSize,
//STRIP001 			Point(aSource.Left() + nOffset - nThisStep, aSource.Top()), aSize,
//STRIP001 			*pVDev);
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ueberblenden von links oben
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromUpperLeft()
//STRIP001 {
//STRIP001 	const long	nMaxX = aTarget.GetWidth() + aTarget.GetHeight();
//STRIP001 	const long	nExt = Max( nMaxX / 30L, 10L );
//STRIP001 	const Size	aSize( nExt, nExt );
//STRIP001 	long		nStartX = 0, nStartY = 0;
//STRIP001 	long		nX, nY;
//STRIP001 	const ULONG	nWait = DIAG_WAIT( eSpeed );
//STRIP001 
//STRIP001 	pWin->Push( PUSH_CLIPREGION );
//STRIP001 	nPushCount++;
//STRIP001 
//STRIP001 	pWin->IntersectClipRegion( aTarget );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		nX = nStartX, nY = nStartY, nStartX += nExt;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Point aDstPt( nX + aTarget.Left(), nY + aTarget.Top() );
//STRIP001 
//STRIP001 			if( !Rectangle( aDstPt, aSize ).Intersection( aTarget ).IsEmpty() )
//STRIP001 				pWin->DrawOutDev( aDstPt, aSize, Point( nX + aSource.Left(), nY + aSource.Top() ), aSize, *pVDev );
//STRIP001 
//STRIP001 			nX -= nExt, nY += nExt;
//STRIP001 		}
//STRIP001 		while( nX >= 0 );
//STRIP001 
//STRIP001 		pWin->Sync();
//STRIP001 		WaitInEffect( nWait );
//STRIP001 		Application::Reschedule();
//STRIP001 
//STRIP001 		if( FADER_MAGIC != nMagic )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	while( nStartX <= nMaxX );
//STRIP001 
//STRIP001 	pWin->Pop();
//STRIP001 	nPushCount--;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von oben druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromTop()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nOffset != aTarget.GetHeight())
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::max( std::min ((long)nStep, aTarget.GetHeight() - nOffset), 0L );
//STRIP001 
//STRIP001 		Size aSize(aTarget.GetWidth(), nThisStep);
//STRIP001 
//STRIP001 		pWin->DrawOutDev(Point(aTarget.Left(), aTarget.Top() + nOffset), aSize,
//STRIP001 						 Point(aSource.Left(), aSource.Top() + nOffset), aSize,
//STRIP001 						 *pVDev);
//STRIP001 
//STRIP001 		nOffset += nThisStep;
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ueberblenden von rechts oben
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromUpperRight()
//STRIP001 {
//STRIP001 	const long	nWidth = aTarget.GetWidth();
//STRIP001 	const long	nMaxX = nWidth + aTarget.GetHeight();
//STRIP001 	const long	nExt = Max( nMaxX / 30L, 10L );
//STRIP001 	const Size	aSize( nExt, nExt );
//STRIP001 	long		nStartX = nWidth - nExt, nStartY = 0;
//STRIP001 	long		nFirstX = nStartX - nMaxX;
//STRIP001 	long		nX, nY;
//STRIP001 	const ULONG	nWait = DIAG_WAIT( eSpeed );
//STRIP001 
//STRIP001 	pWin->Push( PUSH_CLIPREGION );
//STRIP001 	nPushCount++;
//STRIP001 
//STRIP001 	pWin->IntersectClipRegion( aTarget );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		nX = nStartX, nY = nStartY, nStartX -= nExt;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Rectangle		aSrcRect( Point( nX + aSource.Left(), nY + aSource.Top() ), aSize );
//STRIP001 			const Rectangle aTmpSrc( aSrcRect );
//STRIP001 			
//STRIP001 			aSrcRect.Intersection( aSource );
//STRIP001 
//STRIP001 			if( !aSrcRect.IsEmpty() )
//STRIP001 			{
//STRIP001 				Size		aSrcSize( aSize );
//STRIP001 				Rectangle	aDstRect( Point( nX + aTarget.Left(), nY + aTarget.Top() ), aSrcSize );
//STRIP001 
//STRIP001 				if( aSrcRect.Left() > aTmpSrc.Left() )
//STRIP001 				{
//STRIP001 					const long nDiff = aSrcRect.Left() - aTmpSrc.Left();
//STRIP001 					aSrcSize.Width() -= nDiff;
//STRIP001 					aDstRect.Left() += nDiff;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !aDstRect.GetIntersection( aTarget ).IsEmpty() )
//STRIP001 					pWin->DrawOutDev( aDstRect.TopLeft(), aSrcSize, aSrcRect.TopLeft(), aSrcSize, *pVDev );
//STRIP001 			}
//STRIP001 
//STRIP001 			nX += nExt, nY += nExt;
//STRIP001 		}
//STRIP001 		while( nX < nWidth );
//STRIP001 
//STRIP001 		pWin->Sync();
//STRIP001 		WaitInEffect( nWait );
//STRIP001 		Application::Reschedule();
//STRIP001 
//STRIP001 		if( FADER_MAGIC != nMagic )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	while( nStartX >= nFirstX );
//STRIP001 
//STRIP001 	pWin->Pop();
//STRIP001 	nPushCount--;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von rechts druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromRight()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nOffset != aTarget.GetWidth())
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 
//STRIP001 		nOffset += nThisStep;
//STRIP001 
//STRIP001 		Size aSize(nThisStep, aTarget.GetHeight());
//STRIP001 
//STRIP001 		pWin->DrawOutDev(
//STRIP001 				Point(aTarget.Right() + 1 - nOffset, aTarget.Top()), aSize,
//STRIP001 				Point(aSource.Right() + 1 - nOffset, aSource.Top()), aSize,
//STRIP001 					  *pVDev);
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ueberblenden von rechts unten
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromLowerRight()
//STRIP001 {
//STRIP001 	const long	nWidth = aTarget.GetWidth();
//STRIP001 	const long	nMaxX = nWidth + aTarget.GetHeight();
//STRIP001 	const long	nExt = Max( nMaxX / 30L, 10L );
//STRIP001 	const Size	aSize( nExt, nExt );
//STRIP001 	long		nStartX = nWidth - nExt, nStartY = aTarget.GetHeight() - nExt;
//STRIP001 	long		nFirstX = nStartX - nMaxX;
//STRIP001 	long		nLastY = -nExt;
//STRIP001 	long		nX, nY;
//STRIP001 	const ULONG	nWait = DIAG_WAIT( eSpeed );
//STRIP001 
//STRIP001 	pWin->Push( PUSH_CLIPREGION );
//STRIP001 	nPushCount++;
//STRIP001 
//STRIP001 	pWin->IntersectClipRegion( aTarget );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		nX = nStartX, nY = nStartY, nStartX -= nExt;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Rectangle		aSrcRect( Point( nX + aSource.Left(), nY + aSource.Top() ), aSize );
//STRIP001 			const Rectangle aTmpSrc( aSrcRect );
//STRIP001 			
//STRIP001 			aSrcRect.Intersection( aSource );
//STRIP001 
//STRIP001 			if( !aSrcRect.IsEmpty() )
//STRIP001 			{
//STRIP001 				Size		aSrcSize( aSize );
//STRIP001 				Rectangle	aDstRect( Point( nX + aTarget.Left(), nY + aTarget.Top() ), aSrcSize );
//STRIP001 
//STRIP001 				if( aSrcRect.Left() > aTmpSrc.Left() )
//STRIP001 				{
//STRIP001 					const long nDiff = aSrcRect.Left() - aTmpSrc.Left();
//STRIP001 					aSrcSize.Width() -= nDiff;
//STRIP001 					aDstRect.Left() += nDiff;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( aSrcRect.Top() > aTmpSrc.Top() )
//STRIP001 				{
//STRIP001 					const long nDiff = aSrcRect.Top() - aTmpSrc.Top();
//STRIP001 					aSrcSize.Height() -= nDiff;
//STRIP001 					aDstRect.Top() += nDiff;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !aDstRect.GetIntersection( aTarget ).IsEmpty() )
//STRIP001 					pWin->DrawOutDev( aDstRect.TopLeft(), aSrcSize, aSrcRect.TopLeft(), aSrcSize, *pVDev );
//STRIP001 			}
//STRIP001 
//STRIP001 			nX += nExt, nY -= nExt;
//STRIP001 		}
//STRIP001 		while( nY >= nLastY );
//STRIP001 
//STRIP001 		pWin->Sync();
//STRIP001 		WaitInEffect( nWait );
//STRIP001 		Application::Reschedule();
//STRIP001 
//STRIP001 		if( FADER_MAGIC != nMagic )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	while( nStartX >= nFirstX );
//STRIP001 
//STRIP001 	pWin->Pop();
//STRIP001 	nPushCount--;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von unten druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromBottom()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nOffset != aTarget.GetHeight())
//STRIP001 	{
//STRIP001 		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 
//STRIP001 		nOffset += nThisStep;
//STRIP001 
//STRIP001 		Size aSize(aTarget.GetWidth(), nThisStep);
//STRIP001 
//STRIP001 		pWin->DrawOutDev(
//STRIP001 				Point(aTarget.Left(), aTarget.Bottom() + 1 - nOffset), aSize,
//STRIP001 				Point(aSource.Left(), aSource.Bottom() + 1 - nOffset), aSize,
//STRIP001 				*pVDev);
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ueberblenden von links unten
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromLowerLeft()
//STRIP001 {
//STRIP001 	const long	nMaxX = aTarget.GetWidth() + aTarget.GetHeight();
//STRIP001 	const long	nExt = Max( nMaxX / 30L, 10L );
//STRIP001 	const Size	aSize( nExt, nExt );
//STRIP001 	const long	nLastX = nMaxX + nExt;
//STRIP001 	const long	nLastY = -nExt;
//STRIP001 	long		nStartX = 0, nStartY = aTarget.GetHeight() - nExt;
//STRIP001 	long		nX, nY;
//STRIP001 	const ULONG	nWait = DIAG_WAIT( eSpeed );
//STRIP001 
//STRIP001 	pWin->Push( PUSH_CLIPREGION );
//STRIP001 	nPushCount++;
//STRIP001 
//STRIP001 	pWin->IntersectClipRegion( aTarget );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		nX = nStartX, nY = nStartY, nStartX += nExt;
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			Rectangle		aSrcRect( Point( nX + aSource.Left(), nY + aSource.Top() ), aSize );
//STRIP001 			const Rectangle aTmpSrc( aSrcRect );
//STRIP001 			
//STRIP001 			aSrcRect.Intersection( aSource );
//STRIP001 
//STRIP001 			if( !aSrcRect.IsEmpty() )
//STRIP001 			{
//STRIP001 				Size		aSrcSize( aSize );
//STRIP001 				Rectangle	aDstRect( Point( nX + aTarget.Left(), nY + aTarget.Top() ), aSrcSize );
//STRIP001 
//STRIP001 				if( aSrcRect.Top() > aTmpSrc.Top() )
//STRIP001 				{
//STRIP001 					const long nDiff = aSrcRect.Top() - aTmpSrc.Top();
//STRIP001 					aSrcSize.Height() -= nDiff;
//STRIP001 					aDstRect.Top() += nDiff;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !aDstRect.GetIntersection( aTarget ).IsEmpty() )
//STRIP001 					pWin->DrawOutDev( aDstRect.TopLeft(), aSrcSize, aSrcRect.TopLeft(), aSrcSize, *pVDev );
//STRIP001 			}
//STRIP001 
//STRIP001 			nX -= nExt, nY -= nExt;
//STRIP001 		}
//STRIP001 		while( nY >= nLastY );
//STRIP001 
//STRIP001 		pWin->Sync();
//STRIP001 		WaitInEffect( nWait );
//STRIP001 		Application::Reschedule();
//STRIP001 
//STRIP001 		if( FADER_MAGIC != nMagic )		
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	while( nStartX <= nLastX );
//STRIP001 
//STRIP001 	pWin->Pop();
//STRIP001 	nPushCount--;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von der Mitte aus druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeFromCenter()
//STRIP001 {
//STRIP001 	const long		nWidth = aTarget.GetWidth();
//STRIP001 	const double	fFact = (double) aTarget.GetHeight() / ( nWidth ? nWidth : 1 );
//STRIP001 	const Point		aCenter( aTarget.Left() + ( nWidth >> 1 ), aTarget.Top() + ( aTarget.GetHeight() >> 1 ) );
//STRIP001 	Rectangle		aRect;
//STRIP001 	ULONG			nHorStep = 0UL, nVertStep = 0UL;
//STRIP001 	BOOL			bEnd = FALSE;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nWidth ) );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( !bEnd )
//STRIP001 	{
//STRIP001 		bEnd = ( aRect.Left() <= aTarget.Left() ) && ( aRect.Top() <= aTarget.Top() ) &&
//STRIP001 			   ( aRect.Right() >= aTarget.Right() ) && ( aRect.Bottom() >= aTarget.Bottom() );
//STRIP001 
//STRIP001 		if( nHorStep || nVertStep )
//STRIP001 		{
//STRIP001 			pWin->SetClipRegion( aRect );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(), *pVDev);
//STRIP001 		}
//STRIP001 
//STRIP001 		nHorStep += aCtrl.GetNextStep() ;
//STRIP001 		nVertStep = (ULONG) ( fFact * nHorStep + 0.5 );
//STRIP001 		TESTMAGIC();
//STRIP001 
//STRIP001 		aRect.Left() = aCenter.X() - ( nHorStep >> 1 );
//STRIP001 		aRect.Top() = aCenter.Y() - ( nVertStep >> 1 );
//STRIP001 		aRect.Right() = aCenter.X() + ( nHorStep >> 1 );
//STRIP001 		aRect.Bottom() = aCenter.Y() + ( nVertStep >> 1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	pWin->SetClipRegion();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: zur Mitte hin druebermalen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::FadeToCenter()
//STRIP001 {
//STRIP001 	const long		nWidth = aTarget.GetWidth();
//STRIP001 	ULONG			nHorzStep = 0UL, nVertStep = 0UL;
//STRIP001 	const double	fFact = (double) aTarget.GetHeight() / ( nWidth ? nWidth : 1 );
//STRIP001 	const Point		aCenter( aTarget.Left() + ( nWidth >> 1 ), aTarget.Top() + ( aTarget.GetHeight() >> 1 ) );
//STRIP001 	Rectangle		aInner( aTarget );
//STRIP001 	Rectangle		aOuter( aTarget );
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nWidth ) );
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if( nHorzStep && nVertStep )
//STRIP001 		{
//STRIP001 			PolyPolygon	aPolyPoly;
//STRIP001 
//STRIP001 			aPolyPoly.Insert( aInner );
//STRIP001 			aPolyPoly.Insert( aOuter );
//STRIP001 			aOuter = aInner;
//STRIP001 
//STRIP001 			pWin->SetClipRegion( aPolyPoly );
//STRIP001 			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							  aSource.TopLeft(), aSource.GetSize(), *pVDev );
//STRIP001 		}
//STRIP001 
//STRIP001 		nHorzStep += aCtrl.GetNextStep() ;
//STRIP001 		nVertStep = (ULONG) ( fFact * nHorzStep + 0.5 );
//STRIP001 		TESTMAGIC();
//STRIP001 
//STRIP001 		aInner.Left() = aTarget.Left() + ( nHorzStep >> 1 );
//STRIP001 		aInner.Top() = aTarget.Top() + ( nVertStep >> 1 );
//STRIP001 		aInner.Right() = aTarget.Right() - ( nHorzStep >> 1 );
//STRIP001 		aInner.Bottom() = aTarget.Bottom() - ( nVertStep >> 1 );
//STRIP001 	}
//STRIP001 	while( ( aInner.Left() < aCenter.X() ) || ( aInner.Top() < aCenter.Y() ) ||
//STRIP001 		   ( aInner.Right() > aCenter.X() ) || ( aInner.Bottom() > aCenter.Y() ) );
//STRIP001 
//STRIP001 	pWin->SetClipRegion( aOuter );
//STRIP001 	pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 					  aSource.TopLeft(), aSource.GetSize(), *pVDev );
//STRIP001 	pWin->SetClipRegion();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von links rollen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::RollFromLeft()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
//STRIP001 	if( !pVDevOld )
//STRIP001 	{
//STRIP001 		while( nOffset != aTarget.GetWidth() )
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ( (long) nStep, aTarget.GetWidth() - nOffset );
//STRIP001 
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Rectangle aScroll (aTarget);
//STRIP001 			aScroll.Right() -= nThisStep;
//STRIP001 			pWin->Scroll( nThisStep, 0, aScroll, FADESCROLL );
//STRIP001 
//STRIP001 			Size aSize(nThisStep, aTarget.GetHeight());
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 aTarget.TopLeft(), aSize,
//STRIP001 					 Point(aSource.Right() - nOffset + 1, aSource.Top()), aSize,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 
//STRIP001 		while( nOffset < aTarget.GetWidth() )
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Size aSizeOfNew(nOffset, aTarget.GetHeight());
//STRIP001 			Size aSizeOfOld(aTarget.GetWidth() - nOffset, aTarget.GetHeight());
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 aTarget.TopLeft(),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 Point(aSource.Right() - nOffset + 1, aSource.Top()),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(Point(aTarget.Left() + nOffset, aTarget.Top()),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 aSource.TopLeft(),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 *pVDevOld);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von rechts rollen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::RollFromRight()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
//STRIP001 	if( !pVDevOld )
//STRIP001 	{
//STRIP001 		while (nOffset != aTarget.GetWidth())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Left() += nThisStep;
//STRIP001 			pWin->Scroll( -(long)nThisStep, 0, aScroll, FADESCROLL );
//STRIP001 			Size aSize(nThisStep, aTarget.GetHeight());
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 Point(aTarget.Right() - nThisStep + 1, aTarget.Top()), aSize,
//STRIP001 					 Point(aSource.Left() + nOffset, aSource.Top()), aSize,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			nOffset += nThisStep;
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 
//STRIP001 		while (nOffset < aTarget.GetWidth())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Size aSizeOfNew(nOffset, aTarget.GetHeight());
//STRIP001 			Size aSizeOfOld(aTarget.GetWidth() - nOffset, aTarget.GetHeight());
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 Point(aTarget.Right() - nOffset + 1, aTarget.Top()),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 aSource.TopLeft(),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 Point(aSource.Left() + nOffset, aSource.Top()),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 *pVDevOld);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von oben rollen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::RollFromTop()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
//STRIP001 	if(!pVDevOld)
//STRIP001 	{
//STRIP001 		while (nOffset != aTarget.GetHeight())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Rectangle aScroll (aTarget);
//STRIP001 			aScroll.Bottom() -= nThisStep;
//STRIP001 			pWin->Scroll( 0, nThisStep, aScroll, FADESCROLL );
//STRIP001 			Size aSize(aTarget.GetWidth(), nThisStep);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 aTarget.TopLeft(), aSize,
//STRIP001 					 Point(aSource.Left(), aSource.Bottom() - nOffset + 1), aSize,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 
//STRIP001 		while (nOffset < aTarget.GetHeight())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Size aSizeOfNew(aTarget.GetWidth(), nOffset);
//STRIP001 			Size aSizeOfOld(aTarget.GetWidth(), aTarget.GetHeight() - nOffset);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 aTarget.TopLeft(),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 Point(aSource.Left(), aSource.Bottom() - nOffset + 1),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(Point(aTarget.Left(), aTarget.Top() + nOffset),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 aSource.TopLeft(),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 *pVDevOld);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: von unten rollen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::RollFromBottom()
//STRIP001 {
//STRIP001 	long			nOffset = 0L;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
//STRIP001 	if( !pVDevOld )
//STRIP001 	{
//STRIP001 		while (nOffset != aTarget.GetHeight())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 
//STRIP001 			Rectangle aScroll(aTarget);
//STRIP001 			aScroll.Top() += nThisStep;
//STRIP001 			pWin->Scroll( 0, -(long)nThisStep, aScroll, FADESCROLL );
//STRIP001 			Size aSize(aTarget.GetWidth(), nThisStep);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 Point(aTarget.Left(), aTarget.Bottom() - nThisStep + 1),
//STRIP001 					 aSize,
//STRIP001 					 Point(aSource.Left(), aSource.Top() + nOffset),
//STRIP001 					 aSize,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			nOffset += nThisStep;
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 
//STRIP001 		while (nOffset < aTarget.GetHeight())
//STRIP001 		{
//STRIP001 			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
//STRIP001 			nOffset += nThisStep;
//STRIP001 
//STRIP001 			Size aSizeOfNew(aTarget.GetWidth(), nOffset);
//STRIP001 			Size aSizeOfOld(aTarget.GetWidth(), aTarget.GetHeight() - nOffset);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(
//STRIP001 					 Point(aTarget.Left(), aTarget.Bottom() - nOffset + 1),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 aSource.TopLeft(),
//STRIP001 					 aSizeOfNew,
//STRIP001 					 *pVDev);
//STRIP001 
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 Point(aSource.Left(), aSource.Top() + nOffset),
//STRIP001 							 aSizeOfOld,
//STRIP001 							 *pVDevOld);
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Checkerboard 
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::VerticalCheckerboard()
//STRIP001 {
//STRIP001 	const long nWidth = aTarget.GetWidth(), nHeight = aTarget.GetHeight();
//STRIP001 
//STRIP001 	if( nWidth && nHeight )
//STRIP001 	{
//STRIP001 		const long	nTileWidth = Max( nWidth / 14L, 8L );
//STRIP001 		const long	nTileHeight = nTileWidth << 1;
//STRIP001 		const long	nTileBottom = nTileHeight - 1;
//STRIP001 		const Point	aOrgPoint1;
//STRIP001 		const Point	aOrgPoint2( Point( nTileWidth, -( nTileHeight >> 1 ) ) );
//STRIP001 		Point		aPt1, aPt2;
//STRIP001 		long		nCurY = 0;
//STRIP001 
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nTileHeight ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			aPt1 = aOrgPoint1;
//STRIP001 			aPt2 = aOrgPoint2;
//STRIP001 
//STRIP001 			nCurY += nStep;
//STRIP001 			nCurY = Min( nCurY, nTileBottom );
//STRIP001 
//STRIP001 			do
//STRIP001 			{
//STRIP001 				do
//STRIP001 				{
//STRIP001 					Rectangle aSourceTile( Point( aSource.Left() + aPt1.X(), aSource.Top() + aPt1.Y() ),
//STRIP001 										   Size( nTileWidth, nCurY * nTileHeight / nTileBottom ) );
//STRIP001 
//STRIP001 					aSourceTile.Intersection( aSource );
//STRIP001 
//STRIP001 					if( !aSourceTile.IsEmpty() )
//STRIP001 					{
//STRIP001 						Point aSrcPt( aSourceTile.Left(), aSourceTile.Top() );
//STRIP001 						Point aDstPt( aTarget.Left() + aSrcPt.X() - aSource.Left(), aTarget.Top() + aSrcPt.Y() - aSource.Top() );
//STRIP001 						Size  aSz( aSourceTile.GetSize() );
//STRIP001 
//STRIP001 						pWin->DrawOutDev( aDstPt, aSz, aSrcPt, aSz, *pVDev );
//STRIP001 					}
//STRIP001 
//STRIP001 					aPt1.Y() += nTileHeight;
//STRIP001 				}
//STRIP001 				while( aPt1.Y() < nHeight );
//STRIP001 
//STRIP001 				do
//STRIP001 				{
//STRIP001 					Rectangle aSourceTile( Point( aSource.Left() + aPt2.X(), aSource.Top() + aPt2.Y() ),
//STRIP001 										   Size( nTileWidth, nCurY * nTileHeight / nTileBottom ) );
//STRIP001 
//STRIP001 					aSourceTile.Intersection( aSource );
//STRIP001 
//STRIP001 					if( !aSourceTile.IsEmpty() )
//STRIP001 					{
//STRIP001 						Point aSrcPt( aSourceTile.Left(), aSourceTile.Top() );
//STRIP001 						Point aDstPt( aTarget.Left() + aSrcPt.X() - aSource.Left(), aTarget.Top() + aSrcPt.Y() - aSource.Top() );
//STRIP001 						Size  aSz( aSourceTile.GetSize() );
//STRIP001 
//STRIP001 						pWin->DrawOutDev( aDstPt, aSz, aSrcPt, aSz, *pVDev );
//STRIP001 					}
//STRIP001 
//STRIP001 					aPt2.Y() += nTileHeight;
//STRIP001 				}
//STRIP001 				while( aPt2.Y() < nHeight );
//STRIP001 
//STRIP001 				aPt1.X() += ( nTileWidth << 1 );
//STRIP001 				aPt1.Y() = aOrgPoint1.Y();
//STRIP001 
//STRIP001 				aPt2.X() += ( nTileWidth << 1 );
//STRIP001 				aPt2.Y() = aOrgPoint2.Y();
//STRIP001 			}
//STRIP001 			while( ( aPt1.X() < nWidth ) || ( aPt2.X() < nWidth ) );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurY < nTileBottom );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Fader::HorizontalCheckerboard()
//STRIP001 {
//STRIP001 	const long nWidth = aTarget.GetWidth(), nHeight = aTarget.GetHeight();
//STRIP001 
//STRIP001 	if( nWidth && nHeight )
//STRIP001 	{
//STRIP001 		const long	nTileHeight = Max( nHeight / 12L, 8L );
//STRIP001 		const long	nTileWidth = nTileHeight << 1;
//STRIP001 		const long	nTileRight = nTileWidth - 1;
//STRIP001 		const Point	aOrgPoint1;
//STRIP001 		const Point	aOrgPoint2( Point( -( nTileWidth >> 1 ), nTileHeight ) );
//STRIP001 		Point		aPt1, aPt2;
//STRIP001 		long		nCurX = 0;
//STRIP001 
//STRIP001 		aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nTileWidth ) );
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 		if( pVDevOld )
//STRIP001 		{
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 							 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 		}
//STRIP001 
//STRIP001 		do
//STRIP001 		{
//STRIP001 			aPt1 = aOrgPoint1;
//STRIP001 			aPt2 = aOrgPoint2;
//STRIP001 
//STRIP001 			nCurX += nStep;
//STRIP001 			nCurX = Min( nCurX, nTileRight );
//STRIP001 
//STRIP001 			do
//STRIP001 			{
//STRIP001 				do
//STRIP001 				{
//STRIP001 					Rectangle aSourceTile( Point( aSource.Left() + aPt1.X(), aSource.Top() + aPt1.Y() ),
//STRIP001 										   Size( nCurX * nTileWidth / nTileRight, nTileHeight ) );
//STRIP001 
//STRIP001 					aSourceTile.Intersection( aSource );
//STRIP001 
//STRIP001 					if( !aSourceTile.IsEmpty() )
//STRIP001 					{
//STRIP001 						Point aSrcPt( aSourceTile.Left(), aSourceTile.Top() );
//STRIP001 						Point aDstPt( aTarget.Left() + aSrcPt.X() - aSource.Left(), aTarget.Top() + aSrcPt.Y() - aSource.Top() );
//STRIP001 						Size  aSz( aSourceTile.GetSize() );
//STRIP001 
//STRIP001 						pWin->DrawOutDev( aDstPt, aSz, aSrcPt, aSz, *pVDev );
//STRIP001 					}
//STRIP001 
//STRIP001 					aPt1.X() += nTileWidth;
//STRIP001 				}
//STRIP001 				while( aPt1.X() < nWidth );
//STRIP001 
//STRIP001 				do
//STRIP001 				{
//STRIP001 					Rectangle aSourceTile( Point( aSource.Left() + aPt2.X(), aSource.Top() + aPt2.Y() ),
//STRIP001 										   Size( nCurX * nTileWidth / nTileRight, nTileHeight ) );
//STRIP001 
//STRIP001 					aSourceTile.Intersection( aSource );
//STRIP001 
//STRIP001 					if( !aSourceTile.IsEmpty() )
//STRIP001 					{
//STRIP001 						Point aSrcPt( aSourceTile.Left(), aSourceTile.Top() );
//STRIP001 						Point aDstPt( aTarget.Left() + aSrcPt.X() - aSource.Left(), aTarget.Top() + aSrcPt.Y() - aSource.Top() );
//STRIP001 						Size  aSz( aSourceTile.GetSize() );
//STRIP001 
//STRIP001 						pWin->DrawOutDev( aDstPt, aSz, aSrcPt, aSz, *pVDev );
//STRIP001 					}
//STRIP001 
//STRIP001 					aPt2.X() += nTileWidth;
//STRIP001 				}
//STRIP001 				while( aPt2.X() < nWidth );
//STRIP001 
//STRIP001 				aPt1.X() = aOrgPoint1.X();
//STRIP001 				aPt1.Y() += ( nTileHeight << 1 );
//STRIP001 
//STRIP001 				aPt2.X() = aOrgPoint2.X();
//STRIP001 				aPt2.Y() += ( nTileHeight << 1 );
//STRIP001 			}
//STRIP001 			while( ( aPt1.Y() < nHeight ) || ( aPt2.Y() < nHeight ) );
//STRIP001 
//STRIP001 			nStep = aCtrl.GetNextStep();
//STRIP001 			TESTMAGIC();
//STRIP001 		}
//STRIP001 		while( nCurX < nTileRight );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* 
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::VerticalStripes()
//STRIP001 {
//STRIP001 	ULONG			nNoOfStripes = 5;
//STRIP001 	ULONG			nStripeWidth = aTarget.GetWidth() / nNoOfStripes;
//STRIP001 	ULONG			nRect;
//STRIP001 	Rectangle*		pRect = NULL;
//STRIP001 	List			aRectList;
//STRIP001 	BOOL			bDone = FALSE;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nStripeWidth / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	for( nRect= 0; nRect < nNoOfStripes; nRect++ )
//STRIP001 	{
//STRIP001 		const ULONG nAxis = aTarget.Left() + nRect * nStripeWidth + nStripeWidth / 2;
//STRIP001 		aRectList.Insert(new Rectangle(Point(nAxis, aTarget.Top()), Size(1, aTarget.GetHeight())), LIST_APPEND);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( !bDone )
//STRIP001 	{
//STRIP001 		bDone = TRUE;
//STRIP001 
//STRIP001 		for( nRect = 0; nRect < nNoOfStripes; nRect++ )
//STRIP001 		{
//STRIP001 			pRect = (Rectangle*) aRectList.GetObject( nRect );
//STRIP001 
//STRIP001 			Rectangle aRect( *pRect );
//STRIP001 
//STRIP001 			aRect.Left() = Max( aRect.Left() - (long) nStep, aTarget.Left() );
//STRIP001 			aRect.Right() = Min( aRect.Right() + (long) nStep, aTarget.Right() );
//STRIP001 
//STRIP001 			const Point aSrc( aSource.Left() + ( aRect.Left() - aTarget.Left() ),
//STRIP001 							  aSource.Top() + ( aRect.Top() - aTarget.Top() ) );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 							  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 			pRect->Left() = aRect.Left();
//STRIP001 			pRect->Right() = aRect.Right();
//STRIP001 
//STRIP001 			if( !nRect )
//STRIP001 			{
//STRIP001 				if( pRect->Left() > aTarget.Left() )
//STRIP001 					bDone = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// linke Kante an rechter Kante des Vorgaengers?
//STRIP001 				if( pRect->Left() > ((Rectangle*)aRectList.GetObject(nRect - 1))->Right() + 1 )
//STRIP001 					bDone = FALSE;
//STRIP001 
//STRIP001 				// letzter Streifen: rechte Kante auf rechter Kante des Ausgabebereichs?
//STRIP001 				if( ( nRect == nNoOfStripes - 1 ) && ( pRect->Right() < aTarget.Right() ) )
//STRIP001 					bDone = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		if( nMagic != FADER_MAGIC )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	for( pRect = (Rectangle*) aRectList.First(); pRect; pRect = (Rectangle*) aRectList.Next() )
//STRIP001 		delete pRect;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ueberblenden: horizontal blenden
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::HorizontalStripes()
//STRIP001 {
//STRIP001 	ULONG			nNoOfStripes = 5;
//STRIP001 	ULONG			nStripeHeight = aTarget.GetHeight() / nNoOfStripes;
//STRIP001 	ULONG			nRect;
//STRIP001 	Rectangle*		pRect = NULL;
//STRIP001 	List			aRectList;
//STRIP001 	BOOL			bDone = FALSE;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, nStripeHeight / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	for( nRect= 0; nRect < nNoOfStripes; nRect++ )
//STRIP001 	{
//STRIP001 		const ULONG nAxis = aTarget.Top() + nRect * nStripeHeight + nStripeHeight / 2;
//STRIP001 		aRectList.Insert(new Rectangle(Point(aTarget.Left(), nAxis),Size(aTarget.GetWidth(), 1)), LIST_APPEND);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while( !bDone )
//STRIP001 	{
//STRIP001 		bDone = TRUE;
//STRIP001 
//STRIP001 		for( nRect = 0; nRect < nNoOfStripes; nRect++ )
//STRIP001 		{
//STRIP001 			pRect = (Rectangle*) aRectList.GetObject( nRect );
//STRIP001 
//STRIP001 			Rectangle aRect( *pRect );
//STRIP001 
//STRIP001 			aRect.Top() = Max( aRect.Top() - (long) nStep, aTarget.Top() );
//STRIP001 			aRect.Bottom() = Min( aRect.Bottom() + (long) nStep, aTarget.Bottom() );
//STRIP001 
//STRIP001 			const Point aSrc( aSource.Left() + ( aRect.Left() - aTarget.Left() ),
//STRIP001 							  aSource.Top() + ( aRect.Top() - aTarget.Top() ) );
//STRIP001 
//STRIP001 			pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 							  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 			pRect->Top() = aRect.Top();
//STRIP001 			pRect->Bottom() = aRect.Bottom();
//STRIP001 
//STRIP001 			if( !nRect )
//STRIP001 			{
//STRIP001 				if( pRect->Top() > aTarget.Top() )
//STRIP001 					bDone = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// obere Kante an unterer Kante des Vorgaengers?
//STRIP001 				if( pRect->Top() > ((Rectangle*)aRectList.GetObject(nRect - 1))->Bottom() + 1 )
//STRIP001 					bDone = FALSE;
//STRIP001 
//STRIP001 				// letzter Streifen: untere Kante auf unterer Kante des Ausgabebereichs?
//STRIP001 				if( ( nRect == nNoOfStripes - 1 ) && ( pRect->Bottom() < aTarget.Bottom() ) )
//STRIP001 					bDone = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		if( FADER_MAGIC != nMagic )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	for( pRect = (Rectangle*) aRectList.First(); pRect; pRect = (Rectangle*) aRectList.Next() )
//STRIP001 		delete pRect;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* im Uhrzeigersinn ueberblenden (dran denken: y waechst nach unten)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::Clockwise()
//STRIP001 {
//STRIP001 	Polygon			aClip( 4 );
//STRIP001 	const double	fStart = 0.75 * F_2PI;
//STRIP001 	const double	fEnd = fStart + F_2PI;
//STRIP001 	const double	fDiff = 8. * F_PI180;
//STRIP001 	double			fPhi1, fPhi2, fSin, fCos;
//STRIP001 	Point			aPnt( 2 * Max (aTarget.GetWidth(), aTarget.GetHeight() ), 0 );
//STRIP001 	Point			aPnt1 = aPnt;
//STRIP001 	Point			aPnt2 = aPnt1;
//STRIP001 	Point			aCenter(aTarget.Left() + aTarget.GetWidth() / 2,
//STRIP001 							aTarget.Top() + aTarget.GetHeight() / 2);
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, (ULONG) ( F_2PI * 10000. ) ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	aClip[ 0 ] = aClip[ 3 ] = aCenter;
//STRIP001 
//STRIP001 	fPhi1 = fPhi2 = fStart;
//STRIP001 
//STRIP001 	while( fPhi2 < fEnd )
//STRIP001 	{
//STRIP001 		double fTemp = fPhi1 - fDiff;
//STRIP001 
//STRIP001 		if( fTemp < fStart )
//STRIP001 			fTemp = fStart;
//STRIP001 
//STRIP001 		aPnt1 = aCenter;
//STRIP001 		fSin = sin( fTemp );
//STRIP001 		fCos = cos( fTemp );
//STRIP001 		aPnt1.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
//STRIP001 		aPnt1.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );
//STRIP001 
//STRIP001 		aPnt2 = aCenter;
//STRIP001 		fPhi1 = fPhi2 = fPhi1 + ( (double) nStep / 10000. );
//STRIP001 		fSin = sin( fPhi2 );
//STRIP001 		fCos = cos( fPhi2 );
//STRIP001 		aPnt2.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
//STRIP001 		aPnt2.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );
//STRIP001 
//STRIP001 		aClip[ 1 ] = aPnt1;
//STRIP001 		aClip[ 2 ] = aPnt2;
//STRIP001 
//STRIP001 		pWin->SetClipRegion( aClip );
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 
//STRIP001 	pWin->SetClipRegion();
//STRIP001 	pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 					 aSource.TopLeft(), aSource.GetSize(), *pVDev);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* gegen den Uhrzeigersinn ueberblenden (dran denken: y waechst nach unten)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CounterClockwise()
//STRIP001 {
//STRIP001 	Polygon			aClip( 4 );
//STRIP001 	const double	fStart = 0.75 * F_2PI;
//STRIP001 	const double	fEnd = fStart + F_2PI;
//STRIP001 	const double	fDiff = 8. * F_PI180;
//STRIP001 	double			fPhi1, fPhi2, fSin, fCos;
//STRIP001 	Point			aPnt( 2 * Max (aTarget.GetWidth(), aTarget.GetHeight() ), 0 );
//STRIP001 	Point			aPnt1 = aPnt;
//STRIP001 	Point			aPnt2 = aPnt1;
//STRIP001 	Point			aCenter(aTarget.Left() + aTarget.GetWidth() / 2,
//STRIP001 							aTarget.Top() + aTarget.GetHeight() / 2);
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, (ULONG) ( F_2PI * 10000. ) ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	aClip[ 0 ] = aClip[ 3 ] = aCenter;
//STRIP001 
//STRIP001 	fPhi1 = fPhi2 = fStart;
//STRIP001 
//STRIP001 	while( fPhi2 < fEnd )
//STRIP001 	{
//STRIP001 		double fTemp = fPhi1 - fDiff;
//STRIP001 
//STRIP001 		if( fTemp < fStart )
//STRIP001 			fTemp = fStart;
//STRIP001 
//STRIP001 		aPnt1 = aCenter;
//STRIP001 		fTemp = fStart - ( fTemp - fStart );
//STRIP001 		fSin = sin( fTemp );
//STRIP001 		fCos = cos( fTemp );
//STRIP001 		aPnt1.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
//STRIP001 		aPnt1.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );
//STRIP001 
//STRIP001 		aPnt2 = aCenter;
//STRIP001 		fPhi1 = fPhi2 = fPhi1 + ( (double) nStep / 10000. );
//STRIP001 		fTemp = fStart - ( fPhi2 - fStart );
//STRIP001 		fSin = sin( fTemp );
//STRIP001 		fCos = cos( fTemp );
//STRIP001 		aPnt2.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
//STRIP001 		aPnt2.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );
//STRIP001 
//STRIP001 		aClip[ 1 ] = aPnt1;
//STRIP001 		aClip[ 2 ] = aPnt2;
//STRIP001 
//STRIP001 		pWin->SetClipRegion( aClip );
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 
//STRIP001 	pWin->SetClipRegion();
//STRIP001 	pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 					 aSource.TopLeft(), aSource.GetSize(), *pVDev);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Vertikal schliessen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CloseVertical()
//STRIP001 {
//STRIP001 	Rectangle		aRect( aTarget );
//STRIP001 	Point			aSrc;
//STRIP001 	long			nOffset = 0UL;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( TRUE )
//STRIP001 	{
//STRIP001 		aRect.Top() = aTarget.Top();
//STRIP001 		aRect.Bottom() = aTarget.Top() + nOffset;
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		aRect.Top() = aTarget.Bottom() - nOffset;
//STRIP001 		aRect.Bottom() = aTarget.Bottom();
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		if( ( aTarget.Top() + nOffset ) > ( aTarget.Bottom() - nOffset ) )
//STRIP001 			break;
//STRIP001 
//STRIP001 		nOffset += nStep;
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Horizontal schliessen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CloseHorizontal()
//STRIP001 {
//STRIP001 	Rectangle		aRect( aTarget );
//STRIP001 	Point			aSrc;
//STRIP001 	long			nOffset = 0UL;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( TRUE )
//STRIP001 	{
//STRIP001 		aRect.Left() = aTarget.Left();
//STRIP001 		aRect.Right() = aTarget.Left() + nOffset;
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		aRect.Left() = aTarget.Right() - nOffset;
//STRIP001 		aRect.Right() = aTarget.Right();
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		if( ( aTarget.Left() + nOffset ) > ( aTarget.Right() - nOffset ) )
//STRIP001 			break;
//STRIP001 
//STRIP001 		nOffset += nStep;
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		TESTMAGIC();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Vertikal oeffnen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::OpenVertical()
//STRIP001 {
//STRIP001 	Rectangle		aRect( aTarget );
//STRIP001 	Point			aSrc;
//STRIP001 	long			nOffset = 0L;
//STRIP001 	long			nCenter = aTarget.Top() + aTarget.GetHeight() / 2;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( TRUE )
//STRIP001 	{
//STRIP001 		aRect.Top() = Max( aTarget.Top(), nCenter - nOffset );
//STRIP001 		aRect.Bottom() = Min( aTarget.Bottom(), nCenter + nOffset );
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		nOffset += nStep;
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		if( FADER_MAGIC != nMagic || aRect == aTarget )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Horizontal oeffnen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::OpenHorizontal()
//STRIP001 {
//STRIP001 	Rectangle		aRect( aTarget );
//STRIP001 	Point			aSrc;
//STRIP001 	long			nOffset = 0L;
//STRIP001 	long			nCenter = aTarget.Left() + aTarget.GetWidth() / 2;
//STRIP001 
//STRIP001 	aCtrl.Reset( pWin, ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() / 2 ) );
//STRIP001 	nStep = aCtrl.GetNextStep();
//STRIP001 
//STRIP001 	if( pVDevOld )
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( TRUE )
//STRIP001 	{
//STRIP001 		aRect.Left() = Max( aTarget.Left(), nCenter - nOffset );
//STRIP001 		aRect.Right() = Min( aTarget.Right(), nCenter + nOffset );
//STRIP001 		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
//STRIP001 		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
//STRIP001 
//STRIP001 		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
//STRIP001 						  aSrc, aRect.GetSize(), *pVDev );
//STRIP001 
//STRIP001 		nOffset += nStep;
//STRIP001 		nStep = aCtrl.GetNextStep();
//STRIP001 		if( FADER_MAGIC != nMagic || aRect == aTarget )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Anzahl der der Zellen horizontal und vertikal bestimmen
//STRIP001 |* (erst NACH SwitchToPixel rufen!)
//STRIP001 |*
//STRIP001 |*   Hoehe a, Breite b, Zellgroesse z, etwa 500 Zellen
//STRIP001 |*
//STRIP001 |*   (1)  a = nRow * z
//STRIP001 |*   (2)  b = nCol * z
//STRIP001 |*   (3)  nRow * nCol = nCells
//STRIP001 |*
//STRIP001 |*                        1/2
//STRIP001 |*    ==> z = (a*b/nCells)
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CalcCellParams(USHORT nCells)
//STRIP001 {
//STRIP001 	double fTemp = (double)aTarget.GetWidth() * (double)aTarget.GetHeight();
//STRIP001 	fTemp /= nCells;
//STRIP001 	fTemp = sqrt(fTemp);
//STRIP001 	nPrefCellSize = (USHORT) fTemp;
//STRIP001 	nPrefCellSize = Max(nPrefCellSize, (USHORT)1);
//STRIP001 
//STRIP001 	nRowCount = aTarget.GetHeight() / nPrefCellSize;
//STRIP001 	if (nRowCount * nPrefCellSize < aTarget.GetHeight())
//STRIP001 		nRowCount++;
//STRIP001 	nColCount = aTarget.GetWidth() / nPrefCellSize;
//STRIP001 	if (nColCount * nPrefCellSize < aTarget.GetWidth())
//STRIP001 		nColCount++;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellgroesse und -position fuer eine bestimmte Reihe und Spalte ermitteln
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Rectangle Fader::GetCell(USHORT nCol, USHORT nRow) const
//STRIP001 {
//STRIP001 	// so gross
//STRIP001 	Rectangle aRect(0, 0, nPrefCellSize, nPrefCellSize);
//STRIP001 
//STRIP001 	// an dieser Position
//STRIP001 	aRect.Move(nCol * nPrefCellSize, nRow * nPrefCellSize);
//STRIP001 
//STRIP001 	// Korrektur fuer letzte Spalte und Reihe
//STRIP001 	if (nCol == nColCount - 1)
//STRIP001 		aRect.Right() = aTarget.Right() - aTarget.Left();
//STRIP001 	if (nRow == nRowCount - 1)
//STRIP001 		aRect.Bottom() = aTarget.Bottom() - aTarget.Top();
//STRIP001 
//STRIP001 	return aRect;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellenweise einblenden: zufaellig
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CellsRandom()
//STRIP001 {
//STRIP001 	ULONG nNoOfSteps = GetEffectSteps(eSpeed);
//STRIP001 
//STRIP001 	CalcCellParams(500);                // etwa 500 Zellen
//STRIP001 
//STRIP001 	USHORT nCellCount = nColCount * nRowCount;
//STRIP001 	USHORT nHits      = 0;
//STRIP001 	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
//STRIP001 	nPause = Max(nPause, (USHORT)1);
//STRIP001 
//STRIP001 	sal_Char* pFlags = new sal_Char[nCellCount];
//STRIP001 	memset(pFlags, 0, nCellCount);
//STRIP001 
//STRIP001 	srand(1);
//STRIP001 
//STRIP001 	if (pVDevOld)
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nHits < nCellCount)
//STRIP001 	{
//STRIP001 		USHORT nCellIndex = rand();
//STRIP001 		if (nCellIndex < nCellCount && !pFlags[nCellIndex])
//STRIP001 		{
//STRIP001 			nHits++;
//STRIP001 			pFlags[nCellIndex] = 1;
//STRIP001 			USHORT nRow = nCellIndex / nColCount;
//STRIP001 			USHORT nCol = nCellIndex % nColCount;
//STRIP001 			Rectangle aRect(GetCell(nCol, nRow));
//STRIP001 
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 *pVDev);
//STRIP001 
//STRIP001 			if( !( nHits % nPause ) )
//STRIP001 			{
//STRIP001 				GetpApp()->Reschedule();
//STRIP001 				if( FADER_MAGIC != nMagic )
//STRIP001 					break;
//STRIP001 				WaitInEffect(WAIT_IN_EFFECT_MS);
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete[] pFlags;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellenweise einblenden: von innen nach aussen und im Uhrzeigersinn
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CellsSpiralOutClockwise()
//STRIP001 {
//STRIP001 	ULONG nNoOfSteps = GetEffectSteps(eSpeed);
//STRIP001 
//STRIP001 	CalcCellParams(100);         // etwa 100 Zellen
//STRIP001 
//STRIP001 	USHORT nCellCount = nColCount * nRowCount;
//STRIP001 	USHORT nHits      = 0;
//STRIP001 	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
//STRIP001 	nPause = Max(nPause, (USHORT)1);
//STRIP001 
//STRIP001 	USHORT nDir = 0;            // rechts = 0, unten = 1, links = 2, oben = 3
//STRIP001 
//STRIP001 	USHORT nXSteps;
//STRIP001 	USHORT nYSteps;
//STRIP001 
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 
//STRIP001 	// Startpunkt, Startrichtung und Schrittweiten festlegen
//STRIP001 	if (nColCount > nRowCount)
//STRIP001 	{
//STRIP001 		nDir = 0;
//STRIP001 		nCurX = nRowCount / 2;
//STRIP001 		if (nRowCount % 2 == 0)
//STRIP001 			nCurX--;
//STRIP001 		nCurY = nCurX;
//STRIP001 		nXSteps = nColCount - 2 * nCurX - 1;
//STRIP001 		nYSteps = 1;
//STRIP001 	}
//STRIP001 	else if (nColCount < nRowCount)
//STRIP001 	{
//STRIP001 		nDir = 1;
//STRIP001 		nCurY = nColCount / 2;
//STRIP001 		if (nColCount % 2 == 0)
//STRIP001 			nCurY--;
//STRIP001 		nCurX = nColCount - 1 - nCurY;
//STRIP001 		nXSteps = 1;
//STRIP001 		nYSteps = nRowCount - 2 * nCurY - 1;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nDir = 0;
//STRIP001 		nCurX = nRowCount / 2;
//STRIP001 		if (nRowCount % 2 == 0)
//STRIP001 			nCurX--;
//STRIP001 		nCurY = nCurX;
//STRIP001 		nXSteps = nYSteps = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pVDevOld)
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	// die erste Zelle zeichnen und die naechste ermitteln (alle weiteren
//STRIP001 	// Zellen werden jetzt NEBEN eine bereits gezeichnete Zelle gesetzt)
//STRIP001 	Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 	pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 					 aRect.GetSize(),
//STRIP001 					 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 					 aRect.GetSize(),
//STRIP001 					 *pVDev);
//STRIP001 	nHits++;
//STRIP001 	switch (nDir)
//STRIP001 	{
//STRIP001 		case 0: nCurX++; break;
//STRIP001 		case 1: nCurY++; break;
//STRIP001 		case 2: nCurX--; break;
//STRIP001 		case 3: nCurY--; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nHits < nCellCount)
//STRIP001 	{
//STRIP001 		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;
//STRIP001 
//STRIP001 		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
//STRIP001 		{
//STRIP001 			Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 *pVDev);
//STRIP001 			nHits++;
//STRIP001 
//STRIP001 			// wenn noch ein Schritt in diese Richtung getan wird, hier
//STRIP001 			// die naechste Zelle bestimmen
//STRIP001 			if (nStep < nStepMax - 1)
//STRIP001 			{
//STRIP001 				switch (nDir)
//STRIP001 				{
//STRIP001 					case 0: nCurX++; break;
//STRIP001 					case 1: nCurY++; break;
//STRIP001 					case 2: nCurX--; break;
//STRIP001 					case 3: nCurY--; break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !( nHits % nPause) )
//STRIP001 			{
//STRIP001 				GetpApp()->Reschedule();
//STRIP001 				if( FADER_MAGIC != nMagic )
//STRIP001 					return;
//STRIP001 				WaitInEffect(WAIT_IN_EFFECT_MS);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Schrittweite erhoehen
//STRIP001 		if( nDir % 2 )
//STRIP001 			nYSteps++;
//STRIP001 		else
//STRIP001 			nXSteps++;
//STRIP001 
//STRIP001 		// Richtung wechseln und naechste Zelle bestimmen
//STRIP001 		nDir++;
//STRIP001 		if( nDir > 3 )
//STRIP001 			nDir = 0;
//STRIP001 
//STRIP001 		switch (nDir)
//STRIP001 		{
//STRIP001 			case 0: nCurX++; break;
//STRIP001 			case 1: nCurY++; break;
//STRIP001 			case 2: nCurX--; break;
//STRIP001 			case 3: nCurY--; break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellenweise einblenden: von innen nach aussen und gegen den Uhrzeigersinn
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CellsSpiralOutCounterClockwise()
//STRIP001 {
//STRIP001 	ULONG nNoOfSteps = GetEffectSteps(eSpeed);
//STRIP001 
//STRIP001 	CalcCellParams(100);         // etwa 100 Zellen
//STRIP001 
//STRIP001 	USHORT nCellCount = nColCount * nRowCount;
//STRIP001 	USHORT nHits      = 0;
//STRIP001 	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
//STRIP001 	nPause = Max(nPause, (USHORT)1);
//STRIP001 
//STRIP001 	USHORT nDir = 0;            // links = 0, unten = 1, rechts = 2, oben = 3
//STRIP001 
//STRIP001 	USHORT nXSteps;
//STRIP001 	USHORT nYSteps;
//STRIP001 
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 
//STRIP001 	// Startpunkt, Startrichtung und Schrittweiten festlegen (Berechnung wie
//STRIP001 	// bei 'Clockwise', dann spiegeln
//STRIP001 	if (nColCount > nRowCount)
//STRIP001 	{
//STRIP001 		nDir = 0;
//STRIP001 		nCurX = nRowCount / 2;
//STRIP001 		if (nRowCount % 2 == 0)
//STRIP001 			nCurX--;
//STRIP001 		nCurY = nCurX;
//STRIP001 		nXSteps = nColCount - 2 * nCurX - 1;
//STRIP001 		nYSteps = 1;
//STRIP001 		nCurX = nColCount - 1 - nCurX;      // spiegeln
//STRIP001 	}
//STRIP001 	else if (nColCount < nRowCount)
//STRIP001 	{
//STRIP001 		nDir = 1;
//STRIP001 		nCurY = nColCount / 2;
//STRIP001 		if (nColCount % 2 == 0)
//STRIP001 			nCurY--;
//STRIP001 		nCurX = nColCount - 1 - nCurY;
//STRIP001 		nXSteps = 1;
//STRIP001 		nYSteps = nRowCount - 2 * nCurY - 1;
//STRIP001 		nCurX = nColCount - 1 - nCurX;      // spiegeln
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nDir = 0;
//STRIP001 		nCurX = nRowCount / 2;
//STRIP001 		if (nRowCount % 2 == 0)
//STRIP001 			nCurX--;
//STRIP001 		nCurY = nCurX;
//STRIP001 		nXSteps = nYSteps = 1;
//STRIP001 		nCurX = nColCount - 1 - nCurX;      // spiegeln
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pVDevOld)
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	// die erste Zelle zeichnen und die naechste ermitteln (alle weiteren
//STRIP001 	// Zellen werden jetzt NEBEN eine bereits gezeichnete Zelle gesetzt)
//STRIP001 	Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 	pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 					 aRect.GetSize(),
//STRIP001 					 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 					 aRect.GetSize(),
//STRIP001 					 *pVDev);
//STRIP001 	nHits++;
//STRIP001 	switch (nDir)
//STRIP001 	{
//STRIP001 		case 0: nCurX--; break;
//STRIP001 		case 1: nCurY++; break;
//STRIP001 		case 2: nCurX++; break;
//STRIP001 		case 3: nCurY--; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nHits < nCellCount)
//STRIP001 	{
//STRIP001 		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;
//STRIP001 
//STRIP001 		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
//STRIP001 		{
//STRIP001 			Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 *pVDev);
//STRIP001 			nHits++;
//STRIP001 
//STRIP001 			// wenn noch ein Schritt in diese Richtung getan wird, hier
//STRIP001 			// die naechste Zelle bestimmen
//STRIP001 			if (nStep < nStepMax - 1)
//STRIP001 			{
//STRIP001 				switch (nDir)
//STRIP001 				{
//STRIP001 					case 0: nCurX--; break;
//STRIP001 					case 1: nCurY++; break;
//STRIP001 					case 2: nCurX++; break;
//STRIP001 					case 3: nCurY--; break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// warten
//STRIP001 			if( !( nHits % nPause ) )
//STRIP001 			{
//STRIP001 				GetpApp()->Reschedule();
//STRIP001 				if( FADER_MAGIC != nMagic )
//STRIP001 					return;
//STRIP001 				WaitInEffect(WAIT_IN_EFFECT_MS);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Schrittweite erhoehen
//STRIP001 		if( nDir % 2 )
//STRIP001 			nYSteps++;
//STRIP001 		else
//STRIP001 			nXSteps++;
//STRIP001 
//STRIP001 		// Richtung wechseln und naechste Zelle bestimmen
//STRIP001 		nDir++;
//STRIP001 		if( nDir > 3 )
//STRIP001 			nDir = 0;
//STRIP001 
//STRIP001 		switch (nDir)
//STRIP001 		{
//STRIP001 			case 0: nCurX--; break;
//STRIP001 			case 1: nCurY++; break;
//STRIP001 			case 2: nCurX++; break;
//STRIP001 			case 3: nCurY--; break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellenweise einblenden: von aussen nach innen und im Uhrzeigersinn
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CellsSpiralInClockwise()
//STRIP001 {
//STRIP001 	ULONG nNoOfSteps = GetEffectSteps(eSpeed);
//STRIP001 
//STRIP001 	CalcCellParams(100);         // etwa 100 Zellen
//STRIP001 
//STRIP001 	USHORT nCellCount = nColCount * nRowCount;
//STRIP001 	USHORT nHits      = 0;
//STRIP001 	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
//STRIP001 	nPause = Max(nPause, (USHORT)1);
//STRIP001 
//STRIP001 	USHORT nDir = 0;            // rechts = 0, unten = 1, links = 2, oben = 3
//STRIP001 
//STRIP001 	USHORT nXSteps = nColCount;
//STRIP001 	USHORT nYSteps = nRowCount;
//STRIP001 
//STRIP001 	USHORT nCurX = 0;
//STRIP001 	USHORT nCurY = 0;
//STRIP001 
//STRIP001 	if (pVDevOld)
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nHits < nCellCount)
//STRIP001 	{
//STRIP001 		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;
//STRIP001 
//STRIP001 		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
//STRIP001 		{
//STRIP001 			Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 *pVDev);
//STRIP001 			nHits++;
//STRIP001 
//STRIP001 			// wenn noch ein Schritt in diese Richtung getan wird, hier
//STRIP001 			// die naechste Zelle bestimmen
//STRIP001 			if (nStep < nStepMax - 1)
//STRIP001 			{
//STRIP001 				switch (nDir)
//STRIP001 				{
//STRIP001 					case 0: nCurX++; break;
//STRIP001 					case 1: nCurY++; break;
//STRIP001 					case 2: nCurX--; break;
//STRIP001 					case 3: nCurY--; break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// warten
//STRIP001 			if( !( nHits % nPause ) )
//STRIP001 			{
//STRIP001 				GetpApp()->Reschedule();
//STRIP001 				if( FADER_MAGIC != nMagic )
//STRIP001 					return;
//STRIP001 				WaitInEffect(WAIT_IN_EFFECT_MS);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Schrittweite verringern
//STRIP001 		if( nDir % 2 )
//STRIP001 			nXSteps--;
//STRIP001 		else
//STRIP001 			nYSteps--;
//STRIP001 
//STRIP001 		// Richtung wechseln und naechste Zelle bestimmen
//STRIP001 		nDir++;
//STRIP001 		if( nDir > 3 )
//STRIP001 			nDir = 0;
//STRIP001 
//STRIP001 		switch (nDir)
//STRIP001 		{
//STRIP001 			case 0: nCurX++; break;
//STRIP001 			case 1: nCurY++; break;
//STRIP001 			case 2: nCurX--; break;
//STRIP001 			case 3: nCurY--; break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zellenweise einblenden: von aussen nach innen und gegen den Uhrzeigersinn
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void Fader::CellsSpiralInCounterClockwise()
//STRIP001 {
//STRIP001 	ULONG nNoOfSteps = GetEffectSteps(eSpeed);
//STRIP001 
//STRIP001 	CalcCellParams(100);         // etwa 100 Zellen
//STRIP001 
//STRIP001 	USHORT nCellCount = nColCount * nRowCount;
//STRIP001 	USHORT nHits      = 0;
//STRIP001 	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
//STRIP001 	nPause = Max(nPause, (USHORT)1);
//STRIP001 
//STRIP001 	USHORT nDir = 0;            // links = 0, unten = 1, rechts = 2, oben = 3
//STRIP001 
//STRIP001 	USHORT nXSteps = nColCount;
//STRIP001 	USHORT nYSteps = nRowCount;
//STRIP001 
//STRIP001 	USHORT nCurX = nColCount - 1;
//STRIP001 	USHORT nCurY = 0;
//STRIP001 
//STRIP001 	if (pVDevOld)
//STRIP001 	{
//STRIP001 		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
//STRIP001 						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
//STRIP001 	}
//STRIP001 
//STRIP001 	while (nHits < nCellCount)
//STRIP001 	{
//STRIP001 		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;
//STRIP001 
//STRIP001 		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
//STRIP001 		{
//STRIP001 			Rectangle aRect(GetCell(nCurX, nCurY));
//STRIP001 			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 aSource.TopLeft() + aRect.TopLeft(),
//STRIP001 							 aRect.GetSize(),
//STRIP001 							 *pVDev);
//STRIP001 			nHits++;
//STRIP001 
//STRIP001 			// wenn noch ein Schritt in diese Richtung getan wird, hier
//STRIP001 			// die naechste Zelle bestimmen
//STRIP001 			if (nStep < nStepMax - 1)
//STRIP001 			{
//STRIP001 				switch (nDir)
//STRIP001 				{
//STRIP001 					case 0: nCurX--; break;
//STRIP001 					case 1: nCurY++; break;
//STRIP001 					case 2: nCurX++; break;
//STRIP001 					case 3: nCurY--; break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// warten
//STRIP001 			if( !( nHits % nPause ) )
//STRIP001 			{
//STRIP001 				GetpApp()->Reschedule();
//STRIP001 				if( FADER_MAGIC != nMagic )
//STRIP001 					return;
//STRIP001 				WaitInEffect(WAIT_IN_EFFECT_MS);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Schrittweite verringern
//STRIP001 		if( nDir % 2 )
//STRIP001 			nXSteps--;
//STRIP001 		else
//STRIP001 			nYSteps--;
//STRIP001 
//STRIP001 		// Richtung wechseln und naechste Zelle bestimmen
//STRIP001 		nDir++;
//STRIP001 		if( nDir > 3 )
//STRIP001 			nDir = 0;
//STRIP001 
//STRIP001 		switch (nDir)
//STRIP001 		{
//STRIP001 			case 0: nCurX--; break;
//STRIP001 			case 1: nCurY++; break;
//STRIP001 			case 2: nCurX++; break;
//STRIP001 			case 3: nCurY--; break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
