/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdview2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:43:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <vector>

// auto strip #ifndef _REF_HXX
// auto strip #include <tools/ref.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVDETC_HXX //autogen
// auto strip #include <bf_svx/svdetc.hxx>
// auto strip #endif
// auto strip #ifndef _IPOBJ_HXX //autogen
// auto strip #include <so3/ipobj.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOOLE2_HXX //autogen
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX //autogen
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
// auto strip #ifndef _SV_GRAPH_HXX //autogen
// auto strip #include <vcl/graph.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XEXCH_HXX //autogen
// auto strip #include <bf_svx/xexch.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLG_NAME_HXX
// auto strip #include <bf_svx/dlgname.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_CHILDWIN_HXX //autogen
// auto strip #include <bf_sfx2/childwin.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _URLBMK_HXX //autogen
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #endif
// auto strip #ifndef _URLBMK_HXX //autogen
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XFLCLIT_HXX
// auto strip #include <bf_svx/xflclit.hxx>
// auto strip #endif
#include <bf_svx/dbexch.hrc>
// auto strip #ifndef _SOT_FORMATS_HXX //autogen
// auto strip #include <sot/formats.hxx>
// auto strip #endif
// auto strip #ifndef _MyEDITENG_HXX //autogen
// auto strip #include <bf_svx/editeng.hxx>
// auto strip #endif
// auto strip #ifndef _SVDITER_HXX
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #endif
// auto strip #ifndef _E3D_OBJ3D_HXX 
// auto strip #include <bf_svx/obj3d.hxx>
// auto strip #endif
#ifndef _E3D_SCENE3D_HXX 
#include <bf_svx/scene3d.hxx>
#endif

// auto strip #include "navigatr.hxx"
// auto strip #include "anminfo.hxx"
#include "strings.hrc"
// auto strip #include "sdview.hxx"
#include "sdxfer.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "sdmod.hxx"
#include "drviewsh.hxx"
#include "docshell.hxx"
// auto strip #include "fudraw.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "unoaprms.hxx"
#include "drawview.hxx"
// auto strip #include "slidview.hxx"
#include "helpids.h"
namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif
#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif

using namespace ::com::sun::star;

// ------------------------
// - SdNavigatorDropEvent -
// ------------------------

struct SdNavigatorDropEvent : public ExecuteDropEvent
{
    DropTargetHelper&       mrTargetHelper;
    SdWindow*               mpTargetWindow;
	USHORT					mnPage;
	USHORT					mnLayer;

				SdNavigatorDropEvent( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
                                      SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer ) :
					ExecuteDropEvent( rEvt ), 
                    mrTargetHelper( rTargetHelper ), 
                    mpTargetWindow( pTargetWindow ),
                    mnPage( nPage ), 
                    mnLayer( nLayer ) {}
};

// -----------------------------------------------------------------------------

//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > SdView::CreateClipboardDataObject( SdView* pWorkView, Window& rWindow )
//STRIP001 {
//STRIP001 	// since SdTransferable::CopyToClipboard is called, this
//STRIP001 	// dynamically created object ist destroyed automatically
//STRIP001 	SdTransferable* pTransferable = new SdTransferable( pDoc, NULL, FALSE );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 
//STRIP001 	SD_MOD()->pTransferClip = pTransferable;
//STRIP001 
//STRIP001 	pDoc->CreatingDataObj( pTransferable );
//STRIP001 	pTransferable->SetWorkDocument( (SdDrawDocument*) GetAllMarkedModel() );
//STRIP001 	pDoc->CreatingDataObj( NULL );
//STRIP001 
//STRIP001 	const Rectangle					aMarkRect( GetAllMarkedRect() );
//STRIP001 	TransferableObjectDescriptor	aObjDesc;
//STRIP001 	String							aDisplayName;
//STRIP001 	SdrOle2Obj*						pSdrOleObj = NULL;
//STRIP001 	SdrPageView*					pPgView = GetPageViewPvNum( 0 );
//STRIP001 	SdPage*							pOldPage = pPgView ? ( (SdPage*) pPgView->GetPage() ) : NULL;
//STRIP001 	SdPage*							pNewPage = (SdPage*) pTransferable->GetWorkDocument()->GetPage( 0 );
//STRIP001 
//STRIP001     if( pOldPage )
//STRIP001     {
//STRIP001     	pNewPage->SetSize( pOldPage->GetSize() );
//STRIP001         pNewPage->SetLayoutName( pOldPage->GetLayoutName() );
//STRIP001     }
//STRIP001 
//STRIP001 	if( aMark.GetMarkCount() == 1 )
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aMark.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 		if( pObj && pObj->ISA(SdrOle2Obj) && ((SdrOle2Obj*) pObj)->GetObjRef().Is() )
//STRIP001 			pSdrOleObj = (SdrOle2Obj*) pObj;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pSdrOleObj )
//STRIP001 		pSdrOleObj->GetObjRef()->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 	else
//STRIP001 		pTransferable->GetWorkDocument()->GetDocSh()->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 
//STRIP001 	if( pDocSh )
//STRIP001 		aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 
//STRIP001 	aObjDesc.maSize = aMarkRect.GetSize();
//STRIP001 
//STRIP001 	pTransferable->SetStartPos( aMarkRect.TopLeft() );
//STRIP001 	pTransferable->SetObjectDescriptor( aObjDesc );
//STRIP001 	pTransferable->CopyToClipboard( pViewSh->GetActiveWindow() );
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > SdView::CreateDragDataObject( SdView* pWorkView, Window& rWindow, const Point& rDragPos )
//STRIP001 {
//STRIP001 	SdTransferable* pTransferable = new SdTransferable( pDoc, pWorkView, FALSE );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 
//STRIP001 	SD_MOD()->pTransferDrag = pTransferable;
//STRIP001 
//STRIP001 	TransferableObjectDescriptor	aObjDesc;
//STRIP001 	String							aDisplayName;
//STRIP001 	SdrOle2Obj*						pSdrOleObj = NULL;
//STRIP001 
//STRIP001 	if( aMark.GetMarkCount() == 1 )
//STRIP001 	{
//STRIP001 		SdrObject* pObj = aMark.GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001 		if( pObj && pObj->ISA( SdrOle2Obj ) && ( (SdrOle2Obj*) pObj )->GetObjRef().Is() )
//STRIP001 			pSdrOleObj = (SdrOle2Obj*) pObj;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pDocSh )
//STRIP001 		aDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 
//STRIP001 	if( pSdrOleObj )
//STRIP001 		pSdrOleObj->GetObjRef()->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 	else
//STRIP001 		pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 
//STRIP001 	aObjDesc.maSize = GetAllMarkedRect().GetSize();
//STRIP001 	aObjDesc.maDragStartPos = rDragPos;
//STRIP001 	aObjDesc.maDisplayName = aDisplayName;
//STRIP001 	aObjDesc.mbCanLink = FALSE;
//STRIP001 
//STRIP001 	pTransferable->SetStartPos( rDragPos );
//STRIP001 	pTransferable->SetObjectDescriptor( aObjDesc );
//STRIP001     pTransferable->StartDrag( &rWindow, DND_ACTION_COPYMOVE | DND_ACTION_LINK );
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > SdView::CreateSelectionDataObject( SdView* pWorkView, Window& rWindow )
//STRIP001 {
//STRIP001 	SdTransferable*                 pTransferable = new SdTransferable( pDoc, pWorkView, TRUE );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
//STRIP001 	TransferableObjectDescriptor	aObjDesc;
//STRIP001 	const Rectangle					aMarkRect( GetAllMarkedRect() );
//STRIP001 	String							aDisplayName;
//STRIP001 
//STRIP001 	SD_MOD()->pTransferSelection = pTransferable;
//STRIP001 
//STRIP001 	if( pDocSh )
//STRIP001     {
//STRIP001 		aDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 		pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001     }
//STRIP001 
//STRIP001 	aObjDesc.maSize = aMarkRect.GetSize();
//STRIP001 
//STRIP001 	pTransferable->SetStartPos( aMarkRect.TopLeft() );
//STRIP001 	pTransferable->SetObjectDescriptor( aObjDesc );
//STRIP001     pTransferable->CopyToSelection( &rWindow );
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }

// -----------------------------------------------------------------------------

/*N*/ void SdView::UpdateSelectionClipboard( BOOL bForceDeselect )
/*N*/ {
/*N*/     if( pViewSh && pViewSh->GetActiveWindow() )
/*N*/     {
/*N*/ 			if( !bForceDeselect && GetMarkList().GetMarkCount() )
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");}  //STRIP001 /*?*/             CreateSelectionDataObject( this, *pViewSh->GetActiveWindow() );
/*?*/         else if( SD_MOD()->pTransferSelection && ( SD_MOD()->pTransferSelection->GetView() == this ) )
/*N*/ 			{
/*?*/  				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/             TransferableHelper::ClearSelection( pViewSh->GetActiveWindow() );
//STRIP001 /*?*/            SD_MOD()->pTransferSelection = NULL;
/*N*/ 			}
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------------

//STRIP001 void SdView::DoCut(Window* pWindow)
//STRIP001 {
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 		( (OutlinerView*) pOLV)->Cut();
//STRIP001 	else if( HasMarkedObj() )
//STRIP001 	{
//STRIP001 		String aStr( SdResId(STR_UNDO_CUT) );
//STRIP001 
//STRIP001 		DoCopy();
//STRIP001 		BegUndo( ( aStr += sal_Unicode(' ') ) += aMark.GetMarkDescription() );
//STRIP001 		DeleteMarked();
//STRIP001 		EndUndo();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdView::DoCopy(Window* pWindow)
//STRIP001 {
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 		( (OutlinerView*) pOLV)->Copy();
//STRIP001 	else if( HasMarkedObj() )
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 		CreateClipboardDataObject( this, *pWindow );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdView::DoPaste( Window* pWindow )
//STRIP001 {
//STRIP001 	const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 
//STRIP001 	if( pOLV )
//STRIP001 	{
//STRIP001 		( (OutlinerView*) pOLV)->PasteSpecial();
//STRIP001 
//STRIP001 		SdrObject*	pObj = GetTextEditObject();
//STRIP001 		SdPage*		pPage = (SdPage*)( pObj ? pObj->GetPage() : NULL );
//STRIP001 		Outliner*	pOutliner = pOLV->GetOutliner();
//STRIP001 
//STRIP001 		if( pOutliner)
//STRIP001 		{
//STRIP001 			if( pObj && pPage && pPage->GetPresObjKind(pObj) == PRESOBJ_TITLE )
//STRIP001 			{
//STRIP001 				// remove all hard linebreaks from the title
//STRIP001 				if( pOutliner && pOutliner->GetParagraphCount() > 1 )
//STRIP001 				{
//STRIP001 					BOOL bOldUpdateMode = pOutliner->GetUpdateMode();
//STRIP001 
//STRIP001 					pOutliner->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 					const EditEngine& rEdit = pOutliner->GetEditEngine();
//STRIP001 					const int nParaCount = rEdit.GetParagraphCount();
//STRIP001 
//STRIP001 					for( int nPara = nParaCount - 2; nPara >= 0; nPara-- )
//STRIP001 					{
//STRIP001 						const int nParaLen = rEdit.GetTextLen( nPara );
//STRIP001 						pOutliner->QuickDelete( ESelection( nPara, nParaLen, nPara+1, 0 ) );
//STRIP001 						pOutliner->QuickInsertLineBreak( ESelection( nPara, nParaLen, nPara, nParaLen ) );
//STRIP001 					}
//STRIP001 
//STRIP001 					DBG_ASSERT( rEdit.GetParagraphCount() <= 1, "Titelobjekt contains hard line breaks" );
//STRIP001 					pOutliner->SetUpdateMode(bOldUpdateMode);
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !pDoc->IsChanged() )
//STRIP001 			{
//STRIP001 				if( pOutliner && pOutliner->IsModified() )
//STRIP001 					pDoc->SetChanged( TRUE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pViewSh->GetActiveWindow() ) );
//STRIP001 
//STRIP001 		if( aDataHelper.GetTransferable().is() )
//STRIP001 		{
//STRIP001             Point       aPos;       
//STRIP001 			sal_Int8    nDnDAction = DND_ACTION_COPY;
//STRIP001 
//STRIP001 		    if( pWindow )
//STRIP001 			    aPos = pWindow->PixelToLogic( Rectangle( aPos, pWindow->GetOutputSizePixel() ).Center() );
//STRIP001 
//STRIP001 			if( !InsertData( aDataHelper, aPos, nDnDAction, FALSE ) )
//STRIP001 			{
//STRIP001 				SdDrawViewShell* pDrViewSh = (SdDrawViewShell*) pDocSh->GetViewShell();
//STRIP001 
//STRIP001 				if( pDrViewSh )
//STRIP001 				{
//STRIP001 					String			aEmptyStr;
//STRIP001 					INetBookmark	aINetBookmark( aEmptyStr, aEmptyStr );
//STRIP001 
//STRIP001 					if( ( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) &&
//STRIP001 						  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aINetBookmark ) ) ||
//STRIP001 						( aDataHelper.HasFormat( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR ) &&
//STRIP001 						  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR, aINetBookmark ) ) ||
//STRIP001 						( aDataHelper.HasFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR ) &&
//STRIP001 						  aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR, aINetBookmark ) ) )
//STRIP001 					{
//STRIP001 						pDrViewSh->InsertURLField( aINetBookmark.GetURL(), aINetBookmark.GetDescription(), aEmptyStr, NULL );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdView::StartDrag( const Point& rStartPos, Window* pWindow )
//STRIP001 {
//STRIP001 	if( HasMarkedObj() && IsAction() && pViewSh && pWindow && !pDragSrcMarkList )
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 
//STRIP001 		if( IsTextEdit() )
//STRIP001             EndTextEdit();
//STRIP001 
//STRIP001 		SdViewShell* pViewShell= pDocSh->GetViewShell();
//STRIP001 
//STRIP001 		if( pViewShell && pViewShell->ISA( SdDrawViewShell ) )
//STRIP001 		{
//STRIP001 			FuPoor* pFunc = ( (SdDrawViewShell*) pViewShell )->GetActualFunction();
//STRIP001 
//STRIP001 			if( pFunc && pFunc->ISA( FuDraw ) )
//STRIP001 				( (FuDraw*) pFunc)->ForcePointer( NULL );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDragSrcMarkList = new SdrMarkList( aMark );
//STRIP001 		nDragSrcPgNum = GetPageViewPvNum(0)->GetPage()->GetPageNum();
//STRIP001 
//STRIP001 		String aStr( SdResId(STR_UNDO_DRAGDROP) );
//STRIP001 		aStr += sal_Unicode(' ');
//STRIP001 		aStr += pDragSrcMarkList->GetMarkDescription();
//STRIP001 		BegUndo(aStr);
//STRIP001 		CreateDragDataObject( this, *pWindow, rStartPos );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdView::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
//STRIP001 
//STRIP001 	if( pDragTransferable )
//STRIP001 		pDragTransferable->SetView( NULL );
//STRIP001 
//STRIP001 	if( ( nDropAction & DND_ACTION_MOVE ) && 
//STRIP001         pDragTransferable && !pDragTransferable->IsInternalMove() &&
//STRIP001         pDragSrcMarkList && pDragSrcMarkList->GetMarkCount() &&
//STRIP001 		!IsPresObjSelected() )
//STRIP001 	{
//STRIP001 		pDragSrcMarkList->ForceSort();
//STRIP001 		BegUndo();
//STRIP001 
//STRIP001 		ULONG nm, nAnz = pDragSrcMarkList->GetMarkCount();
//STRIP001 
//STRIP001  		for( nm = nAnz; nm>0; )
//STRIP001 		{
//STRIP001 			nm--;
//STRIP001 			SdrMark* pM=pDragSrcMarkList->GetMark(nm);
//STRIP001 			AddUndo(new SdrUndoDelObj(*pM->GetObj()));
//STRIP001 		}
//STRIP001 
//STRIP001 		pDragSrcMarkList->GetMark(0)->GetObj()->GetOrdNum();
//STRIP001 
//STRIP001 		for (nm=nAnz; nm>0;)
//STRIP001 		{
//STRIP001 			nm--;
//STRIP001 			SdrMark* pM=pDragSrcMarkList->GetMark(nm);
//STRIP001 			SdrObject* pObj=pM->GetObj();
//STRIP001 			UINT32 nOrdNum=pObj->GetOrdNumDirect();
//STRIP001             
//STRIP001             if( pObj && pObj->GetPage() )
//STRIP001             {
//STRIP001 			    SdrObject* pChkObj = pObj->GetPage()->RemoveObject(nOrdNum);
//STRIP001 			    DBG_ASSERT(pChkObj==pObj,"DeleteMarked(MarkList): pChkObj!=pObj beim RemoveObject()");
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001 		EndUndo();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pDragTransferable )
//STRIP001 		pDragTransferable->SetInternalMove( FALSE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 	nDragSrcPgNum = SDRPAGE_NOTFOUND;
//STRIP001 	delete pDragSrcMarkList, pDragSrcMarkList = NULL;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 sal_Int8 SdView::AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
//STRIP001                              SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001 	String			aLayerName( GetActiveLayer() );
//STRIP001 	SdrPageView*	pPV = GetPageViewPvNum(0);
//STRIP001 	sal_Int8		nDropAction = rEvt.mnAction;
//STRIP001 	sal_Int8		nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( nLayer != SDRLAYER_NOTFOUND )
//STRIP001 	{
//STRIP001 		SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 		aLayerName = rLayerAdmin.GetLayerPerID(nLayer)->GetName();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bIsDropAllowed && !pPV->IsLayerLocked( aLayerName ) && pPV->IsLayerVisible( aLayerName ) )
//STRIP001 	{
//STRIP001 		const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 		BOOL				bIsInsideOutlinerView = FALSE;
//STRIP001 
//STRIP001 		if( pOLV )
//STRIP001 		{
//STRIP001 			Rectangle aRect( pOLV->GetOutputArea() );
//STRIP001 
//STRIP001 			if (aMark.GetMarkCount() == 1)
//STRIP001 			{
//STRIP001 				SdrMark* pMark = aMark.GetMark(0);
//STRIP001 				SdrObject* pObj = pMark->GetObj();
//STRIP001 				aRect.Union( pObj->GetLogicRect() );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( aRect.IsInside( pOLV->GetWindow()->PixelToLogic( rEvt.maPosPixel ) ) )
//STRIP001 			{
//STRIP001 				bIsInsideOutlinerView = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bIsInsideOutlinerView )
//STRIP001 		{
//STRIP001 			SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
//STRIP001 
//STRIP001 			if( pDragTransferable )
//STRIP001 			{
//STRIP001 				const SdView* pSourceView = pDragTransferable->GetView();
//STRIP001 
//STRIP001 				if( pDragTransferable->IsPageTransferable() )
//STRIP001 				{
//STRIP001 					nRet = DND_ACTION_COPY;
//STRIP001 				}
//STRIP001 				else if( pSourceView )
//STRIP001 				{
//STRIP001 					if( !( nDropAction & DND_ACTION_LINK ) || 
//STRIP001                         pSourceView->GetDocSh()->GetMedium()->GetName().Len() )
//STRIP001                     {
//STRIP001 						nRet = nDropAction;
//STRIP001                     }
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const BOOL  bDrawing = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_DRAWING );
//STRIP001 				const BOOL  bGraphic = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_SVXB );
//STRIP001 				const BOOL	bMtf = rTargetHelper.IsDropFormatSupported( FORMAT_GDIMETAFILE );
//STRIP001 				const BOOL	bBitmap = rTargetHelper.IsDropFormatSupported( FORMAT_BITMAP );
//STRIP001 				BOOL	    bBookmark = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
//STRIP001 				BOOL	    bXFillExchange = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_XFA );
//STRIP001 
//STRIP001 		        // check handle insert
//STRIP001                 if( !nRet && ( bXFillExchange && ( SDRDRAG_GRADIENT == GetDragMode() ) || ( SDRDRAG_TRANSPARENCE == GetDragMode() ) ) )
//STRIP001 		        {
//STRIP001 			        const SdrHdlList& rHdlList = GetHdlList();
//STRIP001 
//STRIP001 			        for( sal_uInt32 n = 0; n < rHdlList.GetHdlCount(); n++ )
//STRIP001 			        {
//STRIP001 				        SdrHdl* pIAOHandle = rHdlList.GetHdl( n );
//STRIP001 
//STRIP001 				        if( pIAOHandle && ( HDL_COLR == pIAOHandle->GetKind() ) )
//STRIP001 				        {
//STRIP001 					        const B2dIAOGroup& rIAOGroup = pIAOHandle->GetIAOGroup();
//STRIP001 
//STRIP001 					        if( rIAOGroup.IsHit( rEvt.maPosPixel ) )
//STRIP001 					        {
//STRIP001                                 nRet = nDropAction;
//STRIP001 						        static_cast< SdrHdlColor* >( pIAOHandle )->SetSize( SDR_HANDLE_COLOR_SIZE_SELECTED );
//STRIP001 					        }
//STRIP001 					        else
//STRIP001 						        static_cast< SdrHdlColor* >( pIAOHandle )->SetSize( SDR_HANDLE_COLOR_SIZE_NORMAL );
//STRIP001 				        }
//STRIP001 			        }
//STRIP001 
//STRIP001 			        RefreshAllIAOManagers();
//STRIP001 		        }
//STRIP001 			
//STRIP001 		        // check object insert
//STRIP001 				if( !nRet && ( bXFillExchange || ( ( bDrawing || bGraphic || bMtf || bBitmap || bBookmark ) && ( nDropAction & DND_ACTION_LINK ) ) ) )
//STRIP001 				{
//STRIP001 					SdrObject*		pPickObj = NULL;
//STRIP001 					SdrPageView*	pPV = NULL;
//STRIP001 					SdWindow*		pWindow = pViewSh->GetActiveWindow();
//STRIP001 					USHORT			nHitLog = (USHORT) pWindow->PixelToLogic( Size( HITPIX, 0 ) ).Width();
//STRIP001 					Point			aPos( pWindow->PixelToLogic( rEvt.maPosPixel ) );
//STRIP001 					const BOOL		bHasPickObj = PickObj( aPos, pPickObj, pPV );
//STRIP001                     BOOL            bIsPresTarget = FALSE;
//STRIP001 
//STRIP001 					if( bHasPickObj && pPickObj && ( pPickObj->IsEmptyPresObj() || pPickObj->GetUserCall() ) )
//STRIP001 					{
//STRIP001 						SdPage* pPage = (SdPage*) pPickObj->GetPage();
//STRIP001 
//STRIP001 						if( pPage && pPage->IsMasterPage() )
//STRIP001 							bIsPresTarget = pPage->GetPresObjList()->GetPos( pPickObj ) != LIST_ENTRY_NOTFOUND;
//STRIP001 					}
//STRIP001 
//STRIP001 					if( bHasPickObj && !bIsPresTarget &&
//STRIP001 					    ( !pPickObj->ISA( SdrGrafObj ) || bGraphic || bMtf || bBitmap || ( bXFillExchange && !pPickObj->ISA( SdrGrafObj ) && !pPickObj->ISA( SdrOle2Obj ) ) ) )
//STRIP001 					{
//STRIP001 						if( !pDropMarker )
//STRIP001 							pDropMarker = new SdrViewUserMarker(this);
//STRIP001 
//STRIP001 						if( pDropMarkerObj != pPickObj )
//STRIP001 						{
//STRIP001 							pDropMarkerObj = pPickObj;
//STRIP001 							pDropMarker->SetXPolyPolygon( pDropMarkerObj, GetPageViewPvNum( 0 ) );
//STRIP001 							pDropMarker->Show();
//STRIP001 						}
//STRIP001 
//STRIP001                         nRet = nDropAction;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						bXFillExchange = FALSE;
//STRIP001 				}
//STRIP001 
//STRIP001                 // check normal insert
//STRIP001                 if( !nRet )
//STRIP001                 {
//STRIP001                     const BOOL  bSBAFormat = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_SVX_FORMFIELDEXCH );
//STRIP001                     const BOOL  bEditEngine = rTargetHelper.IsDropFormatSupported( SOT_FORMATSTR_ID_EDITENGINE );
//STRIP001                     const BOOL  bString = rTargetHelper.IsDropFormatSupported( FORMAT_STRING );
//STRIP001                     const BOOL  bRTF = rTargetHelper.IsDropFormatSupported( FORMAT_RTF );
//STRIP001                     const BOOL  bFile = rTargetHelper.IsDropFormatSupported( FORMAT_FILE );
//STRIP001 
//STRIP001 					if( pDropMarker )
//STRIP001 					{
//STRIP001 						pDropMarker->Hide();
//STRIP001 						pDropMarkerObj = NULL;
//STRIP001 					}
//STRIP001 
//STRIP001 	    			if( bBookmark && bFile && ( nDropAction & DND_ACTION_MOVE ) && ( !pViewSh || pViewSh->GetSlideShow() ) )
//STRIP001 		    			bBookmark = FALSE;
//STRIP001 
//STRIP001 				    if( bDrawing || bGraphic || bMtf || bBitmap || bBookmark || bFile || bXFillExchange || bSBAFormat || bEditEngine || bString || bRTF )
//STRIP001 					    nRet = nDropAction;
//STRIP001                 }
//STRIP001     		}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     // destroy drop marker if this is a leaving event
//STRIP001     if( rEvt.mbLeaving && pDropMarker )
//STRIP001 	{
//STRIP001 		pDropMarker->Hide();
//STRIP001 		delete pDropMarker, pDropMarker = NULL;
//STRIP001 		pDropMarkerObj = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 sal_Int8 SdView::ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
//STRIP001                               SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001 	SdrPageView*	pPV = GetPageViewPvNum( 0 );
//STRIP001 	String			aActiveLayer = GetActiveLayer();
//STRIP001 	sal_Int8		nDropAction = rEvt.mnAction;
//STRIP001 	sal_Int8		nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     // destroy drop marker if it is shown
//STRIP001 	if( pDropMarker )
//STRIP001 	{
//STRIP001 		pDropMarker->Hide();
//STRIP001 		delete pDropMarker, pDropMarker = NULL;
//STRIP001 		pDropMarkerObj = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pPV->IsLayerLocked( aActiveLayer ) )
//STRIP001 	{
//STRIP001 		const OutlinerView* pOLV = GetTextEditOutlinerView();
//STRIP001 		BOOL				bIsInsideOutlinerView = FALSE;
//STRIP001 
//STRIP001 		if( pOLV )
//STRIP001 		{
//STRIP001 			Rectangle aRect( pOLV->GetOutputArea() );
//STRIP001 
//STRIP001 			if( aMark.GetMarkCount() == 1 )
//STRIP001 			{
//STRIP001 				SdrMark* pMark = aMark.GetMark(0);
//STRIP001 				SdrObject* pObj = pMark->GetObj();
//STRIP001 				aRect.Union( pObj->GetLogicRect() );
//STRIP001 			}
//STRIP001 
//STRIP001 			Point aPos( pOLV->GetWindow()->PixelToLogic( rEvt.maPosPixel ) );
//STRIP001 
//STRIP001 			if( aRect.IsInside( aPos ) )
//STRIP001 			{
//STRIP001 				bIsInsideOutlinerView = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bIsInsideOutlinerView )
//STRIP001 		{
//STRIP001 			Point				    aPos;
//STRIP001 			SdDrawViewShell*	    pDrViewSh = (SdDrawViewShell*) pDocSh->GetViewShell();
//STRIP001 			SdrPage*			    pPage = NULL;
//STRIP001 			TransferableDataHelper	aDataHelper( rEvt.maDropEvent.Transferable );
//STRIP001 
//STRIP001 			if( pTargetWindow )
//STRIP001 				aPos = pTargetWindow->PixelToLogic( rEvt.maPosPixel );
//STRIP001 
//STRIP001             // handle insert?
//STRIP001             if( !nRet && ( SDRDRAG_GRADIENT == GetDragMode() ) || ( SDRDRAG_TRANSPARENCE == GetDragMode() ) && aDataHelper.HasFormat( SOT_FORMATSTR_ID_XFA ) )
//STRIP001 	        {
//STRIP001 		        const SdrHdlList& rHdlList = GetHdlList();
//STRIP001 
//STRIP001 		        for( sal_uInt32 n = 0; !nRet && n < rHdlList.GetHdlCount(); n++ )
//STRIP001 		        {
//STRIP001 			        SdrHdl* pIAOHandle = rHdlList.GetHdl( n );
//STRIP001 
//STRIP001 			        if( pIAOHandle && ( HDL_COLR == pIAOHandle->GetKind() ) )
//STRIP001 			        {
//STRIP001 				        const B2dIAOGroup& rIAOGroup = pIAOHandle->GetIAOGroup();
//STRIP001 
//STRIP001 				        if( rIAOGroup.IsHit( rEvt.maPosPixel ) )
//STRIP001 				        {
//STRIP001                     		SotStorageStreamRef xStm;
//STRIP001 
//STRIP001                     		if( aDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_XFA, xStm ) && xStm.Is() )
//STRIP001 		                    {
//STRIP001 			                    XFillExchangeData aFillData( XFillAttrSetItem( &pDoc->GetPool() ) );
//STRIP001 
//STRIP001                     			*xStm >> aFillData;
//STRIP001                                 const Color aColor( ( (XFillColorItem&) aFillData.GetXFillAttrSetItem()->GetItemSet().Get( XATTR_FILLCOLOR ) ).GetValue() );
//STRIP001             					static_cast< SdrHdlColor* >( pIAOHandle )->SetColor( aColor, TRUE );
//STRIP001                                 nRet = nDropAction;
//STRIP001 					        }
//STRIP001 				        }
//STRIP001 			        }
//STRIP001 		        }
//STRIP001         	}
//STRIP001 
//STRIP001             // standard insert?
//STRIP001             if( !nRet && InsertData( aDataHelper, aPos, nDropAction, TRUE, 0, nPage, nLayer ) )
//STRIP001     			nRet = nDropAction;
//STRIP001 
//STRIP001 			// special insert?
//STRIP001             if( !nRet && pViewSh )
//STRIP001 			{
//STRIP001 				String		    aTmpString1, aTmpString2;
//STRIP001 				INetBookmark	aINetBookmark( aTmpString1, aTmpString2 );
//STRIP001 
//STRIP001 				// insert bookmark
//STRIP001 				if( aDataHelper.HasFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) &&
//STRIP001 					aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aINetBookmark ) )
//STRIP001 				{
//STRIP001 				    SdPageObjsTLB::SdPageObjsTransferable* pPageObjsTransferable = SdPageObjsTLB::SdPageObjsTransferable::getImplementation( aDataHelper.GetXTransferable() );
//STRIP001 				    
//STRIP001 				    if( pPageObjsTransferable &&
//STRIP001 				        ( NAVIGATOR_DRAGTYPE_LINK == pPageObjsTransferable->GetDragType() ||
//STRIP001 				          NAVIGATOR_DRAGTYPE_EMBEDDED == pPageObjsTransferable->GetDragType() ) )
//STRIP001 				    {
//STRIP001 						// insert bookmark from own navigator (handled async. due to possible message box )
//STRIP001 						Application::PostUserEvent( LINK( this, SdView, ExecuteNavigatorDrop ),
//STRIP001 													new SdNavigatorDropEvent( rEvt, rTargetHelper, pTargetWindow, 
//STRIP001                                                                               nPage, nLayer ) );
//STRIP001 						nRet = nDropAction;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SdrObject*		pPickObj = NULL;
//STRIP001 						SdrPageView*	pPV = NULL;
//STRIP001 						SdWindow*		pWindow = pViewSh->GetActiveWindow();
//STRIP001 						USHORT			nHitLog = USHORT(pWindow->PixelToLogic(Size(HITPIX,0)).Width());
//STRIP001 
//STRIP001 						if( PickObj( aPos, pPickObj, pPV ) )
//STRIP001 						{
//STRIP001 							// insert as clip action => jump
//STRIP001 							String				aBookmark( aINetBookmark.GetURL() );
//STRIP001 							SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pPickObj );
//STRIP001 							BOOL				bCreated = FALSE;
//STRIP001 
//STRIP001 							if( aBookmark.Len() )
//STRIP001 							{
//STRIP001 								presentation::ClickAction eClickAction = presentation::ClickAction_DOCUMENT;
//STRIP001 								String aDocName( aBookmark.GetToken( 0, '#' ) );
//STRIP001 
//STRIP001 								if( pDocSh->GetMedium()->GetName() == aDocName || pDocSh->GetName() == aDocName )
//STRIP001 								{
//STRIP001 									// Interner Sprung -> nur "#Bookmark" verwenden
//STRIP001 									aBookmark = aBookmark.GetToken( 1, '#' );
//STRIP001 									eClickAction = presentation::ClickAction_BOOKMARK;
//STRIP001 								}
//STRIP001 
//STRIP001 								if( !pInfo )
//STRIP001 								{
//STRIP001 									pInfo = new SdAnimationInfo( pDoc );
//STRIP001 									pPickObj->InsertUserData( pInfo );
//STRIP001 									bCreated = TRUE;
//STRIP001 								}
//STRIP001 
//STRIP001 								// Undo-Action mit alten und neuen Groessen erzeugen
//STRIP001 								SdAnimationPrmsUndoAction* pAction = new SdAnimationPrmsUndoAction(pDoc, pPickObj, bCreated);
//STRIP001 								pAction->SetActive(pInfo->bActive, pInfo->bActive);
//STRIP001 								pAction->SetEffect(pInfo->eEffect, pInfo->eEffect);
//STRIP001 								pAction->SetTextEffect(pInfo->eTextEffect, pInfo->eTextEffect);
//STRIP001 								pAction->SetSpeed(pInfo->eSpeed, pInfo->eSpeed);
//STRIP001 								pAction->SetDim(pInfo->bDimPrevious, pInfo->bDimPrevious);
//STRIP001 								pAction->SetDimColor(pInfo->aDimColor, pInfo->aDimColor);
//STRIP001 								pAction->SetDimHide(pInfo->bDimHide, pInfo->bDimHide);
//STRIP001 								pAction->SetSoundOn(pInfo->bSoundOn, pInfo->bSoundOn);
//STRIP001 								pAction->SetSound(pInfo->aSoundFile, pInfo->aSoundFile);
//STRIP001 								pAction->SetPlayFull(pInfo->bPlayFull, pInfo->bPlayFull);
//STRIP001 								pAction->SetPathObj(pInfo->pPathObj, pInfo->pPathObj);
//STRIP001 								pAction->SetClickAction(pInfo->eClickAction, eClickAction);
//STRIP001 								pAction->SetBookmark(pInfo->aBookmark, aBookmark);
//STRIP001 								pAction->SetInvisibleInPres(pInfo->bInvisibleInPresentation, TRUE);
//STRIP001 								pAction->SetVerb(pInfo->nVerb, pInfo->nVerb);
//STRIP001 								pAction->SetSecondEffect(pInfo->eSecondEffect, pInfo->eSecondEffect);
//STRIP001 								pAction->SetSecondSpeed(pInfo->eSecondSpeed, pInfo->eSecondSpeed);
//STRIP001 								pAction->SetSecondSoundOn(pInfo->bSecondSoundOn, pInfo->bSecondSoundOn);
//STRIP001 								pAction->SetSecondPlayFull(pInfo->bSecondPlayFull, pInfo->bSecondPlayFull);
//STRIP001 
//STRIP001 								String aString(SdResId(STR_UNDO_ANIMATION));
//STRIP001 								pAction->SetComment(aString);
//STRIP001 								pDocSh->GetUndoManager()->AddUndoAction(pAction);
//STRIP001 								pInfo->eClickAction = eClickAction;
//STRIP001 								pInfo->aBookmark = aBookmark;
//STRIP001 								pDoc->SetChanged();
//STRIP001 
//STRIP001 								nRet = nDropAction;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else if( pViewSh->ISA( SdDrawViewShell ) )
//STRIP001 						{
//STRIP001 							// insert as normal URL button
//STRIP001 							( (SdDrawViewShell*) pViewSh )->InsertURLButton( aINetBookmark.GetURL(), aINetBookmark.GetDescription(), String(), &aPos );
//STRIP001 							nRet = nDropAction;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SdView, ExecuteNavigatorDrop, SdNavigatorDropEvent*, pSdNavigatorDropEvent )
//STRIP001 {
//STRIP001 	TransferableDataHelper	                aDataHelper( pSdNavigatorDropEvent->maDropEvent.Transferable );
//STRIP001     SdPageObjsTLB::SdPageObjsTransferable*  pPageObjsTransferable = SdPageObjsTLB::SdPageObjsTransferable::getImplementation( aDataHelper.GetXTransferable() );
//STRIP001 	INetBookmark			                aINetBookmark;
//STRIP001 
//STRIP001 	if( pPageObjsTransferable && aDataHelper.GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aINetBookmark ) )
//STRIP001 	{
//STRIP001 		Point	aPos;
//STRIP001 		List	aBookmarkList;
//STRIP001 		String	aBookmark;
//STRIP001 		String	aFile;
//STRIP001 		SdPage*	pPage = (SdPage*) GetPageViewPvNum( 0 )->GetPage();
//STRIP001 		USHORT	nPgPos = 0xFFFF;
//STRIP001 
//STRIP001 		if( pSdNavigatorDropEvent->mpTargetWindow )
//STRIP001 			aPos = pSdNavigatorDropEvent->mpTargetWindow->PixelToLogic( pSdNavigatorDropEvent->maPosPixel );
//STRIP001 
//STRIP001 		aFile = aINetBookmark.GetURL().GetToken( 0, '#' );
//STRIP001 		aBookmark = aINetBookmark.GetURL().GetToken( 1, '#' );
//STRIP001 		aBookmarkList.Insert( &aBookmark );
//STRIP001 
//STRIP001 		if( !pPage->IsMasterPage() )
//STRIP001 		{
//STRIP001 			if( pPage->GetPageKind() == PK_STANDARD )
//STRIP001 				nPgPos = pPage->GetPageNum() + 2;
//STRIP001 			else if( pPage->GetPageKind() == PK_NOTES )
//STRIP001 				nPgPos = pPage->GetPageNum() + 1;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Um zu gewaehrleisten, dass alle Seitennamen eindeutig sind, werden
//STRIP001 		// die einzufuegenden geprueft und gegebenenfalls in einer Ersatzliste
//STRIP001 		// aufgenommen (bNameOK == FALSE -> Benutzer hat abgebrochen)
//STRIP001 		List*	pExchangeList = NULL;
//STRIP001 		BOOL	bLink = ( NAVIGATOR_DRAGTYPE_LINK == pPageObjsTransferable->GetDragType()  ? TRUE : FALSE );
//STRIP001 		BOOL	bNameOK = GetExchangeList( pExchangeList, &aBookmarkList, 2 );
//STRIP001 		BOOL	bReplace = FALSE;
//STRIP001 
//STRIP001 		// Da man hier nicht weiss, ob es sich um eine Seite oder ein Objekt handelt,
//STRIP001 		// wird eine Liste sowohl mit Seiten, als auch mit Objekten gefuellt.
//STRIP001 		// Sollten Seitennamen und Objektnamen identisch sein gibt es hier natuerlich Probleme !!!
//STRIP001 		if( bNameOK )
//STRIP001 		{
//STRIP001 			pDoc->InsertBookmark( &aBookmarkList, pExchangeList,
//STRIP001 								  bLink, bReplace, nPgPos, FALSE,
//STRIP001 								  &pPageObjsTransferable->GetDocShell(),
//STRIP001 								  TRUE, &aPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Loeschen der ExchangeList
//STRIP001 		if( pExchangeList )
//STRIP001 		{
//STRIP001 			for( void* p = pExchangeList->First(); p; p = pExchangeList->Next() )
//STRIP001 				delete (String*) p;
//STRIP001 
//STRIP001 			delete pExchangeList;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pSdNavigatorDropEvent;
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Rueckgabeparameter:
|* pExchangeList == NULL -> Namen sind alle eindeutig
|* bNameOK == FALSE -> Benutzer hat abgebrochen
|* nType == 0 -> Seiten
|* nType == 1 -> Objekte
|* nType == 2 -> Seiten + Objekte
|*
\************************************************************************/

//STRIP001 BOOL SdView::GetExchangeList( List*& rpExchangeList, List* pBookmarkList, USHORT nType )
//STRIP001 {
//STRIP001 	DBG_ASSERT( !rpExchangeList, "ExchangeList muss NULL sein!");
//STRIP001 
//STRIP001 	BOOL bListIdentical = TRUE; // BookmarkList und ExchangeList sind gleich
//STRIP001 	BOOL bNameOK = TRUE;		// Name ist eindeutig
//STRIP001 
//STRIP001 	rpExchangeList = new List();
//STRIP001 
//STRIP001 	if( pBookmarkList )
//STRIP001 	{
//STRIP001 		String* pString = (String*) pBookmarkList->First();
//STRIP001 		
//STRIP001         while( pString && bNameOK )
//STRIP001 		{
//STRIP001 			String* pNewName = new String( *pString );
//STRIP001 			
//STRIP001             if( nType == 0  || nType == 2 )
//STRIP001 				bNameOK = pDocSh->CheckPageName( pViewSh->GetWindow(), *pNewName );
//STRIP001 			
//STRIP001             if( bNameOK && ( nType == 1  || nType == 2 ) )
//STRIP001             {
//STRIP001                 if( pDoc->GetObj( *pNewName ) )
//STRIP001 	            {
//STRIP001                     String          aTitle( SdResId( STR_TITLE_NAMEGROUP ) );
//STRIP001                     String          aDesc( SdResId( STR_DESC_NAMEGROUP ) );
//STRIP001 		            SvxNameDialog*  pDlg = new SvxNameDialog( pViewSh->GetWindow(), *pNewName, aDesc );
//STRIP001 					pDlg->SetEditHelpId( HID_SD_NAMEDIALOG_OBJECT );
//STRIP001 
//STRIP001                     bNameOK = FALSE;
//STRIP001                     pDlg->SetText( aTitle );
//STRIP001 
//STRIP001 		            while( !bNameOK && pDlg->Execute() == RET_OK )
//STRIP001 		            {
//STRIP001 			            pDlg->GetName( *pNewName );
//STRIP001 			            
//STRIP001                         if( !pDoc->GetObj( *pNewName ) )
//STRIP001                             bNameOK = TRUE;
//STRIP001 		            }
//STRIP001 
//STRIP001 		            delete pDlg;
//STRIP001 	            }
//STRIP001             }
//STRIP001 
//STRIP001 			if( bListIdentical )
//STRIP001 				bListIdentical = ( *pString == *pNewName );
//STRIP001 
//STRIP001 			rpExchangeList->Insert( pNewName, LIST_APPEND );
//STRIP001 			pString = (String*) pBookmarkList->Next();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// ExchangeList ist mit BookmarkList identisch
//STRIP001 	if( rpExchangeList && bListIdentical )
//STRIP001 	{
//STRIP001 		String* pString = (String*) rpExchangeList->First();
//STRIP001 		while( pString )
//STRIP001 		{
//STRIP001 			delete pString;
//STRIP001 			pString = (String*) rpExchangeList->Next();
//STRIP001 		}
//STRIP001 		delete rpExchangeList;
//STRIP001 		rpExchangeList = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bNameOK );
//STRIP001 }

typedef std::vector< std::pair< sal_uInt32, sal_uInt32 > > PathSurrogateVector;
typedef std::vector< SdrObject* > SdrObjectVector;

//STRIP001 void ImplProcessObjectList(SdrObject* pObj, SdrObjectVector& rVector )
//STRIP001 {
//STRIP001 	sal_Bool bIsGroup(pObj->IsGroupObject());
//STRIP001 	if(bIsGroup && pObj->ISA(E3dObject) && !pObj->ISA(E3dScene))
//STRIP001 		bIsGroup = sal_False;
//STRIP001 
//STRIP001 	rVector.push_back( pObj );
//STRIP001 
//STRIP001 	if(bIsGroup)
//STRIP001 	{
//STRIP001 		SdrObjList* pObjList = pObj->GetSubList();
//STRIP001 		sal_uInt32 a;
//STRIP001 		for( a = 0; a < pObjList->GetObjCount(); a++)
//STRIP001 			ImplProcessObjectList(pObjList->GetObj(a), rVector);
//STRIP001 	}
//STRIP001 }

/** this method restores all connections between shapes with animations along a path and theire path */
//STRIP001 SdrModel* SdView::GetMarkedObjModel() const
//STRIP001 {
//STRIP001 	// this vector holds the index of all shapes with animations along a path and the index
//STRIP001 	// of theire corresponding path. The index is a flat index
//STRIP001 	PathSurrogateVector aPathSurro;
//STRIP001 
//STRIP001 	// this is a list with index's of all shapes with animation infos in the source list
//STRIP001 	// it is used to later update the nPresOrder counter
//STRIP001 	std::vector< std::pair< sal_uInt32, sal_uInt32 > > aAnimObjects;
//STRIP001 
//STRIP001 	{
//STRIP001 		// get a flat vector of all shapes inside the mark list first, including deep within groups
//STRIP001 		SdrObjectVector aSdrVector;
//STRIP001 		const sal_uInt32 nMarkCount = aMark.GetMarkCount();
//STRIP001 		sal_uInt32 nMark;
//STRIP001 		for(nMark = 0; nMark < nMarkCount; nMark++ ) 
//STRIP001 		{
//STRIP001 			ImplProcessObjectList( aMark.GetMark( nMark )->GetObj(), aSdrVector );
//STRIP001 		}
//STRIP001 			
//STRIP001 		// now see if we find any shape with an animation along a path
//STRIP001 		sal_uInt32 nObj = 0;
//STRIP001 		SdrObjectVector::iterator aIter( aSdrVector.begin() );
//STRIP001 		const SdrObjectVector::iterator aEnd( aSdrVector.end() );
//STRIP001 		while( aIter != aEnd )
//STRIP001 		{
//STRIP001 			const SdrObject* pObj = (*aIter++);
//STRIP001 
//STRIP001 			if( pObj )
//STRIP001 			{
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(const_cast<SdrObject*>(pObj));
//STRIP001 				if( pInfo)
//STRIP001 				{
//STRIP001 					if( pInfo->eEffect == presentation::AnimationEffect_PATH && pInfo->pPathObj)
//STRIP001 					{
//STRIP001 						// we found one, now look for the path
//STRIP001 						SdrObjectVector::iterator aPathIter( aSdrVector.begin() );
//STRIP001 						sal_uInt32 nPath = 0;
//STRIP001 
//STRIP001 						while( aPathIter != aEnd )
//STRIP001 						{
//STRIP001 							SdrObject* pPathObj = (*aPathIter++);
//STRIP001 							if( pPathObj == pInfo->pPathObj )
//STRIP001 							{
//STRIP001 								// we found the path, so store the indices
//STRIP001 								aPathSurro.push_back( std::pair< sal_uInt32, sal_uInt32 >( nObj, nPath ) );
//STRIP001 								break;
//STRIP001 							}
//STRIP001 							nPath++;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if( pInfo->nPresOrder != LIST_APPEND )
//STRIP001 					{
//STRIP001 						aAnimObjects.push_back( std::pair< sal_uInt32, sal_uInt32 >( nObj, pInfo->nPresOrder ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nObj++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// let the base class create the model
//STRIP001 	SdrModel* pNewModel = FmFormView::GetMarkedObjModel();
//STRIP001 
//STRIP001 	// if we had any shapes with animations along a path...
//STRIP001 	if( !aPathSurro.empty() )
//STRIP001 	{
//STRIP001 		// restore theire connections to the they're path shapes
//STRIP001 		SdrPage* pPage = pNewModel->GetPage(0);
//STRIP001 		SdrObjListIter	aObjIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 		PathSurrogateVector::iterator aIter = aPathSurro.begin();
//STRIP001 		const PathSurrogateVector::iterator aEnd = aPathSurro.end();
//STRIP001 
//STRIP001 		while( aIter != aEnd )
//STRIP001 		{
//STRIP001 
//STRIP001 			sal_uInt32 nObject = (*aIter).first;
//STRIP001 			SdrObject* pObject = NULL;
//STRIP001 			aObjIter.Reset();
//STRIP001 			while( (pObject = aObjIter.Next()) && nObject-- );
//STRIP001 
//STRIP001 			SdrObject* pPath = NULL;
//STRIP001 			nObject = (*aIter).second;
//STRIP001 			aObjIter.Reset();
//STRIP001 			while( (pPath = aObjIter.Next()) && nObject-- );
//STRIP001 
//STRIP001 			if( pObject && pPath )
//STRIP001 			{
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 				if( pInfo == NULL )
//STRIP001 				{
//STRIP001 					pInfo = new SdAnimationInfo(pDoc);
//STRIP001 					pObject->InsertUserData( pInfo );
//STRIP001 				}
//STRIP001 
//STRIP001 				pInfo->eEffect = presentation::AnimationEffect_PATH;
//STRIP001 				pInfo->pPathObj = PTR_CAST( SdrPathObj, pPath );
//STRIP001 			}
//STRIP001 
//STRIP001 			aIter++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// restore presentation order
//STRIP001 	if( !aAnimObjects.empty() )
//STRIP001 	{
//STRIP001 		sal_uInt32 nCurrent = 0;
//STRIP001 		SdrPage* pPage = pNewModel->GetPage(0);
//STRIP001 		SdrObjListIter	aObjIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 		SdrObject* pObj = aObjIter.Next();
//STRIP001 
//STRIP001 		std::vector< std::pair< sal_uInt32, sal_uInt32 > >::iterator aIter( aAnimObjects.begin() );
//STRIP001 		std::vector< std::pair< sal_uInt32, sal_uInt32 > >::iterator aEnd( aAnimObjects.end() );
//STRIP001 		while( aIter != aEnd )
//STRIP001 		{
//STRIP001 			sal_uInt32 nObject = (*aIter).first;
//STRIP001 
//STRIP001 			while( (nCurrent < nObject) && aObjIter.IsMore() )
//STRIP001 			{
//STRIP001 				nCurrent++;
//STRIP001 				pObj = aObjIter.Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			DBG_ASSERT( nCurrent == nObject, "wrong shape count after paste!" );
//STRIP001 			if( nCurrent != nObject )
//STRIP001 				break;
//STRIP001 
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 			DBG_ASSERT( pInfo, "shape that should have an animation info hasn't after paste!" );
//STRIP001 
//STRIP001 			if( pInfo )
//STRIP001 				pInfo->nPresOrder = (*aIter).second;
//STRIP001 
//STRIP001 			aIter++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pNewModel;
//STRIP001 }

/** this method restores all connections between shapes with animations along a path and theire path */
//STRIP001 BOOL SdView::Paste(const SdrModel& rMod, const Point& rPos, SdrObjList* pLst /* =NULL */, UINT32 nOptions /* =0 */)
//STRIP001 {
//STRIP001 	// this vector holds the index of all shapes with animations along a path and the index
//STRIP001 	// of theire corresponding path. The index is a flat index
//STRIP001 	PathSurrogateVector aPathSurro;
//STRIP001 
//STRIP001 	// this is a list with index's of all shapes with animation infos in the source list
//STRIP001 	// it is used to later update the nPresOrder counter
//STRIP001 	std::vector< std::pair< sal_uInt32, sal_uInt32 > > aAnimObjects;
//STRIP001 
//STRIP001 	// get the destination object list or page
//STRIP001 	SdrObjList* pDstList = pLst;
//STRIP001 	if( NULL == pDstList )
//STRIP001 	{
//STRIP001 		SdrPageView* pPV=GetPageView(rPos);
//STRIP001 		if (pPV!=NULL)
//STRIP001 			pDstList=pPV->GetObjList();
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_uInt32 nMaxPresOrder = 0;
//STRIP001 
//STRIP001 	sal_uInt32 nDstObjCount = 0;
//STRIP001 	if( pDstList )
//STRIP001 	{
//STRIP001 		// first we need the flat count of shapes already in the destination
//STRIP001 		// object list, so we can have the absolut index of newly created shapes
//STRIP001 		{
//STRIP001 			SdrObjListIter	aIter( *pDstList, IM_DEEPWITHGROUPS );
//STRIP001 			while( aIter.IsMore() )
//STRIP001 			{
//STRIP001 				SdrObject* pObj = aIter.Next();
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(const_cast<SdrObject*>(pObj));
//STRIP001 				if( pInfo && (pInfo->nPresOrder != LIST_APPEND) && (pInfo->nPresOrder > nMaxPresOrder) )
//STRIP001 					nMaxPresOrder = pInfo->nPresOrder;
//STRIP001 
//STRIP001 				nDstObjCount++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// now find all shapes with an animation at path set and theire path shape
//STRIP001 		sal_uInt32 nPageCount = rMod.GetPageCount();
//STRIP001 		sal_uInt32 nPage;
//STRIP001 		for( nPage=0; nPage < nPageCount; nPage++ )
//STRIP001 		{
//STRIP001 			const SdrPage* pPage = rMod.GetPage( 0 );
//STRIP001 			if( pPage )
//STRIP001 			{
//STRIP001 				SdrObjListIter	aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 				const sal_uInt32 nObjCount = pPage->GetObjCount();
//STRIP001 				sal_uInt32 nObj;
//STRIP001 				SdrObject* pObj;
//STRIP001 				for( pObj = aIter.Next(), nObj = 0; pObj; pObj = aIter.Next(), nObj++ )
//STRIP001 				{
//STRIP001 					SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(const_cast<SdrObject*>(pObj));
//STRIP001 					if( pInfo )
//STRIP001 					{
//STRIP001 						if( pInfo->eEffect == presentation::AnimationEffect_PATH && pInfo->pPathObj)
//STRIP001 						{
//STRIP001 							SdrObjListIter	aPathIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 							sal_uInt32 nPath;
//STRIP001 							SdrObject* pPath;
//STRIP001 							for( pPath = aPathIter.Next(), nPath = 0; pPath; pPath = aPathIter.Next(), nPath++ )
//STRIP001 							{
//STRIP001 								if( pPath == pInfo->pPathObj )
//STRIP001 								{
//STRIP001 									aPathSurro.push_back( std::pair< sal_uInt32, sal_uInt32 >( nDstObjCount + nObj, nDstObjCount + nPath ) );
//STRIP001 									break;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if( pInfo->nPresOrder != LIST_APPEND )
//STRIP001 						{
//STRIP001 							const sal_uInt32 nNewPresOrder = pInfo->nPresOrder + 1 + nMaxPresOrder;
//STRIP001 							aAnimObjects.push_back( std::pair< sal_uInt32, sal_uInt32 >( nDstObjCount + nObj, nNewPresOrder ) );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bRet = FmFormView::Paste( rMod, rPos, pLst,nOptions );
//STRIP001 
//STRIP001 	if( bRet && !aPathSurro.empty() )
//STRIP001 	{
//STRIP001 		// restore all shapes with animation at path and theire path connections
//STRIP001 		PathSurrogateVector::iterator aIter = aPathSurro.begin();
//STRIP001 		const PathSurrogateVector::iterator aEnd = aPathSurro.end();
//STRIP001 
//STRIP001 		SdrObjListIter	aObjIter( *pDstList, IM_DEEPWITHGROUPS );
//STRIP001 
//STRIP001 		while( aIter != aEnd )
//STRIP001 		{
//STRIP001 			sal_uInt32 nObject = (*aIter).first;
//STRIP001 			SdrObject* pObject = NULL;
//STRIP001 			aObjIter.Reset();
//STRIP001 			while( (pObject = aObjIter.Next()) && nObject-- );
//STRIP001 
//STRIP001 			SdrObject* pPath = NULL;
//STRIP001 			nObject = (*aIter).second;
//STRIP001 			aObjIter.Reset();
//STRIP001 			while( (pPath = aObjIter.Next()) && nObject-- );
//STRIP001 
//STRIP001 			if( pObject && PTR_CAST( SdrPathObj, pPath ) )
//STRIP001 			{
//STRIP001 				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 				if( pInfo == NULL )
//STRIP001 				{
//STRIP001 					pInfo = new SdAnimationInfo(pDoc);
//STRIP001 					pObject->InsertUserData( pInfo );
//STRIP001 				}
//STRIP001 
//STRIP001 				pInfo->eEffect = presentation::AnimationEffect_PATH;
//STRIP001 				pInfo->pPathObj = PTR_CAST(SdrPathObj, pPath );
//STRIP001 			}
//STRIP001 
//STRIP001 			aIter++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bRet && !aAnimObjects.empty() )
//STRIP001 	{
//STRIP001 		sal_uInt32 nCurrent = 0;
//STRIP001 		SdrObjListIter	aObjIter( *pDstList, IM_DEEPWITHGROUPS );
//STRIP001 		SdrObject* pObj = aObjIter.Next();
//STRIP001 
//STRIP001 		std::vector< std::pair< sal_uInt32, sal_uInt32 > >::iterator aIter( aAnimObjects.begin() );
//STRIP001 		std::vector< std::pair< sal_uInt32, sal_uInt32 > >::iterator aEnd( aAnimObjects.end() );
//STRIP001 		while( aIter != aEnd )
//STRIP001 		{
//STRIP001 			sal_uInt32 nObject = (*aIter).first;
//STRIP001 
//STRIP001 			while( (nCurrent < nObject) && aObjIter.IsMore() )
//STRIP001 			{
//STRIP001 				nCurrent++;
//STRIP001 				pObj = aObjIter.Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			DBG_ASSERT( nCurrent == nObject, "wrong shape count after paste!" );
//STRIP001 			if( nCurrent != nObject )
//STRIP001 				break;
//STRIP001 
//STRIP001 			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 			DBG_ASSERT( pInfo, "shape that should have an animation info hasn't after paste!" );
//STRIP001 
//STRIP001 			if( pInfo )
//STRIP001 				pInfo->nPresOrder = (*aIter).second;
//STRIP001 
//STRIP001 			aIter++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

}
