/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_dinfdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:54:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _URLOBJ_HXX //autogen wg. INetURLObject
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen wg. RET_OK
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SVAPP_HXX
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif
// auto strip #ifndef _FILEDLGHELPER_HXX
// auto strip #include <filedlghelper.hxx>
// auto strip #endif

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <svtools/useroptions.hxx>
// auto strip #include <svtools/imagemgr.hxx>

#include <memory>

#pragma hdrstop

#include "dinfdlg.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "dinfedt.hxx"
// auto strip #include "frame.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "request.hxx"
// auto strip #include "exptypes.hxx"
// auto strip #include "helper.hxx"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif

#include "sfx.hrc"
#include "dinfdlg.hrc"
#include "sfxlocal.hrc"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

/*N*/ TYPEINIT1_AUTOFACTORY(SfxDocumentInfoItem, SfxStringItem);

//------------------------------------------------------------------------

//STRIP001 String ConvertDateTime_Impl( const SfxStamp& rStamp, const LocaleDataWrapper& rWrapper )
//STRIP001 {
//STRIP001 	 const String pDelim ( DEFINE_CONST_UNICODE( ", "));
//STRIP001 	 String aStr( rWrapper.getDate( rStamp.GetTime() ) );
//STRIP001 	 aStr += pDelim;
//STRIP001 	 aStr += rWrapper.getTime( rStamp.GetTime(), TRUE, FALSE );
//STRIP001 	 String aAuthor = rStamp.GetName();
//STRIP001 	 aAuthor.EraseLeadingChars();
//STRIP001 	 if ( aAuthor.Len() )
//STRIP001 	 {
//STRIP001 		aStr += pDelim;
//STRIP001 		aStr += aAuthor;
//STRIP001 	 }
//STRIP001 	 return aStr;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
/*?*/ SfxDocumentInfoItem::SfxDocumentInfoItem() :
/*?*/ 
/*?*/ 	SfxStringItem()
/*?*/ 
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	 bOwnFormat = FALSE;
//STRIP001 	 bHasTemplate = TRUE;
/*?*/ }

//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentInfoItem::SfxDocumentInfoItem( const String& rFile, const SfxDocumentInfo& rInfo ) :
//STRIP001 
//STRIP001 	 SfxStringItem( SID_DOCINFO, rFile ),
//STRIP001 
//STRIP001 	 aDocInfo( rInfo )
//STRIP001 
//STRIP001 {
//STRIP001 	 bOwnFormat = FALSE;
//STRIP001 	 bHasTemplate = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentInfoItem::SfxDocumentInfoItem( const String& rFile,
//STRIP001 										  const SfxDocumentInfo& rInfo,	BOOL bOwn ) :
//STRIP001 
//STRIP001 	SfxStringItem( SID_DOCINFO, rFile ),
//STRIP001 
//STRIP001 	aDocInfo( rInfo )
//STRIP001 
//STRIP001 {
//STRIP001 	bOwnFormat = ( (bOwn&1) != 0 );
//STRIP001 	bHasTemplate = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentInfoItem::SfxDocumentInfoItem( const SfxDocumentInfoItem& rItem ) :
//STRIP001 
//STRIP001 	SfxStringItem( rItem ),
//STRIP001 
//STRIP001 	aDocInfo( rItem.aDocInfo )
//STRIP001 
//STRIP001 {
//STRIP001 	bOwnFormat = rItem.bOwnFormat;
//STRIP001 	bHasTemplate = rItem.bHasTemplate;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentInfoItem::~SfxDocumentInfoItem()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxPoolItem* SfxDocumentInfoItem::Clone( SfxItemPool * ) const
//STRIP001 {
//STRIP001 	return new SfxDocumentInfoItem( *this );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 int SfxDocumentInfoItem::operator==( const SfxPoolItem& rItem) const
//STRIP001 {
//STRIP001 	 return rItem.Type() == Type() &&
//STRIP001 		 SfxStringItem::operator==(rItem) &&
//STRIP001 		 aDocInfo == ((const SfxDocumentInfoItem &)rItem).aDocInfo;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxDocumentInfoItem::IsOwnFormat() const
//STRIP001 {
//STRIP001 	 return ((bOwnFormat&1) != 0);
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SfxDocumentInfoItem::IsDeleteUserData() const
//STRIP001 {
//STRIP001 	 return ((bOwnFormat&2) != 0);
//STRIP001 }
//STRIP001 
//STRIP001 void SfxDocumentInfoItem::SetDeleteUserData( BOOL bSet )
//STRIP001 {
//STRIP001 	if ( bSet )
//STRIP001 		bOwnFormat |= 2;
//STRIP001 	else
//STRIP001 		bOwnFormat &= 2;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SfxDocumentInfoItem::QueryValue( ::com::sun::star::uno::Any& rVal, BYTE nMemberId ) const
//STRIP001 {
//STRIP001     String aValue;
//STRIP001     sal_Int32 nValue = 0;
//STRIP001 	sal_Bool bValue = sal_False;
//STRIP001     BOOL bField = FALSE;
//STRIP001     BOOL bIsInt = FALSE;
//STRIP001     BOOL bIsString = FALSE;
//STRIP001     sal_Bool bConvert = 0!=(nMemberId&CONVERT_TWIPS);
//STRIP001     nMemberId &= ~CONVERT_TWIPS;
//STRIP001     switch ( nMemberId )
//STRIP001     {
//STRIP001 		case MID_DOCINFO_USEUSERDATA:
//STRIP001 			bValue = aDocInfo.IsUseUserData();
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_DELETEUSERDATA:
//STRIP001 			bValue = IsDeleteUserData();
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADENABLED:
//STRIP001 			bValue = aDocInfo.IsReloadEnabled();
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADSECS:
//STRIP001 			bIsInt = TRUE;
//STRIP001 			nValue = aDocInfo.GetReloadDelay();
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADURL:
//STRIP001 			bIsString = TRUE;
//STRIP001 			aValue = aDocInfo.GetReloadURL();
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_DEFAULTTARGET:
//STRIP001 			bIsString = TRUE;
//STRIP001 			aValue = aDocInfo.GetDefaultTarget();
//STRIP001 			break;
//STRIP001         case MID_DOCINFO_DESCRIPTION:
//STRIP001 			bIsString = TRUE;
//STRIP001             aValue = aDocInfo.GetComment();
//STRIP001             break;
//STRIP001         case MID_DOCINFO_KEYWORDS:
//STRIP001 			bIsString = TRUE;
//STRIP001             aValue = aDocInfo.GetKeywords();
//STRIP001             break;
//STRIP001         case MID_DOCINFO_SUBJECT:
//STRIP001 			bIsString = TRUE;
//STRIP001             aValue = aDocInfo.GetTheme();
//STRIP001             break;
//STRIP001         case MID_DOCINFO_TITLE:
//STRIP001 			bIsString = TRUE;
//STRIP001             aValue = aDocInfo.GetTitle();
//STRIP001             break;
//STRIP001         case MID_DOCINFO_FIELD1:
//STRIP001         case MID_DOCINFO_FIELD2:
//STRIP001         case MID_DOCINFO_FIELD3:
//STRIP001         case MID_DOCINFO_FIELD4:
//STRIP001             bField = TRUE;
//STRIP001             // fehlendes break beabsichtigt
//STRIP001         case MID_DOCINFO_FIELD1TITLE:
//STRIP001         case MID_DOCINFO_FIELD2TITLE:
//STRIP001         case MID_DOCINFO_FIELD3TITLE:
//STRIP001         case MID_DOCINFO_FIELD4TITLE:
//STRIP001         {
//STRIP001 			bIsString = TRUE;
//STRIP001             USHORT nSub = MID_DOCINFO_FIELD1TITLE;
//STRIP001             if ( bField )
//STRIP001             {
//STRIP001                 nSub = MID_DOCINFO_FIELD1;
//STRIP001             }
//STRIP001             const SfxDocUserKey &rOld = aDocInfo.GetUserKey( nMemberId - nSub );
//STRIP001             if ( bField )
//STRIP001             {
//STRIP001                 DBG_ASSERT( nMemberId == MID_DOCINFO_FIELD1 ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD2 ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD3 ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD4,
//STRIP001                             "SfxDocumentInfoItem:Anpassungsfehler" );
//STRIP001                 aValue = rOld.GetWord();
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 DBG_ASSERT( nMemberId == MID_DOCINFO_FIELD1TITLE ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD2TITLE ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD3TITLE ||
//STRIP001                             nMemberId == MID_DOCINFO_FIELD4TITLE,
//STRIP001                             "SfxDocumentInfoItem:Anpassungsfehler" );
//STRIP001                 aValue = rOld.GetTitle();
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001         default:
//STRIP001 			DBG_ERROR("Wrong MemberId!");
//STRIP001            	return sal_False;
//STRIP001 	 }
//STRIP001 
//STRIP001 	if ( bIsString )
//STRIP001 		rVal <<= ::rtl::OUString( aValue );
//STRIP001 	else if ( bIsInt )
//STRIP001 		rVal <<= nValue;
//STRIP001 	else
//STRIP001 		rVal <<= bValue;
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SfxDocumentInfoItem::PutValue( const ::com::sun::star::uno::Any& rVal, BYTE nMemberId )
//STRIP001 {
//STRIP001     ::rtl::OUString aValue;
//STRIP001     sal_Int32 nValue=0;
//STRIP001 	sal_Bool bValue = sal_False;
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001     sal_Bool bConvert = 0!=(nMemberId&CONVERT_TWIPS);
//STRIP001     nMemberId &= ~CONVERT_TWIPS;
//STRIP001     switch ( nMemberId )
//STRIP001     {
//STRIP001 		case MID_DOCINFO_USEUSERDATA:
//STRIP001 			bRet = (rVal >>= bValue);
//STRIP001 			if ( bRet )
//STRIP001 				aDocInfo.SetUseUserData( bValue );
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_DELETEUSERDATA:
//STRIP001 			bRet = (rVal >>= bValue);
//STRIP001 			if ( bRet )
//STRIP001 			{
//STRIP001 				SetDeleteUserData( bValue );
//STRIP001 				if ( IsDeleteUserData() )
//STRIP001 					aDocInfo.DeleteUserData( aDocInfo.IsUseUserData() );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADENABLED:
//STRIP001 			bRet = (rVal >>= bValue);
//STRIP001 			if ( bRet )
//STRIP001 				aDocInfo.EnableReload( bValue );
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADSECS:
//STRIP001 			bRet = (rVal >>= nValue);
//STRIP001 			if ( bRet )
//STRIP001 				aDocInfo.SetReloadDelay( nValue );
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_AUTOLOADURL:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001 				aDocInfo.SetReloadURL( aValue );
//STRIP001 			break;
//STRIP001 		case MID_DOCINFO_DEFAULTTARGET:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001 				aDocInfo.SetDefaultTarget( aValue );
//STRIP001 			break;
//STRIP001         case MID_DOCINFO_DESCRIPTION:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001             	aDocInfo.SetComment(aValue);
//STRIP001             break;
//STRIP001         case MID_DOCINFO_KEYWORDS:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001             	aDocInfo.SetKeywords(aValue);
//STRIP001             break;
//STRIP001         case MID_DOCINFO_SUBJECT:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001             	aDocInfo.SetTheme(aValue);
//STRIP001             break;
//STRIP001         case MID_DOCINFO_TITLE:
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001             	aDocInfo.SetTitle(aValue);
//STRIP001             break;
//STRIP001         case MID_DOCINFO_FIELD1TITLE:
//STRIP001         case MID_DOCINFO_FIELD2TITLE:
//STRIP001         case MID_DOCINFO_FIELD3TITLE:
//STRIP001         case MID_DOCINFO_FIELD4TITLE:
//STRIP001         {
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001 			{
//STRIP001             	const SfxDocUserKey &rOld = aDocInfo.GetUserKey(nMemberId-MID_DOCINFO_FIELD1TITLE);
//STRIP001             	SfxDocUserKey aNew( aValue, rOld.GetWord() );
//STRIP001             	aDocInfo.SetUserKey( aNew, nMemberId-MID_DOCINFO_FIELD1TITLE );
//STRIP001 			}
//STRIP001             break;
//STRIP001         }
//STRIP001         case MID_DOCINFO_FIELD1:
//STRIP001         case MID_DOCINFO_FIELD2:
//STRIP001         case MID_DOCINFO_FIELD3:
//STRIP001         case MID_DOCINFO_FIELD4:
//STRIP001         {
//STRIP001 			bRet = (rVal >>= aValue);
//STRIP001 			if ( bRet )
//STRIP001 			{
//STRIP001             	const SfxDocUserKey &rOld = aDocInfo.GetUserKey(nMemberId-MID_DOCINFO_FIELD1);
//STRIP001             	SfxDocUserKey aNew( rOld.GetTitle(), aValue );
//STRIP001             	aDocInfo.SetUserKey( aNew, nMemberId-MID_DOCINFO_FIELD1 );
//STRIP001 			}
//STRIP001             break;
//STRIP001         }
//STRIP001         default:
//STRIP001 			DBG_ERROR("Wrong MemberId!");
//STRIP001             return sal_False;
//STRIP001     }
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentDescPage::SfxDocumentDescPage( Window * pParent, const SfxItemSet &rItemSet)
//STRIP001 	 : SfxTabPage( pParent, SfxResId(TP_DOCINFODESC), rItemSet),
//STRIP001 	 aTitleFt( this, ResId( FT_TITLE ) ),
//STRIP001 	 aThemaFt( this, ResId( FT_THEMA ) ),
//STRIP001 	 aKeywordsFt( this, ResId( FT_KEYWORDS ) ),
//STRIP001 	 aCommentFt( this, ResId( FT_COMMENT ) ),
//STRIP001 	 aTitleEd( this, ResId( ED_TITLE ) ),
//STRIP001 	 aThemaEd( this, ResId( ED_THEMA ) ),
//STRIP001 	 aKeywordsEd( this, ResId( ED_KEYWORDS ) ),
//STRIP001 	 aCommentEd( this, ResId( ED_COMMENT ) ),
//STRIP001 	 pInfoItem(0)
//STRIP001 {
//STRIP001 	 FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage *SfxDocumentDescPage::Create(Window *pParent, const SfxItemSet &rItemSet)
//STRIP001 {
//STRIP001 	 return new SfxDocumentDescPage(pParent, rItemSet);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxDocumentDescPage::FillItemSet(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	// Pruefung, ob eine Aenderung vorliegt
//STRIP001 	const BOOL bTitleMod = aTitleEd.IsModified();
//STRIP001 	const BOOL bThemeMod = aThemaEd.IsModified();
//STRIP001 	const BOOL bKeywordsMod = aKeywordsEd.IsModified();
//STRIP001 	const BOOL bCommentMod = aCommentEd.IsModified();
//STRIP001 	if( !( bTitleMod || bThemeMod || bKeywordsMod || bCommentMod ) )
//STRIP001 	{
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Erzeugung der Ausgabedaten
//STRIP001 	const SfxPoolItem *pItem;
//STRIP001 	SfxDocumentInfoItem *pInfo;
//STRIP001 	SfxTabDialog* pDlg = GetTabDialog();
//STRIP001 	const SfxItemSet* pExSet = NULL;
//STRIP001 
//STRIP001 	if ( pDlg )
//STRIP001 		pExSet = pDlg->GetExampleSet();
//STRIP001 
//STRIP001 	if ( pExSet && SFX_ITEM_SET != pExSet->GetItemState( SID_DOCINFO, TRUE, &pItem ) )
//STRIP001 	{
//STRIP001 		pInfo = pInfoItem;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pInfo = new SfxDocumentInfoItem( *( const SfxDocumentInfoItem *) pItem );
//STRIP001 	}
//STRIP001 	SfxDocumentInfo aInfo( (*pInfo)() );
//STRIP001 	if( bTitleMod )
//STRIP001 	{
//STRIP001 		aInfo.SetTitle( aTitleEd.GetText() );
//STRIP001 	}
//STRIP001 	if( bThemeMod )
//STRIP001 	{
//STRIP001 		aInfo.SetTheme( aThemaEd.GetText() );
//STRIP001 	}
//STRIP001 	if( bKeywordsMod )
//STRIP001 	{
//STRIP001 		aInfo.SetKeywords( aKeywordsEd.GetText() );
//STRIP001 	}
//STRIP001 	if( bCommentMod )
//STRIP001 	{
//STRIP001 		aInfo.SetComment( aCommentEd.GetText() );
//STRIP001 	}
//STRIP001 	rSet.Put( SfxDocumentInfoItem( pInfo->GetValue(), aInfo ) );
//STRIP001 	if( pInfo != pInfoItem )
//STRIP001 	{
//STRIP001 		delete pInfo;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentDescPage::Reset(const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	 pInfoItem = &(SfxDocumentInfoItem &)rSet.Get(SID_DOCINFO);
//STRIP001 	 const SfxDocumentInfo& rInfo = ( *pInfoItem )();
//STRIP001 
//STRIP001 	 aTitleEd.SetText( rInfo.GetTitle() );
//STRIP001 	 aThemaEd.SetText( rInfo.GetTheme() );
//STRIP001 	 aKeywordsEd.SetText( rInfo.GetKeywords() );
//STRIP001 	 aCommentEd.SetText( rInfo.GetComment() );
//STRIP001 
//STRIP001 	 if ( rInfo.IsReadOnly() )
//STRIP001 	 {
//STRIP001 		aTitleEd.SetReadOnly( TRUE );
//STRIP001 		aThemaEd.SetReadOnly( TRUE );
//STRIP001 		aKeywordsEd.SetReadOnly( TRUE );
//STRIP001 		aCommentEd.SetReadOnly( TRUE );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentPage::SfxDocumentPage( Window* pParent, const SfxItemSet& rItemSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SfxResId( TP_DOCINFODOC ), rItemSet ),
//STRIP001 
//STRIP001 	aBmp1			( this, ResId( BMP_FILE_1 ) ),
//STRIP001 	aNameED			( this, ResId( ED_FILE_NAME ) ),
//STRIP001 
//STRIP001 	aLine1FL		( this, ResId( FL_FILE_1 ) ),
//STRIP001 	aTypeFT			( this, ResId( FT_FILE_TYP ) ),
//STRIP001 	aShowTypeFT		( this, ResId( FT_FILE_SHOW_TYP ) ),
//STRIP001 	aReadOnlyCB		( this, ResId( CB_FILE_READONLY ) ),
//STRIP001 	aFileFt			( this, ResId( FT_FILE ) ),
//STRIP001 	aFileValFt		( this, ResId( FT_FILE_VAL ) ),
//STRIP001 	aSizeFT			( this, ResId( FT_FILE_SIZE ) ),
//STRIP001 	aShowSizeFT		( this, ResId( FT_FILE_SHOW_SIZE ) ),
//STRIP001 
//STRIP001 	aLine2FL		( this, ResId( FL_FILE_2 ) ),
//STRIP001 	aCreateFt		( this, ResId( FT_CREATE ) ),
//STRIP001 	aCreateValFt	( this, ResId( FT_CREATE_VAL ) ),
//STRIP001 	aTimeLogFt		( this, ResId( FT_TIMELOG ) ),
//STRIP001 	aTimeLogValFt	( this, ResId( FT_TIMELOG_VAL ) ),
//STRIP001 	aChangeFt		( this, ResId( FT_CHANGE ) ),
//STRIP001 	aChangeValFt	( this, ResId( FT_CHANGE_VAL ) ),
//STRIP001 	aDocNoFt		( this, ResId( FT_DOCNO ) ),
//STRIP001 	aDocNoValFt		( this, ResId( FT_DOCNO_VAL ) ),
//STRIP001 	aPrintValFt		( this, ResId( FT_PRINT_VAL ) ),
//STRIP001 	aPrintFt		( this, ResId( FT_PRINT ) ),
//STRIP001 	aDeleteBtn		( this, ResId( BTN_DELETE ) ),
//STRIP001 	aUseUserDataCB	( this, ResId( CB_USE_USERDATA ) ),
//STRIP001 
//STRIP001 	aLine3FL		( this, ResId( FL_FILE_3 ) ),
//STRIP001 	aTemplFt		( this, ResId( FT_TEMPL ) ),
//STRIP001 	aTemplValFt		( this, ResId( FT_TEMPL_VAL ) ),
//STRIP001 
//STRIP001 	aUnknownSize	( ResId( STR_UNKNOWNSIZE ) ),
//STRIP001 
//STRIP001 	bEnableUseUserData	( FALSE ),
//STRIP001 	bHandleDelete		( FALSE )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aDeleteBtn.SetClickHdl( LINK( this, SfxDocumentPage, DeleteHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxDocumentPage, DeleteHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	SfxStamp aCreated;
//STRIP001 	if ( bEnableUseUserData && aUseUserDataCB.IsChecked() )
//STRIP001     	aCreated.SetName( SvtUserOptions().GetFullName() );
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	aCreateValFt.SetText( ConvertDateTime_Impl( aCreated, aLocaleWrapper ) );
//STRIP001 	XubString aEmpty;
//STRIP001 	aChangeValFt.SetText( aEmpty );
//STRIP001 	aPrintValFt.SetText( aEmpty );
//STRIP001 	const Time aTime( 0 );
//STRIP001 	aTimeLogValFt.SetText( aLocaleWrapper.getDuration( aTime ) );
//STRIP001 	aDocNoValFt.SetText( '1' );
//STRIP001 	bHandleDelete = TRUE;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SfxDocumentPage::Create( Window* pParent, const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	 return new SfxDocumentPage( pParent, rItemSet );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentPage::EnableUseUserData()
//STRIP001 {
//STRIP001 	bEnableUseUserData = TRUE;
//STRIP001 	aUseUserDataCB.Show();
//STRIP001 	aDeleteBtn.Show();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxDocumentPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if ( !bHandleDelete && bEnableUseUserData &&
//STRIP001 		 aUseUserDataCB.GetState() != aUseUserDataCB.GetSavedValue() &&
//STRIP001 		 GetTabDialog() && GetTabDialog()->GetExampleSet() )
//STRIP001 	{
//STRIP001 		const SfxItemSet* pExpSet = GetTabDialog()->GetExampleSet();
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 		if ( pExpSet && SFX_ITEM_SET == pExpSet->GetItemState( SID_DOCINFO, TRUE, &pItem ) )
//STRIP001 		{
//STRIP001 			SfxDocumentInfoItem* pInfoItem = (SfxDocumentInfoItem*)pItem;
//STRIP001 			SfxDocumentInfo aInfo( (*pInfoItem)() );
//STRIP001 			BOOL bUseData = ( STATE_CHECK == aUseUserDataCB.GetState() );
//STRIP001 			aInfo.SetUseUserData( bUseData );
//STRIP001 /*
//STRIP001 			if ( !bUseData )
//STRIP001 			{
//STRIP001 				// "Benutzerdaten verwenden" ausgeschaltet ->
//STRIP001 				// den Benutzer aus den Stamps l"oschen
//STRIP001 				String aEmptyUser;
//STRIP001 				aInfo.SetCreated(
//STRIP001 					SfxStamp( aEmptyUser, aInfo.GetCreated().GetTime() ) );
//STRIP001 				aInfo.SetChanged(
//STRIP001 					SfxStamp( aEmptyUser, aInfo.GetChanged().GetTime() ) );
//STRIP001 				aInfo.SetPrinted(
//STRIP001 					SfxStamp( aEmptyUser, aInfo.GetPrinted().GetTime() ) );
//STRIP001 			}
//STRIP001 */
//STRIP001 			rSet.Put( SfxDocumentInfoItem( pInfoItem->GetValue(), aInfo ) );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bHandleDelete )
//STRIP001 	{
//STRIP001 		const SfxItemSet* pExpSet = GetTabDialog()->GetExampleSet();
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if ( pExpSet && SFX_ITEM_SET == pExpSet->GetItemState( SID_DOCINFO, TRUE, &pItem ) )
//STRIP001 		{
//STRIP001 			SfxDocumentInfoItem* pInfoItem = (SfxDocumentInfoItem*)pItem;
//STRIP001 			SfxDocumentInfo aInfo( pInfoItem->GetDocInfo() );
//STRIP001 			BOOL bUseAuthor = bEnableUseUserData && aUseUserDataCB.IsChecked();
//STRIP001 			aInfo.DeleteUserData( bUseAuthor );
//STRIP001 			aInfo.SetUseUserData( STATE_CHECK == aUseUserDataCB.GetState() );
//STRIP001 			SfxDocumentInfoItem aItem( pInfoItem->GetValue(), aInfo );
//STRIP001 			aItem.SetDeleteUserData( TRUE );
//STRIP001 			rSet.Put( aItem );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aNameED.IsModified() && aNameED.GetText().Len() )
//STRIP001 	{
//STRIP001 		rSet.Put( SfxStringItem( ID_FILETP_TITLE, aNameED.GetText() ) );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( /* aReadOnlyCB.IsModified() */ TRUE )
//STRIP001 	{
//STRIP001 		rSet.Put( SfxBoolItem( ID_FILETP_READONLY, aReadOnlyCB.IsChecked() ) );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	// Bestimmung der Dokumentinformationen
//STRIP001 	const SfxDocumentInfoItem *pInfoItem =
//STRIP001 		&(const SfxDocumentInfoItem &)rSet.Get(SID_DOCINFO);
//STRIP001 	const SfxDocumentInfo& rInfo = ( *pInfoItem )();
//STRIP001 
//STRIP001 	// Vorlagendaten
//STRIP001 	if ( pInfoItem->HasTemplate() )
//STRIP001 	{
//STRIP001 		aTemplValFt.SetText( rInfo.GetTemplateName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTemplFt.Hide();
//STRIP001 		aTemplValFt.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Bestimmung des Dateinamens
//STRIP001 	String aFile( pInfoItem->GetValue() );
//STRIP001 	String aFactory( aFile );
//STRIP001 	if ( aFile.Len() > 2 && aFile.GetChar(0) == '[' )
//STRIP001 	{
//STRIP001 		USHORT nPos = aFile.Search( ']' );
//STRIP001 		aFactory = aFile.Copy( 1, nPos-1  );
//STRIP001 		aFile = aFile.Copy( nPos+1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Bestimmung des Namens
//STRIP001 	String aName;
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	if ( SFX_ITEM_SET != rSet.GetItemState( ID_FILETP_TITLE, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		INetURLObject aURL(aFile);
//STRIP001 		aName = aURL.GetName( INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 		if ( !aName.Len() || aURL.GetProtocol() == INET_PROT_PRIVATE )
//STRIP001 			aName = String( SfxResId( STR_NONAME ) );
//STRIP001 		aNameED.SetReadOnly( TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pItem->IsA( TYPE( SfxStringItem ) ), "SfxDocumentPage:<SfxStringItem> erwartet" );
//STRIP001 		aName = ( ( SfxStringItem* ) pItem )->GetValue();
//STRIP001 	}
//STRIP001 	aNameED.SetText( aName );
//STRIP001 	aNameED.ClearModifyFlag();
//STRIP001 
//STRIP001 	// Bestimmung des R/O-Flags
//STRIP001 	if ( SFX_ITEM_UNKNOWN == rSet.GetItemState( ID_FILETP_READONLY, FALSE, &pItem )
//STRIP001 		 || !pItem )
//STRIP001 		aReadOnlyCB.Hide();
//STRIP001 	else
//STRIP001 		aReadOnlyCB.Check( ( (SfxBoolItem*)pItem )->GetValue() );
//STRIP001 
//STRIP001 	// Bestimmung des Kontextsymbols
//STRIP001 	INetURLObject aURL;
//STRIP001 	aURL.SetSmartProtocol( INET_PROT_FILE );
//STRIP001 	aURL.SetSmartURL( aFactory);
//STRIP001 	const String& rMainURL = aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001     aBmp1.SetImage( SvFileInformationManager::GetImage( aURL, TRUE ) );
//STRIP001 
//STRIP001 	// Bestimmung von Groesse und Typ
//STRIP001 	String aSizeText( aUnknownSize );
//STRIP001 	if ( aURL.GetProtocol() == INET_PROT_FILE )
//STRIP001 		aSizeText = CreateSizeText( SfxContentHelper::GetSize( aURL.GetMainURL( INetURLObject::NO_DECODE ) ) );
//STRIP001 	aShowSizeFT.SetText( aSizeText );
//STRIP001 
//STRIP001 	String aDescription = SvFileInformationManager::GetDescription( rMainURL );
//STRIP001 	if ( aDescription.Len() == 0 )
//STRIP001 		aDescription = String( SfxResId( STR_SFX_NEWOFFICEDOC ) );
//STRIP001 	aShowTypeFT.SetText( aDescription );
//STRIP001 
//STRIP001 	// Bestimmung des Ortes
//STRIP001 	aURL.SetSmartURL( aFile);
//STRIP001 	if ( aURL.GetProtocol() == INET_PROT_FILE )
//STRIP001 	{
//STRIP001 		INetURLObject aPath( aURL );
//STRIP001 		aPath.setFinalSlash();
//STRIP001 		aPath.removeSegment();
//STRIP001 		String aText( aPath.PathToFileName() ); //! (pb) MaxLen?
//STRIP001 		aFileValFt.SetText( aText );
//STRIP001 	}
//STRIP001 	else if ( aURL.GetProtocol() != INET_PROT_PRIVATE )
//STRIP001 		aFileValFt.SetText( aURL.GetPartBeforeLastName() );
//STRIP001 
//STRIP001 	// Zugriffsdaten
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const SfxStamp& rCreated = rInfo.GetCreated();
//STRIP001 	aCreateValFt.SetText( ConvertDateTime_Impl( rCreated, aLocaleWrapper ) );
//STRIP001 	const SfxStamp& rChanged = rInfo.GetChanged();
//STRIP001 	if ( rCreated != rChanged && rChanged.IsValid() )
//STRIP001 		aChangeValFt.SetText( ConvertDateTime_Impl( rChanged, aLocaleWrapper ) );
//STRIP001 	const SfxStamp& rPrinted = rInfo.GetPrinted();
//STRIP001 	if ( rPrinted != rCreated && rPrinted.IsValid())
//STRIP001 		aPrintValFt.SetText( ConvertDateTime_Impl( rPrinted, aLocaleWrapper ) );
//STRIP001 	const long nTime = rInfo.GetTime();
//STRIP001 	if( 1 || nTime ) //!!!
//STRIP001 	{
//STRIP001 		const Time aTime( nTime );
//STRIP001 		aTimeLogValFt.SetText( aLocaleWrapper.getDuration( aTime ) );
//STRIP001 	}
//STRIP001 	aDocNoValFt.SetText( String::CreateFromInt32( rInfo.GetDocumentNumber() ) );
//STRIP001 
//STRIP001 	TriState eState = (TriState)rInfo.IsUseUserData();
//STRIP001 
//STRIP001 	if ( STATE_DONTKNOW == eState )
//STRIP001 		aUseUserDataCB.EnableTriState( TRUE );
//STRIP001 
//STRIP001 	aUseUserDataCB.SetState( eState );
//STRIP001 	aUseUserDataCB.SaveValue();
//STRIP001 	aUseUserDataCB.Enable( bEnableUseUserData );
//STRIP001 	bHandleDelete = FALSE;
//STRIP001 	aDeleteBtn.Enable( bEnableUseUserData );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxInternetPage::SfxInternetPage( Window* pParent, const SfxItemSet& rItemSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SfxResId( TP_DOCINFORELOAD ), rItemSet ),
//STRIP001 
//STRIP001 	aRBNoAutoUpdate		( this, ResId( RB_NOAUTOUPDATE		) ),
//STRIP001 
//STRIP001 	aRBReloadUpdate		( this, ResId( RB_RELOADUPDATE		) ),
//STRIP001 	aFTEvery			( this, ResId( FT_EVERY				) ),
//STRIP001 	aNFReload			( this, ResId( ED_RELOAD			) ),
//STRIP001 	aFTReloadSeconds	( this, ResId( FT_RELOADSECS		) ),
//STRIP001 
//STRIP001 	aRBForwardUpdate	( this, ResId( RB_FORWARDUPDATE		) ),
//STRIP001 	aFTAfter			( this, ResId( FT_AFTER				) ),
//STRIP001 	aNFAfter			( this, ResId( ED_FORWARD			) ),
//STRIP001 	aFTAfterSeconds		( this, ResId( FT_FORWARDSECS		) ),
//STRIP001 	aFTURL				( this, ResId( FT_URL				) ),
//STRIP001 	aEDForwardURL		( this, ResId( ED_URL				) ),
//STRIP001 	aPBBrowseURL		( this, ResId( PB_BROWSEURL			) ),
//STRIP001 	aFTFrame			( this, ResId( FT_FRAME				) ),
//STRIP001 	aCBFrame			( this, ResId( CB_FRAME				) ),
//STRIP001 
//STRIP001 	aForwardErrorMessg	(		ResId( STR_FORWARD_ERRMSSG	) ),
//STRIP001 	eState( S_Init ),
//STRIP001 	pInfoItem( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	pInfoItem = &( SfxDocumentInfoItem& ) rItemSet.Get( SID_DOCINFO );
//STRIP001 //	SfxDocumentInfo&	rInfo = pInfoItem->GetDocInfo();
//STRIP001 	TargetList			aList;
//STRIP001 	SfxViewFrame*		pFrame = SfxViewFrame::Current();
//STRIP001 	if( pFrame && ( pFrame = pFrame->GetTopViewFrame() ) )
//STRIP001 	{
//STRIP001 		pFrame->GetTargetList( aList );
//STRIP001 
//STRIP001 		String*			pObj;
//STRIP001 		for( USHORT nPos = ( USHORT ) aList.Count() ; nPos ; )
//STRIP001 		{
//STRIP001 			pObj = aList.GetObject( --nPos );
//STRIP001 			aCBFrame.InsertEntry( *pObj );
//STRIP001 			delete pObj;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aRBNoAutoUpdate.SetClickHdl( LINK( this, SfxInternetPage, ClickHdlNoUpdate ) );
//STRIP001 	aRBReloadUpdate.SetClickHdl( LINK( this, SfxInternetPage, ClickHdlReload ) );
//STRIP001 	aRBForwardUpdate.SetClickHdl( LINK( this, SfxInternetPage, ClickHdlForward ) );
//STRIP001 	aPBBrowseURL.SetClickHdl( LINK( this, SfxInternetPage, ClickHdlBrowseURL ) );
//STRIP001 
//STRIP001 	aForwardErrorMessg.SearchAndReplaceAscii( "%PLACEHOLDER%", aRBForwardUpdate.GetText() );
//STRIP001 
//STRIP001 	ChangeState( S_NoUpdate );	
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxInternetPage::ChangeState( STATE eNewState )
//STRIP001 {
//STRIP001 	DBG_ASSERT( eNewState != S_Init, "*SfxInternetPage::ChangeState(): new state init is supposed to not work here!" );
//STRIP001 
//STRIP001 	if( eState == eNewState  )
//STRIP001 		return;
//STRIP001 
//STRIP001 	switch( eState )
//STRIP001 	{
//STRIP001 		case S_Init:
//STRIP001 			EnableNoUpdate( TRUE );
//STRIP001 			EnableReload( FALSE );
//STRIP001 			EnableForward( FALSE );
//STRIP001 			break;
//STRIP001 		case S_NoUpdate:
//STRIP001 			EnableNoUpdate( FALSE );
//STRIP001 			if( eNewState == S_Reload )
//STRIP001 				EnableReload( TRUE );
//STRIP001 			else
//STRIP001 				EnableForward( TRUE );
//STRIP001 			break;
//STRIP001 		case S_Reload:
//STRIP001 			EnableReload( FALSE );
//STRIP001 			if( eNewState == S_NoUpdate )
//STRIP001 				EnableNoUpdate( TRUE );
//STRIP001 			else
//STRIP001 				EnableForward( TRUE );
//STRIP001 			break;
//STRIP001 		case S_Forward:
//STRIP001 			EnableForward( FALSE );
//STRIP001 			if( eNewState == S_NoUpdate )
//STRIP001 				EnableNoUpdate( TRUE );
//STRIP001 			else
//STRIP001 				EnableReload( TRUE );
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR( "*SfxInternetPage::SetState(): unhandled state!" );
//STRIP001 	}
//STRIP001 
//STRIP001 	eState = eNewState;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxInternetPage::EnableNoUpdate( BOOL bEnable )
//STRIP001 {
//STRIP001 	if( bEnable )
//STRIP001 		aRBNoAutoUpdate.Check();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxInternetPage::EnableReload( BOOL bEnable )
//STRIP001 {
//STRIP001 	aFTEvery.Enable( bEnable );
//STRIP001 	aNFReload.Enable( bEnable );
//STRIP001 	aFTReloadSeconds.Enable( bEnable );
//STRIP001 
//STRIP001 	if( bEnable )
//STRIP001 		aRBReloadUpdate.Check();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxInternetPage::EnableForward( BOOL bEnable )
//STRIP001 {
//STRIP001 	aFTAfter.Enable( bEnable );
//STRIP001 	aNFAfter.Enable( bEnable );
//STRIP001 	aFTAfterSeconds.Enable( bEnable );
//STRIP001 	aFTURL.Enable( bEnable );
//STRIP001 	aEDForwardURL.Enable( bEnable );
//STRIP001 	aPBBrowseURL.Enable( bEnable );
//STRIP001 	aFTFrame.Enable( bEnable );
//STRIP001 	aCBFrame.Enable( bEnable );
//STRIP001 
//STRIP001 	if( bEnable )
//STRIP001 		aRBForwardUpdate.Check();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxInternetPage, ClickHdlNoUpdate, Control*, pCtrl )
//STRIP001 {
//STRIP001 	ChangeState( S_NoUpdate );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxInternetPage, ClickHdlReload, Control*, pCtrl )
//STRIP001 {
//STRIP001 	ChangeState( S_Reload );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxInternetPage, ClickHdlForward, Control*, pCtrl )
//STRIP001 {
//STRIP001 	ChangeState( S_Forward );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxInternetPage, ClickHdlBrowseURL, PushButton*, pButton )
//STRIP001 {
//STRIP001 	sfx2::FileDialogHelper aHelper( ::sfx2::FILEOPEN_SIMPLE, WB_OPEN );
//STRIP001     aHelper.SetDisplayDirectory( aEDForwardURL.GetText() );
//STRIP001 
//STRIP001     if( ERRCODE_NONE == aHelper.Execute() )
//STRIP001         aEDForwardURL.SetText( aHelper.GetPath() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxInternetPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem*			pItem = NULL;
//STRIP001 	SfxDocumentInfoItem*		pInfo = NULL;
//STRIP001 	SfxTabDialog*				pDlg = GetTabDialog();
//STRIP001 	const SfxItemSet*			pExSet = NULL;
//STRIP001 
//STRIP001 	if( pDlg )
//STRIP001 		pExSet = pDlg->GetExampleSet();
//STRIP001 
//STRIP001 	if( pExSet && SFX_ITEM_SET != pExSet->GetItemState( SID_DOCINFO, TRUE, &pItem ) )
//STRIP001 		pInfo = pInfoItem;
//STRIP001 	else
//STRIP001 		pInfo = new SfxDocumentInfoItem( *( const SfxDocumentInfoItem* ) pItem );
//STRIP001 
//STRIP001 	SfxDocumentInfo&			rInfo = pInfo->GetDocInfo();
//STRIP001 
//STRIP001 	DBG_ASSERT( eState != S_Init, "*SfxInternetPage::FillItemSet(): state init is not acceptable at this point!" );
//STRIP001 
//STRIP001 	BOOL						bEnableReload = FALSE;
//STRIP001 	::std::auto_ptr< String >	aURL( NULL );
//STRIP001 	::std::auto_ptr< String >	aFrame( NULL );
//STRIP001 	ULONG						nDelay = 0;
//STRIP001 
//STRIP001 	switch( eState )
//STRIP001 	{
//STRIP001 		case S_NoUpdate:
//STRIP001 			break;
//STRIP001 		case S_Reload:
//STRIP001 			bEnableReload = TRUE;
//STRIP001 			aURL = ::std::auto_ptr< String >( new String() );
//STRIP001 			aFrame = ::std::auto_ptr< String >( new String() );
//STRIP001 			nDelay = aNFReload.GetValue();
//STRIP001 			break;
//STRIP001 		case S_Forward:
//STRIP001 			DBG_ASSERT( aEDForwardURL.GetText().Len(), "+SfxInternetPage::FillItemSet(): empty URL should be not possible for forward option!" );
//STRIP001 
//STRIP001 			bEnableReload = TRUE;
//STRIP001 			aURL = ::std::auto_ptr< String >( new String( so3::StaticBaseUrl::SmartRelToAbs( aEDForwardURL.GetText() ) ) );
//STRIP001 			aFrame = ::std::auto_ptr< String >( new String( aCBFrame.GetText() ) );
//STRIP001 			nDelay = aNFAfter.GetValue();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	rInfo.EnableReload( bEnableReload );
//STRIP001 
//STRIP001 	if( bEnableReload )
//STRIP001 	{
//STRIP001 		rInfo.SetReloadURL( *aURL.get() );
//STRIP001 		rInfo.SetDefaultTarget( *aFrame.get() );
//STRIP001 		rInfo.SetReloadDelay( nDelay );
//STRIP001 	}
//STRIP001 
//STRIP001 	rSet.Put( *pInfo );
//STRIP001 	if( pInfo != pInfoItem )
//STRIP001 		delete pInfo;
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage *SfxInternetPage::Create( Window* pParent, const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	return new SfxInternetPage(pParent, rItemSet);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxInternetPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	pInfoItem = &( SfxDocumentInfoItem& ) rSet.Get( SID_DOCINFO );
//STRIP001 	SfxDocumentInfo&	rInfo = pInfoItem->GetDocInfo(); 
//STRIP001 	STATE				eNewState = S_NoUpdate;
//STRIP001 
//STRIP001 	if( rInfo.IsReloadEnabled() )
//STRIP001 	{
//STRIP001 		const String&	rURL = rInfo.GetReloadURL();
//STRIP001 
//STRIP001 		if( rURL.Len() )
//STRIP001 		{
//STRIP001 			aNFAfter.SetValue( rInfo.GetReloadDelay() );
//STRIP001 			aEDForwardURL.SetText( rInfo.GetReloadURL() );
//STRIP001 			aCBFrame.SetText( rInfo.GetDefaultTarget() );
//STRIP001 			eNewState = S_Forward;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNFReload.SetValue( rInfo.GetReloadDelay() );
//STRIP001 			eNewState = S_Reload;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangeState( eNewState );
//STRIP001 
//STRIP001 	// #102907# ------------------------
//STRIP001 	if ( rInfo.IsReadOnly() )
//STRIP001 	{
//STRIP001 		aRBNoAutoUpdate.Disable();
//STRIP001 		aRBReloadUpdate.Disable();
//STRIP001 		aRBForwardUpdate.Disable();
//STRIP001 		aNFReload.Disable();
//STRIP001 		aNFAfter.Disable();
//STRIP001 		aEDForwardURL.Disable();
//STRIP001 		aPBBrowseURL.Disable();
//STRIP001 		aCBFrame.Disable();
//STRIP001 		aFTEvery.Disable();
//STRIP001 		aFTReloadSeconds.Disable();
//STRIP001 		aFTAfter.Disable();
//STRIP001 		aFTAfterSeconds.Disable();
//STRIP001 		aFTURL.Disable();
//STRIP001 		aFTFrame.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 int SfxInternetPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	int				nRet = LEAVE_PAGE;
//STRIP001 
//STRIP001 	if( eState == S_Forward && !aEDForwardURL.GetText().Len() )
//STRIP001 	{
//STRIP001 		ErrorBox	aErrBox( this, WB_OK, aForwardErrorMessg );
//STRIP001 		aErrBox.Execute();
//STRIP001 
//STRIP001 		nRet = KEEP_PAGE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentUserPage::SfxDocumentUserPage( Window* pParent,
//STRIP001 										  const SfxItemSet& rItemSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SfxResId( TP_DOCINFOUSER ), rItemSet ),
//STRIP001 
//STRIP001 	aInfo1Ft		( this, ResId( FT_INFO1 ) ),
//STRIP001 	aInfo2Ft		( this, ResId( FT_INFO2 ) ),
//STRIP001 	aInfo3Ft		( this, ResId( FT_INFO3 ) ),
//STRIP001 	aInfo4Ft		( this, ResId( FT_INFO4 ) ),
//STRIP001 	aInfo1Ed		( this, ResId( ED_INFO1 ) ),
//STRIP001 	aInfo2Ed		( this, ResId( ED_INFO2 ) ),
//STRIP001 	aInfo3Ed		( this, ResId( ED_INFO3 ) ),
//STRIP001 	aInfo4Ed		( this, ResId( ED_INFO4 ) ),
//STRIP001 	aEditLabelBtn	( this, ResId( BTN_EDITLABEL ) ),
//STRIP001 
//STRIP001 	bLabelModified	( FALSE ),
//STRIP001 	pInfoItem		( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aEditLabelBtn.SetClickHdl( LINK( this, SfxDocumentUserPage, EditLabelHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxDocumentUserPage, EditLabelHdl, PushButton *, pPushButton )
//STRIP001 {
//STRIP001 	SfxDocInfoEditDlg* pDlg = new SfxDocInfoEditDlg( this );
//STRIP001 	pDlg->SetText1( GetLabelText_Impl( &aInfo1Ft ) );
//STRIP001 	pDlg->SetText2( GetLabelText_Impl( &aInfo2Ft ) );
//STRIP001 	pDlg->SetText3( GetLabelText_Impl( &aInfo3Ft ) );
//STRIP001 	pDlg->SetText4( GetLabelText_Impl( &aInfo4Ft ) );
//STRIP001 
//STRIP001 	if ( RET_OK == pDlg->Execute() )
//STRIP001 	{
//STRIP001 		SetLabelText_Impl( &aInfo1Ft, pDlg->GetText1() );
//STRIP001 		SetLabelText_Impl( &aInfo2Ft, pDlg->GetText2() );
//STRIP001 		SetLabelText_Impl( &aInfo3Ft, pDlg->GetText3() );
//STRIP001 		SetLabelText_Impl( &aInfo4Ft, pDlg->GetText4() );
//STRIP001 		bLabelModified = TRUE;
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 String SfxDocumentUserPage::GetLabelText_Impl( FixedText* pLabel )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pLabel, "SfxDocumentUserPage::SetLabelText_Impl(): invalid label" );
//STRIP001 	String aLabel = pLabel->GetText();
//STRIP001 	aLabel.Erase( 0, aLabel.Search( ' ' ) + 1 );
//STRIP001 	return aLabel;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentUserPage::SetLabelText_Impl( FixedText* pLabel, const String& rNewLabel )
//STRIP001 {
//STRIP001 	String aLabel( '~' );
//STRIP001 	sal_Int32 nNumber = 0;
//STRIP001 	if ( &aInfo1Ft == pLabel )
//STRIP001 		nNumber = 1;
//STRIP001 	else if ( &aInfo2Ft == pLabel )
//STRIP001 		nNumber = 2;
//STRIP001 	else if ( &aInfo3Ft == pLabel )
//STRIP001 		nNumber = 3;
//STRIP001 	else if ( &aInfo4Ft == pLabel )
//STRIP001 		nNumber = 4;
//STRIP001 	DBG_ASSERT( nNumber > 0, "SfxDocumentUserPage::SetLabelText_Impl(): wrong label" );
//STRIP001 	aLabel += String::CreateFromInt32( nNumber );
//STRIP001 	aLabel += String( DEFINE_CONST_UNICODE(": ") );
//STRIP001 	aLabel += rNewLabel;
//STRIP001 	DBG_ASSERT( pLabel, "SfxDocumentUserPage::SetLabelText_Impl(): invalid label" );
//STRIP001 	pLabel->SetText( aLabel );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SfxDocumentUserPage::Create( Window* pParent, const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	return new SfxDocumentUserPage(pParent, rItemSet);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxDocumentUserPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const BOOL bMod = bLabelModified ||
//STRIP001 					  aInfo1Ed.IsModified() || aInfo2Ed.IsModified() ||
//STRIP001 					  aInfo3Ed.IsModified() || aInfo4Ed.IsModified();
//STRIP001 	if ( !bMod )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	SfxDocumentInfoItem* pInfo = 0;
//STRIP001 	SfxTabDialog* pDlg = GetTabDialog();
//STRIP001 	const SfxItemSet* pExSet = NULL;
//STRIP001 
//STRIP001 	if ( pDlg )
//STRIP001 		pExSet = pDlg->GetExampleSet();
//STRIP001 
//STRIP001 	if ( pExSet &&
//STRIP001 		 SFX_ITEM_SET != pExSet->GetItemState(SID_DOCINFO, TRUE, &pItem) )
//STRIP001 		pInfo = pInfoItem;
//STRIP001 	else
//STRIP001 		pInfo = new SfxDocumentInfoItem( *(const SfxDocumentInfoItem*)pItem );
//STRIP001 	SfxDocumentInfo& rInfo = pInfo->GetDocInfo();
//STRIP001 
//STRIP001 	if ( bLabelModified || aInfo1Ed.IsModified() )
//STRIP001 	{
//STRIP001 		XubString aTitle = GetLabelText_Impl( &aInfo1Ft );
//STRIP001 		rInfo.SetUserKey( SfxDocUserKey( aTitle, aInfo1Ed.GetText() ), 0 );
//STRIP001 	}
//STRIP001 	if ( bLabelModified || aInfo2Ed.IsModified() )
//STRIP001 	{
//STRIP001 		XubString aTitle = GetLabelText_Impl( &aInfo2Ft );
//STRIP001 		rInfo.SetUserKey( SfxDocUserKey( aTitle, aInfo2Ed.GetText() ), 1 );
//STRIP001 	}
//STRIP001 	if ( bLabelModified || aInfo3Ed.IsModified() )
//STRIP001 	{
//STRIP001 		XubString aTitle = GetLabelText_Impl( &aInfo3Ft );
//STRIP001 		rInfo.SetUserKey( SfxDocUserKey( aTitle, aInfo3Ed.GetText() ), 2 );
//STRIP001 	}
//STRIP001 	if ( bLabelModified || aInfo4Ed.IsModified() )
//STRIP001 	{
//STRIP001 		XubString aTitle = GetLabelText_Impl( &aInfo4Ft );
//STRIP001 		rInfo.SetUserKey( SfxDocUserKey( aTitle, aInfo4Ed.GetText() ), 3 );
//STRIP001 	}
//STRIP001 	rSet.Put( *pInfo );
//STRIP001 	if ( pInfo != pInfoItem )
//STRIP001 		delete pInfo;
//STRIP001 	return bMod;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentUserPage::Reset(const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	pInfoItem = &(SfxDocumentInfoItem&)rSet.Get( SID_DOCINFO );
//STRIP001 	const SfxDocumentInfo& rInfo = pInfoItem->GetDocInfo();
//STRIP001 	SetLabelText_Impl( &aInfo1Ft, rInfo.GetUserKey(0).GetTitle() );
//STRIP001 	aInfo1Ed.SetText( rInfo.GetUserKey(0).GetWord() );
//STRIP001 	SetLabelText_Impl( &aInfo2Ft, rInfo.GetUserKey(1).GetTitle() );
//STRIP001 	aInfo2Ed.SetText( rInfo.GetUserKey(1).GetWord() );
//STRIP001 	SetLabelText_Impl( &aInfo3Ft, rInfo.GetUserKey(2).GetTitle() );
//STRIP001 	aInfo3Ed.SetText( rInfo.GetUserKey(2).GetWord() );
//STRIP001 	SetLabelText_Impl( &aInfo4Ft, rInfo.GetUserKey(3).GetTitle() );
//STRIP001 	aInfo4Ed.SetText( rInfo.GetUserKey(3).GetWord() );
//STRIP001 	bLabelModified = FALSE;
//STRIP001 
//STRIP001 	if ( rInfo.IsReadOnly() )
//STRIP001 	{
//STRIP001 		aInfo1Ed.SetReadOnly( TRUE );
//STRIP001 		aInfo2Ed.SetReadOnly( TRUE );
//STRIP001 		aInfo3Ed.SetReadOnly( TRUE );
//STRIP001 		aInfo4Ed.SetReadOnly( TRUE );
//STRIP001 		aEditLabelBtn.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxDocumentInfoDialog::SfxDocumentInfoDialog( Window* pParent,
//STRIP001 											  const SfxItemSet& rItemSet ) :
//STRIP001 
//STRIP001 	SfxTabDialog( 0, pParent, SfxResId( SID_DOCINFO ), &rItemSet )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	 const SfxDocumentInfoItem* pInfoItem =
//STRIP001 		&(const SfxDocumentInfoItem &)rItemSet.Get( SID_DOCINFO );
//STRIP001 
//STRIP001 	 // Bestimmung des Titels
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	String aTitle( GetText() );
//STRIP001 	if ( SFX_ITEM_SET !=
//STRIP001 		 rItemSet.GetItemState( SID_EXPLORER_PROPS_START, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		// Dateiname
//STRIP001 		String aFile( pInfoItem->GetValue() );
//STRIP001 #ifdef WIN
//STRIP001 		if ( aFile.Len() <= 8 )
//STRIP001 		{
//STRIP001 			String sTmp( SfxResId( STR_NONAME ) );
//STRIP001 			USHORT nLen = Min( (USHORT)8, sTmp.Len() );
//STRIP001 
//STRIP001 			if ( sTmp.Copy( 0, nLen ).Lower() ==
//STRIP001 				 aFile.Copy( 0, nLen ).Lower() )
//STRIP001 			{
//STRIP001 				aFile = pInfoItem->GetValue();
//STRIP001 			}
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		INetURLObject aURL;
//STRIP001 		aURL.SetSmartProtocol( INET_PROT_FILE );
//STRIP001 		aURL.SetSmartURL( aFile);
//STRIP001 		if ( INET_PROT_PRIV_SOFFICE != aURL.GetProtocol() )
//STRIP001 		{
//STRIP001 			String aLastName( aURL.GetLastName() );
//STRIP001 			if ( aLastName.Len() )
//STRIP001 				aTitle += aLastName;
//STRIP001 			else
//STRIP001 				aTitle += aFile;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTitle += String( SfxResId( STR_NONAME ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pItem->IsA( TYPE( SfxStringItem ) ),
//STRIP001 					"SfxDocumentInfoDialog:<SfxStringItem> erwartet" );
//STRIP001 		aTitle += ( ( SfxStringItem* ) pItem )->GetValue();
//STRIP001 	}
//STRIP001 	SetText( aTitle );
//STRIP001 
//STRIP001 	// Eigenschaftenseiten
//STRIP001 	AddTabPage(TP_DOCINFODESC, SfxDocumentDescPage::Create, 0);
//STRIP001 	AddTabPage(TP_DOCINFODOC, SfxDocumentPage::Create, 0);
//STRIP001 	AddTabPage(TP_DOCINFOUSER, SfxDocumentUserPage::Create, 0);
//STRIP001 	AddTabPage(TP_DOCINFORELOAD, SfxInternetPage::Create, 0);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxDocumentInfoDialog::PageCreated( USHORT nId, SfxTabPage &rPage )
//STRIP001 {
//STRIP001 	if ( TP_DOCINFODOC == nId )
//STRIP001 		( (SfxDocumentPage&)rPage ).EnableUseUserData();
//STRIP001 }
}
