/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_filedlghelper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:56:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FILEDLGHELPER_HXX
#include "filedlghelper.hxx"
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef  _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_COMMONFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/CommonFilePickerElementIds.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXTENDEDFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/ExtendedFilePickerElementIds.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_FILEPREVIEWIMAGEFORMATS_HPP_
#include <com/sun/star/ui/dialogs/FilePreviewImageFormats.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_CONTROLACTIONS_HPP_
#include <com/sun/star/ui/dialogs/ControlActions.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERNOTIFIER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerNotifier.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPREVIEW_HPP_
#include <com/sun/star/ui/dialogs/XFilePreview.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERGROUPMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterGroupManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HDL_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif

#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _UNOTOOLS_UCBHELPER_HXX
#include <unotools/ucbhelper.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_CVTGRF_HXX
#include <vcl/cvtgrf.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_MNEMONIC_HXX
#include <vcl/mnemonic.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX
#include <svtools/stritem.hxx>
#endif
#ifndef _FILTER_HXX
#include <svtools/filter.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif
#ifndef _SVT_HELPID_HRC
#include <svtools/helpid.hrc>
#endif
#ifndef _PICKERHELPER_HXX
#include <svtools/pickerhelper.hxx>
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_ 
#include <toolkit/helper/vclunohelper.hxx>
#endif

#ifndef _SFXAPP_HXX
#include "app.hxx"
#endif
#ifndef _SFXDOCFILE_HXX
#include "docfile.hxx"
#endif
#ifndef _SFX_OBJFAC_HXX
#include "docfac.hxx"
#endif
#ifndef _SFX_OPENFLAG_HXX
#include "openflag.hxx"
#endif
#ifndef _SFX_PASSWD_HXX
#include "passwd.hxx"
#endif
#ifndef _SFX_SFXRESID_HXX
#include "sfxresid.hxx"
#endif
#ifndef _SFXSIDS_HRC
#include "sfxsids.hrc"
#endif
#ifndef _SFX_EXPLORER_HRC
#include "explorer.hrc"
#endif
#ifndef _SFX_FILEDLGHELPER_HRC
#include "filedlghelper.hrc"
#endif
#ifndef SFX2_FILTERGROUPING_HXX
#include "filtergrouping.hxx"
#endif
#ifndef SFX2_REQUEST_HXX
#include "request.hxx"
#endif
#ifndef _SFX_FILEDLGIMPL_HXX
#include "filedlgimpl.hxx"
#endif

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

//-----------------------------------------------------------------------------

using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::rtl;
using namespace ::cppu;

//-----------------------------------------------------------------------------

//STRIP001 const short FILEOPEN_SIMPLE = TemplateDescription::FILEOPEN_SIMPLE;
//STRIP001 const short FILESAVE_SIMPLE = TemplateDescription::FILESAVE_SIMPLE;
//STRIP001 const short FILESAVE_AUTOEXTENSION_PASSWORD = TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD;
//STRIP001 const short FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS = TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS;
//STRIP001 const short FILESAVE_AUTOEXTENSION_SELECTION = TemplateDescription::FILESAVE_AUTOEXTENSION_SELECTION;
//STRIP001 const short FILESAVE_AUTOEXTENSION_TEMPLATE = TemplateDescription::FILESAVE_AUTOEXTENSION_TEMPLATE;
//STRIP001 const short FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE = TemplateDescription::FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE;
//STRIP001 const short FILEOPEN_PLAY = TemplateDescription::FILEOPEN_PLAY;
//STRIP001 const short FILEOPEN_READONLY_VERSION = TemplateDescription::FILEOPEN_READONLY_VERSION;
//STRIP001 const short FILEOPEN_LINK_PREVIEW = TemplateDescription::FILEOPEN_LINK_PREVIEW;
//STRIP001 const short FILESAVE_AUTOEXTENSION = TemplateDescription::FILESAVE_AUTOEXTENSION;
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 
//STRIP001 #define IODLG_CONFIGNAME		String(DEFINE_CONST_UNICODE("FilePicker_Save"))
//STRIP001 #define IMPGRF_CONFIGNAME		String(DEFINE_CONST_UNICODE("FilePicker_Graph"))
//STRIP001 #define USERITEM_NAME			::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "UserItem" ))
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 
//STRIP001 namespace sfx2
//STRIP001 {
//STRIP001 
//STRIP001 const OUString* GetLastFilterConfigId( FileDialogHelper::Context _eContext )
//STRIP001 {
//STRIP001 	static const OUString	aSD_EXPORT_IDENTIFIER( RTL_CONSTASCII_USTRINGPARAM( "SdExportLastFilter" ) );
//STRIP001 	static const OUString	aSI_EXPORT_IDENTIFIER( RTL_CONSTASCII_USTRINGPARAM( "SiExportLastFilter" ) );
//STRIP001 
//STRIP001 	const OUString* pRet = NULL;
//STRIP001 
//STRIP001 	switch( _eContext )
//STRIP001 	{
//STRIP001 		case FileDialogHelper::SD_EXPORT:	pRet = &aSD_EXPORT_IDENTIFIER;	break;
//STRIP001 		case FileDialogHelper::SI_EXPORT:	pRet = &aSI_EXPORT_IDENTIFIER;	break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 String EncodeSpaces_Impl( const String& rSource );
//STRIP001 String DecodeSpaces_Impl( const String& rSource );
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // -----------		FileDialogHelper_Impl		---------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // XFilePickerListener Methods
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper_Impl::fileSelectionChanged( const FilePickerEvent& aEvent ) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	mpAntiImpl->FileSelectionChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper_Impl::directoryChanged( const FilePickerEvent& aEvent ) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	mpAntiImpl->DirectoryChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 OUString SAL_CALL FileDialogHelper_Impl::helpRequested( const FilePickerEvent& aEvent ) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	return mpAntiImpl->HelpRequested( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper_Impl::controlStateChanged( const FilePickerEvent& aEvent ) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	mpAntiImpl->ControlStateChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper_Impl::dialogSizeChanged() throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	mpAntiImpl->DialogSizeChanged();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // handle XFilePickerListener events
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::handleFileSelectionChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	if ( mbHasVersions )
//STRIP001 		updateVersions();
//STRIP001 
//STRIP001 	if ( mbShowPreview )
//STRIP001 		maPreViewTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::handleDirectoryChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	if ( mbShowPreview )
//STRIP001 		TimeOutHdl_Impl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 OUString FileDialogHelper_Impl::handleHelpRequested( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	//!!! todo: cache the help strings (here or TRA)
//STRIP001 
//STRIP001 	ULONG nHelpId = 0;
//STRIP001 	// mapping from element id -> help id
//STRIP001 	switch ( aEvent.ElementId )
//STRIP001 	{
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION :
//STRIP001 			nHelpId = HID_FILESAVE_AUTOEXTENSION;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_PASSWORD :
//STRIP001 			nHelpId = HID_FILESAVE_SAVEWITHPASSWORD;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS :
//STRIP001 			nHelpId = HID_FILESAVE_CUSTOMIZEFILTER;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_READONLY :
//STRIP001 			nHelpId = HID_FILEOPEN_READONLY;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_LINK :
//STRIP001 			nHelpId = HID_FILEDLG_LINK_CB;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_PREVIEW :
//STRIP001 			nHelpId = HID_FILEDLG_PREVIEW_CB;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::PUSHBUTTON_PLAY :
//STRIP001 			nHelpId = HID_FILESAVE_DOPLAY;
//STRIP001 			break;
//STRIP001 
//STRIP001         case ExtendedFilePickerElementIds::LISTBOX_VERSION_LABEL :
//STRIP001 		case ExtendedFilePickerElementIds::LISTBOX_VERSION :
//STRIP001 			nHelpId = HID_FILEOPEN_VERSION;
//STRIP001 			break;
//STRIP001 
//STRIP001         case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE_LABEL :
//STRIP001 		case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE :
//STRIP001 			nHelpId = HID_FILESAVE_TEMPLATE;
//STRIP001 			break;
//STRIP001 
//STRIP001         case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE_LABEL :
//STRIP001 		case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE :
//STRIP001 			nHelpId = HID_FILEOPEN_IMAGE_TEMPLATE;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_SELECTION :
//STRIP001 			nHelpId = HID_FILESAVE_SELECTION;
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERRORFILE( "invalid element id" );
//STRIP001 	}
//STRIP001 
//STRIP001 	OUString aHelpText;
//STRIP001 	Help* pHelp = Application::GetHelp();
//STRIP001 	if ( pHelp )
//STRIP001 		aHelpText = String( pHelp->GetHelpText( nHelpId, NULL ) );
//STRIP001 	return aHelpText;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::handleControlStateChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	switch ( aEvent.ElementId )
//STRIP001 	{
//STRIP001 		case CommonFilePickerElementIds::LISTBOX_FILTER:
//STRIP001 			updateFilterOptionsBox();
//STRIP001 			enablePasswordBox( sal_False );
//STRIP001 			updateSelectionBox();
//STRIP001 			// only use it for export and with our own dialog
//STRIP001 			if ( mbExport && !mbSystemPicker )
//STRIP001 				updateExportButton();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case ExtendedFilePickerElementIds::CHECKBOX_PREVIEW:
//STRIP001 			updatePreviewState();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::handleDialogSizeChanged()
//STRIP001 {
//STRIP001 	if ( mbShowPreview )
//STRIP001 		TimeOutHdl_Impl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // XEventListener Methods
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper_Impl::disposing( const EventObject& Source ) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	dispose();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::dispose()
//STRIP001 {
//STRIP001 	if ( mxFileDlg.is() )
//STRIP001 	{
//STRIP001 		// remove the event listener
//STRIP001 		Reference< XFilePickerNotifier > xNotifier( mxFileDlg, UNO_QUERY );
//STRIP001 		if ( xNotifier.is() )
//STRIP001 			xNotifier->removeFilePickerListener( this );
//STRIP001 
//STRIP001 		::comphelper::disposeComponent( mxFileDlg );
//STRIP001 		mxFileDlg.clear();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String FileDialogHelper_Impl::getCurrentFilterUIName() const
//STRIP001 {
//STRIP001 	String aFilterName;
//STRIP001 	Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if( xFltMgr.is() )
//STRIP001 	{
//STRIP001 		aFilterName = xFltMgr->getCurrentFilter();
//STRIP001 
//STRIP001 		if ( aFilterName.Len() && isShowFilterExtensionEnabled() )
//STRIP001 			aFilterName = getFilterName( aFilterName );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aFilterName;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::LoadLastUsedFilter( const OUString& _rContextIdentifier )
//STRIP001 {
//STRIP001 	SvtViewOptions aDlgOpt( E_DIALOG, IODLG_CONFIGNAME );
//STRIP001 
//STRIP001 	if( aDlgOpt.Exists() )
//STRIP001 	{
//STRIP001 		OUString	aLastFilter;
//STRIP001 		if( aDlgOpt.GetUserItem( _rContextIdentifier ) >>= aLastFilter )
//STRIP001 			setFilter( aLastFilter );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::SaveLastUsedFilter( const OUString& _rContextIdentifier )
//STRIP001 {
//STRIP001 	SvtViewOptions( E_DIALOG, IODLG_CONFIGNAME ).SetUserItem( _rContextIdentifier,
//STRIP001 						makeAny( getFilterWithExtension( getFilter() ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::SaveLastUsedFilter( void )
//STRIP001 {
//STRIP001 	const OUString*	pConfigId = GetLastFilterConfigId( meContext );
//STRIP001 	if( pConfigId )
//STRIP001 		SaveLastUsedFilter( *pConfigId );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 const SfxFilter* FileDialogHelper_Impl::getCurentSfxFilter()
//STRIP001 {
//STRIP001 	String aFilterName = getCurrentFilterUIName();
//STRIP001 
//STRIP001 	const SfxFilter* pFilter = NULL;
//STRIP001 	if ( mpMatcher && aFilterName.Len() )
//STRIP001 		pFilter = mpMatcher->GetFilter4UIName( aFilterName, m_nMustFlags, m_nDontFlags );
//STRIP001 
//STRIP001 	return pFilter;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Bool FileDialogHelper_Impl::updateExtendedControl( sal_Int16 _nExtendedControlId, sal_Bool _bEnable )
//STRIP001 {
//STRIP001 	sal_Bool bIsEnabled = sal_False;
//STRIP001 
//STRIP001 	Reference < XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 	if ( xCtrlAccess.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xCtrlAccess->enableControl( _nExtendedControlId, _bEnable );
//STRIP001 			bIsEnabled = _bEnable;
//STRIP001 		}
//STRIP001 		catch( const IllegalArgumentException& )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "FileDialogHelper_Impl::updateExtendedControl: caught an exception!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bIsEnabled;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Bool FileDialogHelper_Impl::CheckFilterOptionsCapability( const SfxFilter* _pFilter )
//STRIP001 {
//STRIP001 	sal_Bool bResult = sal_False;
//STRIP001 
//STRIP001 	if( mxFilterCFG.is() && _pFilter )
//STRIP001 	{
//STRIP001 		try {
//STRIP001    			Sequence < PropertyValue > aProps;
//STRIP001    			Any aAny = mxFilterCFG->getByName( _pFilter->GetName() );
//STRIP001    			if ( aAny >>= aProps )
//STRIP001    			{
//STRIP001        			::rtl::OUString aServiceName;
//STRIP001        			sal_Int32 nPropertyCount = aProps.getLength();
//STRIP001        			for( sal_Int32 nProperty=0; nProperty < nPropertyCount; ++nProperty )
//STRIP001 				{
//STRIP001            			if( aProps[nProperty].Name.equals( DEFINE_CONST_OUSTRING( "UIComponent") ) )
//STRIP001            			{
//STRIP001 						::rtl::OUString aServiceName;
//STRIP001                			aProps[nProperty].Value >>= aServiceName;
//STRIP001 						if( aServiceName.getLength() )
//STRIP001 							bResult = sal_True;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( Exception& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Bool FileDialogHelper_Impl::isInOpenMode() const
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	switch ( m_nDialogType )
//STRIP001 	{
//STRIP001 		case FILEOPEN_SIMPLE:
//STRIP001 		case FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE:
//STRIP001 		case FILEOPEN_PLAY:
//STRIP001 		case FILEOPEN_READONLY_VERSION:
//STRIP001 		case FILEOPEN_LINK_PREVIEW:
//STRIP001 			bRet = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FileDialogHelper_Impl::updateFilterOptionsBox()
//STRIP001 {
//STRIP001 	if ( !m_bHaveFilterOptions )
//STRIP001 		return;
//STRIP001 
//STRIP001 	updateExtendedControl(
//STRIP001 		ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS,
//STRIP001 		CheckFilterOptionsCapability( getCurentSfxFilter() )
//STRIP001 	);
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FileDialogHelper_Impl::updateExportButton()
//STRIP001 {
//STRIP001 	Reference < XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 	if ( xCtrlAccess.is() )
//STRIP001 	{
//STRIP001 		OUString sEllipses( RTL_CONSTASCII_USTRINGPARAM( "..." ) );
//STRIP001 		OUString sOldLabel( xCtrlAccess->getLabel( CommonFilePickerElementIds::PUSHBUTTON_OK ) );
//STRIP001 
//STRIP001 		// initialize button label; we need the label with the mnemonic char
//STRIP001 		if ( !maButtonLabel.getLength() || maButtonLabel.indexOf( MNEMONIC_CHAR ) == -1 )
//STRIP001 		{
//STRIP001 			// cut the ellipses, if necessary
//STRIP001 			sal_Int32 nIndex = sOldLabel.indexOf( sEllipses );
//STRIP001 			if ( -1 == nIndex )
//STRIP001 				nIndex = sOldLabel.getLength();
//STRIP001 			maButtonLabel = sOldLabel.copy( 0, nIndex );
//STRIP001 		}
//STRIP001 
//STRIP001 		OUString sLabel = maButtonLabel;
//STRIP001 		// filter with options -> append ellipses on export button label
//STRIP001 		if ( CheckFilterOptionsCapability( getCurentSfxFilter() ) )
//STRIP001 			sLabel += OUString( RTL_CONSTASCII_USTRINGPARAM( "..." ) );
//STRIP001 
//STRIP001 		if ( sOldLabel != sLabel )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				xCtrlAccess->setLabel( CommonFilePickerElementIds::PUSHBUTTON_OK, sLabel );
//STRIP001 			}
//STRIP001 			catch( const IllegalArgumentException& )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "FileDialogHelper_Impl::updateExportButton: caught an exception!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::updateSelectionBox()
//STRIP001 {
//STRIP001 	if ( !mbExport )
//STRIP001 		return;
//STRIP001 
//STRIP001 	const SfxFilter* pFilter = getCurentSfxFilter();
//STRIP001 
//STRIP001 	updateExtendedControl(
//STRIP001 		ExtendedFilePickerElementIds::CHECKBOX_SELECTION,
//STRIP001 		( mbSelectionEnabled && pFilter && ( pFilter->GetFilterFlags() & SFX_FILTER_SUPPORTSSELECTION ) != 0 ) );
//STRIP001 
//STRIP001 	Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 	xCtrlAccess->setValue( ExtendedFilePickerElementIds::CHECKBOX_SELECTION, 0, makeAny( (sal_Bool)mbSelection ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 struct CheckPasswordCapability
//STRIP001 {
//STRIP001 	sal_Bool operator() ( const SfxFilter* _pFilter )
//STRIP001 	{
//STRIP001         return  _pFilter && _pFilter->IsOwnFormat()
//STRIP001 			&&	_pFilter->UsesStorage()
//STRIP001 			&&	( SOFFICE_FILEFORMAT_60 <= _pFilter->GetVersion() );
//STRIP001 	}
//STRIP001 };
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::enablePasswordBox( sal_Bool bInit )
//STRIP001 {
//STRIP001 	if ( ! mbHasPassword )
//STRIP001 		return;
//STRIP001 
//STRIP001 	sal_Bool bWasEnabled = mbIsPwdEnabled;
//STRIP001 
//STRIP001 	mbIsPwdEnabled = updateExtendedControl(
//STRIP001 		ExtendedFilePickerElementIds::CHECKBOX_PASSWORD,
//STRIP001 		CheckPasswordCapability()( getCurentSfxFilter() )
//STRIP001 	);
//STRIP001 
//STRIP001 	if( bInit )
//STRIP001 	{
//STRIP001 		// in case of inintialization previous state is not interesting
//STRIP001 		if( mbIsPwdEnabled )
//STRIP001 		{
//STRIP001 			Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 			if( mbPwdCheckBoxState )
//STRIP001 				xCtrlAccess->setValue( ExtendedFilePickerElementIds::CHECKBOX_PASSWORD, 0, makeAny( sal_True ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( !bWasEnabled && mbIsPwdEnabled )
//STRIP001 	{
//STRIP001 		Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 		if( mbPwdCheckBoxState )
//STRIP001 			xCtrlAccess->setValue( ExtendedFilePickerElementIds::CHECKBOX_PASSWORD, 0, makeAny( sal_True ) );
//STRIP001 	}
//STRIP001 	else if( bWasEnabled && !mbIsPwdEnabled )
//STRIP001 	{
//STRIP001 		// remember user settings until checkbox is enabled
//STRIP001 		Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 		Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_PASSWORD, 0 );
//STRIP001 		sal_Bool bPassWord = sal_False;
//STRIP001 		mbPwdCheckBoxState = ( aValue >>= bPassWord ) && bPassWord;
//STRIP001 		xCtrlAccess->setValue( ExtendedFilePickerElementIds::CHECKBOX_PASSWORD, 0, makeAny( sal_False ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::updatePreviewState( sal_Bool _bUpdatePreviewWindow )
//STRIP001 {
//STRIP001 	if ( mbHasPreview )
//STRIP001 	{
//STRIP001 		Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 		// check, wether or not we have to display a preview
//STRIP001 		if ( xCtrlAccess.is() )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_PREVIEW, 0 );
//STRIP001 				sal_Bool bShowPreview = sal_False;
//STRIP001 
//STRIP001 				if ( aValue >>= bShowPreview )
//STRIP001 				{
//STRIP001 					mbShowPreview = bShowPreview;
//STRIP001 
//STRIP001 					// #97633
//STRIP001 					// setShowState has currently no effect for the
//STRIP001 					// OpenOffice FilePicker (see svtools/source/filepicker/iodlg.cxx)
//STRIP001 					Reference< XFilePreview > xFilePreview( mxFileDlg, UNO_QUERY );
//STRIP001 					if ( xFilePreview.is() )
//STRIP001 						xFilePreview->setShowState( mbShowPreview );
//STRIP001 
//STRIP001 					if ( _bUpdatePreviewWindow )
//STRIP001 						TimeOutHdl_Impl( NULL );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( Exception )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "FileDialogHelper_Impl::updatePreviewState: caught an exception!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::updateVersions()
//STRIP001 {
//STRIP001 	Sequence < OUString > aEntries;
//STRIP001 	Sequence < OUString > aPathSeq = mxFileDlg->getFiles();
//STRIP001 
//STRIP001 	if ( aPathSeq.getLength() == 1 )
//STRIP001 	{
//STRIP001 		INetURLObject aObj( aPathSeq[0] );
//STRIP001 
//STRIP001 		if ( ( aObj.GetProtocol() == INET_PROT_FILE ) &&
//STRIP001 			( utl::UCBContentHelper::IsDocument( aObj.GetMainURL( INetURLObject::NO_DECODE ) ) ) )
//STRIP001 		{
//STRIP001 			SvStorageRef pStor = new SvStorage( FALSE, aObj.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ, 0 );
//STRIP001 			if( pStor->GetError() == SVSTREAM_OK )
//STRIP001 			{
//STRIP001 				SfxVersionTableDtor* pVerTable = SfxMedium::GetVersionList( pStor ); // aMed.GetVersionList();
//STRIP001 
//STRIP001 				if ( pVerTable )
//STRIP001 				{
//STRIP001 					SvStringsDtor* pVersions = pVerTable->GetVersions();
//STRIP001 
//STRIP001 					aEntries.realloc( pVersions->Count() + 1 );
//STRIP001 					aEntries[0] = OUString( String ( SfxResId( STR_SFX_FILEDLG_ACTUALVERSION ) ) );
//STRIP001 
//STRIP001 					for ( USHORT i = 0; i < pVersions->Count(); i++ )
//STRIP001 						aEntries[ i + 1 ] = OUString( *(pVersions->GetObject(i)) );
//STRIP001 
//STRIP001 					delete pVersions;
//STRIP001 					delete pVerTable;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SfxFilterFlags nMust = SFX_FILTER_IMPORT | SFX_FILTER_OWN;
//STRIP001 					SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED | SFX_FILTER_STARONEFILTER;
//STRIP001 					if ( SFX_APP()->GetFilterMatcher().GetFilter4ClipBoardId( pStor->GetFormat(), nMust, nDont ) )
//STRIP001 					{
//STRIP001 						aEntries.realloc( 1 );
//STRIP001 						aEntries[0] = OUString( String ( SfxResId( STR_SFX_FILEDLG_ACTUALVERSION ) ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Reference < XFilePickerControlAccess > xDlg( mxFileDlg, UNO_QUERY );
//STRIP001 	Any aValue;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		xDlg->setValue( ExtendedFilePickerElementIds::LISTBOX_VERSION,
//STRIP001 						ControlActions::DELETE_ITEMS, aValue );
//STRIP001 	}
//STRIP001 	catch( IllegalArgumentException ){}
//STRIP001 
//STRIP001 	sal_Int32 nCount = aEntries.getLength();
//STRIP001 
//STRIP001 	if ( nCount )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			aValue <<= aEntries;
//STRIP001 			xDlg->setValue( ExtendedFilePickerElementIds::LISTBOX_VERSION,
//STRIP001 							ControlActions::ADD_ITEMS, aValue );
//STRIP001 
//STRIP001 			Any aPos;
//STRIP001 			aPos <<= (sal_Int32) 0;
//STRIP001 			xDlg->setValue( ExtendedFilePickerElementIds::LISTBOX_VERSION,
//STRIP001 							ControlActions::SET_SELECT_ITEM, aPos );
//STRIP001 		}
//STRIP001 		catch( IllegalArgumentException ){}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 class OReleaseSolarMutex
//STRIP001 {
//STRIP001 private:
//STRIP001 	const sal_Int32	m_nAquireCount;
//STRIP001 public:
//STRIP001 	OReleaseSolarMutex( )
//STRIP001 		:m_nAquireCount( Application::ReleaseSolarMutex() )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	~OReleaseSolarMutex( )
//STRIP001 	{
//STRIP001 		Application::AcquireSolarMutex( m_nAquireCount );
//STRIP001 	}
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 IMPL_LINK( FileDialogHelper_Impl, TimeOutHdl_Impl, Timer*, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( !mbHasPreview )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	maGraphic.Clear();
//STRIP001 
//STRIP001 	Any aAny;
//STRIP001 	Reference < XFilePreview > xFilePicker( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( ! xFilePicker.is() )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	Sequence < OUString > aPathSeq = mxFileDlg->getFiles();
//STRIP001 
//STRIP001 	if ( mbShowPreview && ( aPathSeq.getLength() == 1 ) )
//STRIP001 	{
//STRIP001 		OUString	aURL = aPathSeq[0];
//STRIP001 
//STRIP001 		if ( ERRCODE_NONE == getGraphic( aURL, maGraphic ) )
//STRIP001 		{
//STRIP001 			// #89491
//STRIP001 			// changed the code slightly;
//STRIP001 			// before: the bitmap was scaled and
//STRIP001 			// surrounded a white frame
//STRIP001 			// now: the bitmap will only be scaled
//STRIP001 			// and the filepicker implementation
//STRIP001 			// is responsible for placing it at its
//STRIP001 			// proper position and painting a frame
//STRIP001 
//STRIP001 			Bitmap aBmp = maGraphic.GetBitmap();
//STRIP001 
//STRIP001 			// scale the bitmap to the correct size
//STRIP001 			sal_Int32 nOutWidth  = xFilePicker->getAvailableWidth();
//STRIP001 			sal_Int32 nOutHeight = xFilePicker->getAvailableHeight();
//STRIP001 			sal_Int32 nBmpWidth  = aBmp.GetSizePixel().Width();
//STRIP001 			sal_Int32 nBmpHeight = aBmp.GetSizePixel().Height();
//STRIP001 
//STRIP001 			double nXRatio = (double) nOutWidth / nBmpWidth;
//STRIP001 			double nYRatio = (double) nOutHeight / nBmpHeight;
//STRIP001 
//STRIP001 			if ( nXRatio < nYRatio )
//STRIP001 				aBmp.Scale( nXRatio, nXRatio );
//STRIP001 			else
//STRIP001 				aBmp.Scale( nYRatio, nYRatio );
//STRIP001 
//STRIP001             // #94505# Convert to true color, to allow CopyPixel
//STRIP001             aBmp.Convert( BMP_CONVERSION_24BIT );
//STRIP001 
//STRIP001 			// and copy it into the Any
//STRIP001 			SvMemoryStream aData;
//STRIP001 
//STRIP001 			aData << aBmp;
//STRIP001 
//STRIP001 			Sequence < sal_Int8 > aBuffer( (sal_Int8*) aData.GetData(), aData.GetSize() );
//STRIP001 
//STRIP001 			aAny <<= aBuffer;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		OReleaseSolarMutex aReleaseForCallback;
//STRIP001 		// clear the preview window
//STRIP001 		xFilePicker->setImage( FilePreviewImageFormats::BITMAP, aAny );
//STRIP001 	}
//STRIP001 	catch( IllegalArgumentException )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper_Impl::getGraphic( const OUString& rURL,
//STRIP001 										   Graphic& rGraphic ) const
//STRIP001 {
//STRIP001 	if ( utl::UCBContentHelper::IsFolder( rURL ) )
//STRIP001 		return ERRCODE_IO_NOTAFILE;
//STRIP001 
//STRIP001 	if ( !mpGraphicFilter )
//STRIP001 		return ERRCODE_IO_NOTSUPPORTED;
//STRIP001 
//STRIP001 	// select graphic filter from dialog filter selection
//STRIP001 	OUString aCurFilter( getFilter() );
//STRIP001 
//STRIP001 	sal_uInt16 nFilter = aCurFilter.getLength() && mpGraphicFilter->GetImportFormatCount()
//STRIP001 					? mpGraphicFilter->GetImportFormatNumber( aCurFilter )
//STRIP001 					: GRFILTER_FORMAT_DONTKNOW;
//STRIP001 
//STRIP001 	INetURLObject aURLObj( rURL );
//STRIP001 
//STRIP001 	if ( aURLObj.HasError() || INET_PROT_NOT_VALID == aURLObj.GetProtocol() )
//STRIP001 	{
//STRIP001 		aURLObj.SetSmartProtocol( INET_PROT_FILE );
//STRIP001 		aURLObj.SetSmartURL( rURL );
//STRIP001 	}
//STRIP001 
//STRIP001 	ErrCode nRet = ERRCODE_NONE;
//STRIP001 
//STRIP001 	sal_uInt32 nFilterImportFlags = GRFILTER_I_FLAGS_SET_LOGSIZE_FOR_JPEG;
//STRIP001 	// non-local?
//STRIP001 	if ( INET_PROT_FILE != aURLObj.GetProtocol() )
//STRIP001 	{
//STRIP001 		SvStream* pStream = ::utl::UcbStreamHelper::CreateStream( rURL, STREAM_READ );
//STRIP001 
//STRIP001 		if( pStream )
//STRIP001 			nRet = mpGraphicFilter->ImportGraphic( rGraphic, rURL, *pStream, nFilter, NULL, nFilterImportFlags );
//STRIP001 		else
//STRIP001 			nRet = mpGraphicFilter->ImportGraphic( rGraphic, aURLObj, nFilter, NULL, nFilterImportFlags );
//STRIP001 		delete pStream;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nRet = mpGraphicFilter->ImportGraphic( rGraphic, aURLObj, nFilter, NULL, nFilterImportFlags );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper_Impl::getGraphic( Graphic& rGraphic ) const
//STRIP001 {
//STRIP001 	ErrCode nRet = ERRCODE_NONE;
//STRIP001 
//STRIP001 	if ( ! maGraphic )
//STRIP001 	{
//STRIP001 		OUString aPath;;
//STRIP001 		Sequence < OUString > aPathSeq = mxFileDlg->getFiles();
//STRIP001 
//STRIP001 		if ( aPathSeq.getLength() == 1 )
//STRIP001 		{
//STRIP001 			aPath = aPathSeq[0];
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aPath.getLength() )
//STRIP001 			nRet = getGraphic( aPath, rGraphic );
//STRIP001 		else
//STRIP001 			nRet = ERRCODE_IO_GENERAL;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rGraphic = maGraphic;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Bool lcl_isSystemFilePicker( const Reference< XFilePicker >& _rxFP )
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference< XServiceInfo > xSI( _rxFP, UNO_QUERY );
//STRIP001 		if ( xSI.is() && xSI->supportsService( DEFINE_CONST_OUSTRING( "com.sun.star.ui.dialogs.SystemFilePicker" ) ) )
//STRIP001 			return sal_True;
//STRIP001 	}
//STRIP001 	catch( const Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // -----------		FileDialogHelper_Impl		---------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 FileDialogHelper_Impl::FileDialogHelper_Impl( FileDialogHelper* _pAntiImpl, const short nDialogType, sal_uInt32 nFlags, Window* _pPreferredParentWindow )
//STRIP001 	:m_nDialogType			( nDialogType )
//STRIP001 	,meContext				( FileDialogHelper::UNKNOWN_CONTEXT )
//STRIP001 {
//STRIP001 	OUString aService( RTL_CONSTASCII_USTRINGPARAM( FILE_OPEN_SERVICE_NAME ) );
//STRIP001 
//STRIP001 	Reference< XMultiServiceFactory > xFactory( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 
//STRIP001 	// create the file open dialog
//STRIP001 	// the flags can be SFXWB_INSERT or SFXWB_MULTISELECTION
//STRIP001 
//STRIP001 	mpPreferredParentWindow = _pPreferredParentWindow;
//STRIP001 	mpAntiImpl				= _pAntiImpl;
//STRIP001 	mnError 				= ERRCODE_NONE;
//STRIP001 	mbHasAutoExt			= sal_False;
//STRIP001 	mbHasPassword			= sal_False;
//STRIP001 	m_bHaveFilterOptions	= sal_False;
//STRIP001 	mbIsPwdEnabled			= sal_True;
//STRIP001 	mbHasVersions			= sal_False;
//STRIP001 	mbHasPreview			= sal_False;
//STRIP001 	mbShowPreview			= sal_False;
//STRIP001 	mbHasLink				= sal_False;
//STRIP001 	mbDeleteMatcher 		= sal_False;
//STRIP001 	mbInsert				= SFXWB_INSERT == ( nFlags & SFXWB_INSERT );
//STRIP001 	mbExport				= SFXWB_EXPORT == ( nFlags & SFXWB_EXPORT );
//STRIP001 	mbIsSaveDlg 			= sal_False;
//STRIP001 	mbPwdCheckBoxState		= sal_False;
//STRIP001 	mbSelection				= sal_False;
//STRIP001 	mbSelectionEnabled		= sal_True;
//STRIP001 
//STRIP001 	// default settings
//STRIP001     m_nDontFlags = SFX_FILTER_INTERNAL | SFX_FILTER_NOTINFILEDLG | SFX_FILTER_NOTINSTALLED;
//STRIP001 	if( WB_OPEN == ( nFlags & WB_OPEN ) )
//STRIP001 		m_nMustFlags = SFX_FILTER_IMPORT;
//STRIP001 	else
//STRIP001 		m_nMustFlags = SFX_FILTER_EXPORT;
//STRIP001 
//STRIP001 
//STRIP001 	mpMatcher = NULL;
//STRIP001 	mpGraphicFilter = NULL;
//STRIP001 	mnPostUserEventId = 0;
//STRIP001 
//STRIP001 	// create the picker component
//STRIP001 	mxFileDlg = mxFileDlg.query( xFactory->createInstance( aService ) );
//STRIP001 	mbSystemPicker = lcl_isSystemFilePicker( mxFileDlg );
//STRIP001 
//STRIP001 	Reference< XFilePickerNotifier > xNotifier( mxFileDlg, UNO_QUERY );
//STRIP001 	Reference< XInitialization > xInit( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( ! mxFileDlg.is() || ! xNotifier.is() )
//STRIP001 	{
//STRIP001 		mnError = ERRCODE_ABORT;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if ( xInit.is() )
//STRIP001 	{
//STRIP001 		sal_Int16 nTemplateDescription = TemplateDescription::FILEOPEN_SIMPLE;
//STRIP001 
//STRIP001 		switch ( m_nDialogType )
//STRIP001 		{
//STRIP001 			case FILEOPEN_SIMPLE:
//STRIP001 				nTemplateDescription = TemplateDescription::FILEOPEN_SIMPLE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_SIMPLE:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_SIMPLE;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_AUTOEXTENSION_PASSWORD:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD;
//STRIP001 				mbHasPassword = sal_True;
//STRIP001 				mbHasAutoExt = sal_True;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS;
//STRIP001 				mbHasPassword = sal_True;
//STRIP001 
//STRIP001 				m_bHaveFilterOptions = sal_True;
//STRIP001 				if( xFactory.is() )
//STRIP001 				{
//STRIP001 					mxFilterCFG = Reference< XNameAccess >(
//STRIP001 						xFactory->createInstance( DEFINE_CONST_OUSTRING( "com.sun.star.document.FilterFactory" ) ),
//STRIP001 						UNO_QUERY );
//STRIP001 				}
//STRIP001 
//STRIP001 				mbHasAutoExt = sal_True;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_AUTOEXTENSION_SELECTION:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_AUTOEXTENSION_SELECTION;
//STRIP001 				mbHasAutoExt = sal_True;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				if ( mbExport && !mxFilterCFG.is() && xFactory.is() )
//STRIP001 				{
//STRIP001 					mxFilterCFG = Reference< XNameAccess >(
//STRIP001 						xFactory->createInstance( DEFINE_CONST_OUSTRING( "com.sun.star.document.FilterFactory" ) ),
//STRIP001 						UNO_QUERY );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_AUTOEXTENSION_TEMPLATE:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_AUTOEXTENSION_TEMPLATE;
//STRIP001 				mbHasAutoExt = sal_True;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE:
//STRIP001 				nTemplateDescription = TemplateDescription::FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE;
//STRIP001 				mbHasPreview = sal_True;
//STRIP001 				mbHasLink = sal_True;
//STRIP001 
//STRIP001 				// aPreviewTimer
//STRIP001 				maPreViewTimer.SetTimeout( 500 );
//STRIP001 				maPreViewTimer.SetTimeoutHdl( LINK( this, FileDialogHelper_Impl, TimeOutHdl_Impl ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILEOPEN_PLAY:
//STRIP001 				nTemplateDescription = TemplateDescription::FILEOPEN_PLAY;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILEOPEN_READONLY_VERSION:
//STRIP001 				nTemplateDescription = TemplateDescription::FILEOPEN_READONLY_VERSION;
//STRIP001 				mbHasVersions = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILEOPEN_LINK_PREVIEW:
//STRIP001 				nTemplateDescription = TemplateDescription::FILEOPEN_LINK_PREVIEW;
//STRIP001 				mbHasPreview = sal_True;
//STRIP001 				mbHasLink = sal_True;
//STRIP001 				// aPreviewTimer
//STRIP001 				maPreViewTimer.SetTimeout( 500 );
//STRIP001 				maPreViewTimer.SetTimeoutHdl( LINK( this, FileDialogHelper_Impl, TimeOutHdl_Impl ) );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FILESAVE_AUTOEXTENSION:
//STRIP001 				nTemplateDescription = TemplateDescription::FILESAVE_AUTOEXTENSION;
//STRIP001 				mbHasAutoExt = sal_True;
//STRIP001 				mbIsSaveDlg = sal_True;
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERRORFILE( "FileDialogHelper::ctor with unknown type" );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		Sequence < Any > aInitArguments( mbSystemPicker || !mpPreferredParentWindow ? 1 : 2 );
//STRIP001 		// This is a hack. We currently know that the internal file picker implementation
//STRIP001 		// supports the extended arguments as specified below.
//STRIP001 		// TODO:
//STRIP001 		// a) adjust the service description so that it includes the TemplateDescription and ParentWindow args
//STRIP001 		// b) adjust the implementation of the system file picker to that it recognizes it
//STRIP001 		if ( mbSystemPicker )
//STRIP001 		{
//STRIP001 			aInitArguments[0] <<= nTemplateDescription;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aInitArguments[0] <<= NamedValue(
//STRIP001 									::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TemplateDescription" ) ),
//STRIP001 									makeAny( nTemplateDescription )
//STRIP001 								);
//STRIP001 
//STRIP001 			if ( mpPreferredParentWindow )
//STRIP001 				aInitArguments[1] <<= NamedValue(
//STRIP001 										::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ParentWindow" ) ),
//STRIP001 										makeAny( VCLUnoHelper::GetInterface( mpPreferredParentWindow ) )
//STRIP001 									);
//STRIP001 		}
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xInit->initialize( aInitArguments );
//STRIP001 		}
//STRIP001 		catch( const Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "FileDialogHelper_Impl::FileDialogHelper_Impl: could not initialize the picker!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// set multiselection mode
//STRIP001 	if ( nFlags & SFXWB_MULTISELECTION )
//STRIP001 		mxFileDlg->setMultiSelectionMode( sal_True );
//STRIP001 
//STRIP001 	if ( mbHasLink )		// generate graphic filter only on demand
//STRIP001 		addGraphicFilter();
//STRIP001 
//STRIP001 	// Export dialog
//STRIP001 	if ( mbExport )
//STRIP001 		mxFileDlg->setTitle( OUString( String( SfxResId( STR_SFX_EXPLORERFILE_EXPORT ) ) ) );
//STRIP001 
//STRIP001 	// the "insert file" dialog needs another title
//STRIP001 	if ( mbInsert )
//STRIP001 	{
//STRIP001 		mxFileDlg->setTitle( OUString( String( SfxResId( STR_SFX_EXPLORERFILE_INSERT ) ) ) );
//STRIP001 		Reference < XFilePickerControlAccess > xExtDlg( mxFileDlg, UNO_QUERY );
//STRIP001 		if ( xExtDlg.is() )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				xExtDlg->setLabel( CommonFilePickerElementIds::PUSHBUTTON_OK,
//STRIP001 								   OUString( String( SfxResId( STR_SFX_EXPLORERFILE_BUTTONINSERT ) ) ) );
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// add the event listener
//STRIP001 	xNotifier->addFilePickerListener( this );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper_Impl::~FileDialogHelper_Impl()
//STRIP001 {
//STRIP001 	// Remove user event if we haven't received it yet
//STRIP001 	if ( mnPostUserEventId )
//STRIP001 		Application::RemoveUserEvent( mnPostUserEventId );
//STRIP001 	mnPostUserEventId = 0;
//STRIP001 
//STRIP001 	delete mpGraphicFilter;
//STRIP001 
//STRIP001 	if ( mbDeleteMatcher )
//STRIP001 		delete mpMatcher;
//STRIP001 
//STRIP001 	maPreViewTimer.SetTimeoutHdl( Link() );
//STRIP001 
//STRIP001 	::comphelper::disposeComponent( mxFileDlg );
//STRIP001 }
//STRIP001 
//STRIP001 #define nMagic (sal_Int16) 0xFFFF
//STRIP001 
//STRIP001 class PickerThread_Impl : public ::vos::OThread
//STRIP001 {
//STRIP001 	Reference < XFilePicker > mxPicker;
//STRIP001 	::vos::OMutex			maMutex;
//STRIP001 	virtual void SAL_CALL	run();
//STRIP001 	sal_Int16				mnRet;
//STRIP001 public:
//STRIP001 							PickerThread_Impl( const Reference < XFilePicker >& rPicker )
//STRIP001 							: mxPicker( rPicker ), mnRet(nMagic) {}
//STRIP001 
//STRIP001 	sal_Int16				GetReturnValue()
//STRIP001 							{ ::vos::OGuard aGuard( maMutex ); return mnRet; }
//STRIP001 
//STRIP001 	void					SetReturnValue( sal_Int16 aRetValue )
//STRIP001 							{ ::vos::OGuard aGuard( maMutex ); mnRet = aRetValue; }
//STRIP001 };
//STRIP001 
//STRIP001 void SAL_CALL PickerThread_Impl::run()
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		sal_Int16 n = mxPicker->execute();
//STRIP001 		SetReturnValue( n );
//STRIP001 	}
//STRIP001 	catch( RuntimeException& )
//STRIP001 	{
//STRIP001 		SetReturnValue( ExecutableDialogResults::CANCEL );
//STRIP001 		DBG_ERRORFILE( "RuntimeException caught" );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::setControlHelpIds( const sal_Int16* _pControlId, const sal_Int32* _pHelpId )
//STRIP001 {
//STRIP001 	DBG_ASSERT( _pControlId && _pHelpId, "FileDialogHelper_Impl::setControlHelpIds: invalid array pointers!" );
//STRIP001 	if ( !_pControlId || !_pHelpId )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// forward these ids to the file picker
//STRIP001 	try
//STRIP001 	{
//STRIP001 		const ::rtl::OUString sHelpIdPrefix( RTL_CONSTASCII_USTRINGPARAM( "HID:" ) );
//STRIP001 		// the ids for the single controls
//STRIP001 		Reference< XFilePickerControlAccess > xControlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 		if ( xControlAccess.is() )
//STRIP001 		{
//STRIP001 			while ( *_pControlId )
//STRIP001 			{
//STRIP001 				// calc the help id of the element
//STRIP001 				::rtl::OUString sId( sHelpIdPrefix );
//STRIP001 				sId += ::rtl::OUString::valueOf( *_pHelpId );
//STRIP001 				// set the help id
//STRIP001 				xControlAccess->setValue( *_pControlId, ControlActions::SET_HELP_URL, makeAny( sId ) );
//STRIP001 
//STRIP001 				++_pControlId; ++_pHelpId;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( const Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "FileDialogHelper_Impl::setControlHelpIds: caught an exception while setting the help ids!" );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::setDialogHelpId( const sal_Int32 _nHelpId )
//STRIP001 {
//STRIP001 	svt::SetDialogHelpId( mxFileDlg, _nHelpId );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FileDialogHelper_Impl, InitControls, void*, NOTINTERESTEDIN )
//STRIP001 {
//STRIP001 	mnPostUserEventId = 0;
//STRIP001 	enablePasswordBox( sal_True );
//STRIP001 	updateFilterOptionsBox( );
//STRIP001 	updateSelectionBox( );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::preExecute()
//STRIP001 {
//STRIP001 	loadConfig( );
//STRIP001 	setDefaultValues( );
//STRIP001 	updatePreviewState( sal_False );
//STRIP001 
//STRIP001 	implInitializeFileName( );
//STRIP001 	// #106079# / 2002-12-09 / fs@openoffice.org
//STRIP001 
//STRIP001 	// allow for dialog implementations which need to be executed before they return valid values for
//STRIP001 	// current filter and such
//STRIP001 	mnPostUserEventId = Application::PostUserEvent( LINK( this, FileDialogHelper_Impl, InitControls ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::postExecute( sal_Int16 _nResult )
//STRIP001 {
//STRIP001 	if ( ExecutableDialogResults::CANCEL != _nResult )
//STRIP001 		saveConfig();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::implInitializeFileName( )
//STRIP001 {
//STRIP001 	if ( maFileName.getLength() )
//STRIP001 	{
//STRIP001 		INetURLObject aObj( maPath );
//STRIP001 		aObj.Append( maFileName );
//STRIP001 
//STRIP001 		// in case we're operating as save dialog, and "auto extension" is checked,
//STRIP001 		// cut the extension from the name
//STRIP001 		// #106079# / 2002-12-09 / fs@openoffice.org
//STRIP001 		if ( mbIsSaveDlg && mbHasAutoExt )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				sal_Bool bAutoExtChecked = sal_False;
//STRIP001 
//STRIP001 				Reference < XFilePickerControlAccess > xControlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 				if	(	xControlAccess.is()
//STRIP001 					&&	(	xControlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION, 0 )
//STRIP001 						>>=	bAutoExtChecked
//STRIP001 						)
//STRIP001 					)
//STRIP001 				{
//STRIP001 					if ( bAutoExtChecked )
//STRIP001 					{	// cut the extension
//STRIP001 						aObj.removeExtension( );
//STRIP001 						mxFileDlg->setDefaultName( aObj.GetName( INetURLObject::DECODE_WITH_CHARSET ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( const Exception& e )
//STRIP001 			{
//STRIP001 				e;	// make compiler happy
//STRIP001 				DBG_ERROR( "FileDialogHelper_Impl::implInitializeFileName: could not ask for the auto-extension current-value!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Int16 FileDialogHelper_Impl::implDoExecute()
//STRIP001 {
//STRIP001 	preExecute();
//STRIP001 
//STRIP001 	sal_Int16 nRet = ExecutableDialogResults::CANCEL;
//STRIP001 
//STRIP001 	if ( mbSystemPicker )
//STRIP001 	{
//STRIP001 		PickerThread_Impl* pThread = new PickerThread_Impl( mxFileDlg );
//STRIP001 		pThread->create();
//STRIP001 		while ( pThread->GetReturnValue() == nMagic )
//STRIP001 			Application::Yield();
//STRIP001 		pThread->join();
//STRIP001 		nRet = pThread->GetReturnValue();
//STRIP001 		delete pThread;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			nRet = mxFileDlg->execute();
//STRIP001 		}
//STRIP001 		catch( const Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "FileDialogHelper_Impl::implDoExecute: caught an exception!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	postExecute( nRet );
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper_Impl::execute( SvStringsDtor*& rpURLList,
//STRIP001 										SfxItemSet *&	rpSet,
//STRIP001 										String& 		rFilter )
//STRIP001 {
//STRIP001 	// rpSet is in/out parameter, usually just a media-descriptor that
//STRIP001 	// can be changed by dialog
//STRIP001 
//STRIP001 	Reference< XFilePickerControlAccess > xCtrlAccess( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	// retrieves parameters from rpSet
//STRIP001 	// for now only Password is used
//STRIP001 	if ( rpSet )
//STRIP001 	{
//STRIP001 		// check password checkbox if the document had password before
//STRIP001 		if( mbHasPassword )
//STRIP001 		{
//STRIP001 			SFX_ITEMSET_ARG( rpSet, pPassItem, SfxStringItem, SID_PASSWORD, FALSE );
//STRIP001 			mbPwdCheckBoxState = ( pPassItem != NULL );
//STRIP001 		}
//STRIP001 
//STRIP001 		SFX_ITEMSET_ARG( rpSet, pSelectItem, SfxBoolItem, SID_SELECTION, FALSE );
//STRIP001 		if ( pSelectItem )
//STRIP001 			mbSelection = pSelectItem->GetValue();
//STRIP001 		else
//STRIP001 			mbSelectionEnabled = sal_False;
//STRIP001 
//STRIP001 		// the password will be set in case user decide so
//STRIP001 		rpSet->ClearItem( SID_PASSWORD );
//STRIP001 	}
//STRIP001 
//STRIP001 	rpURLList = NULL;
//STRIP001 
//STRIP001 	if ( ! mxFileDlg.is() )
//STRIP001 		return ERRCODE_ABORT;
//STRIP001 
//STRIP001 	if ( ExecutableDialogResults::CANCEL != implDoExecute() )
//STRIP001 	{
//STRIP001 		// create an itemset if there is no
//STRIP001 		if( !rpSet )
//STRIP001 			rpSet = new SfxAllItemSet( SFX_APP()->GetPool() );
//STRIP001 
//STRIP001 		// check, wether or not we have to display a password box
//STRIP001 		if ( mbHasPassword && mbIsPwdEnabled && xCtrlAccess.is() )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_PASSWORD, 0 );
//STRIP001 				sal_Bool bPassWord = sal_False;
//STRIP001 				if ( ( aValue >>= bPassWord ) && bPassWord )
//STRIP001 				{
//STRIP001 					// ask for the password
//STRIP001 					SfxPasswordDialog aPasswordDlg( NULL );
//STRIP001 					aPasswordDlg.ShowExtras( SHOWEXTRAS_CONFIRM );
//STRIP001 					BOOL bOK = FALSE;
//STRIP001 					short nRet = aPasswordDlg.Execute();
//STRIP001 					if ( RET_OK == nRet )
//STRIP001 					{
//STRIP001 						String aPasswd = aPasswordDlg.GetPassword();
//STRIP001 						rpSet->Put( SfxStringItem( SID_PASSWORD, aPasswd ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						return ERRCODE_ABORT;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( mbExport )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_SELECTION, 0 );
//STRIP001 				sal_Bool bSelection = sal_False;
//STRIP001 				if ( ( aValue >>= bSelection ) && bSelection )
//STRIP001 					rpSet->Put( SfxBoolItem( SID_SELECTION, bSelection ) );
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException )
//STRIP001 			{
//STRIP001 				DBG_ERROR( "FileDialogHelper_Impl::execute: caught an IllegalArgumentException!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		// set the read-only flag. When inserting a file, this flag is always set
//STRIP001 		if ( mbInsert )
//STRIP001 			rpSet->Put( SfxBoolItem( SID_DOC_READONLY, sal_True ) );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( ( FILEOPEN_READONLY_VERSION == m_nDialogType ) && xCtrlAccess.is() )
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::CHECKBOX_READONLY, 0 );
//STRIP001 					sal_Bool bReadOnly = sal_False;
//STRIP001 					if ( ( aValue >>= bReadOnly ) && bReadOnly )
//STRIP001 						rpSet->Put( SfxBoolItem( SID_DOC_READONLY, bReadOnly ) );
//STRIP001 				}
//STRIP001 				catch( IllegalArgumentException )
//STRIP001 				{
//STRIP001 					DBG_ERROR( "FileDialogHelper_Impl::execute: caught an IllegalArgumentException!" );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( mbHasVersions && xCtrlAccess.is() )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Any aValue = xCtrlAccess->getValue( ExtendedFilePickerElementIds::LISTBOX_VERSION,
//STRIP001 													ControlActions::GET_SELECTED_ITEM_INDEX );
//STRIP001 				sal_Int32 nVersion = 0;
//STRIP001 				if ( ( aValue >>= nVersion ) && nVersion > 0 )
//STRIP001 					// open a special version; 0 == current version
//STRIP001 					rpSet->Put( SfxInt16Item( SID_VERSION, (short)nVersion ) );
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 
//STRIP001 		// set the filter
//STRIP001 		getRealFilter( rFilter );
//STRIP001 
//STRIP001 		// fill the rpURLList
//STRIP001 		Sequence < OUString > aPathSeq = mxFileDlg->getFiles();
//STRIP001 
//STRIP001 		if ( aPathSeq.getLength() )
//STRIP001 		{
//STRIP001 			rpURLList = new SvStringsDtor;
//STRIP001 
//STRIP001 			if ( aPathSeq.getLength() == 1 )
//STRIP001 			{
//STRIP001 				OUString aFileURL( aPathSeq[0] );
//STRIP001 
//STRIP001 				String* pURL = new String( aFileURL );
//STRIP001 				rpURLList->Insert( pURL, 0 );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				INetURLObject aPath( aPathSeq[0] );
//STRIP001 				aPath.setFinalSlash();
//STRIP001 
//STRIP001 				for ( USHORT i = 1; i < aPathSeq.getLength(); ++i )
//STRIP001 				{
//STRIP001 					if ( i == 1 )
//STRIP001 						aPath.Append( aPathSeq[i] );
//STRIP001 					else
//STRIP001 						aPath.setName( aPathSeq[i] );
//STRIP001 
//STRIP001 					String* pURL = new String( aPath.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 					rpURLList->Insert( pURL, rpURLList->Count() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			SaveLastUsedFilter();
//STRIP001 			return ERRCODE_NONE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			return ERRCODE_ABORT;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return ERRCODE_ABORT;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper_Impl::execute()
//STRIP001 {
//STRIP001 	if ( ! mxFileDlg.is() )
//STRIP001 		return ERRCODE_ABORT;
//STRIP001 
//STRIP001 	sal_Int16 nRet = implDoExecute();
//STRIP001 
//STRIP001 	maPath = mxFileDlg->getDisplayDirectory();
//STRIP001 
//STRIP001 	if ( ExecutableDialogResults::CANCEL == nRet )
//STRIP001 		return ERRCODE_ABORT;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return ERRCODE_NONE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 OUString FileDialogHelper_Impl::getPath() const
//STRIP001 {
//STRIP001 	OUString aPath;
//STRIP001 
//STRIP001 	if ( mxFileDlg.is() )
//STRIP001 		aPath = mxFileDlg->getDisplayDirectory();
//STRIP001 
//STRIP001 	if ( !aPath.getLength() )
//STRIP001 		aPath = maPath;
//STRIP001 
//STRIP001 	return aPath;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 OUString FileDialogHelper_Impl::getFilter() const
//STRIP001 {
//STRIP001 	String aFilter = getCurrentFilterUIName();
//STRIP001 
//STRIP001 	if( !aFilter.Len() )
//STRIP001 		aFilter = maCurFilter;
//STRIP001 
//STRIP001 	return aFilter;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::getRealFilter( String& _rFilter ) const
//STRIP001 {
//STRIP001 	_rFilter = getCurrentFilterUIName();
//STRIP001 
//STRIP001 	if ( !_rFilter.Len() )
//STRIP001 		_rFilter = maCurFilter;
//STRIP001 
//STRIP001 	if ( _rFilter.Len() && mpMatcher )
//STRIP001 	{
//STRIP001 		const SfxFilter* pFilter =
//STRIP001 			mpMatcher->GetFilter4UIName( _rFilter, m_nMustFlags, m_nDontFlags );
//STRIP001 		_rFilter = pFilter ? pFilter->GetFilterName() : _rFilter.Erase();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::displayFolder( const ::rtl::OUString& _rPath )
//STRIP001 {
//STRIP001 	if ( ! _rPath.getLength() )
//STRIP001 		// nothing to do
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( !::utl::UCBContentHelper::IsFolder( _rPath ) )
//STRIP001 		// only valid folders accepted here
//STRIP001 		return;
//STRIP001 
//STRIP001 	maPath = _rPath;
//STRIP001 	if ( mxFileDlg.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			mxFileDlg->setDisplayDirectory( maPath );
//STRIP001 		}
//STRIP001 		catch( const IllegalArgumentException& e )
//STRIP001 		{
//STRIP001 			e; // make compiler happy
//STRIP001 			DBG_ERROR( "FileDialogHelper_Impl::displayFolder: caught an exception!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::setFileName( const ::rtl::OUString& _rFile )
//STRIP001 {
//STRIP001 	maFileName = _rFile;
//STRIP001 	if ( mxFileDlg.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			mxFileDlg->setDefaultName( maFileName );
//STRIP001 		}
//STRIP001 		catch( const IllegalArgumentException& e )
//STRIP001 		{
//STRIP001 			e; // make compiler happy
//STRIP001 			DBG_ERROR( "FileDialogHelper_Impl::setFileName: caught an exception!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::setFilter( const OUString& rFilter )
//STRIP001 {
//STRIP001 	maCurFilter = rFilter;
//STRIP001 
//STRIP001 	if ( rFilter.getLength() && mpMatcher )
//STRIP001 	{
//STRIP001 		const SfxFilter* pFilter = mpMatcher->GetFilter(
//STRIP001 										rFilter, m_nMustFlags, m_nDontFlags );
//STRIP001 		if ( pFilter )
//STRIP001 			maCurFilter = pFilter->GetUIName();
//STRIP001 	}
//STRIP001 
//STRIP001 	Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( maCurFilter.getLength() && xFltMgr.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xFltMgr->setCurrentFilter( maCurFilter );
//STRIP001 		}
//STRIP001 		catch( IllegalArgumentException ){}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::createMatcher( const SfxObjectFactory& rFactory )
//STRIP001 {
//STRIP001 	mpMatcher = new SfxFilterMatcher( rFactory.GetFilterContainer() );
//STRIP001 	mbDeleteMatcher = sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::addFilters( sal_uInt32 nFlags,
//STRIP001 										const SfxObjectFactory& rFactory,
//STRIP001 										SfxFilterFlags nMust,
//STRIP001 										SfxFilterFlags nDont )
//STRIP001 {
//STRIP001 	Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( ! xFltMgr.is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// create the list of filters
//STRIP001 
//STRIP001 	if ( !&rFactory )
//STRIP001 	{
//STRIP001 		SfxApplication *pSfxApp = SFX_APP();
//STRIP001 
//STRIP001 		mpMatcher = &pSfxApp->GetFilterMatcher();
//STRIP001 		mbDeleteMatcher = sal_False;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		mpMatcher = new SfxFilterMatcher( rFactory.GetFilterContainer() );
//STRIP001 		mbDeleteMatcher = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	m_nMustFlags |= nMust;
//STRIP001 	m_nDontFlags |= nDont;
//STRIP001 
//STRIP001 	SfxFilterMatcherIter aIter( mpMatcher, m_nMustFlags, m_nDontFlags );
//STRIP001 
//STRIP001 	// append the filters
//STRIP001 	::rtl::OUString sFirstFilter;
//STRIP001 	if ( WB_OPEN == ( nFlags & WB_OPEN ) )
//STRIP001 		::sfx2::appendFiltersForOpen( aIter, xFltMgr, sFirstFilter, *this );
//STRIP001 	else if ( mbExport )
//STRIP001 		::sfx2::appendExportFilters( aIter, xFltMgr, sFirstFilter, *this );
//STRIP001 	else
//STRIP001 		::sfx2::appendFiltersForSave( aIter, xFltMgr, sFirstFilter, *this );
//STRIP001 
//STRIP001 	// set our initial selected filter (if we do not already have one)
//STRIP001 	if ( maSelectFilter.getLength() )
//STRIP001 		maSelectFilter = sFirstFilter;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::addFilter( const OUString& rFilterName,
//STRIP001 									   const OUString& rExtension )
//STRIP001 {
//STRIP001 	Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( ! xFltMgr.is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		xFltMgr->appendFilter( rFilterName, rExtension );
//STRIP001 
//STRIP001 		if ( !maSelectFilter.getLength() )
//STRIP001 			maSelectFilter = rFilterName;
//STRIP001 	}
//STRIP001 	catch( IllegalArgumentException )
//STRIP001 	{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		ByteString aMsg( "Could not append Filter" );
//STRIP001 		aMsg += ByteString( String( rFilterName ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		DBG_ERRORFILE( aMsg.GetBuffer() );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::addGraphicFilter()
//STRIP001 {
//STRIP001 	Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 
//STRIP001 	if ( ! xFltMgr.is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// create the list of filters
//STRIP001 	mpGraphicFilter = new GraphicFilter;
//STRIP001 	USHORT i, j, nCount = mpGraphicFilter->GetImportFormatCount();
//STRIP001 
//STRIP001 	// compute the extension string for all known import filters
//STRIP001 	String aExtensions;
//STRIP001 
//STRIP001 	for ( i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		j = 0;
//STRIP001 		String sWildcard;
//STRIP001 		while( TRUE )
//STRIP001 		{
//STRIP001 			sWildcard = mpGraphicFilter->GetImportWildcard( i, j++ );
//STRIP001 			if ( !sWildcard.Len() )
//STRIP001 				break;
//STRIP001 			if ( aExtensions.Search( sWildcard ) == STRING_NOTFOUND )
//STRIP001 			{
//STRIP001 				if ( aExtensions.Len() )
//STRIP001 					aExtensions += sal_Unicode(';');
//STRIP001 				aExtensions += sWildcard;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 #if defined(WIN) || defined(WNT)
//STRIP001 	if ( aExtensions.Len() > 240 )
//STRIP001 		aExtensions = DEFINE_CONST_UNICODE( FILEDIALOG_FILTER_ALL );
//STRIP001 #endif
//STRIP001 	sal_Bool bIsInOpenMode = isInOpenMode();
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		OUString aAllFilterName = String( SfxResId( STR_SFX_IMPORT_ALL ) );
//STRIP001 		aAllFilterName = ::sfx2::addExtension( aAllFilterName, aExtensions, bIsInOpenMode, *this );
//STRIP001 
//STRIP001 		xFltMgr->appendFilter( aAllFilterName, aExtensions );
//STRIP001 		maSelectFilter = aAllFilterName;
//STRIP001 	}
//STRIP001 	catch( IllegalArgumentException )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Could not append Filter" );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Now add the filter
//STRIP001 	for ( i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		String aName = mpGraphicFilter->GetImportFormatName( i );
//STRIP001 		String aExtensions;
//STRIP001 		j = 0;
//STRIP001 		String sWildcard;
//STRIP001 		while( TRUE )
//STRIP001 		{
//STRIP001 			sWildcard = mpGraphicFilter->GetImportWildcard( i, j++ );
//STRIP001 			if ( !sWildcard.Len() )
//STRIP001 				break;
//STRIP001 			if ( aExtensions.Search( sWildcard ) == STRING_NOTFOUND )
//STRIP001 			{
//STRIP001 				if ( aExtensions.Len() )
//STRIP001 					aExtensions += sal_Unicode(';');
//STRIP001 				aExtensions += sWildcard;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aName = ::sfx2::addExtension( aName, aExtensions, bIsInOpenMode, *this );
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xFltMgr->appendFilter( aName, aExtensions );
//STRIP001 		}
//STRIP001 		catch( IllegalArgumentException )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "Could not append Filter" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 #define GRF_CONFIG_STR		"   "
//STRIP001 #define STD_CONFIG_STR		"1 "
//STRIP001 
//STRIP001 void FileDialogHelper_Impl::saveConfig()
//STRIP001 {
//STRIP001 	Reference < XFilePickerControlAccess > xDlg( mxFileDlg, UNO_QUERY );
//STRIP001 	Any aValue;
//STRIP001 
//STRIP001 	if ( ! xDlg.is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( mbHasPreview )
//STRIP001 	{
//STRIP001 		SvtViewOptions aDlgOpt( E_DIALOG, IMPGRF_CONFIGNAME );
//STRIP001 		String aUserData = DEFINE_CONST_UNICODE( GRF_CONFIG_STR );
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			aValue = xDlg->getValue( ExtendedFilePickerElementIds::CHECKBOX_LINK, 0 );
//STRIP001 			sal_Bool bValue = sal_False;
//STRIP001 			aValue >>= bValue;
//STRIP001 			aUserData.SetToken( 0, ' ', String::CreateFromInt32( (sal_Int32) bValue ) );
//STRIP001 
//STRIP001 			aValue = xDlg->getValue( ExtendedFilePickerElementIds::CHECKBOX_PREVIEW, 0 );
//STRIP001 			bValue = sal_False;
//STRIP001 			aValue >>= bValue;
//STRIP001 			aUserData.SetToken( 1, ' ', String::CreateFromInt32( (sal_Int32) bValue ) );
//STRIP001 
//STRIP001 			INetURLObject aObj( getPath() );
//STRIP001 
//STRIP001 			if ( aObj.GetProtocol() == INET_PROT_FILE )
//STRIP001 				aUserData.SetToken( 2, ' ', aObj.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 			String aFilter = getFilter();
//STRIP001 			aFilter = EncodeSpaces_Impl( aFilter );
//STRIP001 			aUserData.SetToken( 3, ' ', aFilter );
//STRIP001 
//STRIP001 			aDlgOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( aUserData ) ) );
//STRIP001 		}
//STRIP001 		catch( IllegalArgumentException ){}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		sal_Bool bWriteConfig = sal_False;
//STRIP001 		SvtViewOptions aDlgOpt( E_DIALOG, IODLG_CONFIGNAME );
//STRIP001 		String aUserData = DEFINE_CONST_UNICODE( STD_CONFIG_STR );
//STRIP001 
//STRIP001 		if ( aDlgOpt.Exists() )
//STRIP001 		{
//STRIP001 			Any aUserItem = aDlgOpt.GetUserItem( USERITEM_NAME );
//STRIP001 			OUString aTemp;
//STRIP001 			if ( aUserItem >>= aTemp )
//STRIP001 				aUserData = String( aTemp );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( mbHasAutoExt )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				aValue = xDlg->getValue( ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION, 0 );
//STRIP001 				sal_Bool bAutoExt = sal_True;
//STRIP001 				aValue >>= bAutoExt;
//STRIP001 				aUserData.SetToken( 0, ' ', String::CreateFromInt32( (sal_Int32) bAutoExt ) );
//STRIP001 				bWriteConfig = sal_True;
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( ! mbIsSaveDlg )
//STRIP001 		{
//STRIP001 			OUString aPath = getPath();
//STRIP001 			if ( aPath.getLength() &&
//STRIP001 				 utl::LocalFileHelper::IsLocalFile( aPath ) )
//STRIP001 			{
//STRIP001 				aUserData.SetToken( 1, ' ', aPath );
//STRIP001 				bWriteConfig = sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bWriteConfig )
//STRIP001 			aDlgOpt.SetUserItem( USERITEM_NAME, makeAny( OUString( aUserData ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	pSfxApp->SetLastDir_Impl( getPath() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 namespace
//STRIP001 {
//STRIP001 	static ::rtl::OUString getInitPath( const String& _rFallback, const xub_StrLen _nFallbackToken )
//STRIP001 	{
//STRIP001 		SfxApplication *pSfxApp = SFX_APP();
//STRIP001 		String sPath = pSfxApp->GetLastDir_Impl();
//STRIP001 
//STRIP001 		if ( !sPath.Len() )
//STRIP001 			sPath = _rFallback.GetToken( _nFallbackToken, ' ' );
//STRIP001 
//STRIP001 		// check if the path points to a valid (accessible) directory
//STRIP001 		sal_Bool bValid = sal_False;
//STRIP001 		if ( sPath.Len() )
//STRIP001 		{
//STRIP001 			String sPathCheck( sPath );
//STRIP001 			if ( sPathCheck.GetBuffer()[ sPathCheck.Len() - 1 ] != '/' )
//STRIP001 				sPathCheck += '/';
//STRIP001 			sPathCheck += '.';
//STRIP001 			try
//STRIP001 			{
//STRIP001 				::ucb::Content aContent( sPathCheck, Reference< ::com::sun::star::ucb::XCommandEnvironment >() );
//STRIP001 				bValid = aContent.isFolder();
//STRIP001 			}
//STRIP001 			catch( const Exception& e )
//STRIP001 			{
//STRIP001 				e;	// make compiler happy
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bValid )
//STRIP001 			sPath.Erase();
//STRIP001 
//STRIP001 		return sPath;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::loadConfig()
//STRIP001 {
//STRIP001 	Reference < XFilePickerControlAccess > xDlg( mxFileDlg, UNO_QUERY );
//STRIP001 	Any aValue;
//STRIP001 
//STRIP001 	if ( ! xDlg.is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( mbHasPreview )
//STRIP001 	{
//STRIP001 		SvtViewOptions aViewOpt( E_DIALOG, IMPGRF_CONFIGNAME );
//STRIP001 		String aUserData;
//STRIP001 
//STRIP001 		if ( aViewOpt.Exists() )
//STRIP001 		{
//STRIP001 			Any aUserItem = aViewOpt.GetUserItem( USERITEM_NAME );
//STRIP001 			OUString aTemp;
//STRIP001 			if ( aUserItem >>= aTemp )
//STRIP001 				aUserData = String( aTemp );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aUserData.Len() > 0 )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				// respect the last "insert as link" state
//STRIP001 				sal_Bool bLink = (sal_Bool) aUserData.GetToken( 0, ' ' ).ToInt32();
//STRIP001 				aValue <<= bLink;
//STRIP001 				xDlg->setValue( ExtendedFilePickerElementIds::CHECKBOX_LINK, 0, aValue );
//STRIP001 
//STRIP001 				// respect the last "show preview" state
//STRIP001 				sal_Bool bShowPreview = (sal_Bool) aUserData.GetToken( 1, ' ' ).ToInt32();
//STRIP001 				aValue <<= bShowPreview;
//STRIP001 				xDlg->setValue( ExtendedFilePickerElementIds::CHECKBOX_PREVIEW, 0, aValue );
//STRIP001 
//STRIP001 				if ( !maPath.getLength() )
//STRIP001 					displayFolder( getInitPath( aUserData, 2 ) );
//STRIP001 
//STRIP001 				if ( ! maCurFilter.getLength() )
//STRIP001 				{
//STRIP001 					String aFilter = aUserData.GetToken( 3, ' ' );
//STRIP001 					aFilter = DecodeSpaces_Impl( aFilter );
//STRIP001 					setFilter( aFilter );
//STRIP001 				}
//STRIP001 
//STRIP001 				// set the member so we know that we have to show the preview
//STRIP001 				mbShowPreview = bShowPreview;
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !maPath.getLength() )
//STRIP001 			displayFolder( SvtPathOptions().GetGraphicPath() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvtViewOptions aViewOpt( E_DIALOG, IODLG_CONFIGNAME );
//STRIP001 		String aUserData;
//STRIP001 
//STRIP001 		if ( aViewOpt.Exists() )
//STRIP001 		{
//STRIP001 			Any aUserItem = aViewOpt.GetUserItem( USERITEM_NAME );
//STRIP001 			OUString aTemp;
//STRIP001 			if ( aUserItem >>= aTemp )
//STRIP001 				aUserData = String( aTemp );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( ! aUserData.Len() )
//STRIP001 			aUserData = DEFINE_CONST_UNICODE( STD_CONFIG_STR );
//STRIP001 
//STRIP001 		if ( ! maPath.getLength() )
//STRIP001 			displayFolder( getInitPath( aUserData, 1 ) );
//STRIP001 
//STRIP001 		if ( mbHasAutoExt )
//STRIP001 		{
//STRIP001 			sal_Int32 nFlag = aUserData.GetToken( 0, ' ' ).ToInt32();
//STRIP001 			aValue <<= (sal_Bool) nFlag;
//STRIP001 			try
//STRIP001 			{
//STRIP001 				xDlg->setValue( ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION, 0, aValue );
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException ){}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !maPath.getLength() )
//STRIP001 			displayFolder( SvtPathOptions().GetWorkPath() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper_Impl::setDefaultValues()
//STRIP001 {
//STRIP001 	// when no filter is set, we set the curentFilter to <all>
//STRIP001 	if ( !maCurFilter.getLength() && maSelectFilter.getLength() )
//STRIP001 	{
//STRIP001 		Reference< XFilterManager > xFltMgr( mxFileDlg, UNO_QUERY );
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xFltMgr->setCurrentFilter( maSelectFilter );
//STRIP001 		}
//STRIP001 		catch( IllegalArgumentException )
//STRIP001 		{}
//STRIP001 	}
//STRIP001 
//STRIP001 	// when no path is set, we use the standard 'work' folder
//STRIP001 	if ( ! maPath.getLength() )
//STRIP001 	{
//STRIP001 		OUString aWorkFolder = SvtPathOptions().GetWorkPath();
//STRIP001 		mxFileDlg->setDisplayDirectory( aWorkFolder );
//STRIP001 
//STRIP001 		// INetURLObject aStdDirObj( SvtPathOptions().GetWorkPath() );
//STRIP001 		//SetStandardDir( aStdDirObj.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool FileDialogHelper_Impl::isShowFilterExtensionEnabled() const
//STRIP001 {
//STRIP001 	return !maFilters.empty();
//STRIP001 }
//STRIP001 
//STRIP001 void FileDialogHelper_Impl::addFilterPair( const OUString& rFilter,
//STRIP001 										   const OUString& rFilterWithExtension )
//STRIP001 {
//STRIP001 	maFilters.push_back( FilterPair( rFilter, rFilterWithExtension ) );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 OUString FileDialogHelper_Impl::getFilterName( const OUString& rFilterWithExtension ) const
//STRIP001 {
//STRIP001 	OUString sRet;
//STRIP001 	for( ::std::vector< FilterPair >::const_iterator pIter = maFilters.begin(); pIter != maFilters.end(); ++pIter )
//STRIP001 	{
//STRIP001 		if ( (*pIter).Second == rFilterWithExtension )
//STRIP001 		{
//STRIP001 			sRet = (*pIter).First;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 OUString FileDialogHelper_Impl::getFilterWithExtension( const OUString& rFilter ) const
//STRIP001 {
//STRIP001 	OUString sRet;
//STRIP001 	for( ::std::vector< FilterPair >::const_iterator pIter = maFilters.begin(); pIter != maFilters.end(); ++pIter )
//STRIP001 	{
//STRIP001 		if ( (*pIter).First == rFilter )
//STRIP001 		{
//STRIP001 			sRet = (*pIter).Second;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 void FileDialogHelper_Impl::SetContext( FileDialogHelper::Context _eNewContext )
//STRIP001 {
//STRIP001 	meContext = _eNewContext;
//STRIP001 
//STRIP001 	sal_Int32		nNewHelpId = 0;
//STRIP001 	OUString		aConfigId;
//STRIP001 
//STRIP001 	switch( _eNewContext )
//STRIP001 	{
//STRIP001 // #104952#	dependency to SVX not allowed! When used again, another solution has to be found
//STRIP001 //		case FileDialogHelper::SW_INSERT_GRAPHIC:
//STRIP001 //		case FileDialogHelper::SC_INSERT_GRAPHIC:
//STRIP001 //		case FileDialogHelper::SD_INSERT_GRAPHIC:		nNewHelpId = SID_INSERT_GRAPHIC;		break;
//STRIP001 		case FileDialogHelper::SW_INSERT_SOUND:
//STRIP001 		case FileDialogHelper::SC_INSERT_SOUND:
//STRIP001 		case FileDialogHelper::SD_INSERT_SOUND:			nNewHelpId = SID_INSERT_SOUND;			break;
//STRIP001 		case FileDialogHelper::SW_INSERT_VIDEO:
//STRIP001 		case FileDialogHelper::SC_INSERT_VIDEO:
//STRIP001 		case FileDialogHelper::SD_INSERT_VIDEO:			nNewHelpId = SID_INSERT_VIDEO;			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	const OUString*	pConfigId = GetLastFilterConfigId( _eNewContext );
//STRIP001 	if( pConfigId )
//STRIP001 		LoadLastUsedFilter( *pConfigId );
//STRIP001 
//STRIP001 //	if( nNewHelpId )
//STRIP001 //		this->setDialogHelpId( nNewHelpId );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // -----------			FileDialogHelper		---------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 FileDialogHelper::FileDialogHelper( sal_uInt32 nFlags,
//STRIP001 									const SfxObjectFactory& rFact,
//STRIP001 									SfxFilterFlags nMust,
//STRIP001 									SfxFilterFlags nDont )
//STRIP001 {
//STRIP001 	mpImp = new FileDialogHelper_Impl( this, getDialogType( nFlags ), nFlags );
//STRIP001 	mxImp = mpImp;
//STRIP001 
//STRIP001 	// create the list of filters
//STRIP001 	mpImp->addFilters( nFlags, rFact, nMust, nDont );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper::FileDialogHelper( sal_uInt32 nFlags )
//STRIP001 {
//STRIP001 	const short nDialogType = getDialogType( nFlags );
//STRIP001 
//STRIP001 	mpImp = new FileDialogHelper_Impl( this, nDialogType, nFlags );
//STRIP001 	mxImp = mpImp;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper::FileDialogHelper( const short nDialogType,
//STRIP001 									sal_uInt32 nFlags,
//STRIP001 									const SfxObjectFactory& rFact,
//STRIP001 									SfxFilterFlags nMust,
//STRIP001 									SfxFilterFlags nDont )
//STRIP001 {
//STRIP001 	mpImp = new FileDialogHelper_Impl( this, nDialogType, nFlags );
//STRIP001 	mxImp = mpImp;
//STRIP001 
//STRIP001 	// create the list of filters
//STRIP001 	mpImp->addFilters( nFlags, rFact, nMust, nDont );
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef FS_PRIV_DEBUG
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper::FileDialogHelper( const short nDialogType,
//STRIP001 									sal_uInt32 nFlags )
//STRIP001 {
//STRIP001 	mpImp = new FileDialogHelper_Impl( this, nDialogType, nFlags );
//STRIP001 	mxImp = mpImp;
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper::FileDialogHelper( const short nDialogType,
//STRIP001 									sal_uInt32 nFlags, Window* _pPreferredParent )
//STRIP001 {
//STRIP001 	mpImp = new FileDialogHelper_Impl( this, nDialogType, nFlags, _pPreferredParent );
//STRIP001 	mxImp = mpImp;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 FileDialogHelper::~FileDialogHelper()
//STRIP001 {
//STRIP001 	mpImp->dispose();
//STRIP001 	mxImp.clear();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::CreateMatcher( const SfxObjectFactory& rFactory )
//STRIP001 {
//STRIP001 	mpImp->createMatcher( rFactory );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::SetControlHelpIds( const sal_Int16* _pControlId, const sal_Int32* _pHelpId )
//STRIP001 {
//STRIP001 	mpImp->setControlHelpIds( _pControlId, _pHelpId );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::SetDialogHelpId( const sal_Int32 _nHelpId )
//STRIP001 {
//STRIP001 	mpImp->setDialogHelpId( _nHelpId );
//STRIP001 }
//STRIP001 
//STRIP001 void FileDialogHelper::SetContext( Context _eNewContext )
//STRIP001 {
//STRIP001 	mpImp->SetContext( _eNewContext );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper::Execute( const String&   rPath,
//STRIP001 								   SvStringsDtor*& rpURLList,
//STRIP001 								   SfxItemSet *&   rpSet,
//STRIP001 								   String&		   rFilter )
//STRIP001 {
//STRIP001 	SetDisplayDirectory( rPath );
//STRIP001 
//STRIP001 	return mpImp->execute( rpURLList, rpSet, rFilter );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper::Execute()
//STRIP001 {
//STRIP001 	return mpImp->execute();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper::Execute( SfxItemSet *&   rpSet,
//STRIP001 								   String&		   rFilter )
//STRIP001 {
//STRIP001 	ErrCode nRet;
//STRIP001 	SvStringsDtor* pURLList;
//STRIP001 
//STRIP001 	nRet = mpImp->execute( pURLList, rpSet, rFilter );
//STRIP001 
//STRIP001 	delete pURLList;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::SetTitle( const String& rNewTitle )
//STRIP001 {
//STRIP001 	if ( mpImp->mxFileDlg.is() )
//STRIP001 		mpImp->mxFileDlg->setTitle( rNewTitle );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String FileDialogHelper::GetPath() const
//STRIP001 {
//STRIP001 	OUString aPath;
//STRIP001 
//STRIP001 	if ( mpImp->mxFileDlg.is() )
//STRIP001 	{
//STRIP001 		Sequence < OUString > aPathSeq = mpImp->mxFileDlg->getFiles();
//STRIP001 
//STRIP001 		if ( aPathSeq.getLength() == 1 )
//STRIP001 		{
//STRIP001 			aPath = aPathSeq[0];
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aPath;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 Sequence < OUString > FileDialogHelper::GetMPath() const
//STRIP001 {
//STRIP001 	if ( mpImp->mxFileDlg.is() )
//STRIP001 		return mpImp->mxFileDlg->getFiles();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Sequence < OUString > aEmpty;
//STRIP001 		return aEmpty;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String FileDialogHelper::GetDisplayDirectory() const
//STRIP001 {
//STRIP001 	return mpImp->getPath();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String FileDialogHelper::GetCurrentFilter() const
//STRIP001 {
//STRIP001 	return mpImp->getFilter();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode FileDialogHelper::GetGraphic( Graphic& rGraphic ) const
//STRIP001 {
//STRIP001 	return mpImp->getGraphic( rGraphic );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::SetDisplayDirectory( const String& _rPath )
//STRIP001 {
//STRIP001 	if ( !_rPath.Len() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// if the given path isn't a folder, we cut off the last part
//STRIP001 	// and take it as filename and the rest of the path should be
//STRIP001 	// the folder
//STRIP001 
//STRIP001 	::rtl::OUString sPath;
//STRIP001 	::rtl::OUString sFileName;
//STRIP001 
//STRIP001 	INetURLObject aObj( _rPath );
//STRIP001 	if ( !::utl::UCBContentHelper::IsFolder( _rPath ) )
//STRIP001 	{
//STRIP001 		sFileName = aObj.GetName( INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 		aObj.removeSegment();
//STRIP001 	}
//STRIP001 
//STRIP001 	sPath = aObj.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 
//STRIP001 	mpImp->displayFolder( sPath );
//STRIP001 	mpImp->setFileName( sFileName );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::AddFilter( const String& rFilterName,
//STRIP001 								  const String& rExtension )
//STRIP001 {
//STRIP001 	mpImp->addFilter( rFilterName, rExtension );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void FileDialogHelper::SetCurrentFilter( const String& rFilter )
//STRIP001 {
//STRIP001 	String sFilter( rFilter );
//STRIP001 	if ( mpImp->isShowFilterExtensionEnabled() )
//STRIP001 		sFilter = mpImp->getFilterWithExtension( rFilter );
//STRIP001 	mpImp->setFilter( sFilter );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 Reference < XFilePicker > FileDialogHelper::GetFilePicker() const
//STRIP001 {
//STRIP001 	return mpImp->mxFileDlg;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 const short FileDialogHelper::getDialogType( sal_uInt32 nFlags ) const
//STRIP001 {
//STRIP001 	short nDialogType = FILEOPEN_SIMPLE;
//STRIP001 
//STRIP001 	if ( nFlags & WB_SAVEAS )
//STRIP001 	{
//STRIP001 		if ( nFlags & SFXWB_PASSWORD )
//STRIP001 			nDialogType = FILESAVE_AUTOEXTENSION_PASSWORD;
//STRIP001 		else
//STRIP001 			nDialogType = FILESAVE_SIMPLE;
//STRIP001 	}
//STRIP001 	else if ( nFlags & SFXWB_GRAPHIC )
//STRIP001 	{
//STRIP001 		if ( nFlags & SFXWB_SHOWSTYLES )
//STRIP001 			nDialogType = FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE;
//STRIP001 		else
//STRIP001 			nDialogType = FILEOPEN_LINK_PREVIEW;
//STRIP001 	}
//STRIP001 	else if ( SFXWB_INSERT != ( nFlags & SFXWB_INSERT ) )
//STRIP001 		nDialogType = FILEOPEN_READONLY_VERSION;
//STRIP001 
//STRIP001 	return nDialogType;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // XFilePickerListener Methods
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper::FileSelectionChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	mpImp->handleFileSelectionChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper::DirectoryChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	mpImp->handleDirectoryChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 OUString SAL_CALL FileDialogHelper::HelpRequested( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	return mpImp->handleHelpRequested( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper::ControlStateChanged( const FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	mpImp->handleControlStateChanged( aEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL FileDialogHelper::DialogSizeChanged()
//STRIP001 {
//STRIP001 	mpImp->handleDialogSizeChanged();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 ErrCode FileOpenDialog_Impl( sal_uInt32 nFlags,
//STRIP001 							 const SfxObjectFactory& rFact,
//STRIP001 							 SvStringsDtor *& rpURLList,
//STRIP001 							 String& rFilter,
//STRIP001 							 SfxItemSet *& rpSet,
//STRIP001 							 String aPath,
//STRIP001 							 ULONG nHelpId )
//STRIP001 {
//STRIP001 	ErrCode nRet;
//STRIP001 	FileDialogHelper aDialog( nFlags, rFact );
//STRIP001 
//STRIP001 //	if( nHelpId )
//STRIP001 //		aDialog.SetDialogHelpId( nHelpId );
//STRIP001 
//STRIP001 	nRet = aDialog.Execute( aPath, rpURLList, rpSet, rFilter );
//STRIP001 
//STRIP001 	aPath = aDialog.GetDisplayDirectory();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String EncodeSpaces_Impl( const String& rSource )
//STRIP001 {
//STRIP001 	String sRet( rSource );
//STRIP001 	sRet.SearchAndReplaceAll( DEFINE_CONST_UNICODE( " " ), DEFINE_CONST_UNICODE( "%20" ) );
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String DecodeSpaces_Impl( const String& rSource )
//STRIP001 {
//STRIP001 	String sRet( rSource );
//STRIP001 	sRet.SearchAndReplaceAll( DEFINE_CONST_UNICODE( "%20" ), DEFINE_CONST_UNICODE( " " ) );
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 }	// end of namespace sfx2

}
