/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_measure.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:55:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


// include ---------------------------------------------------------------

#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#pragma hdrstop

#include "dialogs.hrc"

#define _SVX_MEASURE_CXX

#include "svdomeas.hxx"
#include "svdattr.hxx"
#include "svdattrx.hxx"
#include "svdview.hxx"

#include "measctrl.hxx"
#include "measure.hxx"
#include "measure.hrc"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "strarray.hxx"
namespace binfilter {


//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_MEASURE_FIRST,
//STRIP001 	SDRATTR_MEASURE_LAST,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Dialog to change measure-attributes
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxMeasureDialog::SvxMeasureDialog( Window* pParent, const SfxItemSet& rInAttrs,
//STRIP001 								const SdrView* pSdrView ) :
//STRIP001 		SfxSingleTabDialog( pParent, rInAttrs, RID_SVXPAGE_MEASURE )
//STRIP001 {
//STRIP001 	SvxMeasurePage* pPage = new SvxMeasurePage( this, rInAttrs );
//STRIP001 
//STRIP001 	pPage->SetView( pSdrView );
//STRIP001 	pPage->Construct();
//STRIP001 
//STRIP001 	SetTabPage( pPage );
//STRIP001 	SetText( pPage->GetText() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Dtor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxMeasureDialog::~SvxMeasureDialog()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Tabpage for changing measure-attributes
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxMeasurePage::SvxMeasurePage( Window* pWindow, const SfxItemSet& rInAttrs ) :
//STRIP001 				SvxTabPage		( pWindow, ResId( RID_SVXPAGE_MEASURE, DIALOG_MGR() ),
//STRIP001 								  rInAttrs ),
//STRIP001 
//STRIP001 		rOutAttrs				( rInAttrs ),
//STRIP001 		aAttrSet				( *rInAttrs.GetPool() ),
//STRIP001 
//STRIP001 		aFlLine                 ( this, ResId( FL_LINE ) ),
//STRIP001 		aFtLineDist				( this, ResId( FT_LINE_DIST ) ),
//STRIP001 		aMtrFldLineDist			( this, ResId( MTR_LINE_DIST ) ),
//STRIP001 		aFtHelplineOverhang		( this, ResId( FT_HELPLINE_OVERHANG ) ),
//STRIP001 		aMtrFldHelplineOverhang	( this, ResId( MTR_FLD_HELPLINE_OVERHANG ) ),
//STRIP001 		aFtHelplineDist			( this, ResId( FT_HELPLINE_DIST ) ),
//STRIP001 		aMtrFldHelplineDist		( this, ResId( MTR_FLD_HELPLINE_DIST ) ),
//STRIP001 		aFtHelpline1Len			( this, ResId( FT_HELPLINE1_LEN ) ),
//STRIP001 		aMtrFldHelpline1Len		( this, ResId( MTR_FLD_HELPLINE1_LEN ) ),
//STRIP001 		aFtHelpline2Len			( this, ResId( FT_HELPLINE2_LEN ) ),
//STRIP001 		aMtrFldHelpline2Len		( this, ResId( MTR_FLD_HELPLINE2_LEN ) ),
//STRIP001 		aTsbBelowRefEdge		( this, ResId( TSB_BELOW_REF_EDGE ) ),
//STRIP001 		aFtDecimalPlaces		( this, ResId( FT_DECIMALPLACES ) ),
//STRIP001 		aMtrFldDecimalPlaces	( this, ResId( MTR_FLD_DECIMALPLACES ) ),
//STRIP001 		aTsbParallel    		( this, ResId( TSB_PARALLEL ) ),
//STRIP001 		aTsbShowUnit			( this, ResId( TSB_SHOW_UNIT ) ),
//STRIP001 		aLbUnit					( this, ResId( LB_UNIT ) ),
//STRIP001 
//STRIP001 		aFlLabel    			( this, ResId( FL_LABEL ) ),
//STRIP001         aFlVert                 ( this, ResId( FL_VERT ) ),
//STRIP001 		aCtlPosition			( this, ResId( CTL_POSITION ),
//STRIP001 										RP_RM, 200, 100, CS_LINE ),
//STRIP001 		aTsbAutoPosV			( this, ResId( TSB_AUTOPOSV ) ),
//STRIP001 		aTsbAutoPosH			( this, ResId( TSB_AUTOPOSH ) ),
//STRIP001         aFtPosition             ( this, ResId( FT_POSITION ) ),
//STRIP001 		aCtlPreview				( this, ResId( CTL_PREVIEW ), rInAttrs ),
//STRIP001 		bPositionModified		( FALSE )
//STRIP001 {
//STRIP001 	FillUnitLB();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	const FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 	SetFieldUnit( aMtrFldLineDist, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldHelplineOverhang, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldHelplineDist, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldHelpline1Len, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldHelpline2Len, eFUnit );
//STRIP001 	if( eFUnit == FUNIT_MM )
//STRIP001 	{
//STRIP001 		aMtrFldLineDist.SetSpinSize( 50 );
//STRIP001 		aMtrFldHelplineOverhang.SetSpinSize( 50 );
//STRIP001 		aMtrFldHelplineDist.SetSpinSize( 50 );
//STRIP001 		aMtrFldHelpline1Len.SetSpinSize( 50 );
//STRIP001 		aMtrFldHelpline2Len.SetSpinSize( 50 );
//STRIP001 	}
//STRIP001 
//STRIP001 	aTsbAutoPosV.SetClickHdl( LINK( this, SvxMeasurePage, ClickAutoPosHdl_Impl ) );
//STRIP001 	aTsbAutoPosH.SetClickHdl( LINK( this, SvxMeasurePage, ClickAutoPosHdl_Impl ) );
//STRIP001 
//STRIP001 	// set background and border of iconchoicectrl
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	aCtlPreview.SetBackground ( rStyles.GetWindowColor() );
//STRIP001 	aCtlPreview.SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001 
//STRIP001 	Link aLink( LINK( this, SvxMeasurePage, ChangeAttrHdl_Impl ) );
//STRIP001 	aMtrFldLineDist.SetModifyHdl( aLink );
//STRIP001 	aMtrFldHelplineOverhang.SetModifyHdl( aLink );
//STRIP001 	aMtrFldHelplineDist.SetModifyHdl( aLink );
//STRIP001 	aMtrFldHelpline1Len.SetModifyHdl( aLink );
//STRIP001 	aMtrFldHelpline2Len.SetModifyHdl( aLink );
//STRIP001 	aMtrFldDecimalPlaces.SetModifyHdl( aLink );
//STRIP001 	aTsbBelowRefEdge.SetClickHdl( aLink );
//STRIP001 	aTsbParallel.SetClickHdl( aLink );
//STRIP001 	aTsbShowUnit.SetClickHdl( aLink );
//STRIP001 	aLbUnit.SetSelectHdl( aLink );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Dtor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxMeasurePage::~SvxMeasurePage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* read the delivered Item-Set
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void __EXPORT SvxMeasurePage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = rAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	eUnit = pPool->GetMetric( SDRATTR_MEASURELINEDIST );
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem = GetItem( rAttrs, SDRATTR_MEASURELINEDIST );
//STRIP001 
//STRIP001 	// SdrMeasureLineDistItem
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASURELINEDIST )) )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrMeasureLineDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldLineDist, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldLineDist.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldLineDist.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureHelplineOverhangItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_MEASUREHELPLINEOVERHANG );
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASUREHELPLINEOVERHANG )))
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrMeasureHelplineOverhangItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHelplineOverhang, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldHelplineOverhang.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldHelplineOverhang.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureHelplineDistItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_MEASUREHELPLINEDIST );
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASUREHELPLINEDIST )))
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrMeasureHelplineDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHelplineDist, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldHelplineDist.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldHelplineDist.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureHelpline1LenItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_MEASUREHELPLINE1LEN );
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASUREHELPLINE1LEN )))
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrMeasureHelpline1LenItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHelpline1Len, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldHelpline1Len.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldHelpline1Len.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureHelpline2LenItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_MEASUREHELPLINE2LEN );
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASUREHELPLINE2LEN )))
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrMeasureHelpline2LenItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHelpline2Len, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldHelpline2Len.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldHelpline2Len.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureBelowRefEdgeItem
//STRIP001 	if( rAttrs.GetItemState( SDRATTR_MEASUREBELOWREFEDGE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbBelowRefEdge.SetState( ( ( const SdrMeasureBelowRefEdgeItem& )rAttrs.Get( SDRATTR_MEASUREBELOWREFEDGE ) ).
//STRIP001 						GetValue() ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 		aTsbBelowRefEdge.EnableTriState( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbBelowRefEdge.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbBelowRefEdge.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureDecimalPlacesItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_MEASUREDECIMALPLACES );
//STRIP001 	if( pItem || (pItem = &pPool->GetDefaultItem( SDRATTR_MEASUREDECIMALPLACES )))
//STRIP001 	{
//STRIP001 		INT16 nValue = ( ( const SdrMeasureDecimalPlacesItem* )pItem )->GetValue();
//STRIP001 		aMtrFldDecimalPlaces.SetValue( nValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldDecimalPlaces.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrFldDecimalPlaces.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureTextRota90Item
//STRIP001 	// Attention: negate !
//STRIP001 	if( rAttrs.GetItemState( SDRATTR_MEASURETEXTROTA90 ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbParallel.SetState( ( ( const SdrMeasureTextRota90Item& )rAttrs.Get( SDRATTR_MEASURETEXTROTA90 ) ).
//STRIP001 						GetValue() ? STATE_NOCHECK : STATE_CHECK );
//STRIP001 		aTsbParallel.EnableTriState( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbParallel.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbParallel.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureShowUnitItem
//STRIP001 	if( rAttrs.GetItemState( SDRATTR_MEASURESHOWUNIT ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		aTsbShowUnit.SetState( ( ( const SdrMeasureShowUnitItem& )rAttrs.Get( SDRATTR_MEASURESHOWUNIT ) ).
//STRIP001 						GetValue() ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 		aTsbShowUnit.EnableTriState( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTsbShowUnit.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 	aTsbShowUnit.SaveValue();
//STRIP001 
//STRIP001 	// SdrMeasureUnitItem
//STRIP001 	if( rAttrs.GetItemState( SDRATTR_MEASUREUNIT ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		long nFieldUnit = (long) ( ( const SdrMeasureUnitItem& )rAttrs.
//STRIP001 									Get( SDRATTR_MEASUREUNIT ) ).GetValue();
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < aLbUnit.GetEntryCount(); ++i )
//STRIP001 		{
//STRIP001 			if ( (long)aLbUnit.GetEntryData( i ) == nFieldUnit )
//STRIP001 			{
//STRIP001 				aLbUnit.SelectEntryPos( i );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbUnit.SetNoSelection();
//STRIP001 	}
//STRIP001 	aLbUnit.SaveValue();
//STRIP001 
//STRIP001 	// Position
//STRIP001 	if ( rAttrs.GetItemState( SDRATTR_MEASURETEXTVPOS ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		SdrMeasureTextVPos eVPos = (SdrMeasureTextVPos)
//STRIP001 					( ( const SdrMeasureTextVPosItem& )rAttrs.Get( SDRATTR_MEASURETEXTVPOS ) ).GetValue();
//STRIP001 		{
//STRIP001 			if ( rAttrs.GetItemState( SDRATTR_MEASURETEXTHPOS ) != SFX_ITEM_DONTCARE )
//STRIP001 			{
//STRIP001 				aTsbAutoPosV.EnableTriState( FALSE );
//STRIP001 				aTsbAutoPosH.EnableTriState( FALSE );
//STRIP001 
//STRIP001 				SdrMeasureTextHPos eHPos = (SdrMeasureTextHPos)
//STRIP001 							( ( const SdrMeasureTextHPosItem& )rAttrs.Get( SDRATTR_MEASURETEXTHPOS ) ).GetValue();
//STRIP001 				RECT_POINT eRP = RP_MM;
//STRIP001 				switch( eVPos )
//STRIP001 				{
//STRIP001 				case SDRMEASURE_ABOVE:
//STRIP001 					switch( eHPos )
//STRIP001 					{
//STRIP001 					case SDRMEASURE_TEXTLEFTOUTSIDE:	eRP = RP_LT; break;
//STRIP001 					case SDRMEASURE_TEXTINSIDE:			eRP = RP_MT; break;
//STRIP001 					case SDRMEASURE_TEXTRIGHTOUTSIDE:	eRP = RP_RT; break;
//STRIP001 					case SDRMEASURE_TEXTHAUTO:			eRP = RP_MT; break;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case SDRMEASURETEXT_VERTICALCENTERED:
//STRIP001 					switch( eHPos )
//STRIP001 					{
//STRIP001 					case SDRMEASURE_TEXTLEFTOUTSIDE:	eRP = RP_LM; break;
//STRIP001 					case SDRMEASURE_TEXTINSIDE:			eRP = RP_MM; break;
//STRIP001 					case SDRMEASURE_TEXTRIGHTOUTSIDE:	eRP = RP_RM; break;
//STRIP001 					case SDRMEASURE_TEXTHAUTO:			eRP = RP_MM; break;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case SDRMEASURE_BELOW:
//STRIP001 					switch( eHPos )
//STRIP001 					{
//STRIP001 					case SDRMEASURE_TEXTLEFTOUTSIDE:	eRP = RP_LB; break;
//STRIP001 					case SDRMEASURE_TEXTINSIDE:			eRP = RP_MB; break;
//STRIP001 					case SDRMEASURE_TEXTRIGHTOUTSIDE:	eRP = RP_RB; break;
//STRIP001 					case SDRMEASURE_TEXTHAUTO:			eRP = RP_MB; break;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case SDRMEASURE_TEXTVAUTO:
//STRIP001 					switch( eHPos )
//STRIP001 					{
//STRIP001 					case SDRMEASURE_TEXTLEFTOUTSIDE:	eRP = RP_LM; break;
//STRIP001 					case SDRMEASURE_TEXTINSIDE:			eRP = RP_MM; break;
//STRIP001 					case SDRMEASURE_TEXTRIGHTOUTSIDE:	eRP = RP_RM; break;
//STRIP001 					case SDRMEASURE_TEXTHAUTO:			eRP = RP_MM; break;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				CTL_STATE nState = 0;
//STRIP001 
//STRIP001 				if( eHPos == SDRMEASURE_TEXTHAUTO )
//STRIP001 				{
//STRIP001 					aTsbAutoPosH.SetState( STATE_CHECK );
//STRIP001 					nState = CS_NOHORZ;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( eVPos == SDRMEASURE_TEXTVAUTO )
//STRIP001 				{
//STRIP001 					aTsbAutoPosV.SetState( STATE_CHECK );
//STRIP001 					nState |= CS_NOVERT;
//STRIP001 				}
//STRIP001 
//STRIP001 				aCtlPosition.SetState( nState );
//STRIP001 				aCtlPosition.SetActualRP( eRP );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aCtlPosition.Reset();
//STRIP001 		aTsbAutoPosV.SetState( STATE_DONTKNOW );
//STRIP001 		aTsbAutoPosH.SetState( STATE_DONTKNOW );
//STRIP001 	}
//STRIP001 
//STRIP001 	// put the attributes to the preview-control,
//STRIP001 	// otherwise the control don't know about
//STRIP001 	// the settings of the dialog (#67930)
//STRIP001 	ChangeAttrHdl_Impl( &aTsbShowUnit );
//STRIP001 	aCtlPreview.SetAttributes( rAttrs );
//STRIP001 
//STRIP001 	bPositionModified = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill the delivered Item-Set with dialogbox-attributes
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxMeasurePage::FillItemSet( SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	BOOL	 bModified = FALSE;
//STRIP001 	INT32	 nValue;
//STRIP001 	TriState eState;
//STRIP001 
//STRIP001 	if( aMtrFldLineDist.GetText() != aMtrFldLineDist.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldLineDist, eUnit );
//STRIP001 		rAttrs.Put( SdrMeasureLineDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldHelplineOverhang.GetText() != aMtrFldHelplineOverhang.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHelplineOverhang, eUnit );
//STRIP001 		rAttrs.Put( SdrMeasureHelplineOverhangItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldHelplineDist.GetText() != aMtrFldHelplineDist.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHelplineDist, eUnit );
//STRIP001 		rAttrs.Put( SdrMeasureHelplineDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldHelpline1Len.GetText() != aMtrFldHelpline1Len.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHelpline1Len, eUnit );
//STRIP001 		rAttrs.Put( SdrMeasureHelpline1LenItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldHelpline2Len.GetText() != aMtrFldHelpline2Len.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHelpline2Len, eUnit );
//STRIP001 		rAttrs.Put( SdrMeasureHelpline2LenItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	eState = aTsbBelowRefEdge.GetState();
//STRIP001 	if( eState != aTsbBelowRefEdge.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrMeasureBelowRefEdgeItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldDecimalPlaces.GetText() != aMtrFldDecimalPlaces.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = aMtrFldDecimalPlaces.GetValue();
//STRIP001 		rAttrs.Put( SdrMeasureDecimalPlacesItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	eState = aTsbParallel.GetState();
//STRIP001 	if( eState != aTsbParallel.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrMeasureTextRota90Item( (BOOL) STATE_NOCHECK == eState ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	eState = aTsbShowUnit.GetState();
//STRIP001 	if( eState != aTsbShowUnit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SdrMeasureShowUnitItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nPos = aLbUnit.GetSelectEntryPos();
//STRIP001 	if( nPos != aLbUnit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			USHORT nFieldUnit = (USHORT)(long)aLbUnit.GetEntryData( nPos );
//STRIP001 			FieldUnit eUnit = (FieldUnit) nFieldUnit;
//STRIP001 			rAttrs.Put( SdrMeasureUnitItem( eUnit ) );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 //enum SdrMeasureTextHPos {SDRMEASURE_TEXTHAUTO,SDRMEASURE_TEXTLEFTOUTSIDE,SDRMEASURE_TEXTINSIDE,SDRMEASURE_TEXTRIGHTOUTSIDE};
//STRIP001 //enum SdrMeasureTextVPos {SDRMEASURE_TEXTVAUTO,SDRMEASURE_ABOVE,SDRMEASURETEXT_VERTICALCENTERED,SDRMEASURE_BELOW};
//STRIP001 
//STRIP001 	if( bPositionModified )
//STRIP001 	{
//STRIP001 		// Position
//STRIP001 		SdrMeasureTextVPos eVPos, eOldVPos;
//STRIP001 		SdrMeasureTextHPos eHPos, eOldHPos;
//STRIP001 
//STRIP001 		RECT_POINT eRP = aCtlPosition.GetActualRP();
//STRIP001 		switch( eRP )
//STRIP001 		{
//STRIP001 			case RP_LT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_LM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_LB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_MT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_MM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_MB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_RT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 			case RP_RM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 			case RP_RB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 		}
//STRIP001 		if( aTsbAutoPosH.GetState() == STATE_CHECK )
//STRIP001 			eHPos = SDRMEASURE_TEXTHAUTO;
//STRIP001 
//STRIP001 		if( aTsbAutoPosV.GetState() == STATE_CHECK )
//STRIP001 			eVPos = SDRMEASURE_TEXTVAUTO;
//STRIP001 
//STRIP001 		if ( rAttrs.GetItemState( SDRATTR_MEASURETEXTVPOS ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			eOldVPos = (SdrMeasureTextVPos)
//STRIP001 						( ( const SdrMeasureTextVPosItem& )rOutAttrs.Get( SDRATTR_MEASURETEXTVPOS ) ).GetValue();
//STRIP001 			if( eOldVPos != eVPos )
//STRIP001 			{
//STRIP001 				rAttrs.Put( SdrMeasureTextVPosItem( eVPos ) );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rAttrs.Put( SdrMeasureTextVPosItem( eVPos ) );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rAttrs.GetItemState( SDRATTR_MEASURETEXTHPOS ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			eOldHPos = (SdrMeasureTextHPos)
//STRIP001 						( ( const SdrMeasureTextHPosItem& )rOutAttrs.Get( SDRATTR_MEASURETEXTHPOS ) ).GetValue();
//STRIP001 			if( eOldHPos != eHPos )
//STRIP001 			{
//STRIP001 				rAttrs.Put( SdrMeasureTextHPosItem( eHPos ) );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rAttrs.Put( SdrMeasureTextHPosItem( eHPos ) );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* The View have to set at the measure-object to be able to notify
//STRIP001 |* unit and floatingpoint-values
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxMeasurePage::Construct()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 
//STRIP001 	aCtlPreview.pMeasureObj->SetModel( pView->GetModel() );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* create the tabpage
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SfxTabPage* SvxMeasurePage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxMeasurePage( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 USHORT*	SvxMeasurePage::GetRanges()
//STRIP001 {
//STRIP001 	return( pRanges );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxMeasurePage::PointChanged( Window* pWindow, RECT_POINT eRP )
//STRIP001 {
//STRIP001 	ChangeAttrHdl_Impl( pWindow );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxMeasurePage, ClickAutoPosHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( aTsbAutoPosH.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		switch( aCtlPosition.GetActualRP() )
//STRIP001 		{
//STRIP001 			case RP_LT:
//STRIP001 			case RP_RT:
//STRIP001 				aCtlPosition.SetActualRP( RP_MT );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RP_LM:
//STRIP001 			case RP_RM:
//STRIP001 				aCtlPosition.SetActualRP( RP_MM );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RP_LB:
//STRIP001 			case RP_RB:
//STRIP001 				aCtlPosition.SetActualRP( RP_MB );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( aTsbAutoPosV.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		switch( aCtlPosition.GetActualRP() )
//STRIP001 		{
//STRIP001 			case RP_LT:
//STRIP001 			case RP_LB:
//STRIP001 				aCtlPosition.SetActualRP( RP_LM );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RP_MT:
//STRIP001 			case RP_MB:
//STRIP001 				aCtlPosition.SetActualRP( RP_MM );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RP_RT:
//STRIP001 			case RP_RB:
//STRIP001 				aCtlPosition.SetActualRP( RP_RM );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ChangeAttrHdl_Impl( p );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxMeasurePage, ChangeAttrHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 
//STRIP001 	if( p == &aMtrFldLineDist )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldLineDist, eUnit );
//STRIP001 		aAttrSet.Put( SdrMeasureLineDistItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldHelplineOverhang )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHelplineOverhang, eUnit );
//STRIP001 		aAttrSet.Put( SdrMeasureHelplineOverhangItem( nValue) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldHelplineDist )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHelplineDist, eUnit );
//STRIP001 		aAttrSet.Put( SdrMeasureHelplineDistItem( nValue) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldHelpline1Len )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHelpline1Len, eUnit );
//STRIP001 		aAttrSet.Put( SdrMeasureHelpline1LenItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldHelpline2Len )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHelpline2Len, eUnit );
//STRIP001 		aAttrSet.Put( SdrMeasureHelpline2LenItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aTsbBelowRefEdge )
//STRIP001 	{
//STRIP001 		TriState eState = aTsbBelowRefEdge.GetState();
//STRIP001 		if( eState != STATE_DONTKNOW )
//STRIP001 			aAttrSet.Put( SdrMeasureBelowRefEdgeItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldDecimalPlaces )
//STRIP001 	{
//STRIP001 		INT16 nValue = aMtrFldDecimalPlaces.GetValue();
//STRIP001 		aAttrSet.Put( SdrMeasureDecimalPlacesItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aTsbParallel )
//STRIP001 	{
//STRIP001 		TriState eState = aTsbParallel.GetState();
//STRIP001 		if( eState != STATE_DONTKNOW )
//STRIP001 			aAttrSet.Put( SdrMeasureTextRota90Item( (BOOL) !STATE_CHECK == eState ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aTsbShowUnit )
//STRIP001 	{
//STRIP001 		TriState eState = aTsbShowUnit.GetState();
//STRIP001 		if( eState != STATE_DONTKNOW )
//STRIP001 			aAttrSet.Put( SdrMeasureShowUnitItem( (BOOL) STATE_CHECK == eState ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aLbUnit )
//STRIP001 	{
//STRIP001 		USHORT nPos = aLbUnit.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			USHORT nFieldUnit = (USHORT)(long)aLbUnit.GetEntryData( nPos );
//STRIP001 			FieldUnit eUnit = (FieldUnit) nFieldUnit;
//STRIP001 			aAttrSet.Put( SdrMeasureUnitItem( eUnit ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aTsbAutoPosV || p == &aTsbAutoPosH || p == &aCtlPosition )
//STRIP001 	{
//STRIP001 		bPositionModified = TRUE;
//STRIP001 
//STRIP001 		// Position
//STRIP001 		RECT_POINT eRP = aCtlPosition.GetActualRP();
//STRIP001 		SdrMeasureTextVPos eVPos;
//STRIP001 		SdrMeasureTextHPos eHPos;
//STRIP001 
//STRIP001 		switch( eRP )
//STRIP001 		{
//STRIP001 			case RP_LT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_LM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_LB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTLEFTOUTSIDE; break;
//STRIP001 			case RP_MT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_MM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_MB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTINSIDE; break;
//STRIP001 			case RP_RT: eVPos = SDRMEASURE_ABOVE;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 			case RP_RM: eVPos = SDRMEASURETEXT_VERTICALCENTERED;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 			case RP_RB: eVPos = SDRMEASURE_BELOW;
//STRIP001 						eHPos = SDRMEASURE_TEXTRIGHTOUTSIDE; break;
//STRIP001 		}
//STRIP001 
//STRIP001 		CTL_STATE nState = 0;
//STRIP001 
//STRIP001 		if( aTsbAutoPosH.GetState() == STATE_CHECK )
//STRIP001 		{
//STRIP001 			eHPos = SDRMEASURE_TEXTHAUTO;
//STRIP001 			nState = CS_NOHORZ;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aTsbAutoPosV.GetState() == STATE_CHECK )
//STRIP001 		{
//STRIP001 			eVPos = SDRMEASURE_TEXTVAUTO;
//STRIP001 			nState |= CS_NOVERT;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( p == &aTsbAutoPosV || p == &aTsbAutoPosH )
//STRIP001 			aCtlPosition.SetState( nState );
//STRIP001 
//STRIP001 		aAttrSet.Put( SdrMeasureTextVPosItem( eVPos ) );
//STRIP001 		aAttrSet.Put( SdrMeasureTextHPosItem( eHPos ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aCtlPreview.SetAttributes( aAttrSet );
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxMeasurePage::FillUnitLB()
//STRIP001 {
//STRIP001 	// fill ListBox with metrics
//STRIP001 	SvxStringArray aMetricArr( RID_SVXSTR_FIELDUNIT_TABLE );
//STRIP001 
//STRIP001 	long nUnit = FUNIT_NONE;
//STRIP001 	String aStrMetric( ResId( STR_MEASURE_AUTOMATIC ) );
//STRIP001 	USHORT nPos = aLbUnit.InsertEntry( aStrMetric );
//STRIP001 	aLbUnit.SetEntryData( nPos, (void*)nUnit );
//STRIP001 
//STRIP001 	for( USHORT i = 0; i < aMetricArr.Count(); ++i )
//STRIP001 	{
//STRIP001 		aStrMetric = aMetricArr.GetStringByPos( i );
//STRIP001 		nUnit = aMetricArr.GetValue( i );
//STRIP001 		nPos = aLbUnit.InsertEntry( aStrMetric );
//STRIP001 		aLbUnit.SetEntryData( nPos, (void*)nUnit );
//STRIP001 	}
//STRIP001 }


}
