/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galbrws1.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:54:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <tools/datetime.hxx>
#include <unotools/datetime.hxx>
#include <vcl/msgbox.hxx>
#include <ucbhelper/content.hxx>
#include <bf_sfx2/app.hxx>
#include "helpid.hrc"
#include "gallery1.hxx"
#include "galtheme.hxx"
#include "galmisc.hxx"
#include "galdlg.hxx"
#include "galbrws1.hxx"

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

#include <algorithm>
namespace binfilter {

// --------------
// - Namespaces -
// --------------

using namespace ::ucb;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::ucb;

// -----------------
// - GalleryButton -
// -----------------

//STRIP001 GalleryButton::GalleryButton( GalleryBrowser1* pParent, WinBits nWinBits ) :
//STRIP001     PushButton( pParent, nWinBits )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryButton::~GalleryButton()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryButton::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if( !static_cast< GalleryBrowser1* >( GetParent() )->KeyInput( rKEvt, this ) )
//STRIP001         PushButton::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------
//STRIP001 // - GalleryThemeListBox -
//STRIP001 // -----------------------
//STRIP001 
//STRIP001 GalleryThemeListBox::GalleryThemeListBox( GalleryBrowser1* pParent, WinBits nWinBits ) :
//STRIP001 	ListBox( pParent, nWinBits )
//STRIP001 {
//STRIP001     InitSettings();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryThemeListBox::~GalleryThemeListBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemeListBox::InitSettings()
//STRIP001 {
//STRIP001 	SetBackground( Wallpaper( GALLERY_BG_COLOR ) );
//STRIP001 	SetControlBackground( GALLERY_BG_COLOR );
//STRIP001 	SetControlForeground( GALLERY_FG_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemeListBox::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings();
//STRIP001 	else
//STRIP001 		ListBox::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 long GalleryThemeListBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001     long nDone = 0;
//STRIP001 
//STRIP001 	if( rNEvt.GetType() == EVENT_COMMAND )
//STRIP001 	{
//STRIP001 		const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
//STRIP001 
//STRIP001 		if( pCEvt && pCEvt->GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 			static_cast< GalleryBrowser1* >( GetParent() )->ShowContextMenu();
//STRIP001 	}
//STRIP001     else if( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001     {
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001         if( pKEvt )
//STRIP001             nDone = static_cast< GalleryBrowser1* >( GetParent() )->KeyInput( *pKEvt, this );
//STRIP001     }
//STRIP001 
//STRIP001 	return( nDone ? nDone : ListBox::PreNotify( rNEvt ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryBrowser1 -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryBrowser1::GalleryBrowser1( GalleryBrowser* pParent, const ResId& rResId, Gallery* pGallery ) :
//STRIP001 	Control		( pParent, rResId ),
//STRIP001 	maNewTheme	( this, WB_3DLOOK | WB_BORDER ),
//STRIP001 	mpThemes	( new GalleryThemeListBox( this, WB_TABSTOP | WB_3DLOOK | WB_BORDER | WB_HSCROLL | WB_VSCROLL | WB_AUTOHSCROLL | WB_SORT ) ),
//STRIP001 	mpGallery	( pGallery )
//STRIP001 {
//STRIP001 	StartListening( *mpGallery );
//STRIP001 
//STRIP001 	maNewTheme.SetHelpId( HID_GALLERY_NEWTHEME );
//STRIP001 	maNewTheme.SetText( String( GAL_RESID( RID_SVXSTR_GALLERY_CREATETHEME ) ) );
//STRIP001 	maNewTheme.SetClickHdl( LINK( this, GalleryBrowser1, ClickNewThemeHdl ) );
//STRIP001 	
//STRIP001 	// disable creation of new themes if a writable directory is not available
//STRIP001 	if( mpGallery->GetUserURL().GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001 	    maNewTheme.Disable();
//STRIP001 
//STRIP001 	mpThemes->SetHelpId( HID_GALLERY_THEMELIST );
//STRIP001 	mpThemes->SetSelectHdl( LINK( this, GalleryBrowser1, SelectThemeHdl ) );
//STRIP001 
//STRIP001 	for( ULONG i = 0, nCount = mpGallery->GetThemeCount(); i < nCount; i++ )
//STRIP001 		ImplInsertThemeEntry( mpGallery->GetThemeInfo( i ) );
//STRIP001 
//STRIP001 	ImplAdjustControls();
//STRIP001 	maNewTheme.Show( TRUE );
//STRIP001 	mpThemes->Show( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryBrowser1::~GalleryBrowser1()
//STRIP001 {
//STRIP001 	EndListening( *mpGallery );
//STRIP001 	delete mpThemes;
//STRIP001 	mpThemes = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 ULONG GalleryBrowser1::ImplInsertThemeEntry( const GalleryThemeEntry* pEntry )
//STRIP001 {
//STRIP001 	static const BOOL bShowHiddenThemes = ( getenv( "GALLERY_SHOW_HIDDEN_THEMES" ) != NULL );
//STRIP001 
//STRIP001 	ULONG nRet = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 
//STRIP001 	if( pEntry && ( !pEntry->IsHidden() || bShowHiddenThemes ) )
//STRIP001 	{
//STRIP001 		Bitmap aBMP( GAL_RESID( RID_SVXBMP_THEME_NORMAL ) );
//STRIP001 		static const Image aImgNormal( BitmapEx( aBMP, COL_LIGHTMAGENTA ) );
//STRIP001 		aBMP = Bitmap( GAL_RESID( RID_SVXBMP_THEME_DEFAULT ) );
//STRIP001 		static const Image aImgDefault( BitmapEx( aBMP, COL_LIGHTMAGENTA ) );
//STRIP001 		aBMP = Bitmap( GAL_RESID( RID_SVXBMP_THEME_READONLY ) );
//STRIP001 		static const Image aImgReadOnly( BitmapEx( aBMP, COL_LIGHTMAGENTA ) );
//STRIP001 		aBMP = Bitmap( GAL_RESID( RID_SVXBMP_THEME_IMPORTED ) );
//STRIP001 		static const Image aImgImported( BitmapEx( aBMP, COL_LIGHTMAGENTA ) );
//STRIP001 
//STRIP001 		const Image* pImage;
//STRIP001 
//STRIP001 		if( pEntry->IsImported() )
//STRIP001 			pImage = &aImgImported;
//STRIP001 		else if( pEntry->IsReadOnly() )
//STRIP001 			pImage = &aImgReadOnly;
//STRIP001 		else if( pEntry->IsDefault() )
//STRIP001 			pImage = &aImgDefault;
//STRIP001 		else
//STRIP001 			pImage = &aImgNormal;
//STRIP001 
//STRIP001 		nRet = mpThemes->InsertEntry( pEntry->GetThemeName(), *pImage );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::ImplAdjustControls()
//STRIP001 {
//STRIP001 	const Size	aOutSize( GetOutputSizePixel() );
//STRIP001 	const long	nNewThemeHeight = LogicToPixel( Size( 0, 14 ), MAP_APPFONT ).Height();
//STRIP001     const long  nStartY = nNewThemeHeight + 4;
//STRIP001 
//STRIP001 	maNewTheme.SetPosSizePixel( Point(), 
//STRIP001 								Size( aOutSize.Width(), nNewThemeHeight ) );
//STRIP001 	
//STRIP001 	mpThemes->SetPosSizePixel( Point( 0, nStartY ), 
//STRIP001 							   Size( aOutSize.Width(), aOutSize.Height() - nStartY ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::ImplFillExchangeData( const GalleryTheme* pThm, ExchangeData& rData )
//STRIP001 {
//STRIP001 	rData.pTheme = (GalleryTheme*) pThm;
//STRIP001 	rData.aEditedTitle = pThm->GetName();
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content			aCnt( pThm->GetThmURL().GetMainURL( INetURLObject::NO_DECODE ), uno::Reference< XCommandEnvironment >() );
//STRIP001 		util::DateTime	aDateTimeModified;
//STRIP001 		DateTime		aDateTime;
//STRIP001 
//STRIP001 		aCnt.getPropertyValue( OUString::createFromAscii( "DateModified" ) ) >>= aDateTimeModified;
//STRIP001 		::utl::typeConvert( aDateTimeModified, aDateTime );
//STRIP001 		rData.aThemeChangeDate = aDateTime;
//STRIP001 		rData.aThemeChangeTime = aDateTime;
//STRIP001 	}
//STRIP001 	catch( const ContentCreationException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 ::std::vector< USHORT > GalleryBrowser1::ImplGetExecuteVector()
//STRIP001 {
//STRIP001     ::std::vector< USHORT > aExecVector;
//STRIP001 	GalleryTheme*           pTheme = mpGallery->AcquireTheme( GetSelectedTheme(), *this );
//STRIP001 
//STRIP001 	if( pTheme )
//STRIP001 	{
//STRIP001 		BOOL                bUpdateAllowed, bRenameAllowed, bRemoveAllowed;
//STRIP001 		static const BOOL	bIdDialog = ( getenv( "GALLERY_ENABLE_ID_DIALOG" ) != NULL );
//STRIP001 
//STRIP001 		if( pTheme->IsReadOnly() )
//STRIP001 			bUpdateAllowed = bRenameAllowed = bRemoveAllowed = FALSE;
//STRIP001 		else if( pTheme->IsImported() )
//STRIP001 		{
//STRIP001 			bUpdateAllowed = FALSE;
//STRIP001 			bRenameAllowed = bRemoveAllowed = TRUE;
//STRIP001 		}
//STRIP001 		else if( pTheme->IsDefault() )
//STRIP001 		{
//STRIP001 			bUpdateAllowed = bRenameAllowed = TRUE;
//STRIP001 			bRemoveAllowed = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bUpdateAllowed = bRenameAllowed = bRemoveAllowed = TRUE;
//STRIP001 
//STRIP001         if( bUpdateAllowed && pTheme->GetObjectCount() )
//STRIP001             aExecVector.push_back( MN_ACTUALIZE );
//STRIP001 
//STRIP001         if( bRenameAllowed )
//STRIP001             aExecVector.push_back( MN_RENAME );
//STRIP001 
//STRIP001         if( bRemoveAllowed )
//STRIP001             aExecVector.push_back( MN_DELETE );
//STRIP001 
//STRIP001         if( bIdDialog && !pTheme->IsReadOnly() && !pTheme->IsImported() )
//STRIP001             aExecVector.push_back( MN_ASSIGN_ID );
//STRIP001 
//STRIP001         aExecVector.push_back( MN_PROPERTIES );
//STRIP001 		
//STRIP001 		mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001     }
//STRIP001 
//STRIP001     return aExecVector;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::ImplExecute( USHORT nId )
//STRIP001 {
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case( MN_ACTUALIZE ):
//STRIP001 		{
//STRIP001 			GalleryTheme*		pTheme = mpGallery->AcquireTheme( GetSelectedTheme(), *this );
//STRIP001 			ActualizeProgress	aActualizeProgress( this, pTheme );
//STRIP001 
//STRIP001 			aActualizeProgress.Update();
//STRIP001 			aActualizeProgress.Execute();
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( MN_DELETE  ):
//STRIP001 		{
//STRIP001 			if( QueryBox( NULL, WB_YES_NO, String( GAL_RESID( RID_SVXSTR_GALLERY_DELETETHEME ) ) ).Execute() == RET_YES )
//STRIP001 				mpGallery->RemoveTheme( mpThemes->GetSelectEntry() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( MN_RENAME ):
//STRIP001 		{
//STRIP001 			GalleryTheme*	pTheme = mpGallery->AcquireTheme( GetSelectedTheme(), *this );
//STRIP001 			const String	aOldName( pTheme->GetName() );
//STRIP001 			TitleDialog		aDlg( this, aOldName );
//STRIP001 
//STRIP001 			if( aDlg.Execute() == RET_OK )
//STRIP001 			{	
//STRIP001 				const String aNewName( aDlg.GetTitle() );
//STRIP001 
//STRIP001 				if( aNewName.Len() && ( aNewName != aOldName ) )
//STRIP001 				{
//STRIP001 					String	aName( aNewName );
//STRIP001 					USHORT	nCount = 0;
//STRIP001 					
//STRIP001 					while( mpGallery->HasTheme( aName ) && ( nCount++ < 16000 ) )
//STRIP001 					{
//STRIP001 						aName = aNewName;
//STRIP001 						aName += ' ';
//STRIP001 						aName += String::CreateFromInt32( nCount );
//STRIP001 					}
//STRIP001 
//STRIP001 					mpGallery->RenameTheme( aOldName, aName );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( MN_ASSIGN_ID ):
//STRIP001 		{
//STRIP001 			GalleryTheme* pTheme = mpGallery->AcquireTheme( GetSelectedTheme(), *this );
//STRIP001 
//STRIP001 			if( pTheme && !pTheme->IsReadOnly() && !pTheme->IsImported() )
//STRIP001 			{
//STRIP001 				GalleryIdDialog aDlg( this, pTheme );
//STRIP001 
//STRIP001 				if( aDlg.Execute() == RET_OK )
//STRIP001 					pTheme->SetId( aDlg.GetId(), TRUE );
//STRIP001 			}
//STRIP001 
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( MN_PROPERTIES ):
//STRIP001 		{
//STRIP001 			SfxItemSet				aSet( SFX_APP()->GetPool() );
//STRIP001 			GalleryTheme*			pTheme = mpGallery->AcquireTheme( GetSelectedTheme(), *this );
//STRIP001 			ExchangeData			aData; ImplFillExchangeData( pTheme, aData );
//STRIP001 			GalleryThemeProperties	aThemeProps( NULL, &aData, &aSet );
//STRIP001 
//STRIP001 			if( RET_OK == aThemeProps.Execute() )
//STRIP001 			{
//STRIP001 				String aName( pTheme->GetName() );
//STRIP001 				
//STRIP001 				if( aData.aEditedTitle.Len() && aName != aData.aEditedTitle )
//STRIP001 				{
//STRIP001 					const String	aOldName( aName );
//STRIP001 					String			aName( aData.aEditedTitle );
//STRIP001 					USHORT			nCount = 0;
//STRIP001 					
//STRIP001 					while( mpGallery->HasTheme( aName ) && ( nCount++ < 16000 ) )
//STRIP001 					{
//STRIP001 						aName = aData.aEditedTitle;
//STRIP001 						aName += ' ';
//STRIP001 						aName += String::CreateFromInt32( nCount );
//STRIP001 					}
//STRIP001 
//STRIP001 					mpGallery->RenameTheme( aOldName, aName );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::Resize()
//STRIP001 {
//STRIP001 	Control::Resize();
//STRIP001 	ImplAdjustControls();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::GetFocus()
//STRIP001 {
//STRIP001 	Control::GetFocus();
//STRIP001 	if( mpThemes )
//STRIP001 		mpThemes->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	const GalleryHint& rGalleryHint = (const GalleryHint&) rHint;
//STRIP001 
//STRIP001 	switch( rGalleryHint.GetType() )
//STRIP001 	{
//STRIP001 		case( GALLERY_HINT_THEME_CREATED ):
//STRIP001 			ImplInsertThemeEntry( mpGallery->GetThemeInfo( rGalleryHint.GetThemeName() ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( GALLERY_HINT_THEME_RENAMED ):
//STRIP001 		{
//STRIP001 			const USHORT nCurSelectPos = mpThemes->GetSelectEntryPos();
//STRIP001 			const USHORT nRenameEntryPos = mpThemes->GetEntryPos( rGalleryHint.GetThemeName() );
//STRIP001 
//STRIP001 			mpThemes->RemoveEntry( rGalleryHint.GetThemeName() );
//STRIP001 			ImplInsertThemeEntry( mpGallery->GetThemeInfo( rGalleryHint.GetStringData() ) );
//STRIP001 
//STRIP001 			if( nCurSelectPos == nRenameEntryPos )
//STRIP001 			{
//STRIP001 				mpThemes->SelectEntry( rGalleryHint.GetStringData() );
//STRIP001 				SelectThemeHdl( NULL );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( GALLERY_HINT_THEME_REMOVED ):
//STRIP001 		{
//STRIP001 			mpThemes->RemoveEntry( rGalleryHint.GetThemeName() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( GALLERY_HINT_CLOSE_THEME ):
//STRIP001 		{
//STRIP001 			const USHORT nCurSelectPos = mpThemes->GetSelectEntryPos();
//STRIP001 			const USHORT nCloseEntryPos = mpThemes->GetEntryPos( rGalleryHint.GetThemeName() );
//STRIP001 
//STRIP001 			if( nCurSelectPos == nCloseEntryPos )
//STRIP001 			{
//STRIP001 				if( nCurSelectPos < ( mpThemes->GetEntryCount() - 1 ) )
//STRIP001 					mpThemes->SelectEntryPos( nCurSelectPos + 1 );
//STRIP001 				else if( nCurSelectPos )
//STRIP001 					mpThemes->SelectEntryPos( nCurSelectPos - 1 );
//STRIP001 				else
//STRIP001 					mpThemes->SetNoSelection();
//STRIP001 
//STRIP001 				SelectThemeHdl( NULL );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser1::ShowContextMenu()
//STRIP001 {
//STRIP001 	Application::PostUserEvent( LINK( this, GalleryBrowser1, ShowContextMenuHdl ), this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryBrowser1::KeyInput( const KeyEvent& rKEvt, Window* pWindow )
//STRIP001 {
//STRIP001     BOOL bRet = static_cast< GalleryBrowser* >( GetParent() )->KeyInput( rKEvt, pWindow );
//STRIP001 
//STRIP001     if( !bRet )
//STRIP001     {
//STRIP001         ::std::vector< USHORT > aExecVector( ImplGetExecuteVector() );
//STRIP001         USHORT                  nExecuteId = 0;
//STRIP001         BOOL                    bMod1 = rKEvt.GetKeyCode().IsMod1();
//STRIP001 
//STRIP001         switch( rKEvt.GetKeyCode().GetCode() )
//STRIP001         {
//STRIP001             case( KEY_INSERT ):
//STRIP001                 ClickNewThemeHdl( NULL );
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_I ):
//STRIP001             {
//STRIP001                 if( bMod1 )
//STRIP001                    ClickNewThemeHdl( NULL );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_U ): 
//STRIP001             {
//STRIP001                 if( bMod1 )
//STRIP001                     nExecuteId = MN_ACTUALIZE;
//STRIP001             }
//STRIP001             break;
//STRIP001         
//STRIP001             case( KEY_DELETE ):
//STRIP001                 nExecuteId = MN_DELETE; 
//STRIP001             break;
//STRIP001             
//STRIP001             case( KEY_D ):
//STRIP001             {
//STRIP001                 if( bMod1 )
//STRIP001                     nExecuteId = MN_DELETE;
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_R ):
//STRIP001             {
//STRIP001                 if( bMod1 )
//STRIP001                     nExecuteId = MN_RENAME; 
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_RETURN ):
//STRIP001             {
//STRIP001                 if( bMod1 )
//STRIP001                     nExecuteId = MN_PROPERTIES; 
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         if( nExecuteId && ( ::std::find( aExecVector.begin(), aExecVector.end(), nExecuteId ) != aExecVector.end() ) )
//STRIP001         {
//STRIP001             ImplExecute( nExecuteId );
//STRIP001             bRet = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser1, ShowContextMenuHdl, void*, p )
//STRIP001 {
//STRIP001     ::std::vector< USHORT > aExecVector( ImplGetExecuteVector() );
//STRIP001 
//STRIP001     if( aExecVector.size() )
//STRIP001     {
//STRIP001 		PopupMenu aMenu( GAL_RESID( RID_SVXMN_GALLERY1 ) );
//STRIP001 
//STRIP001 		aMenu.EnableItem( MN_ACTUALIZE, ::std::find( aExecVector.begin(), aExecVector.end(), MN_ACTUALIZE ) != aExecVector.end() );
//STRIP001 		aMenu.EnableItem( MN_RENAME, ::std::find( aExecVector.begin(), aExecVector.end(), MN_RENAME ) != aExecVector.end() );
//STRIP001 		aMenu.EnableItem( MN_DELETE, ::std::find( aExecVector.begin(), aExecVector.end(), MN_DELETE ) != aExecVector.end() );
//STRIP001 		aMenu.EnableItem( MN_ASSIGN_ID, ::std::find( aExecVector.begin(), aExecVector.end(), MN_ASSIGN_ID ) != aExecVector.end() );
//STRIP001 		aMenu.EnableItem( MN_PROPERTIES, ::std::find( aExecVector.begin(), aExecVector.end(), MN_PROPERTIES ) != aExecVector.end() );
//STRIP001 		aMenu.SetSelectHdl( LINK( this, GalleryBrowser1, PopupMenuHdl ) );
//STRIP001 		aMenu.RemoveDisabledEntries();
//STRIP001 
//STRIP001 		const Rectangle aThemesRect( mpThemes->GetPosPixel(), mpThemes->GetOutputSizePixel() );
//STRIP001 		Point			aSelPos( mpThemes->GetBoundingRectangle( mpThemes->GetSelectEntryPos() ).Center() );
//STRIP001 
//STRIP001 		aSelPos.X() = Max( Min( aSelPos.X(), aThemesRect.Right() ), aThemesRect.Left() );
//STRIP001 		aSelPos.Y() = Max( Min( aSelPos.Y(), aThemesRect.Bottom() ), aThemesRect.Top() );
//STRIP001 		
//STRIP001 		aMenu.Execute( this, aSelPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser1, PopupMenuHdl, Menu*, pMenu )
//STRIP001 {
//STRIP001     ImplExecute( pMenu->GetCurItemId() );
//STRIP001     return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser1, SelectThemeHdl, void*, p )
//STRIP001 {
//STRIP001 	( (GalleryBrowser*) GetParent() )->ThemeSelectionHasChanged();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser1, ClickNewThemeHdl, void*, p )
//STRIP001 {
//STRIP001 	String	aNewTheme( GAL_RESID( RID_SVXSTR_GALLERY_NEWTHEME ) );
//STRIP001 	String	aName( aNewTheme );
//STRIP001 	ULONG	nCount = 0;
//STRIP001 
//STRIP001 	while( mpGallery->HasTheme( aName ) && ( nCount++ < 16000 ) )
//STRIP001 	{
//STRIP001 		aName = aNewTheme;
//STRIP001 		aName += ' ';
//STRIP001 		aName += String::CreateFromInt32( nCount );
//STRIP001 	}
//STRIP001 	
//STRIP001 	if( !mpGallery->HasTheme( aName ) && mpGallery->CreateTheme( aName ) )
//STRIP001 	{
//STRIP001 		GalleryTheme*			pTheme = mpGallery->AcquireTheme( aName, *this );
//STRIP001 		SfxItemSet				aSet( SFX_APP()->GetPool() );
//STRIP001 		ExchangeData			aData; ImplFillExchangeData( pTheme, aData );
//STRIP001 		GalleryThemeProperties	aThemeProps( NULL, &aData, &aSet );
//STRIP001 
//STRIP001 		if( RET_OK == aThemeProps.Execute() )
//STRIP001 		{
//STRIP001 			String aName( pTheme->GetName() );
//STRIP001 			
//STRIP001 			if( aData.aEditedTitle.Len() && ( aName != aData.aEditedTitle ) )
//STRIP001 			{
//STRIP001 				const String	aOldName( aName );
//STRIP001 				String			aName( aData.aEditedTitle );
//STRIP001 				USHORT			nCount = 0;
//STRIP001 				
//STRIP001 				while( mpGallery->HasTheme( aName ) && ( nCount++ < 16000 ) )
//STRIP001 				{
//STRIP001 					aName = aData.aEditedTitle;
//STRIP001 					aName += ' ';
//STRIP001 					aName += String::CreateFromInt32( nCount );
//STRIP001 				}
//STRIP001 
//STRIP001 				mpGallery->RenameTheme( aOldName, aName );
//STRIP001 			}
//STRIP001 
//STRIP001 			mpThemes->SelectEntry( pTheme->GetName() );
//STRIP001 			SelectThemeHdl( NULL );
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			mpGallery->ReleaseTheme( pTheme, *this );
//STRIP001 			mpGallery->RemoveTheme( aName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	
//STRIP001 	return 0L;
//STRIP001 }
}
