/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galmisc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:56:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <unotools/streamwrap.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <unotools/processfactory.hxx>
#include <ucbhelper/content.hxx>
#include <tools/resmgr.hxx>
#include <tools/intn.hxx>
#include <tools/urlobj.hxx>
#include <svtools/solar.hrc>
#include <svtools/urihelper.hxx>
#include <svtools/filter.hxx>
#include <svtools/itempool.hxx>
#include <bf_sfx2/docfile.hxx>
#include "impgrf.hxx"
#include "svdpage.hxx"
#include "svdograf.hxx"
#include "fmmodel.hxx"
#include "fmview.hxx"
#include "unomodel.hxx"
#include "codec.hxx"
#include "gallery.hrc"
#include "gallery1.hxx"
#include "galtheme.hxx"
#include "galmisc.hxx"

#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_NAMECLASH_HPP_
#include <com/sun/star/ucb/NameClash.hpp>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

// --------------
// - Namespaces -
// --------------

using namespace ::ucb;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::ucb;

// ----------
// - ResMgr -
// ----------

//STRIP001 ResMgr* GetGalleryResMgr()
//STRIP001 {
//STRIP001 	static ResMgr* pGalleryResMgr = NULL;
//STRIP001 
//STRIP001 	if( !pGalleryResMgr )
//STRIP001 	{
//STRIP001 		ByteString aResMgrName( "gal" );
//STRIP001 		aResMgrName += ByteString::CreateFromInt32( SOLARUPD );
//STRIP001 		pGalleryResMgr = ResMgr::CreateResMgr(
//STRIP001 			aResMgrName.GetBuffer(), Application::GetSettings().GetUILanguage() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return pGalleryResMgr;
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------
//STRIP001 // - SgaUserDataFactory -
//STRIP001 // ----------------------
//STRIP001 
//STRIP001 IMPL_LINK( SgaUserDataFactory, MakeUserData, SdrObjFactory*, pObjFactory )
//STRIP001 {
//STRIP001 	if ( pObjFactory->nInventor == IV_IMAPINFO && pObjFactory->nIdentifier == ID_IMAPINFO )
//STRIP001 		pObjFactory->pNewData = new SgaIMapInfo;
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------
//STRIP001 // - GalleryGraphicImport -
//STRIP001 // ------------------------
//STRIP001 
//STRIP001 USHORT GalleryGraphicImport( const INetURLObject& rURL, Graphic& rGraphic,
//STRIP001 				             String& rFilterName, BOOL bShowProgress )
//STRIP001 {
//STRIP001 	USHORT		nRet = SGA_IMPORT_NONE;
//STRIP001 	SfxMedium	aMedium( rURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ, TRUE );
//STRIP001 	String		aFilterName;
//STRIP001 
//STRIP001 	aMedium.SetTransferPriority( SFX_TFPRIO_VISIBLE_HIGHRES_GRAPHIC | SFX_TFPRIO_SYNCHRON );
//STRIP001 	aMedium.DownLoad();
//STRIP001 
//STRIP001 	SvStream* pIStm = aMedium.GetInStream();
//STRIP001 
//STRIP001 	if( pIStm )
//STRIP001 	{
//STRIP001 		GraphicFilter*		pGraphicFilter = GetGrfFilter();
//STRIP001 		GalleryProgress*	pProgress = bShowProgress ? new GalleryProgress( pGraphicFilter ) : NULL;
//STRIP001 		USHORT				nFormat;
//STRIP001 
//STRIP001 		if( !pGraphicFilter->ImportGraphic( rGraphic, rURL.GetMainURL( INetURLObject::NO_DECODE ), *pIStm, GRFILTER_FORMAT_DONTKNOW, &nFormat ) )
//STRIP001 		{
//STRIP001 			rFilterName = pGraphicFilter->GetImportFormatName( nFormat );
//STRIP001 			nRet = SGA_IMPORT_FILE;
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pProgress;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------
//STRIP001 // - GallerySvDrawImport -
//STRIP001 // -----------------------
//STRIP001 
//STRIP001 BOOL GallerySvDrawImport( SvStream& rIStm, FmFormModel& rModel )
//STRIP001 {
//STRIP001 	UINT32  nVersion;
//STRIP001     BOOL    bRet;
//STRIP001 
//STRIP001 	if( GalleryCodec::IsCoded( rIStm, nVersion ) )
//STRIP001 	{
//STRIP001 		SvMemoryStream	aMemStm( 65535, 65535 );
//STRIP001 		GalleryCodec	aCodec( rIStm );
//STRIP001 
//STRIP001 		aCodec.Read( aMemStm );
//STRIP001 		aMemStm.Seek( 0UL );
//STRIP001 
//STRIP001         if( 1 == nVersion )
//STRIP001         {
//STRIP001             // read as binary
//STRIP001        		SgaUserDataFactory	aFactory;
//STRIP001 
//STRIP001 		    aMemStm.SetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 		    rModel.SetStreamingSdrModel( TRUE );
//STRIP001 		    rModel.GetItemPool().Load( aMemStm );
//STRIP001 		    aMemStm >> rModel;
//STRIP001     		rModel.SetStreamingSdrModel( FALSE );
//STRIP001 		    rModel.GetItemPool().LoadCompleted();
//STRIP001 		    bRet = ( rIStm.GetError() == 0 );
//STRIP001         }
//STRIP001         else if( 2 == nVersion )
//STRIP001         {
//STRIP001             // recall to read as XML
//STRIP001             bRet = GallerySvDrawImport( aMemStm, rModel );
//STRIP001         }
//STRIP001  	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         // read as XML 
//STRIP001     	uno::Reference< io::XInputStream > xInputStream( new utl::OInputStreamWrapper( rIStm ) );
//STRIP001 
//STRIP001 		rModel.GetItemPool().SetDefaultMetric( SFX_MAPUNIT_100TH_MM );
//STRIP001 		rModel.SetStreamingSdrModel( TRUE );
//STRIP001         bRet = SvxDrawingLayerImport( &rModel, xInputStream );
//STRIP001 		rModel.SetStreamingSdrModel( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------
//STRIP001 // - GalleryIsSoundFile -
//STRIP001 // ----------------------
//STRIP001 
//STRIP001 BOOL GalleryIsSoundFile( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	const String	aExt( rURL.getExtension().ToLowerAscii() );
//STRIP001 	BOOL			bRet = FALSE;
//STRIP001 
//STRIP001 	if( ( aExt == String( RTL_CONSTASCII_USTRINGPARAM( "wav" ) ) ) ||
//STRIP001 		( aExt == String( RTL_CONSTASCII_USTRINGPARAM( "aif" ) ) ) ||
//STRIP001 		( aExt == String( RTL_CONSTASCII_USTRINGPARAM( "au" ) ) ) )
//STRIP001 	{
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( rURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			BYTE cVal1, cVal2, cVal3, cVal4;
//STRIP001 
//STRIP001 			*pIStm >> cVal1 >> cVal2 >> cVal3 >> cVal4;
//STRIP001 
//STRIP001 			if ( ( cVal1 == 'R' && cVal2 == 'I' && cVal3 == 'F' && cVal4 == 'F' ) ||
//STRIP001 				 ( cVal1 == '.' && cVal2 == 's' && cVal3 == 'n' && cVal4 == 'd' ) )
//STRIP001 			{
//STRIP001 				bRet = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------
//STRIP001 // - CreateIMapGraphic -
//STRIP001 // ---------------------
//STRIP001 
//STRIP001 BOOL CreateIMapGraphic( const FmFormModel& rModel, Graphic& rGraphic, ImageMap& rImageMap )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if ( rModel.GetPageCount() )
//STRIP001 	{
//STRIP001 		const SdrPage*		pPage = rModel.GetPage( 0 );
//STRIP001 		const SdrObject*	pObj = pPage->GetObj( 0 );
//STRIP001 
//STRIP001 		if ( pPage->GetObjCount() == 1 && pObj->ISA( SdrGrafObj ) )
//STRIP001 		{
//STRIP001 			const USHORT nCount = pObj->GetUserDataCount();
//STRIP001 
//STRIP001 			// gibt es in den User-Daten eine IMap-Information?
//STRIP001 			for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 			{
//STRIP001 				const SdrObjUserData* pUserData = pObj->GetUserData( i );
//STRIP001 
//STRIP001 				if ( ( pUserData->GetInventor() == IV_IMAPINFO ) && ( pUserData->GetId() == ID_IMAPINFO ) )
//STRIP001 				{
//STRIP001 					rGraphic = ( (SdrGrafObj*) pObj )->GetGraphic();
//STRIP001 					rImageMap = ( (SgaIMapInfo*) pUserData )->GetImageMap();
//STRIP001 					bRet = TRUE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // --------------------
//STRIP001 // - GetReducedString -
//STRIP001 // --------------------
//STRIP001 
//STRIP001 String GetReducedString( const INetURLObject& rURL, ULONG nMaxLen )
//STRIP001 {
//STRIP001     String aReduced( rURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 
//STRIP001     aReduced = aReduced.GetToken( aReduced.GetTokenCount( '/' ) - 1, '/' );
//STRIP001 
//STRIP001     if( INET_PROT_PRIV_SOFFICE != rURL.GetProtocol() )
//STRIP001     {
//STRIP001         sal_Unicode     aDelimiter;
//STRIP001    	    const String    aPath( rURL.getFSysPath( INetURLObject::FSYS_DETECT, &aDelimiter ) );
//STRIP001         const String    aName( aReduced );
//STRIP001     
//STRIP001         if( aPath.Len() > nMaxLen )
//STRIP001         {
//STRIP001             aReduced = aPath.Copy( 0, (USHORT)( nMaxLen - aName.Len() - 4 ) );
//STRIP001     	    aReduced += String( RTL_CONSTASCII_USTRINGPARAM( "..." ) );
//STRIP001             aReduced += aDelimiter;
//STRIP001 		    aReduced += aName;
//STRIP001         }
//STRIP001         else
//STRIP001             aReduced = aPath;
//STRIP001     }
//STRIP001 
//STRIP001     return aReduced;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 String GetSvDrawStreamNameFromURL( const INetURLObject& rSvDrawObjURL )
//STRIP001 {
//STRIP001 	String aRet;
//STRIP001 
//STRIP001 	if( rSvDrawObjURL.GetProtocol() == INET_PROT_PRIV_SOFFICE &&
//STRIP001 		rSvDrawObjURL.GetMainURL( INetURLObject::NO_DECODE ).GetTokenCount( '/' ) == 3 )
//STRIP001 	{
//STRIP001 		aRet = rSvDrawObjURL.GetMainURL( INetURLObject::NO_DECODE ).GetToken( 2, '/' );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL FileExists( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			Content		aCnt( rURL.GetMainURL( INetURLObject::NO_DECODE ), uno::Reference< XCommandEnvironment >() );
//STRIP001 			OUString	aTitle;
//STRIP001 
//STRIP001 			aCnt.getPropertyValue( OUString::createFromAscii( "Title" ) ) >>= aTitle;
//STRIP001 			bRet = ( aTitle.getLength() > 0 );
//STRIP001 		}
//STRIP001 		catch( const ContentCreationException& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 		catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 	    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL CreateDir( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	BOOL bRet = FileExists( rURL );
//STRIP001 
//STRIP001 	if( !bRet )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			uno::Reference< XCommandEnvironment >	aCmdEnv;
//STRIP001 			INetURLObject							aNewFolderURL( rURL );
//STRIP001 			INetURLObject							aParentURL( aNewFolderURL ); aParentURL.removeSegment();
//STRIP001 			Content									aParent( aParentURL.GetMainURL( INetURLObject::NO_DECODE ), aCmdEnv );
//STRIP001 			uno::Sequence< OUString >				aProps( 1 );
//STRIP001 			uno::Sequence< uno::Any >				aValues( 1 );
//STRIP001 			
//STRIP001 			aProps.getArray()[ 0 ] = OUString::createFromAscii( "Title" );
//STRIP001 			aValues.getArray()[ 0 ] = uno::makeAny( OUString( aNewFolderURL.GetName() ) );
//STRIP001 
//STRIP001         Content aContent( aNewFolderURL.GetMainURL( INetURLObject::NO_DECODE ), aCmdEnv );
//STRIP001         bRet = aParent.insertNewContent( OUString::createFromAscii( "application/vnd.sun.staroffice.fsys-folder" ), aProps, aValues, aContent );
//STRIP001 		}
//STRIP001 		catch( const ContentCreationException& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 		catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 	    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL CopyFile(  const INetURLObject& rSrcURL, const INetURLObject& rDstURL )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aDestPath( rDstURL.GetMainURL( INetURLObject::NO_DECODE ), uno::Reference< XCommandEnvironment >() );
//STRIP001 		
//STRIP001 		aDestPath.executeCommand( OUString::createFromAscii( "transfer" ),
//STRIP001 								  uno::makeAny( TransferInfo( sal_False, rSrcURL.GetMainURL( INetURLObject::NO_DECODE ), 
//STRIP001 												rDstURL.GetName(), NameClash::OVERWRITE ) ) );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	catch( const ContentCreationException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL KillFile( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	BOOL bRet = FileExists( rURL );
//STRIP001 
//STRIP001 	if( bRet )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			Content aCnt( rURL.GetMainURL( INetURLObject::NO_DECODE ), uno::Reference< XCommandEnvironment >() );
//STRIP001 			aCnt.executeCommand( OUString::createFromAscii( "delete" ), uno::makeAny( sal_Bool( sal_True ) ) );
//STRIP001 		}
//STRIP001 		catch( const ContentCreationException& )
//STRIP001 		{
//STRIP001 			bRet = FALSE;
//STRIP001 		}
//STRIP001 		catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 		{
//STRIP001 			bRet = FALSE;
//STRIP001 		}
//STRIP001 	    catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	    {
//STRIP001             bRet = FALSE;
//STRIP001 	    }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryProgress -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryProgress::GalleryProgress( GraphicFilter* pFilter ) :
//STRIP001 	mpFilter( pFilter )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 
//STRIP001 	if( xMgr.is() )
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::awt::XProgressMonitor >	xMonitor( xMgr->createInstance( 
//STRIP001 													  ::rtl::OUString::createFromAscii( "com.sun.star.awt.XProgressMonitor" ) ),
//STRIP001 													  ::com::sun::star::uno::UNO_QUERY );
//STRIP001 
//STRIP001 		if ( xMonitor.is() )
//STRIP001 		{
//STRIP001 			mxProgressBar = ::com::sun::star::uno::Reference< ::com::sun::star::awt::XProgressBar >( xMonitor, 
//STRIP001 																									 ::com::sun::star::uno::UNO_QUERY );
//STRIP001 
//STRIP001 			if( mxProgressBar.is() )
//STRIP001 			{
//STRIP001 				String aProgressText;
//STRIP001 
//STRIP001 				if( mpFilter )
//STRIP001 				{
//STRIP001 					aProgressText = String( GAL_RESID( RID_SVXSTR_GALLERY_FILTER ) );
//STRIP001 					mpFilter->SetUpdatePercentHdl( LINK( this, GalleryProgress, Update ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aProgressText = String( RTL_CONSTASCII_USTRINGPARAM( "Gallery" ) );
//STRIP001 
//STRIP001 				xMonitor->addText( String( RTL_CONSTASCII_USTRINGPARAM( "Gallery" ) ), aProgressText, sal_False ) ;
//STRIP001 				mxProgressBar->setRange( 0, GALLERY_PROGRESS_RANGE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryProgress::~GalleryProgress()
//STRIP001 {
//STRIP001 	if( mpFilter )
//STRIP001 		mpFilter->SetUpdatePercentHdl( Link() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryProgress::Update( ULONG nVal, ULONG nMaxVal )
//STRIP001 {
//STRIP001 	if( mxProgressBar.is() && nMaxVal )
//STRIP001 		mxProgressBar->setValue( Min( (ULONG)( (double) nVal / nMaxVal * GALLERY_PROGRESS_RANGE ), (ULONG) GALLERY_PROGRESS_RANGE ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryProgress, Update, GraphicFilter*, pFilter )
//STRIP001 {
//STRIP001 	Update( pFilter->GetPercent(), 100 );
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------
//STRIP001 // - GalleryTransferable -
//STRIP001 // -----------------------
//STRIP001 
//STRIP001 GalleryTransferable::GalleryTransferable( GalleryTheme* pTheme, ULONG nObjectPos ) :
//STRIP001 	mpTheme( pTheme ),
//STRIP001 	meObjectKind( mpTheme->GetObjectKind( nObjectPos ) ),
//STRIP001 	mnObjectPos( nObjectPos ),
//STRIP001 	mpGraphicObject( NULL ),
//STRIP001 	mpImageMap( NULL ),
//STRIP001 	mpURL( NULL ),
//STRIP001 	mbInitialized( sal_False )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryTransferable::~GalleryTransferable()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::InitData()
//STRIP001 {
//STRIP001 	if( !mbInitialized )
//STRIP001 	{
//STRIP001 		switch( meObjectKind )
//STRIP001 		{
//STRIP001 			case( SGA_OBJ_ANIM ):
//STRIP001 			case( SGA_OBJ_BMP ):
//STRIP001 			case( SGA_OBJ_INET ):
//STRIP001 			{
//STRIP001 				Graphic aGraphic;
//STRIP001 
//STRIP001 				if( mpTheme->GetGraphic( mnObjectPos, aGraphic ) )
//STRIP001 					mpGraphicObject = new GraphicObject( aGraphic );
//STRIP001 
//STRIP001 				mpURL = new INetURLObject;
//STRIP001 
//STRIP001 				if( !mpTheme->GetURL( mnObjectPos, *mpURL ) )
//STRIP001 					delete mpURL, mpURL = NULL;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SGA_OBJ_SOUND ):
//STRIP001 			{
//STRIP001 				mpURL = new INetURLObject;
//STRIP001 
//STRIP001 				if( !mpTheme->GetURL( mnObjectPos, *mpURL ) )
//STRIP001 					delete mpURL, mpURL = NULL;
//STRIP001 			}
//STRIP001             break;
//STRIP001 			
//STRIP001 			case( SGA_OBJ_SVDRAW ):
//STRIP001 			{
//STRIP001 				Graphic aGraphic;
//STRIP001 
//STRIP001 
//STRIP001 				if( mpTheme->GetGraphic( mnObjectPos, aGraphic ) )
//STRIP001 					mpGraphicObject = new GraphicObject( aGraphic );
//STRIP001 
//STRIP001                 mxModelStream = new SotStorageStream( String() );
//STRIP001         		mxModelStream->SetBufferSize( 16348 );
//STRIP001 
//STRIP001 				if( !mpTheme->GetModelStream( mnObjectPos, mxModelStream ) )
//STRIP001                     mxModelStream.Clear();
//STRIP001                 else
//STRIP001                     mxModelStream->Seek( 0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "GalleryTransferable::GalleryTransferable: invalid object type" );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		mbInitialized = sal_True;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::AddSupportedFormats()
//STRIP001 {
//STRIP001 	InitData();
//STRIP001 
//STRIP001     if( mpURL )
//STRIP001         AddFormat( FORMAT_FILE );
//STRIP001 
//STRIP001 	if( mxModelStream.Is() )
//STRIP001 	{
//STRIP001 /*!!!
//STRIP001 		Graphic		aGraphic;
//STRIP001 		ImageMap	aImageMap;
//STRIP001 
//STRIP001 		if( CreateIMapGraphic( *mpModel, aGraphic, aImageMap ) )
//STRIP001 		{
//STRIP001 			delete mpGraphicObject, mpGraphicObject = new GraphicObject( aGraphic );
//STRIP001 			delete mpImageMap, mpImageMap = new ImageMap( aImageMap );
//STRIP001 
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_SVIM );
//STRIP001 		}
//STRIP001 		else
//STRIP001 */
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001 	}
//STRIP001 	
//STRIP001 	if( mpGraphicObject )
//STRIP001 	{
//STRIP001 		AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001 
//STRIP001 		if( mpGraphicObject->GetType() == GRAPHIC_GDIMETAFILE )
//STRIP001 		{
//STRIP001 			AddFormat( FORMAT_GDIMETAFILE );
//STRIP001 			AddFormat( FORMAT_BITMAP );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			AddFormat( FORMAT_BITMAP );
//STRIP001 			AddFormat( FORMAT_GDIMETAFILE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool GalleryTransferable::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_uInt32	nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001 	sal_Bool	bRet = sal_False;
//STRIP001 
//STRIP001 	InitData();
//STRIP001 
//STRIP001 	if( ( SOT_FORMATSTR_ID_DRAWING == nFormat ) && mxModelStream.Is() )
//STRIP001 	{
//STRIP001 		bRet = SetObject( &mxModelStream, 0, rFlavor );
//STRIP001 	}
//STRIP001 	else if( ( SOT_FORMATSTR_ID_SVIM == nFormat ) && mpImageMap )
//STRIP001 	{
//STRIP001 		bRet = SetImageMap( *mpImageMap, rFlavor );
//STRIP001 	}
//STRIP001 	else if( ( FORMAT_FILE == nFormat ) && mpURL )
//STRIP001 	{
//STRIP001 		bRet = SetString( mpURL->GetMainURL( INetURLObject::NO_DECODE ), rFlavor );
//STRIP001 	}
//STRIP001 	else if( ( SOT_FORMATSTR_ID_SVXB == nFormat ) && mpGraphicObject )
//STRIP001 	{
//STRIP001 		bRet = SetGraphic( mpGraphicObject->GetGraphic(), rFlavor );
//STRIP001 	}
//STRIP001 	else if( ( FORMAT_GDIMETAFILE == nFormat ) && mpGraphicObject )
//STRIP001 	{
//STRIP001 		bRet = SetGDIMetaFile( mpGraphicObject->GetGraphic().GetGDIMetaFile(), rFlavor );
//STRIP001 	}
//STRIP001 	else if( ( FORMAT_BITMAP == nFormat ) && mpGraphicObject )
//STRIP001 	{
//STRIP001 		bRet = SetBitmap( mpGraphicObject->GetGraphic().GetBitmap(), rFlavor );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool GalleryTransferable::WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, 
//STRIP001 										   sal_uInt32 nUserObjectId, const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	if( pUserObject )
//STRIP001 	{
//STRIP001         *rxOStm << *static_cast< SotStorageStream* >( pUserObject );
//STRIP001 		bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	mpTheme->SetDragging( FALSE );
//STRIP001 	mpTheme->SetDragPos( 0 );
//STRIP001 	if ( nDropAction )
//STRIP001 	{
//STRIP001 		Window *pFocusWindow = Application::GetFocusWindow();
//STRIP001 		if ( pFocusWindow )
//STRIP001 			pFocusWindow->GrabFocusToDocument();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::ObjectReleased()
//STRIP001 {
//STRIP001     mxModelStream.Clear();
//STRIP001 	delete mpGraphicObject, mpGraphicObject = NULL;
//STRIP001 	delete mpImageMap, mpImageMap = NULL;
//STRIP001 	delete mpURL, mpURL = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::CopyToClipboard( Window* pWindow )
//STRIP001 {
//STRIP001 	InitData();
//STRIP001 	TransferableHelper::CopyToClipboard( pWindow );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTransferable::StartDrag( Window* pWindow, sal_Int8 nDragSourceActions,
//STRIP001 									 sal_Int32 nDragPointer, sal_Int32 nDragImage )
//STRIP001 {
//STRIP001     INetURLObject aURL;
//STRIP001 
//STRIP001     if( mpTheme->GetURL( mnObjectPos, aURL ) && ( aURL.GetProtocol() != INET_PROT_NOT_VALID ) )
//STRIP001     {
//STRIP001     	mpTheme->SetDragging( sal_True );
//STRIP001 	    mpTheme->SetDragPos( mnObjectPos );
//STRIP001 		TransferableHelper::StartDrag( pWindow, nDragSourceActions, nDragPointer, nDragImage );
//STRIP001     }
//STRIP001 }
}
