/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optdict.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:35:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif


#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif
#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#define _SVX_OPTDICT_CXX

#include "dialogs.hrc"
#include "optdict.hrc"

#define ITEMID_SPELLCHECK	0

#include "optdict.hxx"
#include "dialmgr.hxx"
#include "svxerr.hxx"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::linguistic2;

// static ----------------------------------------------------------------

//STRIP001 static const sal_uInt16 nNameLen    = 8;
//STRIP001 static const short  NOACTDICT   = -1;

//STRIP001 static long nStaticTabs[]=
//STRIP001 {
//STRIP001 	2,10,71,120
//STRIP001 };

// static function -------------------------------------------------------

//STRIP001 static String getNormDicEntry_Impl( const String &rText )
//STRIP001 {
//STRIP001 	String aTmp( rText );
//STRIP001 	aTmp.EraseTrailingChars( '.' );
//STRIP001 	aTmp.EraseAllChars( '=' );
//STRIP001 	return aTmp;
//STRIP001 }


// Compare Dictionary Entry  result
//STRIP001 enum CDE_RESULT { CDE_EQUAL, CDE_SIMILAR, CDE_DIFFERENT };

//STRIP001 static CDE_RESULT cmpDicEntry_Impl( const String &rText1, const String &rText2 )
//STRIP001 {
//STRIP001 	CDE_RESULT eRes = CDE_DIFFERENT;
//STRIP001 
//STRIP001 	if (rText1 == rText2)
//STRIP001 		eRes = CDE_EQUAL;
//STRIP001 	else
//STRIP001 	{	// similar = equal up to trailing '.' and hyphenation positions
//STRIP001 		// marked with '='
//STRIP001 		if (getNormDicEntry_Impl( rText1 ) == getNormDicEntry_Impl( rText2 ))
//STRIP001 			eRes = CDE_SIMILAR;
//STRIP001 	}
//STRIP001 
//STRIP001 	return eRes;
//STRIP001 }

// class SvxNewDictionaryDialog -------------------------------------------

//STRIP001 SvxNewDictionaryDialog::SvxNewDictionaryDialog( Window* pParent,
//STRIP001 		Reference< XSpellChecker1 >  &xSpl ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SFXDLG_NEWDICT ) ),
//STRIP001 
//STRIP001 	aNameText		( this, ResId( FT_DICTNAME ) ),
//STRIP001 	aNameEdit		( this, ResId( ED_DICTNAME ) ),
//STRIP001 	aLanguageText	( this, ResId( FT_DICTLANG ) ),
//STRIP001 	aLanguageLB		( this, ResId( LB_DICTLANG ) ),
//STRIP001 	aExceptBtn		( this, ResId( BTN_EXCEPT ) ),
//STRIP001 	aNewDictBox		( this, ResId( GB_NEWDICT ) ),
//STRIP001 	aOKBtn			( this, ResId( BTN_NEWDICT_OK ) ),
//STRIP001 	aCancelBtn		( this, ResId( BTN_NEWDICT_ESC ) ),
//STRIP001 	aHelpBtn		( this, ResId( BTN_NEWDICT_HLP ) ),
//STRIP001 	xSpell( xSpl )
//STRIP001 {
//STRIP001 	// Handler installieren
//STRIP001 	aNameEdit.SetModifyHdl(
//STRIP001 		LINK( this, SvxNewDictionaryDialog, ModifyHdl_Impl ) );
//STRIP001 	aOKBtn.SetClickHdl( LINK( this, SvxNewDictionaryDialog, OKHdl_Impl ) );
//STRIP001 
//STRIP001 	// Sprachen anzeigen
//STRIP001 	aLanguageLB.SetLanguageList( LANG_LIST_ALL, TRUE, TRUE );
//STRIP001 	aLanguageLB.SelectEntryPos(0);
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxNewDictionaryDialog, OKHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	String sDict = aNameEdit.GetText();
//STRIP001 	sDict.EraseTrailingChars();
//STRIP001 	// add extension for personal dictionaries
//STRIP001 	sDict.AppendAscii(".dic");
//STRIP001 
//STRIP001 	Reference< XDictionaryList >  xDicList( SvxGetDictionaryList() );
//STRIP001 
//STRIP001 	Sequence< Reference< XDictionary >  > aDics;
//STRIP001 	if (xDicList.is())
//STRIP001 		aDics = xDicList->getDictionaries();
//STRIP001 	const Reference< XDictionary >  *pDic = aDics.getConstArray();
//STRIP001 	sal_Int32 nCount = (sal_uInt16) aDics.getLength();
//STRIP001 
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	sal_uInt16 i;
//STRIP001 	for (i = 0; !bFound && i < nCount; ++i )
//STRIP001 		if ( sDict.EqualsIgnoreCaseAscii( String(pDic[i]->getName()) ))
//STRIP001 			bFound = sal_True;
//STRIP001 
//STRIP001 	if ( bFound )
//STRIP001 	{
//STRIP001 		// Doppelte Namen?
//STRIP001 		InfoBox( this, SVX_RESSTR( RID_SVXSTR_OPT_DOUBLE_DICTS ) ).Execute();
//STRIP001 		aNameEdit.GrabFocus();
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Erzeugen und hinzufuegen
//STRIP001 	sal_uInt16 nLang = aLanguageLB.GetSelectLanguage();
//STRIP001 	try
//STRIP001 	{
//STRIP001 		// create new dictionary
//STRIP001 		DictionaryType eType = aExceptBtn.IsChecked() ?
//STRIP001 				DictionaryType_NEGATIVE : DictionaryType_POSITIVE;
//STRIP001 		if (xDicList.is())
//STRIP001 		{
//STRIP001 			lang::Locale aLocale( SvxCreateLocale(nLang) );
//STRIP001 			String aURL( SvxGetDictionaryURL(sDict) );
//STRIP001 			xNewDic = Reference< XDictionary1 > (
//STRIP001 					xDicList->createDictionary( sDict, aLocale, eType, aURL ) , UNO_QUERY );
//STRIP001 		}
//STRIP001 		DBG_ASSERT(xNewDic.is(), "NULL pointer");
//STRIP001 	}
//STRIP001 	catch(...)
//STRIP001 	{
//STRIP001 		xNewDic = NULL;
//STRIP001 
//STRIP001 		// Fehler: konnte neues W"orterbuch nicht anlegen
//STRIP001 		SfxErrorContext aContext( ERRCTX_SVX_LINGU_DICTIONARY, String(),
//STRIP001 			this, RID_SVXERRCTX, DIALOG_MGR() );
//STRIP001 		ErrorHandler::HandleError( *new StringErrorInfo(
//STRIP001 				ERRCODE_SVX_LINGU_DICT_NOTWRITEABLE, sDict ) );
//STRIP001 
//STRIP001 /* chaos raus
//STRIP001 	   	// delete object pointed to by util::URL
//STRIP001 		//! works only if it is in our own dictionary path
//STRIP001 		CntAnchorRef xAnchor = new CntAnchor( NULL, SvxGetDictionaryURL(sDict) );
//STRIP001 		xAnchor->Put( SfxBoolItem(WID_DELETE, sal_True) );
//STRIP001 */
//STRIP001 
//STRIP001 		EndDialog( RET_CANCEL );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (xDicList.is() && xNewDic.is())
//STRIP001 	{
//STRIP001 		xDicList->addDictionary( Reference< XDictionary > ( xNewDic, UNO_QUERY ) );
//STRIP001 
//STRIP001 		// refresh list of dictionaries
//STRIP001 		//! dictionaries may have been added/removed elsewhere too.
//STRIP001 		aDics = xDicList->getDictionaries();
//STRIP001 	}
//STRIP001 	pDic = aDics.getConstArray();
//STRIP001 	nCount = (sal_uInt16) aDics.getLength();
//STRIP001 
//STRIP001 
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxNewDictionaryDialog, ModifyHdl_Impl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( aNameEdit.GetText().Len() )
//STRIP001 		aOKBtn.Enable();
//STRIP001 	else
//STRIP001 		aOKBtn.Disable();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxNewDictionaryDialog, ModifyHdl_Impl, Edit *, EMPTYARG )

//==========================================================================
//
// class SvxEditDictionaryDialog -------------------------------------------
//
//==========================================================================

//STRIP001 SvxEditDictionaryDialog::SvxEditDictionaryDialog(
//STRIP001 			Window* pParent,
//STRIP001 			const String& rName,
//STRIP001 			Reference< XSpellChecker1 >  &xSpl ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SFXDLG_EDITDICT ) ),
//STRIP001 
//STRIP001 	aBookFT			( this, ResId( FT_BOOK ) ),
//STRIP001 	aAllDictsLB		( this, ResId( LB_ALLDICTS ) ),
//STRIP001 	aLangFT			( this, ResId( FT_DICTLANG ) ),
//STRIP001 	aLangLB			( this, ResId( LB_DICTLANG ) ),
//STRIP001 	aWordFT			( this, ResId( FT_WORD ) ),
//STRIP001 	aWordED			( this, ResId( ED_WORD ) ),
//STRIP001 	aReplaceFT		( this, ResId( FT_REPLACE ) ),
//STRIP001 	aReplaceED		( this, ResId( ED_REPLACE ) ),
//STRIP001 	aWordsLB		( this, ResId( TLB_REPLACE ) ),
//STRIP001 	aNewReplacePB	( this, ResId( PB_NEW_REPLACE ) ),
//STRIP001 	aDeletePB		( this, ResId( PB_DELETE_REPLACE ) ),
//STRIP001 	aEditDictsBox	( this, ResId( GB_EDITDICTS ) ),
//STRIP001 	aCloseBtn		( this, ResId( BTN_EDITCLOSE ) ),
//STRIP001 	aHelpBtn		( this, ResId( BTN_EDITHELP ) ),
//STRIP001 	sModify			(ResId(STR_MODIFY)),
//STRIP001 	sNew			(aNewReplacePB.GetText()),
//STRIP001 	aDecoView		( this),
//STRIP001 	bFirstSelect	(sal_True),
//STRIP001 	bDoNothing		(sal_False),
//STRIP001 	xSpell			( xSpl ),
//STRIP001 	nOld			( NOACTDICT )
//STRIP001 
//STRIP001 {
//STRIP001 	if (SvxGetDictionaryList().is())
//STRIP001 		aDics = SvxGetDictionaryList()->getDictionaries();
//STRIP001 
//STRIP001 	aWordsLB.SetSelectHdl(LINK(this, SvxEditDictionaryDialog, SelectHdl));
//STRIP001 	aWordsLB.SetTabs(nStaticTabs);
//STRIP001 
//STRIP001 	//! we use an algorithm of our own to insert elements sorted
//STRIP001 	aWordsLB.SetWindowBits(/*WB_SORT|*/WB_HSCROLL|WB_CLIPCHILDREN);
//STRIP001 
//STRIP001 
//STRIP001 	nWidth=aWordED.GetSizePixel().Width();
//STRIP001 	// Handler installieren
//STRIP001 	aNewReplacePB.SetClickHdl(
//STRIP001 		LINK( this, SvxEditDictionaryDialog, NewDelHdl));
//STRIP001 	aDeletePB.SetClickHdl(
//STRIP001 		LINK( this, SvxEditDictionaryDialog, NewDelHdl));
//STRIP001 
//STRIP001 	aLangLB.SetSelectHdl(
//STRIP001 		LINK( this, SvxEditDictionaryDialog, SelectLangHdl_Impl ) );
//STRIP001 	aAllDictsLB.SetSelectHdl(
//STRIP001 		LINK( this, SvxEditDictionaryDialog, SelectBookHdl_Impl ) );
//STRIP001 
//STRIP001 	aWordED.SetModifyHdl(LINK(this, SvxEditDictionaryDialog, ModifyHdl));
//STRIP001 	aReplaceED.SetModifyHdl(LINK(this, SvxEditDictionaryDialog, ModifyHdl));
//STRIP001 	aWordED.SetActionHdl(LINK(this, SvxEditDictionaryDialog, NewDelHdl));
//STRIP001 	aReplaceED.SetActionHdl(LINK(this, SvxEditDictionaryDialog, NewDelHdl));
//STRIP001 
//STRIP001 	// Listbox mit allen verfuegbaren WB's fuellen
//STRIP001 	const Reference< XDictionary >  *pDic = aDics.getConstArray();
//STRIP001 	sal_Int32 nCount = aDics.getLength();
//STRIP001 
//STRIP001 	String aLookUpEntry;
//STRIP001 	for ( sal_Int32 i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		Reference< XDictionary1 >  xDic( pDic[i], UNO_QUERY );
//STRIP001 		if (xDic.is())
//STRIP001 		{
//STRIP001 			sal_Bool bNegative = xDic->getDictionaryType() == DictionaryType_NEGATIVE ?
//STRIP001 								sal_True : sal_False;
//STRIP001 			String aDicName( xDic->getName() );
//STRIP001 			const String aTxt( ::GetDicInfoStr( aDicName, xDic->getLanguage(),
//STRIP001 												 bNegative ) );
//STRIP001 			aAllDictsLB.InsertEntry( aTxt );
//STRIP001 
//STRIP001 			if (rName == aDicName)
//STRIP001 				aLookUpEntry = aTxt;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aLangLB.SetLanguageList( LANG_LIST_ALL, TRUE, TRUE );
//STRIP001 
//STRIP001 	aReplaceED.SetSpaces(sal_True);
//STRIP001 	aWordED.SetSpaces(sal_True);
//STRIP001 
//STRIP001 	if ( nCount > 0 )
//STRIP001 	{
//STRIP001 		aAllDictsLB.SelectEntry( aLookUpEntry );
//STRIP001 		sal_uInt16 nPos = aAllDictsLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 		if ( nPos == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			nPos = 0;
//STRIP001 			aAllDictsLB.SelectEntryPos( nPos );
//STRIP001 		}
//STRIP001 		Reference< XDictionary1 >  xDic;
//STRIP001 		if (nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 			xDic = Reference< XDictionary1 > ( aDics.getConstArray()[ nPos ], UNO_QUERY );
//STRIP001 		if (xDic.is())
//STRIP001 			SetLanguage_Impl( xDic->getLanguage() );
//STRIP001 
//STRIP001 		// check if dictionary is read-only
//STRIP001 		SetDicReadonly_Impl(xDic);
//STRIP001 		sal_Bool bEnable = !IsDicReadonly_Impl();
//STRIP001 		aNewReplacePB   .Enable( sal_False );
//STRIP001 		aDeletePB		.Enable( sal_False );
//STRIP001 		aLangFT.Enable( bEnable );
//STRIP001 		aLangLB.Enable( bEnable );
//STRIP001 		ShowWords_Impl( nPos );
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aNewReplacePB.Disable();
//STRIP001 		aDeletePB	 .Disable();
//STRIP001 	}
//STRIP001 	FreeResource();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxEditDictionaryDialog::~SvxEditDictionaryDialog()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxEditDictionaryDialog::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	ModalDialog::Paint(rRect );
//STRIP001 
//STRIP001 	Rectangle aRect(aEditDictsBox.GetPosPixel(),aEditDictsBox.GetSizePixel());
//STRIP001 
//STRIP001 	sal_uInt16 nStyle=BUTTON_DRAW_NOFILL;
//STRIP001 	aDecoView.DrawButton( aRect, nStyle);
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxEditDictionaryDialog::SetDicReadonly_Impl(
//STRIP001 			Reference< XDictionary1 >  &xDic )
//STRIP001 {
//STRIP001 	// enable or disable new and delete button according to file attributes
//STRIP001 	bDicIsReadonly = sal_True;
//STRIP001 	if (xDic.is())
//STRIP001 	{
//STRIP001 		Reference< frame::XStorable >  xStor( xDic, UNO_QUERY );
//STRIP001 		if (   !xStor.is() 				// non persistent dictionary
//STRIP001 			|| !xStor->hasLocation()	// not yet persistent
//STRIP001 			|| !xStor->isReadonly() )
//STRIP001 		{
//STRIP001 			bDicIsReadonly = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxEditDictionaryDialog::SetLanguage_Impl( util::Language nLanguage )
//STRIP001 {
//STRIP001 	// select language
//STRIP001 	aLangLB.SelectLanguage( nLanguage );
//STRIP001 }

//STRIP001 USHORT SvxEditDictionaryDialog::GetLBInsertPos(const String &rDicWord)
//STRIP001 {
//STRIP001 	USHORT nPos = USHRT_MAX;
//STRIP001 
//STRIP001 	IntlWrapper aIntlWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const CollatorWrapper* pCollator = aIntlWrapper.getCollator();
//STRIP001 	USHORT j;
//STRIP001 	for( j = 0; j < aWordsLB.GetEntryCount(); j++ )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = aWordsLB.GetEntry(j);
//STRIP001 		DBG_ASSERT( pEntry, "NULL pointer");
//STRIP001 		String aNormEntry( getNormDicEntry_Impl( rDicWord ) );
//STRIP001 		StringCompare eCmpRes = (StringCompare)pCollator->
//STRIP001 			CompareString( aNormEntry, getNormDicEntry_Impl( aWordsLB.GetEntryText(pEntry, 0) ) );
//STRIP001 		if( COMPARE_LESS == eCmpRes )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if (j < aWordsLB.GetEntryCount())	// entry found?
//STRIP001 		nPos = j;
//STRIP001 
//STRIP001 	return nPos;
//STRIP001 }

//STRIP001 void SvxEditDictionaryDialog::RemoveDictEntry(SvLBoxEntry* pEntry)
//STRIP001 {
//STRIP001 	sal_uInt16 nLBPos = aAllDictsLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( pEntry != NULL && nLBPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		String sTmpShort(aWordsLB.GetEntryText(pEntry, 0));
//STRIP001 
//STRIP001 		Reference< XDictionary >  xDic = aDics.getConstArray()[ nLBPos ];
//STRIP001 		if (xDic->remove( sTmpShort ))	// sal_True on success
//STRIP001 		{
//STRIP001 			aWordsLB.GetModel()->Remove(pEntry);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxEditDictionaryDialog, SelectBookHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	sal_uInt16 nPos = aAllDictsLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aNewReplacePB.Enable( sal_False );
//STRIP001 		aDeletePB	 .Enable( sal_False );
//STRIP001 		// Dictionary anzeigen
//STRIP001 		ShowWords_Impl( nPos );
//STRIP001 		// enable or disable new and delete button according to file attributes
//STRIP001 		Reference< XDictionary1 >  xDic( aDics.getConstArray()[ nPos ], UNO_QUERY );
//STRIP001 		if (xDic.is())
//STRIP001 			SetLanguage_Impl( xDic->getLanguage() );
//STRIP001 
//STRIP001 		SetDicReadonly_Impl(xDic);
//STRIP001 		sal_Bool bEnable = !IsDicReadonly_Impl();
//STRIP001 		aLangFT.Enable( bEnable );
//STRIP001 		aLangLB.Enable( bEnable );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxEditDictionaryDialog, SelectLangHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	sal_uInt16 nDicPos = aAllDictsLB.GetSelectEntryPos();
//STRIP001 	sal_uInt16 nLang = aLangLB.GetSelectLanguage();
//STRIP001 	Reference< XDictionary1 >  xDic( aDics.getConstArray()[ nDicPos ], UNO_QUERY );
//STRIP001 	INT16 nOldLang = xDic->getLanguage();
//STRIP001 
//STRIP001 	if ( nLang != nOldLang )
//STRIP001 	{
//STRIP001 		QueryBox aBox( this, SVX_RES( RID_SFXQB_SET_LANGUAGE ) );
//STRIP001 		String sTxt( aBox.GetMessText() );
//STRIP001 		sTxt.SearchAndReplaceAscii( "%1", aAllDictsLB.GetSelectEntry() );
//STRIP001 		aBox.SetMessText( sTxt );
//STRIP001 
//STRIP001 		if ( aBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			xDic->setLanguage( nLang );
//STRIP001 			sal_Bool bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001 
//STRIP001 			const String sName(
//STRIP001 				::GetDicInfoStr( xDic->getName(),
//STRIP001 								 xDic->getLanguage(),
//STRIP001 								 bNegativ ) );
//STRIP001 			aAllDictsLB.RemoveEntry( nDicPos );
//STRIP001 			aAllDictsLB.InsertEntry( sName, nDicPos );
//STRIP001 			aAllDictsLB.SelectEntryPos( nDicPos );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SetLanguage_Impl( nOldLang );
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxEditDictionaryDialog::ShowWords_Impl( sal_uInt16 nId )
//STRIP001 {
//STRIP001 	Reference< XDictionary >  xDic = aDics.getConstArray()[ nId ];
//STRIP001 
//STRIP001 	nOld = nId;
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	aWordED.SetText(aStr);
//STRIP001 	aReplaceED.SetText(aStr);
//STRIP001 
//STRIP001 	if(xDic->getDictionaryType() != DictionaryType_POSITIVE)
//STRIP001 	{
//STRIP001 		nStaticTabs[0]=2;
//STRIP001 
//STRIP001 		// make controls for replacement text active
//STRIP001 		if(!aReplaceFT.IsVisible())
//STRIP001 		{
//STRIP001 			Size aSize=aWordED.GetSizePixel();
//STRIP001 			aSize.Width()=nWidth;
//STRIP001 			aWordED.SetSizePixel(aSize);
//STRIP001 			aReplaceFT.Show();
//STRIP001 			aReplaceED.Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nStaticTabs[0]=1;
//STRIP001 
//STRIP001 		// deactivate controls for replacement text
//STRIP001 		if(aReplaceFT.IsVisible())
//STRIP001 		{
//STRIP001 			Size aSize=aWordED.GetSizePixel();
//STRIP001 			aSize.Width()=aWordsLB.GetSizePixel().Width();
//STRIP001 			aWordED.SetSizePixel(aSize);
//STRIP001 			aReplaceFT.Hide();
//STRIP001 			aReplaceED.Hide();
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	aWordsLB.SetTabs(nStaticTabs);
//STRIP001 	aWordsLB.Clear();
//STRIP001 
//STRIP001 	Sequence< Reference< XDictionaryEntry >  > aEntries( xDic->getEntries() );
//STRIP001 	const Reference< XDictionaryEntry >  *pEntry = aEntries.getConstArray();
//STRIP001 	sal_Int32 nCount = aEntries.getLength();
//STRIP001 
//STRIP001 	for (sal_Int32 i = 0;  i < nCount;  i++)
//STRIP001 	{
//STRIP001 		aStr = String(pEntry[i]->getDictionaryWord());
//STRIP001 		INT16 nPos = GetLBInsertPos( aStr );
//STRIP001 		if(pEntry[i]->isNegative())
//STRIP001 		{
//STRIP001 			aStr += '\t';
//STRIP001 			aStr += String(pEntry[i]->getReplacementText());
//STRIP001 		}
//STRIP001 		aWordsLB.InsertEntry(aStr, nPos == USHRT_MAX ?
//STRIP001 										LIST_APPEND : (sal_uInt32) nPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aWordsLB.GetEntryCount())
//STRIP001 	{
//STRIP001 		aWordED	  .SetText( aWordsLB.GetEntryText(0LU, 0) );
//STRIP001 		aReplaceED.SetText( aWordsLB.GetEntryText(0LU, 1) );
//STRIP001 	}
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK(SvxEditDictionaryDialog, SelectHdl, SvTabListBox*, pBox)
//STRIP001 {
//STRIP001 	if(!bDoNothing)
//STRIP001 	{
//STRIP001 		if(!bFirstSelect)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pEntry = pBox->FirstSelected();
//STRIP001 			String sTmpShort(pBox->GetEntryText(pEntry, 0));
//STRIP001 			// wird der Text ueber den ModifyHdl gesetzt, dann steht der Cursor
//STRIP001 			//sonst immer am Wortanfang, obwohl man gerade hier editiert
//STRIP001 			if(aWordED.GetText() != sTmpShort)
//STRIP001 				aWordED.SetText(sTmpShort);
//STRIP001 			aReplaceED.SetText(pBox->GetEntryText(pEntry, 1));
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bFirstSelect = sal_False;
//STRIP001 
//STRIP001 		// entries in the list box should exactly correspond to those from the
//STRIP001 		// dictionary. Thus:
//STRIP001 		aNewReplacePB.Enable(sal_False);
//STRIP001 		aDeletePB	 .Enable( sal_True && !IsDicReadonly_Impl() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 };

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK(SvxEditDictionaryDialog, NewDelHdl, PushButton*, pBtn)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = aWordsLB.FirstSelected();
//STRIP001 
//STRIP001 	if(pBtn == &aDeletePB)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(pEntry, "keine Eintrag selektiert")
//STRIP001 		String aStr;
//STRIP001 
//STRIP001 		aWordED.SetText(aStr);
//STRIP001 		aReplaceED.SetText(aStr);
//STRIP001 		aDeletePB.Disable();
//STRIP001 
//STRIP001 		RemoveDictEntry(pEntry);	// remove entry from dic and list-box
//STRIP001 	}
//STRIP001 	if(pBtn == &aNewReplacePB || aNewReplacePB.IsEnabled())
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = aWordsLB.FirstSelected();
//STRIP001 		XubString aNewWord(aWordED.GetText());
//STRIP001 		String sEntry(aNewWord);
//STRIP001 		XubString aReplaceStr(aReplaceED.GetText());
//STRIP001 
//STRIP001 		sal_Int16 nAddRes = DIC_ERR_UNKNOWN;
//STRIP001 		sal_uInt16 nPos = aAllDictsLB.GetSelectEntryPos();
//STRIP001 		if ( nPos != LISTBOX_ENTRY_NOTFOUND && aNewWord.Len() > 0)
//STRIP001 		{
//STRIP001 			DBG_ASSERT(nPos < aDics.getLength(), "invalid dictionary index");
//STRIP001 			Reference< XDictionary1 >  xDic( aDics.getConstArray()[ nPos ], UNO_QUERY );
//STRIP001 			if (xDic.is())
//STRIP001 			{
//STRIP001 				// make changes in dic
//STRIP001 
//STRIP001 				//! ...IsVisible should reflect wether the dictionary is a negativ
//STRIP001 				//! or not (hopefully...)
//STRIP001 				sal_Bool bIsNegEntry = aReplaceFT.IsVisible();
//STRIP001 				::rtl::OUString aRplcText;
//STRIP001 				if(bIsNegEntry)
//STRIP001 					aRplcText = aReplaceStr;
//STRIP001 
//STRIP001 				if (pEntry) // entry selected in aWordsLB ie action = modify entry
//STRIP001 					xDic->remove( aWordsLB.GetEntryText( pEntry, 0 ) );
//STRIP001 				// if remove has failed the following add should fail too
//STRIP001 				// and thus a warning message should be triggered...
//STRIP001 
//STRIP001                 Reference<XDictionary> aXDictionary(xDic, UNO_QUERY);
//STRIP001 				nAddRes = SvxAddEntryToDic( aXDictionary,
//STRIP001 							aNewWord, bIsNegEntry,
//STRIP001 							aRplcText, xDic->getLanguage(), sal_False );
//STRIP001  			}
//STRIP001 		}
//STRIP001 		if (DIC_ERR_NONE != nAddRes)
//STRIP001 			SvxDicError( this, nAddRes );
//STRIP001 
//STRIP001 		if(DIC_ERR_NONE == nAddRes && sEntry.Len())
//STRIP001 		{
//STRIP001 			// insert new entry in list-box etc...
//STRIP001 
//STRIP001 			aWordsLB.SetUpdateMode(sal_False);
//STRIP001 			sal_uInt16 nPos = USHRT_MAX;
//STRIP001 
//STRIP001 			if(aReplaceFT.IsVisible())
//STRIP001 			{
//STRIP001 				sEntry += '\t';
//STRIP001 				sEntry += aReplaceStr;
//STRIP001 			}
//STRIP001 
//STRIP001 			SvLBoxEntry* pNewEntry = NULL;
//STRIP001 			if(pEntry) // entry selected in aWordsLB ie action = modify entry
//STRIP001 			{
//STRIP001 				aWordsLB.SetEntryText( sEntry, pEntry );
//STRIP001 				pNewEntry = pEntry;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nPos = GetLBInsertPos( aNewWord );
//STRIP001 				SvLBoxEntry* pInsEntry = aWordsLB.InsertEntry(sEntry,
//STRIP001 							nPos == USHRT_MAX ? LIST_APPEND : (sal_uInt32)nPos);
//STRIP001 				pNewEntry = pInsEntry;
//STRIP001 			}
//STRIP001 
//STRIP001 			aWordsLB.MakeVisible( pNewEntry );
//STRIP001 			aWordsLB.SetUpdateMode(sal_True);
//STRIP001 			// falls der Request aus dem ReplaceEdit kam, dann Focus in das ShortEdit setzen
//STRIP001 			if(aReplaceED.HasFocus())
//STRIP001 				aWordED.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// das kann nur ein Enter in einem der beiden Edit-Felder sein und das
//STRIP001 		// bedeutet EndDialog() - muss im KeyInput ausgewertet werden
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 	ModifyHdl(&aWordED);
//STRIP001 	return 1;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK(SvxEditDictionaryDialog, ModifyHdl, Edit*, pEdt)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pFirstSel = aWordsLB.FirstSelected();
//STRIP001 	String rEntry = pEdt->GetText();
//STRIP001 
//STRIP001 	xub_StrLen nWordLen=rEntry.Len();
//STRIP001 	const String& rRepString = aReplaceED.GetText();
//STRIP001 
//STRIP001 	BOOL bEnableNewReplace	= FALSE;
//STRIP001 	BOOL bEnableDelete		= FALSE;
//STRIP001 	String aNewReplaceText	= sNew;
//STRIP001 
//STRIP001 	if(pEdt == &aWordED)
//STRIP001 	{
//STRIP001 		if(nWordLen>0)
//STRIP001 		{
//STRIP001 			sal_Bool bFound = sal_False;
//STRIP001 			sal_Bool bTmpSelEntry=sal_False;
//STRIP001 			CDE_RESULT eCmpRes = CDE_DIFFERENT;
//STRIP001 
//STRIP001 			for(sal_uInt16 i = 0; i < aWordsLB.GetEntryCount(); i++)
//STRIP001 			{
//STRIP001 				SvLBoxEntry*  pEntry = aWordsLB.GetEntry( i );
//STRIP001 				String aTestStr( aWordsLB.GetEntryText(pEntry, 0) );
//STRIP001 				eCmpRes = cmpDicEntry_Impl( rEntry, aTestStr );
//STRIP001 				if(CDE_DIFFERENT != eCmpRes)
//STRIP001 				{
//STRIP001 					if(rRepString.Len())
//STRIP001 						bFirstSelect = sal_True;
//STRIP001 					bDoNothing=sal_True;
//STRIP001 					aWordsLB.SetCurEntry(pEntry);
//STRIP001 					bDoNothing=sal_False;
//STRIP001 					pFirstSel = pEntry;
//STRIP001 					aReplaceED.SetText(aWordsLB.GetEntryText(pEntry, 1));
//STRIP001 
//STRIP001 					if (CDE_SIMILAR == eCmpRes)
//STRIP001 					{
//STRIP001 						aNewReplaceText = sModify;
//STRIP001 						bEnableNewReplace = TRUE;
//STRIP001 					}
//STRIP001 					bFound= sal_True;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				else if(getNormDicEntry_Impl(aTestStr).Search(
//STRIP001 							getNormDicEntry_Impl( rEntry ) ) == 0
//STRIP001 						&& !bTmpSelEntry)
//STRIP001 				{
//STRIP001 					bDoNothing=sal_True;
//STRIP001 					aWordsLB.MakeVisible(pEntry);
//STRIP001 					bDoNothing=sal_False;
//STRIP001 					bTmpSelEntry=sal_True;
//STRIP001 
//STRIP001 					aNewReplaceText = sNew;
//STRIP001 					bEnableNewReplace = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bFound)
//STRIP001 			{
//STRIP001 				aWordsLB.SelectAll(sal_False);
//STRIP001 				pFirstSel = 0;
//STRIP001 
//STRIP001 				aNewReplaceText = sNew;
//STRIP001 				bEnableNewReplace = TRUE;
//STRIP001 			}
//STRIP001 			bEnableDelete = CDE_DIFFERENT != eCmpRes;
//STRIP001 		}
//STRIP001 		else if(aWordsLB.GetEntryCount()>0)
//STRIP001 		{
//STRIP001 			SvLBoxEntry*  pEntry = aWordsLB.GetEntry( 0 );
//STRIP001 			bDoNothing=sal_True;
//STRIP001 			aWordsLB.MakeVisible(pEntry);
//STRIP001 			bDoNothing=sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(pEdt == &aReplaceED)
//STRIP001 	{
//STRIP001 		String aReplaceText;
//STRIP001 		String aWordText;
//STRIP001 		if (pFirstSel)	// a aWordsLB entry is selected
//STRIP001 		{
//STRIP001 			aWordText	 = aWordsLB.GetEntryText( pFirstSel, 0 );
//STRIP001  			aReplaceText = aWordsLB.GetEntryText( pFirstSel, 1 );
//STRIP001 
//STRIP001 			aNewReplaceText = sModify;
//STRIP001 			bEnableDelete = TRUE;
//STRIP001 		}
//STRIP001 		BOOL bIsChange =
//STRIP001 				CDE_EQUAL != cmpDicEntry_Impl(aWordED.GetText(), aWordText)
//STRIP001 			 || CDE_EQUAL != cmpDicEntry_Impl(aReplaceED.GetText(), aReplaceText);
//STRIP001 		if (aWordED.GetText().Len()  &&  bIsChange)
//STRIP001 			bEnableNewReplace = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aNewReplacePB.SetText( aNewReplaceText );
//STRIP001 	aNewReplacePB.Enable( bEnableNewReplace && !IsDicReadonly_Impl() );
//STRIP001 	aDeletePB	 .Enable( bEnableDelete     && !IsDicReadonly_Impl() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//=========================================================
//SvxDictEdit
//=========================================================
//STRIP001 void SvxDictEdit::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	const KeyCode aKeyCode = rKEvt.GetKeyCode();
//STRIP001 	const sal_uInt16 nModifier = aKeyCode.GetModifier();
//STRIP001 	if( aKeyCode.GetCode() == KEY_RETURN )
//STRIP001 	{
//STRIP001 		//wird bei Enter nichts getan, dann doch die Basisklasse rufen
//STRIP001 		// um den Dialog zu schliessen
//STRIP001 		if(!nModifier && !aActionLink.Call(this))
//STRIP001 				 Edit::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 	else if(bSpaces || aKeyCode.GetCode() != KEY_SPACE)
//STRIP001 		Edit::KeyInput(rKEvt);
//STRIP001 }


}
