/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_zoomctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:47:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SHL_HXX //autogen
// auto strip #include <tools/shl.hxx>
// auto strip #endif
#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
// auto strip #ifndef _MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#include "dialogs.hrc"

#include "zoomctrl.hxx"
// auto strip #include "zoom.hxx"
#include "zoomitem.hxx"
#include "stbctrls.h"
// auto strip #include "dialmgr.hxx"
namespace binfilter {

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SvxZoomStatusBarControl,SvxZoomItem);

// class ZoomPopup_Impl --------------------------------------------------

//STRIP001 class ZoomPopup_Impl : public PopupMenu
//STRIP001 {
//STRIP001 public:
//STRIP001 	ZoomPopup_Impl( USHORT nZ, USHORT nValueSet );
//STRIP001 
//STRIP001 	USHORT			GetZoom() const { return nZoom; }
//STRIP001 	USHORT			GetCurId() const { return nCurId; }
//STRIP001 
//STRIP001 private:
//STRIP001 	USHORT			nZoom;
//STRIP001 	USHORT			nCurId;
//STRIP001 
//STRIP001 	virtual void	Select();
//STRIP001 };

// -----------------------------------------------------------------------

//STRIP001 ZoomPopup_Impl::ZoomPopup_Impl( USHORT nZ, USHORT nValueSet )
//STRIP001 
//STRIP001 :	PopupMenu( ResId( RID_SVXMNU_ZOOM, DIALOG_MGR() ) ),
//STRIP001 
//STRIP001 	nZoom( nZ )
//STRIP001 {
//STRIP001 	static USHORT aTable[] =
//STRIP001 	{
//STRIP001 		SVX_ZOOM_ENABLE_50, 		ZOOM_50,
//STRIP001 		SVX_ZOOM_ENABLE_100,		ZOOM_100,
//STRIP001 		SVX_ZOOM_ENABLE_150,		ZOOM_150,
//STRIP001 		SVX_ZOOM_ENABLE_200,		ZOOM_200,
//STRIP001 		SVX_ZOOM_ENABLE_OPTIMAL,	ZOOM_OPTIMAL,
//STRIP001 		SVX_ZOOM_ENABLE_WHOLEPAGE,	ZOOM_WHOLE_PAGE,
//STRIP001 		SVX_ZOOM_ENABLE_PAGEWIDTH,	ZOOM_PAGE_WIDTH
//STRIP001 	};
//STRIP001 
//STRIP001 	for ( USHORT nPos = 0; nPos < sizeof(aTable) / sizeof(USHORT); nPos += 2 )
//STRIP001 		if ( ( aTable[nPos] != ( aTable[nPos] & nValueSet ) ) )
//STRIP001 			EnableItem( aTable[nPos+1], FALSE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ZoomPopup_Impl::Select()
//STRIP001 {
//STRIP001 	nCurId = GetCurItemId();
//STRIP001 
//STRIP001 	switch ( nCurId )
//STRIP001 	{
//STRIP001 		case ZOOM_200:			nZoom = 200; break;
//STRIP001 		case ZOOM_150:			nZoom = 150; break;
//STRIP001 		case ZOOM_100:			nZoom = 100; break;
//STRIP001 		case ZOOM_75:			nZoom =  75; break;
//STRIP001 		case ZOOM_50:			nZoom =  50; break;
//STRIP001 
//STRIP001 		case ZOOM_OPTIMAL:
//STRIP001 		case ZOOM_PAGE_WIDTH:
//STRIP001 		case ZOOM_WHOLE_PAGE:	nZoom = 0; break;
//STRIP001 
//STRIP001 	}
//STRIP001 }

// class SvxZoomStatusBarControl ------------------------------------------

/*N*/ SvxZoomStatusBarControl::SvxZoomStatusBarControl( USHORT nId,
/*N*/ 												  StatusBar& rStb,
/*N*/ 												  SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 
/*N*/ 	nZoom( 100 ),
/*N*/ 
/*N*/ 	nValueSet( SVX_ZOOM_ENABLE_ALL )
/*N*/ 
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxZoomStatusBarControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if( SFX_ITEM_AVAILABLE != eState )
/*N*/ 	{
/*N*/ 		GetStatusBar().SetItemText( GetId(), String() );
/*N*/ 		nValueSet = 0;
/*N*/ 	}
/*N*/ 	else if ( pState->ISA( SfxUInt16Item) )
/*N*/ 	{
/*N*/ 		const SfxUInt16Item* pItem = (const SfxUInt16Item*)pState;
/*N*/ 		nZoom = pItem->GetValue();
/*N*/ 		String aStr( String::CreateFromInt32(nZoom) );
/*N*/ 		aStr += '%';
/*N*/ 		GetStatusBar().SetItemText( GetId(), aStr );
/*N*/ 
/*N*/ 		if ( pState->ISA(SvxZoomItem) )
/*N*/ 		{
/*N*/ 			nValueSet = ((const SvxZoomItem*)pState)->GetValueSet();
/*N*/ 			SvxZoomType eType = ((const SvxZoomItem*)pState)->GetType();
/*N*/ 
/*!!!
			switch ( eType )
			{
				case SVX_ZOOM_OPTIMAL:
					GetStatusBar().SetItemText( GetId(), "Opt." );
					break;
				case SVX_ZOOM_WHOLEPAGE:
					GetStatusBar().SetItemText( GetId(), "Page" );
					break;
				case SVX_ZOOM_PAGEWIDTH:
					GetStatusBar().SetItemText( GetId(), "Width" );
					break;
			}
*/
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			DBG_WARNING( "use SfxZoomItem for SID_ATTR_ZOOM" );
/*N*/ 			nValueSet = SVX_ZOOM_ENABLE_ALL;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomStatusBarControl::Paint( const UserDrawEvent& rUsrEvt )
//STRIP001 {
//STRIP001 	String aStr( String::CreateFromInt32( nZoom ));
//STRIP001 	aStr += '%';
//STRIP001 	GetStatusBar().SetItemText( GetId(), aStr );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxZoomStatusBarControl::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	if ( COMMAND_CONTEXTMENU & rCEvt.GetCommand() && 0 != nValueSet )
//STRIP001 	{
//STRIP001 		CaptureMouse();
//STRIP001 		ZoomPopup_Impl aPop( nZoom, nValueSet );
//STRIP001 		StatusBar& rStatusbar = GetStatusBar();
//STRIP001 
//STRIP001 		if ( aPop.Execute( &rStatusbar, rCEvt.GetMousePosPixel() ) && ( nZoom != aPop.GetZoom() || !nZoom ) )
//STRIP001 		{
//STRIP001 			nZoom = aPop.GetZoom();
//STRIP001 			SvxZoomItem aZoom( SVX_ZOOM_PERCENT, nZoom, GetId() );
//STRIP001 
//STRIP001 			USHORT nId = aPop.GetCurId();
//STRIP001 
//STRIP001 			if ( ZOOM_OPTIMAL == nId )
//STRIP001 				aZoom.SetType( SVX_ZOOM_OPTIMAL );
//STRIP001 			else if ( ZOOM_PAGE_WIDTH == nId )
//STRIP001 				aZoom.SetType( SVX_ZOOM_PAGEWIDTH );
//STRIP001 			else if ( ZOOM_WHOLE_PAGE == nId )
//STRIP001 				aZoom.SetType( SVX_ZOOM_WHOLEPAGE );
//STRIP001 
//STRIP001 			GetBindings().GetDispatcher()->Execute( GetId(), SFX_CALLMODE_RECORD, &aZoom, 0L );
//STRIP001 		}
//STRIP001 		ReleaseMouse();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SfxStatusBarControl::Command( rCEvt );
//STRIP001 }

/*N*/ ULONG SvxZoomStatusBarControl::GetDefItemWidth(const StatusBar& rStb)
/*N*/ {
/*N*/ 	long nWidth1 =  rStb.GetTextWidth(String::CreateFromAscii("XXXXX%"));
/*N*/ 	return nWidth1;
/*N*/ }


}
