/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_grafctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:14:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_SIZE 0 
#define ITEMID_BRUSH 0
#define ITEMID_GRF_CROP SID_ATTR_GRAF_CROP

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _TOOLBOX_HXX //autogen
// auto strip #include <vcl/toolbox.hxx>
// auto strip #endif
// auto strip #ifndef _FIELD_HXX //autogen
// auto strip #include <vcl/field.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIXED_HXX
// auto strip #include <vcl/fixed.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX //autogen
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#ifndef _SFXTBXMGR_HXX //autogen
#include <bf_sfx2/tbxmgr.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _BASEDLGS_HXX
// auto strip #include <bf_sfx2/basedlgs.hxx>
// auto strip #endif

#include "svxids.hrc"
#include "grafctrl.hrc"
#include "dialogs.hrc"
// auto strip #include "brshitem.hxx"
// auto strip #include "sizeitem.hxx"

#ifndef _XDEF_HXX
#include "xdef.hxx"
#endif

// auto strip #include "sdgcpitm.hxx"
// auto strip #include "../dialog/grfpage.hxx"
// auto strip #include "itemwin.hxx"
// auto strip #include "dialmgr.hxx"
// auto strip #include "svdview.hxx"
// auto strip #include "svdmodel.hxx"
// auto strip #include "svdograf.hxx"
// auto strip #include "svdundo.hxx"
// auto strip #include "svdtrans.hxx"
#include "grafctrl.hxx"
namespace binfilter {

// -----------
// - Defines -
// -----------

#define SYMBOL_TO_FIELD_OFFSET		4
#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()

// ----------------
// - TbxImageItem -
// ----------------

/*N*/ TYPEINIT1( TbxImageItem, SfxUInt16Item );

//---------------------------------------------------------

/*N*/ TbxImageItem::TbxImageItem( USHORT nWhich, UINT16 nImage ) :
/*N*/ 	SfxUInt16Item( nWhich, nImage )
/*N*/ {
/*N*/ }

//---------------------------------------------------------

//STRIP001 SfxPoolItem* TbxImageItem::Clone( SfxItemPool* pPool ) const
//STRIP001 {
//STRIP001 	return new TbxImageItem( *this );
//STRIP001 }

//---------------------------------------------------------

//STRIP001 int TbxImageItem::operator==( const SfxPoolItem& rItem ) const
//STRIP001 {
//STRIP001 	return( ( (TbxImageItem&) rItem ).GetValue() == GetValue() );
//STRIP001 }

// -----------------------
// - ImplGrafMetricField -
// -----------------------

//STRIP001 class ImplGrafMetricField : public MetricField
//STRIP001 {
//STRIP001 private:
//STRIP001 	Timer			maTimer;
//STRIP001 	USHORT			mnSID;
//STRIP001 	SfxBindings&	mrBindings;
//STRIP001 
//STRIP001 					DECL_LINK( ImplModifyHdl, Timer* );
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	virtual void	Modify();
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					ImplGrafMetricField( Window* pParent, USHORT nSID, SfxBindings& rBindings );
//STRIP001 					~ImplGrafMetricField();
//STRIP001 
//STRIP001 	void			Update( const SfxPoolItem* pItem );
//STRIP001 	USHORT			GetSID() const { return mnSID; }
//STRIP001 };

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafMetricField::ImplGrafMetricField( Window* pParent, USHORT nSID, SfxBindings& rBindings ) :
//STRIP001 
//STRIP001 	MetricField( pParent, WB_BORDER | WB_SPIN | WB_REPEAT | WB_3DLOOK ),
//STRIP001 
//STRIP001 	mnSID		( nSID ),
//STRIP001 	mrBindings	( rBindings )
//STRIP001 
//STRIP001 {
//STRIP001 	Size aSize( GetTextWidth( String::CreateFromAscii("-100 %") ), GetTextHeight() );
//STRIP001 
//STRIP001 	aSize.Width() += 20, aSize.Height() += 6;
//STRIP001 	SetSizePixel( aSize );
//STRIP001 
//STRIP001 	if( SID_ATTR_GRAF_GAMMA == mnSID )
//STRIP001 	{
//STRIP001 		SetDecimalDigits( 2 );
//STRIP001 
//STRIP001 		SetMin( 10 );
//STRIP001 		SetFirst( 10 );
//STRIP001 		SetMax( 1000 );
//STRIP001 		SetLast( 1000 );
//STRIP001 		SetSpinSize( 10 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const long nMinVal = ( SID_ATTR_GRAF_TRANSPARENCE == mnSID ) ? 0 : -100;
//STRIP001 
//STRIP001 		SetUnit( FUNIT_CUSTOM );
//STRIP001 		SetCustomUnitText( String::CreateFromAscii(" %") );
//STRIP001 		SetDecimalDigits( 0 );
//STRIP001 
//STRIP001 		SetMin( nMinVal );
//STRIP001 		SetFirst( nMinVal );
//STRIP001 		SetMax( 100 );
//STRIP001 		SetLast( 100 );
//STRIP001 		SetSpinSize( 1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	maTimer.SetTimeout( 100 );
//STRIP001 	maTimer.SetTimeoutHdl( LINK( this, ImplGrafMetricField, ImplModifyHdl ) );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafMetricField::~ImplGrafMetricField()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void ImplGrafMetricField::Modify()
//STRIP001 {
//STRIP001 	maTimer.Start();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ImplGrafMetricField, ImplModifyHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	SfxPoolItem*	pItem;
//STRIP001 	const long		nVal = GetValue();
//STRIP001 
//STRIP001 	switch( mnSID )
//STRIP001 	{
//STRIP001 	case SID_ATTR_GRAF_RED:
//STRIP001 	case SID_ATTR_GRAF_GREEN:
//STRIP001 	case SID_ATTR_GRAF_BLUE:
//STRIP001 	case SID_ATTR_GRAF_LUMINANCE:
//STRIP001 	case SID_ATTR_GRAF_CONTRAST:
//STRIP001 		pItem = new SfxInt16Item( mnSID, (short) nVal );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case SID_ATTR_GRAF_GAMMA:
//STRIP001 		pItem = new SfxUInt32Item( mnSID, nVal );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case SID_ATTR_GRAF_TRANSPARENCE:
//STRIP001 		pItem = new SfxUInt16Item( mnSID, (USHORT) nVal );
//STRIP001 		break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		pItem = 0;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		mrBindings.GetDispatcher()->Execute( mnSID, SFX_CALLMODE_RECORD, pItem, 0L );
//STRIP001 		delete pItem;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void ImplGrafMetricField::Update( const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue;
//STRIP001 
//STRIP001 		switch( mnSID )
//STRIP001 		{
//STRIP001 		case SID_ATTR_GRAF_TRANSPARENCE:
//STRIP001 			nValue = ( (SfxUInt16Item*) pItem )->GetValue();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_GAMMA:
//STRIP001 			nValue = ( (SfxUInt32Item*) pItem )->GetValue();
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			nValue = ( (SfxInt16Item*) pItem )->GetValue();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		SetValue( nValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetText( String() );
//STRIP001 }

// --------------------
// - ImplGrafControl  -
// --------------------

//STRIP001 static USHORT ImplGetRID( USHORT nSID, bool bHighContrast )
//STRIP001 {
//STRIP001 	static const USHORT aImplSlotToResMap[][3] =
//STRIP001 	{
//STRIP001 		{ SID_ATTR_GRAF_RED, RID_SVXIMG_GRAF_RED, RID_SVXIMG_GRAF_RED_H },
//STRIP001 		{ SID_ATTR_GRAF_GREEN, RID_SVXIMG_GRAF_GREEN, RID_SVXIMG_GRAF_GREEN_H },
//STRIP001 		{ SID_ATTR_GRAF_BLUE, RID_SVXIMG_GRAF_BLUE, RID_SVXIMG_GRAF_BLUE_H },
//STRIP001 		{ SID_ATTR_GRAF_LUMINANCE, RID_SVXIMG_GRAF_LUMINANCE, RID_SVXIMG_GRAF_LUMINANCE_H },
//STRIP001 		{ SID_ATTR_GRAF_CONTRAST, RID_SVXIMG_GRAF_CONTRAST, RID_SVXIMG_GRAF_CONTRAST_H },
//STRIP001 		{ SID_ATTR_GRAF_GAMMA, RID_SVXIMG_GRAF_GAMMA, RID_SVXIMG_GRAF_GAMMA_H },
//STRIP001 		{ SID_ATTR_GRAF_TRANSPARENCE, RID_SVXIMG_GRAF_TRANSPARENCE, RID_SVXIMG_GRAF_TRANSPARENCE_H }
//STRIP001 	};
//STRIP001 
//STRIP001 	USHORT nRID = 0;
//STRIP001 
//STRIP001 	for( int i = 0,
//STRIP001 		nCount = sizeof( aImplSlotToResMap ) / ( sizeof( USHORT ) * 2 );
//STRIP001 			i < nCount; i++ )
//STRIP001 		if( aImplSlotToResMap[ i ][ 0 ] == nSID )
//STRIP001 		{
//STRIP001 			nRID = aImplSlotToResMap[ i ][ bHighContrast ? 2 : 1 ];
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	return nRID;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 class ImplGrafControl : public Control
//STRIP001 {
//STRIP001 private:
//STRIP001 	FixedImage				maImage;
//STRIP001 	ImplGrafMetricField		maField;
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	virtual void			GetFocus();
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 							ImplGrafControl( Window* pParent, USHORT nSID, SfxBindings& rBindings );
//STRIP001 							~ImplGrafControl();
//STRIP001 
//STRIP001 	void					Update( const SfxPoolItem* pItem ) { maField.Update( pItem ); }
//STRIP001 	void					SetText( const String& rStr ) { maField.SetText( rStr ); }
//STRIP001 };

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafControl::ImplGrafControl( Window* pParent, USHORT nSID, SfxBindings& rBindings ) :
//STRIP001 
//STRIP001 	Control( pParent, WB_TABSTOP ),
//STRIP001 
//STRIP001 	maImage		( this ),
//STRIP001 	maField		( this, nSID, rBindings )
//STRIP001 
//STRIP001 {
//STRIP001 	ResId	aResId( ImplGetRID( nSID, false ), DIALOG_MGR() ) ;
//STRIP001 	Image	aImage( aResId );
//STRIP001 
//STRIP001 	ResId	aResIdHC( ImplGetRID( nSID, true ), DIALOG_MGR() ) ;
//STRIP001 	Image	aImageHC( aResIdHC );
//STRIP001 
//STRIP001 	Size	aImgSize( aImage.GetSizePixel() );
//STRIP001 	Size	aFldSize( maField.GetSizePixel() );
//STRIP001 	long	nFldY, nImgY;
//STRIP001 
//STRIP001 	maImage.SetImage( aImage );
//STRIP001 	maImage.SetModeImage( aImageHC, BMP_COLOR_HIGHCONTRAST );
//STRIP001 	maImage.SetSizePixel( aImgSize );
//STRIP001 
//STRIP001 	if( aImgSize.Height() > aFldSize.Height() )
//STRIP001 		nImgY = 0, nFldY = ( aImgSize.Height() - aFldSize.Height() ) >> 1;
//STRIP001 	else
//STRIP001 		nFldY = 0, nImgY = ( aFldSize.Height() - aImgSize.Height() ) >> 1;
//STRIP001 
//STRIP001 	maImage.SetPosPixel( Point( 0, nImgY ) );
//STRIP001 	maField.SetPosPixel( Point( aImgSize.Width() + SYMBOL_TO_FIELD_OFFSET, nFldY ) );
//STRIP001 	SetSizePixel( Size( aImgSize.Width() + aFldSize.Width() + SYMBOL_TO_FIELD_OFFSET,
//STRIP001 				  Max( aImgSize.Height(), aFldSize.Height() ) ) );
//STRIP001 
//STRIP001 //	maImage.SetHelpId( nSID );
//STRIP001 	maImage.Show();
//STRIP001 
//STRIP001 	maField.SetHelpId( nSID );
//STRIP001 	maField.Show();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafControl::~ImplGrafControl()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void ImplGrafControl::GetFocus()
//STRIP001 {
//STRIP001 	maField.GrabFocus();
//STRIP001 }

// -----------------------
// - ImplGrafModeControl -
// -----------------------

//STRIP001 class ImplGrafModeControl : public ListBox
//STRIP001 {
//STRIP001 private:
//STRIP001 	USHORT			mnCurPos;
//STRIP001 	SfxBindings&	mrBindings;
//STRIP001 
//STRIP001 	virtual void 	Select();
//STRIP001 	virtual long	PreNotify( NotifyEvent& rNEvt );
//STRIP001 	virtual long	Notify( NotifyEvent& rNEvt );
//STRIP001 	void			ImplReleaseFocus();
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					ImplGrafModeControl( Window* pParent, SfxBindings& rBindings );
//STRIP001 					~ImplGrafModeControl();
//STRIP001 
//STRIP001 	void			Update( const SfxPoolItem* pItem );
//STRIP001 };

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafModeControl::ImplGrafModeControl( Window* pParent, SfxBindings& rBindings ) :
//STRIP001 
//STRIP001 	ListBox( pParent, WB_BORDER | WB_DROPDOWN | WB_AUTOHSCROLL ),
//STRIP001 
//STRIP001 	mnCurPos	( 0 ),
//STRIP001 	mrBindings	( rBindings )
//STRIP001 
//STRIP001 {
//STRIP001 	SetSizePixel( Size( 100, 260 ) );
//STRIP001 
//STRIP001 	InsertEntry( SVX_RESSTR( RID_SVXSTR_GRAFMODE_STANDARD ) );
//STRIP001 	InsertEntry( SVX_RESSTR( RID_SVXSTR_GRAFMODE_GREYS ) );
//STRIP001 	InsertEntry( SVX_RESSTR( RID_SVXSTR_GRAFMODE_MONO ) );
//STRIP001 	InsertEntry( SVX_RESSTR( RID_SVXSTR_GRAFMODE_WATERMARK ) );
//STRIP001 
//STRIP001 	Show();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ImplGrafModeControl::~ImplGrafModeControl()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ImplGrafModeControl::Select()
//STRIP001 {
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		SfxUInt16Item aGrafModeItem( SID_ATTR_GRAF_MODE, GetSelectEntryPos() );
//STRIP001 		mrBindings.GetDispatcher()->Execute( SID_ATTR_GRAF_MODE, SFX_CALLMODE_RECORD, &aGrafModeItem, 0L );
//STRIP001 		ImplReleaseFocus();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long ImplGrafModeControl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001 	if( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
//STRIP001 		mnCurPos = GetSelectEntryPos();
//STRIP001 
//STRIP001 	return ListBox::PreNotify( rNEvt );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long ImplGrafModeControl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = ListBox::Notify( rNEvt );
//STRIP001 
//STRIP001 	if( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001 		switch( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 			{
//STRIP001 				Select();
//STRIP001 				nHandled = 1;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 			{
//STRIP001 				SelectEntryPos( mnCurPos );
//STRIP001 				ImplReleaseFocus();
//STRIP001 				nHandled = 1;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ImplGrafModeControl::ImplReleaseFocus()
//STRIP001 {
//STRIP001 	Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 
//STRIP001 	if( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ImplGrafModeControl::Update( const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( pItem )
//STRIP001 		SelectEntryPos( ((SfxUInt16Item*)pItem)->GetValue() );
//STRIP001 	else
//STRIP001 		SetNoSelection();
//STRIP001 }

// -----------------------
// - ImplGrafFilterPopup -
// -----------------------

//STRIP001 class ImplGrafFilterPopup : public SfxPopupWindow
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	SvxGrafFilterToolBoxControl*	mpParent;
//STRIP001 	SfxToolBoxManager				maTbxMgr;
//STRIP001 	ResId							maResIdWin;
//STRIP001 	ResId							maResIdTbx;
//STRIP001 	WindowAlign						meTbxAlign;
//STRIP001 	Link							maSelectHdl;
//STRIP001 									
//STRIP001 									DECL_LINK( TbxSelectHdl, void* );
//STRIP001 									
//STRIP001 public:								
//STRIP001 									ImplGrafFilterPopup( USHORT nId, SvxGrafFilterToolBoxControl* pParent, 
//STRIP001 														 WindowAlign eAlign,
//STRIP001 														 const ResId& rResIdWin, const ResId& rResIdTbx, 
//STRIP001 														 SfxBindings& rBindings );
//STRIP001 									~ImplGrafFilterPopup();
//STRIP001 									
//STRIP001 	virtual SfxPopupWindow*			Clone() const;
//STRIP001 	virtual void					PopupModeEnd();
//STRIP001 									
//STRIP001 	void							StartSelection() { maTbxMgr.GetToolBox().StartSelection(); }
//STRIP001 	void							Update();
//STRIP001 };

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafFilterPopup::ImplGrafFilterPopup( USHORT nId, SvxGrafFilterToolBoxControl* pParent,
//STRIP001 										  WindowAlign eAlign,
//STRIP001 										  const ResId& rResIdWin, const ResId& rResIdTbx,
//STRIP001 										  SfxBindings& rBindings ) :
//STRIP001 	SfxPopupWindow	( nId, rResIdWin, rBindings ),
//STRIP001 	mpParent		( pParent ),
//STRIP001     maTbxMgr		( this, GetBindings(), rResIdTbx ),
//STRIP001     maResIdWin		( rResIdWin ),
//STRIP001     maResIdTbx      ( rResIdTbx ),
//STRIP001 	meTbxAlign		( eAlign )
//STRIP001 {
//STRIP001 	maTbxMgr.UseDefault();
//STRIP001 
//STRIP001 	maSelectHdl = maTbxMgr.GetToolBox().GetSelectHdl();
//STRIP001 	maTbxMgr.GetToolBox().SetSelectHdl( LINK( this, ImplGrafFilterPopup, TbxSelectHdl ) );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	const Size aSize( maTbxMgr.CalcWindowSizePixel() );
//STRIP001 	maTbxMgr.SetPosSizePixel( Point(), aSize );
//STRIP001 	SetOutputSizePixel( aSize );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 ImplGrafFilterPopup::~ImplGrafFilterPopup()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SfxPopupWindow* ImplGrafFilterPopup::Clone() const
//STRIP001 {
//STRIP001 	return( new ImplGrafFilterPopup( GetId(), mpParent, meTbxAlign, 
//STRIP001 									 maResIdWin, maResIdTbx, 
//STRIP001 									 (SfxBindings&) GetBindings() ) );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void ImplGrafFilterPopup::Update()
//STRIP001 {
//STRIP001 	ToolBox* pBox = &maTbxMgr.GetToolBox();
//STRIP001 	maTbxMgr.Activate( pBox );
//STRIP001 	maTbxMgr.Deactivate( pBox );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void ImplGrafFilterPopup::PopupModeEnd()
//STRIP001 {
//STRIP001 	maTbxMgr.GetToolBox().EndSelection();
//STRIP001 	SfxPopupWindow::PopupModeEnd();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ImplGrafFilterPopup, TbxSelectHdl, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	const USHORT nSlotId = maTbxMgr.GetToolBox().GetCurItemId();
//STRIP001 
//STRIP001 	if( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( nSlotId, SFX_CALLMODE_ASYNCHRON );
//STRIP001 	
//STRIP001 	return 0;
//STRIP001 }

// -------------------------------
// - SvxGrafFilterToolBoxControl -
// -------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafFilterToolBoxControl, TbxImageItem );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafFilterToolBoxControl::SvxGrafFilterToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ {
/*?*/ }

// -----------------------------------------------------------------------------
	
//STRIP001 SvxGrafFilterToolBoxControl::~SvxGrafFilterToolBoxControl()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafFilterToolBoxControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	GetToolBox().EnableItem( GetId(), ( eState != SFX_ITEM_DISABLED ) );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxGrafFilterToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SfxPopupWindow* SvxGrafFilterToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	ImplGrafFilterPopup* pWin = new ImplGrafFilterPopup( GetId(), this, GetToolBox().GetAlign(),
//STRIP001 														 SVX_RES( RID_SVXTBX_GRFFILTER ),
//STRIP001 														 SVX_RES( TBX_GRFFILTER ),
//STRIP001 														 GetBindings() );
//STRIP001 	pWin->StartPopupMode( &GetToolBox(), TRUE );
//STRIP001 	pWin->StartSelection();
//STRIP001 	pWin->Show();
//STRIP001 	
//STRIP001 	return pWin;
//STRIP001 }

// -------------------------
// - SvxGrafToolBoxControl -
// -------------------------

//STRIP001 SFX_IMPL_TOOLBOX_CONTROL( SvxGrafToolBoxControl, SfxVoidItem );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafToolBoxControl::SvxGrafToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl	( nId, rTbx, rBind )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 	SfxModule*		pModule = pSfxApp->GetActiveModule();
//STRIP001 
//STRIP001 	if( pModule )
//STRIP001 		StartListening( rBind, TRUE );
//STRIP001 	else
//STRIP001 		StartListening( *pSfxApp , TRUE );
//STRIP001 
/*?*/ }

// -----------------------------------------------------------------------------

//STRIP001 SvxGrafToolBoxControl::~SvxGrafToolBoxControl()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafToolBoxControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	ImplGrafControl* pCtrl = (ImplGrafControl*) GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pCtrl, "Control not found" );
//STRIP001 
//STRIP001 	if( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pCtrl->Disable();
//STRIP001 		pCtrl->SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pCtrl->Enable();
//STRIP001 
//STRIP001 		if( eState == SFX_ITEM_AVAILABLE )
//STRIP001 			pCtrl->Update( pState );
//STRIP001 		else
//STRIP001 			pCtrl->Update( NULL );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 										const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Window* SvxGrafToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	return( new ImplGrafControl( pParent, GetId(), GetBindings() ) );
//STRIP001 }

// ----------------------------
// - SvxGrafRedToolBoxControl -
// ----------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafRedToolBoxControl, SfxInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafRedToolBoxControl::SvxGrafRedToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// ------------------------------
// - SvxGrafGreenToolBoxControl -
// ------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafGreenToolBoxControl, SfxInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafGreenToolBoxControl::SvxGrafGreenToolBoxControl(	USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// -----------------------------
// - SvxGrafBlueToolBoxControl -
// -----------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafBlueToolBoxControl, SfxInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafBlueToolBoxControl::SvxGrafBlueToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// ----------------------------------
// - SvxGrafLuminanceToolBoxControl -
// ----------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafLuminanceToolBoxControl, SfxInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafLuminanceToolBoxControl::SvxGrafLuminanceToolBoxControl( USHORT nId, ToolBox& rTbx,
/*?*/ 																SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// ----------------------------------
// - SvxGrafContrastToolBoxControl -
// ----------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafContrastToolBoxControl, SfxInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafContrastToolBoxControl::SvxGrafContrastToolBoxControl( USHORT nId, ToolBox& rTbx,
/*?*/ 															  SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// ------------------------------
// - SvxGrafGammaToolBoxControl -
// ------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafGammaToolBoxControl, SfxUInt32Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafGammaToolBoxControl::SvxGrafGammaToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// -------------------------------------
// - SvxGrafTransparenceToolBoxControl -
// -------------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafTransparenceToolBoxControl, SfxUInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafTransparenceToolBoxControl::SvxGrafTransparenceToolBoxControl( USHORT nId, ToolBox& rTbx,
/*?*/ 																	  SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SvxGrafToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ }

// -----------------------------
// - SvxGrafModeToolBoxControl -
// -----------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxGrafModeToolBoxControl, SfxUInt16Item );

// -----------------------------------------------------------------------------

/*?*/ SvxGrafModeToolBoxControl::SvxGrafModeToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ 
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 	SfxModule*		pModule = pSfxApp->GetActiveModule();
//STRIP001 
//STRIP001 	if( pModule )
//STRIP001 		StartListening( rBind, TRUE );
//STRIP001 	else
//STRIP001 		StartListening( *pSfxApp , TRUE );
/*?*/ }

// -----------------------------------------------------------------------------

//STRIP001 SvxGrafModeToolBoxControl::~SvxGrafModeToolBoxControl()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafModeToolBoxControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	ImplGrafModeControl* pCtrl = (ImplGrafModeControl*) GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pCtrl, "Control not found" );
//STRIP001 
//STRIP001 	if( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pCtrl->Disable();
//STRIP001 		pCtrl->SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pCtrl->Enable();
//STRIP001 
//STRIP001 		if( eState == SFX_ITEM_AVAILABLE )
//STRIP001 			pCtrl->Update( pState );
//STRIP001 		else
//STRIP001 			pCtrl->Update( NULL );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafModeToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 											const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Window* SvxGrafModeToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	return( new ImplGrafModeControl( pParent, GetBindings() ) );
//STRIP001 }

// ---------------------
// - SvxGrafAttrHelper -
// ---------------------

//STRIP001 void SvxGrafAttrHelper::ExecuteGrafAttr( SfxRequest& rReq, SdrView& rView )
//STRIP001 {
//STRIP001 	SfxItemPool&	rPool = rView.GetModel()->GetItemPool();
//STRIP001 	SfxItemSet		aSet( rPool, SDRATTR_GRAF_FIRST, SDRATTR_GRAF_LAST-1 );
//STRIP001 
//STRIP001     String				aUndoStr( rView.GetMarkDescription() );
//STRIP001 	const SfxItemSet*	pArgs = rReq.GetArgs();
//STRIP001     const SfxPoolItem*	pItem;
//STRIP001     USHORT				nSlot = rReq.GetSlot();
//STRIP001 	BOOL				bGeometryChanged = FALSE;
//STRIP001     
//STRIP001 	if( !pArgs || SFX_ITEM_SET != pArgs->GetItemState( nSlot, FALSE, &pItem ))
//STRIP001 		pItem = 0;
//STRIP001 
//STRIP001 	aUndoStr.Append( sal_Unicode(' ') );
//STRIP001 
//STRIP001 	switch( nSlot )
//STRIP001 	{
//STRIP001 		case SID_ATTR_GRAF_RED:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafRedItem( ((SfxInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFRED ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_GREEN:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafGreenItem( ((SfxInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFGREEN ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_BLUE:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafBlueItem( ((SfxInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFBLUE ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_LUMINANCE:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafLuminanceItem( ((SfxInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFLUMINANCE ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_CONTRAST:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafContrastItem( ((SfxInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFCONTRAST ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_GAMMA:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafGamma100Item( ((SfxUInt32Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFGAMMA ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_TRANSPARENCE:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafTransparenceItem( ((SfxUInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFTRANSPARENCY ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_GRAF_MODE:
//STRIP001 		{
//STRIP001 			if( pItem )
//STRIP001 			{
//STRIP001 				aSet.Put( SdrGrafModeItem( (GraphicDrawMode) ((SfxUInt16Item*)pItem)->GetValue() ));
//STRIP001 				aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFMODE ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( SID_ATTR_GRAF_CROP ):
//STRIP001 		{
//STRIP001 			SdrGrafObj* pObj = (SdrGrafObj*) rView.GetMarkList().GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001 			if( pObj && pObj->ISA( SdrGrafObj ) && 
//STRIP001 				( pObj->GetGraphicType() != GRAPHIC_NONE ) && 
//STRIP001 				( pObj->GetGraphicType() != GRAPHIC_DEFAULT ) )
//STRIP001 			{
//STRIP001 				SfxItemSet			aGrfAttr( rPool, SDRATTR_GRAFCROP, SDRATTR_GRAFCROP, 0 );
//STRIP001 				const SfxMapUnit	eOldMetric = rPool.GetMetric( 0 );
//STRIP001 				const MapMode		aMap100( MAP_100TH_MM );
//STRIP001 				const MapMode		aMapTwip( MAP_TWIP );
//STRIP001 
//STRIP001 				aGrfAttr.Put(pObj->GetItemSet());
//STRIP001 				rPool.SetDefaultMetric( SFX_MAPUNIT_TWIP );
//STRIP001 				
//STRIP001 				SfxItemSet	aCropDlgAttr( rPool,
//STRIP001 										  SDRATTR_GRAFCROP, SDRATTR_GRAFCROP,
//STRIP001 										  SID_ATTR_GRAF_GRAPHIC, SID_ATTR_GRAF_GRAPHIC,
//STRIP001 										  SID_ATTR_PAGE_SIZE, SID_ATTR_PAGE_SIZE,
//STRIP001 										  SID_ATTR_GRAF_FRMSIZE, SID_ATTR_GRAF_FRMSIZE,
//STRIP001 										  SID_ATTR_GRAF_CROP, SID_ATTR_GRAF_CROP, 0 );
//STRIP001 	
//STRIP001 				aCropDlgAttr.Put( SvxBrushItem( pObj->GetGraphic(), GPOS_MM, SID_ATTR_GRAF_GRAPHIC ) );
//STRIP001 				aCropDlgAttr.Put( SvxSizeItem( SID_ATTR_PAGE_SIZE, 
//STRIP001 											   Size( OutputDevice::LogicToLogic( 
//STRIP001 													 Size( 200000, 200000 ), aMap100, aMapTwip ) ) ) );
//STRIP001 				aCropDlgAttr.Put( SvxSizeItem( SID_ATTR_GRAF_FRMSIZE, OutputDevice::LogicToLogic( 
//STRIP001 											   pObj->GetLogicRect().GetSize(), aMap100, aMapTwip ) ) );
//STRIP001 
//STRIP001 				const SdrGrafCropItem&	rCrop = (const SdrGrafCropItem&) aGrfAttr.Get( SDRATTR_GRAFCROP );
//STRIP001 				Size					aLTSize( OutputDevice::LogicToLogic( 
//STRIP001 												 Size( rCrop.GetLeft(), rCrop.GetTop() ), aMap100, aMapTwip ) );
//STRIP001 				Size					aRBSize( OutputDevice::LogicToLogic( 
//STRIP001 												 Size( rCrop.GetRight(), rCrop.GetBottom() ), aMap100, aMapTwip ) );
//STRIP001 				
//STRIP001 				aCropDlgAttr.Put( SdrGrafCropItem( aLTSize.Width(), aLTSize.Height(),
//STRIP001 												   aRBSize.Width(), aRBSize.Height() ) );
//STRIP001 		
//STRIP001 				SfxSingleTabDialog	aCropDialog( SfxViewShell::Current() ? SfxViewShell::Current()->GetWindow() : NULL, 
//STRIP001 												 aCropDlgAttr, 950 );
//STRIP001 				const String		aCropStr = SVX_RESSTR( RID_SVXSTR_GRAFCROP );
//STRIP001 				SfxTabPage*			pTabPage = SvxGrfCropPage::Create( &aCropDialog, aCropDlgAttr );
//STRIP001 
//STRIP001 				pTabPage->SetText( aCropStr );
//STRIP001 				aCropDialog.SetTabPage( pTabPage );
//STRIP001 
//STRIP001 				if( aCropDialog.Execute() == RET_OK )
//STRIP001 				{
//STRIP001 					const SfxItemSet* pOutAttr = aCropDialog.GetOutputItemSet();
//STRIP001 
//STRIP001 					if( pOutAttr )
//STRIP001 					{
//STRIP001 						aUndoStr.Append( String( SVX_RESSTR( RID_SVXSTR_UNDO_GRAFCROP ) ) );
//STRIP001 
//STRIP001 						// set crop attributes
//STRIP001 						if( SFX_ITEM_SET <= pOutAttr->GetItemState( SDRATTR_GRAFCROP ) )
//STRIP001 						{
//STRIP001 							const SdrGrafCropItem& rNewCrop = (const SdrGrafCropItem&) pOutAttr->Get( SDRATTR_GRAFCROP );
//STRIP001 							
//STRIP001 							aLTSize = OutputDevice::LogicToLogic( Size( rNewCrop.GetLeft(), rNewCrop.GetTop() ), aMapTwip, aMap100 );
//STRIP001 							aRBSize = OutputDevice::LogicToLogic( Size( rNewCrop.GetRight(), rNewCrop.GetBottom() ), aMapTwip, aMap100 );
//STRIP001 							aSet.Put( SdrGrafCropItem( aLTSize.Width(), aLTSize.Height(), aRBSize.Width(), aRBSize.Height() ) );
//STRIP001 						}
//STRIP001 
//STRIP001 						// set new logic rect
//STRIP001 						if( SFX_ITEM_SET <= pOutAttr->GetItemState( SID_ATTR_GRAF_FRMSIZE ) )
//STRIP001 						{
//STRIP001 							Point		aNewOrigin( pObj->GetLogicRect().TopLeft() );
//STRIP001 							const Size&	rGrfSize = ( (const SvxSizeItem&) pOutAttr->Get( SID_ATTR_GRAF_FRMSIZE ) ).GetSize();
//STRIP001 							Size		aNewGrfSize( OutputDevice::LogicToLogic( rGrfSize, aMapTwip, aMap100 ) );
//STRIP001 							Size		aOldGrfSize( pObj->GetLogicRect().GetSize() );
//STRIP001 
//STRIP001 							Rectangle aNewRect( aNewOrigin, aNewGrfSize );
//STRIP001                             Point aOffset( (aNewGrfSize.Width() - aOldGrfSize.Width()) >> 1,
//STRIP001                                            (aNewGrfSize.Height() - aOldGrfSize.Height()) >> 1 );
//STRIP001 
//STRIP001                             // #106181# rotate snap rect before setting it
//STRIP001                             const GeoStat& aGeo = pObj->GetGeoStat();
//STRIP001                             
//STRIP001                             if (aGeo.nDrehWink!=0 || aGeo.nShearWink!=0) 
//STRIP001                             {
//STRIP001                                 Polygon aPol(aNewRect);
//STRIP001 
//STRIP001                                 // also transform origin offset
//STRIP001                                 if (aGeo.nShearWink!=0)
//STRIP001                                 {
//STRIP001                                     ShearPoly(aPol,
//STRIP001                                               aNewRect.TopLeft(),
//STRIP001                                               aGeo.nTan);
//STRIP001                                     ShearPoint(aOffset, Point(0,0), aGeo.nTan);
//STRIP001                                 }
//STRIP001                                 if (aGeo.nDrehWink!=0) 
//STRIP001                                 {
//STRIP001                                     RotatePoly(aPol,
//STRIP001                                                aNewRect.TopLeft(),
//STRIP001                                                aGeo.nSin,aGeo.nCos);
//STRIP001                                     RotatePoint(aOffset, Point(0,0), aGeo.nSin,aGeo.nCos);
//STRIP001                                 }
//STRIP001 
//STRIP001                                 // apply offset
//STRIP001                                 aPol.Move( -aOffset.X(), -aOffset.Y() );
//STRIP001                                 aNewRect=aPol.GetBoundRect();
//STRIP001                             } 
//STRIP001                             else
//STRIP001                             {
//STRIP001                                 aNewRect.Move( -aOffset.X(), -aOffset.Y() );
//STRIP001                             }
//STRIP001 
//STRIP001 							if( !aSet.Count() )
//STRIP001 								rView.SetMarkedObjRect( aNewRect );
//STRIP001 							else
//STRIP001 							{
//STRIP001 								rView.BegUndo( aUndoStr );
//STRIP001 								rView.AddUndo( new SdrUndoGeoObj( *pObj ) );
//STRIP001 								pObj->SetSnapRect( aNewRect );	
//STRIP001 								rView.SetAttributes( aSet );
//STRIP001 								rView.EndUndo();
//STRIP001 								aSet.ClearItem();
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				rPool.SetDefaultMetric( eOldMetric );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aSet.Count() )
//STRIP001 	{
//STRIP001 		rView.BegUndo( aUndoStr );
//STRIP001 		rView.SetAttributes( aSet );
//STRIP001 		rView.EndUndo();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SvxGrafAttrHelper::GetGrafAttrState( SfxItemSet& rSet, SdrView& rView )
//STRIP001 {
//STRIP001 	SfxItemPool&	rPool = rView.GetModel()->GetItemPool();
//STRIP001 	SfxItemSet		aAttrSet( rPool );
//STRIP001 	SfxWhichIter	aIter( rSet );
//STRIP001 	USHORT			nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	rView.GetAttributes( aAttrSet );
//STRIP001 
//STRIP001 	while( nWhich )
//STRIP001 	{
//STRIP001 		USHORT nSlotId = SfxItemPool::IsWhich( nWhich ) ? rPool.GetSlotId( nWhich ) : nWhich;
//STRIP001 
//STRIP001 		switch( nSlotId )
//STRIP001 		{
//STRIP001 			case( SID_ATTR_GRAF_MODE ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFMODE ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxUInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFMODE, SdrGrafModeItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_RED ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFRED ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFRED, SdrGrafRedItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_GREEN ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFGREEN ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFGREEN, SdrGrafGreenItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_BLUE ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFBLUE ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFBLUE, SdrGrafBlueItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_LUMINANCE ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFLUMINANCE ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFLUMINANCE, SdrGrafLuminanceItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_CONTRAST ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFCONTRAST ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxInt16Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFCONTRAST, SdrGrafContrastItem ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_GAMMA ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFGAMMA ) )
//STRIP001 				{
//STRIP001 					rSet.Put( SfxUInt32Item( nSlotId,
//STRIP001 						ITEMVALUE( aAttrSet, SDRATTR_GRAFGAMMA, SdrGrafGamma100Item ) ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_TRANSPARENCE ):
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_AVAILABLE <= aAttrSet.GetItemState( SDRATTR_GRAFTRANSPARENCE ) )
//STRIP001 				{
//STRIP001 					const SdrMarkList&	rMarkList = rView.GetMarkList();
//STRIP001 					BOOL				bEnable = TRUE;
//STRIP001 
//STRIP001 					for( USHORT i = 0, nCount = (USHORT) rMarkList.GetMarkCount();
//STRIP001 						 ( i < nCount ) && bEnable; i++ )
//STRIP001 					{
//STRIP001 						SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001 						if( !pObj || !pObj->ISA( SdrGrafObj ) ||
//STRIP001 							( (SdrGrafObj*) pObj )->HasGDIMetaFile() ||
//STRIP001 							( (SdrGrafObj*) pObj )->IsAnimated() )
//STRIP001 						{
//STRIP001 							bEnable = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if( bEnable )
//STRIP001 						rSet.Put( SfxUInt16Item( nSlotId,
//STRIP001 							ITEMVALUE( aAttrSet, SDRATTR_GRAFTRANSPARENCE, SdrGrafTransparenceItem ) ) );
//STRIP001 					else
//STRIP001 						rSet.DisableItem( SID_ATTR_GRAF_TRANSPARENCE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SID_ATTR_GRAF_CROP ):
//STRIP001 			{
//STRIP001 				const SdrMarkList&	rMarkList = rView.GetMarkList();
//STRIP001 				BOOL				bDisable = TRUE;
//STRIP001 
//STRIP001 				if( 1 == rMarkList.GetMarkCount() )
//STRIP001 				{
//STRIP001 					SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001 					if( pObj && pObj->ISA( SdrGrafObj ) )
//STRIP001 					{
//STRIP001 						SdrGrafObj* pGrafObj = (SdrGrafObj*) pObj;
//STRIP001 
//STRIP001 						if(	( pGrafObj->GetGraphicType() != GRAPHIC_NONE ) && 
//STRIP001 							( pGrafObj->GetGraphicType() != GRAPHIC_DEFAULT ) )
//STRIP001 						{
//STRIP001 							bDisable = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if( bDisable )
//STRIP001 					rSet.DisableItem( SID_ATTR_GRAF_CROP );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
}
