/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_column.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:13:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include "uiparam.hxx"
//STRIP001 #include "hintids.hxx"
//STRIP001 
//STRIP001 #ifndef _SVX_HTMLMODE_HXX //autogen
//STRIP001 #include <bf_svx/htmlmode.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_BOXITEM_HXX //autogen
//STRIP001 #include <bf_svx/boxitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_LRSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/lrspitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SIZEITEM_HXX //autogen
//STRIP001 #include <bf_svx/sizeitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_FRMDIRITEM_HXX
//STRIP001 #include "bf_svx/frmdiritem.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _SVTOOLS_CTLOPTIONS_HXX
//STRIP001 #include <svtools/ctloptions.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include <helpid.h>
//STRIP001 #include "globals.hrc"
//STRIP001 #include "swtypes.hxx"
//STRIP001 #include "wrtsh.hxx"
//STRIP001 #include "view.hxx"
//STRIP001 #include "docsh.hxx"
//STRIP001 #include "uitool.hxx"
//STRIP001 #include "cmdid.h"
//STRIP001 #include "viewopt.hxx"
//STRIP001 #include "format.hxx"
//STRIP001 #include "frmmgr.hxx"
//STRIP001 #include "frmdlg.hxx"
//STRIP001 #include "column.hxx"
//STRIP001 #include "colmgr.hxx"
//STRIP001 #include "prcntfld.hxx"
//STRIP001 #include "linetype.hxx"
//STRIP001 #include "paratr.hxx"
//STRIP001 #include "frmui.hrc"
//STRIP001 #include "poolfmt.hrc"
//STRIP001 #include "column.hrc"
//STRIP001 #ifndef _SECTION_HXX //autogen
//STRIP001 #include <section.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCARY_HXX
//STRIP001 #include <docary.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _PAGEDESC_HXX //autogen
//STRIP001 #include <pagedesc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXDISPATCH_HXX //autogen
//STRIP001 #include <bf_sfx2/dispatch.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define FRAME_FORMAT_WIDTH 1000
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:  Statische Daten
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 static const USHORT __FAR_DATA nLines[] = {
//STRIP001 	LIN_1,
//STRIP001 	LIN_2,
//STRIP001 	LIN_3,
//STRIP001 	LIN_4,
//STRIP001 	LIN_5
//STRIP001 };
//STRIP001 
//STRIP001 static const USHORT nLineCount = sizeof(nLines) / sizeof(nLines[0]);
//STRIP001 static const nVisCols = 3;
//STRIP001 
//STRIP001 inline BOOL IsMarkInSameSection( SwWrtShell& rWrtSh, const SwSection* pSect )
//STRIP001 {
//STRIP001 	rWrtSh.SwapPam();
//STRIP001 	BOOL bRet = pSect == rWrtSh.GetCurrSection();
//STRIP001 	rWrtSh.SwapPam();
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwColumnDlg::SwColumnDlg(Window* pParent, SwWrtShell& rSh) :
//STRIP001 	SfxModalDialog(pParent, SW_RES(DLG_COLUMN)),
//STRIP001 	aOK(this, 		ResId(PB_OK)),
//STRIP001 	aCancel(this, 	ResId(PB_CANCEL)),
//STRIP001 	aHelp(this, 	ResId(PB_HELP)),
//STRIP001 	aApplyToFT(this, ResId(FT_APPLY_TO)),
//STRIP001 	aApplyToLB(this, ResId(LB_APPLY_TO)),
//STRIP001 	rWrtShell(rSh),
//STRIP001 	pPageSet(0),
//STRIP001 	pSectionSet(0),
//STRIP001 	pSelectionSet(0),
//STRIP001 	pFrameSet(0),
//STRIP001 	nOldSelection(0),
//STRIP001 	bPageChanged(FALSE),
//STRIP001 	nSelectionWidth(0),
//STRIP001 	bSectionChanged(FALSE),
//STRIP001 	bSelSectionChanged(FALSE),
//STRIP001 	bFrameChanged(FALSE)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SwRect aRect;
//STRIP001 	rWrtShell.CalcBoundRect(aRect, FLY_IN_CNTNT);
//STRIP001 
//STRIP001 	nSelectionWidth = aRect.Width();
//STRIP001 
//STRIP001 	SfxItemSet* pColPgSet = 0;
//STRIP001 	static USHORT __READONLY_DATA aSectIds[] = { RES_COL, RES_COL,
//STRIP001 												RES_FRM_SIZE, RES_FRM_SIZE,
//STRIP001                                                 RES_COLUMNBALANCE, RES_FRAMEDIR,
//STRIP001 												0 };
//STRIP001 
//STRIP001 	const SwSection* pCurrSection = rWrtShell.GetCurrSection();
//STRIP001 	USHORT nFullSectCnt = rWrtShell.GetFullSelectedSectionCount();
//STRIP001 	if( pCurrSection && ( !rWrtShell.HasSelection() || 0 != nFullSectCnt ))
//STRIP001 	{
//STRIP001 		nSelectionWidth = rSh.GetSectionWidth(*pCurrSection->GetFmt());
//STRIP001 		if ( !nSelectionWidth )
//STRIP001 			nSelectionWidth = USHRT_MAX;
//STRIP001 		pSectionSet = new SfxItemSet( rWrtShell.GetAttrPool(), aSectIds );
//STRIP001 		pSectionSet->Put( pCurrSection->GetFmt()->GetAttrSet() );
//STRIP001 		pColPgSet = pSectionSet;
//STRIP001 		aApplyToLB.RemoveEntry( aApplyToLB.GetEntryPos(
//STRIP001 										(void*)( 1 >= nFullSectCnt
//STRIP001 													? LISTBOX_SECTIONS
//STRIP001 													: LISTBOX_SECTION )));
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aApplyToLB.RemoveEntry(aApplyToLB.GetEntryPos( (void*) LISTBOX_SECTION ));
//STRIP001 		aApplyToLB.RemoveEntry(aApplyToLB.GetEntryPos( (void*) LISTBOX_SECTIONS ));
//STRIP001 	}
//STRIP001 
//STRIP001 	if( rWrtShell.HasSelection() && rWrtShell.IsInsRegionAvailable() &&
//STRIP001 		( !pCurrSection || ( 1 != nFullSectCnt &&
//STRIP001 			IsMarkInSameSection( rWrtShell, pCurrSection ) )))
//STRIP001 	{
//STRIP001 		pSelectionSet = new SfxItemSet( rWrtShell.GetAttrPool(), aSectIds );
//STRIP001 		pColPgSet = pSelectionSet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aApplyToLB.RemoveEntry(aApplyToLB.GetEntryPos( (void*) LISTBOX_SELECTION ));
//STRIP001 
//STRIP001 	if( rWrtShell.GetFlyFrmFmt() )
//STRIP001 	{
//STRIP001 		const SwFrmFmt* pFmt = rSh.GetFlyFrmFmt() ;
//STRIP001 		pFrameSet = new SfxItemSet(rWrtShell.GetAttrPool(), aSectIds );
//STRIP001 		pFrameSet->Put(pFmt->GetFrmSize());
//STRIP001 		pFrameSet->Put(pFmt->GetCol());
//STRIP001 		pColPgSet = pFrameSet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aApplyToLB.RemoveEntry(aApplyToLB.GetEntryPos( (void*) LISTBOX_FRAME ));
//STRIP001 
//STRIP001 
//STRIP001 	USHORT nPagePos = aApplyToLB.GetEntryPos( (void*) LISTBOX_PAGE );
//STRIP001 	const SwPageDesc* pPageDesc = rWrtShell.GetSelectedPageDescs();
//STRIP001 	if( pPageDesc )
//STRIP001 	{
//STRIP001 		pPageSet = new SfxItemSet( rWrtShell.GetAttrPool(),
//STRIP001 									RES_COL, RES_COL,
//STRIP001 									RES_FRM_SIZE, RES_FRM_SIZE,
//STRIP001 									RES_LR_SPACE, RES_LR_SPACE,
//STRIP001 									0 );
//STRIP001 
//STRIP001 		String sPageStr = aApplyToLB.GetEntry(nPagePos);
//STRIP001 		aApplyToLB.RemoveEntry( nPagePos );
//STRIP001 		sPageStr += pPageDesc->GetName();
//STRIP001 		aApplyToLB.InsertEntry( sPageStr, nPagePos );
//STRIP001 		aApplyToLB.SetEntryData( nPagePos, (void*) LISTBOX_PAGE);
//STRIP001 
//STRIP001 		const SwFrmFmt &rFmt = pPageDesc->GetMaster();
//STRIP001 		nPageWidth = rFmt.GetFrmSize().GetSize().Width();
//STRIP001 
//STRIP001 		const SvxLRSpaceItem& rLRSpace = (const SvxLRSpaceItem&)rFmt.GetLRSpace();
//STRIP001         const SvxBoxItem& rBox = (const SvxBoxItem&) rFmt.GetBox();
//STRIP001         nPageWidth -= rLRSpace.GetLeft() + rLRSpace.GetRight() + rBox.GetDistance();
//STRIP001 
//STRIP001 		pPageSet->Put(rFmt.GetCol());
//STRIP001 		pPageSet->Put(rFmt.GetLRSpace());
//STRIP001 		pColPgSet = pPageSet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aApplyToLB.RemoveEntry( nPagePos );
//STRIP001 
//STRIP001 
//STRIP001 	ASSERT( pColPgSet, "" );
//STRIP001 	// TabPage erzeugen
//STRIP001 	SwColumnPage* pPage = (SwColumnPage*) SwColumnPage::Create( this,
//STRIP001 																*pColPgSet );
//STRIP001 	pTabPage = pPage;
//STRIP001 
//STRIP001 	//Groesse anpassen
//STRIP001 	Size aPageSize(pTabPage->GetSizePixel());
//STRIP001 	Size aDlgSize(GetOutputSizePixel());
//STRIP001 	aDlgSize.Height() = aPageSize.Height();
//STRIP001 	SetOutputSizePixel(aDlgSize);
//STRIP001 	pTabPage->Show();
//STRIP001 
//STRIP001 	aApplyToLB.SelectEntryPos(0);
//STRIP001 	ObjectHdl(0);
//STRIP001 
//STRIP001 	aApplyToLB.SetSelectHdl(LINK(this, SwColumnDlg, ObjectHdl));
//STRIP001 	aOK.SetClickHdl(LINK(this, SwColumnDlg, OkHdl));
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwColumnDlg::~SwColumnDlg()
//STRIP001 {
//STRIP001 	delete pTabPage;
//STRIP001 	delete pPageSet;
//STRIP001 	delete pSectionSet;
//STRIP001 	delete pSelectionSet;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------26.05.99 11:40-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK(SwColumnDlg, ObjectHdl, ListBox*, pBox)
//STRIP001 {
//STRIP001 	SfxItemSet* pSet = 0;
//STRIP001 	switch(nOldSelection)
//STRIP001 	{
//STRIP001 		case LISTBOX_SELECTION  :
//STRIP001 			pSet = pSelectionSet;
//STRIP001 		break;
//STRIP001 		case LISTBOX_SECTION	:
//STRIP001 			pSet = pSectionSet;
//STRIP001 			bSectionChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_SECTIONS	:
//STRIP001 			pSet = pSectionSet;
//STRIP001 			bSelSectionChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_PAGE		:
//STRIP001 			pSet = pPageSet;
//STRIP001 			bPageChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_FRAME:
//STRIP001 			pSet = pFrameSet;
//STRIP001 			bFrameChanged = TRUE;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	if(pBox)
//STRIP001 	{
//STRIP001 		pTabPage->FillItemSet(*pSet);
//STRIP001 	}
//STRIP001 	nOldSelection = (long)aApplyToLB.GetEntryData(aApplyToLB.GetSelectEntryPos());
//STRIP001 	long nWidth = nSelectionWidth;
//STRIP001 	switch(nOldSelection)
//STRIP001 	{
//STRIP001 		case LISTBOX_SELECTION  :
//STRIP001 			pSet = pSelectionSet;
//STRIP001 			pSet->Put(SwFmtFrmSize(ATT_VAR_SIZE, nWidth, nWidth));
//STRIP001 		break;
//STRIP001 		case LISTBOX_SECTION	:
//STRIP001 		case LISTBOX_SECTIONS	:
//STRIP001 			pSet = pSectionSet;
//STRIP001 			pSet->Put(SwFmtFrmSize(ATT_VAR_SIZE, nWidth, nWidth));
//STRIP001 		break;
//STRIP001 		case LISTBOX_PAGE		:
//STRIP001 			nWidth = nPageWidth;
//STRIP001 			pSet = pPageSet;
//STRIP001 			pSet->Put(SwFmtFrmSize(ATT_VAR_SIZE, nWidth, nWidth));
//STRIP001 		break;
//STRIP001 		case LISTBOX_FRAME:
//STRIP001 			pSet = pFrameSet;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001     BOOL bIsSection = pSet == pSectionSet || pSet == pSelectionSet;
//STRIP001     pTabPage->ShowBalance(bIsSection);
//STRIP001     pTabPage->SetInSection(bIsSection);
//STRIP001     pTabPage->SetFrmMode(TRUE);
//STRIP001 	pTabPage->SetPageWidth(nWidth);
//STRIP001 	pTabPage->Reset(*pSet);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------26.05.99 12:32-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK(SwColumnDlg, OkHdl, OKButton*, EMPTYARG)
//STRIP001 {
//STRIP001 	//aktuelle Selektion auswerten
//STRIP001 	SfxItemSet* pSet = 0;
//STRIP001 	switch(nOldSelection)
//STRIP001 	{
//STRIP001 		case LISTBOX_SELECTION  :
//STRIP001 			pSet = pSelectionSet;
//STRIP001 		break;
//STRIP001 		case LISTBOX_SECTION	:
//STRIP001 			pSet = pSectionSet;
//STRIP001 			bSectionChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_SECTIONS	:
//STRIP001 			pSet = pSectionSet;
//STRIP001 			bSelSectionChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_PAGE		:
//STRIP001 			pSet = pPageSet;
//STRIP001 			bPageChanged = TRUE;
//STRIP001 		break;
//STRIP001 		case LISTBOX_FRAME:
//STRIP001 			pSet = pFrameSet;
//STRIP001 			bFrameChanged = TRUE;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	pTabPage->FillItemSet(*pSet);
//STRIP001 
//STRIP001 	if(pSelectionSet && SFX_ITEM_SET == pSelectionSet->GetItemState(RES_COL))
//STRIP001 	{
//STRIP001 		//Bereich mit Spalten einfuegen
//STRIP001 		const SwFmtCol& rColItem = (const SwFmtCol&)pSelectionSet->Get(RES_COL);
//STRIP001 		//nur, wenn es auch Spalten gibt!
//STRIP001 		if(rColItem.GetNumCols() > 1)
//STRIP001 			rWrtShell.GetView().GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 				FN_INSERT_REGION, SFX_CALLMODE_ASYNCHRON, *pSelectionSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pSectionSet && pSectionSet->Count() && bSectionChanged )
//STRIP001 	{
//STRIP001 		const SwSection* pCurrSection = rWrtShell.GetCurrSection();
//STRIP001 		const SwSectionFmt* pFmt = pCurrSection->GetFmt();
//STRIP001 		USHORT nNewPos = rWrtShell.GetSectionFmtPos( *pFmt );
//STRIP001 		rWrtShell.ChgSection( nNewPos, *pCurrSection, pSectionSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pSectionSet && pSectionSet->Count() && bSelSectionChanged )
//STRIP001 	{
//STRIP001 		rWrtShell.SetSectionAttr( *pSectionSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pPageSet && SFX_ITEM_SET == pPageSet->GetItemState(RES_COL) && bPageChanged)
//STRIP001 	{
//STRIP001 		// aktuellen PageDescriptor ermitteln und damit den Set fuellen
//STRIP001 		const USHORT nCurIdx = rWrtShell.GetCurPageDesc();
//STRIP001 		SwPageDesc aPageDesc(rWrtShell.GetPageDesc(nCurIdx));
//STRIP001 		SwFrmFmt &rFmt = aPageDesc.GetMaster();
//STRIP001 		rFmt.SetAttr(pPageSet->Get(RES_COL));
//STRIP001 		rWrtShell.ChgPageDesc(nCurIdx, aPageDesc);
//STRIP001 	}
//STRIP001 	if(pFrameSet && SFX_ITEM_SET == pFrameSet->GetItemState(RES_COL) && bFrameChanged)
//STRIP001 	{
//STRIP001 		SfxItemSet aTmp(*pFrameSet->GetPool(), RES_COL, RES_COL);
//STRIP001 		aTmp.Put(*pFrameSet);
//STRIP001 		rWrtShell.StartAction();
//STRIP001 		rWrtShell.Push();
//STRIP001 		rWrtShell.SetFlyFrmAttr( aTmp );
//STRIP001 		//die Rahmenselektion wieder aufheben
//STRIP001 		if(rWrtShell.IsFrmSelected())
//STRIP001 		{
//STRIP001 			rWrtShell.UnSelectFrm();
//STRIP001 			rWrtShell.LeaveSelFrmMode();
//STRIP001 		}
//STRIP001 		rWrtShell.Pop();
//STRIP001 		rWrtShell.EndAction();
//STRIP001 	}
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL < 2
//STRIP001 inline
//STRIP001 #endif
//STRIP001 USHORT GetMaxWidth( SwColMgr* pColMgr, USHORT nCols )
//STRIP001 {
//STRIP001 	USHORT nMax = pColMgr->GetActualSize();
//STRIP001 	if( --nCols )
//STRIP001 		nMax -= pColMgr->GetGutterWidth() * nCols;
//STRIP001 	return nMax;
//STRIP001 }
//STRIP001 
//STRIP001 static USHORT __FAR_DATA aPageRg[] = {
//STRIP001 	RES_COL, RES_COL,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 DBG_NAME(columnhdl) 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 USHORT lcl_LineWidthToPos(ULONG nWidth)
//STRIP001 {
//STRIP001 	const USHORT nUShortWidth = (USHORT)nWidth;
//STRIP001 	for(USHORT i = 0; i < nLineCount; ++i)
//STRIP001 		if(nUShortWidth == nLines[i])
//STRIP001 			return i;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::ResetColWidth()
//STRIP001 {
//STRIP001 	if( nCols )
//STRIP001 	{
//STRIP001 		USHORT nWidth = GetMaxWidth( pColMgr, nCols );
//STRIP001 		nWidth /= nCols;
//STRIP001 
//STRIP001 		for(USHORT i = 0; i < nCols; ++i)
//STRIP001 			nColWidth[i] = (long) nWidth;
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Jetzt als TabPage
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwColumnPage::SwColumnPage(Window *pParent, const SfxItemSet &rSet)
//STRIP001 
//STRIP001 	: SfxTabPage(pParent, SW_RES(TP_COLUMN), rSet),
//STRIP001 
//STRIP001 	aClNrLbl(this,			ResId(FT_NUMBER  )),
//STRIP001 	aCLNrEdt(this,			ResId(ED_NUMBER  )),
//STRIP001 	aAutoWidthBox(this, 	ResId(CB_AUTO_WIDTH)),
//STRIP001 	aDefaultVS(this, 		ResId(VS_DEFAULTS)),
//STRIP001 	aBalanceColsCB(this,	ResId(CB_BALANCECOLS)),
//STRIP001 	aFLGroup(this,			ResId(FL_COLUMNS )),
//STRIP001 
//STRIP001 	aLineTypeLbl(this,		ResId(FT_STYLE)),
//STRIP001 	aLineTypeDLB(this,		ResId(LB_STYLE)),
//STRIP001 	aLineHeightLbl(this, 	ResId(FT_HEIGHT)),
//STRIP001 	aLineHeightEdit(this, 	ResId(ED_HEIGHT)),
//STRIP001 	aLinePosLbl(this,		ResId(FT_POSITION)),
//STRIP001 	aLinePosDLB(this,		ResId(LB_POSITION)),
//STRIP001 	aFLLineType(this,		ResId(FL_LINETYPE)),
//STRIP001 	aBtnUp(this,			ResId(BTN_DOWN)),
//STRIP001 	aBtnDown(this,			ResId(BTN_UP)),
//STRIP001 
//STRIP001     aColumnFT(this,         ResId(FT_COLUMN)),
//STRIP001     aWidthFT(this,          ResId(FT_WIDTH)),
//STRIP001 	aDistFT(this,			ResId(FT_DIST)),
//STRIP001     aLbl1(this,             ResId(FT_1)),
//STRIP001 	aEd1(this,				ResId(ED_1)),
//STRIP001 	aDistEd1(this,			ResId(ED_DIST1)),
//STRIP001     aLbl2(this,             ResId(FT_2)),
//STRIP001 	aEd2(this,				ResId(ED_2)),
//STRIP001 	aDistEd2(this,			ResId(ED_DIST2)),
//STRIP001     aLbl3(this,             ResId(FT_3)),
//STRIP001 	aEd3(this,				ResId(ED_3)),
//STRIP001 	aFLLayout(this,			ResId(FL_LAYOUT)),
//STRIP001     aVertFL(this,         ResId(FL_VERT)),
//STRIP001     aPropertiesFL(  this,    ResId( FL_PROPERTIES    )),
//STRIP001     aTextDirectionFT( this,  ResId( FT_TEXTDIRECTION )),
//STRIP001     aTextDirectionLB( this,  ResId( LB_TEXTDIRECTION )),
//STRIP001 
//STRIP001     aPgeExampleWN(this,     ResId(WN_BSP)),
//STRIP001     aFrmExampleWN(this,     ResId(WN_BSP)),
//STRIP001 
//STRIP001 	nFirstVis(0),
//STRIP001 	bFrm(FALSE),
//STRIP001 	bFormat(FALSE),
//STRIP001 	bHtmlMode(FALSE),
//STRIP001 	nMinWidth(MINLAY),
//STRIP001 	pModifiedField(0),
//STRIP001 	pColMgr(0),
//STRIP001 	bLockUpdate(FALSE)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001     aDefaultVS.SetHelpId(HID_COLUMN_VALUESET);
//STRIP001     aDefaultVS.SetColCount( 5 );
//STRIP001 	aDefaultVS.SetStyle(  aDefaultVS.GetStyle()
//STRIP001 							| WB_ITEMBORDER
//STRIP001 							| WB_DOUBLEBORDER );
//STRIP001 
//STRIP001     for(USHORT i = 0; i < 5; i++)
//STRIP001 		aDefaultVS.InsertItem( i + 1, i );
//STRIP001 
//STRIP001 	aDefaultVS.SetSelectHdl(LINK(this, SwColumnPage, SetDefaultsHdl));
//STRIP001 
//STRIP001 	// Controls fuer Zusaetzebereich beim MoreButton anmelden
//STRIP001     Link aCLNrLk = LINK(this, SwColumnPage, ColModify);
//STRIP001     aCLNrEdt.SetLoseFocusHdl(aCLNrLk);
//STRIP001     aCLNrEdt.SetUpHdl(aCLNrLk);
//STRIP001     aCLNrEdt.SetDownHdl(aCLNrLk);
//STRIP001     Link aLk = LINK(this, SwColumnPage, GapModify);
//STRIP001 	aDistEd1.SetUpHdl(aLk);
//STRIP001 	aDistEd1.SetDownHdl(aLk);
//STRIP001 	aDistEd1.SetLoseFocusHdl(aLk);
//STRIP001 	aDistEd2.SetUpHdl(aLk);
//STRIP001 	aDistEd2.SetDownHdl(aLk);
//STRIP001 	aDistEd2.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aLk = LINK(this, SwColumnPage, EdModify);
//STRIP001 
//STRIP001 	aEd1.SetUpHdl(aLk);
//STRIP001 	aEd1.SetDownHdl(aLk);
//STRIP001 	aEd1.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aEd2.SetUpHdl(aLk);
//STRIP001 	aEd2.SetDownHdl(aLk);
//STRIP001 	aEd2.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aEd3.SetUpHdl(aLk);
//STRIP001 	aEd3.SetDownHdl(aLk);
//STRIP001 	aEd3.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aBtnUp.SetClickHdl(LINK(this, SwColumnPage, Up));
//STRIP001 	aBtnDown.SetClickHdl(LINK(this, SwColumnPage, Down));
//STRIP001 	aAutoWidthBox.SetClickHdl(LINK(this, SwColumnPage, AutoWidthHdl));
//STRIP001 
//STRIP001 	aLk = LINK( this, SwColumnPage, UpdateColMgr );
//STRIP001 	aLineTypeDLB.SetSelectHdl( aLk );
//STRIP001 	aLineHeightEdit.SetModifyHdl( aLk );
//STRIP001 	aLinePosDLB.SetSelectHdl( aLk );
//STRIP001 
//STRIP001 		// Trennlinie
//STRIP001 	aLineTypeDLB.SetUnit( FUNIT_POINT );
//STRIP001 	aLineTypeDLB.SetSourceUnit( FUNIT_TWIP );
//STRIP001 	for( i = 0; i < nLineCount; ++i )
//STRIP001 		aLineTypeDLB.InsertEntry( 100 * nLines[ i ] );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwColumnPage::~SwColumnPage()
//STRIP001 {
//STRIP001 	delete pColMgr;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::SetPageWidth(long nPageWidth)
//STRIP001 {
//STRIP001 	long nNewMaxWidth = aEd1.Normalize(nPageWidth);
//STRIP001 
//STRIP001 	aDistEd1.SetMax(nNewMaxWidth, FUNIT_TWIP);
//STRIP001 	aDistEd2.SetMax(nNewMaxWidth, FUNIT_TWIP);
//STRIP001 	aEd1.SetMax(nNewMaxWidth, FUNIT_TWIP);
//STRIP001 	aEd2.SetMax(nNewMaxWidth, FUNIT_TWIP);
//STRIP001 	aEd3.SetMax(nNewMaxWidth, FUNIT_TWIP);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::Reset(const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	USHORT nHtmlMode = ::binfilter::GetHtmlMode((const SwDocShell*)SfxObjectShell::Current());
//STRIP001 	if(nHtmlMode & HTMLMODE_ON)
//STRIP001 	{
//STRIP001 		bHtmlMode = TRUE;
//STRIP001 		aAutoWidthBox.Enable(FALSE);
//STRIP001 	}
//STRIP001 	FieldUnit aMetric = ::GetDfltMetric(bHtmlMode);
//STRIP001 	SetMetric(aEd1, aMetric);
//STRIP001 	SetMetric(aEd2, aMetric);
//STRIP001 	SetMetric(aEd3, aMetric);
//STRIP001 	SetMetric(aDistEd1, aMetric);
//STRIP001 	SetMetric(aDistEd2, aMetric);
//STRIP001 
//STRIP001 	delete pColMgr;
//STRIP001 	pColMgr = new SwColMgr(rSet);
//STRIP001 	nCols 	= pColMgr->GetCount() ;
//STRIP001 	aCLNrEdt.SetMax(Max((USHORT)aCLNrEdt.GetMax(), (USHORT)nCols));
//STRIP001 	aCLNrEdt.SetLast(Max(nCols,(USHORT)aCLNrEdt.GetMax()));
//STRIP001 
//STRIP001 	if(bFrm)
//STRIP001 	{
//STRIP001 		if(bFormat)                     // hier gibt es keine Size
//STRIP001 			pColMgr->SetActualWidth(FRAME_FORMAT_WIDTH);
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SwFmtFrmSize& rSize = (const SwFmtFrmSize&)rSet.Get(RES_FRM_SIZE);
//STRIP001 			const SvxBoxItem& rBox = (const SvxBoxItem&) rSet.Get(RES_BOX);
//STRIP001 			pColMgr->SetActualWidth((USHORT)rSize.GetSize().Width() - rBox.GetDistance());
//STRIP001 		}
//STRIP001 	}
//STRIP001     if(aBalanceColsCB.IsVisible())
//STRIP001 	{
//STRIP001         const SfxPoolItem* pItem;
//STRIP001         if( SFX_ITEM_SET == rSet.GetItemState( RES_COLUMNBALANCE, FALSE, &pItem ))
//STRIP001 			aBalanceColsCB.Check(!((const SwFmtNoBalancedColumns*)pItem)->GetValue());
//STRIP001 		else
//STRIP001 			aBalanceColsCB.Check( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001     //text direction
//STRIP001     if( SFX_ITEM_AVAILABLE <= rSet.GetItemState( RES_FRAMEDIR ) )
//STRIP001 	{
//STRIP001         const SvxFrameDirectionItem& rItem = (const SvxFrameDirectionItem&)rSet.Get(RES_FRAMEDIR);
//STRIP001         sal_uInt32 nVal  = rItem.GetValue();
//STRIP001         USHORT nPos = aTextDirectionLB.GetEntryPos( (void*) nVal );
//STRIP001         aTextDirectionLB.SelectEntryPos( nPos );
//STRIP001         aTextDirectionLB.SaveValue();
//STRIP001 	}
//STRIP001 
//STRIP001     Init();
//STRIP001 	ActivatePage( rSet );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	TabPage erzeugen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SfxTabPage* SwColumnPage::Create(Window *pParent, const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	return new SwColumnPage(pParent, rSet);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Attribute in den Set stopfen bei OK
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwColumnPage::FillItemSet(SfxItemSet &rSet)
//STRIP001 {
//STRIP001     if(aCLNrEdt.HasChildPathFocus())
//STRIP001         aCLNrEdt.GetDownHdl().Call(&aCLNrEdt);
//STRIP001     // Im ItemSet setzen
//STRIP001 	// Die aktuellen Einstellungen sind
//STRIP001 	// schon vorhanden
//STRIP001 	//
//STRIP001 	const SfxPoolItem* pOldItem;
//STRIP001 	const SwFmtCol& rCol = pColMgr->GetColumns();
//STRIP001 	if(0 == (pOldItem = GetOldItem( rSet, RES_COL )) ||
//STRIP001 				rCol != *pOldItem )
//STRIP001 		rSet.Put(rCol);
//STRIP001 
//STRIP001 	if(aBalanceColsCB.IsVisible() )
//STRIP001 	{
//STRIP001 		rSet.Put(SwFmtNoBalancedColumns(!aBalanceColsCB.IsChecked() ));
//STRIP001 	}
//STRIP001     USHORT nPos;
//STRIP001     if( aTextDirectionLB.IsVisible() &&
//STRIP001         ( nPos = aTextDirectionLB.GetSelectEntryPos() ) !=
//STRIP001                                             aTextDirectionLB.GetSavedValue() )
//STRIP001 	{
//STRIP001         sal_uInt32 nDirection = (sal_uInt32)aTextDirectionLB.GetEntryData( nPos );
//STRIP001         rSet.Put( SvxFrameDirectionItem( (SvxFrameDirection)nDirection, RES_FRAMEDIR));
//STRIP001 	}
//STRIP001     return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	ColumnManager updaten
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, UpdateColMgr, void *, pField )
//STRIP001 {
//STRIP001 	long nGutterWidth = pColMgr->GetGutterWidth();
//STRIP001 	if(nCols > 1)
//STRIP001 	{
//STRIP001 			// Ermitteln, ob die schmalste Spalte zu schmal ist
//STRIP001 			// fuer den eingestellten Spaltenabstand
//STRIP001 		long nMin = nColWidth[0];
//STRIP001 		for(USHORT i = 1; i < nCols; ++i)
//STRIP001 			nMin = Min(nMin, nColWidth[i]);
//STRIP001 
//STRIP001 		BOOL bAutoWidth = aAutoWidthBox.IsChecked();
//STRIP001 		if(!bAutoWidth)
//STRIP001 		{
//STRIP001 			pColMgr->SetAutoWidth(FALSE);
//STRIP001 				// falls der Benutzer nicht die Gesamtbreite vergeben hat,
//STRIP001 				// den fehlenden Betrag auf die letzte Spalte addieren.
//STRIP001 			long nSum = 0;
//STRIP001 			for(i = 0; i < nCols; ++i)
//STRIP001 				nSum += nColWidth[i];
//STRIP001 			nGutterWidth = 0;
//STRIP001 			for(i = 0; i < nCols - 1; ++i)
//STRIP001 				nGutterWidth += nColDist[i];
//STRIP001 			nSum += nGutterWidth;
//STRIP001 
//STRIP001 			long nMaxW = pColMgr->GetActualSize();
//STRIP001 
//STRIP001 			if( nSum < nMaxW  )
//STRIP001 				nColWidth[nCols - 1] += nMaxW - nSum;
//STRIP001 
//STRIP001 			pColMgr->SetColWidth( 0, nColWidth[0] + (USHORT)nColDist[0]/2 );
//STRIP001 			for( i = 1; i < nCols-1; ++i )
//STRIP001 			{
//STRIP001 				long nActDist = (nColDist[i] + nColDist[i - 1]) / 2;
//STRIP001 				pColMgr->SetColWidth( i, (USHORT)nColWidth[i] + (USHORT)nActDist );
//STRIP001 			}
//STRIP001 			pColMgr->SetColWidth( nCols-1, (USHORT)nColWidth[nCols-1] + nColDist[nCols -2]/2 );
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 			// keins ist ausgeschaltet
//STRIP001         const USHORT nPos = aLineTypeDLB.GetSelectEntryPos();
//STRIP001         BOOL bEnable = 0 != nPos;
//STRIP001 		aLineHeightEdit.Enable( bEnable );
//STRIP001 		aLineHeightLbl.Enable( bEnable );
//STRIP001 		if( !bEnable )
//STRIP001 			pColMgr->SetNoLine();
//STRIP001 		else if( LISTBOX_ENTRY_NOTFOUND != nPos )
//STRIP001 		{
//STRIP001 			pColMgr->SetLineWidthAndColor(nLines[nPos - 1], Color(COL_BLACK) );
//STRIP001 			pColMgr->SetAdjust( SwColLineAdj(
//STRIP001 									aLinePosDLB.GetSelectEntryPos() + 1) );
//STRIP001 			pColMgr->SetLineHeightPercent((short)aLineHeightEdit.GetValue());
//STRIP001 			bEnable = pColMgr->GetLineHeightPercent() != 100;
//STRIP001 		}
//STRIP001 		aLinePosLbl.Enable( bEnable );
//STRIP001 		aLinePosDLB.Enable( bEnable );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pColMgr->NoCols();
//STRIP001         nCols = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	//Maximalwerte setzen
//STRIP001 	aCLNrEdt.SetMax(Max(1L,
//STRIP001 		Min(long(nMaxCols), long( pColMgr->GetActualSize() / (nGutterWidth + MINLAY)) )));
//STRIP001 	aCLNrEdt.SetLast(aCLNrEdt.GetMax());
//STRIP001 	aCLNrEdt.Reformat();
//STRIP001 
//STRIP001 	//Beispielfenster anregen
//STRIP001 	if(!bLockUpdate)
//STRIP001 	{
//STRIP001 		if(bFrm)
//STRIP001 		{
//STRIP001 			aFrmExampleWN.SetColumns( pColMgr->GetColumns() );
//STRIP001 			aFrmExampleWN.Invalidate();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aPgeExampleWN.Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Initialisierung
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::Init()
//STRIP001 {
//STRIP001 	aCLNrEdt.SetValue(nCols);
//STRIP001 
//STRIP001     BOOL bAutoWidth = pColMgr->IsAutoWidth() || bHtmlMode;
//STRIP001     aAutoWidthBox.Check( bAutoWidth );
//STRIP001 
//STRIP001     sal_Int32 nColumnWidthSum = 0;
//STRIP001     // Setzen der Breiten
//STRIP001     USHORT i;
//STRIP001     for(i = 0; i < nCols; ++i)
//STRIP001 	{
//STRIP001 		nColWidth[i] = pColMgr->GetColWidth(i);
//STRIP001         nColumnWidthSum += nColWidth[i];
//STRIP001 		if(i < nCols - 1)
//STRIP001 			nColDist[i] = pColMgr->GetGutterWidth(i);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( 1 < nCols )
//STRIP001 	{
//STRIP001         // #97495# make sure that the automatic column widht's are always equal
//STRIP001         if(bAutoWidth)
//STRIP001         {
//STRIP001             nColumnWidthSum /= nCols;
//STRIP001             for(i = 0; i < nCols; ++i)
//STRIP001                 nColWidth[i] = nColumnWidthSum;
//STRIP001         }
//STRIP001         USHORT eAdj = pColMgr->GetAdjust();
//STRIP001 		if( COLADJ_NONE == eAdj )		// der Dialog kennt kein NONE!
//STRIP001 		{
//STRIP001 			eAdj = COLADJ_TOP;
//STRIP001 			//ohne Adjust auch kein Linientyp
//STRIP001 			aLineTypeDLB.SelectEntryPos( 0 );
//STRIP001 			aLineHeightEdit.SetValue( 100 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aLineTypeDLB.SelectEntryPos( lcl_LineWidthToPos(( pColMgr->GetLineWidth() )) + 1);
//STRIP001 			aLineHeightEdit.SetValue( pColMgr->GetLineHeightPercent() );
//STRIP001 		}
//STRIP001 		aLinePosDLB.SelectEntryPos( eAdj - 1 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLinePosDLB.SelectEntryPos( 0 );
//STRIP001 		aLineTypeDLB.SelectEntryPos( 0 );
//STRIP001 		aLineHeightEdit.SetValue( 100 );
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateCols();
//STRIP001 	Update();
//STRIP001 
//STRIP001 		// Maximale Spaltenzahl setzen
//STRIP001 		// Werte kleiner als 1 sind nicht erlaubt
//STRIP001 	aCLNrEdt.SetMax(Max(1L,
//STRIP001 		Min(long(nMaxCols), long( pColMgr->GetActualSize() / nMinWidth) )));
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Die Anzahl der Spalten hat sich veraendert -- hier werden
//STRIP001 				die Controls fuer die Bearbeitung der Spalten entsprechend
//STRIP001 				der Spaltenzahl en- oder disabled.
//STRIP001 				Falls es mehr als nVisCols (= 3) Spalten gibt, werden
//STRIP001 				alle Edit enabled und die Buttons fuer das Scrollen
//STRIP001 				ebenfalls.
//STRIP001 				Andernfalls werden die Edits jeweils fuer die entsprechenden
//STRIP001 				Spaltenzahl enabled; eine Spalte kann nicht bearbeitet werden.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::UpdateCols()
//STRIP001 {
//STRIP001 	BOOL bEnableBtns= FALSE;
//STRIP001 	BOOL bEnable12	= FALSE;
//STRIP001 	BOOL bEnable3	= FALSE;
//STRIP001 	const BOOL bEdit = !aAutoWidthBox.IsChecked();
//STRIP001 	if ( nCols > nVisCols )
//STRIP001 	{
//STRIP001 		bEnableBtns = TRUE && !bHtmlMode;
//STRIP001 		bEnable12 = bEnable3 = bEdit;
//STRIP001 	}
//STRIP001 	else if( bEdit )
//STRIP001 	{
//STRIP001 		// hier gibt es absichtlich kaum noch breaks
//STRIP001 		switch(nCols)
//STRIP001 		{
//STRIP001 			case 3: bEnable3 = TRUE;
//STRIP001 			case 2: bEnable12= TRUE; break;
//STRIP001 			default: /* do nothing */;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aEd1.Enable( bEnable12 );
//STRIP001 	aDistEd1.Enable(nCols > 1);
//STRIP001 	aEd2.Enable( bEnable12 );
//STRIP001 	aDistEd2.Enable(bEnable3);
//STRIP001 	aEd3.Enable( bEnable3  );
//STRIP001     aLbl1.Enable(bEnable12 );
//STRIP001     aLbl2.Enable(bEnable12 );
//STRIP001     aLbl3.Enable(bEnable3  );
//STRIP001 	aBtnUp.Enable( bEnableBtns );
//STRIP001 	aBtnDown.Enable( bEnableBtns );
//STRIP001 
//STRIP001 	const BOOL bEnable = nCols > 1;
//STRIP001 	if( !bEnable )
//STRIP001 	{
//STRIP001 		aLinePosDLB.Enable( FALSE );
//STRIP001 		aLinePosLbl.Enable( FALSE );
//STRIP001 	}
//STRIP001 	aLineHeightEdit.Enable( bEnable );
//STRIP001 	aLineHeightLbl.Enable( bEnable );
//STRIP001 	aLineTypeDLB.Enable( bEnable );
//STRIP001 	aLineTypeLbl.Enable( bEnable );
//STRIP001 	aAutoWidthBox.Enable( bEnable && !bHtmlMode );
//STRIP001 }
//STRIP001 
//STRIP001 void SwColumnPage::SetLabels( USHORT nVis )
//STRIP001 {
//STRIP001 	String sLbl( '~' );
//STRIP001 
//STRIP001 	String sLbl2( String::CreateFromInt32( nVis + 1 ));
//STRIP001 	sLbl2.Insert(sLbl, sLbl2.Len() - 1);
//STRIP001     aLbl1.SetText(sLbl2);
//STRIP001 
//STRIP001 	sLbl2 = String::CreateFromInt32( nVis + 2 );
//STRIP001 	sLbl2.Insert(sLbl, sLbl2.Len() - 1);
//STRIP001     aLbl2.SetText(sLbl2);
//STRIP001 
//STRIP001 	sLbl2 = String::CreateFromInt32( nVis + 3 );
//STRIP001 	sLbl2.Insert(sLbl, sLbl2.Len() - 1);
//STRIP001     aLbl3.SetText(sLbl2);
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Handler, der bei einer Veraenderung der Spaltenzahl
//STRIP001 				gerufen wird.
//STRIP001 				Eine Aenderung der Spaltenzahl ueberschreibt eventuelle
//STRIP001 				Breiteneinstellungen des Benutzers; alle Spalten sind
//STRIP001 				gleich breit.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, ColModify, NumericField *, pNF )
//STRIP001 {
//STRIP001     nCols = (USHORT)aCLNrEdt.GetValue();
//STRIP001     //#107890# the handler is also called from LoseFocus() 
//STRIP001     //then no change has been made and thus no action should be taken
//STRIP001     if(pColMgr->GetCount() != nCols)
//STRIP001     {        
//STRIP001         if(pNF)
//STRIP001             aDefaultVS.SetNoSelection();
//STRIP001         long nDist = aDistEd1.Denormalize(aDistEd1.GetValue(FUNIT_TWIP));
//STRIP001         pColMgr->SetCount(nCols, (USHORT)nDist);
//STRIP001         for(USHORT i = 0; i < nCols; i++)
//STRIP001             nColDist[i] = nDist;
//STRIP001         nFirstVis = 0;
//STRIP001         SetLabels( nFirstVis );
//STRIP001         UpdateCols();
//STRIP001         ResetColWidth();
//STRIP001         Update();
//STRIP001     }
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Modify- Handler fuer eine Aenderung der Spaltenbreite
//STRIP001 				oder des Spaltenabstandes.
//STRIP001 				Diese Aenderungen wirken sich erst zeitversetzt aus.
//STRIP001 				Durch eine Aenderung der Spaltenbreite wird die automatische
//STRIP001 				Berechnung der Spaltenbreite ausser Kraft gesetzt; erst
//STRIP001 				eine Aenderung der Spaltenzahl kehrt wieder zu diesem
//STRIP001 				Default zurueck.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, GapModify, PercentField *, pFld )
//STRIP001 {
//STRIP001 	long nActValue = pFld->Denormalize(pFld->GetValue(FUNIT_TWIP));
//STRIP001 	if(nCols < 2)
//STRIP001 		return 0;
//STRIP001 	if(aAutoWidthBox.IsChecked())
//STRIP001 	{
//STRIP001 		USHORT nMaxGap = pColMgr->GetActualSize() - nCols * MINLAY;
//STRIP001 		DBG_ASSERT(nCols, "Abstand kann nicht ohne Spalten eingestellt werden")
//STRIP001 		nMaxGap /= nCols - 1;
//STRIP001 		if(nActValue > nMaxGap)
//STRIP001 		{
//STRIP001 			nActValue = nMaxGap;
//STRIP001             aDistEd1.SetPrcntValue(aDistEd1.Normalize(nMaxGap), FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		pColMgr->SetGutterWidth((USHORT)nActValue);
//STRIP001 		for(USHORT i = 0; i < nCols; i++)
//STRIP001 			nColDist[i] = nActValue;
//STRIP001 
//STRIP001 		ResetColWidth();
//STRIP001 		UpdateCols();
//STRIP001 	}
//STRIP001 	else
//STRIP001 
//STRIP001 	{
//STRIP001 		USHORT nOffset = 0;
//STRIP001 		if(pFld == &aDistEd2)
//STRIP001 		{
//STRIP001 			nOffset = 1;
//STRIP001 		}
//STRIP001 		long nDiff = nActValue - nColDist[nFirstVis + nOffset];
//STRIP001 		if(nDiff)
//STRIP001 		{
//STRIP001 			long nLeft = nColWidth[nFirstVis + nOffset];
//STRIP001 			long nRight = nColWidth[nFirstVis + nOffset + 1];
//STRIP001 			if(nLeft + nRight + 2 * MINLAY < nDiff)
//STRIP001 				nDiff = nLeft + nRight - 2 * MINLAY;
//STRIP001 			if(nDiff < nRight - MINLAY)
//STRIP001 			{
//STRIP001 				nRight -= nDiff;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				long nTemp = nDiff - nRight + MINLAY;
//STRIP001 				nRight = MINLAY;
//STRIP001 				if(nLeft > nTemp - MINLAY)
//STRIP001 				{
//STRIP001 					nLeft -= nTemp;
//STRIP001 					nTemp = 0;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nTemp -= nLeft + MINLAY;
//STRIP001 					nLeft = MINLAY;
//STRIP001 				}
//STRIP001 				nDiff = nTemp;
//STRIP001 			}
//STRIP001 			nColWidth[nFirstVis + nOffset] = nLeft;
//STRIP001 			nColWidth[nFirstVis + nOffset + 1] = nRight;
//STRIP001 			nColDist[nFirstVis + nOffset] += nDiff;
//STRIP001 
//STRIP001 			pColMgr->SetColWidth( nFirstVis + nOffset, USHORT(nLeft) );
//STRIP001 			pColMgr->SetColWidth( nFirstVis + nOffset + 1, USHORT(nRight) );
//STRIP001 			pColMgr->SetGutterWidth( USHORT(nColDist[nFirstVis + nOffset]), nFirstVis + nOffset );
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	Update();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, EdModify, PercentField *, pField )
//STRIP001 {
//STRIP001 	pModifiedField = pField;
//STRIP001 	Timeout(0);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Handler hinter der Checkbox fuer automatische Breite.
//STRIP001 				Ist die Box gecheckt, koennen keine expliziten Werte
//STRIP001 				fuer die Spaltenbreite eingegeben werden.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, AutoWidthHdl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	long nDist = aDistEd1.Denormalize(aDistEd1.GetValue(FUNIT_TWIP));
//STRIP001 	pColMgr->SetCount(nCols, (USHORT)nDist);
//STRIP001 	for(USHORT i = 0; i < nCols; i++)
//STRIP001 		nColDist[i] = nDist;
//STRIP001 	if(pBox->IsChecked())
//STRIP001 	{
//STRIP001 		pColMgr->SetGutterWidth(USHORT(nDist));
//STRIP001 		ResetColWidth();
//STRIP001 	}
//STRIP001 	pColMgr->SetAutoWidth(pBox->IsChecked(), USHORT(nDist));
//STRIP001 	UpdateCols();
//STRIP001 	Update();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Raufscrollen der Inhalte der Edits.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, Up, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( nFirstVis )
//STRIP001 	{
//STRIP001 		--nFirstVis;
//STRIP001 		SetLabels( nFirstVis );
//STRIP001 		Update();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Runterscrollen der Inhalte der Edits.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, Down, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( nFirstVis + nVisCols < nCols )
//STRIP001 	{
//STRIP001 		++nFirstVis;
//STRIP001 		SetLabels( nFirstVis );
//STRIP001 		Update();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Relikt aus alten Zeiten - jetzt direkt ohne time
//STRIP001  * 				Timer- Handler; angetriggert durch eine Aenderung der
//STRIP001 				Spaltenbreite oder des Spaltenabstandes.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, Timeout, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001 	DBG_PROFSTART(columnhdl) ;
//STRIP001 	if(pModifiedField)
//STRIP001 	{
//STRIP001 			// Finden der veraenderten Spalte
//STRIP001 		USHORT nChanged = nFirstVis;
//STRIP001 		if(pModifiedField == &aEd2)
//STRIP001 			++nChanged;
//STRIP001 		else if(pModifiedField == &aEd3)
//STRIP001 			nChanged += 2;
//STRIP001 		/*else if(pModifiedField == &aEd4)
//STRIP001 			nChanged += 3;*/
//STRIP001 
//STRIP001 		long nNewWidth = (USHORT)
//STRIP001 			pModifiedField->Denormalize(pModifiedField->GetValue(FUNIT_TWIP));
//STRIP001 		long nDiff = nNewWidth - nColWidth[nChanged];
//STRIP001 
//STRIP001 		// wenn es die letzte Spalte ist
//STRIP001 		if(nChanged == nCols - 1)
//STRIP001 		{
//STRIP001 			nColWidth[0] -= nDiff;
//STRIP001 			if(nColWidth[0] < (long)nMinWidth)
//STRIP001 			{
//STRIP001 				nNewWidth -= nMinWidth - nColWidth[0];
//STRIP001 				nColWidth[0] = nMinWidth;
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 		else if(nDiff)
//STRIP001 		{
//STRIP001 			nColWidth[nChanged + 1] -= nDiff;
//STRIP001 			if(nColWidth[nChanged + 1] < (long) nMinWidth)
//STRIP001 			{
//STRIP001 				nNewWidth -= nMinWidth - nColWidth[nChanged + 1];
//STRIP001 				nColWidth[nChanged + 1] = nMinWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nColWidth[nChanged] = nNewWidth;
//STRIP001 		pModifiedField = 0;
//STRIP001 	}
//STRIP001 	Update();
//STRIP001 	DBG_PROFSTOP(columnhdl) ;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Aktualisierung der Anzeige
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::Update()
//STRIP001 {
//STRIP001 	aBalanceColsCB.Enable(nCols > 1);
//STRIP001 	if(nCols >= 2)
//STRIP001 	{
//STRIP001         aEd1.SetPrcntValue(aEd1.Normalize(nColWidth[nFirstVis]), FUNIT_TWIP);
//STRIP001         aDistEd1.SetPrcntValue(aDistEd1.Normalize(nColDist[nFirstVis]), FUNIT_TWIP);
//STRIP001         aEd2.SetPrcntValue(aEd2.Normalize(nColWidth[nFirstVis + 1]), FUNIT_TWIP);
//STRIP001 		if(nCols >= 3)
//STRIP001 		{
//STRIP001             aDistEd2.SetPrcntValue(aDistEd2.Normalize(nColDist[nFirstVis + 1]), FUNIT_TWIP);
//STRIP001             aEd3.SetPrcntValue(aEd3.Normalize(nColWidth[nFirstVis + 2]), FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aEd3.SetText(aEmptyStr);
//STRIP001 			aDistEd2.SetText(aEmptyStr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aEd1.SetText(aEmptyStr);
//STRIP001 		aEd2.SetText(aEmptyStr);
//STRIP001 		aEd3.SetText(aEmptyStr);
//STRIP001 		aDistEd1.SetText(aEmptyStr);
//STRIP001 		aDistEd2.SetText(aEmptyStr);
//STRIP001 	}
//STRIP001 	UpdateColMgr(0);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Update Bsp
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	if(!bFrm)
//STRIP001 	{
//STRIP001 		if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_PAGE_SIZE ))
//STRIP001 		{
//STRIP001 			const SvxSizeItem& rSize = (const SvxSizeItem&)rSet.Get(
//STRIP001 												SID_ATTR_PAGE_SIZE);
//STRIP001 			const SvxLRSpaceItem& rLRSpace = (const SvxLRSpaceItem&)rSet.Get(
//STRIP001 																RES_LR_SPACE );
//STRIP001 			const SvxBoxItem& rBox = (const SvxBoxItem&) rSet.Get(RES_BOX);
//STRIP001 			USHORT nActWidth = (USHORT)rSize.GetSize().Width()
//STRIP001 							- rLRSpace.GetLeft() - rLRSpace.GetRight() - rBox.GetDistance();
//STRIP001 
//STRIP001 			if( pColMgr->GetActualSize() != nActWidth)
//STRIP001 			{
//STRIP001 				pColMgr->SetActualWidth(nActWidth);
//STRIP001 				ColModify( 0 );
//STRIP001 				UpdateColMgr( 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aFrmExampleWN.Hide();
//STRIP001 		aPgeExampleWN.UpdateExample( rSet, pColMgr );
//STRIP001 		aPgeExampleWN.Show();
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aPgeExampleWN.Hide();
//STRIP001 		aFrmExampleWN.Show();
//STRIP001 
//STRIP001 		// Size
//STRIP001         const SwFmtFrmSize& rSize = (const SwFmtFrmSize&)rSet.Get(RES_FRM_SIZE);
//STRIP001         const SvxBoxItem& rBox = (const SvxBoxItem&) rSet.Get(RES_BOX);
//STRIP001 
//STRIP001         long nDistance = rBox.GetDistance();
//STRIP001 		const USHORT nTotalWish = bFormat ? FRAME_FORMAT_WIDTH : USHORT(rSize.GetWidth() - 2 * nDistance);
//STRIP001 
//STRIP001 		// Maximalwerte der Spaltenbreiten setzen
//STRIP001 		SetPageWidth(nTotalWish);
//STRIP001 
//STRIP001 		if(pColMgr->GetActualSize() != nTotalWish)
//STRIP001 		{
//STRIP001 			pColMgr->SetActualWidth(nTotalWish);
//STRIP001 			Init();
//STRIP001 		}
//STRIP001 		BOOL bPercent;
//STRIP001 		// im Rahmenformat nur relative Angaben
//STRIP001 		if ( bFormat || rSize.GetWidthPercent() && rSize.GetWidthPercent() != 0xff)
//STRIP001 		{
//STRIP001 			// Wert fuer 100% setzen
//STRIP001 			aEd1.SetRefValue(nTotalWish);
//STRIP001 			aEd2.SetRefValue(nTotalWish);
//STRIP001 			aEd3.SetRefValue(nTotalWish);
//STRIP001 			aDistEd1.SetRefValue(nTotalWish);
//STRIP001 			aDistEd2.SetRefValue(nTotalWish);
//STRIP001 
//STRIP001 			// Auf %-Darstellung umschalten
//STRIP001 			bPercent = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bPercent = FALSE;
//STRIP001 
//STRIP001 		aEd1.ShowPercent(bPercent);
//STRIP001 		aEd2.ShowPercent(bPercent);
//STRIP001 		aEd3.ShowPercent(bPercent);
//STRIP001 		aDistEd1.ShowPercent(bPercent);
//STRIP001 		aDistEd2.ShowPercent(bPercent);
//STRIP001 		aDistEd1.MetricField::SetMin(0);
//STRIP001 		aDistEd2.MetricField::SetMin(0);
//STRIP001 	}
//STRIP001 	Update();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 int SwColumnPage::DeactivatePage(SfxItemSet *pSet)
//STRIP001 {
//STRIP001 	if(pSet)
//STRIP001 		FillItemSet(*pSet);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 USHORT* SwColumnPage::GetRanges()
//STRIP001 {
//STRIP001 	return aPageRg;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwColumnPage, SetDefaultsHdl, ValueSet *, pVS )
//STRIP001 {
//STRIP001 	USHORT nItem = pVS->GetSelectItemId();
//STRIP001 	if( nItem < 4 )
//STRIP001 	{
//STRIP001 		aCLNrEdt.SetValue( nItem );
//STRIP001 		aAutoWidthBox.Check();
//STRIP001         aDistEd1.SetPrcntValue(0);
//STRIP001 		ColModify(0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bLockUpdate = TRUE;
//STRIP001 		aCLNrEdt.SetValue( 2 );
//STRIP001 		aAutoWidthBox.Check(FALSE);
//STRIP001         aDistEd1.SetPrcntValue(0);
//STRIP001 		ColModify(0);
//STRIP001 		// jetzt noch das Breitenverhaeltnisse auf 2 : 1 bzw. 1 : 2 stellen
//STRIP001 		USHORT nSmall = pColMgr->GetActualSize()  / 3;
//STRIP001 		if(nItem == 4)
//STRIP001 		{
//STRIP001             aEd2.SetPrcntValue(aEd2.Normalize(long(nSmall)), FUNIT_TWIP);
//STRIP001 			pModifiedField = &aEd2;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             aEd1.SetPrcntValue(aEd1.Normalize(long(nSmall)), FUNIT_TWIP);
//STRIP001 			pModifiedField = &aEd1;
//STRIP001 		}
//STRIP001 		bLockUpdate = FALSE;
//STRIP001 		Timeout(0);
//STRIP001 
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------25.10.96 11.41-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwColumnPage::SetFrmMode(BOOL bMod)
//STRIP001 {
//STRIP001 	bFrm = bMod;
//STRIP001 }
//STRIP001 /* -----------------------------2002/06/19 13:08------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwColumnPage::SetInSection(BOOL bSet)
//STRIP001 {
//STRIP001     if(!SW_MOD()->GetCTLOptions().IsCTLFontEnabled())
//STRIP001         return;
//STRIP001 
//STRIP001     aVertFL.Show(bSet);
//STRIP001     aPropertiesFL.Show(bSet);
//STRIP001     aTextDirectionFT.Show(bSet);
//STRIP001     aTextDirectionLB.Show(bSet);
//STRIP001     if(bSet)
//STRIP001     {
//STRIP001         //resize line type FixedLine
//STRIP001         Point aLtPos = aFLLineType.GetPosPixel();
//STRIP001         Point aPropPos = aPropertiesFL.GetPosPixel();
//STRIP001         Size aSz = aFLLineType.GetSizePixel();
//STRIP001         aSz.Width() = aPropPos.X() - aLtPos.X() - LogicToPixel(Size(8, 8), MAP_APPFONT).Width();
//STRIP001         aFLLineType.SetSizePixel(aSz);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         Size aSz = aFLLineType.GetSizePixel();
//STRIP001         aSz.Width() = LogicToPixel(Size(248, 248), MAP_APPFONT).Width();
//STRIP001         aFLLineType.SetSizePixel(aSz);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------07.03.97 08.33-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void ColumnValueSet::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	OutputDevice*  pDev = rUDEvt.GetDevice();
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	Rectangle aRect = rUDEvt.GetRect();
//STRIP001 	USHORT	nItemId = rUDEvt.GetItemId();
//STRIP001 	long nRectWidth = aRect.GetWidth();
//STRIP001 	long nRectHeight = aRect.GetHeight();
//STRIP001 
//STRIP001 	Point aBLPos = aRect.TopLeft();
//STRIP001     Color aFillColor(pDev->GetFillColor());
//STRIP001     Color aLineColor(pDev->GetLineColor());
//STRIP001     pDev->SetFillColor(rStyleSettings.GetFieldColor());
//STRIP001     pDev->SetLineColor(SwViewOption::GetFontColor());
//STRIP001 
//STRIP001 	long nStep = Abs(Abs(nRectHeight * 95 /100) / 11);
//STRIP001 	long nTop = (nRectHeight - 11 * nStep ) / 2;
//STRIP001 	USHORT nCols;
//STRIP001 	long nStarts[3];
//STRIP001 	long nEnds[3];
//STRIP001 	nStarts[0] = nRectWidth * 10 / 100;
//STRIP001 	switch( nItemId )
//STRIP001 	{
//STRIP001 		case 1:
//STRIP001 			nEnds[0] = nRectWidth * 9 / 10;
//STRIP001 			nCols = 1;
//STRIP001 		break;
//STRIP001 		case 2: nCols = 2;
//STRIP001 			nEnds[0] = nRectWidth * 45 / 100;
//STRIP001 			nStarts[1] = nEnds[0] + nStep;
//STRIP001 			nEnds[1] = nRectWidth * 9 / 10;
//STRIP001 		break;
//STRIP001 		case 3: nCols = 3;
//STRIP001 			nEnds[0] 	= nRectWidth * 30 / 100;
//STRIP001 			nStarts[1] 	= nEnds[0] + nStep;
//STRIP001 			nEnds[1] 	= nRectWidth * 63 / 100;
//STRIP001 			nStarts[2] 	= nEnds[1] + nStep;
//STRIP001 			nEnds[2] 	= nRectWidth * 9 / 10;
//STRIP001 		break;
//STRIP001 		case 4: nCols = 2;
//STRIP001 			nEnds[0] = nRectWidth * 63 / 100;
//STRIP001 			nStarts[1] = nEnds[0] + nStep;
//STRIP001 			nEnds[1] = nRectWidth * 9 / 10;
//STRIP001 		break;
//STRIP001 		case 5: nCols = 2;
//STRIP001 			nEnds[0] = nRectWidth * 30 / 100;
//STRIP001 			nStarts[1] = nEnds[0] + nStep;
//STRIP001 			nEnds[1] = nRectWidth * 9 / 10;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	for(USHORT j = 0; j < nCols; j++ )
//STRIP001 	{
//STRIP001 		Point aStart(aBLPos.X() + nStarts[j], 0);
//STRIP001 		Point aEnd(aBLPos.X() + nEnds[j], 0);
//STRIP001 		for( USHORT i = 0; i < 12; i ++)
//STRIP001 		{
//STRIP001 			aStart.Y() = aEnd.Y() = aBLPos.Y() + nTop + i * nStep;
//STRIP001 			pDev->DrawLine(aStart, aEnd);
//STRIP001 		}
//STRIP001 	}
//STRIP001     pDev->SetFillColor(aFillColor);
//STRIP001     pDev->SetLineColor(aLineColor);
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------07.03.97 08.48-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 ColumnValueSet::~ColumnValueSet()
//STRIP001 {
//STRIP001 }
//STRIP001 /* -----------------------------02.04.2002 16:01------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void ColumnValueSet::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         Format();
//STRIP001     }
//STRIP001     ValueSet::DataChanged( rDCEvt );
//STRIP001 }

}
