/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_shdwcrsr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:06:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _SV_WINDOW_HXX //autogen
//STRIP001 #include <vcl/window.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "swtypes.hxx"
//STRIP001 #include "shdwcrsr.hxx"
//STRIP001 
//STRIP001 
//STRIP001 SwShadowCursor::~SwShadowCursor()
//STRIP001 {
//STRIP001 	if( USHRT_MAX != nOldMode )
//STRIP001 		DrawCrsr( aOldPt, nOldHeight, nOldMode );
//STRIP001 }
//STRIP001 
//STRIP001 void SwShadowCursor::SetPos( const Point& rPt, long nHeight, USHORT nMode )
//STRIP001 {
//STRIP001 	Point aPt( pWin->LogicToPixel( rPt ));
//STRIP001 	nHeight = pWin->LogicToPixel( Size( 0, nHeight )).Height();
//STRIP001 	if( aOldPt != aPt || nOldHeight != nHeight || nOldMode != nMode )
//STRIP001 	{
//STRIP001 		if( USHRT_MAX != nOldMode )
//STRIP001 			DrawCrsr( aOldPt, nOldHeight, nOldMode );
//STRIP001 
//STRIP001 		DrawCrsr( aPt, nHeight, nMode );
//STRIP001 		nOldMode = nMode;
//STRIP001 		nOldHeight = nHeight;
//STRIP001 		aOldPt = aPt;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SwShadowCursor::DrawTri( const Point& rPt, long nHeight, BOOL bLeft )
//STRIP001 {
//STRIP001 	USHORT nLineDiff = ( nHeight / 2 );
//STRIP001 	USHORT nLineDiffHalf = nLineDiff / 2;
//STRIP001 
//STRIP001 	// Punkt oben
//STRIP001 	Point aPt1( (bLeft ? rPt.X() - 3 : rPt.X() + 3),
//STRIP001 				rPt.Y() + nLineDiffHalf );
//STRIP001 	// Punkt unten
//STRIP001 	Point aPt2( aPt1.X(), aPt1.Y() + nHeight - nLineDiff - 1 );
//STRIP001 	short nDiff = bLeft ? -1 : 1;
//STRIP001 	while( aPt1.Y() <= aPt2.Y() )
//STRIP001 	{
//STRIP001 		pWin->DrawLine( aPt1, aPt2 );
//STRIP001 		aPt1.Y()++, aPt2.Y()--;
//STRIP001 		aPt2.X() = aPt1.X() += nDiff;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SwShadowCursor::DrawCrsr( const Point& rPt, long nHeight, USHORT nMode )
//STRIP001 {
//STRIP001 	nHeight = (((nHeight / 4)+1) * 4) + 1;
//STRIP001 
//STRIP001 	pWin->Push();
//STRIP001 
//STRIP001 	pWin->SetMapMode( MAP_PIXEL );
//STRIP001 	pWin->SetRasterOp( ROP_XOR );
//STRIP001 
//STRIP001 	pWin->SetLineColor( Color( aCol.GetColor() ^ COL_WHITE ) );
//STRIP001 
//STRIP001 	// 1. der Strich:
//STRIP001 	pWin->DrawLine( Point( rPt.X(), rPt.Y() + 1),
//STRIP001 			  Point( rPt.X(), rPt.Y() - 2 + nHeight ));
//STRIP001 
//STRIP001 	// 2. das Dreieck
//STRIP001 	if( HORI_LEFT == nMode || HORI_CENTER == nMode )	// Pfeil nach rechts
//STRIP001 		DrawTri( rPt, nHeight, FALSE );
//STRIP001 	if( HORI_RIGHT == nMode || HORI_CENTER == nMode )	// Pfeil nach links
//STRIP001 		DrawTri( rPt, nHeight, TRUE );
//STRIP001 
//STRIP001 	pWin->Pop();
//STRIP001 }
//STRIP001 
//STRIP001 void SwShadowCursor::Paint()
//STRIP001 {
//STRIP001 	if( USHRT_MAX != nOldMode )
//STRIP001 		DrawCrsr( aOldPt, nOldHeight, nOldMode );
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SwShadowCursor::GetRect() const
//STRIP001 {
//STRIP001 	long nH = nOldHeight;
//STRIP001 	Point aPt( aOldPt );
//STRIP001 
//STRIP001 	nH = (((nH / 4)+1) * 4) + 1;
//STRIP001 	USHORT nWidth = nH / 4 + 3 + 1;
//STRIP001 
//STRIP001 	Size aSz( nWidth, nH );
//STRIP001 
//STRIP001 	if( HORI_RIGHT == nOldMode )
//STRIP001 		aPt.X() -= aSz.Width();
//STRIP001 	else if( HORI_CENTER == nOldMode )
//STRIP001 	{
//STRIP001 		aPt.X() -= aSz.Width();
//STRIP001 		aSz.Width() *= 2;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pWin->PixelToLogic( Rectangle( aPt, aSz ) );
//STRIP001 }




}
