/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizlogo.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:19:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#include "swtypes.hxx"
#include "hintids.hxx"
#include "uitool.hxx"
#include "wizard.hrc"
#include "wizlogo.hxx"

#ifndef _COM_SUN_STAR_UI_DIALOGS_EXTENDEDFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/ExtendedFilePickerElementIds.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;
using namespace sfx2;

WizardLogoDlg::WizardLogoDlg(SwWizardDialog* pDlgWin)
{
	pL_Text_LgoArt=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LgoArt));
	pL_RBtn_NoLogo=new RadioButton  (pDlgWin,SW_RES(DLG_Lgo_RBtn_NoLogo));
	pL_RBtn_GrLogo=new RadioButton  (pDlgWin,SW_RES(DLG_Lgo_RBtn_GrLogo));
	pL_RBtn_TxLogo=new RadioButton  (pDlgWin,SW_RES(DLG_Lgo_RBtn_TxLogo));
	pL_Text_LogoTx=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LogoTx));
	pL_MEdt_LogoTx=new MultiLineEdit(pDlgWin,SW_RES(DLG_Lgo_MEdt_LogoTx));
	pL_Edit_LogoFN=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Edit_LogoFN));
	pL_PBtn_LogoFN=new PushButton   (pDlgWin,SW_RES(DLG_Lgo_PBtn_LogoFN));
    pL_FL_LogoFN=new FixedLine     (pDlgWin,SW_RES(DLG_Lgo_FL_LogoFN));
	pL_BBtn_LogoLi=new JBitmapButton(pDlgWin,SW_RES(DLG_Lgo_BBtn_LogoLi));
	pL_BBtn_LogoMi=new JBitmapButton(pDlgWin,SW_RES(DLG_Lgo_BBtn_LogoMi));
	pL_BBtn_LogoRe=new JBitmapButton(pDlgWin,SW_RES(DLG_Lgo_BBtn_LogoRe));
	pL_Text_LogoHo=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LogoHo));
	pL_MFld_LogoHo=new MetricField  (pDlgWin,SW_RES(DLG_Lgo_MFld_LogoHo));
	pL_Text_LogoVe=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LogoVe));
	pL_MFld_LogoVe=new MetricField  (pDlgWin,SW_RES(DLG_Lgo_MFld_LogoVe));
    pL_FL_LgoPos=new FixedLine     (pDlgWin,SW_RES(DLG_Lgo_FL_LgoPos));
	pL_Text_LogoWd=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LogoWd));
	pL_MFld_LogoWd=new MetricField  (pDlgWin,SW_RES(DLG_Lgo_MFld_LogoWd));
	pL_Text_LogoHg=new FixedText    (pDlgWin,SW_RES(DLG_Lgo_Text_LogoHg));
	pL_MFld_LogoHg=new MetricField  (pDlgWin,SW_RES(DLG_Lgo_MFld_LogoHg));
    pL_FL_LgoSiz=new FixedLine     (pDlgWin,SW_RES(DLG_Lgo_FL_LgoSiz));
	pWizDlg=pDlgWin;
	pLogo1=NULL;
	pLogoF=NULL;
	eBeware=ALIGN_Null;


	pL_BBtn_LogoLi->setBitmaps(Bitmap(SW_RES(BMAP_Disbl_LogoLi_H)));
	pL_BBtn_LogoMi->setBitmaps(Bitmap(SW_RES(BMAP_Disbl_LogoMi_H)));
	pL_BBtn_LogoRe->setBitmaps(Bitmap(SW_RES(BMAP_Disbl_LogoRe_H)));
	pL_BBtn_LogoLi->ChangeDisbBitmap(Bitmap(SW_RES(BMAP_Disbl_LogoLi)),Bitmap(SW_RES(BMAP_Disbl_LogoLi__H)));
	pL_BBtn_LogoMi->ChangeDisbBitmap(Bitmap(SW_RES(BMAP_Disbl_LogoMi)),Bitmap(SW_RES(BMAP_Disbl_LogoMi__H)));
	pL_BBtn_LogoRe->ChangeDisbBitmap(Bitmap(SW_RES(BMAP_Disbl_LogoRe)),Bitmap(SW_RES(BMAP_Disbl_LogoRe__H)));

	FieldUnit aMetric = ::GetDfltMetric(FALSE);
	pL_MFld_LogoHo->SetUnit(aMetric);
	pL_MFld_LogoVe->SetUnit(aMetric);
	pL_MFld_LogoWd->SetUnit(aMetric);
	pL_MFld_LogoHg->SetUnit(aMetric);

	SetEventHandler();
}

WizardLogoDlg::~WizardLogoDlg()
{
	delete pL_Text_LgoArt;
	delete pL_RBtn_NoLogo;
	delete pL_RBtn_GrLogo;
	delete pL_RBtn_TxLogo;
	delete pL_Text_LogoTx;
	delete pL_MEdt_LogoTx;
	delete pL_Edit_LogoFN;
	delete pL_PBtn_LogoFN;
    delete pL_FL_LogoFN;
	delete pL_BBtn_LogoLi;
	delete pL_BBtn_LogoMi;
	delete pL_BBtn_LogoRe;
	delete pL_Text_LogoHo;
	delete pL_MFld_LogoHo;
	delete pL_Text_LogoVe;
	delete pL_MFld_LogoVe;
    delete pL_FL_LgoPos;
	delete pL_Text_LogoWd;
	delete pL_MFld_LogoWd;
	delete pL_Text_LogoHg;
	delete pL_MFld_LogoHg;
    delete pL_FL_LgoSiz;
}

void WizardLogoDlg::Fill(MultiOne& WinArr)
{
	WinArr.AddWin(pL_Text_LgoArt);
	WinArr.AddWin(pL_RBtn_NoLogo, TRUE);
	WinArr.AddWin(pL_RBtn_GrLogo, TRUE);
	WinArr.AddWin(pL_RBtn_TxLogo, TRUE);
	WinArr.AddWin(pL_Text_LogoTx);
	WinArr.AddWin(pL_MEdt_LogoTx, TRUE);
	WinArr.AddWin(pL_Edit_LogoFN, TRUE);
	WinArr.AddWin(pL_PBtn_LogoFN, TRUE);
    WinArr.AddWin(pL_FL_LogoFN,FALSE,TRUE);
	WinArr.AddWin(pL_BBtn_LogoLi, TRUE);
	WinArr.AddWin(pL_BBtn_LogoMi, TRUE);
	WinArr.AddWin(pL_BBtn_LogoRe, TRUE);
	WinArr.AddWin(pL_Text_LogoHo);
	WinArr.AddWin(pL_MFld_LogoHo, TRUE);
	WinArr.AddWin(pL_Text_LogoVe);
	WinArr.AddWin(pL_MFld_LogoVe, TRUE);
    WinArr.AddWin(pL_FL_LgoPos,FALSE,TRUE);
	WinArr.AddWin(pL_Text_LogoWd);
	WinArr.AddWin(pL_MFld_LogoWd, TRUE);
	WinArr.AddWin(pL_Text_LogoHg);
	WinArr.AddWin(pL_MFld_LogoHg, TRUE);
    WinArr.AddWin(pL_FL_LgoSiz,FALSE,TRUE);
}

void WizardLogoDlg::SetPtr(WizardLogo* pL1,WizardLogo* pL2)
{
	pLogo1 = pL1;
	pLogoF = pL2;
	ToUI();
	SetDisable();
}

void WizardLogoDlg::ToUI()
{
	if( !pLogo1 )
		return;

	pL_MFld_LogoWd->SetValue(pLogo1->GetWdt(), FUNIT_CM);
	pL_MFld_LogoHg->SetValue(pLogo1->GetHgt(), FUNIT_CM);
	pL_MFld_LogoHo->SetValue(pLogo1->GetHor(), FUNIT_CM);
	pL_MFld_LogoVe->SetValue(pLogo1->GetVer(), FUNIT_CM);

	if( pLogo1->IsVisible() )
	{
		if( pLogo1->IsTextLogo() )
			pL_RBtn_TxLogo->Check(TRUE);
		if( pLogo1->IsGrafLogo() )
			pL_RBtn_GrLogo->Check(TRUE);
	}
	else
		pL_RBtn_NoLogo->Check(TRUE);

	String aFNam;
	String aFilt;
    sal_Bool bAsLink;
    pLogo1->GetGraphic( aFNam, aFilt, bAsLink );
	if( !aFNam.Len() )
		aFNam = SW_RESSTR( STR_Lgo_NoSelect );

	FNam2FixedText( aFNam, *pL_Edit_LogoFN );
	pL_MEdt_LogoTx->SetText( pLogo1->GetStr() );
	SetDisable();
}

void WizardLogoDlg::SetDisable()
{
	if( pL_RBtn_GrLogo->IsChecked() || pL_RBtn_TxLogo->IsChecked() )
	{
		BOOL bFlag = pL_RBtn_GrLogo->IsChecked();
		pWizDlg->ShowHideWin( *pL_Edit_LogoFN, bFlag );
		pWizDlg->ShowHideWin( *pL_PBtn_LogoFN, bFlag );
        pWizDlg->ShowHideWin( *pL_FL_LogoFN, bFlag );
		pWizDlg->ShowHideWin( *pL_MEdt_LogoTx, !bFlag );
		pWizDlg->ShowHideWin( *pL_Text_LogoTx, !bFlag );
	}

	BOOL bDisable = pL_RBtn_NoLogo->IsChecked();

	MultiOne aWinList;
	Fill( aWinList );
	USHORT Anz = aWinList.GetAnz();
	for( USHORT i = 0; i < Anz; ++i )
	{
		Window* pWin = aWinList.GetWin(i);
		if( pWin && pWin != pL_Text_LgoArt && pWin != pL_RBtn_NoLogo &&
			pWin != pL_RBtn_GrLogo && pWin != pL_RBtn_TxLogo )
		{
			pWin->Enable(!bDisable);
		}
	}
	SetMetric();
	SetBBtnDisable();
}

void WizardLogoDlg::SetBBtnDisable()
{
	if( !pLogo1 )
		return;

	BOOL bLogoLi = pLogo1->IsVisible(), bLogoMi = bLogoLi, bLogoRe = bLogoLi;

	if( bLogoLi )
		switch( eBeware )
		{
		case ALIGN_LiOb:
			bLogoLi = FALSE;
			bLogoMi = FALSE;
			pLogo1->SetAlign( ALIGN_ReOb, &pWizDlg->aPrevWin );
			break;

		case ALIGN_ReOb:
			bLogoRe = FALSE;
			bLogoMi = FALSE;
			pLogo1->SetAlign( ALIGN_LiOb, &pWizDlg->aPrevWin );
			break;
		}

	pL_BBtn_LogoLi->Enable(bLogoLi);
	pL_BBtn_LogoMi->Enable(bLogoMi);
	pL_BBtn_LogoRe->Enable(bLogoRe);
}

void WizardLogoDlg::SetBeware(PageAlign eBwr)
{
	eBeware = eBwr;
	SetBBtnDisable();
}

void WizardLogoDlg::SetMetric()
{
	if( !pLogo1 )
		return;

	pL_MFld_LogoHo->SetValue( pLogo1->GetHor(), FUNIT_CM );
	pL_MFld_LogoVe->SetValue( pLogo1->GetVer(), FUNIT_CM );
	BOOL bLgo = pLogo1->IsVisible();
	String aStr;
	BOOL bEnable = bLgo && pLogo1->GetHorStr( aStr );
	if( bEnable )
		  pL_Text_LogoHo->SetText(aStr);
	pL_Text_LogoHo->Enable(bEnable);
	pL_MFld_LogoHo->Enable(bEnable);

	bEnable = bLgo && pLogo1->GetVerStr( aStr );
	if( bEnable )
		pL_Text_LogoVe->SetText(aStr);
	pL_Text_LogoVe->Enable(bEnable);
	pL_MFld_LogoVe->Enable(bEnable);
}

IMPL_LINK( WizardLogoDlg, BBtnHdl, Button *, pBtn )
{
	if( !pLogo1 )
		return 0;

	PageAlign eTmp = ALIGN_LiOb;
	if( pBtn == pL_BBtn_LogoMi )
		eTmp = ALIGN_MiOb;
	else if( pBtn == pL_BBtn_LogoRe )
		eTmp = ALIGN_ReOb;

	pLogo1->SetAlign( eTmp, &pWizDlg->aPrevWin );
	SetMetric();
	return 0;
}

IMPL_LINK( WizardLogoDlg, MFldHdl, MetricField *, pEdt )
{
	if( !pLogo1 )
		return 0;

	USHORT nVal = USHORT( pEdt->GetValue(FUNIT_CM) );
	Window* pPrevWin = &pWizDlg->aPrevWin;

	if( pEdt == pL_MFld_LogoWd)
		pLogo1->SetWdt( nVal, pPrevWin );
	else if( pEdt == pL_MFld_LogoHg)
		pLogo1->SetHgt(nVal, pPrevWin );
	else if( pEdt == pL_MFld_LogoHo)
		pLogo1->SetHor(nVal, pPrevWin );
	else if( pEdt == pL_MFld_LogoVe)
		pLogo1->SetVer(nVal, pPrevWin );

	//SetDisable();
	return 0;
}

IMPL_LINK( WizardLogoDlg, RBtnHdl, RadioButton *, pBtn )
{
	Window* pPrevWin = &pWizDlg->aPrevWin;
	if( pBtn == pL_RBtn_NoLogo)
	{
		if( pLogo1 )
			pLogo1->Hide( pPrevWin );
		if( pLogoF )
			pLogoF->Hide( pPrevWin );
	}
	else if( pBtn == pL_RBtn_GrLogo )
	{
		if( pLogo1 )
		{
			pLogo1->SetModeGraf( pPrevWin );
			pLogo1->Show( pPrevWin );
		}
		if( pLogoF )
		{
			pLogoF->SetModeGraf( pPrevWin );
			pLogoF->Show( pPrevWin );
		}
	}
	else if( pBtn == pL_RBtn_TxLogo )
	{
		if( pLogo1 )
		{
			pLogo1->SetModeText( pPrevWin );
			pLogo1->Show( pPrevWin );
		}
		if( pLogoF )
		{
			pLogoF->SetModeText( pPrevWin );
			pLogoF->Show( pPrevWin );
		}
	}
	SetDisable();
	return 0;
}

IMPL_LINK_INLINE_START( WizardLogoDlg, MEdtHdl, MultiLineEdit *, pEdt )
{
	if( pLogo1 )
		pLogo1->SetStr( pEdt->GetText(), &pWizDlg->aPrevWin );
	if( pLogoF )
		pLogoF->SetStr( pEdt->GetText(), &pWizDlg->aPrevWin );
	return 0;
}
IMPL_LINK_INLINE_END( WizardLogoDlg, MEdtHdl, MultiLineEdit *, pEdt )

IMPL_LINK( WizardLogoDlg, PBtnHdl, PushButton *, pBtn )
{
    FileDialogHelper* pFileDlg = new FileDialogHelper( SFXWB_GRAPHIC );
    pFileDlg->SetTitle(SW_RESSTR( STR_Lgo_WTGrphic ));
    Reference < XFilePicker > xFP = pFileDlg->GetFilePicker();
    Reference < XFilePickerControlAccess > xCtrlAcc(xFP, UNO_QUERY);

    if( ERRCODE_NONE == pFileDlg->Execute() )
	{
        Any aVal = xCtrlAcc->getValue( ExtendedFilePickerElementIds::CHECKBOX_LINK, 0);
        DBG_ASSERT(aVal.hasValue(), "Value CBX_INSERT_AS_LINK not found")
        BOOL bAsLink = aVal.hasValue() ? *(sal_Bool*) aVal.getValue() : sal_True;

        String aFNam( pFileDlg->GetPath() );
        String aFilt( pFileDlg->GetCurrentFilter() );
		if( pLogo1 )
            pLogo1->SetGraphic( aFNam, aFilt, bAsLink );
		if( pLogoF )
            pLogoF->SetGraphic( aFNam, aFilt, bAsLink );
		FNam2FixedText( aFNam, *pL_Edit_LogoFN );
	}
    delete pFileDlg;

	return 0;
}

void WizardLogoDlg::SetEventHandler()
{
	Link aLk = LINK( this, WizardLogoDlg, BBtnHdl );
	pL_BBtn_LogoLi->SetClickHdl( aLk );
	pL_BBtn_LogoMi->SetClickHdl( aLk );
	pL_BBtn_LogoRe->SetClickHdl( aLk );

	aLk = LINK( this, WizardLogoDlg, MFldHdl );
	pL_MFld_LogoWd->SetModifyHdl( aLk );
	pL_MFld_LogoHg->SetModifyHdl( aLk );
	pL_MFld_LogoHo->SetModifyHdl( aLk );
	pL_MFld_LogoVe->SetModifyHdl( aLk );

	aLk = LINK( this, WizardLogoDlg, RBtnHdl );
	pL_RBtn_NoLogo->SetClickHdl( aLk );
	pL_RBtn_GrLogo->SetClickHdl( aLk );
	pL_RBtn_TxLogo->SetClickHdl( aLk );

	pL_MEdt_LogoTx->SetModifyHdl(LINK(this,WizardLogoDlg,MEdtHdl));

	pL_PBtn_LogoFN->SetClickHdl(LINK(this,WizardLogoDlg,PBtnHdl));
}


}
