/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbdatdef.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:45:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBDATDEF_HXX
#define _SBA_DBDATDEF_HXX

#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif

#ifndef _SDB_SDBCONT_HXX //autogen
#include <sdb/sdbcont.hxx>
#endif

#ifndef _SBA_DBDEFOBJ_HXX
#include "dbdefobj.hxx"
#endif

#ifndef _SDB_SDBCONN_HXX //autogen
#include <sdb/sdbconn.hxx>
#endif

#ifndef	_SVSTDARR_ULONGS
#define _SVSTDARR_ULONGS
#include <svtools/svstdarr.hxx>
#endif

#ifndef _SDB_ROW_HXX
#include <sdb/row.hxx>
#endif
class SvNumberFormatter; 
class FontList; 
class Font; 
class SfxPoolItem;
namespace binfilter {


class SvxNumberInfoItem;
class SdbConnection;
class SvxFontListItem;

class XColorTable;
class SdbColumn;

class SbaDataObj;


DECLARE_LIST(SbaDataObjList, SbaDataObj*)//STRIP008 DECLARE_LIST(SbaDataObjList, SbaDataObj*);

//==================================================================
// SbaColumn
//==================================================================
DBG_NAMEEX(SbaColumn)//STRIP008
class SbaColumn : public SvRefBase, public SfxItemSet
{
	friend class SbaDBDataDef;

protected:
	SbaColumn(SfxItemPool& _rPool, USHORT nWhich1, USHORT nWhich2)
		:SfxItemSet(_rPool, nWhich1, nWhich2){ DBG_CTOR(SbaColumn,NULL);}
	SbaColumn(SfxItemPool& _rPool, const USHORT* nWhichPairTable)
		:SfxItemSet(_rPool, nWhichPairTable){DBG_CTOR(SbaColumn,NULL);}
	SbaColumn(SfxItemPool& _rPool, BOOL bTotalPoolRanges = FALSE)
		:SfxItemSet(_rPool, bTotalPoolRanges){DBG_CTOR(SbaColumn,NULL);}
	~SbaColumn(){ DBG_DTOR(SbaColumn,NULL); }
public:
	virtual SfxItemSet* Clone(BOOL bItems = TRUE, SfxItemPool *pToPool = 0) const;

	// vergleicht nur die Attribute, die fuer SDB relevant sind
	// welche Attribute das sind, weiss die Definition, da diese
	// Treiber abhaengig sind
	virtual BOOL CompareCoreAttrs(const SbaColumn& _rCol,
								  const SbaDBDataDef& _rDef) const;
};

SV_DECL_IMPL_REF(SbaColumn);

//==================================================================

DECL_SDBKEYREFCONT_VIRT(SbaColumnMap,SbaColumn*);
DBG_NAMEEX(SbaColumnList)//STRIP008
class SbaColumnList : public SbaColumnMap,
					  public SvRefBase
{
	SdbIdentifierCase eIdentifierCase;

public:
	SbaColumnList(SdbIdentifierCase _eCase = SDB_IC_MIXED,
				  USHORT _nInitSize = 16,
				  USHORT _nReSize = 16 )
				 :SbaColumnMap(BOOL(_eCase == SDB_IC_ALL), _nInitSize, _nReSize )
				 ,eIdentifierCase(_eCase){DBG_CTOR(SbaColumnList,NULL);}

	SbaColumnList( USHORT _nBlockSize, USHORT _nInitSize,
				   USHORT _nReSize, SdbIdentifierCase _eCase = SDB_IC_MIXED)
				  :SbaColumnMap(_nBlockSize,_nInitSize,_nReSize,_eCase == SDB_IC_ALL)
				  ,eIdentifierCase(_eCase){DBG_CTOR(SbaColumnList,NULL);}
	~SbaColumnList(){ DBG_DTOR(SbaColumnList,NULL); }

	// spezielles Lookup falls mehrere gleichnamige Spalten (unterschiedlicher Tabellen)
	// angelegt sind (Join bei einer Abfrage)
	virtual SbaColumn* Lookup(const String& _rFieldName, const String& _rTableName) const;
	virtual SbaColumnList& operator= (const SbaColumnList&);
	virtual BOOL operator ==(const SbaColumnList &) const;
	BOOL operator !=(const SbaColumnList & _rList) const
		{return !operator ==(_rList);}

	// siehe Oben
	virtual BOOL CompareCoreAttrs(const SbaColumnList& _rCols,
								  const SbaDBDataDef& _rDef) const;

	SdbIdentifierCase GetIdentifierCase() const {return eIdentifierCase;}
	void SetIdentifierCase(SdbIdentifierCase _eCase);
	String ShortenFieldName( const String& rName, xub_StrLen nNewLength);

protected:
	BOOL IsCaseSensitive() const {return SbaColumnMap::IsCaseSensitive();}
	void SetCaseSensitive(BOOL _bCaseSensitive) {SbaColumnMap::SetCaseSensitive(_bCaseSensitive);}
	virtual SvRefBase* Find(const String& _rKey) const;
};

SV_DECL_IMPL_REF(SbaColumnList);

//==================================================================

//==================================================================
// SbaDBDataDef
//==================================================================
class SbaDBDataDef : public SbaDBDef
{
	friend class SbaQueryObj;
	friend class SbaColumn;

protected:
	SbaColumnListRef		xOriginalColumns,		// Spalten der Definition
							xColumns;				// Struktur um Spalten zu aendern
	BOOL					bAttrsModified : 1;		// Modifizieren von Attributen
	ULONG					nUsageCount;			// wird dieses Objekt bereits von Datenobjekten verwendet

	XColorTable*			pColorTable;
	SfxItemSet*				pObjAttrSet;
	SfxItemPool*			pPool;
	SbaDataObjList			aDataObjList;			// aktuell geoeffnet AbfrageObjekte
	SvULongs				aCoreWhichList;			// Liste von WhichIds der Feldattribute
													// die beim Speichern von in die native Datenbank
													// relevant ist.

public:
	// Pooldefaults werden beim ableben der DLL gel"oscht
	static SfxPoolItem *ppPoolDefaults[];
	static USHORT nPoolDefaultsLen;

	TYPEINFO();
	SbaDBDataDef(SbaDatabase* pDB,
				 const String& rName,
				 DBObject eObj,
				 BOOL bNew = TRUE,
				 BOOL bShow = TRUE);

	// Zugriff auf den Pool, Notwendig zu Clonen
	SfxItemPool* GetPool() const {return pPool;}

	// Zugriff auf die Feldinformationen
	const SbaColumnList& GetOriginalColumns() const {return *xOriginalColumns;}
	SbaColumnList&		 GetColumns() {return *xColumns;}
	SbaColumn*			 GetColumn(const String& _rFieldName,
								   const String& _rTableName = String() )
							{return xOriginalColumns->Lookup(_rFieldName, _rTableName);}
	void				 SetDefault( const ODbRowRef& xRow);
	void				 SetDefault( const SdbColumnsRef& xColumnsRef );

	// String in ODbVariantRef umwandeln mit FormatInfos in pColumn
	BOOL				 FillVariant(const ODbVariantRef& xVar, const String& rString, SbaColumn* pColumn );

	// Im Gegensatz zu SdbColumns: Die Zaehlung beginnt bei 0 !!!
	SbaColumn*			 GetColumn(UINT16 nPos) const {return xOriginalColumns->GetObject(nPos);}
	UINT16				 Count() const {return (UINT16)xOriginalColumns->Count();}

	// Columns erzeugen
	virtual SbaColumn* CreateColumn(const String& rName,
									SbaFieldType eType,
									UINT32 nLength,
									UINT16 nScale,
									BOOL bRequired,
									UINT32 nKey,
									UINT16 nPos,
									const String& rDefault = String()) const;

	virtual SbaColumn* CreateColumn(const SdbColumn& rCol) const;
	SdbColumn* CreateColumn(const SbaColumn& rSbaCol) const;
#if _SOLAR__PRIVATE
	SbaColumn* CreateColumn(const SbaColumn& rColumn,BOOL bDummy) const;
#endif

	// nur Definitionen, denen ein Namen zugeordnet ist
	// koennen auch Daten abspeichern.
	// dieses kann in der Regel nur fuer Abfragen zutreffen,
	// die nur fuer eine temp Anzeige im Beamer gedacht sind.
	BOOL IsTemp() const {return aName.Len() == 0;}
	BOOL IsUsed() const {return nUsageCount != 0;}

	virtual BOOL SetLock(BOOL _bLocked);
	virtual BOOL IsModified() const;
	// speichert geaenderte Attributierung
	virtual BOOL Update();

	// Erstellen eines AbfrageObjekts
	virtual SbaDataObj* CreateDataObj();

	inline String GetOutputString(const ODbVariantRef& xVar, USHORT nCol, Color** ppCol) const;
	inline String GetInputString(const ODbVariantRef& xVar, USHORT nCol, Color** ppCol) const;

	static String TypeString(SbaFieldType eFieldType);
	static String SizeString(SbaNumericSize eSizeType);
	static UINT32 GetFieldLength(const SdbColumn& rCol);

	// Usage-Counter
	void AddUsage();
	void ReleaseUsage();

protected:
	virtual	~SbaDBDataDef();
	virtual void RemoveChildren();
	virtual void RemoveChild(SdbObj* pObj);
	virtual SbaDataObj* CreateDataObjImpl() = 0;

	virtual BOOL IsDataUpdateAllowed() const;

	virtual String GetString(const ODbVariantRef& xVar, USHORT nCol, Color** ppCol, BOOL bOutput) const;

protected:
	// bMergePkKeys gibt an ob die PkKey Info aus der SdbColumn in die SbaColumn bertragen werden soll
	BOOL Load(const SdbColumns* pCols = NULL,BOOL bMergePkKeys = TRUE);	// Einlesen der Daten aus der Datenbank
	BOOL Store();								// Speichern der Daten
	// bMergePkKeys gibt an ob die PkKey Info aus der SdbColumn in die SbaColumn bertragen werden soll
	void Merge(const SdbColumns& rCols,BOOL bMergePkKeys = TRUE);		// Abgleich mit aktueller ColumnStruktur
	void FillColumns(const SdbColumns& rCols);

	// Zugriff auf die SDB-Datenbank
	BOOL BeginTrans(BOOL bForStore);
	BOOL EndTrans(BOOL bCommit = FALSE);
	BOOL Commit() {return EndTrans(TRUE);}
	BOOL Rollback(){return EndTrans(FALSE);}

private:
	void CreatePool();

public:
	// Attribute der Definition
	SfxItemSet*	GetObjAttrs() const {return pObjAttrSet;}
	void PutObjAttrs(const SfxItemSet& rSet);

	virtual SvNumberFormatter* GetFormatter() const;
	const SvxFontListItem& GetFontListItem() const;
};

SV_DECL_IMPL_REF(SbaDBDataDef);

//==================================================================
// SbaDataObj
// Entsprechung zum Cursor aus SDB
//==================================================================
class SbaDataObj : public SbaDBObj
{
	UINT16				nCacheSize;			// default 200
protected:
	SdbCursor*			pCursor;			// aktueller Cursor
	String				aSQLStatement;
	BOOL				bNative : 1;		// sql statement wird ohne zu parsen an den
											// treiber weitergegeben
	BOOL				bForUpdate : 1;		// geoeffnet zum schreiben

public:
	TYPEINFO();
	SbaDataObj(SbaDBDataDef* pDBDef,
				 const String& rSQLStatement,
				 BOOL _bNative,
				 const String& rName,
				 BOOL bShow = TRUE);			// Sollen Fehler angezeigt werden

	virtual	~SbaDataObj();
	virtual SbaDBDataDef* GetDataDef() const;
	inline  SbaDatabase*  GetDatabase() const
		{return GetDataDef() ? GetDataDef()->GetDatabase() : NULL;}

	virtual void ReInit(const String& rSQLStatement);
	virtual BOOL Prepare();
	virtual BOOL Open();
	virtual BOOL IsPrepared() const;

	BOOL IsNative() const {return bNative;}
	SdbCursor* GetCursor() const {return pCursor;}
	const String& SQLStatement() const {return aSQLStatement;}

	void SetCacheSize(UINT16 nSize);

	virtual BOOL IsUpdateAllowed() const = 0;
	BOOL SetUpdatable(BOOL bUpdate);
	BOOL IsUpdatable() const;

	UINT16 CacheSize() const {return nCacheSize;}
	INT32  CountAll();

protected:
	virtual void Close();
};

SV_DECL_IMPL_REF(SbaDataObj);

//==================================================================

//------------------------------------------------------------------------------
inline String SbaDBDataDef::GetOutputString(const ODbVariantRef& xVar, USHORT nCol, Color** pColor) const
{
	return GetString(xVar,nCol, pColor, TRUE);
}

//------------------------------------------------------------------------------
inline String SbaDBDataDef::GetInputString(const ODbVariantRef& xVar, USHORT nCol, Color** pColor) const
{
	return GetString(xVar,nCol, pColor, FALSE);
}



} //namespace binfilter
#endif

