/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dragmt3d.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:17:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _E3D_DRAGMT3D_HXX
#define _E3D_DRAGMT3D_HXX

#ifndef _SVDDRGMT_HXX
#include "svddrgmt.hxx"
#endif

#ifndef _E3D_VIEW3D_HXX
#include "view3d.hxx"
#endif

#ifndef _POLY3D_HXX
#include "poly3d.hxx"
#endif

#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif
namespace binfilter {

class E3dScene;

/*************************************************************************
|*
|* Parameter fuer Interaktion eines 3D-Objektes
|*
\************************************************************************/

class E3dDragMethodUnit
{
public:
	E3dObject*			p3DObj;
	Polygon3D			aWireframePoly;
	Matrix4D			aDisplayTransform;
	Matrix4D			aInvDisplayTransform;
	Matrix4D            aInitTransform;
	Matrix4D			aTransform;
	INT32				nStartAngle;
	INT32				nLastAngle;

	// TimingVars
	UINT8						nOrigQuality;

	E3dDragMethodUnit() {}
};

/*************************************************************************
|*
|* Parameter fuer Interaktion eines 3D-Objektes
|*
\************************************************************************/

SV_DECL_PTRARR_DEL(E3dDragMethodUnitGroup, E3dDragMethodUnit*, 1, 3)//STRIP008 ;

/*************************************************************************
|*
|* Ableitung von SdrDragMethod fuer 3D-Objekte
|*
\************************************************************************/

//STRIP001 class E3dDragMethod : public SdrDragMethod
//STRIP001 {
//STRIP001 protected:
//STRIP001 	E3dDragMethodUnitGroup		aGrp;
//STRIP001 	E3dDragConstraint			eConstraint;
//STRIP001 	E3dDragDetail				eDragDetail;
//STRIP001 	Point						aLastPos;
//STRIP001 	Rectangle					aFullBound;
//STRIP001 	BOOL						bMoveFull;
//STRIP001 	BOOL						bMovedAtAll;
//STRIP001 	Timer						aCallbackTimer;
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	E3dDragMethod(SdrDragView &rView,
//STRIP001 		const SdrMarkList& rMark,
//STRIP001 		E3dDragDetail eDetail,
//STRIP001 		E3dDragConstraint eConstr = E3DDRAG_CONSTR_XYZ,
//STRIP001 		BOOL bFull=FALSE);
//STRIP001 
//STRIP001 	virtual void TakeComment(String& rStr) const;
//STRIP001 
//STRIP001 	virtual FASTBOOL Beg();
//STRIP001 	virtual void Mov(const Point& rPnt);
//STRIP001 	virtual void Brk();
//STRIP001 	virtual FASTBOOL End(FASTBOOL bCopy);
//STRIP001 
//STRIP001 	virtual void DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const;
//STRIP001 	E3dView& Get3DView()  { return (E3dView&)rView;  }
//STRIP001 
//STRIP001 	DECL_LINK(TimerInterruptHdl, void*);
//STRIP001 };


/*************************************************************************
|*
|* Ableitung von SdrDragMethod zum Drehen von 3D-Objekten
|*
\************************************************************************/

//STRIP001 class E3dDragRotate : public E3dDragMethod
//STRIP001 {
//STRIP001 	Vector3D				aGlobalCenter;
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	E3dDragRotate(SdrDragView &rView,
//STRIP001 		const SdrMarkList& rMark,
//STRIP001 		E3dDragDetail eDetail,
//STRIP001 		E3dDragConstraint eConstr = E3DDRAG_CONSTR_XYZ,
//STRIP001 		BOOL bFull=FALSE);
//STRIP001 
//STRIP001 	virtual void Mov(const Point& rPnt);
//STRIP001 	virtual Pointer GetPointer() const;
//STRIP001 };


/*************************************************************************
|*
|* Ableitung von SdrDragMethod zum Verschieben von 3D-Subobjekten
|*
\************************************************************************/

//STRIP001 class E3dDragMove : public E3dDragMethod
//STRIP001 {
//STRIP001 	SdrHdlKind				eWhatDragHdl;
//STRIP001 	Point					aScaleFixPos;
//STRIP001 
//STRIP001 public:
//STRIP001 	TYPEINFO();
//STRIP001 	E3dDragMove(SdrDragView &rView,
//STRIP001 		const SdrMarkList& rMark,
//STRIP001 		E3dDragDetail eDetail,
//STRIP001 		SdrHdlKind eDrgHdl = HDL_MOVE,
//STRIP001 		E3dDragConstraint eConstr = E3DDRAG_CONSTR_XYZ,
//STRIP001 		BOOL bFull=FALSE);
//STRIP001 
//STRIP001 	virtual void Mov(const Point& rPnt);
//STRIP001 	virtual Pointer GetPointer() const;
//STRIP001 };


}//end of namespace binfilter
#endif			// _E3D_DRAGMT3D_HXX
