// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_TEST_FAKE_RENDERER_SCHEDULER_H_
#define CONTENT_TEST_FAKE_RENDERER_SCHEDULER_H_

#include "base/macros.h"
#include "components/scheduler/renderer/renderer_scheduler.h"

namespace content {

class FakeRendererScheduler : public scheduler::RendererScheduler {
 public:
  FakeRendererScheduler();
  ~FakeRendererScheduler() override;

  // RendererScheduler implementation.
  std::unique_ptr<blink::WebThread> CreateMainThread() override;
  scoped_refptr<scheduler::TaskQueue> DefaultTaskRunner() override;
  scoped_refptr<scheduler::TaskQueue> CompositorTaskRunner() override;
  scoped_refptr<scheduler::TaskQueue> LoadingTaskRunner() override;
  scoped_refptr<scheduler::SingleThreadIdleTaskRunner> IdleTaskRunner()
      override;
  scoped_refptr<scheduler::TaskQueue> TimerTaskRunner() override;
  scoped_refptr<scheduler::TaskQueue> NewLoadingTaskRunner(
      const char* name) override;
  scoped_refptr<scheduler::TaskQueue> NewTimerTaskRunner(
      const char* name) override;
  std::unique_ptr<scheduler::RenderWidgetSchedulingState>
  NewRenderWidgetSchedulingState() override;
  void WillBeginFrame(const cc::BeginFrameArgs& args) override;
  void BeginFrameNotExpectedSoon() override;
  void DidCommitFrameToCompositor() override;
  void DidHandleInputEventOnCompositorThread(
      const blink::WebInputEvent& web_input_event,
      InputEventState event_state) override;
  void DidHandleInputEventOnMainThread(
      const blink::WebInputEvent& web_input_event) override;
  void DidAnimateForInputOnCompositorThread() override;
  void OnRendererBackgrounded() override;
  void OnRendererForegrounded() override;
  void SuspendRenderer() override;
  void AddPendingNavigation(
      blink::WebScheduler::NavigatingFrameType type) override;
  void RemovePendingNavigation(
      blink::WebScheduler::NavigatingFrameType type) override;
  void OnNavigationStarted() override;
  bool IsHighPriorityWorkAnticipated() override;
  bool CanExceedIdleDeadlineIfRequired() const override;
  bool ShouldYieldForHighPriorityWork() override;
  void AddTaskObserver(base::MessageLoop::TaskObserver* task_observer) override;
  void RemoveTaskObserver(
      base::MessageLoop::TaskObserver* task_observer) override;
  void Shutdown() override;
  void SuspendTimerQueue() override;
  void ResumeTimerQueue() override;
  void SetTimerQueueSuspensionWhenBackgroundedEnabled(bool enabled) override;
  void SetTopLevelBlameContext(
      base::trace_event::BlameContext* blame_context) override;
  void SetRAILModeObserver(RAILModeObserver* observer) override;

 private:
  DISALLOW_COPY_AND_ASSIGN(FakeRendererScheduler);
};

}  // namespace content

#endif  // CONTENT_TEST_FAKE_RENDERER_SCHEDULER_H_
