# libFuzzer and ClusterFuzz Integration

*** note
Most links on this page are private.
***

ClusterFuzz is a distributed fuzzing infrastructure 
([go/clusterfuzz](https://goto.google.com/clusterfuzz)) that automatically
executes libFuzzer tests on scale.

## Status Links

* [Buildbot] - status of all libFuzzer builds.
* [ClusterFuzz Fuzzer Status] - fuzzing metrics, links to crashes and coverage 
reports.
* [ClusterFuzz libFuzzer Logs] - individual fuzzer run logs.
* [Corpus GCS Bucket] - current corpus for each fuzzer. Can be used to upload
bootstrapped corpus.

## Integration Details

The integration between libFuzzer and ClusterFuzz consists of:

* Build rules definition in [fuzzer_test.gni].
* [Buildbot] that automatically discovers fuzzers using `gn refs` facility, 
builds fuzzers with multiple sanitizers and uploads binaries to a special
GCS bucket. Build bot recipe is defined in [chromium_libfuzzer.py].
* ClusterFuzz downloads new binaries once a day and runs fuzzers continuously.
* Fuzzer run logs are uploaded to [ClusterFuzz libFuzzer Logs] GCS bucket.
* Fuzzing corpus is maintained for each fuzzer in [Corpus GCS Bucket]. Once a day
corpus is minimized to reduce number of duplicates and/or reduce effect of 
parasitic coverage. 
* [ClusterFuzz Fuzzer Status] displays fuzzer runtime 
metrics as well as provides links to crashes and coverage reports. The information
is collected every 30 minutes.


## Corpus
ClusterFuzz uses two corpus types with libFuzzer:

* **Seed** (or **static**) corpus: files manually uploaded by developers.
ClusterFuzz uses these files for fuzzing but doesn't delete/overwrite them.

* **General** (or **working**) corpus: files generated by fuzzers themselves.
These corpus files are frequently modified during fuzzing sessions and can be
deleted during corpus minimization.

A fuzzer has two input corpus directories, seed and general, but its output
goes into general corpus directory. Seed corpus is read-only.


[Buildbot]: https://goto.google.com/libfuzzer-clusterfuzz-buildbot
[chromium_libfuzzer.py]: https://code.google.com/p/chromium/codesearch#chromium/build/scripts/slave/recipes/chromium_libfuzzer.py
[ClusterFuzz Fuzzer Status]: https://goto.google.com/libfuzzer-clusterfuzz-status
[ClusterFuzz libFuzzer Logs]: https://goto.google.com/libfuzzer-clusterfuzz-logs
[Corpus GCS Bucket]: https://goto.google.com/libfuzzer-clusterfuzz-corpus
[fuzzer_test.gni]: https://code.google.com/p/chromium/codesearch#chromium/src/testing/libfuzzer/fuzzer_test.gni
