# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'internal_ozone_platform_deps': [
      'ozone_platform_gbm',
    ],
    'internal_ozone_platform_unittest_deps': [
      'ozone_platform_gbm_unittests',
    ],
    'internal_ozone_platforms': [
      'gbm',
    ],
    'use_drm_atomic%': 0,
  },
  'targets': [
    {
      'target_name': 'drm_atomic',
      'type': 'none',
      'conditions': [
        ['use_drm_atomic==1', {
          'direct_dependent_settings': {
            'defines': [
              'USE_DRM_ATOMIC',
            ],
          },
        }],
      ],
    },
    {
      'target_name': 'ozone_platform_gbm',
      'type': 'static_library',
      'dependencies': [
        'ozone.gyp:ozone_base',
        'ozone.gyp:ozone_common',
        '../../base/base.gyp:base',
        '../../build/linux/system.gyp:libdrm',
        '../../third_party/minigbm/minigbm.gyp:minigbm',
        '../../skia/skia.gyp:skia',
        '../../third_party/khronos/khronos.gyp:khronos_headers',
        '../base/ui_base.gyp:ui_base',
        '../display/display.gyp:display_types',
        '../display/display.gyp:display_util',
        '../events/devices/events_devices.gyp:events_devices',
        '../events/events.gyp:events',
        '../events/ozone/events_ozone.gyp:events_ozone',
        '../events/ozone/events_ozone.gyp:events_ozone_evdev',
        '../events/ozone/events_ozone.gyp:events_ozone_layout',
        '../events/platform/events_platform.gyp:events_platform',
        '../gfx/gfx.gyp:gfx',
        '../gfx/gfx.gyp:gfx_geometry',
        'drm_atomic',
      ],
      'defines': [
        'OZONE_IMPLEMENTATION',
      ],
      'sources': [
        'client_native_pixmap_factory_gbm.cc',
        'client_native_pixmap_factory_gbm.h',
        'common/client_native_pixmap_dmabuf.cc',
        'common/client_native_pixmap_dmabuf.h',
        'common/drm_util.cc',
        'common/drm_util.h',
        'common/scoped_drm_types.cc',
        'common/scoped_drm_types.h',
        'gpu/crtc_controller.cc',
        'gpu/crtc_controller.h',
        'gpu/display_change_observer.h',
        'gpu/drm_buffer.cc',
        'gpu/drm_buffer.h',
        'gpu/drm_console_buffer.cc',
        'gpu/drm_console_buffer.h',
        'gpu/drm_device.cc',
        'gpu/drm_device.h',
        'gpu/drm_device_generator.cc',
        'gpu/drm_device_generator.h',
        'gpu/drm_device_manager.cc',
        'gpu/drm_device_manager.h',
        'gpu/drm_display.cc',
        'gpu/drm_display.h',
        'gpu/drm_gpu_display_manager.cc',
        'gpu/drm_gpu_display_manager.h',
        'gpu/drm_gpu_platform_support.cc',
        'gpu/drm_gpu_platform_support.h',
        'gpu/drm_overlay_validator.cc',
        'gpu/drm_overlay_validator.h',
        'gpu/drm_thread.cc',
        'gpu/drm_thread.h',
        'gpu/drm_thread_message_proxy.cc',
        'gpu/drm_thread_message_proxy.h',
        'gpu/drm_thread_proxy.cc',
        'gpu/drm_thread_proxy.h',
        'gpu/drm_vsync_provider.cc',
        'gpu/drm_vsync_provider.h',
        'gpu/drm_window.cc',
        'gpu/drm_window.h',
        'gpu/drm_window_proxy.cc',
        'gpu/drm_window_proxy.h',
        'gpu/gbm_buffer.cc',
        'gpu/gbm_buffer.h',
        'gpu/gbm_buffer_base.cc',
        'gpu/gbm_buffer_base.h',
        'gpu/gbm_device.cc',
        'gpu/gbm_device.h',
        'gpu/gbm_surface_factory.cc',
        'gpu/gbm_surface_factory.h',
        'gpu/gbm_surfaceless.cc',
        'gpu/gbm_surfaceless.h',
        'gpu/hardware_display_controller.cc',
        'gpu/hardware_display_controller.h',
        'gpu/hardware_display_plane.cc',
        'gpu/hardware_display_plane.h',
        'gpu/hardware_display_plane_manager.cc',
        'gpu/hardware_display_plane_manager.h',
        'gpu/hardware_display_plane_manager_legacy.cc',
        'gpu/hardware_display_plane_manager_legacy.h',
        'gpu/inter_thread_messaging_proxy.cc',
        'gpu/inter_thread_messaging_proxy.h',
        'gpu/overlay_plane.cc',
        'gpu/overlay_plane.h',
        'gpu/page_flip_request.cc',
        'gpu/page_flip_request.h',
        'gpu/proxy_helpers.cc',
        'gpu/proxy_helpers.h',
        'gpu/screen_manager.cc',
        'gpu/screen_manager.h',
        'host/drm_cursor.cc',
        'host/drm_cursor.h',
        'host/drm_device_handle.cc',
        'host/drm_device_handle.h',
        'host/drm_display_host.cc',
        'host/drm_display_host.h',
        'host/drm_display_host_manager.cc',
        'host/drm_display_host_manager.h',
        'host/drm_gpu_platform_support_host.cc',
        'host/drm_gpu_platform_support_host.h',
        'host/drm_native_display_delegate.cc',
        'host/drm_native_display_delegate.h',
        'host/drm_overlay_candidates_host.cc',
        'host/drm_overlay_candidates_host.h',
        'host/drm_overlay_manager.cc',
        'host/drm_overlay_manager.h',
        'host/drm_window_host.cc',
        'host/drm_window_host.h',
        'host/drm_window_host_manager.cc',
        'host/drm_window_host_manager.h',
        'host/gpu_thread_adapter.h',
        'host/gpu_thread_observer.h',
        'mus_thread_proxy.cc',
        'mus_thread_proxy.h',
        'ozone_platform_gbm.cc',
        'ozone_platform_gbm.h',
      ],
      'conditions': [
        ['use_drm_atomic == 1', {
          'sources': [
            'gpu/hardware_display_plane_atomic.cc',
            'gpu/hardware_display_plane_atomic.h',
            'gpu/hardware_display_plane_manager_atomic.cc',
            'gpu/hardware_display_plane_manager_atomic.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'ozone_platform_gbm_unittests',
      'type': 'none',
      'dependencies': [
        '../../build/linux/system.gyp:libdrm',
        '../../skia/skia.gyp:skia',
        '../gfx/gfx.gyp:gfx',
        '../gfx/gfx.gyp:gfx_geometry',
        'ozone.gyp:ozone_platform',
        'drm_atomic',
      ],
      'export_dependent_settings': [
        '../../build/linux/system.gyp:libdrm',
        '../../skia/skia.gyp:skia',
        '../gfx/gfx.gyp:gfx_geometry',
        'drm_atomic',
      ],
      'direct_dependent_settings': {
        'sources': [
          'gpu/drm_overlay_validator_unittest.cc',
          'gpu/drm_window_unittest.cc',
          'gpu/fake_plane_info.cc',
          'gpu/fake_plane_info.h',
          'gpu/hardware_display_controller_unittest.cc',
          'gpu/hardware_display_plane_manager_unittest.cc',
          'gpu/mock_dumb_buffer_generator.cc',
          'gpu/mock_dumb_buffer_generator.h',
          'gpu/mock_drm_device.cc',
          'gpu/mock_drm_device.h',
          'gpu/mock_hardware_display_plane_manager.cc',
          'gpu/mock_hardware_display_plane_manager.h',
          'gpu/mock_scanout_buffer.cc',
          'gpu/mock_scanout_buffer.h',
          'gpu/mock_scanout_buffer_generator.cc',
          'gpu/mock_scanout_buffer_generator.h',
          'gpu/screen_manager_unittest.cc',
        ],
      },
    },
  ],
}
