/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;
import java.util.Set;

public class DescendantTokenCheck
extends Check {
    private int mMinimumDepth;
    private int mMaximumDepth = Integer.MAX_VALUE;
    private int mMinimumNumber;
    private int mMaximumNumber = Integer.MAX_VALUE;
    private boolean mSumTokenCounts;
    private int[] mLimitedTokens = new int[0];
    private String mMinimumMessage;
    private String mMaximumMessage;
    private int[] mCounts = new int[0];

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void visitToken(DetailAST aAST) {
        Arrays.fill(this.mCounts, 0);
        this.countTokens(aAST, 0);
        String name = TokenTypes.getTokenName(aAST.getType());
        if (this.mSumTokenCounts) {
            int total = 0;
            for (int element : this.mLimitedTokens) {
                total += this.mCounts[element - 1];
            }
            if (total < this.mMinimumNumber) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), null == this.mMinimumMessage ? "descendant.token.sum.min" : this.mMinimumMessage, String.valueOf(total), String.valueOf(this.mMinimumNumber), name);
            }
            if (total > this.mMaximumNumber) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), null == this.mMaximumMessage ? "descendant.token.sum.max" : this.mMaximumMessage, String.valueOf(total), String.valueOf(this.mMaximumNumber), name);
            }
        } else {
            for (int element : this.mLimitedTokens) {
                String descendantName;
                int tokenCount = this.mCounts[element - 1];
                if (tokenCount < this.mMinimumNumber) {
                    descendantName = TokenTypes.getTokenName(element);
                    this.log(aAST.getLineNo(), aAST.getColumnNo(), null == this.mMinimumMessage ? "descendant.token.min" : this.mMinimumMessage, String.valueOf(tokenCount), String.valueOf(this.mMinimumNumber), name, descendantName);
                }
                if (tokenCount <= this.mMaximumNumber) continue;
                descendantName = TokenTypes.getTokenName(element);
                this.log(aAST.getLineNo(), aAST.getColumnNo(), null == this.mMaximumMessage ? "descendant.token.max" : this.mMaximumMessage, String.valueOf(tokenCount), String.valueOf(this.mMaximumNumber), name, descendantName);
            }
        }
    }

    private void countTokens(AST aAST, int aDepth) {
        if (aDepth <= this.mMaximumDepth) {
            int type;
            if (aDepth >= this.mMinimumDepth && (type = aAST.getType()) <= this.mCounts.length) {
                int n = type - 1;
                this.mCounts[n] = this.mCounts[n] + 1;
            }
            int nextDepth = aDepth + 1;
            for (AST child = aAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.countTokens(child, nextDepth);
            }
        }
    }

    public int[] getAcceptableTokens() {
        Set<String> tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        for (String name : tokenNames) {
            result[i++] = TokenTypes.getTokenId(name);
        }
        return result;
    }

    public void setLimitedTokens(String[] aLimitedTokens) {
        this.mLimitedTokens = new int[aLimitedTokens.length];
        int maxToken = 0;
        for (int i = 0; i < aLimitedTokens.length; ++i) {
            this.mLimitedTokens[i] = TokenTypes.getTokenId(aLimitedTokens[i]);
            if (this.mLimitedTokens[i] <= maxToken) continue;
            maxToken = this.mLimitedTokens[i];
        }
        this.mCounts = new int[maxToken];
    }

    public void setMinimumDepth(int aMinimumDepth) {
        this.mMinimumDepth = aMinimumDepth;
    }

    public void setMaximumDepth(int aMaximumDepth) {
        this.mMaximumDepth = aMaximumDepth;
    }

    public void setMinimumNumber(int aMinimumNumber) {
        this.mMinimumNumber = aMinimumNumber;
    }

    public void setMaximumNumber(int aMaximumNumber) {
        this.mMaximumNumber = aMaximumNumber;
    }

    public void setMinimumMessage(String aMessage) {
        this.mMinimumMessage = aMessage;
    }

    public void setMaximumMessage(String aMessage) {
        this.mMaximumMessage = aMessage;
    }

    public void setSumTokenCounts(boolean aSum) {
        this.mSumTokenCounts = aSum;
    }
}

