// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2013 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _OXIDE_SHARED_COMMON_CONTENT_CLIENT_H_
#define _OXIDE_SHARED_COMMON_CONTENT_CLIENT_H_

#include <string>

#include "base/basictypes.h"
#include "base/compiler_specific.h"
#include "content/public/common/content_client.h"

template <typename Type> struct DefaultSingletonTraits;

namespace oxide {

class ContentBrowserClient;
class ContentRendererClient;

class ContentClient FINAL : public content::ContentClient {
 public:
  static ContentClient* GetInstance();
  static ContentClient* instance();
  virtual ~ContentClient();

  ContentBrowserClient* browser();
  ContentRendererClient* renderer();

  void SetUserAgent(const std::string& user_agent);

 private:
  friend struct DefaultSingletonTraits<ContentClient>;
  ContentClient();

  // content::ContentClient implementation
  void AddPepperPlugins(std::vector<content::PepperPluginInfo>* plugins) FINAL;
  std::string GetUserAgent() const FINAL;
  base::string16 GetLocalizedString(int message_id) const FINAL;
  base::StringPiece GetDataResource(int resource_id,
                                    ui::ScaleFactor scale_factor) const FINAL;
  base::RefCountedStaticMemory* GetDataResourceBytes(
      int resource_id) const FINAL;

  std::string user_agent_;

  DISALLOW_COPY_AND_ASSIGN(ContentClient);
};

} // namespace oxide

#endif // _OXIDE_SHARED_COMMON_CONTENT_CLIENT_H_
