

  Polymer('core-input', {

    publish: {

      /**
       * The "committed" value of the input, ie. the input value when the user
       * hits the "enter" key or blurs the input after changing the value. You
       * can bind to this value instead of listening for the "change" event.
       * Setting this property has no effect on the input value.
       *
       * @attribute committedValue
       * @type string
       * @default ''
       */
      committedValue: '',

      /**
       * Set to true to prevent invalid input from being entered.
       *
       * @attribute preventInvalidInput
       * @type boolean
       * @default false
       */
      preventInvalidInput: false

    },

    previousValidInput: '',

    eventDelegates: {
      input: 'inputAction',
      change: 'changeAction'
    },

    ready: function() {
      /* set ARIA attributes */
      this.disabledHandler();
      this.placeholderHandler();
    },

    attributeChanged: function(attr, old) {
      if (this[attr + 'Handler']) {
        this[attr + 'Handler'](old);
      }
    },

    disabledHandler: function() {
      if (this.disabled) {
        this.setAttribute('aria-disabled', '');
      } else {
        this.removeAttribute('aria-disabled');
      }
    },

    placeholderHandler: function() {
      if (this.placeholder) {
        this.setAttribute('aria-label', this.placeholder);
      } else {
        this.removeAttribute('aria-label');
      }
    },

    /**
     * Commits the `value` to `committedValue`
     *
     * @method commit
     */
    commit: function() {
      this.committedValue = this.value;
    },

    changeAction: function() {
      this.commit();
    },

    inputAction: function(e) {
      if (this.preventInvalidInput) {
        if (!e.target.validity.valid) {
          e.target.value = this.previousValidInput;
        } else {
          this.previousValidInput = e.target.value;
        }
      }
    }

  });

