

  Polymer('paper-tabs',Polymer.mixin({
    
    /**
     * If true, ink ripple effect is disabled.
     *
     * @attribute noink
     * @type boolean
     * @default false
     */
    noink: false,
    
    /**
     * If true, the bottom bar to indicate the selected tab will not be shown.
     *
     * @attribute nobar
     * @type boolean
     * @default false
     */
    nobar: false,
    
    /**
     * If true, the slide effect for the bottom bar is disabled.
     *
     * @attribute noslide
     * @type boolean
     * @default false
     */
    noslide: false,
    
    /**
     * If true, tabs are scrollable and the tab width is based on the label width.
     *
     * @attribute scrollable
     * @type boolean
     * @default false
     */
    scrollable: false,
    
    /**
     * If true, dragging on the tabs to scroll is disabled.
     *
     * @attribute disableDrag
     * @type boolean
     * @default false
     */
    disableDrag: false,
    
    /**
     * If true, scroll buttons (left/right arrow) will be hidden for scrollable tabs.
     *
     * @attribute hideScrollButton
     * @type boolean
     * @default false
     */
    hideScrollButton: false,

    eventDelegates: {
      'core-resize': 'resizeHandler'
    },
    
    activateEvent: 'tap',
    
    step: 10,
    
    holdDelay: 10,
    
    ready: function() {
      this.super();
      this._trackxHandler = this.trackx.bind(this);
      Polymer.addEventListener(this.$.tabsContainer, 'trackx', this._trackxHandler);
      this._tabsObserver = new MutationObserver(this.updateBar.bind(this));
    },
    
    domReady: function() {
      this.async('resizeHandler');
      this._tabsObserver.observe(this, {childList: true, subtree: true, characterData: true});
    },

    attached: function() {
      this.resizableAttachedHandler();
    },
    
    detached: function() {
      Polymer.removeEventListener(this.$.tabsContainer, 'trackx', this._trackxHandler);
      this._tabsObserver.disconnect();
      this.resizableDetachedHandler();
    },
    
    trackStart: function(e) {
      if (!this.scrollable || this.disableDrag) {
        return;
      }
      var t = e.target;
      if (t && t.cancelRipple) {
        t.cancelRipple();
      }
      this._startx = this.$.tabsContainer.scrollLeft;
      e.preventTap();
    },
    
    trackx: function(e) {
      if (!this.scrollable || this.disableDrag) {
        return;
      }
      this.$.tabsContainer.scrollLeft = this._startx - e.dx;
    },
    
    resizeHandler: function() {
      this.scroll();
      this.updateBar();
    },
    
    scroll: function() {
      if (!this.scrollable) {
        return;
      }
      var tc = this.$.tabsContainer;
      var l = tc.scrollLeft;
      this.leftHidden = l === 0;
      this.rightHidden = l === (tc.scrollWidth - tc.clientWidth);
    },
    
    holdLeft: function() {
      this.holdJob = setInterval(this.scrollToLeft.bind(this), this.holdDelay);
    },
    
    holdRight: function() {
      this.holdJob = setInterval(this.scrollToRight.bind(this), this.holdDelay);
    },
    
    releaseHold: function() {
      clearInterval(this.holdJob);
      this.holdJob = null;
    },
    
    scrollToLeft: function() {
      this.$.tabsContainer.scrollLeft -= this.step;
    },
    
    scrollToRight: function() {
      this.$.tabsContainer.scrollLeft += this.step;
    },
    
    /**
     * Invoke this to update the size and position of the bottom bar.  Usually
     * you only need to call this if the `paper-tabs` is initially hidden and
     * later becomes visible.
     *
     * @method updateBar
     */
    updateBar: function() {
      this.async('selectedItemChanged');
    },
    
    selectedItemChanged: function(old) {
      var oldIndex = this.selectedIndex;
      this.super(arguments);
      var s = this.$.selectionBar.style;
      
      if (!this.selectedItem) {
        s.width = 0;
        s.left = 0;
        return;
      } 
      
      var r = this.$.tabsContent.getBoundingClientRect();
      this._w = r.width;
      this._l = r.left;
      
      r = this.selectedItem.getBoundingClientRect();
      this._sw = r.width;
      this._sl = r.left;
      this._sOffsetLeft = this._sl - this._l; 
      
      if (this.noslide || old == null) {
        this.positionBarForSelected();
        return;
      }
      
      var oldRect = old.getBoundingClientRect();
      
      var m = 5;
      this.$.selectionBar.classList.add('expand');
      if (oldIndex < this.selectedIndex) {
        s.width = this.calcPercent(this._sl + this._sw - oldRect.left) - m + '%';
        this._transitionCounter = 1;
      } else {
        s.width = this.calcPercent(oldRect.left + oldRect.width - this._sl) - m + '%';
        s.left = this.calcPercent(this._sOffsetLeft) + m + '%';
        this._transitionCounter = 2;
      }
      if (this.scrollable) {
        this.scrollToSelectedIfNeeded();
      }
    },
    
    scrollToSelectedIfNeeded: function() {
      var scrollLeft = this.$.tabsContainer.scrollLeft;
      // scroll to selected if needed
      if (this._sOffsetLeft + this._sw < scrollLeft || 
          this._sOffsetLeft - scrollLeft > this.$.tabsContainer.offsetWidth) {
        this.$.tabsContainer.scrollLeft = this._sOffsetLeft;
      }
    },
    
    positionBarForSelected: function() {
      var s = this.$.selectionBar.style;
      s.width = this.calcPercent(this._sw) + '%';
      s.left = this.calcPercent(this._sOffsetLeft) + '%';
    },
    
    calcPercent: function(w) {
      return 100 * w / this._w;
    },
    
    barTransitionEnd: function(e) {
      this._transitionCounter--;
      var cl = this.$.selectionBar.classList;
      if (cl.contains('expand') && !this._transitionCounter) {
        cl.remove('expand');
        cl.add('contract');
        this.positionBarForSelected();
      } else if (cl.contains('contract')) {
        cl.remove('contract');
      }
    }
    
  }, Polymer.CoreResizable));
  
