#ifndef INCLUDE_DRIVER_BACKLIGHT_X1600_H
#define INCLUDE_DRIVER_BACKLIGHT_X1600_H
/**
 * @brief Low level backlight driver for ATI X1600 graphics card.
 *
 * This file contains some definitions and the prototypes for the
 * X1600 backlight driver.
 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/driver_backlight_x1600.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 * @author  Stefan Bruda <bruda@cs.ubishops.ca> 
 * @author  Nicolas Boichat <nicolas@boichat.ch>
 * @author  Julien Blache <jb@jblache.org>
 */

#define PCI_ID_VENDOR_ATI     0x1002
#define PCI_ID_PRODUCT_X1600  0x71c5

#define X1600_BRIGHTNESS_MIN    32    /* This value must never be 0 */
#define X1600_BRIGHTNESS_MAX    255

struct driver_backlight *driver_backlight_x1600_init ();

#endif    /* INCLUDE_DRIVER_BACKLIGHT_X1600_H */
