#line 1 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
/* hash.cmod -*- c -*- */

#include "global.h"
RCSID("$Id: hash.cmod,v 1.18 2004/02/21 18:36:06 nilsson Exp $");
#include "interpret.h"
#include "svalue.h"
#include "threads.h"

/* For this_object() */
#include "object.h"
#include "module_support.h"

#include "nettle_config.h"

#ifdef HAVE_LIBNETTLE

#include "nettle.h"

#include <nettle/md5.h>
#ifdef HAVE_NETTLE_MD4_INIT
#include <nettle/md4.h>
#include <nettle/md2.h>
#endif
#include <nettle/sha.h>
#include <nettle/nettle-meta.h>

#include <assert.h>
#include <stdio.h>
#include <stdarg.h>

#if 0
static void
werror(const char *format, ...)
{
  va_list args;

  va_start(args, format);
  vfprintf(stderr, format, args);
  va_end(args);
}
#else
#define werror(x)
#endif

/*! @module Nettle */

/*! @class HashInfo
 *!
 *! Represents information about a hash algorithm, such as
 *! name, digest size, and internal block size.
 */

#undef class_HashInfo_defined
#define class_HashInfo_defined
struct program *HashInfo_program=0;
int HashInfo_program_fun_num=-1;

#undef var_meta_HashInfo_defined
#define var_meta_HashInfo_defined

#undef THIS
#define THIS ((struct HashInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_HASHINFO
#define THIS_HASHINFO ((struct HashInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_HASHINFO
#define OBJ2_HASHINFO(o) ((struct HashInfo_struct *)(o->storage+HashInfo_storage_offset))

#undef GET_HASHINFO_STORAGE
#define GET_HASHINFO_STORAGE ((struct HashInfo_struct *)(o->storage+HashInfo_storage_offset)
static ptrdiff_t HashInfo_storage_offset;
struct HashInfo_struct {

#ifdef var_meta_HashInfo_defined
#line 54 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
const struct nettle_hash *meta;
#endif /* var_meta_HashInfo_defined */
};
/*! @decl string name(void)
   *!
   *! Returns a human readable name for the algorithm.
   */
  #define f_HashInfo_name_defined
ptrdiff_t f_HashInfo_name_fun_num = 0;
void f_HashInfo_name(INT32 args) {
#line 60 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(args != 0) wrong_number_of_args_error("name",args,0);
#line 62 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      if (!THIS->meta)
	Pike_error("HashInfo not properly initialized.\n");

      push_text(THIS->meta->name);
    }

  }
/*! @decl string digest_size(void)
   *!
   *! Returns the size of a hash digests.
   */
  #define f_HashInfo_digest_size_defined
ptrdiff_t f_HashInfo_digest_size_fun_num = 0;
void f_HashInfo_digest_size(INT32 args) {
#line 73 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(args != 0) wrong_number_of_args_error("digest_size",args,0);
#line 75 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      if (!THIS->meta)
	Pike_error("HashInfo not properly initialized.\n");

      push_int(THIS->meta->digest_size);
    }

  }
/*! @decl string block_size(void)
   *!
   *! Returns the internal block size of the hash algorithm.
   */
  #define f_HashInfo_block_size_defined
ptrdiff_t f_HashInfo_block_size_fun_num = 0;
void f_HashInfo_block_size(INT32 args) {
#line 86 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(args != 0) wrong_number_of_args_error("block_size",args,0);
#line 88 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      if (!THIS->meta)
	Pike_error("HashInfo not properly initialized.\n");

      push_int(THIS->meta->block_size);
    }
  }

#undef internal_init_HashInfo_defined
#define internal_init_HashInfo_defined

#undef HashInfo_event_handler_defined
#define HashInfo_event_handler_defined
static void init_HashInfo_struct(void)
#line 95 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      werror("HashInfo->INIT\n");
      THIS->meta = NULL;
    }

#ifdef HashInfo_event_handler_defined
static void HashInfo_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_HashInfo_defined
  case PROG_EVENT_INIT: init_HashInfo_struct(); break;

#endif /* internal_init_HashInfo_defined */
  default: break; 
  }
}

#endif /* HashInfo_event_handler_defined */
/*! @endclass HashInfo */

#line 103 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
#define GET_META(o) \
( ((struct HashInfo_struct *) get_storage((o), HashInfo_program)) \
  ->meta)

/* The algorithm objects have to be implemented in pike. */

/*! @class HashState
 *!
 *! Base class for hashing contexts.
 */

#undef class_HashState_defined
#define class_HashState_defined
struct program *HashState_program=0;
int HashState_program_fun_num=-1;

#undef inherit_HashInfo_HashState_defined
#define inherit_HashInfo_HashState_defined

#undef var_ctx_HashState_defined
#define var_ctx_HashState_defined

#undef THIS
#define THIS ((struct HashState_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_HASHSTATE
#define THIS_HASHSTATE ((struct HashState_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_HASHSTATE
#define OBJ2_HASHSTATE(o) ((struct HashState_struct *)(o->storage+HashState_storage_offset))

#undef GET_HASHSTATE_STORAGE
#define GET_HASHSTATE_STORAGE ((struct HashState_struct *)(o->storage+HashState_storage_offset)
static ptrdiff_t HashState_storage_offset;
struct HashState_struct {

#ifdef var_ctx_HashState_defined
#line 116 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
void *ctx;
#endif /* var_ctx_HashState_defined */
};
#line 118 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
/* FIXME: Create should copy state from the other object, if
   * provided. */

  /*! @decl HashState update(string data)
   *!
   *! Hashes more data.
   */
  #define f_HashState_update_defined
ptrdiff_t f_HashState_update_fun_num = 0;
void f_HashState_update(INT32 args) {
#line 125 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct pike_string * data;
#line 125 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(args != 1) wrong_number_of_args_error("update",args,1);
#line 125 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("update",1,"string");
#line 125 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 127 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      const void *ctx = THIS->ctx;
      const struct nettle_hash *meta =
	GET_META(Pike_fp->current_object);

      if (!ctx || !meta)
	Pike_error("HashState not properly initialized.\n");

      NO_WIDE_STRING(data);
      THREADS_ALLOW();
      meta->update(ctx, data->len, data->str);
      THREADS_DISALLOW();

      push_object(this_object());
    }

  }
/*! @decl string digest(int|void length)
   *!
   *! Generates a digests, and resets the hashing contents.
   *!
   *! @param length
   *!   If the length argument is provided, the digest is truncated
   *!   to the given length.
   *!
   *! @returns
   *!   The digest.
   */
  #define f_HashState_digest_defined
ptrdiff_t f_HashState_digest_fun_num = 0;
void f_HashState_digest(INT32 args) {
#line 154 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct svalue * arg;
#line 154 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
if(args > 1) wrong_number_of_args_error("digest",args,1);
if (args > 0) {
#line 154 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
arg=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else arg=0;
#line 155 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      const struct nettle_hash *meta;
      struct pike_string *digest;
      unsigned length;

      if (! THIS->ctx)
	Pike_error("HashState not properly initialized.\n");

      meta = GET_META(Pike_fp->current_object);
      assert(meta);
      
      if (!arg)
	length = meta->digest_size;
      else
	{
	  if (arg->type != PIKE_T_INT)
	    Pike_error("Bad argument type.\n");
	  if (arg->u.integer < 0)
	    Pike_error("Invalid length, must be positive.\n");
	  if ((unsigned)arg->u.integer > meta->digest_size)
	    Pike_error("Unsupported digest length.\n");

	  length = arg->u.integer;
	}
      
      digest = begin_shared_string(length);
      meta->digest(THIS->ctx, length, digest->str);
      push_string(end_shared_string(digest));
    }

  }

#undef internal_init_HashState_defined
#define internal_init_HashState_defined

#undef HashState_event_handler_defined
#define HashState_event_handler_defined
static void init_HashState_struct(void)
#line 186 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      werror("HashState->INIT\n");
      THIS->ctx = NULL;
    }
  
#undef internal_exit_HashState_defined
#define internal_exit_HashState_defined

#undef HashState_event_handler_defined
#define HashState_event_handler_defined
static void exit_HashState_struct(void)
#line 191 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      werror("HashState->EXIT\n");
      if (THIS->ctx && Pike_fp->current_object->prog)
      {
	const struct nettle_hash *meta =
	  GET_META(Pike_fp->current_object);
	assert(meta);
	memset(THIS->ctx, 0, meta->context_size);
      }
    }

#ifdef HashState_event_handler_defined
static void HashState_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_HashState_defined
  case PROG_EVENT_INIT: init_HashState_struct(); break;

#endif /* internal_init_HashState_defined */

#ifdef internal_exit_HashState_defined
  case PROG_EVENT_EXIT: exit_HashState_struct(); break;

#endif /* internal_exit_HashState_defined */
  default: break; 
  }
}

#endif /* HashState_event_handler_defined */
/*! @endclass HashState */

/*! @class MD5_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with HashInfo. */


#undef class_MD5_Info_defined
#define class_MD5_Info_defined
struct program *MD5_Info_program=0;
int MD5_Info_program_fun_num=-1;

#undef internal_init_MD5_Info_defined
#define internal_init_MD5_Info_defined

#undef MD5_Info_event_handler_defined
#define MD5_Info_event_handler_defined
static void init_MD5_Info_struct(void)
#line 213 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashInfo_struct *HashInfo
	= (struct HashInfo_struct *) get_storage(Pike_fp->current_object,
						 HashInfo_program);

      werror("MD5_Info->INIT\n");
      
      if (HashInfo && !HashInfo->meta)
	HashInfo->meta = &nettle_md5;
      else {
	/* Can't call Pike_error here. 
	 * Pike_error("Can't initialize this object.\n"); */
	werror("MD5_Info->INIT failed\n");
      }
    }

#ifdef MD5_Info_event_handler_defined
static void MD5_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD5_Info_defined
  case PROG_EVENT_INIT: init_MD5_Info_struct(); break;

#endif /* internal_init_MD5_Info_defined */
  default: break; 
  }
}

#endif /* MD5_Info_event_handler_defined */
/*! @endclass MD5_Info */

/*! @class MD5_State
 *!
 *! State for MD5 hashing.
 */

#undef class_MD5_State_defined
#define class_MD5_State_defined
struct program *MD5_State_program=0;
int MD5_State_program_fun_num=-1;

#undef inherit_MD5_Info_MD5_State_defined
#define inherit_MD5_Info_MD5_State_defined

#undef inherit_HashState_MD5_State_defined
#define inherit_HashState_MD5_State_defined

#undef var_md5_MD5_State_defined
#define var_md5_MD5_State_defined

#undef THIS
#define THIS ((struct MD5_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MD5_STATE
#define THIS_MD5_STATE ((struct MD5_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MD5_STATE
#define OBJ2_MD5_STATE(o) ((struct MD5_State_struct *)(o->storage+MD5_State_storage_offset))

#undef GET_MD5_STATE_STORAGE
#define GET_MD5_STATE_STORAGE ((struct MD5_State_struct *)(o->storage+MD5_State_storage_offset)
static ptrdiff_t MD5_State_storage_offset;
struct MD5_State_struct {

#ifdef var_md5_MD5_State_defined
#line 240 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct md5_ctx md5;
#endif /* var_md5_MD5_State_defined */
};

#undef internal_init_MD5_State_defined
#define internal_init_MD5_State_defined

#undef MD5_State_event_handler_defined
#define MD5_State_event_handler_defined
static void init_MD5_State_struct(void)
#line 243 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashState_struct *instance
	= (struct HashState_struct *) get_storage(Pike_fp->current_object,
						  HashState_program);
      werror("MD5_State->INIT\n");

      assert(instance);

      md5_init(&THIS->md5);      
      instance->ctx = &THIS->md5;
    }

#ifdef MD5_State_event_handler_defined
static void MD5_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD5_State_defined
  case PROG_EVENT_INIT: init_MD5_State_struct(); break;

#endif /* internal_init_MD5_State_defined */
  default: break; 
  }
}

#endif /* MD5_State_event_handler_defined */
/*! @endclass MD5_State */

#line 257 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
#ifdef HAVE_NETTLE_MD4_INIT

/*! @class MD4_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with HashInfo. */


#undef class_MD4_Info_defined
#define class_MD4_Info_defined
struct program *MD4_Info_program=0;
int MD4_Info_program_fun_num=-1;

#undef internal_init_MD4_Info_defined
#define internal_init_MD4_Info_defined

#undef MD4_Info_event_handler_defined
#define MD4_Info_event_handler_defined
static void init_MD4_Info_struct(void)
#line 267 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashInfo_struct *HashInfo
	= (struct HashInfo_struct *) get_storage(Pike_fp->current_object,
						 HashInfo_program);

      werror("MD4_Info->INIT\n");
      
      if (HashInfo && !HashInfo->meta)
	HashInfo->meta = &nettle_md4;
      else {
	/* Can't call Pike_error here. 
	 * Pike_error("Can't initialize this object.\n"); */
	werror("MD4_Info->INIT failed\n");
      }
    }

#ifdef MD4_Info_event_handler_defined
static void MD4_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD4_Info_defined
  case PROG_EVENT_INIT: init_MD4_Info_struct(); break;

#endif /* internal_init_MD4_Info_defined */
  default: break; 
  }
}

#endif /* MD4_Info_event_handler_defined */
/*! @endclass MD4_Info */

/*! @class MD4_State
 *!
 *! State for MD4 hashing.
 */

#undef class_MD4_State_defined
#define class_MD4_State_defined
struct program *MD4_State_program=0;
int MD4_State_program_fun_num=-1;

#undef inherit_MD4_Info_MD4_State_defined
#define inherit_MD4_Info_MD4_State_defined

#undef inherit_HashState_MD4_State_defined
#define inherit_HashState_MD4_State_defined

#undef var_md4_MD4_State_defined
#define var_md4_MD4_State_defined

#undef THIS
#define THIS ((struct MD4_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MD4_STATE
#define THIS_MD4_STATE ((struct MD4_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MD4_STATE
#define OBJ2_MD4_STATE(o) ((struct MD4_State_struct *)(o->storage+MD4_State_storage_offset))

#undef GET_MD4_STATE_STORAGE
#define GET_MD4_STATE_STORAGE ((struct MD4_State_struct *)(o->storage+MD4_State_storage_offset)
static ptrdiff_t MD4_State_storage_offset;
struct MD4_State_struct {

#ifdef var_md4_MD4_State_defined
#line 294 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct md4_ctx md4;
#endif /* var_md4_MD4_State_defined */
};

#undef internal_init_MD4_State_defined
#define internal_init_MD4_State_defined

#undef MD4_State_event_handler_defined
#define MD4_State_event_handler_defined
static void init_MD4_State_struct(void)
#line 297 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashState_struct *instance
	= (struct HashState_struct *) get_storage(Pike_fp->current_object,
						  HashState_program);
      werror("MD4_State->INIT\n");

      assert(instance);

      md4_init(&THIS->md4);
      instance->ctx = &THIS->md4;
    }

#ifdef MD4_State_event_handler_defined
static void MD4_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD4_State_defined
  case PROG_EVENT_INIT: init_MD4_State_struct(); break;

#endif /* internal_init_MD4_State_defined */
  default: break; 
  }
}

#endif /* MD4_State_event_handler_defined */
/*! @endclass MD4_State */

/*! @class MD2_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with HashInfo. */


#undef class_MD2_Info_defined
#define class_MD2_Info_defined
struct program *MD2_Info_program=0;
int MD2_Info_program_fun_num=-1;

#undef internal_init_MD2_Info_defined
#define internal_init_MD2_Info_defined

#undef MD2_Info_event_handler_defined
#define MD2_Info_event_handler_defined
static void init_MD2_Info_struct(void)
#line 319 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashInfo_struct *HashInfo
	= (struct HashInfo_struct *) get_storage(Pike_fp->current_object,
						 HashInfo_program);

      werror("MD2_Info->INIT\n");
      
      if (HashInfo && !HashInfo->meta)
	HashInfo->meta = &nettle_md2;
      else {
	/* Can't call Pike_error here. 
	 * Pike_error("Can't initialize this object.\n"); */
	werror("MD2_Info->INIT failed\n");
      }
    }

#ifdef MD2_Info_event_handler_defined
static void MD2_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD2_Info_defined
  case PROG_EVENT_INIT: init_MD2_Info_struct(); break;

#endif /* internal_init_MD2_Info_defined */
  default: break; 
  }
}

#endif /* MD2_Info_event_handler_defined */
/*! @endclass MD2_Info */

/*! @class MD2_State
 *!
 *! State for MD2 hashing.
 */

#undef class_MD2_State_defined
#define class_MD2_State_defined
struct program *MD2_State_program=0;
int MD2_State_program_fun_num=-1;

#undef inherit_MD2_Info_MD2_State_defined
#define inherit_MD2_Info_MD2_State_defined

#undef inherit_HashState_MD2_State_defined
#define inherit_HashState_MD2_State_defined

#undef var_md2_MD2_State_defined
#define var_md2_MD2_State_defined

#undef THIS
#define THIS ((struct MD2_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MD2_STATE
#define THIS_MD2_STATE ((struct MD2_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MD2_STATE
#define OBJ2_MD2_STATE(o) ((struct MD2_State_struct *)(o->storage+MD2_State_storage_offset))

#undef GET_MD2_STATE_STORAGE
#define GET_MD2_STATE_STORAGE ((struct MD2_State_struct *)(o->storage+MD2_State_storage_offset)
static ptrdiff_t MD2_State_storage_offset;
struct MD2_State_struct {

#ifdef var_md2_MD2_State_defined
#line 346 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct md2_ctx md2;
#endif /* var_md2_MD2_State_defined */
};

#undef internal_init_MD2_State_defined
#define internal_init_MD2_State_defined

#undef MD2_State_event_handler_defined
#define MD2_State_event_handler_defined
static void init_MD2_State_struct(void)
#line 349 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashState_struct *instance
	= (struct HashState_struct *) get_storage(Pike_fp->current_object,
						  HashState_program);
      werror("MD2_State->INIT\n");

      assert(instance);

      md2_init(&THIS->md2);
      instance->ctx = &THIS->md2;
    }

#ifdef MD2_State_event_handler_defined
static void MD2_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_MD2_State_defined
  case PROG_EVENT_INIT: init_MD2_State_struct(); break;

#endif /* internal_init_MD2_State_defined */
  default: break; 
  }
}

#endif /* MD2_State_event_handler_defined */
/*! @endclass MD2_State */

#line 363 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
#endif /* HAVE_NETTLE_MD4_INIT */

/*! @class SHA1_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with HashInfo. */


#undef class_SHA1_Info_defined
#define class_SHA1_Info_defined
struct program *SHA1_Info_program=0;
int SHA1_Info_program_fun_num=-1;

#undef internal_init_SHA1_Info_defined
#define internal_init_SHA1_Info_defined

#undef SHA1_Info_event_handler_defined
#define SHA1_Info_event_handler_defined
static void init_SHA1_Info_struct(void)
#line 373 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashInfo_struct *HashInfo
	= (struct HashInfo_struct *) get_storage(Pike_fp->current_object,
						 HashInfo_program);

      werror("SHA1_Info->INIT\n");
      
      if (HashInfo && !HashInfo->meta)
	HashInfo->meta = &nettle_sha1;
      else {
	/* Can't call Pike_error here. 
	 * Pike_error("Can't initialize this object.\n"); */
	werror("SHA1_Info->INIT failed\n");
      }
    }

#ifdef SHA1_Info_event_handler_defined
static void SHA1_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_SHA1_Info_defined
  case PROG_EVENT_INIT: init_SHA1_Info_struct(); break;

#endif /* internal_init_SHA1_Info_defined */
  default: break; 
  }
}

#endif /* SHA1_Info_event_handler_defined */
/*! @endclass SHA1_Info */

/*! @class SHA1_State
 *!
 *! State for SHA1 hashing.
 */


#undef class_SHA1_State_defined
#define class_SHA1_State_defined
struct program *SHA1_State_program=0;
int SHA1_State_program_fun_num=-1;

#undef inherit_SHA1_Info_SHA1_State_defined
#define inherit_SHA1_Info_SHA1_State_defined

#undef inherit_HashState_SHA1_State_defined
#define inherit_HashState_SHA1_State_defined

#undef var_sha1_SHA1_State_defined
#define var_sha1_SHA1_State_defined

#undef THIS
#define THIS ((struct SHA1_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SHA1_STATE
#define THIS_SHA1_STATE ((struct SHA1_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SHA1_STATE
#define OBJ2_SHA1_STATE(o) ((struct SHA1_State_struct *)(o->storage+SHA1_State_storage_offset))

#undef GET_SHA1_STATE_STORAGE
#define GET_SHA1_STATE_STORAGE ((struct SHA1_State_struct *)(o->storage+SHA1_State_storage_offset)
static ptrdiff_t SHA1_State_storage_offset;
struct SHA1_State_struct {

#ifdef var_sha1_SHA1_State_defined
#line 401 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct sha1_ctx sha1;
#endif /* var_sha1_SHA1_State_defined */
};

#undef internal_init_SHA1_State_defined
#define internal_init_SHA1_State_defined

#undef SHA1_State_event_handler_defined
#define SHA1_State_event_handler_defined
static void init_SHA1_State_struct(void)
#line 404 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashState_struct *instance
	= (struct HashState_struct *) get_storage(Pike_fp->current_object,
						  HashState_program);
      werror("SHA1_State->INIT\n");

      assert(instance);

      sha1_init(&THIS->sha1);      
      instance->ctx = &THIS->sha1;
    }

#ifdef SHA1_State_event_handler_defined
static void SHA1_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_SHA1_State_defined
  case PROG_EVENT_INIT: init_SHA1_State_struct(); break;

#endif /* internal_init_SHA1_State_defined */
  default: break; 
  }
}

#endif /* SHA1_State_event_handler_defined */
/*! @endclass SHA1_State */

/*! @class SHA256_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with HashInfo. */


#undef class_SHA256_Info_defined
#define class_SHA256_Info_defined
struct program *SHA256_Info_program=0;
int SHA256_Info_program_fun_num=-1;

#undef internal_init_SHA256_Info_defined
#define internal_init_SHA256_Info_defined

#undef SHA256_Info_event_handler_defined
#define SHA256_Info_event_handler_defined
static void init_SHA256_Info_struct(void)
#line 426 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashInfo_struct *HashInfo
	= (struct HashInfo_struct *) get_storage(Pike_fp->current_object,
						 HashInfo_program);

      werror("SHA256_Info->INIT\n");
      
      if (HashInfo && !HashInfo->meta)
	HashInfo->meta = &nettle_sha256;
      else {
	/* Can't call Pike_error here. 
	 * Pike_error("Can't initialize this object.\n"); */
	werror("SHA256_Info->INIT failed\n");
      }
    }

#ifdef SHA256_Info_event_handler_defined
static void SHA256_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_SHA256_Info_defined
  case PROG_EVENT_INIT: init_SHA256_Info_struct(); break;

#endif /* internal_init_SHA256_Info_defined */
  default: break; 
  }
}

#endif /* SHA256_Info_event_handler_defined */
/*! @endclass SHA256_Info */

/*! @class SHA256_State
 *!
 *! State for SHA256 hashing.
 */


#undef class_SHA256_State_defined
#define class_SHA256_State_defined
struct program *SHA256_State_program=0;
int SHA256_State_program_fun_num=-1;

#undef inherit_SHA256_Info_SHA256_State_defined
#define inherit_SHA256_Info_SHA256_State_defined

#undef inherit_HashState_SHA256_State_defined
#define inherit_HashState_SHA256_State_defined

#undef var_sha256_SHA256_State_defined
#define var_sha256_SHA256_State_defined

#undef THIS
#define THIS ((struct SHA256_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SHA256_STATE
#define THIS_SHA256_STATE ((struct SHA256_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SHA256_STATE
#define OBJ2_SHA256_STATE(o) ((struct SHA256_State_struct *)(o->storage+SHA256_State_storage_offset))

#undef GET_SHA256_STATE_STORAGE
#define GET_SHA256_STATE_STORAGE ((struct SHA256_State_struct *)(o->storage+SHA256_State_storage_offset)
static ptrdiff_t SHA256_State_storage_offset;
struct SHA256_State_struct {

#ifdef var_sha256_SHA256_State_defined
#line 454 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
struct sha256_ctx sha256;
#endif /* var_sha256_SHA256_State_defined */
};

#undef internal_init_SHA256_State_defined
#define internal_init_SHA256_State_defined

#undef SHA256_State_event_handler_defined
#define SHA256_State_event_handler_defined
static void init_SHA256_State_struct(void)
#line 457 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
{
      struct HashState_struct *instance
	= (struct HashState_struct *) get_storage(Pike_fp->current_object,
						  HashState_program);
      werror("SHA256_State->INIT\n");

      assert(instance);

      sha256_init(&THIS->sha256);
      instance->ctx = &THIS->sha256;
    }

#ifdef SHA256_State_event_handler_defined
static void SHA256_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_SHA256_State_defined
  case PROG_EVENT_INIT: init_SHA256_State_struct(); break;

#endif /* internal_init_SHA256_State_defined */
  default: break; 
  }
}

#endif /* SHA256_State_event_handler_defined */
/*! @endclass SHA256_State */

/*! @endmodule Nettle */

#line 473 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
void
hash_init(void)
{
  werror("Nettle, hash init\n");
  
#ifdef class_HashInfo_defined

#ifdef PROG_HASHINFO_ID
  START_NEW_PROGRAM_ID(HASHINFO);
#else
  start_new_program();

#endif /* PROG_HASHINFO_ID */

#ifndef tObjImpl_HASHINFO

#undef tObjImpl_HASHINFO
#define tObjImpl_HASHINFO tObj

#endif /* tObjImpl_HASHINFO */

#ifdef THIS_HASHINFO

  HashInfo_storage_offset=ADD_STORAGE(struct HashInfo_struct);

#endif /* THIS_HASHINFO */

#ifdef HashInfo_event_handler_defined
  pike_set_prog_event_callback(HashInfo_event_handler);

#endif /* HashInfo_event_handler_defined */

#ifdef f_HashInfo_name_defined
#line 60 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
  f_HashInfo_name_fun_num =
    ADD_FUNCTION2("name", f_HashInfo_name, tFunc(tNone,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_HashInfo_name_defined */

#ifdef f_HashInfo_digest_size_defined
#line 73 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
  f_HashInfo_digest_size_fun_num =
    ADD_FUNCTION2("digest_size", f_HashInfo_digest_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_HashInfo_digest_size_defined */

#ifdef f_HashInfo_block_size_defined
#line 86 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
  f_HashInfo_block_size_fun_num =
    ADD_FUNCTION2("block_size", f_HashInfo_block_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_HashInfo_block_size_defined */
  HashInfo_program=end_program();
  HashInfo_program_fun_num=add_program_constant("HashInfo",HashInfo_program,0);

#endif /* class_HashInfo_defined */

#ifdef class_HashState_defined

#ifdef PROG_HASHSTATE_ID
  START_NEW_PROGRAM_ID(HASHSTATE);
#else
  start_new_program();

#endif /* PROG_HASHSTATE_ID */

#ifndef tObjImpl_HASHSTATE

#undef tObjImpl_HASHSTATE
#define tObjImpl_HASHSTATE tObj

#endif /* tObjImpl_HASHSTATE */

#ifdef THIS_HASHSTATE

  HashState_storage_offset=ADD_STORAGE(struct HashState_struct);

#endif /* THIS_HASHSTATE */

#ifdef inherit_HashInfo_HashState_defined
  low_inherit(HashInfo_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashInfo_HashState_defined */

#ifdef HashState_event_handler_defined
  pike_set_prog_event_callback(HashState_event_handler);

#endif /* HashState_event_handler_defined */

#ifdef f_HashState_update_defined
#line 125 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
  f_HashState_update_fun_num =
    ADD_FUNCTION2("update", f_HashState_update, tFunc(tString,tObj), 0, OPT_SIDE_EFFECT);

#endif /* f_HashState_update_defined */

#ifdef f_HashState_digest_defined
#line 154 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
  f_HashState_digest_fun_num =
    ADD_FUNCTION2("digest", f_HashState_digest, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_HashState_digest_defined */
  HashState_program=end_program();
  HashState_program_fun_num=add_program_constant("HashState",HashState_program,0);

#endif /* class_HashState_defined */

#ifdef class_MD5_Info_defined

#ifdef PROG_MD5_INFO_ID
  START_NEW_PROGRAM_ID(MD5_INFO);
#else
  start_new_program();

#endif /* PROG_MD5_INFO_ID */

#ifndef tObjImpl_MD5_INFO

#undef tObjImpl_MD5_INFO
#define tObjImpl_MD5_INFO tObj

#endif /* tObjImpl_MD5_INFO */

#ifdef THIS_MD5_INFO

  MD5_Info_storage_offset=ADD_STORAGE(struct MD5_Info_struct);

#endif /* THIS_MD5_INFO */

#ifdef MD5_Info_event_handler_defined
  pike_set_prog_event_callback(MD5_Info_event_handler);

#endif /* MD5_Info_event_handler_defined */
  MD5_Info_program=end_program();
  MD5_Info_program_fun_num=add_program_constant("MD5_Info",MD5_Info_program,0);

#endif /* class_MD5_Info_defined */

#ifdef class_MD5_State_defined

#ifdef PROG_MD5_STATE_ID
  START_NEW_PROGRAM_ID(MD5_STATE);
#else
  start_new_program();

#endif /* PROG_MD5_STATE_ID */

#ifndef tObjImpl_MD5_STATE

#undef tObjImpl_MD5_STATE
#define tObjImpl_MD5_STATE tObj

#endif /* tObjImpl_MD5_STATE */

#ifdef THIS_MD5_STATE

  MD5_State_storage_offset=ADD_STORAGE(struct MD5_State_struct);

#endif /* THIS_MD5_STATE */

#ifdef inherit_MD5_Info_MD5_State_defined
  low_inherit(MD5_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_MD5_Info_MD5_State_defined */

#ifdef inherit_HashState_MD5_State_defined
  low_inherit(HashState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashState_MD5_State_defined */

#ifdef MD5_State_event_handler_defined
  pike_set_prog_event_callback(MD5_State_event_handler);

#endif /* MD5_State_event_handler_defined */
  MD5_State_program=end_program();
  MD5_State_program_fun_num=add_program_constant("MD5_State",MD5_State_program,0);

#endif /* class_MD5_State_defined */

#ifdef class_MD4_Info_defined

#ifdef PROG_MD4_INFO_ID
  START_NEW_PROGRAM_ID(MD4_INFO);
#else
  start_new_program();

#endif /* PROG_MD4_INFO_ID */

#ifndef tObjImpl_MD4_INFO

#undef tObjImpl_MD4_INFO
#define tObjImpl_MD4_INFO tObj

#endif /* tObjImpl_MD4_INFO */

#ifdef THIS_MD4_INFO

  MD4_Info_storage_offset=ADD_STORAGE(struct MD4_Info_struct);

#endif /* THIS_MD4_INFO */

#ifdef MD4_Info_event_handler_defined
  pike_set_prog_event_callback(MD4_Info_event_handler);

#endif /* MD4_Info_event_handler_defined */
  MD4_Info_program=end_program();
  MD4_Info_program_fun_num=add_program_constant("MD4_Info",MD4_Info_program,0);

#endif /* class_MD4_Info_defined */

#ifdef class_MD4_State_defined

#ifdef PROG_MD4_STATE_ID
  START_NEW_PROGRAM_ID(MD4_STATE);
#else
  start_new_program();

#endif /* PROG_MD4_STATE_ID */

#ifndef tObjImpl_MD4_STATE

#undef tObjImpl_MD4_STATE
#define tObjImpl_MD4_STATE tObj

#endif /* tObjImpl_MD4_STATE */

#ifdef THIS_MD4_STATE

  MD4_State_storage_offset=ADD_STORAGE(struct MD4_State_struct);

#endif /* THIS_MD4_STATE */

#ifdef inherit_MD4_Info_MD4_State_defined
  low_inherit(MD4_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_MD4_Info_MD4_State_defined */

#ifdef inherit_HashState_MD4_State_defined
  low_inherit(HashState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashState_MD4_State_defined */

#ifdef MD4_State_event_handler_defined
  pike_set_prog_event_callback(MD4_State_event_handler);

#endif /* MD4_State_event_handler_defined */
  MD4_State_program=end_program();
  MD4_State_program_fun_num=add_program_constant("MD4_State",MD4_State_program,0);

#endif /* class_MD4_State_defined */

#ifdef class_MD2_Info_defined

#ifdef PROG_MD2_INFO_ID
  START_NEW_PROGRAM_ID(MD2_INFO);
#else
  start_new_program();

#endif /* PROG_MD2_INFO_ID */

#ifndef tObjImpl_MD2_INFO

#undef tObjImpl_MD2_INFO
#define tObjImpl_MD2_INFO tObj

#endif /* tObjImpl_MD2_INFO */

#ifdef THIS_MD2_INFO

  MD2_Info_storage_offset=ADD_STORAGE(struct MD2_Info_struct);

#endif /* THIS_MD2_INFO */

#ifdef MD2_Info_event_handler_defined
  pike_set_prog_event_callback(MD2_Info_event_handler);

#endif /* MD2_Info_event_handler_defined */
  MD2_Info_program=end_program();
  MD2_Info_program_fun_num=add_program_constant("MD2_Info",MD2_Info_program,0);

#endif /* class_MD2_Info_defined */

#ifdef class_MD2_State_defined

#ifdef PROG_MD2_STATE_ID
  START_NEW_PROGRAM_ID(MD2_STATE);
#else
  start_new_program();

#endif /* PROG_MD2_STATE_ID */

#ifndef tObjImpl_MD2_STATE

#undef tObjImpl_MD2_STATE
#define tObjImpl_MD2_STATE tObj

#endif /* tObjImpl_MD2_STATE */

#ifdef THIS_MD2_STATE

  MD2_State_storage_offset=ADD_STORAGE(struct MD2_State_struct);

#endif /* THIS_MD2_STATE */

#ifdef inherit_MD2_Info_MD2_State_defined
  low_inherit(MD2_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_MD2_Info_MD2_State_defined */

#ifdef inherit_HashState_MD2_State_defined
  low_inherit(HashState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashState_MD2_State_defined */

#ifdef MD2_State_event_handler_defined
  pike_set_prog_event_callback(MD2_State_event_handler);

#endif /* MD2_State_event_handler_defined */
  MD2_State_program=end_program();
  MD2_State_program_fun_num=add_program_constant("MD2_State",MD2_State_program,0);

#endif /* class_MD2_State_defined */

#ifdef class_SHA1_Info_defined

#ifdef PROG_SHA1_INFO_ID
  START_NEW_PROGRAM_ID(SHA1_INFO);
#else
  start_new_program();

#endif /* PROG_SHA1_INFO_ID */

#ifndef tObjImpl_SHA1_INFO

#undef tObjImpl_SHA1_INFO
#define tObjImpl_SHA1_INFO tObj

#endif /* tObjImpl_SHA1_INFO */

#ifdef THIS_SHA1_INFO

  SHA1_Info_storage_offset=ADD_STORAGE(struct SHA1_Info_struct);

#endif /* THIS_SHA1_INFO */

#ifdef SHA1_Info_event_handler_defined
  pike_set_prog_event_callback(SHA1_Info_event_handler);

#endif /* SHA1_Info_event_handler_defined */
  SHA1_Info_program=end_program();
  SHA1_Info_program_fun_num=add_program_constant("SHA1_Info",SHA1_Info_program,0);

#endif /* class_SHA1_Info_defined */

#ifdef class_SHA1_State_defined

#ifdef PROG_SHA1_STATE_ID
  START_NEW_PROGRAM_ID(SHA1_STATE);
#else
  start_new_program();

#endif /* PROG_SHA1_STATE_ID */

#ifndef tObjImpl_SHA1_STATE

#undef tObjImpl_SHA1_STATE
#define tObjImpl_SHA1_STATE tObj

#endif /* tObjImpl_SHA1_STATE */

#ifdef THIS_SHA1_STATE

  SHA1_State_storage_offset=ADD_STORAGE(struct SHA1_State_struct);

#endif /* THIS_SHA1_STATE */

#ifdef inherit_SHA1_Info_SHA1_State_defined
  low_inherit(SHA1_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_SHA1_Info_SHA1_State_defined */

#ifdef inherit_HashState_SHA1_State_defined
  low_inherit(HashState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashState_SHA1_State_defined */

#ifdef SHA1_State_event_handler_defined
  pike_set_prog_event_callback(SHA1_State_event_handler);

#endif /* SHA1_State_event_handler_defined */
  SHA1_State_program=end_program();
  SHA1_State_program_fun_num=add_program_constant("SHA1_State",SHA1_State_program,0);

#endif /* class_SHA1_State_defined */

#ifdef class_SHA256_Info_defined

#ifdef PROG_SHA256_INFO_ID
  START_NEW_PROGRAM_ID(SHA256_INFO);
#else
  start_new_program();

#endif /* PROG_SHA256_INFO_ID */

#ifndef tObjImpl_SHA256_INFO

#undef tObjImpl_SHA256_INFO
#define tObjImpl_SHA256_INFO tObj

#endif /* tObjImpl_SHA256_INFO */

#ifdef THIS_SHA256_INFO

  SHA256_Info_storage_offset=ADD_STORAGE(struct SHA256_Info_struct);

#endif /* THIS_SHA256_INFO */

#ifdef SHA256_Info_event_handler_defined
  pike_set_prog_event_callback(SHA256_Info_event_handler);

#endif /* SHA256_Info_event_handler_defined */
  SHA256_Info_program=end_program();
  SHA256_Info_program_fun_num=add_program_constant("SHA256_Info",SHA256_Info_program,0);

#endif /* class_SHA256_Info_defined */

#ifdef class_SHA256_State_defined

#ifdef PROG_SHA256_STATE_ID
  START_NEW_PROGRAM_ID(SHA256_STATE);
#else
  start_new_program();

#endif /* PROG_SHA256_STATE_ID */

#ifndef tObjImpl_SHA256_STATE

#undef tObjImpl_SHA256_STATE
#define tObjImpl_SHA256_STATE tObj

#endif /* tObjImpl_SHA256_STATE */

#ifdef THIS_SHA256_STATE

  SHA256_State_storage_offset=ADD_STORAGE(struct SHA256_State_struct);

#endif /* THIS_SHA256_STATE */

#ifdef inherit_SHA256_Info_SHA256_State_defined
  low_inherit(SHA256_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_SHA256_Info_SHA256_State_defined */

#ifdef inherit_HashState_SHA256_State_defined
  low_inherit(HashState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_HashState_SHA256_State_defined */

#ifdef SHA256_State_event_handler_defined
  pike_set_prog_event_callback(SHA256_State_event_handler);

#endif /* SHA256_State_event_handler_defined */
  SHA256_State_program=end_program();
  SHA256_State_program_fun_num=add_program_constant("SHA256_State",SHA256_State_program,0);

#endif /* class_SHA256_State_defined */
#line 477 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
;
}

void
hash_exit(void)
{
  werror("Nettle, hash exit\n");
  
#ifdef class_HashInfo_defined
  if(HashInfo_program) {
    free_program(HashInfo_program);
    HashInfo_program=0;
  }

#endif /* class_HashInfo_defined */

#ifdef class_HashState_defined
  if(HashState_program) {
    free_program(HashState_program);
    HashState_program=0;
  }

#endif /* class_HashState_defined */

#ifdef class_MD5_Info_defined
  if(MD5_Info_program) {
    free_program(MD5_Info_program);
    MD5_Info_program=0;
  }

#endif /* class_MD5_Info_defined */

#ifdef class_MD5_State_defined
  if(MD5_State_program) {
    free_program(MD5_State_program);
    MD5_State_program=0;
  }

#endif /* class_MD5_State_defined */

#ifdef class_MD4_Info_defined
  if(MD4_Info_program) {
    free_program(MD4_Info_program);
    MD4_Info_program=0;
  }

#endif /* class_MD4_Info_defined */

#ifdef class_MD4_State_defined
  if(MD4_State_program) {
    free_program(MD4_State_program);
    MD4_State_program=0;
  }

#endif /* class_MD4_State_defined */

#ifdef class_MD2_Info_defined
  if(MD2_Info_program) {
    free_program(MD2_Info_program);
    MD2_Info_program=0;
  }

#endif /* class_MD2_Info_defined */

#ifdef class_MD2_State_defined
  if(MD2_State_program) {
    free_program(MD2_State_program);
    MD2_State_program=0;
  }

#endif /* class_MD2_State_defined */

#ifdef class_SHA1_Info_defined
  if(SHA1_Info_program) {
    free_program(SHA1_Info_program);
    SHA1_Info_program=0;
  }

#endif /* class_SHA1_Info_defined */

#ifdef class_SHA1_State_defined
  if(SHA1_State_program) {
    free_program(SHA1_State_program);
    SHA1_State_program=0;
  }

#endif /* class_SHA1_State_defined */

#ifdef class_SHA256_Info_defined
  if(SHA256_Info_program) {
    free_program(SHA256_Info_program);
    SHA256_Info_program=0;
  }

#endif /* class_SHA256_Info_defined */

#ifdef class_SHA256_State_defined
  if(SHA256_State_program) {
    free_program(SHA256_State_program);
    SHA256_State_program=0;
  }

#endif /* class_SHA256_State_defined */
#line 484 "/tmp/pikedeb.a8fa1cdb35/7.6/src/post_modules/Nettle/hash.cmod"
;
}

#endif /* HAVE_LIBNETTLE */

