# Only include the folling if we are on a buildd AND doing a PRIMARY/archive 
# build AND the architecture is i386.
ifeq ($(shell grep -qs '^Purpose: PRIMARY' /CurrentlyBuilding && echo 0),0)
ifeq ($(shell grep -Pqs '^Component: main|restricted' /CurrentlyBuilding && echo 0),0)

DEB_BUILD_ARCH := $(shell dpkg-architecture -qDEB_BUILD_ARCH)
DEB_SOURCE_PACKAGE := $(shell dpkg-parsechangelog | sed -n 's/^Source: //p')

DEB_KUBUNTU_OVERRIDE_DH_CLEAN ?= override_dh_clean
$(DEB_KUBUNTU_OVERRIDE_DH_CLEAN): kubuntu_override_dh_clean_impl

KUBUNTU_DESKTOP_POT ?= $(DEB_SOURCE_PACKAGE)

kubuntu_override_dh_clean_impl:
	# clean up edited .desktop etc files
	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  for file in `cat LIST`; do \
	     sed -i '/X-Ubuntu-Gettext-Domain=/d' $${file}; \
	  done; \
	  rm -f LIST; \
	fi
ifeq ($(DEB_BUILD_ARCH),i386)
	if [ -z $${KUBUNTU_NO_DELETE_POT} ]; then \
	    rm -rf po/*.pot; \
	fi;
else
	@echo "No i386 build -> not cleaning l10n content."
endif
	dh_clean

#Kubuntu specific, Launchpad translations support, create .pot translation templates
#suggestions for a better override target to do this welcome
DEB_KUBUNTU_OVERRIDE_DH_INSTALLDOCS ?= override_dh_installdocs
$(DEB_KUBUNTU_OVERRIDE_DH_INSTALLDOCS): kubuntu_override_dh_installdocs_impl

kubuntu_override_dh_installdocs_impl:
	dh_installdocs
	# generate .po files for .desktop etc files
	echo KUBUNTU_DESKTOP_POT: $(KUBUNTU_DESKTOP_POT)
	if [ -f /usr/lib/kubuntu-desktop-i18n/findfiles ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  sed /\.pc/d LIST -i; \
	  cat LIST; \
	  # add translation domain to files \
	  for file in `cat LIST`; do \
	    echo X-Ubuntu-Gettext-Domain=desktop_$(KUBUNTU_DESKTOP_POT) >> $${file}; \
	  done; \
	  rm -f LIST; \
	fi
ifeq ($(DEB_BUILD_ARCH),i386)
	mkdir -p po
	extract-messages.sh
	extract-xml.sh
	-for file in po/*pot; do \
		sed "s/charset=CHARSET/charset=UTF-8/" -i $$file; \
	done

	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  sed /\.pc/d LIST -i; \
	  perl /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl --file-list=LIST --base-dir=. > desktop.$(KUBUNTU_DESKTOP_POT).tmp; \
	  msguniq --to-code=UTF-8 --no-wrap -o desktop.$(KUBUNTU_DESKTOP_POT) desktop.$(KUBUNTU_DESKTOP_POT).tmp 2>/dev/null; \
	  python /usr/lib/kubuntu-desktop-i18n/msgsplit desktop.$(KUBUNTU_DESKTOP_POT); \
	  mv desktop.$(KUBUNTU_DESKTOP_POT) po/desktop_$(KUBUNTU_DESKTOP_POT).pot; \
	  rm -f desktop.$(KUBUNTU_DESKTOP_POT) desktop.$(KUBUNTU_DESKTOP_POT).tmp; \
	  rm -f LIST; \
	fi
else
	@echo "No i386 build -> not generating l10n content."
endif

endif
endif
