#!/bin/sh

if [ `grep -qs '^Purpose: PRIMARY' /CurrentlyBuilding; echo $?` -ne 0 ] ||
   [ `grep -Pqs '^Component: main|restricted' /CurrentlyBuilding; echo $?` -ne 0 ]; then
    echo "No primary archive build or not targetting main|restricted -> not cleaning l10n content."
    exit 0
fi

# clean up edited .desktop etc files
if [ -f /usr/lib/kubuntu-desktop-i18n/findfiles ]; then
    sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST;
    for file in `cat LIST`; do
        sed -i '/X-Ubuntu-Gettext-Domain=/d' ${file};
    done;
    rm -f LIST;
fi

if [ "`dpkg-architecture -qDEB_BUILD_ARCH`" != "i386" ]; then
    echo "No i386 build -> not cleaning l10n content."
    exit 0
fi

if [ -z $${KUBUNTU_NO_DELETE_POT} ]; then
    rm -rf po/*.pot;
fi
