import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored

import launchpadbugs.exceptions as exceptions
import launchpadbugs.connector as Connector
from launchpadbugs.connector import ConnectBug

cfg = ConfigTest()["test_examples"]
COOKIEFILE = cfg["cookiefile"]
LOGIN = {"email": cfg["email"], "password": cfg["password"]}

class ConnectorTestCase(PyLPBugsTestCase):
    
    def test_001_LaunchpadConnector(self):
        """ LaunchpadConnector should raise 'NotImplementedError' for nonexistent methods """
        self.assertRaises(NotImplementedError, Connector.LaunchpadConnector, "Bug", "Test")
                
    def test_002_ConnectBug_unknown_method(self):
        """ ConnectBug should raise 'NotImplementedError' for nonexistent methods """
        self.assertRaises(NotImplementedError, Connector.ConnectBug, "Test")
                
    def test_003_ConnectBug(self):
        """ ConnectBugList: per default a user is not logged in """
        b = Connector.ConnectBug()
        self.failIf(not b.needs_login, "a user should not be logged in per default")
                
    def test_004_ConnectBugList_unknown_method(self):
        """ ConnectBugList should raise 'NotImplementedError' for nonexistent methods """
        self.assertRaises(NotImplementedError, Connector.ConnectBugList, "Test")
                
    def test_005_ConnectBugList(self):
        """ ConnectBugList: per default a user is not logged in """
        bl = Connector.ConnectBugList()
        self.failIf(not bl.needs_login, "a user should not be logged in per default")
    

class LoginTestCase(PyLPBugsTestCase):
    """ test to log in into launchpad.net """
    
    def setUp(self):
        self.HBug = ConnectBug()
        
    def test_001_login_file_not_exists(self):
        """Cookiefile does not exist"""
        self.failUnlessRaises(exceptions.PythonLaunchpadBugsIOError, self.HBug.set_auth, "/bla/blu/foo")
        
    def test_002_login_file_exists(self):
        """Cookiefile exists"""
        if COOKIEFILE:
            self.HBug.authentication = COOKIEFILE
            self.failIf(self.HBug.connection.needs_login("https://bugs.launchpad.net/bugs/+filebug"))
        else:
            raise TestCaseIgnored, "no cookiefile given"
            
        
    def test_003_login_direct(self):
        """login via {"email": <email>, "password": <password>}"""
        if LOGIN["password"] and LOGIN["email"]:
            self.HBug.authentication = LOGIN
            self.failIf(self.HBug.connection.needs_login("https://bugs.launchpad.net/bugs/+filebug"))
        else:
            raise TestCaseIgnored, "no password and/or email given"
            
            

if __name__ == '__main__':
    import unittest
    
    ConnectorTestSuite = unittest.TestLoader().loadTestsFromTestCase(ConnectorTestCase)
    LoginTestSuite = unittest.TestLoader().loadTestsFromTestCase(LoginTestCase)
    
    alltests = PyLPBugsTestSuite((ConnectorTestSuite, LoginTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
