import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored
from launchpadbugs.lpconstants import HTTPCONNECTION
from launchpadbugs.text_buglist import BugPage, BugInfo, BugList
from launchpadbugs.http_connection import HTTPConnection

con = None

class TextBugListTestCase(PyLPBugsTestCase):
    
    def test_001_setup_HTTPConnection(self):
        """ prepare the HTTPConnection object """
        global con
        con = HTTPConnection()
            
    def test_002_package_bugs(self):
        """[STABLE/EDGE] test package bugs """
        url = "https://bugs.launchpad.net/ubuntu/+source/hal"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_003_package_bugs(self):
        """[STABLE/EDGE] test package bugs with '+bugs-text'-url"""
        url = "https://bugs.launchpad.net/ubuntu/+source/hal/+bugs-text"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_004_buglist(self):
        """ test BugList """
        url1 = "https://bugs.launchpad.net/bughelper/+bugs"
        url2 = "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bugs"
        BL1 = BugList(url1, con)
        BL2 = BugList(url2, con)
        BL1 += BL2
        self.failUnlessRaises(NotImplementedError, BL1.sort, "-nr")
        self.failUnlessRaises(NotImplementedError, BL1.sort, "status")
        

if __name__ == '__main__':
    import unittest
    
    TextBugListTestSuite = unittest.TestLoader().loadTestsFromTestCase(TextBugListTestCase)
    
    alltests = PyLPBugsTestSuite((TextBugListTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
