#!/usr/bin/env python
#
# $Id$
#
# Time-stamp: <2002-11-12 14:03:39 resolve>
#
# Copyright (C) Damien Elmes <resolve@repose.cx>, 2001.
# This file is licensed under the GPL. Please see COPYING for more details.
#


"""
Plugin for PyOSDd which indicates when things have happened on IRC.
"""

import commands
import os
import re

import pyosd, pyosd.daemon as pyd

class plugin:

    def __init__(self):
        self.plugin_name = "irc"
        self.plugin_desc = "Notify user of IRC action"
        self.plugin_keys = ["irc"]

    def irc(self, *args):
        if args:
            channel = args[0]
        else:
            channel = ""

        self.display(channel)

    def display(self, channel):
        """ Determine current volume, and display it. """

        pyd.top.set_colour("#bbbbFF")
        pyd.top.set_timeout(2)
        pyd.top.display("IRC: action on %s" % channel)
