/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QEdje.
 *
 * QEdje is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QEdje is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QEdje.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QEDJE_RUNNINGPROGRAM_H__
#define __QEDJE_RUNNINGPROGRAM_H__

#include "qedje.h"
#include "qedjeloader.h"

#include <QtCore/QTimeLine>


class QEdje;
class QEdjeProgram;
class QEdjeRealPart;

/*!
  \enum TweenMode
  \brief QRunniingProgram curve shapes.
 */
enum TweenMode
{
    TWEEN_MODE_LINEAR = 1,
    TWEEN_MODE_SINUSOIDAL = 2,
    TWEEN_MODE_ACCELERATE = 3,
    TWEEN_MODE_DECELERATE = 4,
};

/*!
  \class QRunningProgram
  \brief Controls the execution of a QEdjeProgram

  When running emits 'iterate' signals in regular intervals to drive
  the the animation of its QEdjeRealPart targets.

  \sa QEdjeProgram
  \sa QEdjeRealPart
*/
class QRunningProgram : public QObject
{
    Q_OBJECT

public:
    QRunningProgram(QEdjeProgram *program, QEdje *edje,
                    int duration, TweenMode tweenMode,
                    QList<QEdjeRealPart*> targets);
    ~QRunningProgram();

    QD_PROPERTY_RD(QList<QEdjeRealPart *>, _targets, targets);

    void start();
    qreal valueForTime(int msec) const;
    QString state() const { return _program->state; }
    double value() const { return _program->value; }
    QEdjeProgram *program() const { return _program; }


protected:
    virtual void timerEvent(QTimerEvent *event);

private:
    QEdje *_edje;
    int _duration;
    TweenMode _mode;
    QEdjeProgram *_program;
    QTime _stopwatch;
    int _timerId;
    qreal _currentValue;
    int _delay;
    int _delayId;

    void updateValue();
    void endProgram();
    void stopProgram();
    void stop();
    void realStart();
};

#endif
