/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "qziontextblock.h"
#include "qziontextblock_p.h"

#include <QDebug>
#include <QRegion>
#include <QPainter>
#include <QApplication>
#include <QPaintEvent>

#include "qzionobject_p.h"

QZionTextBlock::QZionTextBlock(QZionAbstractCanvas *canvas)
    : QZionObject(canvas)
{
    QZINIT(QZionTextBlock, canvas);
}

QZionTextBlock::QZionTextBlock(QZionAbstractCanvas *canvas, const QString &text)
    : QZionObject(canvas)
{
    QZINIT(QZionTextBlock, canvas);

    QZD(QZionTextBlock);
    d->setText(text);
}

QZionTextBlock::~QZionTextBlock()
{
    QZDELETE(QZionTextBlock);
}

QSize QZionTextBlock::size() const
{
    QZD(QZionTextBlock);
    return d->size();
}

void QZionTextBlock::setSize(const QSize &size)
{
    QZD(QZionTextBlock);
    d->setSize(size);
    QZionObject::setSize(size);
}

QString QZionTextBlock::text() const
{
    QZD(QZionTextBlock);
    return d->text();
}

QColor QZionTextBlock::color() const
{
    return QColor(255, 255, 255, 0);
}

void QZionTextBlock::setColor(const QColor &color)
{
    Q_UNUSED(color);
}

void QZionTextBlock::setText(const QString &text)
{
    QZD(QZionTextBlock);
    d->setText(text);
}

QRect QZionTextBlock::rect() const
{
    QZD(QZionTextBlock);
    return d->sceneBoundingRect().toRect().translated(pos());
}

void QZionTextBlock::paint(QPainter* painter)
{
    Q_UNUSED(painter);
}
