/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONABSTRACTCANVAS_P_H__
#define __QZIONABSTRACTCANVAS_P_H__

#include "qzionobject.h"
#include "qzionabstractcanvas.h"

class QZionAbstractCanvasPrivate
{
public:
    QList<QZionObject*> items;
    QZionAbstractCanvas *owner;

    QZionAbstractCanvasPrivate(QZionAbstractCanvas *owner)
        : owner(owner) {};

    virtual ~QZionAbstractCanvasPrivate() {};

    inline void updateAfterRestack(QZionObject *obj, int from, int to);
};

inline void QZionAbstractCanvasPrivate::updateAfterRestack(QZionObject *obj,
                                                           int from, int to)
{
    from = qMin(from, to);
    to = qMax(from, to);

    QRegion toUpdate;
    QRect obj_rect = obj->rect();

    for (int i = from; i <= to; ++i) {
        QZionObject *other = items.at(i);
        if (!other->visible())
            continue;

        QRect r = other->rect() & obj_rect;
        if (!r.isEmpty())
            toUpdate |= r;
    }

    if (!toUpdate.isEmpty())
        owner->invalidate(toUpdate);
}

#endif
