/* 
 *  arch-tag: Implementation of random navigation method with equal weights for each song
 *
 *  Copyright (C) 2003 Jeffrey Yasskin <jyasskin@mail.utexas.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "rb-play-order-random-equal-weights.h"

static void rb_random_play_order_equal_weights_class_init (RBRandomPlayOrderEqualWeightsClass *klass);

static double rb_random_equal_weights_get_entry_weight (RBRandomPlayOrder *rorder,
							RhythmDB *db, RhythmDBEntry *entry);

G_DEFINE_TYPE (RBRandomPlayOrderEqualWeights,
	       rb_random_play_order_equal_weights,
	       RB_TYPE_RANDOM_PLAY_ORDER)

static void
rb_random_play_order_equal_weights_class_init (RBRandomPlayOrderEqualWeightsClass *klass)
{
	RBRandomPlayOrderClass *rorder;

	rorder = RB_RANDOM_PLAY_ORDER_CLASS (klass);
	rorder->get_entry_weight = rb_random_equal_weights_get_entry_weight;
}

RBPlayOrder *
rb_random_play_order_equal_weights_new (RBShellPlayer *player)
{
	RBRandomPlayOrderEqualWeights *rorder;

	rorder = g_object_new (RB_TYPE_RANDOM_PLAY_ORDER_EQUAL_WEIGHTS,
			"player", player,
			NULL);

	return RB_PLAY_ORDER (rorder);
}

static void
rb_random_play_order_equal_weights_init (RBRandomPlayOrderEqualWeights *porder)
{
}

static double
rb_random_equal_weights_get_entry_weight (RBRandomPlayOrder *rorder, RhythmDB *db, RhythmDBEntry *entry)
{
	return 1.0;
}
