#[cfg(feature = "Win32_UI_Shell_Common")]
pub mod Common;
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub mod PropertiesSystem;
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ShellMessageBoxA<'a, P0, P1, P2, P3>(happinst: P0, hwnd: P1, lpctext: P2, lpctitle: P3, fustyle: u32) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "cdecl" {
        fn ShellMessageBoxA(happinst: super::super::Foundation::HINSTANCE, hwnd: super::super::Foundation::HWND, lpctext: ::windows::core::PCSTR, lpctitle: ::windows::core::PCSTR, fustyle: u32) -> i32;
    }
    ShellMessageBoxA(happinst.into(), hwnd.into(), lpctext.into(), lpctitle.into(), fustyle)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ShellMessageBoxW<'a, P0, P1, P2, P3>(happinst: P0, hwnd: P1, lpctext: P2, lpctitle: P3, fustyle: u32) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "cdecl" {
        fn ShellMessageBoxW(happinst: super::super::Foundation::HINSTANCE, hwnd: super::super::Foundation::HWND, lpctext: ::windows::core::PCWSTR, lpctitle: ::windows::core::PCWSTR, fustyle: u32) -> i32;
    }
    ShellMessageBoxW(happinst.into(), hwnd.into(), lpctext.into(), lpctitle.into(), fustyle)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn wnsprintfA<'a, P0>(pszdest: &mut [u8], pszfmt: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "cdecl" {
        fn wnsprintfA(pszdest: ::windows::core::PSTR, cchdest: i32, pszfmt: ::windows::core::PCSTR) -> i32;
    }
    wnsprintfA(::core::mem::transmute(pszdest.as_ptr()), pszdest.len() as _, pszfmt.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn wnsprintfW<'a, P0>(pszdest: &mut [u16], pszfmt: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "cdecl" {
        fn wnsprintfW(pszdest: ::windows::core::PWSTR, cchdest: i32, pszfmt: ::windows::core::PCWSTR) -> i32;
    }
    wnsprintfW(::core::mem::transmute(pszdest.as_ptr()), pszdest.len() as _, pszfmt.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocCreate<T>(clsid: ::windows::core::GUID) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocCreate(clsid: ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    AssocCreate(::core::mem::transmute(clsid), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocCreateForClasses<T>(rgclasses: &[ASSOCIATIONELEMENT]) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocCreateForClasses(rgclasses: *const ASSOCIATIONELEMENT, cclasses: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    AssocCreateForClasses(::core::mem::transmute(rgclasses.as_ptr()), rgclasses.len() as _, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn AssocGetDetailsOfPropKey<'a, P0>(psf: P0, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut super::super::System::Com::VARIANT, pffoundpropkey: ::core::option::Option<*mut super::super::Foundation::BOOL>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocGetDetailsOfPropKey(psf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pffoundpropkey: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT;
    }
    AssocGetDetailsOfPropKey(psf.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(pkey), ::core::mem::transmute(pv), ::core::mem::transmute(pffoundpropkey.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn AssocGetPerceivedType<'a, P0>(pszext: P0, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: ::core::option::Option<*mut ::windows::core::PWSTR>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocGetPerceivedType(pszext: ::windows::core::PCWSTR, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    AssocGetPerceivedType(pszext.into(), ::core::mem::transmute(ptype), ::core::mem::transmute(pflag), ::core::mem::transmute(ppsztype.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AssocIsDangerous<'a, P0>(pszassoc: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocIsDangerous(pszassoc: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    AssocIsDangerous(pszassoc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyA<'a, P0, P1>(flags: u32, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> ::windows::core::Result<super::super::System::Registry::HKEY>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryKeyA(flags: u32, key: ASSOCKEY, pszassoc: ::windows::core::PCSTR, pszextra: ::windows::core::PCSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    AssocQueryKeyA(flags, key, pszassoc.into(), pszextra.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Registry::HKEY>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyW<'a, P0, P1>(flags: u32, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> ::windows::core::Result<super::super::System::Registry::HKEY>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryKeyW(flags: u32, key: ASSOCKEY, pszassoc: ::windows::core::PCWSTR, pszextra: ::windows::core::PCWSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    AssocQueryKeyW(flags, key, pszassoc.into(), pszextra.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Registry::HKEY>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocQueryStringA<'a, P0, P1>(flags: u32, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringA(flags: u32, str: ASSOCSTR, pszassoc: ::windows::core::PCSTR, pszextra: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringA(flags, str, pszassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyA<'a, P0, P1>(flags: u32, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringByKeyA(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringByKeyA(flags, str, hkassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyW<'a, P0, P1>(flags: u32, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringByKeyW(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringByKeyW(flags, str, hkassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn AssocQueryStringW<'a, P0, P1>(flags: u32, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn AssocQueryStringW(flags: u32, str: ASSOCSTR, pszassoc: ::windows::core::PCWSTR, pszextra: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
    }
    AssocQueryStringW(flags, str, pszassoc.into(), pszextra.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CDefFolderMenu_Create2<'a, P0, P1>(pidlfolder: ::core::option::Option<*const Common::ITEMIDLIST>, hwnd: P0, apidl: ::core::option::Option<&[*const Common::ITEMIDLIST]>, psf: P1, pfn: LPFNDFMCALLBACK, ahkeys: ::core::option::Option<&[super::super::System::Registry::HKEY]>) -> ::windows::core::Result<IContextMenu>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CDefFolderMenu_Create2(pidlfolder: *const Common::ITEMIDLIST, hwnd: super::super::Foundation::HWND, cidl: u32, apidl: *const *const Common::ITEMIDLIST, psf: *mut ::core::ffi::c_void, pfn: *mut ::core::ffi::c_void, nkeys: u32, ahkeys: *const super::super::System::Registry::HKEY, ppcm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    CDefFolderMenu_Create2(::core::mem::transmute(pidlfolder.unwrap_or(::std::ptr::null())), hwnd.into(), apidl.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(apidl.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psf.into().abi(), ::core::mem::transmute(pfn), ahkeys.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(ahkeys.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IContextMenu>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, apidl: ::core::option::Option<&[*const Common::ITEMIDLIST]>) -> ::windows::core::Result<super::super::System::Com::IDataObject> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST, ppdtobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    CIDLData_CreateFromIDArray(::core::mem::transmute(pidlfolder), apidl.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(apidl.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDataObject>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
    }
    ChrCmpIA(w1, w2)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
    }
    ChrCmpIW(w1, w2)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ColorAdjustLuma<'a, P0, P1>(clrrgb: P0, n: i32, fscale: P1) -> super::super::Foundation::COLORREF
where
    P0: ::std::convert::Into<super::super::Foundation::COLORREF>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorAdjustLuma(clrrgb: super::super::Foundation::COLORREF, n: i32, fscale: super::super::Foundation::BOOL) -> super::super::Foundation::COLORREF;
    }
    ColorAdjustLuma(clrrgb.into(), n, fscale.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> super::super::Foundation::COLORREF {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> super::super::Foundation::COLORREF;
    }
    ColorHLSToRGB(whue, wluminance, wsaturation)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ColorRGBToHLS<'a, P0>(clrrgb: P0, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16)
where
    P0: ::std::convert::Into<super::super::Foundation::COLORREF>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ColorRGBToHLS(clrrgb: super::super::Foundation::COLORREF, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16);
    }
    ColorRGBToHLS(clrrgb.into(), ::core::mem::transmute(pwhue), ::core::mem::transmute(pwluminance), ::core::mem::transmute(pwsaturation))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn CommandLineToArgvW<'a, P0>(lpcmdline: P0, pnumargs: *mut i32) -> *mut ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CommandLineToArgvW(lpcmdline: ::windows::core::PCWSTR, pnumargs: *mut i32) -> *mut ::windows::core::PWSTR;
    }
    CommandLineToArgvW(lpcmdline.into(), ::core::mem::transmute(pnumargs))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn ConnectToConnectionPoint<'a, P0, P1, P2>(punk: P0, riidevent: *const ::windows::core::GUID, fconnect: P1, punktarget: P2, pdwcookie: *mut u32, ppcpout: ::core::option::Option<*mut ::core::option::Option<super::super::System::Com::IConnectionPoint>>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ConnectToConnectionPoint(punk: *mut ::core::ffi::c_void, riidevent: *const ::windows::core::GUID, fconnect: super::super::Foundation::BOOL, punktarget: *mut ::core::ffi::c_void, pdwcookie: *mut u32, ppcpout: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    ConnectToConnectionPoint(punk.into().abi(), ::core::mem::transmute(riidevent), fconnect.into(), punktarget.into().abi(), ::core::mem::transmute(pdwcookie), ::core::mem::transmute(ppcpout.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn CreateProfile<'a, P0, P1>(pszusersid: P0, pszusername: P1, pszprofilepath: &mut [u16]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn CreateProfile(pszusersid: ::windows::core::PCWSTR, pszusername: ::windows::core::PCWSTR, pszprofilepath: ::windows::core::PWSTR, cchprofilepath: u32) -> ::windows::core::HRESULT;
    }
    CreateProfile(pszusersid.into(), pszusername.into(), ::core::mem::transmute(pszprofilepath.as_ptr()), pszprofilepath.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_AutoScroll<'a, P0>(hwnd: P0, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_AutoScroll(hwnd: super::super::Foundation::HWND, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_AutoScroll(hwnd.into(), ::core::mem::transmute(pad), ::core::mem::transmute(pptnow))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragEnterEx<'a, P0>(hwndtarget: P0, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragEnterEx(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_DragEnterEx(hwndtarget.into(), ::core::mem::transmute(ptstart))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn DAD_DragEnterEx2<'a, P0, P1>(hwndtarget: P0, ptstart: super::super::Foundation::POINT, pdtobject: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragEnterEx2(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT, pdtobject: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    DAD_DragEnterEx2(hwndtarget.into(), ::core::mem::transmute(ptstart), pdtobject.into().abi())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragLeave() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragLeave() -> super::super::Foundation::BOOL;
    }
    DAD_DragLeave()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_DragMove(::core::mem::transmute(pt))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn DAD_SetDragImage<'a, P0>(him: P0, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::Controls::HIMAGELIST>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_SetDragImage(him: super::Controls::HIMAGELIST, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DAD_SetDragImage(him.into(), ::core::mem::transmute(pptoffset))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_ShowDragImage<'a, P0>(fshow: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DAD_ShowDragImage(fshow: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    DAD_ShowDragImage(fshow.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DefSubclassProc<'a, P0, P1, P2>(hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
    P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DefSubclassProc(hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    }
    DefSubclassProc(hwnd.into(), umsg, wparam.into(), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileA<'a, P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DeleteProfileA(lpsidstring: ::windows::core::PCSTR, lpprofilepath: ::windows::core::PCSTR, lpcomputername: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    DeleteProfileA(lpsidstring.into(), lpprofilepath.into(), lpcomputername.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileW<'a, P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DeleteProfileW(lpsidstring: ::windows::core::PCWSTR, lpprofilepath: ::windows::core::PCWSTR, lpcomputername: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    DeleteProfileW(lpsidstring.into(), lpprofilepath.into(), lpcomputername.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DoEnvironmentSubstA(pszsrc: &mut [u8]) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DoEnvironmentSubstA(pszsrc: ::windows::core::PSTR, cchsrc: u32) -> u32;
    }
    DoEnvironmentSubstA(::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DoEnvironmentSubstW(pszsrc: &mut [u16]) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DoEnvironmentSubstW(pszsrc: ::windows::core::PWSTR, cchsrc: u32) -> u32;
    }
    DoEnvironmentSubstW(::core::mem::transmute(pszsrc.as_ptr()), pszsrc.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragAcceptFiles<'a, P0, P1>(hwnd: P0, faccept: P1)
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragAcceptFiles(hwnd: super::super::Foundation::HWND, faccept: super::super::Foundation::BOOL);
    }
    DragAcceptFiles(hwnd.into(), faccept.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragFinish<'a, P0>(hdrop: P0)
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragFinish(hdrop: HDROP);
    }
    DragFinish(hdrop.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragQueryFileA<'a, P0>(hdrop: P0, ifile: u32, lpszfile: ::core::option::Option<&mut [u8]>) -> u32
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryFileA(hdrop: HDROP, ifile: u32, lpszfile: ::windows::core::PSTR, cch: u32) -> u32;
    }
    DragQueryFileA(hdrop.into(), ifile, ::core::mem::transmute(lpszfile.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DragQueryFileW<'a, P0>(hdrop: P0, ifile: u32, lpszfile: ::core::option::Option<&mut [u16]>) -> u32
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryFileW(hdrop: HDROP, ifile: u32, lpszfile: ::windows::core::PWSTR, cch: u32) -> u32;
    }
    DragQueryFileW(hdrop.into(), ifile, ::core::mem::transmute(lpszfile.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragQueryPoint<'a, P0>(hdrop: P0, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<HDROP>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DragQueryPoint(hdrop: HDROP, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
    }
    DragQueryPoint(hdrop.into(), ::core::mem::transmute(ppt))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn DriveType(idrive: i32) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DriveType(idrive: i32) -> i32;
    }
    DriveType(idrive)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn DuplicateIcon<'a, P0, P1>(hinst: P0, hicon: P1) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<super::WindowsAndMessaging::HICON>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn DuplicateIcon(hinst: super::super::Foundation::HINSTANCE, hicon: super::WindowsAndMessaging::HICON) -> super::WindowsAndMessaging::HICON;
    }
    DuplicateIcon(hinst.into(), hicon.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconA<'a, P0>(hinst: P0, psziconpath: &mut [u8; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconA(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconA(hinst.into(), ::core::mem::transmute(psziconpath.as_ptr()), ::core::mem::transmute(piicon))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExA<'a, P0>(hinst: P0, psziconpath: &mut [u8; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconExA(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconExA(hinst.into(), ::core::mem::transmute(psziconpath.as_ptr()), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExW<'a, P0>(hinst: P0, psziconpath: &mut [u16; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconExW(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PWSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconExW(hinst.into(), ::core::mem::transmute(psziconpath.as_ptr()), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconW<'a, P0>(hinst: P0, psziconpath: &mut [u16; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractAssociatedIconW(hinst: super::super::Foundation::HINSTANCE, psziconpath: ::windows::core::PWSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
    }
    ExtractAssociatedIconW(hinst.into(), ::core::mem::transmute(psziconpath.as_ptr()), ::core::mem::transmute(piicon))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconA<'a, P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconA(hinst: super::super::Foundation::HINSTANCE, pszexefilename: ::windows::core::PCSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
    }
    ExtractIconA(hinst.into(), pszexefilename.into(), niconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExA<'a, P0>(lpszfile: P0, niconindex: i32, phiconlarge: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconExA(lpszfile: ::windows::core::PCSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
    }
    ExtractIconExA(lpszfile.into(), niconindex, ::core::mem::transmute(phiconlarge.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phiconsmall.unwrap_or(::std::ptr::null_mut())), nicons)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExW<'a, P0>(lpszfile: P0, niconindex: i32, phiconlarge: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconExW(lpszfile: ::windows::core::PCWSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
    }
    ExtractIconExW(lpszfile.into(), niconindex, ::core::mem::transmute(phiconlarge.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phiconsmall.unwrap_or(::std::ptr::null_mut())), nicons)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconW<'a, P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: ::std::convert::Into<super::super::Foundation::HINSTANCE>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ExtractIconW(hinst: super::super::Foundation::HINSTANCE, pszexefilename: ::windows::core::PCWSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
    }
    ExtractIconW(hinst.into(), pszexefilename.into(), niconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableA<'a, P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u8; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn FindExecutableA(lpfile: ::windows::core::PCSTR, lpdirectory: ::windows::core::PCSTR, lpresult: ::windows::core::PSTR) -> super::super::Foundation::HINSTANCE;
    }
    FindExecutableA(lpfile.into(), lpdirectory.into(), ::core::mem::transmute(lpresult.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableW<'a, P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u16; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn FindExecutableW(lpfile: ::windows::core::PCWSTR, lpdirectory: ::windows::core::PCWSTR, lpresult: ::windows::core::PWSTR) -> super::super::Foundation::HINSTANCE;
    }
    FindExecutableW(lpfile.into(), lpdirectory.into(), ::core::mem::transmute(lpresult.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetAcceptLanguagesA(pszlanguages: ::windows::core::PSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAcceptLanguagesA(pszlanguages: ::windows::core::PSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
    }
    GetAcceptLanguagesA(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetAcceptLanguagesW(pszlanguages: ::windows::core::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAcceptLanguagesW(pszlanguages: ::windows::core::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
    }
    GetAcceptLanguagesW(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAllUsersProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetAllUsersProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetAllUsersProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetAllUsersProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID() -> ::windows::core::Result<::windows::core::PWSTR> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetCurrentProcessExplicitAppUserModelID(appid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    GetCurrentProcessExplicitAppUserModelID(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDefaultUserProfileDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetDefaultUserProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDefaultUserProfileDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetDefaultUserProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32;
    }
    GetDpiForShellUIComponent(param0)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileNameFromBrowse<'a, P0, P1, P2, P3, P4>(hwnd: P0, pszfilepath: &mut [u16], pszworkingdir: P1, pszdefext: P2, pszfilters: P3, psztitle: P4) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetFileNameFromBrowse(hwnd: super::super::Foundation::HWND, pszfilepath: ::windows::core::PWSTR, cchfilepath: u32, pszworkingdir: ::windows::core::PCWSTR, pszdefext: ::windows::core::PCWSTR, pszfilters: ::windows::core::PCWSTR, psztitle: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    GetFileNameFromBrowse(hwnd.into(), ::core::mem::transmute(pszfilepath.as_ptr()), pszfilepath.len() as _, pszworkingdir.into(), pszdefext.into(), pszfilters.into(), psztitle.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuContextHelpId<'a, P0>(param0: P0) -> u32
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU) -> u32;
    }
    GetMenuContextHelpId(param0.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuPosFromID<'a, P0>(hmenu: P0, id: u32) -> i32
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetMenuPosFromID(hmenu: super::WindowsAndMessaging::HMENU, id: u32) -> i32;
    }
    GetMenuPosFromID(hmenu.into(), id)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfileType(::core::mem::transmute(dwflags))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfilesDirectoryA(lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfilesDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetProfilesDirectoryW(lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetProfilesDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR;
    }
    GetScaleFactorForDevice(devicetype)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn GetScaleFactorForMonitor<'a, P0>(hmon: P0) -> ::windows::core::Result<Common::DEVICE_SCALE_FACTOR>
where
    P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetScaleFactorForMonitor(hmon: super::super::Graphics::Gdi::HMONITOR, pscale: *mut Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    GetScaleFactorForMonitor(hmon.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Common::DEVICE_SCALE_FACTOR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryA<'a, P0>(htoken: P0, lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetUserProfileDirectoryA(htoken: super::super::Foundation::HANDLE, lpprofiledir: ::windows::core::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetUserProfileDirectoryA(htoken.into(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryW<'a, P0>(htoken: P0, lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetUserProfileDirectoryW(htoken: super::super::Foundation::HANDLE, lpprofiledir: ::windows::core::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
    }
    GetUserProfileDirectoryW(htoken.into(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowContextHelpId<'a, P0>(param0: P0) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetWindowContextHelpId(param0: super::super::Foundation::HWND) -> u32;
    }
    GetWindowContextHelpId(param0.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowSubclass<'a, P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, pdwrefdata: ::core::option::Option<*mut usize>) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn GetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: *mut ::core::ffi::c_void, uidsubclass: usize, pdwrefdata: *mut usize) -> super::super::Foundation::BOOL;
    }
    GetWindowSubclass(hwnd.into(), ::core::mem::transmute(pfnsubclass), uidsubclass, ::core::mem::transmute(pdwrefdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
    }
    HMONITOR_UserFree(::core::mem::transmute(param0), ::core::mem::transmute(param1))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
    }
    HMONITOR_UserFree64(::core::mem::transmute(param0), ::core::mem::transmute(param1))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserMarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserMarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
    }
    HMONITOR_UserSize(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
    }
    HMONITOR_UserSize64(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserUnmarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
    }
    HMONITOR_UserUnmarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HashData(pbdata: &[u8], pbhash: &mut [u8]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HashData(pbdata: *const u8, cbdata: u32, pbhash: *mut u8, cbhash: u32) -> ::windows::core::HRESULT;
    }
    HashData(::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, ::core::mem::transmute(pbhash.as_ptr()), pbhash.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkClone<'a, P0, P1, T>(pihl: P0, pihlsiteforclone: P1, dwsitedata: u32) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkClone(pihl: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pihlsiteforclone: *mut ::core::ffi::c_void, dwsitedata: u32, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkClone(pihl.into().abi(), &<T as ::windows::core::Interface>::IID, pihlsiteforclone.into().abi(), dwsitedata, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateBrowseContext<'a, P0, T>(piunkouter: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateBrowseContext(piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkCreateBrowseContext(piunkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateExtensionServices<'a, P0, P1, P2, P3, P4, T>(pwzadditionalheaders: P0, phwnd: P1, pszusername: P2, pszpassword: P3, piunkouter: P4) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateExtensionServices(pwzadditionalheaders: ::windows::core::PCWSTR, phwnd: super::super::Foundation::HWND, pszusername: ::windows::core::PCWSTR, pszpassword: ::windows::core::PCWSTR, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkCreateExtensionServices(pwzadditionalheaders.into(), phwnd.into(), pszusername.into(), pszpassword.into(), piunkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromData<'a, P0, P1, P2, T>(pidataobj: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromData(pidataobj: *mut ::core::ffi::c_void, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkCreateFromData(pidataobj.into().abi(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromMoniker<'a, P0, P1, P2, P3, P4, T>(pimktrgt: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromMoniker(pimktrgt: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkCreateFromMoniker(pimktrgt.into().abi(), pwzlocation.into(), pwzfriendlyname.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateFromString<'a, P0, P1, P2, P3, P4, T>(pwztarget: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateFromString(pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    HlinkCreateFromString(pwztarget.into(), pwzlocation.into(), pwzfriendlyname.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateShortcut<'a, P0, P1, P2>(grfhlshortcutf: u32, pihl: P0, pwzdir: P1, pwzfilename: P2, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcut(grfhlshortcutf: u32, pihl: *mut ::core::ffi::c_void, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcut(grfhlshortcutf, pihl.into().abi(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateShortcutFromMoniker<'a, P0, P1, P2, P3>(grfhlshortcutf: u32, pimktarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcutFromMoniker(grfhlshortcutf: u32, pimktarget: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcutFromMoniker(grfhlshortcutf, pimktarget.into().abi(), pwzlocation.into(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkCreateShortcutFromString<'a, P0, P1, P2, P3>(grfhlshortcutf: u32, pwztarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkCreateShortcutFromString(grfhlshortcutf: u32, pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pwzdir: ::windows::core::PCWSTR, pwzfilename: ::windows::core::PCWSTR, ppwzshortcutfile: *mut ::windows::core::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
    }
    HlinkCreateShortcutFromString(grfhlshortcutf, pwztarget.into(), pwzlocation.into(), pwzdir.into(), pwzfilename.into(), ::core::mem::transmute(ppwzshortcutfile), dwreserved).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkGetSpecialReference(ureference: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkGetSpecialReference(ureference: u32, ppwzreference: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkGetSpecialReference(ureference, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkGetValueFromParams<'a, P0, P1>(pwzparams: P0, pwzname: P1) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkGetValueFromParams(pwzparams: ::windows::core::PCWSTR, pwzname: ::windows::core::PCWSTR, ppwzvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkGetValueFromParams(pwzparams.into(), pwzname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkIsShortcut<'a, P0>(pwzfilename: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkIsShortcut(pwzfilename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkIsShortcut(pwzfilename.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigate<'a, P0, P1, P2, P3, P4>(pihl: P0, pihlframe: P1, grfhlnf: u32, pbc: P2, pibsc: P3, pihlbc: P4) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlink>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkNavigate(pihl: *mut ::core::ffi::c_void, pihlframe: *mut ::core::ffi::c_void, grfhlnf: u32, pbc: *mut ::core::ffi::c_void, pibsc: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkNavigate(pihl.into().abi(), pihlframe.into().abi(), grfhlnf, pbc.into().abi(), pibsc.into().abi(), pihlbc.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigateToStringReference<'a, P0, P1, P2, P3, P4, P5, P6>(pwztarget: P0, pwzlocation: P1, pihlsite: P2, dwsitedata: u32, pihlframe: P3, grfhlnf: u32, pibc: P4, pibsc: P5, pihlbc: P6) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P4: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P5: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P6: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkNavigateToStringReference(pwztarget: ::windows::core::PCWSTR, pwzlocation: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, pihlframe: *mut ::core::ffi::c_void, grfhlnf: u32, pibc: *mut ::core::ffi::c_void, pibsc: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkNavigateToStringReference(pwztarget.into(), pwzlocation.into(), pihlsite.into().abi(), dwsitedata, pihlframe.into().abi(), grfhlnf, pibc.into().abi(), pibsc.into().abi(), pihlbc.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnNavigate<'a, P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, grfhlnf: u32, pimktarget: P2, pwzlocation: P3, pwzfriendlyname: P4, puhlid: *mut u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkOnNavigate(pihlframe: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void, grfhlnf: u32, pimktarget: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR, puhlid: *mut u32) -> ::windows::core::HRESULT;
    }
    HlinkOnNavigate(pihlframe.into().abi(), pihlbc.into().abi(), grfhlnf, pimktarget.into().abi(), pwzlocation.into(), pwzfriendlyname.into(), ::core::mem::transmute(puhlid)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnRenameDocument<'a, P0, P1, P2>(dwreserved: u32, pihlbc: P0, pimkold: P1, pimknew: P2) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkOnRenameDocument(dwreserved: u32, pihlbc: *mut ::core::ffi::c_void, pimkold: *mut ::core::ffi::c_void, pimknew: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkOnRenameDocument(dwreserved, pihlbc.into().abi(), pimkold.into().abi(), pimknew.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkParseDisplayName<'a, P0, P1, P2>(pibc: P0, pwzdisplayname: P1, fnoforceabs: P2, pccheaten: *mut u32, ppimk: *mut ::core::option::Option<super::super::System::Com::IMoniker>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkParseDisplayName(pibc: *mut ::core::ffi::c_void, pwzdisplayname: ::windows::core::PCWSTR, fnoforceabs: super::super::Foundation::BOOL, pccheaten: *mut u32, ppimk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkParseDisplayName(pibc.into().abi(), pwzdisplayname.into(), fnoforceabs.into(), ::core::mem::transmute(pccheaten), ::core::mem::transmute(ppimk)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkPreprocessMoniker<'a, P0, P1>(pibc: P0, pimkin: P1) -> ::windows::core::Result<super::super::System::Com::IMoniker>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkPreprocessMoniker(pibc: *mut ::core::ffi::c_void, pimkin: *mut ::core::ffi::c_void, ppimkout: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkPreprocessMoniker(pibc.into().abi(), pimkin.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IMoniker>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkQueryCreateFromData<'a, P0>(pidataobj: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkQueryCreateFromData(pidataobj: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkQueryCreateFromData(pidataobj.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveMonikerForData<'a, P0, P1, P2, P3>(pimkreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveMonikerForData(pimkreference: *mut ::core::ffi::c_void, reserved: u32, pibc: *mut ::core::ffi::c_void, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: *mut ::core::ffi::c_void, pimkbase: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveMonikerForData(pimkreference.into().abi(), reserved, pibc.into().abi(), cfmtetc, ::core::mem::transmute(rgfmtetc), pibsc.into().abi(), pimkbase.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkResolveShortcut<'a, P0, P1, P2>(pwzshortcutfilename: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkSite>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcut(pwzshortcutfilename: ::windows::core::PCWSTR, pihlsite: *mut ::core::ffi::c_void, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcut(pwzshortcutfilename.into(), pihlsite.into().abi(), dwsitedata, piunkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveShortcutToMoniker<'a, P0>(pwzshortcutfilename: P0, ppimktarget: *mut ::core::option::Option<super::super::System::Com::IMoniker>, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcutToMoniker(pwzshortcutfilename: ::windows::core::PCWSTR, ppimktarget: *mut *mut ::core::ffi::c_void, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcutToMoniker(pwzshortcutfilename.into(), ::core::mem::transmute(ppimktarget), ::core::mem::transmute(ppwzlocation)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkResolveShortcutToString<'a, P0>(pwzshortcutfilename: P0, ppwztarget: *mut ::windows::core::PWSTR, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveShortcutToString(pwzshortcutfilename: ::windows::core::PCWSTR, ppwztarget: *mut ::windows::core::PWSTR, ppwzlocation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    HlinkResolveShortcutToString(pwzshortcutfilename.into(), ::core::mem::transmute(ppwztarget), ::core::mem::transmute(ppwzlocation)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveStringForData<'a, P0, P1, P2, P3>(pwzreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindStatusCallback>>,
    P3: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkResolveStringForData(pwzreference: ::windows::core::PCWSTR, reserved: u32, pibc: *mut ::core::ffi::c_void, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: *mut ::core::ffi::c_void, pimkbase: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    HlinkResolveStringForData(pwzreference.into(), reserved, pibc.into().abi(), cfmtetc, ::core::mem::transmute(rgfmtetc), pibsc.into().abi(), pimkbase.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkSetSpecialReference<'a, P0>(ureference: u32, pwzreference: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkSetSpecialReference(ureference: u32, pwzreference: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkSetSpecialReference(ureference, pwzreference.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn HlinkTranslateURL<'a, P0>(pwzurl: P0, grfflags: u32) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkTranslateURL(pwzurl: ::windows::core::PCWSTR, grfflags: u32, ppwztranslatedurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    HlinkTranslateURL(pwzurl.into(), grfflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkUpdateStackItem<'a, P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, uhlid: u32, pimktrgt: P2, pwzlocation: P3, pwzfriendlyname: P4) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IHlinkFrame>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IHlinkBrowseContext>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMoniker>>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn HlinkUpdateStackItem(pihlframe: *mut ::core::ffi::c_void, pihlbc: *mut ::core::ffi::c_void, uhlid: u32, pimktrgt: *mut ::core::ffi::c_void, pwzlocation: ::windows::core::PCWSTR, pwzfriendlyname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    HlinkUpdateStackItem(pihlframe.into().abi(), pihlbc.into().abi(), uhlid, pimktrgt.into().abi(), pwzlocation.into(), pwzfriendlyname.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILAppendID<'a, P0>(pidl: ::core::option::Option<*const Common::ITEMIDLIST>, pmkid: *const Common::SHITEMID, fappend: P0) -> *mut Common::ITEMIDLIST
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILAppendID(pidl: *const Common::ITEMIDLIST, pmkid: *const Common::SHITEMID, fappend: super::super::Foundation::BOOL) -> *mut Common::ITEMIDLIST;
    }
    ILAppendID(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pmkid), fappend.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILClone(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILClone(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILClone(::core::mem::transmute(pidl))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCloneFirst(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILCloneFirst(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILCloneFirst(::core::mem::transmute(pidl))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCombine(pidl1: ::core::option::Option<*const Common::ITEMIDLIST>, pidl2: ::core::option::Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILCombine(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILCombine(::core::mem::transmute(pidl1.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pidl2.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathA<'a, P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILCreateFromPathA(pszpath: ::windows::core::PCSTR) -> *mut Common::ITEMIDLIST;
    }
    ILCreateFromPathA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathW<'a, P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILCreateFromPathW(pszpath: ::windows::core::PCWSTR) -> *mut Common::ITEMIDLIST;
    }
    ILCreateFromPathW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindChild(pidlparent: *const Common::ITEMIDLIST, pidlchild: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILFindChild(pidlparent: *const Common::ITEMIDLIST, pidlchild: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILFindChild(::core::mem::transmute(pidlparent), ::core::mem::transmute(pidlchild))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindLastID(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILFindLastID(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILFindLastID(::core::mem::transmute(pidl))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFree(pidl: ::core::option::Option<*const Common::ITEMIDLIST>) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILFree(pidl: *const Common::ITEMIDLIST);
    }
    ILFree(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetNext(pidl: ::core::option::Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILGetNext(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST;
    }
    ILGetNext(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetSize(pidl: ::core::option::Option<*const Common::ITEMIDLIST>) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILGetSize(pidl: *const Common::ITEMIDLIST) -> u32;
    }
    ILGetSize(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILIsEqual(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILIsEqual(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL;
    }
    ILIsEqual(::core::mem::transmute(pidl1), ::core::mem::transmute(pidl2))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILIsParent<'a, P0>(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST, fimmediate: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILIsParent(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST, fimmediate: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    ILIsParent(::core::mem::transmute(pidl1), ::core::mem::transmute(pidl2), fimmediate.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILLoadFromStreamEx<'a, P0>(pstm: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILLoadFromStreamEx(pstm: *mut ::core::ffi::c_void, pidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    ILLoadFromStreamEx(pstm.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILRemoveLastID(pidl: ::core::option::Option<*mut Common::ITEMIDLIST>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILRemoveLastID(pidl: *mut Common::ITEMIDLIST) -> super::super::Foundation::BOOL;
    }
    ILRemoveLastID(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILSaveToStream<'a, P0>(pstm: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ILSaveToStream(pstm: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    ILSaveToStream(pstm.into().abi(), ::core::mem::transmute(pidl)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Copy<'a, P0, P1>(pstmfrom: P0, pstmto: P1, cb: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_Copy(pstmfrom: *mut ::core::ffi::c_void, pstmto: *mut ::core::ffi::c_void, cb: u32) -> ::windows::core::HRESULT;
    }
    IStream_Copy(pstmfrom.into().abi(), pstmto.into().abi(), cb).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Read<'a, P0>(pstm: P0, pv: *mut ::core::ffi::c_void, cb: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_Read(pstm: *mut ::core::ffi::c_void, pv: *mut ::core::ffi::c_void, cb: u32) -> ::windows::core::HRESULT;
    }
    IStream_Read(pstm.into().abi(), ::core::mem::transmute(pv), cb).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_ReadPidl<'a, P0>(pstm: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_ReadPidl(pstm: *mut ::core::ffi::c_void, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    IStream_ReadPidl(pstm.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_ReadStr<'a, P0>(pstm: P0) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_ReadStr(pstm: *mut ::core::ffi::c_void, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    IStream_ReadStr(pstm.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Reset<'a, P0>(pstm: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_Reset(pstm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    IStream_Reset(pstm.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Size<'a, P0>(pstm: P0) -> ::windows::core::Result<u64>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_Size(pstm: *mut ::core::ffi::c_void, pui: *mut u64) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    IStream_Size(pstm.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Write<'a, P0>(pstm: P0, pv: *const ::core::ffi::c_void, cb: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_Write(pstm: *mut ::core::ffi::c_void, pv: *const ::core::ffi::c_void, cb: u32) -> ::windows::core::HRESULT;
    }
    IStream_Write(pstm.into().abi(), ::core::mem::transmute(pv), cb).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_WritePidl<'a, P0>(pstm: P0, pidlwrite: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_WritePidl(pstm: *mut ::core::ffi::c_void, pidlwrite: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    IStream_WritePidl(pstm.into().abi(), ::core::mem::transmute(pidlwrite)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_WriteStr<'a, P0, P1>(pstm: P0, psz: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IStream_WriteStr(pstm: *mut ::core::ffi::c_void, psz: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    IStream_WriteStr(pstm.into().abi(), psz.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IUnknown_AtomicRelease(ppunk: ::core::option::Option<*mut *mut ::core::ffi::c_void>) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_AtomicRelease(ppunk: *mut *mut ::core::ffi::c_void);
    }
    IUnknown_AtomicRelease(::core::mem::transmute(ppunk.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IUnknown_GetSite<'a, P0, T>(punk: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_GetSite(punk: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    IUnknown_GetSite(punk.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IUnknown_GetWindow<'a, P0>(punk: P0) -> ::windows::core::Result<super::super::Foundation::HWND>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_GetWindow(punk: *mut ::core::ffi::c_void, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    IUnknown_GetWindow(punk.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IUnknown_QueryService<'a, P0, T>(punk: P0, guidservice: *const ::windows::core::GUID) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_QueryService(punk: *mut ::core::ffi::c_void, guidservice: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, ppvout: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    IUnknown_QueryService(punk.into().abi(), ::core::mem::transmute(guidservice), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IUnknown_Set<'a, P0>(ppunk: *mut ::core::option::Option<::windows::core::IUnknown>, punk: P0)
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_Set(ppunk: *mut *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void);
    }
    IUnknown_Set(::core::mem::transmute(ppunk), punk.into().abi())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IUnknown_SetSite<'a, P0, P1>(punk: P0, punksite: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IUnknown_SetSite(punk: *mut ::core::ffi::c_void, punksite: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    IUnknown_SetSite(punk.into().abi(), punksite.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImportPrivacySettings<'a, P0>(pszfilename: P0, pfparseprivacypreferences: *mut super::super::Foundation::BOOL, pfparsepersiterules: *mut super::super::Foundation::BOOL) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ImportPrivacySettings(pszfilename: ::windows::core::PCWSTR, pfparseprivacypreferences: *mut super::super::Foundation::BOOL, pfparsepersiterules: *mut super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    ImportPrivacySettings(pszfilename.into(), ::core::mem::transmute(pfparseprivacypreferences), ::core::mem::transmute(pfparsepersiterules))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn InitNetworkAddressControl() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn InitNetworkAddressControl() -> super::super::Foundation::BOOL;
    }
    InitNetworkAddressControl()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IntlStrEqWorkerA<'a, P0, P1, P2>(fcasesens: P0, lpstring1: P1, lpstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IntlStrEqWorkerA(fcasesens: super::super::Foundation::BOOL, lpstring1: ::windows::core::PCSTR, lpstring2: ::windows::core::PCSTR, nchar: i32) -> super::super::Foundation::BOOL;
    }
    IntlStrEqWorkerA(fcasesens.into(), lpstring1.into(), lpstring2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IntlStrEqWorkerW<'a, P0, P1, P2>(fcasesens: P0, lpstring1: P1, lpstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IntlStrEqWorkerW(fcasesens: super::super::Foundation::BOOL, lpstring1: ::windows::core::PCWSTR, lpstring2: ::windows::core::PCWSTR, nchar: i32) -> super::super::Foundation::BOOL;
    }
    IntlStrEqWorkerW(fcasesens.into(), lpstring1.into(), lpstring2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsCharSpaceA<'a, P0>(wch: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::CHAR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsCharSpaceA(wch: super::super::Foundation::CHAR) -> super::super::Foundation::BOOL;
    }
    IsCharSpaceA(wch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsCharSpaceW(wch: u16) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsCharSpaceW(wch: u16) -> super::super::Foundation::BOOL;
    }
    IsCharSpaceW(wch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsInternetESCEnabled() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsInternetESCEnabled() -> super::super::Foundation::BOOL;
    }
    IsInternetESCEnabled()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsLFNDriveA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsLFNDriveA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    IsLFNDriveA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsLFNDriveW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsLFNDriveW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    IsLFNDriveW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn IsNetDrive(idrive: i32) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsNetDrive(idrive: i32) -> i32;
    }
    IsNetDrive(idrive)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsOS(dwos: OS) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsOS(dwos: OS) -> super::super::Foundation::BOOL;
    }
    IsOS(dwos)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsUserAnAdmin() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn IsUserAnAdmin() -> super::super::Foundation::BOOL;
    }
    IsUserAnAdmin()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LoadUserProfileA<'a, P0>(htoken: P0, lpprofileinfo: *mut PROFILEINFOA) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn LoadUserProfileA(htoken: super::super::Foundation::HANDLE, lpprofileinfo: *mut PROFILEINFOA) -> super::super::Foundation::BOOL;
    }
    LoadUserProfileA(htoken.into(), ::core::mem::transmute(lpprofileinfo))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn LoadUserProfileW<'a, P0>(htoken: P0, lpprofileinfo: *mut PROFILEINFOW) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn LoadUserProfileW(htoken: super::super::Foundation::HANDLE, lpprofileinfo: *mut PROFILEINFOW) -> super::super::Foundation::BOOL;
    }
    LoadUserProfileW(htoken.into(), ::core::mem::transmute(lpprofileinfo))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn OleSaveToStreamEx<'a, P0, P1, P2>(piunk: P0, pistm: P1, fcleardirty: P2) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn OleSaveToStreamEx(piunk: *mut ::core::ffi::c_void, pistm: *mut ::core::ffi::c_void, fcleardirty: super::super::Foundation::BOOL) -> ::windows::core::HRESULT;
    }
    OleSaveToStreamEx(piunk.into().abi(), pistm.into().abi(), fcleardirty.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn OpenRegStream<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn OpenRegStream(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    OpenRegStream(hkey.into(), pszsubkey.into(), pszvalue.into(), grfmode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn ParseURLA<'a, P0>(pcszurl: P0, ppu: *mut PARSEDURLA) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ParseURLA(pcszurl: ::windows::core::PCSTR, ppu: *mut PARSEDURLA) -> ::windows::core::HRESULT;
    }
    ParseURLA(pcszurl.into(), ::core::mem::transmute(ppu)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn ParseURLW<'a, P0>(pcszurl: P0, ppu: *mut PARSEDURLW) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ParseURLW(pcszurl: ::windows::core::PCWSTR, ppu: *mut PARSEDURLW) -> ::windows::core::HRESULT;
    }
    ParseURLW(pcszurl.into(), ::core::mem::transmute(ppu)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathAddBackslashA(pszpath: &mut [u8; 260]) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAddBackslashA(pszpath: ::windows::core::PSTR) -> ::windows::core::PSTR;
    }
    PathAddBackslashA(::core::mem::transmute(pszpath.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathAddBackslashW(pszpath: &mut [u16; 260]) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAddBackslashW(pszpath: ::windows::core::PWSTR) -> ::windows::core::PWSTR;
    }
    PathAddBackslashW(::core::mem::transmute(pszpath.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathAddExtensionA<'a, P0>(pszpath: &mut [u8; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAddExtensionA(pszpath: ::windows::core::PSTR, pszext: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathAddExtensionA(::core::mem::transmute(pszpath.as_ptr()), pszext.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathAddExtensionW<'a, P0>(pszpath: &mut [u16; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAddExtensionW(pszpath: ::windows::core::PWSTR, pszext: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathAddExtensionW(::core::mem::transmute(pszpath.as_ptr()), pszext.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathAllocCanonicalize<'a, P0>(pszpathin: P0, dwflags: PATHCCH_OPTIONS) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAllocCanonicalize(pszpathin: ::windows::core::PCWSTR, dwflags: PATHCCH_OPTIONS, ppszpathout: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    PathAllocCanonicalize(pszpathin.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathAllocCombine<'a, P0, P1>(pszpathin: P0, pszmore: P1, dwflags: PATHCCH_OPTIONS) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAllocCombine(pszpathin: ::windows::core::PCWSTR, pszmore: ::windows::core::PCWSTR, dwflags: PATHCCH_OPTIONS, ppszpathout: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    PathAllocCombine(pszpathin.into(), pszmore.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathAppendA<'a, P0>(pszpath: &mut [u8; 260], pszmore: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAppendA(pszpath: ::windows::core::PSTR, pszmore: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathAppendA(::core::mem::transmute(pszpath.as_ptr()), pszmore.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathAppendW<'a, P0>(pszpath: &mut [u16; 260], pszmore: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathAppendW(pszpath: ::windows::core::PWSTR, pszmore: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathAppendW(::core::mem::transmute(pszpath.as_ptr()), pszmore.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathBuildRootA(pszroot: &mut [u8; 4], idrive: i32) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathBuildRootA(pszroot: ::windows::core::PSTR, idrive: i32) -> ::windows::core::PSTR;
    }
    PathBuildRootA(::core::mem::transmute(pszroot.as_ptr()), idrive)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathBuildRootW(pszroot: &mut [u16; 4], idrive: i32) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathBuildRootW(pszroot: ::windows::core::PWSTR, idrive: i32) -> ::windows::core::PWSTR;
    }
    PathBuildRootW(::core::mem::transmute(pszroot.as_ptr()), idrive)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathCanonicalizeA<'a, P0>(pszbuf: &mut [u8; 260], pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCanonicalizeA(pszbuf: ::windows::core::PSTR, pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathCanonicalizeA(::core::mem::transmute(pszbuf.as_ptr()), pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathCanonicalizeW<'a, P0>(pszbuf: &mut [u16; 260], pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCanonicalizeW(pszbuf: ::windows::core::PWSTR, pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathCanonicalizeW(::core::mem::transmute(pszbuf.as_ptr()), pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchAddBackslash(pszpath: &mut [u16]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchAddBackslash(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchAddBackslash(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchAddBackslashEx(pszpath: &mut [u16], ppszend: ::core::option::Option<*mut ::windows::core::PWSTR>, pcchremaining: ::core::option::Option<*mut usize>) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchAddBackslashEx(pszpath: ::windows::core::PWSTR, cchpath: usize, ppszend: *mut ::windows::core::PWSTR, pcchremaining: *mut usize) -> ::windows::core::HRESULT;
    }
    PathCchAddBackslashEx(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, ::core::mem::transmute(ppszend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchremaining.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchAddExtension<'a, P0>(pszpath: &mut [u16], pszext: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchAddExtension(pszpath: ::windows::core::PWSTR, cchpath: usize, pszext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    PathCchAddExtension(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, pszext.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchAppend<'a, P0>(pszpath: &mut [u16], pszmore: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchAppend(pszpath: ::windows::core::PWSTR, cchpath: usize, pszmore: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    PathCchAppend(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, pszmore.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchAppendEx<'a, P0>(pszpath: &mut [u16], pszmore: P0, dwflags: PATHCCH_OPTIONS) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchAppendEx(pszpath: ::windows::core::PWSTR, cchpath: usize, pszmore: ::windows::core::PCWSTR, dwflags: PATHCCH_OPTIONS) -> ::windows::core::HRESULT;
    }
    PathCchAppendEx(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, pszmore.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchCanonicalize<'a, P0>(pszpathout: &mut [u16], pszpathin: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchCanonicalize(pszpathout: ::windows::core::PWSTR, cchpathout: usize, pszpathin: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    PathCchCanonicalize(::core::mem::transmute(pszpathout.as_ptr()), pszpathout.len() as _, pszpathin.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchCanonicalizeEx<'a, P0>(pszpathout: &mut [u16], pszpathin: P0, dwflags: PATHCCH_OPTIONS) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchCanonicalizeEx(pszpathout: ::windows::core::PWSTR, cchpathout: usize, pszpathin: ::windows::core::PCWSTR, dwflags: PATHCCH_OPTIONS) -> ::windows::core::HRESULT;
    }
    PathCchCanonicalizeEx(::core::mem::transmute(pszpathout.as_ptr()), pszpathout.len() as _, pszpathin.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchCombine<'a, P0, P1>(pszpathout: &mut [u16], pszpathin: P0, pszmore: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchCombine(pszpathout: ::windows::core::PWSTR, cchpathout: usize, pszpathin: ::windows::core::PCWSTR, pszmore: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    PathCchCombine(::core::mem::transmute(pszpathout.as_ptr()), pszpathout.len() as _, pszpathin.into(), pszmore.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchCombineEx<'a, P0, P1>(pszpathout: &mut [u16], pszpathin: P0, pszmore: P1, dwflags: PATHCCH_OPTIONS) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchCombineEx(pszpathout: ::windows::core::PWSTR, cchpathout: usize, pszpathin: ::windows::core::PCWSTR, pszmore: ::windows::core::PCWSTR, dwflags: PATHCCH_OPTIONS) -> ::windows::core::HRESULT;
    }
    PathCchCombineEx(::core::mem::transmute(pszpathout.as_ptr()), pszpathout.len() as _, pszpathin.into(), pszmore.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchFindExtension<'a, P0>(pszpath: P0, cchpath: usize) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchFindExtension(pszpath: ::windows::core::PCWSTR, cchpath: usize, ppszext: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    PathCchFindExtension(pszpath.into(), cchpath, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathCchIsRoot<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchIsRoot(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathCchIsRoot(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchRemoveBackslash(pszpath: &mut [u16]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchRemoveBackslash(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchRemoveBackslash(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchRemoveBackslashEx(pszpath: ::windows::core::PWSTR, cchpath: usize, ppszend: ::core::option::Option<*mut ::windows::core::PWSTR>, pcchremaining: ::core::option::Option<*mut usize>) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchRemoveBackslashEx(pszpath: ::windows::core::PWSTR, cchpath: usize, ppszend: *mut ::windows::core::PWSTR, pcchremaining: *mut usize) -> ::windows::core::HRESULT;
    }
    PathCchRemoveBackslashEx(::core::mem::transmute(pszpath), cchpath, ::core::mem::transmute(ppszend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchremaining.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchRemoveExtension(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchRemoveExtension(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchRemoveExtension(::core::mem::transmute(pszpath), cchpath).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchRemoveFileSpec(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchRemoveFileSpec(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchRemoveFileSpec(::core::mem::transmute(pszpath), cchpath).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchRenameExtension<'a, P0>(pszpath: &mut [u16], pszext: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchRenameExtension(pszpath: ::windows::core::PWSTR, cchpath: usize, pszext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    PathCchRenameExtension(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, pszext.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchSkipRoot<'a, P0>(pszpath: P0) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchSkipRoot(pszpath: ::windows::core::PCWSTR, ppszrootend: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    PathCchSkipRoot(pszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchStripPrefix(pszpath: &mut [u16]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchStripPrefix(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchStripPrefix(::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCchStripToRoot(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCchStripToRoot(pszpath: ::windows::core::PWSTR, cchpath: usize) -> ::windows::core::HRESULT;
    }
    PathCchStripToRoot(::core::mem::transmute(pszpath), cchpath).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCleanupSpec<'a, P0>(pszdir: P0, pszspec: ::windows::core::PWSTR) -> PCS_RET
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCleanupSpec(pszdir: ::windows::core::PCWSTR, pszspec: ::windows::core::PWSTR) -> PCS_RET;
    }
    PathCleanupSpec(pszdir.into(), ::core::mem::transmute(pszspec))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCombineA<'a, P0, P1>(pszdest: &mut [u8; 260], pszdir: P0, pszfile: P1) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCombineA(pszdest: ::windows::core::PSTR, pszdir: ::windows::core::PCSTR, pszfile: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathCombineA(::core::mem::transmute(pszdest.as_ptr()), pszdir.into(), pszfile.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCombineW<'a, P0, P1>(pszdest: &mut [u16; 260], pszdir: P0, pszfile: P1) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCombineW(pszdest: ::windows::core::PWSTR, pszdir: ::windows::core::PCWSTR, pszfile: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathCombineW(::core::mem::transmute(pszdest.as_ptr()), pszdir.into(), pszfile.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCommonPrefixA<'a, P0, P1>(pszfile1: P0, pszfile2: P1, achpath: ::core::option::Option<&mut [u8; 260]>) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCommonPrefixA(pszfile1: ::windows::core::PCSTR, pszfile2: ::windows::core::PCSTR, achpath: ::windows::core::PSTR) -> i32;
    }
    PathCommonPrefixA(pszfile1.into(), pszfile2.into(), ::core::mem::transmute(achpath.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCommonPrefixW<'a, P0, P1>(pszfile1: P0, pszfile2: P1, achpath: ::core::option::Option<&mut [u16; 260]>) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCommonPrefixW(pszfile1: ::windows::core::PCWSTR, pszfile2: ::windows::core::PCWSTR, achpath: ::windows::core::PWSTR) -> i32;
    }
    PathCommonPrefixW(pszfile1.into(), pszfile2.into(), ::core::mem::transmute(achpath.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn PathCompactPathA<'a, P0>(hdc: P0, pszpath: &mut [u8; 260], dx: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Graphics::Gdi::HDC>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCompactPathA(hdc: super::super::Graphics::Gdi::HDC, pszpath: ::windows::core::PSTR, dx: u32) -> super::super::Foundation::BOOL;
    }
    PathCompactPathA(hdc.into(), ::core::mem::transmute(pszpath.as_ptr()), dx)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathCompactPathExA<'a, P0>(pszout: &mut [u8], pszsrc: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCompactPathExA(pszout: ::windows::core::PSTR, pszsrc: ::windows::core::PCSTR, cchmax: u32, dwflags: u32) -> super::super::Foundation::BOOL;
    }
    PathCompactPathExA(::core::mem::transmute(pszout.as_ptr()), pszsrc.into(), pszout.len() as _, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathCompactPathExW<'a, P0>(pszout: &mut [u16], pszsrc: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCompactPathExW(pszout: ::windows::core::PWSTR, pszsrc: ::windows::core::PCWSTR, cchmax: u32, dwflags: u32) -> super::super::Foundation::BOOL;
    }
    PathCompactPathExW(::core::mem::transmute(pszout.as_ptr()), pszsrc.into(), pszout.len() as _, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
#[inline]
pub unsafe fn PathCompactPathW<'a, P0>(hdc: P0, pszpath: &mut [u16; 260], dx: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Graphics::Gdi::HDC>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCompactPathW(hdc: super::super::Graphics::Gdi::HDC, pszpath: ::windows::core::PWSTR, dx: u32) -> super::super::Foundation::BOOL;
    }
    PathCompactPathW(hdc.into(), ::core::mem::transmute(pszpath.as_ptr()), dx)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCreateFromUrlA<'a, P0>(pszurl: P0, pszpath: ::windows::core::PSTR, pcchpath: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCreateFromUrlA(pszurl: ::windows::core::PCSTR, pszpath: ::windows::core::PSTR, pcchpath: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    PathCreateFromUrlA(pszurl.into(), ::core::mem::transmute(pszpath), ::core::mem::transmute(pcchpath), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCreateFromUrlAlloc<'a, P0>(pszin: P0, ppszout: *mut ::windows::core::PWSTR, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCreateFromUrlAlloc(pszin: ::windows::core::PCWSTR, ppszout: *mut ::windows::core::PWSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    PathCreateFromUrlAlloc(pszin.into(), ::core::mem::transmute(ppszout), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathCreateFromUrlW<'a, P0>(pszurl: P0, pszpath: ::windows::core::PWSTR, pcchpath: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathCreateFromUrlW(pszurl: ::windows::core::PCWSTR, pszpath: ::windows::core::PWSTR, pcchpath: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    PathCreateFromUrlW(pszurl.into(), ::core::mem::transmute(pszpath), ::core::mem::transmute(pcchpath), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathFileExistsA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFileExistsA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathFileExistsA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathFileExistsW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFileExistsW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathFileExistsW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindExtensionA<'a, P0>(pszpath: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindExtensionA(pszpath: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathFindExtensionA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindExtensionW<'a, P0>(pszpath: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindExtensionW(pszpath: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathFindExtensionW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindFileNameA<'a, P0>(pszpath: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindFileNameA(pszpath: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathFindFileNameA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindFileNameW<'a, P0>(pszpath: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindFileNameW(pszpath: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathFindFileNameW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindNextComponentA<'a, P0>(pszpath: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindNextComponentA(pszpath: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathFindNextComponentA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindNextComponentW<'a, P0>(pszpath: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindNextComponentW(pszpath: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathFindNextComponentW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathFindOnPathA(pszpath: &mut [u8; 260], ppszotherdirs: ::core::option::Option<*const *const i8>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindOnPathA(pszpath: ::windows::core::PSTR, ppszotherdirs: *const *const i8) -> super::super::Foundation::BOOL;
    }
    PathFindOnPathA(::core::mem::transmute(pszpath.as_ptr()), ::core::mem::transmute(ppszotherdirs.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathFindOnPathW(pszpath: &mut [u16; 260], ppszotherdirs: ::core::option::Option<*const *const u16>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindOnPathW(pszpath: ::windows::core::PWSTR, ppszotherdirs: *const *const u16) -> super::super::Foundation::BOOL;
    }
    PathFindOnPathW(::core::mem::transmute(pszpath.as_ptr()), ::core::mem::transmute(ppszotherdirs.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindSuffixArrayA<'a, P0>(pszpath: P0, apszsuffix: &[::windows::core::PSTR]) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindSuffixArrayA(pszpath: ::windows::core::PCSTR, apszsuffix: *const ::windows::core::PSTR, iarraysize: i32) -> ::windows::core::PSTR;
    }
    PathFindSuffixArrayA(pszpath.into(), ::core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathFindSuffixArrayW<'a, P0>(pszpath: P0, apszsuffix: &[::windows::core::PWSTR]) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathFindSuffixArrayW(pszpath: ::windows::core::PCWSTR, apszsuffix: *const ::windows::core::PWSTR, iarraysize: i32) -> ::windows::core::PWSTR;
    }
    PathFindSuffixArrayW(pszpath.into(), ::core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetArgsA<'a, P0>(pszpath: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetArgsA(pszpath: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathGetArgsA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetArgsW<'a, P0>(pszpath: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetArgsW(pszpath: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathGetArgsW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetCharTypeA(ch: u8) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetCharTypeA(ch: u8) -> u32;
    }
    PathGetCharTypeA(ch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetCharTypeW(ch: u16) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetCharTypeW(ch: u16) -> u32;
    }
    PathGetCharTypeW(ch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetDriveNumberA<'a, P0>(pszpath: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetDriveNumberA(pszpath: ::windows::core::PCSTR) -> i32;
    }
    PathGetDriveNumberA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetDriveNumberW<'a, P0>(pszpath: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetDriveNumberW(pszpath: ::windows::core::PCWSTR) -> i32;
    }
    PathGetDriveNumberW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathGetShortPath(pszlongpath: &mut [u16; 260]) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathGetShortPath(pszlongpath: ::windows::core::PWSTR);
    }
    PathGetShortPath(::core::mem::transmute(pszlongpath.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsContentTypeA<'a, P0, P1>(pszpath: P0, pszcontenttype: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsContentTypeA(pszpath: ::windows::core::PCSTR, pszcontenttype: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsContentTypeA(pszpath.into(), pszcontenttype.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsContentTypeW<'a, P0, P1>(pszpath: P0, pszcontenttype: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsContentTypeW(pszpath: ::windows::core::PCWSTR, pszcontenttype: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsContentTypeW(pszpath.into(), pszcontenttype.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsDirectoryA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsDirectoryA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsDirectoryA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsDirectoryEmptyA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsDirectoryEmptyA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsDirectoryEmptyA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsDirectoryEmptyW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsDirectoryEmptyW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsDirectoryEmptyW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsDirectoryW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsDirectoryW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsDirectoryW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsExe<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsExe(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsExe(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsFileSpecA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsFileSpecA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsFileSpecA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsFileSpecW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsFileSpecW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsFileSpecW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsLFNFileSpecA<'a, P0>(pszname: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsLFNFileSpecA(pszname: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsLFNFileSpecA(pszname.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsLFNFileSpecW<'a, P0>(pszname: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsLFNFileSpecW(pszname: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsLFNFileSpecW(pszname.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsNetworkPathA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsNetworkPathA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsNetworkPathA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsNetworkPathW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsNetworkPathW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsNetworkPathW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsPrefixA<'a, P0, P1>(pszprefix: P0, pszpath: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsPrefixA(pszprefix: ::windows::core::PCSTR, pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsPrefixA(pszprefix.into(), pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsPrefixW<'a, P0, P1>(pszprefix: P0, pszpath: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsPrefixW(pszprefix: ::windows::core::PCWSTR, pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsPrefixW(pszprefix.into(), pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsRelativeA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsRelativeA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsRelativeA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsRelativeW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsRelativeW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsRelativeW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsRootA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsRootA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsRootA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsRootW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsRootW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsRootW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSameRootA<'a, P0, P1>(pszpath1: P0, pszpath2: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSameRootA(pszpath1: ::windows::core::PCSTR, pszpath2: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsSameRootA(pszpath1.into(), pszpath2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSameRootW<'a, P0, P1>(pszpath1: P0, pszpath2: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSameRootW(pszpath1: ::windows::core::PCWSTR, pszpath2: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsSameRootW(pszpath1.into(), pszpath2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSlowA<'a, P0>(pszfile: P0, dwattr: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSlowA(pszfile: ::windows::core::PCSTR, dwattr: u32) -> super::super::Foundation::BOOL;
    }
    PathIsSlowA(pszfile.into(), dwattr)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSlowW<'a, P0>(pszfile: P0, dwattr: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSlowW(pszfile: ::windows::core::PCWSTR, dwattr: u32) -> super::super::Foundation::BOOL;
    }
    PathIsSlowW(pszfile.into(), dwattr)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSystemFolderA<'a, P0>(pszpath: P0, dwattrb: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSystemFolderA(pszpath: ::windows::core::PCSTR, dwattrb: u32) -> super::super::Foundation::BOOL;
    }
    PathIsSystemFolderA(pszpath.into(), dwattrb)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsSystemFolderW<'a, P0>(pszpath: P0, dwattrb: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsSystemFolderW(pszpath: ::windows::core::PCWSTR, dwattrb: u32) -> super::super::Foundation::BOOL;
    }
    PathIsSystemFolderW(pszpath.into(), dwattrb)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCEx<'a, P0>(pszpath: P0, ppszserver: ::core::option::Option<*mut ::windows::core::PWSTR>) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCEx(pszpath: ::windows::core::PCWSTR, ppszserver: *mut ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCEx(pszpath.into(), ::core::mem::transmute(ppszserver.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCServerA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCServerA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCServerA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCServerShareA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCServerShareA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCServerShareA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCServerShareW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCServerShareW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCServerShareW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCServerW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCServerW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCServerW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsUNCW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsUNCW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsUNCW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsURLA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsURLA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathIsURLA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathIsURLW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathIsURLW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathIsURLW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMakePrettyA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMakePrettyA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    PathMakePrettyA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMakePrettyW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMakePrettyW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathMakePrettyW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMakeSystemFolderA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMakeSystemFolderA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathMakeSystemFolderA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMakeSystemFolderW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMakeSystemFolderW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathMakeSystemFolderW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMakeUniqueName<'a, P0, P1, P2>(pszuniquename: &mut [u16], psztemplate: P0, pszlongplate: P1, pszdir: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMakeUniqueName(pszuniquename: ::windows::core::PWSTR, cchmax: u32, psztemplate: ::windows::core::PCWSTR, pszlongplate: ::windows::core::PCWSTR, pszdir: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathMakeUniqueName(::core::mem::transmute(pszuniquename.as_ptr()), pszuniquename.len() as _, psztemplate.into(), pszlongplate.into(), pszdir.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMatchSpecA<'a, P0, P1>(pszfile: P0, pszspec: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMatchSpecA(pszfile: ::windows::core::PCSTR, pszspec: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathMatchSpecA(pszfile.into(), pszspec.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathMatchSpecExA<'a, P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMatchSpecExA(pszfile: ::windows::core::PCSTR, pszspec: ::windows::core::PCSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    PathMatchSpecExA(pszfile.into(), pszspec.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathMatchSpecExW<'a, P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMatchSpecExW(pszfile: ::windows::core::PCWSTR, pszspec: ::windows::core::PCWSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    PathMatchSpecExW(pszfile.into(), pszspec.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathMatchSpecW<'a, P0, P1>(pszfile: P0, pszspec: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathMatchSpecW(pszfile: ::windows::core::PCWSTR, pszspec: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathMatchSpecW(pszfile.into(), pszspec.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathParseIconLocationA(psziconfile: ::windows::core::PSTR) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathParseIconLocationA(psziconfile: ::windows::core::PSTR) -> i32;
    }
    PathParseIconLocationA(::core::mem::transmute(psziconfile))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathParseIconLocationW(psziconfile: ::windows::core::PWSTR) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathParseIconLocationW(psziconfile: ::windows::core::PWSTR) -> i32;
    }
    PathParseIconLocationW(::core::mem::transmute(psziconfile))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathQualify(psz: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathQualify(psz: ::windows::core::PWSTR);
    }
    PathQualify(::core::mem::transmute(psz))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathQuoteSpacesA(lpsz: &mut [u8; 260]) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathQuoteSpacesA(lpsz: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    PathQuoteSpacesA(::core::mem::transmute(lpsz.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathQuoteSpacesW(lpsz: &mut [u16; 260]) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathQuoteSpacesW(lpsz: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathQuoteSpacesW(::core::mem::transmute(lpsz.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRelativePathToA<'a, P0, P1>(pszpath: &mut [u8; 260], pszfrom: P0, dwattrfrom: u32, pszto: P1, dwattrto: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRelativePathToA(pszpath: ::windows::core::PSTR, pszfrom: ::windows::core::PCSTR, dwattrfrom: u32, pszto: ::windows::core::PCSTR, dwattrto: u32) -> super::super::Foundation::BOOL;
    }
    PathRelativePathToA(::core::mem::transmute(pszpath.as_ptr()), pszfrom.into(), dwattrfrom, pszto.into(), dwattrto)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRelativePathToW<'a, P0, P1>(pszpath: &mut [u16; 260], pszfrom: P0, dwattrfrom: u32, pszto: P1, dwattrto: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRelativePathToW(pszpath: ::windows::core::PWSTR, pszfrom: ::windows::core::PCWSTR, dwattrfrom: u32, pszto: ::windows::core::PCWSTR, dwattrto: u32) -> super::super::Foundation::BOOL;
    }
    PathRelativePathToW(::core::mem::transmute(pszpath.as_ptr()), pszfrom.into(), dwattrfrom, pszto.into(), dwattrto)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveArgsA(pszpath: ::windows::core::PSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveArgsA(pszpath: ::windows::core::PSTR);
    }
    PathRemoveArgsA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveArgsW(pszpath: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveArgsW(pszpath: ::windows::core::PWSTR);
    }
    PathRemoveArgsW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveBackslashA(pszpath: ::windows::core::PSTR) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveBackslashA(pszpath: ::windows::core::PSTR) -> ::windows::core::PSTR;
    }
    PathRemoveBackslashA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveBackslashW(pszpath: ::windows::core::PWSTR) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveBackslashW(pszpath: ::windows::core::PWSTR) -> ::windows::core::PWSTR;
    }
    PathRemoveBackslashW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveBlanksA(pszpath: ::windows::core::PSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveBlanksA(pszpath: ::windows::core::PSTR);
    }
    PathRemoveBlanksA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveBlanksW(pszpath: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveBlanksW(pszpath: ::windows::core::PWSTR);
    }
    PathRemoveBlanksW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveExtensionA(pszpath: ::windows::core::PSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveExtensionA(pszpath: ::windows::core::PSTR);
    }
    PathRemoveExtensionA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathRemoveExtensionW(pszpath: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveExtensionW(pszpath: ::windows::core::PWSTR);
    }
    PathRemoveExtensionW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRemoveFileSpecA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveFileSpecA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    PathRemoveFileSpecA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRemoveFileSpecW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRemoveFileSpecW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathRemoveFileSpecW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRenameExtensionA<'a, P0>(pszpath: &mut [u8; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRenameExtensionA(pszpath: ::windows::core::PSTR, pszext: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathRenameExtensionA(::core::mem::transmute(pszpath.as_ptr()), pszext.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathRenameExtensionW<'a, P0>(pszpath: &mut [u16; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathRenameExtensionW(pszpath: ::windows::core::PWSTR, pszext: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathRenameExtensionW(::core::mem::transmute(pszpath.as_ptr()), pszext.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathResolve(pszpath: &mut [u16; 260], dirs: ::core::option::Option<*const *const u16>, fflags: PRF_FLAGS) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathResolve(pszpath: ::windows::core::PWSTR, dirs: *const *const u16, fflags: PRF_FLAGS) -> i32;
    }
    PathResolve(::core::mem::transmute(pszpath.as_ptr()), ::core::mem::transmute(dirs.unwrap_or(::std::ptr::null())), fflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathSearchAndQualifyA<'a, P0>(pszpath: P0, pszbuf: &mut [u8]) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSearchAndQualifyA(pszpath: ::windows::core::PCSTR, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> super::super::Foundation::BOOL;
    }
    PathSearchAndQualifyA(pszpath.into(), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathSearchAndQualifyW<'a, P0>(pszpath: P0, pszbuf: &mut [u16]) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSearchAndQualifyW(pszpath: ::windows::core::PCWSTR, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> super::super::Foundation::BOOL;
    }
    PathSearchAndQualifyW(pszpath.into(), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathSetDlgItemPathA<'a, P0, P1>(hdlg: P0, id: i32, pszpath: P1)
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSetDlgItemPathA(hdlg: super::super::Foundation::HWND, id: i32, pszpath: ::windows::core::PCSTR);
    }
    PathSetDlgItemPathA(hdlg.into(), id, pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathSetDlgItemPathW<'a, P0, P1>(hdlg: P0, id: i32, pszpath: P1)
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSetDlgItemPathW(hdlg: super::super::Foundation::HWND, id: i32, pszpath: ::windows::core::PCWSTR);
    }
    PathSetDlgItemPathW(hdlg.into(), id, pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathSkipRootA<'a, P0>(pszpath: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSkipRootA(pszpath: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    PathSkipRootA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathSkipRootW<'a, P0>(pszpath: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathSkipRootW(pszpath: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    PathSkipRootW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathStripPathA(pszpath: ::windows::core::PSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathStripPathA(pszpath: ::windows::core::PSTR);
    }
    PathStripPathA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathStripPathW(pszpath: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathStripPathW(pszpath: ::windows::core::PWSTR);
    }
    PathStripPathW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathStripToRootA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathStripToRootA(pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    PathStripToRootA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathStripToRootW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathStripToRootW(pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathStripToRootW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnExpandEnvStringsA<'a, P0>(pszpath: P0, pszbuf: &mut [u8]) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnExpandEnvStringsA(pszpath: ::windows::core::PCSTR, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> super::super::Foundation::BOOL;
    }
    PathUnExpandEnvStringsA(pszpath.into(), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnExpandEnvStringsW<'a, P0>(pszpath: P0, pszbuf: &mut [u16]) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnExpandEnvStringsW(pszpath: ::windows::core::PCWSTR, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> super::super::Foundation::BOOL;
    }
    PathUnExpandEnvStringsW(pszpath.into(), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathUndecorateA(pszpath: ::windows::core::PSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUndecorateA(pszpath: ::windows::core::PSTR);
    }
    PathUndecorateA(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn PathUndecorateW(pszpath: ::windows::core::PWSTR) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUndecorateW(pszpath: ::windows::core::PWSTR);
    }
    PathUndecorateW(::core::mem::transmute(pszpath))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnmakeSystemFolderA<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnmakeSystemFolderA(pszpath: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    PathUnmakeSystemFolderA(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnmakeSystemFolderW<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnmakeSystemFolderW(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathUnmakeSystemFolderW(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnquoteSpacesA(lpsz: ::windows::core::PSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnquoteSpacesA(lpsz: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    PathUnquoteSpacesA(::core::mem::transmute(lpsz))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathUnquoteSpacesW(lpsz: ::windows::core::PWSTR) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathUnquoteSpacesW(lpsz: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    PathUnquoteSpacesW(::core::mem::transmute(lpsz))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PathYetAnotherMakeUniqueName<'a, P0, P1, P2>(pszuniquename: &mut [u16; 260], pszpath: P0, pszshort: P1, pszfilespec: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PathYetAnotherMakeUniqueName(pszuniquename: ::windows::core::PWSTR, pszpath: ::windows::core::PCWSTR, pszshort: ::windows::core::PCWSTR, pszfilespec: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    PathYetAnotherMakeUniqueName(::core::mem::transmute(pszuniquename.as_ptr()), pszpath.into(), pszshort.into(), pszfilespec.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PickIconDlg<'a, P0>(hwnd: P0, psziconpath: &mut [u16], piiconindex: ::core::option::Option<*mut i32>) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn PickIconDlg(hwnd: super::super::Foundation::HWND, psziconpath: ::windows::core::PWSTR, cchiconpath: u32, piiconindex: *mut i32) -> i32;
    }
    PickIconDlg(hwnd.into(), ::core::mem::transmute(psziconpath.as_ptr()), psziconpath.len() as _, ::core::mem::transmute(piiconindex.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn QISearch<T>(that: *mut ::core::ffi::c_void, pqit: *const QITAB) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn QISearch(that: *mut ::core::ffi::c_void, pqit: *const QITAB, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    QISearch(::core::mem::transmute(that), ::core::mem::transmute(pqit), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ReadCabinetState(pcs: *mut CABINETSTATE, clength: i32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ReadCabinetState(pcs: *mut CABINETSTATE, clength: i32) -> super::super::Foundation::BOOL;
    }
    ReadCabinetState(::core::mem::transmute(pcs), clength)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RealDriveType<'a, P0>(idrive: i32, foktohitnet: P0) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RealDriveType(idrive: i32, foktohitnet: super::super::Foundation::BOOL) -> i32;
    }
    RealDriveType(idrive, foktohitnet.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RegisterAppConstrainedChangeNotification(routine: PAPPCONSTRAIN_CHANGE_ROUTINE, context: ::core::option::Option<*const ::core::ffi::c_void>, registration: *mut *mut _APPCONSTRAIN_REGISTRATION) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RegisterAppConstrainedChangeNotification(routine: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, registration: *mut *mut _APPCONSTRAIN_REGISTRATION) -> u32;
    }
    RegisterAppConstrainedChangeNotification(::core::mem::transmute(routine), ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(registration))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RegisterAppStateChangeNotification(routine: PAPPSTATE_CHANGE_ROUTINE, context: ::core::option::Option<*const ::core::ffi::c_void>, registration: *mut *mut _APPSTATE_REGISTRATION) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RegisterAppStateChangeNotification(routine: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, registration: *mut *mut _APPSTATE_REGISTRATION) -> u32;
    }
    RegisterAppStateChangeNotification(::core::mem::transmute(routine), ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(registration))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RegisterScaleChangeEvent<'a, P0>(hevent: P0) -> ::windows::core::Result<usize>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RegisterScaleChangeEvent(hevent: super::super::Foundation::HANDLE, pdwcookie: *mut usize) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    RegisterScaleChangeEvent(hevent.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<usize>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RegisterScaleChangeNotifications<'a, P0>(displaydevice: DISPLAY_DEVICE_TYPE, hwndnotify: P0, umsgnotify: u32) -> ::windows::core::Result<u32>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RegisterScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, hwndnotify: super::super::Foundation::HWND, umsgnotify: u32, pdwcookie: *mut u32) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    RegisterScaleChangeNotifications(displaydevice, hwndnotify.into(), umsgnotify, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RemoveWindowSubclass<'a, P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RemoveWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: *mut ::core::ffi::c_void, uidsubclass: usize) -> super::super::Foundation::BOOL;
    }
    RemoveWindowSubclass(hwnd.into(), ::core::mem::transmute(pfnsubclass), uidsubclass)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RestartDialog<'a, P0, P1>(hwnd: P0, pszprompt: P1, dwreturn: u32) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RestartDialog(hwnd: super::super::Foundation::HWND, pszprompt: ::windows::core::PCWSTR, dwreturn: u32) -> i32;
    }
    RestartDialog(hwnd.into(), pszprompt.into(), dwreturn)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RestartDialogEx<'a, P0, P1>(hwnd: P0, pszprompt: P1, dwreturn: u32, dwreasoncode: u32) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RestartDialogEx(hwnd: super::super::Foundation::HWND, pszprompt: ::windows::core::PCWSTR, dwreturn: u32, dwreasoncode: u32) -> i32;
    }
    RestartDialogEx(hwnd.into(), pszprompt.into(), dwreturn, dwreasoncode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn RevokeScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, dwcookie: u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn RevokeScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, dwcookie: u32) -> ::windows::core::HRESULT;
    }
    RevokeScaleChangeNotifications(displaydevice, dwcookie).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn SHAddFromPropSheetExtArray<'a, P0, P1>(hpsxa: P0, lpfnaddpage: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: P1) -> u32
where
    P0: ::std::convert::Into<HPSXA>,
    P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAddFromPropSheetExtArray(hpsxa: HPSXA, lpfnaddpage: *mut ::core::ffi::c_void, lparam: super::super::Foundation::LPARAM) -> u32;
    }
    SHAddFromPropSheetExtArray(hpsxa.into(), ::core::mem::transmute(lpfnaddpage), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAddToRecentDocs(uflags: u32, pv: ::core::option::Option<*const ::core::ffi::c_void>) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAddToRecentDocs(uflags: u32, pv: *const ::core::ffi::c_void);
    }
    SHAddToRecentDocs(uflags, ::core::mem::transmute(pv.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAlloc(cb: usize) -> *mut ::core::ffi::c_void {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAlloc(cb: usize) -> *mut ::core::ffi::c_void;
    }
    SHAlloc(cb)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHAllocShared(pvdata: ::core::option::Option<*const ::core::ffi::c_void>, dwsize: u32, dwprocessid: u32) -> super::super::Foundation::HANDLE {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAllocShared(pvdata: *const ::core::ffi::c_void, dwsize: u32, dwprocessid: u32) -> super::super::Foundation::HANDLE;
    }
    SHAllocShared(::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())), dwsize, dwprocessid)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAnsiToAnsi<'a, P0>(pszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAnsiToAnsi(pszsrc: ::windows::core::PCSTR, pszdst: ::windows::core::PSTR, cchbuf: i32) -> i32;
    }
    SHAnsiToAnsi(pszsrc.into(), ::core::mem::transmute(pszdst.as_ptr()), pszdst.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAnsiToUnicode<'a, P0>(pszsrc: P0, pwszdst: &mut [u16]) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAnsiToUnicode(pszsrc: ::windows::core::PCSTR, pwszdst: ::windows::core::PWSTR, cwchbuf: i32) -> i32;
    }
    SHAnsiToUnicode(pszsrc.into(), ::core::mem::transmute(pwszdst.as_ptr()), pwszdst.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHAppBarMessage(dwmessage: u32, pdata: *mut APPBARDATA) -> usize {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAppBarMessage(dwmessage: u32, pdata: *mut APPBARDATA) -> usize;
    }
    SHAppBarMessage(dwmessage, ::core::mem::transmute(pdata))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAssocEnumHandlers<'a, P0>(pszextra: P0, affilter: ASSOC_FILTER) -> ::windows::core::Result<IEnumAssocHandlers>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAssocEnumHandlers(pszextra: ::windows::core::PCWSTR, affilter: ASSOC_FILTER, ppenumhandler: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHAssocEnumHandlers(pszextra.into(), affilter, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumAssocHandlers>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHAssocEnumHandlersForProtocolByApplication<'a, P0, T>(protocol: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAssocEnumHandlersForProtocolByApplication(protocol: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, enumhandlers: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHAssocEnumHandlersForProtocolByApplication(protocol.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHAutoComplete<'a, P0>(hwndedit: P0, dwflags: SHELL_AUTOCOMPLETE_FLAGS) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHAutoComplete(hwndedit: super::super::Foundation::HWND, dwflags: SHELL_AUTOCOMPLETE_FLAGS) -> ::windows::core::HRESULT;
    }
    SHAutoComplete(hwndedit.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToFolderIDListParent<'a, P0, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppidllast: ::core::option::Option<*mut *mut Common::ITEMIDLIST>) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBindToFolderIDListParent(psfroot: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, ppidllast: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHBindToFolderIDListParent(psfroot.into().abi(), ::core::mem::transmute(pidl), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _, ::core::mem::transmute(ppidllast.unwrap_or(::std::ptr::null_mut()))).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToFolderIDListParentEx<'a, P0, P1, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppbc: P1, ppidllast: ::core::option::Option<*mut *mut Common::ITEMIDLIST>) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBindToFolderIDListParentEx(psfroot: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, ppbc: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, ppidllast: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHBindToFolderIDListParentEx(psfroot.into().abi(), ::core::mem::transmute(pidl), ppbc.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _, ::core::mem::transmute(ppidllast.unwrap_or(::std::ptr::null_mut()))).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToObject<'a, P0, P1, T>(psf: P0, pidl: *const Common::ITEMIDLIST, pbc: P1) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBindToObject(psf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pbc: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHBindToObject(psf.into().abi(), ::core::mem::transmute(pidl), pbc.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToParent<T>(pidl: *const Common::ITEMIDLIST, ppidllast: ::core::option::Option<*mut *mut Common::ITEMIDLIST>) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBindToParent(pidl: *const Common::ITEMIDLIST, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, ppidllast: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHBindToParent(::core::mem::transmute(pidl), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _, ::core::mem::transmute(ppidllast.unwrap_or(::std::ptr::null_mut()))).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBrowseForFolderA(lpbi: *const BROWSEINFOA) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBrowseForFolderA(lpbi: *const BROWSEINFOA) -> *mut Common::ITEMIDLIST;
    }
    SHBrowseForFolderA(::core::mem::transmute(lpbi))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBrowseForFolderW(lpbi: *const BROWSEINFOW) -> *mut Common::ITEMIDLIST {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHBrowseForFolderW(lpbi: *const BROWSEINFOW) -> *mut Common::ITEMIDLIST;
    }
    SHBrowseForFolderW(::core::mem::transmute(lpbi))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCLSIDFromString<'a, P0>(psz: P0) -> ::windows::core::Result<::windows::core::GUID>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCLSIDFromString(psz: ::windows::core::PCWSTR, pclsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCLSIDFromString(psz.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHChangeNotification_Lock<'a, P0>(hchange: P0, dwprocid: u32, pppidl: ::core::option::Option<*mut *mut *mut Common::ITEMIDLIST>, plevent: ::core::option::Option<*mut i32>) -> ShFindChangeNotificationHandle
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotification_Lock(hchange: super::super::Foundation::HANDLE, dwprocid: u32, pppidl: *mut *mut *mut Common::ITEMIDLIST, plevent: *mut i32) -> ShFindChangeNotificationHandle;
    }
    SHChangeNotification_Lock(hchange.into(), dwprocid, ::core::mem::transmute(pppidl.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plevent.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHChangeNotification_Unlock<'a, P0>(hlock: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotification_Unlock(hlock: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
    }
    SHChangeNotification_Unlock(hlock.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHChangeNotify(weventid: SHCNE_ID, uflags: SHCNF_FLAGS, dwitem1: ::core::option::Option<*const ::core::ffi::c_void>, dwitem2: ::core::option::Option<*const ::core::ffi::c_void>) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotify(weventid: SHCNE_ID, uflags: SHCNF_FLAGS, dwitem1: *const ::core::ffi::c_void, dwitem2: *const ::core::ffi::c_void);
    }
    SHChangeNotify(weventid, uflags, ::core::mem::transmute(dwitem1.unwrap_or(::std::ptr::null())), ::core::mem::transmute(dwitem2.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHChangeNotifyDeregister(ulid: u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotifyDeregister(ulid: u32) -> super::super::Foundation::BOOL;
    }
    SHChangeNotifyDeregister(ulid)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHChangeNotifyRegister<'a, P0>(hwnd: P0, fsources: SHCNRF_SOURCE, fevents: i32, wmsg: u32, centries: i32, pshcne: *const SHChangeNotifyEntry) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotifyRegister(hwnd: super::super::Foundation::HWND, fsources: SHCNRF_SOURCE, fevents: i32, wmsg: u32, centries: i32, pshcne: *const SHChangeNotifyEntry) -> u32;
    }
    SHChangeNotifyRegister(hwnd.into(), fsources, fevents, wmsg, centries, ::core::mem::transmute(pshcne))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHChangeNotifyRegisterThread(status: SCNRT_STATUS) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHChangeNotifyRegisterThread(status: SCNRT_STATUS);
    }
    SHChangeNotifyRegisterThread(status)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCloneSpecialIDList<'a, P0, P1>(hwnd: P0, csidl: i32, fcreate: P1) -> *mut Common::ITEMIDLIST
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCloneSpecialIDList(hwnd: super::super::Foundation::HWND, csidl: i32, fcreate: super::super::Foundation::BOOL) -> *mut Common::ITEMIDLIST;
    }
    SHCloneSpecialIDList(hwnd.into(), csidl, fcreate.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCoCreateInstance<'a, P0, P1, T>(pszclsid: P0, pclsid: ::core::option::Option<*const ::windows::core::GUID>, punkouter: P1) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCoCreateInstance(pszclsid: ::windows::core::PCWSTR, pclsid: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCoCreateInstance(pszclsid.into(), ::core::mem::transmute(pclsid.unwrap_or(::std::ptr::null())), punkouter.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHCopyKeyA<'a, P0, P1, P2>(hkeysrc: P0, pszsrcsubkey: P1, hkeydest: P2, freserved: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCopyKeyA(hkeysrc: super::super::System::Registry::HKEY, pszsrcsubkey: ::windows::core::PCSTR, hkeydest: super::super::System::Registry::HKEY, freserved: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHCopyKeyA(hkeysrc.into(), pszsrcsubkey.into(), hkeydest.into(), freserved)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHCopyKeyW<'a, P0, P1, P2>(hkeysrc: P0, pszsrcsubkey: P1, hkeydest: P2, freserved: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCopyKeyW(hkeysrc: super::super::System::Registry::HKEY, pszsrcsubkey: ::windows::core::PCWSTR, hkeydest: super::super::System::Registry::HKEY, freserved: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHCopyKeyW(hkeysrc.into(), pszsrcsubkey.into(), hkeydest.into(), freserved)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateAssociationRegistration<T>() -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateAssociationRegistration(riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateAssociationRegistration(&<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDataObject<'a, P0, T>(pidlfolder: ::core::option::Option<*const Common::ITEMIDLIST>, apidl: ::core::option::Option<&[*const Common::ITEMIDLIST]>, pdtinner: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDataObject(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST, pdtinner: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateDataObject(::core::mem::transmute(pidlfolder.unwrap_or(::std::ptr::null())), apidl.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(apidl.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pdtinner.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDefaultContextMenu<T>(pdcm: *const DEFCONTEXTMENU) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDefaultContextMenu(pdcm: *const ::core::mem::ManuallyDrop<DEFCONTEXTMENU>, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateDefaultContextMenu(::core::mem::transmute(pdcm), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateDefaultExtractIcon<T>() -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDefaultExtractIcon(riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateDefaultExtractIcon(&<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateDefaultPropertiesOp<'a, P0>(psi: P0) -> ::windows::core::Result<IFileOperation>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDefaultPropertiesOp(psi: *mut ::core::ffi::c_void, ppfileop: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateDefaultPropertiesOp(psi.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IFileOperation>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHCreateDirectory<'a, P0, P1>(hwnd: P0, pszpath: P1) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDirectory(hwnd: super::super::Foundation::HWND, pszpath: ::windows::core::PCWSTR) -> i32;
    }
    SHCreateDirectory(hwnd.into(), pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SHCreateDirectoryExA<'a, P0, P1>(hwnd: P0, pszpath: P1, psa: ::core::option::Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDirectoryExA(hwnd: super::super::Foundation::HWND, pszpath: ::windows::core::PCSTR, psa: *const super::super::Security::SECURITY_ATTRIBUTES) -> i32;
    }
    SHCreateDirectoryExA(hwnd.into(), pszpath.into(), ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SHCreateDirectoryExW<'a, P0, P1>(hwnd: P0, pszpath: P1, psa: ::core::option::Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateDirectoryExW(hwnd: super::super::Foundation::HWND, pszpath: ::windows::core::PCWSTR, psa: *const super::super::Security::SECURITY_ATTRIBUTES) -> i32;
    }
    SHCreateDirectoryExW(hwnd.into(), pszpath.into(), ::core::mem::transmute(psa.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateFileExtractIconW<'a, P0, T>(pszfile: P0, dwfileattributes: u32) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateFileExtractIconW(pszfile: ::windows::core::PCWSTR, dwfileattributes: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateFileExtractIconW(pszfile.into(), dwfileattributes, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemFromIDList<T>(pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateItemFromIDList(pidl: *const Common::ITEMIDLIST, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateItemFromIDList(::core::mem::transmute(pidl), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromParsingName<'a, P0, P1, T>(pszpath: P0, pbc: P1) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateItemFromParsingName(pszpath: ::windows::core::PCWSTR, pbc: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateItemFromParsingName(pszpath.into(), pbc.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromRelativeName<'a, P0, P1, P2, T>(psiparent: P0, pszname: P1, pbc: P2) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateItemFromRelativeName(psiparent: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pbc: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateItemFromRelativeName(psiparent.into().abi(), pszname.into(), pbc.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateItemInKnownFolder<'a, P0, T>(kfid: *const ::windows::core::GUID, dwkfflags: u32, pszitem: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateItemInKnownFolder(kfid: *const ::windows::core::GUID, dwkfflags: u32, pszitem: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateItemInKnownFolder(::core::mem::transmute(kfid), dwkfflags, pszitem.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemWithParent<'a, P0, T>(pidlparent: ::core::option::Option<*const Common::ITEMIDLIST>, psfparent: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateItemWithParent(pidlparent: *const Common::ITEMIDLIST, psfparent: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, riid: *const ::windows::core::GUID, ppvitem: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateItemWithParent(::core::mem::transmute(pidlparent.unwrap_or(::std::ptr::null())), psfparent.into().abi(), ::core::mem::transmute(pidl), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateMemStream(pinit: ::core::option::Option<&[u8]>) -> ::core::option::Option<super::super::System::Com::IStream> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateMemStream(pinit: *const u8, cbinit: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    SHCreateMemStream(::core::mem::transmute(pinit.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pinit.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`, `\"Win32_System_Threading\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn SHCreateProcessAsUserW(pscpi: *mut SHCREATEPROCESSINFOW) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateProcessAsUserW(pscpi: *mut SHCREATEPROCESSINFOW) -> super::super::Foundation::BOOL;
    }
    SHCreateProcessAsUserW(::core::mem::transmute(pscpi))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCreatePropSheetExtArray<'a, P0, P1>(hkey: P0, pszsubkey: P1, max_iface: u32) -> HPSXA
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreatePropSheetExtArray(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, max_iface: u32) -> HPSXA;
    }
    SHCreatePropSheetExtArray(hkey.into(), pszsubkey.into(), max_iface)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateQueryCancelAutoPlayMoniker() -> ::windows::core::Result<super::super::System::Com::IMoniker> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateQueryCancelAutoPlayMoniker(ppmoniker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateQueryCancelAutoPlayMoniker(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IMoniker>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[inline]
pub unsafe fn SHCreateShellFolderView(pcsfv: *const SFV_CREATE) -> ::windows::core::Result<IShellView> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellFolderView(pcsfv: *const ::core::mem::ManuallyDrop<SFV_CREATE>, ppsv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateShellFolderView(::core::mem::transmute(pcsfv), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellView>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateShellFolderViewEx(pcsfv: *const CSFV) -> ::windows::core::Result<IShellView> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellFolderViewEx(pcsfv: *const ::core::mem::ManuallyDrop<CSFV>, ppsv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateShellFolderViewEx(::core::mem::transmute(pcsfv), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellView>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItem<'a, P0>(pidlparent: ::core::option::Option<*const Common::ITEMIDLIST>, psfparent: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<IShellItem>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellItem(pidlparent: *const Common::ITEMIDLIST, psfparent: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, ppsi: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateShellItem(::core::mem::transmute(pidlparent.unwrap_or(::std::ptr::null())), psfparent.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItem>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArray<'a, P0>(pidlparent: ::core::option::Option<*const Common::ITEMIDLIST>, psf: P0, ppidl: ::core::option::Option<&[*const Common::ITEMIDLIST]>) -> ::windows::core::Result<IShellItemArray>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellItemArray(pidlparent: *const Common::ITEMIDLIST, psf: *mut ::core::ffi::c_void, cidl: u32, ppidl: *const *const Common::ITEMIDLIST, ppsiitemarray: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateShellItemArray(::core::mem::transmute(pidlparent.unwrap_or(::std::ptr::null())), psf.into().abi(), ppidl.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(ppidl.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItemArray>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromDataObject<'a, P0, T>(pdo: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellItemArrayFromDataObject(pdo: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateShellItemArrayFromDataObject(pdo.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromIDLists(rgpidl: &[*const Common::ITEMIDLIST]) -> ::windows::core::Result<IShellItemArray> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellItemArrayFromIDLists(cidl: u32, rgpidl: *const *const Common::ITEMIDLIST, ppsiitemarray: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateShellItemArrayFromIDLists(rgpidl.len() as _, ::core::mem::transmute(rgpidl.as_ptr()), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItemArray>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromShellItem<'a, P0, T>(psi: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellItemArrayFromShellItem(psi: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHCreateShellItemArrayFromShellItem(psi.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Graphics_Gdi\"`*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn SHCreateShellPalette<'a, P0>(hdc: P0) -> super::super::Graphics::Gdi::HPALETTE
where
    P0: ::std::convert::Into<super::super::Graphics::Gdi::HDC>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateShellPalette(hdc: super::super::Graphics::Gdi::HDC) -> super::super::Graphics::Gdi::HPALETTE;
    }
    SHCreateShellPalette(hdc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStdEnumFmtEtc(afmt: &[super::super::System::Com::FORMATETC]) -> ::windows::core::Result<super::super::System::Com::IEnumFORMATETC> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateStdEnumFmtEtc(cfmt: u32, afmt: *const super::super::System::Com::FORMATETC, ppenumformatetc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateStdEnumFmtEtc(afmt.len() as _, ::core::mem::transmute(afmt.as_ptr()), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IEnumFORMATETC>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileA<'a, P0>(pszfile: P0, grfmode: u32) -> ::windows::core::Result<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateStreamOnFileA(pszfile: ::windows::core::PCSTR, grfmode: u32, ppstm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateStreamOnFileA(pszfile.into(), grfmode, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IStream>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn SHCreateStreamOnFileEx<'a, P0, P1, P2>(pszfile: P0, grfmode: u32, dwattributes: u32, fcreate: P1, pstmtemplate: P2) -> ::windows::core::Result<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateStreamOnFileEx(pszfile: ::windows::core::PCWSTR, grfmode: u32, dwattributes: u32, fcreate: super::super::Foundation::BOOL, pstmtemplate: *mut ::core::ffi::c_void, ppstm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateStreamOnFileEx(pszfile.into(), grfmode, dwattributes, fcreate.into(), pstmtemplate.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IStream>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileW<'a, P0>(pszfile: P0, grfmode: u32) -> ::windows::core::Result<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateStreamOnFileW(pszfile: ::windows::core::PCWSTR, grfmode: u32, ppstm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHCreateStreamOnFileW(pszfile.into(), grfmode, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IStream>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Threading\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn SHCreateThread(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: ::core::option::Option<*const ::core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateThread(pfnthreadproc: *mut ::core::ffi::c_void, pdata: *const ::core::ffi::c_void, flags: u32, pfncallback: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    SHCreateThread(::core::mem::transmute(pfnthreadproc), ::core::mem::transmute(pdata.unwrap_or(::std::ptr::null())), flags, ::core::mem::transmute(pfncallback))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHCreateThreadRef(pcref: *mut i32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateThreadRef(pcref: *mut i32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHCreateThreadRef(::core::mem::transmute(pcref), ::core::mem::transmute(ppunk)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Threading\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn SHCreateThreadWithHandle(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: ::core::option::Option<*const ::core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE, phandle: ::core::option::Option<*mut super::super::Foundation::HANDLE>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHCreateThreadWithHandle(pfnthreadproc: *mut ::core::ffi::c_void, pdata: *const ::core::ffi::c_void, flags: u32, pfncallback: *mut ::core::ffi::c_void, phandle: *mut super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
    }
    SHCreateThreadWithHandle(::core::mem::transmute(pfnthreadproc), ::core::mem::transmute(pdata.unwrap_or(::std::ptr::null())), flags, ::core::mem::transmute(pfncallback), ::core::mem::transmute(phandle.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconA<'a, P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDefExtractIconA(psziconfile: ::windows::core::PCSTR, iindex: i32, uflags: u32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, niconsize: u32) -> ::windows::core::HRESULT;
    }
    SHDefExtractIconA(psziconfile.into(), iindex, uflags, ::core::mem::transmute(phiconlarge.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phiconsmall.unwrap_or(::std::ptr::null_mut())), niconsize).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconW<'a, P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: ::core::option::Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDefExtractIconW(psziconfile: ::windows::core::PCWSTR, iindex: i32, uflags: u32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, niconsize: u32) -> ::windows::core::HRESULT;
    }
    SHDefExtractIconW(psziconfile.into(), iindex, uflags, ::core::mem::transmute(phiconlarge.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phiconsmall.unwrap_or(::std::ptr::null_mut())), niconsize).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteEmptyKeyA<'a, P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteEmptyKeyA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteEmptyKeyA(hkey.into(), pszsubkey.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteEmptyKeyW<'a, P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteEmptyKeyW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteEmptyKeyW(hkey.into(), pszsubkey.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteKeyA<'a, P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteKeyA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteKeyA(hkey.into(), pszsubkey.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteKeyW<'a, P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteKeyW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteKeyW(hkey.into(), pszsubkey.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteValueA<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteValueA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteValueA(hkey.into(), pszsubkey.into(), pszvalue.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHDeleteValueW<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDeleteValueW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR) -> super::super::Foundation::WIN32_ERROR;
    }
    SHDeleteValueW(hkey.into(), pszsubkey.into(), pszvalue.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHDestroyPropSheetExtArray<'a, P0>(hpsxa: P0)
where
    P0: ::std::convert::Into<HPSXA>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDestroyPropSheetExtArray(hpsxa: HPSXA);
    }
    SHDestroyPropSheetExtArray(hpsxa.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
#[inline]
pub unsafe fn SHDoDragDrop<'a, P0, P1, P2>(hwnd: P0, pdata: P1, pdsrc: P2, dweffect: super::super::System::Ole::DROPEFFECT) -> ::windows::core::Result<super::super::System::Ole::DROPEFFECT>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IDropSource>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHDoDragDrop(hwnd: super::super::Foundation::HWND, pdata: *mut ::core::ffi::c_void, pdsrc: *mut ::core::ffi::c_void, dweffect: super::super::System::Ole::DROPEFFECT, pdweffect: *mut super::super::System::Ole::DROPEFFECT) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHDoDragDrop(hwnd.into(), pdata.into().abi(), pdsrc.into().abi(), dweffect, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::DROPEFFECT>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHEmptyRecycleBinA<'a, P0, P1>(hwnd: P0, pszrootpath: P1, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEmptyRecycleBinA(hwnd: super::super::Foundation::HWND, pszrootpath: ::windows::core::PCSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHEmptyRecycleBinA(hwnd.into(), pszrootpath.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHEmptyRecycleBinW<'a, P0, P1>(hwnd: P0, pszrootpath: P1, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEmptyRecycleBinW(hwnd: super::super::Foundation::HWND, pszrootpath: ::windows::core::PCWSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHEmptyRecycleBinW(hwnd.into(), pszrootpath.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHEnumKeyExA<'a, P0>(hkey: P0, dwindex: u32, pszname: ::windows::core::PSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEnumKeyExA(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszname: ::windows::core::PSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHEnumKeyExA(hkey.into(), dwindex, ::core::mem::transmute(pszname), ::core::mem::transmute(pcchname))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHEnumKeyExW<'a, P0>(hkey: P0, dwindex: u32, pszname: ::windows::core::PWSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEnumKeyExW(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszname: ::windows::core::PWSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHEnumKeyExW(hkey.into(), dwindex, ::core::mem::transmute(pszname), ::core::mem::transmute(pcchname))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHEnumValueA<'a, P0>(hkey: P0, dwindex: u32, pszvaluename: ::windows::core::PSTR, pcchvaluename: ::core::option::Option<*mut u32>, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEnumValueA(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszvaluename: ::windows::core::PSTR, pcchvaluename: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHEnumValueA(hkey.into(), dwindex, ::core::mem::transmute(pszvaluename), ::core::mem::transmute(pcchvaluename.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHEnumValueW<'a, P0>(hkey: P0, dwindex: u32, pszvaluename: ::windows::core::PWSTR, pcchvaluename: ::core::option::Option<*mut u32>, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEnumValueW(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszvaluename: ::windows::core::PWSTR, pcchvaluename: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHEnumValueW(hkey.into(), dwindex, ::core::mem::transmute(pszvaluename), ::core::mem::transmute(pcchvaluename.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumerateUnreadMailAccountsW<'a, P0>(hkeyuser: P0, dwindex: u32, pszmailaddress: &mut [u16]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEnumerateUnreadMailAccountsW(hkeyuser: super::super::System::Registry::HKEY, dwindex: u32, pszmailaddress: ::windows::core::PWSTR, cchmailaddress: i32) -> ::windows::core::HRESULT;
    }
    SHEnumerateUnreadMailAccountsW(hkeyuser.into(), dwindex, ::core::mem::transmute(pszmailaddress.as_ptr()), pszmailaddress.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHEvaluateSystemCommandTemplate<'a, P0>(pszcmdtemplate: P0, ppszapplication: *mut ::windows::core::PWSTR, ppszcommandline: ::core::option::Option<*mut ::windows::core::PWSTR>, ppszparameters: ::core::option::Option<*mut ::windows::core::PWSTR>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHEvaluateSystemCommandTemplate(pszcmdtemplate: ::windows::core::PCWSTR, ppszapplication: *mut ::windows::core::PWSTR, ppszcommandline: *mut ::windows::core::PWSTR, ppszparameters: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    SHEvaluateSystemCommandTemplate(pszcmdtemplate.into(), ::core::mem::transmute(ppszapplication), ::core::mem::transmute(ppszcommandline.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppszparameters.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFileOperationA(lpfileop: *mut SHFILEOPSTRUCTA) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFileOperationA(lpfileop: *mut SHFILEOPSTRUCTA) -> i32;
    }
    SHFileOperationA(::core::mem::transmute(lpfileop))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFileOperationW(lpfileop: *mut SHFILEOPSTRUCTW) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFileOperationW(lpfileop: *mut SHFILEOPSTRUCTW) -> i32;
    }
    SHFileOperationW(::core::mem::transmute(lpfileop))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHFindFiles(pidlfolder: ::core::option::Option<*const Common::ITEMIDLIST>, pidlsavefile: ::core::option::Option<*const Common::ITEMIDLIST>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFindFiles(pidlfolder: *const Common::ITEMIDLIST, pidlsavefile: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL;
    }
    SHFindFiles(::core::mem::transmute(pidlfolder.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pidlsavefile.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHFind_InitMenuPopup<'a, P0, P1>(hmenu: P0, hwndowner: P1, idcmdfirst: u32, idcmdlast: u32) -> ::core::option::Option<IContextMenu>
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFind_InitMenuPopup(hmenu: super::WindowsAndMessaging::HMENU, hwndowner: super::super::Foundation::HWND, idcmdfirst: u32, idcmdlast: u32) -> ::core::option::Option<IContextMenu>;
    }
    SHFind_InitMenuPopup(hmenu.into(), hwndowner.into(), idcmdfirst, idcmdlast)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHFlushSFCache() {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFlushSFCache();
    }
    SHFlushSFCache()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFormatDateTimeA(pft: *const super::super::Foundation::FILETIME, pdwflags: ::core::option::Option<*mut u32>, pszbuf: &mut [u8]) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFormatDateTimeA(pft: *const super::super::Foundation::FILETIME, pdwflags: *mut u32, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> i32;
    }
    SHFormatDateTimeA(::core::mem::transmute(pft), ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFormatDateTimeW(pft: *const super::super::Foundation::FILETIME, pdwflags: ::core::option::Option<*mut u32>, pszbuf: &mut [u16]) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFormatDateTimeW(pft: *const super::super::Foundation::FILETIME, pdwflags: *mut u32, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> i32;
    }
    SHFormatDateTimeW(::core::mem::transmute(pft), ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFormatDrive<'a, P0>(hwnd: P0, drive: u32, fmtid: SHFMT_ID, options: SHFMT_OPT) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFormatDrive(hwnd: super::super::Foundation::HWND, drive: u32, fmtid: SHFMT_ID, options: SHFMT_OPT) -> u32;
    }
    SHFormatDrive(hwnd.into(), drive, fmtid, options)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHFree(pv: ::core::option::Option<*const ::core::ffi::c_void>) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFree(pv: *const ::core::ffi::c_void);
    }
    SHFree(::core::mem::transmute(pv.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFreeNameMappings<'a, P0>(hnamemappings: P0)
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFreeNameMappings(hnamemappings: super::super::Foundation::HANDLE);
    }
    SHFreeNameMappings(hnamemappings.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHFreeShared<'a, P0>(hdata: P0, dwprocessid: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHFreeShared(hdata: super::super::Foundation::HANDLE, dwprocessid: u32) -> super::super::Foundation::BOOL;
    }
    SHFreeShared(hdata.into(), dwprocessid)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetAttributesFromDataObject<'a, P0>(pdo: P0, dwattributemask: u32, pdwattributes: ::core::option::Option<*mut u32>, pcitems: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetAttributesFromDataObject(pdo: *mut ::core::ffi::c_void, dwattributemask: u32, pdwattributes: *mut u32, pcitems: *mut u32) -> ::windows::core::HRESULT;
    }
    SHGetAttributesFromDataObject(pdo.into().abi(), dwattributemask, ::core::mem::transmute(pdwattributes.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcitems.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListA<'a, P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut ::core::ffi::c_void, cb: i32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDataFromIDListA(psf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut ::core::ffi::c_void, cb: i32) -> ::windows::core::HRESULT;
    }
    SHGetDataFromIDListA(psf.into().abi(), ::core::mem::transmute(pidl), nformat, ::core::mem::transmute(pv), cb).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListW<'a, P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut ::core::ffi::c_void, cb: i32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDataFromIDListW(psf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut ::core::ffi::c_void, cb: i32) -> ::windows::core::HRESULT;
    }
    SHGetDataFromIDListW(psf.into().abi(), ::core::mem::transmute(pidl), nformat, ::core::mem::transmute(pv), cb).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetDesktopFolder() -> ::windows::core::Result<IShellFolder> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDesktopFolder(ppshf: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetDesktopFolder(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellFolder>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExA<'a, P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: ::core::option::Option<*mut u64>, pultotalnumberofbytes: ::core::option::Option<*mut u64>, pultotalnumberoffreebytes: ::core::option::Option<*mut u64>) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDiskFreeSpaceExA(pszdirectoryname: ::windows::core::PCSTR, pulfreebytesavailabletocaller: *mut u64, pultotalnumberofbytes: *mut u64, pultotalnumberoffreebytes: *mut u64) -> super::super::Foundation::BOOL;
    }
    SHGetDiskFreeSpaceExA(pszdirectoryname.into(), ::core::mem::transmute(pulfreebytesavailabletocaller.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pultotalnumberofbytes.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pultotalnumberoffreebytes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExW<'a, P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: ::core::option::Option<*mut u64>, pultotalnumberofbytes: ::core::option::Option<*mut u64>, pultotalnumberoffreebytes: ::core::option::Option<*mut u64>) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDiskFreeSpaceExW(pszdirectoryname: ::windows::core::PCWSTR, pulfreebytesavailabletocaller: *mut u64, pultotalnumberofbytes: *mut u64, pultotalnumberoffreebytes: *mut u64) -> super::super::Foundation::BOOL;
    }
    SHGetDiskFreeSpaceExW(pszdirectoryname.into(), ::core::mem::transmute(pulfreebytesavailabletocaller.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pultotalnumberofbytes.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pultotalnumberoffreebytes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetDriveMedia<'a, P0>(pszdrive: P0) -> ::windows::core::Result<u32>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetDriveMedia(pszdrive: ::windows::core::PCWSTR, pdwmediacontent: *mut u32) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetDriveMedia(pszdrive.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_FileSystem\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoA<'a, P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: ::core::option::Option<*mut SHFILEINFOA>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFileInfoA(pszpath: ::windows::core::PCSTR, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: *mut SHFILEINFOA, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize;
    }
    SHGetFileInfoA(pszpath.into(), dwfileattributes, ::core::mem::transmute(psfi.unwrap_or(::std::ptr::null_mut())), cbfileinfo, uflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Storage_FileSystem\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoW<'a, P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: ::core::option::Option<*mut SHFILEINFOW>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFileInfoW(pszpath: ::windows::core::PCWSTR, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: *mut SHFILEINFOW, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize;
    }
    SHGetFileInfoW(pszpath.into(), dwfileattributes, ::core::mem::transmute(psfi.unwrap_or(::std::ptr::null_mut())), cbfileinfo, uflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetFolderLocation<'a, P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFolderLocation(hwnd: super::super::Foundation::HWND, csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetFolderLocation(hwnd.into(), csidl, htoken.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetFolderPathA<'a, P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszpath: &mut [u8; 260]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFolderPathA(hwnd: super::super::Foundation::HWND, csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszpath: ::windows::core::PSTR) -> ::windows::core::HRESULT;
    }
    SHGetFolderPathA(hwnd.into(), csidl, htoken.into(), dwflags, ::core::mem::transmute(pszpath.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirA<'a, P0, P1, P2>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszsubdir: P2, pszpath: &mut [u8; 260]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFolderPathAndSubDirA(hwnd: super::super::Foundation::HWND, csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszsubdir: ::windows::core::PCSTR, pszpath: ::windows::core::PSTR) -> ::windows::core::HRESULT;
    }
    SHGetFolderPathAndSubDirA(hwnd.into(), csidl, htoken.into(), dwflags, pszsubdir.into(), ::core::mem::transmute(pszpath.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirW<'a, P0, P1, P2>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszsubdir: P2, pszpath: &mut [u16; 260]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFolderPathAndSubDirW(hwnd: super::super::Foundation::HWND, csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszsubdir: ::windows::core::PCWSTR, pszpath: ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    SHGetFolderPathAndSubDirW(hwnd.into(), csidl, htoken.into(), dwflags, pszsubdir.into(), ::core::mem::transmute(pszpath.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetFolderPathW<'a, P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszpath: &mut [u16; 260]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetFolderPathW(hwnd: super::super::Foundation::HWND, csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszpath: ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    SHGetFolderPathW(hwnd.into(), csidl, htoken.into(), dwflags, ::core::mem::transmute(pszpath.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetIDListFromObject<'a, P0>(punk: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetIDListFromObject(punk: *mut ::core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetIDListFromObject(punk.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetIconOverlayIndexA<'a, P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetIconOverlayIndexA(psziconpath: ::windows::core::PCSTR, iiconindex: i32) -> i32;
    }
    SHGetIconOverlayIndexA(psziconpath.into(), iiconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetIconOverlayIndexW<'a, P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetIconOverlayIndexW(psziconpath: ::windows::core::PCWSTR, iiconindex: i32) -> i32;
    }
    SHGetIconOverlayIndexW(psziconpath.into(), iiconindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetImageList<T>(iimagelist: i32) -> ::windows::core::Result<T>
where
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetImageList(iimagelist: i32, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHGetImageList(iimagelist, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetInstanceExplorer() -> ::windows::core::Result<::windows::core::IUnknown> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetInstanceExplorer(ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetInstanceExplorer(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetInverseCMAP(pbmap: &mut [u8]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetInverseCMAP(pbmap: *mut u8, cbmap: u32) -> ::windows::core::HRESULT;
    }
    SHGetInverseCMAP(::core::mem::transmute(pbmap.as_ptr()), pbmap.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetItemFromDataObject<'a, P0, T>(pdtobj: P0, dwflags: DATAOBJ_GET_ITEM_FLAGS) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetItemFromDataObject(pdtobj: *mut ::core::ffi::c_void, dwflags: DATAOBJ_GET_ITEM_FLAGS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHGetItemFromDataObject(pdtobj.into().abi(), dwflags, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetItemFromObject<'a, P0, T>(punk: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetItemFromObject(punk: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHGetItemFromObject(punk.into().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetKnownFolderIDList<'a, P0>(rfid: *const ::windows::core::GUID, dwflags: u32, htoken: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetKnownFolderIDList(rfid: *const ::windows::core::GUID, dwflags: u32, htoken: super::super::Foundation::HANDLE, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetKnownFolderIDList(::core::mem::transmute(rfid), dwflags, htoken.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetKnownFolderItem<'a, P0, T>(rfid: *const ::windows::core::GUID, flags: KNOWN_FOLDER_FLAG, htoken: P0) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetKnownFolderItem(rfid: *const ::windows::core::GUID, flags: KNOWN_FOLDER_FLAG, htoken: super::super::Foundation::HANDLE, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHGetKnownFolderItem(::core::mem::transmute(rfid), flags, htoken.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetKnownFolderPath<'a, P0>(rfid: *const ::windows::core::GUID, dwflags: KNOWN_FOLDER_FLAG, htoken: P0) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetKnownFolderPath(rfid: *const ::windows::core::GUID, dwflags: KNOWN_FOLDER_FLAG, htoken: super::super::Foundation::HANDLE, ppszpath: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetKnownFolderPath(::core::mem::transmute(rfid), dwflags, htoken.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetLocalizedName<'a, P0>(pszpath: P0, pszresmodule: &mut [u16], pidsres: *mut i32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetLocalizedName(pszpath: ::windows::core::PCWSTR, pszresmodule: ::windows::core::PWSTR, cch: u32, pidsres: *mut i32) -> ::windows::core::HRESULT;
    }
    SHGetLocalizedName(pszpath.into(), ::core::mem::transmute(pszresmodule.as_ptr()), pszresmodule.len() as _, ::core::mem::transmute(pidsres)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetMalloc() -> ::windows::core::Result<super::super::System::Com::IMalloc> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetMalloc(ppmalloc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetMalloc(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IMalloc>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetNameFromIDList(pidl: *const Common::ITEMIDLIST, sigdnname: SIGDN) -> ::windows::core::Result<::windows::core::PWSTR> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetNameFromIDList(pidl: *const Common::ITEMIDLIST, sigdnname: SIGDN, ppszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetNameFromIDList(::core::mem::transmute(pidl), sigdnname, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetNewLinkInfoA<'a, P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u8; 260], pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetNewLinkInfoA(pszlinkto: ::windows::core::PCSTR, pszdir: ::windows::core::PCSTR, pszname: ::windows::core::PSTR, pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL;
    }
    SHGetNewLinkInfoA(pszlinkto.into(), pszdir.into(), ::core::mem::transmute(pszname.as_ptr()), ::core::mem::transmute(pfmustcopy), uflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetNewLinkInfoW<'a, P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u16; 260], pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetNewLinkInfoW(pszlinkto: ::windows::core::PCWSTR, pszdir: ::windows::core::PCWSTR, pszname: ::windows::core::PWSTR, pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL;
    }
    SHGetNewLinkInfoW(pszlinkto.into(), pszdir.into(), ::core::mem::transmute(pszname.as_ptr()), ::core::mem::transmute(pfmustcopy), uflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetPathFromIDListA(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u8; 260]) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetPathFromIDListA(pidl: *const Common::ITEMIDLIST, pszpath: ::windows::core::PSTR) -> super::super::Foundation::BOOL;
    }
    SHGetPathFromIDListA(::core::mem::transmute(pidl), ::core::mem::transmute(pszpath.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetPathFromIDListEx(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16], uopts: GPFIDL_FLAGS) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetPathFromIDListEx(pidl: *const Common::ITEMIDLIST, pszpath: ::windows::core::PWSTR, cchpath: u32, uopts: GPFIDL_FLAGS) -> super::super::Foundation::BOOL;
    }
    SHGetPathFromIDListEx(::core::mem::transmute(pidl), ::core::mem::transmute(pszpath.as_ptr()), pszpath.len() as _, uopts)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetPathFromIDListW(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16; 260]) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetPathFromIDListW(pidl: *const Common::ITEMIDLIST, pszpath: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    SHGetPathFromIDListW(::core::mem::transmute(pidl), ::core::mem::transmute(pszpath.as_ptr()))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetRealIDL<'a, P0>(psf: P0, pidlsimple: *const Common::ITEMIDLIST) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetRealIDL(psf: *mut ::core::ffi::c_void, pidlsimple: *const Common::ITEMIDLIST, ppidlreal: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetRealIDL(psf.into().abi(), ::core::mem::transmute(pidlsimple), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetSetFolderCustomSettings<'a, P0>(pfcs: *mut SHFOLDERCUSTOMSETTINGS, pszpath: P0, dwreadwrite: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSetFolderCustomSettings(pfcs: *mut SHFOLDERCUSTOMSETTINGS, pszpath: ::windows::core::PCWSTR, dwreadwrite: u32) -> ::windows::core::HRESULT;
    }
    SHGetSetFolderCustomSettings(::core::mem::transmute(pfcs), pszpath.into(), dwreadwrite).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetSetSettings<'a, P0>(lpss: ::core::option::Option<*mut SHELLSTATEA>, dwmask: SSF_MASK, bset: P0)
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSetSettings(lpss: *mut SHELLSTATEA, dwmask: SSF_MASK, bset: super::super::Foundation::BOOL);
    }
    SHGetSetSettings(::core::mem::transmute(lpss.unwrap_or(::std::ptr::null_mut())), dwmask, bset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetSettings(psfs: *mut SHELLFLAGSTATE, dwmask: u32) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSettings(psfs: *mut SHELLFLAGSTATE, dwmask: u32);
    }
    SHGetSettings(::core::mem::transmute(psfs), dwmask)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHGetSpecialFolderLocation<'a, P0>(hwnd: P0, csidl: i32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSpecialFolderLocation(hwnd: super::super::Foundation::HWND, csidl: i32, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetSpecialFolderLocation(hwnd.into(), csidl, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetSpecialFolderPathA<'a, P0, P1>(hwnd: P0, pszpath: &mut [u8; 260], csidl: i32, fcreate: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSpecialFolderPathA(hwnd: super::super::Foundation::HWND, pszpath: ::windows::core::PSTR, csidl: i32, fcreate: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHGetSpecialFolderPathA(hwnd.into(), ::core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHGetSpecialFolderPathW<'a, P0, P1>(hwnd: P0, pszpath: &mut [u16; 260], csidl: i32, fcreate: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetSpecialFolderPathW(hwnd: super::super::Foundation::HWND, pszpath: ::windows::core::PWSTR, csidl: i32, fcreate: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHGetSpecialFolderPathW(hwnd.into(), ::core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHGetStockIconInfo(siid: SHSTOCKICONID, uflags: SHGSI_FLAGS, psii: *mut SHSTOCKICONINFO) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetStockIconInfo(siid: SHSTOCKICONID, uflags: SHGSI_FLAGS, psii: *mut SHSTOCKICONINFO) -> ::windows::core::HRESULT;
    }
    SHGetStockIconInfo(siid, uflags, ::core::mem::transmute(psii)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn SHGetTemporaryPropertyForItem<'a, P0>(psi: P0, propkey: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetTemporaryPropertyForItem(psi: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, ppropvar: *mut ::core::mem::ManuallyDrop<super::super::System::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetTemporaryPropertyForItem(psi.into().abi(), ::core::mem::transmute(propkey), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::StructuredStorage::PROPVARIANT>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGetThreadRef() -> ::windows::core::Result<::windows::core::IUnknown> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetThreadRef(ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHGetThreadRef(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHGetUnreadMailCountW<'a, P0, P1>(hkeyuser: P0, pszmailaddress: P1, pdwcount: ::core::option::Option<*mut u32>, pfiletime: ::core::option::Option<*mut super::super::Foundation::FILETIME>, pszshellexecutecommand: ::core::option::Option<&mut [u16]>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetUnreadMailCountW(hkeyuser: super::super::System::Registry::HKEY, pszmailaddress: ::windows::core::PCWSTR, pdwcount: *mut u32, pfiletime: *mut super::super::Foundation::FILETIME, pszshellexecutecommand: ::windows::core::PWSTR, cchshellexecutecommand: i32) -> ::windows::core::HRESULT;
    }
    SHGetUnreadMailCountW(hkeyuser.into(), pszmailaddress.into(), ::core::mem::transmute(pdwcount.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfiletime.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszshellexecutecommand.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pszshellexecutecommand.as_deref().map_or(0, |slice| slice.len() as _)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHGetValueA<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetValueA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHGetValueA(hkey.into(), pszsubkey.into(), pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHGetValueW<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetValueW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHGetValueW(hkey.into(), pszsubkey.into(), pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetViewStatePropertyBag<'a, P0, T>(pidl: ::core::option::Option<*const Common::ITEMIDLIST>, pszbagname: P0, dwflags: u32) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGetViewStatePropertyBag(pidl: *const Common::ITEMIDLIST, pszbagname: ::windows::core::PCWSTR, dwflags: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    SHGetViewStatePropertyBag(::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), pszbagname.into(), dwflags, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGlobalCounterDecrement(id: SHGLOBALCOUNTER) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGlobalCounterDecrement(id: SHGLOBALCOUNTER) -> i32;
    }
    SHGlobalCounterDecrement(id)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGlobalCounterGetValue(id: SHGLOBALCOUNTER) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGlobalCounterGetValue(id: SHGLOBALCOUNTER) -> i32;
    }
    SHGlobalCounterGetValue(id)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHGlobalCounterIncrement(id: SHGLOBALCOUNTER) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHGlobalCounterIncrement(id: SHGLOBALCOUNTER) -> i32;
    }
    SHGlobalCounterIncrement(id)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHHandleUpdateImage(pidlextra: *const Common::ITEMIDLIST) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHHandleUpdateImage(pidlextra: *const Common::ITEMIDLIST) -> i32;
    }
    SHHandleUpdateImage(::core::mem::transmute(pidlextra))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHILCreateFromPath<'a, P0>(pszpath: P0, ppidl: *mut *mut Common::ITEMIDLIST, rgfinout: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHILCreateFromPath(pszpath: ::windows::core::PCWSTR, ppidl: *mut *mut Common::ITEMIDLIST, rgfinout: *mut u32) -> ::windows::core::HRESULT;
    }
    SHILCreateFromPath(pszpath.into(), ::core::mem::transmute(ppidl), ::core::mem::transmute(rgfinout.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHInvokePrinterCommandA<'a, P0, P1, P2, P3>(hwnd: P0, uaction: u32, lpbuf1: P1, lpbuf2: P2, fmodal: P3) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHInvokePrinterCommandA(hwnd: super::super::Foundation::HWND, uaction: u32, lpbuf1: ::windows::core::PCSTR, lpbuf2: ::windows::core::PCSTR, fmodal: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHInvokePrinterCommandA(hwnd.into(), uaction, lpbuf1.into(), lpbuf2.into(), fmodal.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHInvokePrinterCommandW<'a, P0, P1, P2, P3>(hwnd: P0, uaction: u32, lpbuf1: P1, lpbuf2: P2, fmodal: P3) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHInvokePrinterCommandW(hwnd: super::super::Foundation::HWND, uaction: u32, lpbuf1: ::windows::core::PCWSTR, lpbuf2: ::windows::core::PCWSTR, fmodal: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHInvokePrinterCommandW(hwnd.into(), uaction, lpbuf1.into(), lpbuf2.into(), fmodal.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHIsFileAvailableOffline<'a, P0>(pwszpath: P0) -> ::windows::core::Result<u32>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHIsFileAvailableOffline(pwszpath: ::windows::core::PCWSTR, pdwstatus: *mut u32) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHIsFileAvailableOffline(pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHIsLowMemoryMachine(dwtype: u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHIsLowMemoryMachine(dwtype: u32) -> super::super::Foundation::BOOL;
    }
    SHIsLowMemoryMachine(dwtype)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHLimitInputEdit<'a, P0, P1>(hwndedit: P0, psf: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHLimitInputEdit(hwndedit: super::super::Foundation::HWND, psf: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHLimitInputEdit(hwndedit.into(), psf.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHLoadInProc(rclsid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHLoadInProc(rclsid: *const ::windows::core::GUID) -> ::windows::core::HRESULT;
    }
    SHLoadInProc(::core::mem::transmute(rclsid)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHLoadIndirectString<'a, P0>(pszsource: P0, pszoutbuf: &mut [u16], ppvreserved: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHLoadIndirectString(pszsource: ::windows::core::PCWSTR, pszoutbuf: ::windows::core::PWSTR, cchoutbuf: u32, ppvreserved: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHLoadIndirectString(pszsource.into(), ::core::mem::transmute(pszoutbuf.as_ptr()), pszoutbuf.len() as _, ::core::mem::transmute(ppvreserved.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHLoadNonloadedIconOverlayIdentifiers() -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHLoadNonloadedIconOverlayIdentifiers() -> ::windows::core::HRESULT;
    }
    SHLoadNonloadedIconOverlayIdentifiers().ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHLockShared<'a, P0>(hdata: P0, dwprocessid: u32) -> *mut ::core::ffi::c_void
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHLockShared(hdata: super::super::Foundation::HANDLE, dwprocessid: u32) -> *mut ::core::ffi::c_void;
    }
    SHLockShared(hdata.into(), dwprocessid)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHMapPIDLToSystemImageListIndex<'a, P0>(pshf: P0, pidl: *const Common::ITEMIDLIST, piindexsel: ::core::option::Option<*mut i32>) -> i32
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHMapPIDLToSystemImageListIndex(pshf: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, piindexsel: *mut i32) -> i32;
    }
    SHMapPIDLToSystemImageListIndex(pshf.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(piindexsel.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHMessageBoxCheckA<'a, P0, P1, P2, P3>(hwnd: P0, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P3) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHMessageBoxCheckA(hwnd: super::super::Foundation::HWND, psztext: ::windows::core::PCSTR, pszcaption: ::windows::core::PCSTR, utype: u32, idefault: i32, pszregval: ::windows::core::PCSTR) -> i32;
    }
    SHMessageBoxCheckA(hwnd.into(), psztext.into(), pszcaption.into(), utype, idefault, pszregval.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHMessageBoxCheckW<'a, P0, P1, P2, P3>(hwnd: P0, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P3) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHMessageBoxCheckW(hwnd: super::super::Foundation::HWND, psztext: ::windows::core::PCWSTR, pszcaption: ::windows::core::PCWSTR, utype: u32, idefault: i32, pszregval: ::windows::core::PCWSTR) -> i32;
    }
    SHMessageBoxCheckW(hwnd.into(), psztext.into(), pszcaption.into(), utype, idefault, pszregval.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHMultiFileProperties<'a, P0>(pdtobj: P0, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHMultiFileProperties(pdtobj: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHMultiFileProperties(pdtobj.into().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHObjectProperties<'a, P0, P1, P2>(hwnd: P0, shopobjecttype: SHOP_TYPE, pszobjectname: P1, pszpropertypage: P2) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHObjectProperties(hwnd: super::super::Foundation::HWND, shopobjecttype: SHOP_TYPE, pszobjectname: ::windows::core::PCWSTR, pszpropertypage: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    SHObjectProperties(hwnd.into(), shopobjecttype, pszobjectname.into(), pszpropertypage.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHOpenFolderAndSelectItems(pidlfolder: *const Common::ITEMIDLIST, apidl: ::core::option::Option<&[*const Common::ITEMIDLIST]>, dwflags: u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenFolderAndSelectItems(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHOpenFolderAndSelectItems(::core::mem::transmute(pidlfolder), apidl.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(apidl.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenPropSheetW<'a, P0, P1, P2, P3>(pszcaption: P0, ahkeys: ::core::option::Option<&[super::super::System::Registry::HKEY]>, pclsiddefault: ::core::option::Option<*const ::windows::core::GUID>, pdtobj: P1, psb: P2, pstartpage: P3) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, IShellBrowser>>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenPropSheetW(pszcaption: ::windows::core::PCWSTR, ahkeys: *const super::super::System::Registry::HKEY, ckeys: u32, pclsiddefault: *const ::windows::core::GUID, pdtobj: *mut ::core::ffi::c_void, psb: *mut ::core::ffi::c_void, pstartpage: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    SHOpenPropSheetW(pszcaption.into(), ::core::mem::transmute(ahkeys.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ahkeys.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pclsiddefault.unwrap_or(::std::ptr::null())), pdtobj.into().abi(), psb.into().abi(), pstartpage.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2A<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenRegStream2A(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    SHOpenRegStream2A(hkey.into(), pszsubkey.into(), pszvalue.into(), grfmode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2W<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenRegStream2W(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    SHOpenRegStream2W(hkey.into(), pszsubkey.into(), pszvalue.into(), grfmode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamA<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenRegStreamA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    SHOpenRegStreamA(hkey.into(), pszsubkey.into(), pszvalue.into(), grfmode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamW<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenRegStreamW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, grfmode: u32) -> ::core::option::Option<super::super::System::Com::IStream>;
    }
    SHOpenRegStreamW(hkey.into(), pszsubkey.into(), pszvalue.into(), grfmode)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHOpenWithDialog<'a, P0>(hwndparent: P0, poainfo: *const OPENASINFO) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHOpenWithDialog(hwndparent: super::super::Foundation::HWND, poainfo: *const OPENASINFO) -> ::windows::core::HRESULT;
    }
    SHOpenWithDialog(hwndparent.into(), ::core::mem::transmute(poainfo)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHParseDisplayName<'a, P0, P1>(pszname: P0, pbc: P1, ppidl: *mut *mut Common::ITEMIDLIST, sfgaoin: u32, psfgaoout: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHParseDisplayName(pszname: ::windows::core::PCWSTR, pbc: *mut ::core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST, sfgaoin: u32, psfgaoout: *mut u32) -> ::windows::core::HRESULT;
    }
    SHParseDisplayName(pszname.into(), pbc.into().abi(), ::core::mem::transmute(ppidl), sfgaoin, ::core::mem::transmute(psfgaoout.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHPathPrepareForWriteA<'a, P0, P1, P2>(hwnd: P0, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHPathPrepareForWriteA(hwnd: super::super::Foundation::HWND, punkenablemodless: *mut ::core::ffi::c_void, pszpath: ::windows::core::PCSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHPathPrepareForWriteA(hwnd.into(), punkenablemodless.into().abi(), pszpath.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHPathPrepareForWriteW<'a, P0, P1, P2>(hwnd: P0, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHPathPrepareForWriteW(hwnd: super::super::Foundation::HWND, punkenablemodless: *mut ::core::ffi::c_void, pszpath: ::windows::core::PCWSTR, dwflags: u32) -> ::windows::core::HRESULT;
    }
    SHPathPrepareForWriteW(hwnd.into(), punkenablemodless.into().abi(), pszpath.into(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHQueryInfoKeyA<'a, P0>(hkey: P0, pcsubkeys: ::core::option::Option<*mut u32>, pcchmaxsubkeylen: ::core::option::Option<*mut u32>, pcvalues: ::core::option::Option<*mut u32>, pcchmaxvaluenamelen: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryInfoKeyA(hkey: super::super::System::Registry::HKEY, pcsubkeys: *mut u32, pcchmaxsubkeylen: *mut u32, pcvalues: *mut u32, pcchmaxvaluenamelen: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHQueryInfoKeyA(hkey.into(), ::core::mem::transmute(pcsubkeys.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxsubkeylen.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcvalues.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHQueryInfoKeyW<'a, P0>(hkey: P0, pcsubkeys: ::core::option::Option<*mut u32>, pcchmaxsubkeylen: ::core::option::Option<*mut u32>, pcvalues: ::core::option::Option<*mut u32>, pcchmaxvaluenamelen: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryInfoKeyW(hkey: super::super::System::Registry::HKEY, pcsubkeys: *mut u32, pcchmaxsubkeylen: *mut u32, pcvalues: *mut u32, pcchmaxvaluenamelen: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHQueryInfoKeyW(hkey.into(), ::core::mem::transmute(pcsubkeys.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxsubkeylen.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcvalues.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHQueryRecycleBinA<'a, P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryRecycleBinA(pszrootpath: ::windows::core::PCSTR, pshqueryrbinfo: *mut SHQUERYRBINFO) -> ::windows::core::HRESULT;
    }
    SHQueryRecycleBinA(pszrootpath.into(), ::core::mem::transmute(pshqueryrbinfo)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHQueryRecycleBinW<'a, P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryRecycleBinW(pszrootpath: ::windows::core::PCWSTR, pshqueryrbinfo: *mut SHQUERYRBINFO) -> ::windows::core::HRESULT;
    }
    SHQueryRecycleBinW(pszrootpath.into(), ::core::mem::transmute(pshqueryrbinfo)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHQueryUserNotificationState() -> ::windows::core::Result<QUERY_USER_NOTIFICATION_STATE> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryUserNotificationState(pquns: *mut QUERY_USER_NOTIFICATION_STATE) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHQueryUserNotificationState(::core::mem::transmute(result__.as_mut_ptr())).from_abi::<QUERY_USER_NOTIFICATION_STATE>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHQueryValueExA<'a, P0, P1>(hkey: P0, pszvalue: P1, pdwreserved: ::core::option::Option<*mut u32>, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryValueExA(hkey: super::super::System::Registry::HKEY, pszvalue: ::windows::core::PCSTR, pdwreserved: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHQueryValueExA(hkey.into(), pszvalue.into(), ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHQueryValueExW<'a, P0, P1>(hkey: P0, pszvalue: P1, pdwreserved: ::core::option::Option<*mut u32>, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHQueryValueExW(hkey: super::super::System::Registry::HKEY, pszvalue: ::windows::core::PCWSTR, pdwreserved: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHQueryValueExW(hkey.into(), pszvalue.into(), ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegCloseUSKey(huskey: isize) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegCloseUSKey(huskey: isize) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegCloseUSKey(huskey)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegCreateUSKeyA<'a, P0>(pszpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegCreateUSKeyA(pszpath: ::windows::core::PCSTR, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegCreateUSKeyA(pszpath.into(), samdesired, hrelativeuskey, ::core::mem::transmute(phnewuskey), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegCreateUSKeyW<'a, P0>(pwzpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegCreateUSKeyW(pwzpath: ::windows::core::PCWSTR, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegCreateUSKeyW(pwzpath.into(), samdesired, hrelativeuskey, ::core::mem::transmute(phnewuskey), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyA<'a, P0>(huskey: isize, pszsubkey: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegDeleteEmptyUSKeyA(huskey: isize, pszsubkey: ::windows::core::PCSTR, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegDeleteEmptyUSKeyA(huskey, pszsubkey.into(), delregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyW<'a, P0>(huskey: isize, pwzsubkey: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegDeleteEmptyUSKeyW(huskey: isize, pwzsubkey: ::windows::core::PCWSTR, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegDeleteEmptyUSKeyW(huskey, pwzsubkey.into(), delregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegDeleteUSValueA<'a, P0>(huskey: isize, pszvalue: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegDeleteUSValueA(huskey: isize, pszvalue: ::windows::core::PCSTR, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegDeleteUSValueA(huskey, pszvalue.into(), delregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegDeleteUSValueW<'a, P0>(huskey: isize, pwzvalue: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegDeleteUSValueW(huskey: isize, pwzvalue: ::windows::core::PCWSTR, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegDeleteUSValueW(huskey, pwzvalue.into(), delregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegDuplicateHKey<'a, P0>(hkey: P0) -> super::super::System::Registry::HKEY
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegDuplicateHKey(hkey: super::super::System::Registry::HKEY) -> super::super::System::Registry::HKEY;
    }
    SHRegDuplicateHKey(hkey.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegEnumUSKeyA(huskey: isize, dwindex: u32, pszname: ::windows::core::PSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegEnumUSKeyA(huskey: isize, dwindex: u32, pszname: ::windows::core::PSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegEnumUSKeyA(huskey, dwindex, ::core::mem::transmute(pszname), ::core::mem::transmute(pcchname), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegEnumUSKeyW(huskey: isize, dwindex: u32, pwzname: ::windows::core::PWSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegEnumUSKeyW(huskey: isize, dwindex: u32, pwzname: ::windows::core::PWSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegEnumUSKeyW(huskey, dwindex, ::core::mem::transmute(pwzname), ::core::mem::transmute(pcchname), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegEnumUSValueA(huskey: isize, dwindex: u32, pszvaluename: ::windows::core::PSTR, pcchvaluename: *mut u32, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegEnumUSValueA(huskey: isize, dwindex: u32, pszvaluename: ::windows::core::PSTR, pcchvaluename: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegEnumUSValueA(huskey, dwindex, ::core::mem::transmute(pszvaluename), ::core::mem::transmute(pcchvaluename), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegEnumUSValueW(huskey: isize, dwindex: u32, pszvaluename: ::windows::core::PWSTR, pcchvaluename: *mut u32, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegEnumUSValueW(huskey: isize, dwindex: u32, pszvaluename: ::windows::core::PWSTR, pcchvaluename: *mut u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegEnumUSValueW(huskey, dwindex, ::core::mem::transmute(pszvaluename), ::core::mem::transmute(pcchvaluename), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegGetBoolUSValueA<'a, P0, P1, P2, P3>(pszsubkey: P0, pszvalue: P1, fignorehkcu: P2, fdefault: P3) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    P3: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetBoolUSValueA(pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, fignorehkcu: super::super::Foundation::BOOL, fdefault: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHRegGetBoolUSValueA(pszsubkey.into(), pszvalue.into(), fignorehkcu.into(), fdefault.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegGetBoolUSValueW<'a, P0, P1, P2, P3>(pszsubkey: P0, pszvalue: P1, fignorehkcu: P2, fdefault: P3) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    P3: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetBoolUSValueW(pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, fignorehkcu: super::super::Foundation::BOOL, fdefault: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
    }
    SHRegGetBoolUSValueW(pszsubkey.into(), pszvalue.into(), fignorehkcu.into(), fdefault.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegGetIntW<'a, P0, P1>(hk: P0, pwzkey: P1, idefault: i32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetIntW(hk: super::super::System::Registry::HKEY, pwzkey: ::windows::core::PCWSTR, idefault: i32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetIntW(hk.into(), pwzkey.into(), idefault)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegGetPathA<'a, P0, P1, P2>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u8; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetPathA(hkey: super::super::System::Registry::HKEY, pcszsubkey: ::windows::core::PCSTR, pcszvalue: ::windows::core::PCSTR, pszpath: ::windows::core::PSTR, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetPathA(hkey.into(), pcszsubkey.into(), pcszvalue.into(), ::core::mem::transmute(pszpath.as_ptr()), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegGetPathW<'a, P0, P1, P2>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u16; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetPathW(hkey: super::super::System::Registry::HKEY, pcszsubkey: ::windows::core::PCWSTR, pcszvalue: ::windows::core::PCWSTR, pszpath: ::windows::core::PWSTR, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetPathW(hkey.into(), pcszsubkey.into(), pcszvalue.into(), ::core::mem::transmute(pszpath.as_ptr()), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegGetUSValueA<'a, P0, P1, P2>(pszsubkey: P0, pszvalue: P1, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, fignorehkcu: P2, pvdefaultdata: ::core::option::Option<*const ::core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetUSValueA(pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, fignorehkcu: super::super::Foundation::BOOL, pvdefaultdata: *const ::core::ffi::c_void, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetUSValueA(pszsubkey.into(), pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), fignorehkcu.into(), ::core::mem::transmute(pvdefaultdata.unwrap_or(::std::ptr::null())), dwdefaultdatasize)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegGetUSValueW<'a, P0, P1, P2>(pszsubkey: P0, pszvalue: P1, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, fignorehkcu: P2, pvdefaultdata: ::core::option::Option<*const ::core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetUSValueW(pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, fignorehkcu: super::super::Foundation::BOOL, pvdefaultdata: *const ::core::ffi::c_void, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetUSValueW(pszsubkey.into(), pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), fignorehkcu.into(), ::core::mem::transmute(pvdefaultdata.unwrap_or(::std::ptr::null())), dwdefaultdatasize)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegGetValueA<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetValueA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, srrfflags: i32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetValueA(hkey.into(), pszsubkey.into(), pszvalue.into(), srrfflags, ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegGetValueFromHKCUHKLM<'a, P0, P1>(pwszkey: P0, pwszvalue: P1, srrfflags: i32, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetValueFromHKCUHKLM(pwszkey: ::windows::core::PCWSTR, pwszvalue: ::windows::core::PCWSTR, srrfflags: i32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetValueFromHKCUHKLM(pwszkey.into(), pwszvalue.into(), srrfflags, ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegGetValueW<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegGetValueW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, srrfflags: i32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegGetValueW(hkey.into(), pszsubkey.into(), pszvalue.into(), srrfflags, ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegOpenUSKeyA<'a, P0, P1>(pszpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegOpenUSKeyA(pszpath: ::windows::core::PCSTR, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: super::super::Foundation::BOOL) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegOpenUSKeyA(pszpath.into(), samdesired, hrelativeuskey, ::core::mem::transmute(phnewuskey), fignorehkcu.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegOpenUSKeyW<'a, P0, P1>(pwzpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegOpenUSKeyW(pwzpath: ::windows::core::PCWSTR, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: super::super::Foundation::BOOL) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegOpenUSKeyW(pwzpath.into(), samdesired, hrelativeuskey, ::core::mem::transmute(phnewuskey), fignorehkcu.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyA(huskey: isize, pcsubkeys: ::core::option::Option<*mut u32>, pcchmaxsubkeylen: ::core::option::Option<*mut u32>, pcvalues: ::core::option::Option<*mut u32>, pcchmaxvaluenamelen: ::core::option::Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegQueryInfoUSKeyA(huskey: isize, pcsubkeys: *mut u32, pcchmaxsubkeylen: *mut u32, pcvalues: *mut u32, pcchmaxvaluenamelen: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegQueryInfoUSKeyA(huskey, ::core::mem::transmute(pcsubkeys.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxsubkeylen.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcvalues.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(::std::ptr::null_mut())), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyW(huskey: isize, pcsubkeys: ::core::option::Option<*mut u32>, pcchmaxsubkeylen: ::core::option::Option<*mut u32>, pcvalues: ::core::option::Option<*mut u32>, pcchmaxvaluenamelen: ::core::option::Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegQueryInfoUSKeyW(huskey: isize, pcsubkeys: *mut u32, pcchmaxsubkeylen: *mut u32, pcvalues: *mut u32, pcchmaxvaluenamelen: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegQueryInfoUSKeyW(huskey, ::core::mem::transmute(pcsubkeys.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxsubkeylen.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcvalues.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(::std::ptr::null_mut())), enumregflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegQueryUSValueA<'a, P0, P1>(huskey: isize, pszvalue: P0, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, fignorehkcu: P1, pvdefaultdata: ::core::option::Option<*const ::core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegQueryUSValueA(huskey: isize, pszvalue: ::windows::core::PCSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, fignorehkcu: super::super::Foundation::BOOL, pvdefaultdata: *const ::core::ffi::c_void, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegQueryUSValueA(huskey, pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), fignorehkcu.into(), ::core::mem::transmute(pvdefaultdata.unwrap_or(::std::ptr::null())), dwdefaultdatasize)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegQueryUSValueW<'a, P0, P1>(huskey: isize, pszvalue: P0, pdwtype: ::core::option::Option<*mut u32>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: ::core::option::Option<*mut u32>, fignorehkcu: P1, pvdefaultdata: ::core::option::Option<*const ::core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegQueryUSValueW(huskey: isize, pszvalue: ::windows::core::PCWSTR, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32, fignorehkcu: super::super::Foundation::BOOL, pvdefaultdata: *const ::core::ffi::c_void, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegQueryUSValueW(huskey, pszvalue.into(), ::core::mem::transmute(pdwtype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdata.unwrap_or(::std::ptr::null_mut())), fignorehkcu.into(), ::core::mem::transmute(pvdefaultdata.unwrap_or(::std::ptr::null())), dwdefaultdatasize)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegSetPathA<'a, P0, P1, P2, P3>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegSetPathA(hkey: super::super::System::Registry::HKEY, pcszsubkey: ::windows::core::PCSTR, pcszvalue: ::windows::core::PCSTR, pcszpath: ::windows::core::PCSTR, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegSetPathA(hkey.into(), pcszsubkey.into(), pcszvalue.into(), pcszpath.into(), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHRegSetPathW<'a, P0, P1, P2, P3>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegSetPathW(hkey: super::super::System::Registry::HKEY, pcszsubkey: ::windows::core::PCWSTR, pcszvalue: ::windows::core::PCWSTR, pcszpath: ::windows::core::PCWSTR, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegSetPathW(hkey.into(), pcszsubkey.into(), pcszvalue.into(), pcszpath.into(), dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegSetUSValueA<'a, P0, P1>(pszsubkey: P0, pszvalue: P1, dwtype: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegSetUSValueA(pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegSetUSValueA(pszsubkey.into(), pszvalue.into(), dwtype, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())), cbdata, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegSetUSValueW<'a, P0, P1>(pwzsubkey: P0, pwzvalue: P1, dwtype: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegSetUSValueW(pwzsubkey: ::windows::core::PCWSTR, pwzvalue: ::windows::core::PCWSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegSetUSValueW(pwzsubkey.into(), pwzvalue.into(), dwtype, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())), cbdata, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegWriteUSValueA<'a, P0>(huskey: isize, pszvalue: P0, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegWriteUSValueA(huskey: isize, pszvalue: ::windows::core::PCSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegWriteUSValueA(huskey, pszvalue.into(), dwtype, ::core::mem::transmute(pvdata), cbdata, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHRegWriteUSValueW<'a, P0>(huskey: isize, pwzvalue: P0, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRegWriteUSValueW(huskey: isize, pwzvalue: ::windows::core::PCWSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR;
    }
    SHRegWriteUSValueW(huskey, pwzvalue.into(), dwtype, ::core::mem::transmute(pvdata), cbdata, dwflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHReleaseThreadRef() -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHReleaseThreadRef() -> ::windows::core::HRESULT;
    }
    SHReleaseThreadRef().ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHRemoveLocalizedName<'a, P0>(pszpath: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRemoveLocalizedName(pszpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    SHRemoveLocalizedName(pszpath.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn SHReplaceFromPropSheetExtArray<'a, P0, P1>(hpsxa: P0, upageid: u32, lpfnreplacewith: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: P1) -> u32
where
    P0: ::std::convert::Into<HPSXA>,
    P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHReplaceFromPropSheetExtArray(hpsxa: HPSXA, upageid: u32, lpfnreplacewith: *mut ::core::ffi::c_void, lparam: super::super::Foundation::LPARAM) -> u32;
    }
    SHReplaceFromPropSheetExtArray(hpsxa.into(), upageid, ::core::mem::transmute(lpfnreplacewith), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHResolveLibrary<'a, P0>(psilibrary: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHResolveLibrary(psilibrary: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHResolveLibrary(psilibrary.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHRestricted(rest: RESTRICTIONS) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHRestricted(rest: RESTRICTIONS) -> u32;
    }
    SHRestricted(rest)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSendMessageBroadcastA<'a, P0, P1>(umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSendMessageBroadcastA(umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    }
    SHSendMessageBroadcastA(umsg, wparam.into(), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSendMessageBroadcastW<'a, P0, P1>(umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSendMessageBroadcastW(umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    }
    SHSendMessageBroadcastW(umsg, wparam.into(), lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSetDefaultProperties<'a, P0, P1, P2>(hwnd: P0, psi: P1, dwfileopflags: u32, pfops: P2) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
    P2: ::std::convert::Into<::windows::core::InParam<'a, IFileOperationProgressSink>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetDefaultProperties(hwnd: super::super::Foundation::HWND, psi: *mut ::core::ffi::c_void, dwfileopflags: u32, pfops: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHSetDefaultProperties(hwnd.into(), psi.into().abi(), dwfileopflags, pfops.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSetFolderPathA<'a, P0, P1>(csidl: i32, htoken: P0, dwflags: u32, pszpath: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetFolderPathA(csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszpath: ::windows::core::PCSTR) -> ::windows::core::HRESULT;
    }
    SHSetFolderPathA(csidl, htoken.into(), dwflags, pszpath.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSetFolderPathW<'a, P0, P1>(csidl: i32, htoken: P0, dwflags: u32, pszpath: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetFolderPathW(csidl: i32, htoken: super::super::Foundation::HANDLE, dwflags: u32, pszpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    SHSetFolderPathW(csidl, htoken.into(), dwflags, pszpath.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHSetInstanceExplorer<'a, P0>(punk: P0)
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetInstanceExplorer(punk: *mut ::core::ffi::c_void);
    }
    SHSetInstanceExplorer(punk.into().abi())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHSetKnownFolderPath<'a, P0, P1>(rfid: *const ::windows::core::GUID, dwflags: u32, htoken: P0, pszpath: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetKnownFolderPath(rfid: *const ::windows::core::GUID, dwflags: u32, htoken: super::super::Foundation::HANDLE, pszpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    SHSetKnownFolderPath(::core::mem::transmute(rfid), dwflags, htoken.into(), pszpath.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHSetLocalizedName<'a, P0, P1>(pszpath: P0, pszresmodule: P1, idsres: i32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetLocalizedName(pszpath: ::windows::core::PCWSTR, pszresmodule: ::windows::core::PCWSTR, idsres: i32) -> ::windows::core::HRESULT;
    }
    SHSetLocalizedName(pszpath.into(), pszresmodule.into(), idsres).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn SHSetTemporaryPropertyForItem<'a, P0>(psi: P0, propkey: *const PropertiesSystem::PROPERTYKEY, propvar: *const super::super::System::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetTemporaryPropertyForItem(psi: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, propvar: *const ::core::mem::ManuallyDrop<super::super::System::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT;
    }
    SHSetTemporaryPropertyForItem(psi.into().abi(), ::core::mem::transmute(propkey), ::core::mem::transmute(propvar)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHSetThreadRef<'a, P0>(punk: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetThreadRef(punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    SHSetThreadRef(punk.into().abi()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHSetUnreadMailCountW<'a, P0, P1>(pszmailaddress: P0, dwcount: u32, pszshellexecutecommand: P1) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetUnreadMailCountW(pszmailaddress: ::windows::core::PCWSTR, dwcount: u32, pszshellexecutecommand: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    SHSetUnreadMailCountW(pszmailaddress.into(), dwcount, pszshellexecutecommand.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueA<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>, cbdata: u32) -> i32
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetValueA(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCSTR, pszvalue: ::windows::core::PCSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32) -> i32;
    }
    SHSetValueA(hkey.into(), pszsubkey.into(), pszvalue.into(), dwtype, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())), cbdata)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueW<'a, P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>, cbdata: u32) -> i32
where
    P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSetValueW(hkey: super::super::System::Registry::HKEY, pszsubkey: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, dwtype: u32, pvdata: *const ::core::ffi::c_void, cbdata: u32) -> i32;
    }
    SHSetValueW(hkey.into(), pszsubkey.into(), pszvalue.into(), dwtype, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())), cbdata)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHShellFolderView_Message<'a, P0, P1>(hwndmain: P0, umsg: u32, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHShellFolderView_Message(hwndmain: super::super::Foundation::HWND, umsg: u32, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    }
    SHShellFolderView_Message(hwndmain.into(), umsg, lparam.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHShowManageLibraryUI<'a, P0, P1, P2, P3>(psilibrary: P0, hwndowner: P1, psztitle: P2, pszinstruction: P3, lmdoptions: LIBRARYMANAGEDIALOGOPTIONS) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItem>>,
    P1: ::std::convert::Into<super::super::Foundation::HWND>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHShowManageLibraryUI(psilibrary: *mut ::core::ffi::c_void, hwndowner: super::super::Foundation::HWND, psztitle: ::windows::core::PCWSTR, pszinstruction: ::windows::core::PCWSTR, lmdoptions: LIBRARYMANAGEDIALOGOPTIONS) -> ::windows::core::HRESULT;
    }
    SHShowManageLibraryUI(psilibrary.into().abi(), hwndowner.into(), psztitle.into(), pszinstruction.into(), lmdoptions).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHSimpleIDListFromPath<'a, P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSimpleIDListFromPath(pszpath: ::windows::core::PCWSTR) -> *mut Common::ITEMIDLIST;
    }
    SHSimpleIDListFromPath(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn SHSkipJunction<'a, P0>(pbc: P0, pclsid: *const ::windows::core::GUID) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHSkipJunction(pbc: *mut ::core::ffi::c_void, pclsid: *const ::windows::core::GUID) -> super::super::Foundation::BOOL;
    }
    SHSkipJunction(pbc.into().abi(), ::core::mem::transmute(pclsid))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHStartNetConnectionDialogW<'a, P0, P1>(hwnd: P0, pszremotename: P1, dwtype: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHStartNetConnectionDialogW(hwnd: super::super::Foundation::HWND, pszremotename: ::windows::core::PCWSTR, dwtype: u32) -> ::windows::core::HRESULT;
    }
    SHStartNetConnectionDialogW(hwnd.into(), pszremotename.into(), dwtype).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHStrDupA<'a, P0>(psz: P0) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHStrDupA(psz: ::windows::core::PCSTR, ppwsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHStrDupA(psz.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHStrDupW<'a, P0>(psz: P0) -> ::windows::core::Result<::windows::core::PWSTR>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHStrDupW(psz: ::windows::core::PCWSTR, ppwsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    SHStrDupW(psz.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHStripMneumonicA(pszmenu: ::windows::core::PSTR) -> super::super::Foundation::CHAR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHStripMneumonicA(pszmenu: ::windows::core::PSTR) -> super::super::Foundation::CHAR;
    }
    SHStripMneumonicA(::core::mem::transmute(pszmenu))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHStripMneumonicW(pszmenu: ::windows::core::PWSTR) -> u16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHStripMneumonicW(pszmenu: ::windows::core::PWSTR) -> u16;
    }
    SHStripMneumonicW(::core::mem::transmute(pszmenu))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHTestTokenMembership<'a, P0>(htoken: P0, ulrid: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHTestTokenMembership(htoken: super::super::Foundation::HANDLE, ulrid: u32) -> super::super::Foundation::BOOL;
    }
    SHTestTokenMembership(htoken.into(), ulrid)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHUnicodeToAnsi<'a, P0>(pwszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHUnicodeToAnsi(pwszsrc: ::windows::core::PCWSTR, pszdst: ::windows::core::PSTR, cchbuf: i32) -> i32;
    }
    SHUnicodeToAnsi(pwszsrc.into(), ::core::mem::transmute(pszdst.as_ptr()), pszdst.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHUnicodeToUnicode<'a, P0>(pwzsrc: P0, pwzdst: &mut [u16]) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHUnicodeToUnicode(pwzsrc: ::windows::core::PCWSTR, pwzdst: ::windows::core::PWSTR, cwchbuf: i32) -> i32;
    }
    SHUnicodeToUnicode(pwzsrc.into(), ::core::mem::transmute(pwzdst.as_ptr()), pwzdst.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHUnlockShared(pvdata: *const ::core::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHUnlockShared(pvdata: *const ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    SHUnlockShared(::core::mem::transmute(pvdata))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHUpdateImageA<'a, P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHUpdateImageA(pszhashitem: ::windows::core::PCSTR, iindex: i32, uflags: u32, iimageindex: i32);
    }
    SHUpdateImageA(pszhashitem.into(), iindex, uflags, iimageindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SHUpdateImageW<'a, P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHUpdateImageW(pszhashitem: ::windows::core::PCWSTR, iindex: i32, uflags: u32, iimageindex: i32);
    }
    SHUpdateImageW(pszhashitem.into(), iindex, uflags, iimageindex)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SHValidateUNC<'a, P0>(hwndowner: P0, pszfile: ::windows::core::PWSTR, fconnect: VALIDATEUNC_OPTION) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SHValidateUNC(hwndowner: super::super::Foundation::HWND, pszfile: ::windows::core::PWSTR, fconnect: VALIDATEUNC_OPTION) -> super::super::Foundation::BOOL;
    }
    SHValidateUNC(hwndowner.into(), ::core::mem::transmute(pszfile), fconnect)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn SetCurrentProcessExplicitAppUserModelID<'a, P0>(appid: P0) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SetCurrentProcessExplicitAppUserModelID(appid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT;
    }
    SetCurrentProcessExplicitAppUserModelID(appid.into()).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SetMenuContextHelpId<'a, P0>(param0: P0, param1: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU, param1: u32) -> super::super::Foundation::BOOL;
    }
    SetMenuContextHelpId(param0.into(), param1)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetWindowContextHelpId<'a, P0>(param0: P0, param1: u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SetWindowContextHelpId(param0: super::super::Foundation::HWND, param1: u32) -> super::super::Foundation::BOOL;
    }
    SetWindowContextHelpId(param0.into(), param1)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetWindowSubclass<'a, P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, dwrefdata: usize) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: *mut ::core::ffi::c_void, uidsubclass: usize, dwrefdata: usize) -> super::super::Foundation::BOOL;
    }
    SetWindowSubclass(hwnd.into(), ::core::mem::transmute(pfnsubclass), uidsubclass, dwrefdata)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ShellAboutA<'a, P0, P1, P2, P3>(hwnd: P0, szapp: P1, szotherstuff: P2, hicon: P3) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<super::WindowsAndMessaging::HICON>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellAboutA(hwnd: super::super::Foundation::HWND, szapp: ::windows::core::PCSTR, szotherstuff: ::windows::core::PCSTR, hicon: super::WindowsAndMessaging::HICON) -> i32;
    }
    ShellAboutA(hwnd.into(), szapp.into(), szotherstuff.into(), hicon.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ShellAboutW<'a, P0, P1, P2, P3>(hwnd: P0, szapp: P1, szotherstuff: P2, hicon: P3) -> i32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<super::WindowsAndMessaging::HICON>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellAboutW(hwnd: super::super::Foundation::HWND, szapp: ::windows::core::PCWSTR, szotherstuff: ::windows::core::PCWSTR, hicon: super::WindowsAndMessaging::HICON) -> i32;
    }
    ShellAboutW(hwnd.into(), szapp.into(), szotherstuff.into(), hicon.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ShellExecuteA<'a, P0, P1, P2, P3, P4>(hwnd: P0, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
    P3: ::std::convert::Into<::windows::core::PCSTR>,
    P4: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellExecuteA(hwnd: super::super::Foundation::HWND, lpoperation: ::windows::core::PCSTR, lpfile: ::windows::core::PCSTR, lpparameters: ::windows::core::PCSTR, lpdirectory: ::windows::core::PCSTR, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE;
    }
    ShellExecuteA(hwnd.into(), lpoperation.into(), lpfile.into(), lpparameters.into(), lpdirectory.into(), nshowcmd)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ShellExecuteExA(pexecinfo: *mut SHELLEXECUTEINFOA) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellExecuteExA(pexecinfo: *mut SHELLEXECUTEINFOA) -> super::super::Foundation::BOOL;
    }
    ShellExecuteExA(::core::mem::transmute(pexecinfo))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ShellExecuteExW(pexecinfo: *mut SHELLEXECUTEINFOW) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellExecuteExW(pexecinfo: *mut SHELLEXECUTEINFOW) -> super::super::Foundation::BOOL;
    }
    ShellExecuteExW(::core::mem::transmute(pexecinfo))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ShellExecuteW<'a, P0, P1, P2, P3, P4>(hwnd: P0, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
    P4: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ShellExecuteW(hwnd: super::super::Foundation::HWND, lpoperation: ::windows::core::PCWSTR, lpfile: ::windows::core::PCWSTR, lpparameters: ::windows::core::PCWSTR, lpdirectory: ::windows::core::PCWSTR, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE;
    }
    ShellExecuteW(hwnd.into(), lpoperation.into(), lpfile.into(), lpparameters.into(), lpdirectory.into(), nshowcmd)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn Shell_GetCachedImageIndex<'a, P0>(pwsziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_GetCachedImageIndex(pwsziconpath: ::windows::core::PCWSTR, iiconindex: i32, uiconflags: u32) -> i32;
    }
    Shell_GetCachedImageIndex(pwsziconpath.into(), iiconindex, uiconflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn Shell_GetCachedImageIndexA<'a, P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_GetCachedImageIndexA(psziconpath: ::windows::core::PCSTR, iiconindex: i32, uiconflags: u32) -> i32;
    }
    Shell_GetCachedImageIndexA(psziconpath.into(), iiconindex, uiconflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn Shell_GetCachedImageIndexW<'a, P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_GetCachedImageIndexW(psziconpath: ::windows::core::PCWSTR, iiconindex: i32, uiconflags: u32) -> i32;
    }
    Shell_GetCachedImageIndexW(psziconpath.into(), iiconindex, uiconflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn Shell_GetImageLists(phiml: ::core::option::Option<*mut super::Controls::HIMAGELIST>, phimlsmall: ::core::option::Option<*mut super::Controls::HIMAGELIST>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_GetImageLists(phiml: *mut super::Controls::HIMAGELIST, phimlsmall: *mut super::Controls::HIMAGELIST) -> super::super::Foundation::BOOL;
    }
    Shell_GetImageLists(::core::mem::transmute(phiml.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phimlsmall.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_MergeMenus<'a, P0, P1>(hmdst: P0, hmsrc: P1, uinsert: u32, uidadjust: u32, uidadjustmax: u32, uflags: MM_FLAGS) -> u32
where
    P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    P1: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_MergeMenus(hmdst: super::WindowsAndMessaging::HMENU, hmsrc: super::WindowsAndMessaging::HMENU, uinsert: u32, uidadjust: u32, uidadjustmax: u32, uflags: MM_FLAGS) -> u32;
    }
    Shell_MergeMenus(hmdst.into(), hmsrc.into(), uinsert, uidadjust, uidadjustmax, uflags)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn Shell_NotifyIconA(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAA) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_NotifyIconA(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAA) -> super::super::Foundation::BOOL;
    }
    Shell_NotifyIconA(dwmessage, ::core::mem::transmute(lpdata))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Shell_NotifyIconGetRect(identifier: *const NOTIFYICONIDENTIFIER) -> ::windows::core::Result<super::super::Foundation::RECT> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_NotifyIconGetRect(identifier: *const NOTIFYICONIDENTIFIER, iconlocation: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::mem::MaybeUninit::zeroed();
    Shell_NotifyIconGetRect(::core::mem::transmute(identifier), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn Shell_NotifyIconW(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAW) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Shell_NotifyIconW(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAW) -> super::super::Foundation::BOOL;
    }
    Shell_NotifyIconW(dwmessage, ::core::mem::transmute(lpdata))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SignalFileOpen(pidl: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SignalFileOpen(pidl: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL;
    }
    SignalFileOpen(::core::mem::transmute(pidl))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com_Urlmon\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_Urlmon"))]
#[inline]
pub unsafe fn SoftwareUpdateMessageBox<'a, P0, P1>(hwnd: P0, pszdistunit: P1, dwflags: u32, psdi: ::core::option::Option<*mut super::super::System::Com::Urlmon::SOFTDISTINFO>) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SoftwareUpdateMessageBox(hwnd: super::super::Foundation::HWND, pszdistunit: ::windows::core::PCWSTR, dwflags: u32, psdi: *mut super::super::System::Com::Urlmon::SOFTDISTINFO) -> u32;
    }
    SoftwareUpdateMessageBox(hwnd.into(), pszdistunit.into(), dwflags, ::core::mem::transmute(psdi.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[inline]
pub unsafe fn StgMakeUniqueName<'a, P0, P1, T>(pstgparent: P0, pszfilespec: P1, grfmode: u32) -> ::windows::core::Result<T>
where
    P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::StructuredStorage::IStorage>>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    T: ::windows::core::Interface,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StgMakeUniqueName(pstgparent: *mut ::core::ffi::c_void, pszfilespec: ::windows::core::PCWSTR, grfmode: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
    }
    let mut result__ = ::core::option::Option::None;
    StgMakeUniqueName(pstgparent.into().abi(), pszfilespec.into(), grfmode, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCSpnA<'a, P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCSpnA(pszstr: ::windows::core::PCSTR, pszset: ::windows::core::PCSTR) -> i32;
    }
    StrCSpnA(pszstr.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCSpnIA<'a, P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCSpnIA(pszstr: ::windows::core::PCSTR, pszset: ::windows::core::PCSTR) -> i32;
    }
    StrCSpnIA(pszstr.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCSpnIW<'a, P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCSpnIW(pszstr: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR) -> i32;
    }
    StrCSpnIW(pszstr.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCSpnW<'a, P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCSpnW(pszstr: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR) -> i32;
    }
    StrCSpnW(pszstr.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCatBuffA<'a, P0>(pszdest: &mut [u8], pszsrc: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCatBuffA(pszdest: ::windows::core::PSTR, pszsrc: ::windows::core::PCSTR, cchdestbuffsize: i32) -> ::windows::core::PSTR;
    }
    StrCatBuffA(::core::mem::transmute(pszdest.as_ptr()), pszsrc.into(), pszdest.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCatBuffW<'a, P0>(pszdest: &mut [u16], pszsrc: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCatBuffW(pszdest: ::windows::core::PWSTR, pszsrc: ::windows::core::PCWSTR, cchdestbuffsize: i32) -> ::windows::core::PWSTR;
    }
    StrCatBuffW(::core::mem::transmute(pszdest.as_ptr()), pszsrc.into(), pszdest.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCatChainW<'a, P0>(pszdst: &mut [u16], ichat: u32, pszsrc: P0) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCatChainW(pszdst: ::windows::core::PWSTR, cchdst: u32, ichat: u32, pszsrc: ::windows::core::PCWSTR) -> u32;
    }
    StrCatChainW(::core::mem::transmute(pszdst.as_ptr()), pszdst.len() as _, ichat, pszsrc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCatW<'a, P0>(psz1: ::windows::core::PWSTR, psz2: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCatW(psz1: ::windows::core::PWSTR, psz2: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrCatW(::core::mem::transmute(psz1), psz2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrA<'a, P0>(pszstart: P0, wmatch: u16) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrA(pszstart: ::windows::core::PCSTR, wmatch: u16) -> ::windows::core::PSTR;
    }
    StrChrA(pszstart.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrIA<'a, P0>(pszstart: P0, wmatch: u16) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrIA(pszstart: ::windows::core::PCSTR, wmatch: u16) -> ::windows::core::PSTR;
    }
    StrChrIA(pszstart.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrIW<'a, P0>(pszstart: P0, wmatch: u16) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrIW(pszstart: ::windows::core::PCWSTR, wmatch: u16) -> ::windows::core::PWSTR;
    }
    StrChrIW(pszstart.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrNIW<'a, P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrNIW(pszstart: ::windows::core::PCWSTR, wmatch: u16, cchmax: u32) -> ::windows::core::PWSTR;
    }
    StrChrNIW(pszstart.into(), wmatch, cchmax)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrNW<'a, P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrNW(pszstart: ::windows::core::PCWSTR, wmatch: u16, cchmax: u32) -> ::windows::core::PWSTR;
    }
    StrChrNW(pszstart.into(), wmatch, cchmax)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrChrW<'a, P0>(pszstart: P0, wmatch: u16) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrChrW(pszstart: ::windows::core::PCWSTR, wmatch: u16) -> ::windows::core::PWSTR;
    }
    StrChrW(pszstart.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpCA<'a, P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpCA(pszstr1: ::windows::core::PCSTR, pszstr2: ::windows::core::PCSTR) -> i32;
    }
    StrCmpCA(pszstr1.into(), pszstr2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpCW<'a, P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpCW(pszstr1: ::windows::core::PCWSTR, pszstr2: ::windows::core::PCWSTR) -> i32;
    }
    StrCmpCW(pszstr1.into(), pszstr2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpICA<'a, P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpICA(pszstr1: ::windows::core::PCSTR, pszstr2: ::windows::core::PCSTR) -> i32;
    }
    StrCmpICA(pszstr1.into(), pszstr2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpICW<'a, P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpICW(pszstr1: ::windows::core::PCWSTR, pszstr2: ::windows::core::PCWSTR) -> i32;
    }
    StrCmpICW(pszstr1.into(), pszstr2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpIW<'a, P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpIW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR) -> i32;
    }
    StrCmpIW(psz1.into(), psz2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpLogicalW<'a, P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpLogicalW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR) -> i32;
    }
    StrCmpLogicalW(psz1.into(), psz2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNA<'a, P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNA(psz1: ::windows::core::PCSTR, psz2: ::windows::core::PCSTR, nchar: i32) -> i32;
    }
    StrCmpNA(psz1.into(), psz2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNCA<'a, P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNCA(pszstr1: ::windows::core::PCSTR, pszstr2: ::windows::core::PCSTR, nchar: i32) -> i32;
    }
    StrCmpNCA(pszstr1.into(), pszstr2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNCW<'a, P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNCW(pszstr1: ::windows::core::PCWSTR, pszstr2: ::windows::core::PCWSTR, nchar: i32) -> i32;
    }
    StrCmpNCW(pszstr1.into(), pszstr2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNIA<'a, P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNIA(psz1: ::windows::core::PCSTR, psz2: ::windows::core::PCSTR, nchar: i32) -> i32;
    }
    StrCmpNIA(psz1.into(), psz2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNICA<'a, P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNICA(pszstr1: ::windows::core::PCSTR, pszstr2: ::windows::core::PCSTR, nchar: i32) -> i32;
    }
    StrCmpNICA(pszstr1.into(), pszstr2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNICW<'a, P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNICW(pszstr1: ::windows::core::PCWSTR, pszstr2: ::windows::core::PCWSTR, nchar: i32) -> i32;
    }
    StrCmpNICW(pszstr1.into(), pszstr2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNIW<'a, P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNIW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR, nchar: i32) -> i32;
    }
    StrCmpNIW(psz1.into(), psz2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpNW<'a, P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpNW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR, nchar: i32) -> i32;
    }
    StrCmpNW(psz1.into(), psz2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCmpW<'a, P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCmpW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR) -> i32;
    }
    StrCmpW(psz1.into(), psz2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCpyNW<'a, P0>(pszdst: &mut [u16], pszsrc: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCpyNW(pszdst: ::windows::core::PWSTR, pszsrc: ::windows::core::PCWSTR, cchmax: i32) -> ::windows::core::PWSTR;
    }
    StrCpyNW(::core::mem::transmute(pszdst.as_ptr()), pszsrc.into(), pszdst.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrCpyW<'a, P0>(psz1: ::windows::core::PWSTR, psz2: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrCpyW(psz1: ::windows::core::PWSTR, psz2: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrCpyW(::core::mem::transmute(psz1), psz2.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrDupA<'a, P0>(pszsrch: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrDupA(pszsrch: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    StrDupA(pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrDupW<'a, P0>(pszsrch: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrDupW(pszsrch: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrDupW(pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatByteSize64A(qdw: i64, pszbuf: &mut [u8]) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatByteSize64A(qdw: i64, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> ::windows::core::PSTR;
    }
    StrFormatByteSize64A(qdw, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatByteSizeA(dw: u32, pszbuf: &mut [u8]) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatByteSizeA(dw: u32, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> ::windows::core::PSTR;
    }
    StrFormatByteSizeA(dw, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatByteSizeEx(ull: u64, flags: SFBS_FLAGS, pszbuf: &mut [u16]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatByteSizeEx(ull: u64, flags: SFBS_FLAGS, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> ::windows::core::HRESULT;
    }
    StrFormatByteSizeEx(ull, flags, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatByteSizeW(qdw: i64, pszbuf: &mut [u16]) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatByteSizeW(qdw: i64, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> ::windows::core::PWSTR;
    }
    StrFormatByteSizeW(qdw, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatKBSizeA(qdw: i64, pszbuf: &mut [u8]) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatKBSizeA(qdw: i64, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> ::windows::core::PSTR;
    }
    StrFormatKBSizeA(qdw, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFormatKBSizeW(qdw: i64, pszbuf: &mut [u16]) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFormatKBSizeW(qdw: i64, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> ::windows::core::PWSTR;
    }
    StrFormatKBSizeW(qdw, ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFromTimeIntervalA(pszout: &mut [u8], dwtimems: u32, digits: i32) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFromTimeIntervalA(pszout: ::windows::core::PSTR, cchmax: u32, dwtimems: u32, digits: i32) -> i32;
    }
    StrFromTimeIntervalA(::core::mem::transmute(pszout.as_ptr()), pszout.len() as _, dwtimems, digits)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrFromTimeIntervalW(pszout: &mut [u16], dwtimems: u32, digits: i32) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrFromTimeIntervalW(pszout: ::windows::core::PWSTR, cchmax: u32, dwtimems: u32, digits: i32) -> i32;
    }
    StrFromTimeIntervalW(::core::mem::transmute(pszout.as_ptr()), pszout.len() as _, dwtimems, digits)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrIsIntlEqualA<'a, P0, P1, P2>(fcasesens: P0, pszstring1: P1, pszstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrIsIntlEqualA(fcasesens: super::super::Foundation::BOOL, pszstring1: ::windows::core::PCSTR, pszstring2: ::windows::core::PCSTR, nchar: i32) -> super::super::Foundation::BOOL;
    }
    StrIsIntlEqualA(fcasesens.into(), pszstring1.into(), pszstring2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrIsIntlEqualW<'a, P0, P1, P2>(fcasesens: P0, pszstring1: P1, pszstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrIsIntlEqualW(fcasesens: super::super::Foundation::BOOL, pszstring1: ::windows::core::PCWSTR, pszstring2: ::windows::core::PCWSTR, nchar: i32) -> super::super::Foundation::BOOL;
    }
    StrIsIntlEqualW(fcasesens.into(), pszstring1.into(), pszstring2.into(), nchar)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrNCatA<'a, P0>(psz1: &mut [u8], psz2: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrNCatA(psz1: ::windows::core::PSTR, psz2: ::windows::core::PCSTR, cchmax: i32) -> ::windows::core::PSTR;
    }
    StrNCatA(::core::mem::transmute(psz1.as_ptr()), psz2.into(), psz1.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrNCatW<'a, P0>(psz1: &mut [u16], psz2: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrNCatW(psz1: ::windows::core::PWSTR, psz2: ::windows::core::PCWSTR, cchmax: i32) -> ::windows::core::PWSTR;
    }
    StrNCatW(::core::mem::transmute(psz1.as_ptr()), psz2.into(), psz1.len() as _)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrPBrkA<'a, P0, P1>(psz: P0, pszset: P1) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrPBrkA(psz: ::windows::core::PCSTR, pszset: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    StrPBrkA(psz.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrPBrkW<'a, P0, P1>(psz: P0, pszset: P1) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrPBrkW(psz: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrPBrkW(psz.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRChrA<'a, P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRChrA(pszstart: ::windows::core::PCSTR, pszend: ::windows::core::PCSTR, wmatch: u16) -> ::windows::core::PSTR;
    }
    StrRChrA(pszstart.into(), pszend.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRChrIA<'a, P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRChrIA(pszstart: ::windows::core::PCSTR, pszend: ::windows::core::PCSTR, wmatch: u16) -> ::windows::core::PSTR;
    }
    StrRChrIA(pszstart.into(), pszend.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRChrIW<'a, P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRChrIW(pszstart: ::windows::core::PCWSTR, pszend: ::windows::core::PCWSTR, wmatch: u16) -> ::windows::core::PWSTR;
    }
    StrRChrIW(pszstart.into(), pszend.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRChrW<'a, P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRChrW(pszstart: ::windows::core::PCWSTR, pszend: ::windows::core::PCWSTR, wmatch: u16) -> ::windows::core::PWSTR;
    }
    StrRChrW(pszstart.into(), pszend.into(), wmatch)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRStrIA<'a, P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRStrIA(pszsource: ::windows::core::PCSTR, pszlast: ::windows::core::PCSTR, pszsrch: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    StrRStrIA(pszsource.into(), pszlast.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrRStrIW<'a, P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRStrIW(pszsource: ::windows::core::PCWSTR, pszlast: ::windows::core::PCWSTR, pszsrch: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrRStrIW(pszsource.into(), pszlast.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBSTR(pstr: *mut Common::STRRET, pidl: ::core::option::Option<*const Common::ITEMIDLIST>, pbstr: *mut ::windows::core::BSTR) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRetToBSTR(pstr: *mut Common::STRRET, pidl: *const Common::ITEMIDLIST, pbstr: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT;
    }
    StrRetToBSTR(::core::mem::transmute(pstr), ::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbstr)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufA(pstr: *mut Common::STRRET, pidl: ::core::option::Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u8]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRetToBufA(pstr: *mut Common::STRRET, pidl: *const Common::ITEMIDLIST, pszbuf: ::windows::core::PSTR, cchbuf: u32) -> ::windows::core::HRESULT;
    }
    StrRetToBufA(::core::mem::transmute(pstr), ::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufW(pstr: *mut Common::STRRET, pidl: ::core::option::Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u16]) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRetToBufW(pstr: *mut Common::STRRET, pidl: *const Common::ITEMIDLIST, pszbuf: ::windows::core::PWSTR, cchbuf: u32) -> ::windows::core::HRESULT;
    }
    StrRetToBufW(::core::mem::transmute(pstr), ::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pszbuf.as_ptr()), pszbuf.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrA(pstr: *mut Common::STRRET, pidl: ::core::option::Option<*const Common::ITEMIDLIST>, ppsz: *mut ::windows::core::PSTR) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRetToStrA(pstr: *mut Common::STRRET, pidl: *const Common::ITEMIDLIST, ppsz: *mut ::windows::core::PSTR) -> ::windows::core::HRESULT;
    }
    StrRetToStrA(::core::mem::transmute(pstr), ::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ppsz)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_UI_Shell_Common\"`*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrW(pstr: *mut Common::STRRET, pidl: ::core::option::Option<*const Common::ITEMIDLIST>, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrRetToStrW(pstr: *mut Common::STRRET, pidl: *const Common::ITEMIDLIST, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT;
    }
    StrRetToStrW(::core::mem::transmute(pstr), ::core::mem::transmute(pidl.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ppsz)).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrSpnA<'a, P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrSpnA(psz: ::windows::core::PCSTR, pszset: ::windows::core::PCSTR) -> i32;
    }
    StrSpnA(psz.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrSpnW<'a, P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrSpnW(psz: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR) -> i32;
    }
    StrSpnW(psz.into(), pszset.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrA<'a, P0, P1>(pszfirst: P0, pszsrch: P1) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrA(pszfirst: ::windows::core::PCSTR, pszsrch: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    StrStrA(pszfirst.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrIA<'a, P0, P1>(pszfirst: P0, pszsrch: P1) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrIA(pszfirst: ::windows::core::PCSTR, pszsrch: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    StrStrIA(pszfirst.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrIW<'a, P0, P1>(pszfirst: P0, pszsrch: P1) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrIW(pszfirst: ::windows::core::PCWSTR, pszsrch: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrStrIW(pszfirst.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrNIW<'a, P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrNIW(pszfirst: ::windows::core::PCWSTR, pszsrch: ::windows::core::PCWSTR, cchmax: u32) -> ::windows::core::PWSTR;
    }
    StrStrNIW(pszfirst.into(), pszsrch.into(), cchmax)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrNW<'a, P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrNW(pszfirst: ::windows::core::PCWSTR, pszsrch: ::windows::core::PCWSTR, cchmax: u32) -> ::windows::core::PWSTR;
    }
    StrStrNW(pszfirst.into(), pszsrch.into(), cchmax)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrStrW<'a, P0, P1>(pszfirst: P0, pszsrch: P1) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrStrW(pszfirst: ::windows::core::PCWSTR, pszsrch: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    StrStrW(pszfirst.into(), pszsrch.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrToInt64ExA<'a, P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToInt64ExA(pszstring: ::windows::core::PCSTR, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL;
    }
    StrToInt64ExA(pszstring.into(), dwflags, ::core::mem::transmute(pllret))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrToInt64ExW<'a, P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToInt64ExW(pszstring: ::windows::core::PCWSTR, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL;
    }
    StrToInt64ExW(pszstring.into(), dwflags, ::core::mem::transmute(pllret))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrToIntA<'a, P0>(pszsrc: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToIntA(pszsrc: ::windows::core::PCSTR) -> i32;
    }
    StrToIntA(pszsrc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrToIntExA<'a, P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToIntExA(pszstring: ::windows::core::PCSTR, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL;
    }
    StrToIntExA(pszstring.into(), dwflags, ::core::mem::transmute(piret))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrToIntExW<'a, P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToIntExW(pszstring: ::windows::core::PCWSTR, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL;
    }
    StrToIntExW(pszstring.into(), dwflags, ::core::mem::transmute(piret))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn StrToIntW<'a, P0>(pszsrc: P0) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrToIntW(pszsrc: ::windows::core::PCWSTR) -> i32;
    }
    StrToIntW(pszsrc.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrTrimA<'a, P0>(psz: ::windows::core::PSTR, psztrimchars: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrTrimA(psz: ::windows::core::PSTR, psztrimchars: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    StrTrimA(::core::mem::transmute(psz), psztrimchars.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StrTrimW<'a, P0>(psz: ::windows::core::PWSTR, psztrimchars: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn StrTrimW(psz: ::windows::core::PWSTR, psztrimchars: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    StrTrimW(::core::mem::transmute(psz), psztrimchars.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UnloadUserProfile<'a, P0, P1>(htoken: P0, hprofile: P1) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    P1: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UnloadUserProfile(htoken: super::super::Foundation::HANDLE, hprofile: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
    }
    UnloadUserProfile(htoken.into(), hprofile.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UnregisterAppConstrainedChangeNotification(registration: *mut _APPCONSTRAIN_REGISTRATION) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UnregisterAppConstrainedChangeNotification(registration: *mut _APPCONSTRAIN_REGISTRATION);
    }
    UnregisterAppConstrainedChangeNotification(::core::mem::transmute(registration))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UnregisterAppStateChangeNotification(registration: *mut _APPSTATE_REGISTRATION) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UnregisterAppStateChangeNotification(registration: *mut _APPSTATE_REGISTRATION);
    }
    UnregisterAppStateChangeNotification(::core::mem::transmute(registration))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UnregisterScaleChangeEvent(dwcookie: usize) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UnregisterScaleChangeEvent(dwcookie: usize) -> ::windows::core::HRESULT;
    }
    UnregisterScaleChangeEvent(dwcookie).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlApplySchemeA<'a, P0>(pszin: P0, pszout: ::windows::core::PSTR, pcchout: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlApplySchemeA(pszin: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlApplySchemeA(pszin.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlApplySchemeW<'a, P0>(pszin: P0, pszout: ::windows::core::PWSTR, pcchout: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlApplySchemeW(pszin: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlApplySchemeW(pszin.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCanonicalizeA<'a, P0>(pszurl: P0, pszcanonicalized: ::windows::core::PSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCanonicalizeA(pszurl: ::windows::core::PCSTR, pszcanonicalized: ::windows::core::PSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCanonicalizeA(pszurl.into(), ::core::mem::transmute(pszcanonicalized), ::core::mem::transmute(pcchcanonicalized), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCanonicalizeW<'a, P0>(pszurl: P0, pszcanonicalized: ::windows::core::PWSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCanonicalizeW(pszurl: ::windows::core::PCWSTR, pszcanonicalized: ::windows::core::PWSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCanonicalizeW(pszurl.into(), ::core::mem::transmute(pszcanonicalized), ::core::mem::transmute(pcchcanonicalized), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCombineA<'a, P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: ::windows::core::PSTR, pcchcombined: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCombineA(pszbase: ::windows::core::PCSTR, pszrelative: ::windows::core::PCSTR, pszcombined: ::windows::core::PSTR, pcchcombined: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCombineA(pszbase.into(), pszrelative.into(), ::core::mem::transmute(pszcombined), ::core::mem::transmute(pcchcombined), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCombineW<'a, P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: ::windows::core::PWSTR, pcchcombined: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCombineW(pszbase: ::windows::core::PCWSTR, pszrelative: ::windows::core::PCWSTR, pszcombined: ::windows::core::PWSTR, pcchcombined: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCombineW(pszbase.into(), pszrelative.into(), ::core::mem::transmute(pszcombined), ::core::mem::transmute(pcchcombined), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlCompareA<'a, P0, P1, P2>(psz1: P0, psz2: P1, fignoreslash: P2) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCompareA(psz1: ::windows::core::PCSTR, psz2: ::windows::core::PCSTR, fignoreslash: super::super::Foundation::BOOL) -> i32;
    }
    UrlCompareA(psz1.into(), psz2.into(), fignoreslash.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlCompareW<'a, P0, P1, P2>(psz1: P0, psz2: P1, fignoreslash: P2) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCompareW(psz1: ::windows::core::PCWSTR, psz2: ::windows::core::PCWSTR, fignoreslash: super::super::Foundation::BOOL) -> i32;
    }
    UrlCompareW(psz1.into(), psz2.into(), fignoreslash.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCreateFromPathA<'a, P0>(pszpath: P0, pszurl: ::windows::core::PSTR, pcchurl: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCreateFromPathA(pszpath: ::windows::core::PCSTR, pszurl: ::windows::core::PSTR, pcchurl: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCreateFromPathA(pszpath.into(), ::core::mem::transmute(pszurl), ::core::mem::transmute(pcchurl), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlCreateFromPathW<'a, P0>(pszpath: P0, pszurl: ::windows::core::PWSTR, pcchurl: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlCreateFromPathW(pszpath: ::windows::core::PCWSTR, pszurl: ::windows::core::PWSTR, pcchurl: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlCreateFromPathW(pszpath.into(), ::core::mem::transmute(pszurl), ::core::mem::transmute(pcchurl), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlEscapeA<'a, P0>(pszurl: P0, pszescaped: ::windows::core::PSTR, pcchescaped: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlEscapeA(pszurl: ::windows::core::PCSTR, pszescaped: ::windows::core::PSTR, pcchescaped: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlEscapeA(pszurl.into(), ::core::mem::transmute(pszescaped), ::core::mem::transmute(pcchescaped), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlEscapeW<'a, P0>(pszurl: P0, pszescaped: ::windows::core::PWSTR, pcchescaped: *mut u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlEscapeW(pszurl: ::windows::core::PCWSTR, pszescaped: ::windows::core::PWSTR, pcchescaped: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlEscapeW(pszurl.into(), ::core::mem::transmute(pszescaped), ::core::mem::transmute(pcchescaped), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlFixupW<'a, P0>(pcszurl: P0, psztranslatedurl: &mut [u16]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlFixupW(pcszurl: ::windows::core::PCWSTR, psztranslatedurl: ::windows::core::PWSTR, cchmax: u32) -> ::windows::core::HRESULT;
    }
    UrlFixupW(pcszurl.into(), ::core::mem::transmute(psztranslatedurl.as_ptr()), psztranslatedurl.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlGetLocationA<'a, P0>(pszurl: P0) -> ::windows::core::PSTR
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlGetLocationA(pszurl: ::windows::core::PCSTR) -> ::windows::core::PSTR;
    }
    UrlGetLocationA(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlGetLocationW<'a, P0>(pszurl: P0) -> ::windows::core::PWSTR
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlGetLocationW(pszurl: ::windows::core::PCWSTR) -> ::windows::core::PWSTR;
    }
    UrlGetLocationW(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlGetPartA<'a, P0>(pszin: P0, pszout: ::windows::core::PSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlGetPartA(pszin: ::windows::core::PCSTR, pszout: ::windows::core::PSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlGetPartA(pszin.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout), dwpart, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlGetPartW<'a, P0>(pszin: P0, pszout: ::windows::core::PWSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlGetPartW(pszin: ::windows::core::PCWSTR, pszout: ::windows::core::PWSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlGetPartW(pszin.into(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout), dwpart, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlHashA<'a, P0>(pszurl: P0, pbhash: &mut [u8]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlHashA(pszurl: ::windows::core::PCSTR, pbhash: *mut u8, cbhash: u32) -> ::windows::core::HRESULT;
    }
    UrlHashA(pszurl.into(), ::core::mem::transmute(pbhash.as_ptr()), pbhash.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlHashW<'a, P0>(pszurl: P0, pbhash: &mut [u8]) -> ::windows::core::Result<()>
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlHashW(pszurl: ::windows::core::PCWSTR, pbhash: *mut u8, cbhash: u32) -> ::windows::core::HRESULT;
    }
    UrlHashW(pszurl.into(), ::core::mem::transmute(pbhash.as_ptr()), pbhash.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsA<'a, P0>(pszurl: P0, urlis: URLIS) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsA(pszurl: ::windows::core::PCSTR, urlis: URLIS) -> super::super::Foundation::BOOL;
    }
    UrlIsA(pszurl.into(), urlis)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsNoHistoryA<'a, P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsNoHistoryA(pszurl: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    UrlIsNoHistoryA(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsNoHistoryW<'a, P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsNoHistoryW(pszurl: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    UrlIsNoHistoryW(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsOpaqueA<'a, P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsOpaqueA(pszurl: ::windows::core::PCSTR) -> super::super::Foundation::BOOL;
    }
    UrlIsOpaqueA(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsOpaqueW<'a, P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsOpaqueW(pszurl: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    UrlIsOpaqueW(pszurl.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn UrlIsW<'a, P0>(pszurl: P0, urlis: URLIS) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlIsW(pszurl: ::windows::core::PCWSTR, urlis: URLIS) -> super::super::Foundation::BOOL;
    }
    UrlIsW(pszurl.into(), urlis)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlUnescapeA(pszurl: ::windows::core::PSTR, pszunescaped: ::windows::core::PSTR, pcchunescaped: ::core::option::Option<*mut u32>, dwflags: u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlUnescapeA(pszurl: ::windows::core::PSTR, pszunescaped: ::windows::core::PSTR, pcchunescaped: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlUnescapeA(::core::mem::transmute(pszurl), ::core::mem::transmute(pszunescaped), ::core::mem::transmute(pcchunescaped.unwrap_or(::std::ptr::null_mut())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn UrlUnescapeW(pszurl: ::windows::core::PWSTR, pszunescaped: ::windows::core::PWSTR, pcchunescaped: ::core::option::Option<*mut u32>, dwflags: u32) -> ::windows::core::Result<()> {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn UrlUnescapeW(pszurl: ::windows::core::PWSTR, pszunescaped: ::windows::core::PWSTR, pcchunescaped: *mut u32, dwflags: u32) -> ::windows::core::HRESULT;
    }
    UrlUnescapeW(::core::mem::transmute(pszurl), ::core::mem::transmute(pszunescaped), ::core::mem::transmute(pcchunescaped.unwrap_or(::std::ptr::null_mut())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn WhichPlatform() -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WhichPlatform() -> u32;
    }
    WhichPlatform()
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Win32DeleteFile<'a, P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn Win32DeleteFile(pszpath: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
    }
    Win32DeleteFile(pszpath.into())
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHelpA<'a, P0, P1>(hwndmain: P0, lpszhelp: P1, ucommand: u32, dwdata: usize) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHelpA(hwndmain: super::super::Foundation::HWND, lpszhelp: ::windows::core::PCSTR, ucommand: u32, dwdata: usize) -> super::super::Foundation::BOOL;
    }
    WinHelpA(hwndmain.into(), lpszhelp.into(), ucommand, dwdata)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHelpW<'a, P0, P1>(hwndmain: P0, lpszhelp: P1, ucommand: u32, dwdata: usize) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<super::super::Foundation::HWND>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHelpW(hwndmain: super::super::Foundation::HWND, lpszhelp: ::windows::core::PCWSTR, ucommand: u32, dwdata: usize) -> super::super::Foundation::BOOL;
    }
    WinHelpW(hwndmain.into(), lpszhelp.into(), ucommand, dwdata)
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WriteCabinetState(pcs: *const CABINETSTATE) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WriteCabinetState(pcs: *const CABINETSTATE) -> super::super::Foundation::BOOL;
    }
    WriteCabinetState(::core::mem::transmute(pcs))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn wvnsprintfA<'a, P0>(pszdest: &mut [u8], pszfmt: P0, arglist: *const i8) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn wvnsprintfA(pszdest: ::windows::core::PSTR, cchdest: i32, pszfmt: ::windows::core::PCSTR, arglist: *const i8) -> i32;
    }
    wvnsprintfA(::core::mem::transmute(pszdest.as_ptr()), pszdest.len() as _, pszfmt.into(), ::core::mem::transmute(arglist))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[inline]
pub unsafe fn wvnsprintfW<'a, P0>(pszdest: &mut [u16], pszfmt: P0, arglist: *const i8) -> i32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn wvnsprintfW(pszdest: ::windows::core::PWSTR, cchdest: i32, pszfmt: ::windows::core::PCWSTR, arglist: *const i8) -> i32;
    }
    wvnsprintfW(::core::mem::transmute(pszdest.as_ptr()), pszdest.len() as _, pszfmt.into(), ::core::mem::transmute(arglist))
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct CIE4ConnectionPoint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl CIE4ConnectionPoint {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionInterface(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetConnectionInterface)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionPointContainer(&self) -> ::windows::core::Result<super::super::System::Com::IConnectionPointContainer> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetConnectionPointContainer)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IConnectionPointContainer>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Advise<'a, P0>(&self, punksink: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Advise)(::windows::core::Vtable::as_raw(self), punksink.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Unadvise)(::windows::core::Vtable::as_raw(self), dwcookie).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumConnections(&self) -> ::windows::core::Result<super::super::System::Com::IEnumConnections> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.EnumConnections)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IEnumConnections>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DoInvokeIE4(&self, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DoInvokeIE4)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pf), ::core::mem::transmute(ppv), dispid, ::core::mem::transmute(pdispparams)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn DoInvokePIDLIE4<'a, P0>(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).DoInvokePIDLIE4)(::windows::core::Vtable::as_raw(self), dispid, ::core::mem::transmute(pidl), fcancancel.into()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(CIE4ConnectionPoint, ::windows::core::IUnknown, super::super::System::Com::IConnectionPoint);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for CIE4ConnectionPoint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for CIE4ConnectionPoint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for CIE4ConnectionPoint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for CIE4ConnectionPoint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CIE4ConnectionPoint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for CIE4ConnectionPoint {
    type Vtable = CIE4ConnectionPoint_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for CIE4ConnectionPoint {
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct CIE4ConnectionPoint_Vtbl {
    pub base__: super::super::System::Com::IConnectionPoint_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DoInvokeIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DoInvokeIE4: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub DoInvokePIDLIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    DoInvokePIDLIE4: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DFConstraint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DFConstraint {
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Value(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Value)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DFConstraint, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DFConstraint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DFConstraint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DFConstraint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DFConstraint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFConstraint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DFConstraint {
    type Vtable = DFConstraint_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DFConstraint {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4a3df050_23bd_11d2_939f_00a0c91eedba);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DFConstraint_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Value: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pv: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Value: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellFolderViewEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DShellFolderViewEvents, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellFolderViewEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellFolderViewEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellFolderViewEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellFolderViewEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DShellFolderViewEvents {
    type Vtable = DShellFolderViewEvents_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellFolderViewEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62112aa2_ebe4_11cf_a5fb_0020afe7292d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellFolderViewEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellNameSpaceEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DShellNameSpaceEvents, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellNameSpaceEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellNameSpaceEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellNameSpaceEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellNameSpaceEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DShellNameSpaceEvents {
    type Vtable = DShellNameSpaceEvents_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellNameSpaceEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55136806_b2de_11d1_b9f2_00a0c98bc547);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellNameSpaceEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellWindowsEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DShellWindowsEvents, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellWindowsEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellWindowsEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellWindowsEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellWindowsEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DShellWindowsEvents {
    type Vtable = DShellWindowsEvents_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellWindowsEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe4106e0_399a_11d0_a48c_00a0c90a8f39);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellWindowsEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DWebBrowserEvents, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DWebBrowserEvents {
    type Vtable = DWebBrowserEvents_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeab22ac2_30c1_11cf_a7eb_0000c05bae0b);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DWebBrowserEvents2, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DWebBrowserEvents2 {
    type Vtable = DWebBrowserEvents2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34a715a0_6587_11d0_924a_0020afc7ac4d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder {
    pub unsafe fn Title(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Title)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ParentFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Items)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseName(&self, bname: &::windows::core::BSTR) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ParseName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0>(&self, bname: &::windows::core::BSTR, voptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).NewFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).MoveHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).CopyHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<::windows::core::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDetailsOf)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(Folder, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for Folder {
    type Vtable = Folder_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbbcbde60_c3ff_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Title: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParentFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsf: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParentFolder: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Items: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Items: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<::windows::core::BSTR>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub NewFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<::windows::core::BSTR>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    NewFolder: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub MoveHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    MoveHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CopyHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CopyHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetDetailsOf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, icolumn: i32, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetDetailsOf: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder2 {
    pub unsafe fn Title(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Title)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ParentFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Items)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseName(&self, bname: &::windows::core::BSTR) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ParseName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0>(&self, bname: &::windows::core::BSTR, voptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.NewFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.MoveHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.CopyHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<::windows::core::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetDetailsOf)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Self_)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OfflineStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Synchronize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HaveToShowWebViewBarricade)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DismissedWebViewBarricade)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(Folder2, ::windows::core::IUnknown, super::super::System::Com::IDispatch, Folder);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for Folder2 {
    type Vtable = Folder2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0d2d8ef_3890_11d2_bf8b_00c04fb93661);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder2_Vtbl {
    pub base__: Folder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Self_: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfi: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Self_: usize,
    pub OfflineStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    pub Synchronize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub HaveToShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbhavetoshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub DismissedWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder3 {
    pub unsafe fn Title(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Title)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.ParentFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Items)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseName(&self, bname: &::windows::core::BSTR) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.ParseName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, P0>(&self, bname: &::windows::core::BSTR, voptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.NewFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bname), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.MoveHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, P0, P1>(&self, vitem: P0, voptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.CopyHere)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), voptions.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, P0>(&self, vitem: P0, icolumn: i32) -> ::windows::core::Result<::windows::core::BSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetDetailsOf)(::windows::core::Vtable::as_raw(self), vitem.into().abi(), icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Self_)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.OfflineStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Synchronize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.HaveToShowWebViewBarricade)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.DismissedWebViewBarricade)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ShowWebViewBarricade)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn SetShowWebViewBarricade(&self, bshowwebviewbarricade: i16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetShowWebViewBarricade)(::windows::core::Vtable::as_raw(self), bshowwebviewbarricade).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(Folder3, ::windows::core::IUnknown, super::super::System::Com::IDispatch, Folder, Folder2);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for Folder3 {
    type Vtable = Folder3_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ae5f64_c4d7_4d7f_9307_4d24ee54b841);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder3_Vtbl {
    pub base__: Folder2_Vtbl,
    pub ShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub SetShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bshowwebviewbarricade: i16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    pub unsafe fn SetName(&self, bs: &::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bs)).ok()
    }
    pub unsafe fn Path(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Path)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetLink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsLink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsFileSystem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsBrowsable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ModifyDate)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetModifyDate)(::windows::core::Vtable::as_raw(self), dt).ok()
    }
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Size)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Type(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Type)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Verbs)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, P0>(&self, vverb: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).InvokeVerb)(::windows::core::Vtable::as_raw(self), vverb.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItem, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItem {
    type Vtable = FolderItem_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfac32c80_cbe4_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bs: ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub Path: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetLink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFolder: usize,
    pub IsLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFileSystem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsBrowsable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub ModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdt: *mut f64) -> ::windows::core::HRESULT,
    pub SetModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dt: f64) -> ::windows::core::HRESULT,
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerb: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerb: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem2 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    pub unsafe fn SetName(&self, bs: &::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bs)).ok()
    }
    pub unsafe fn Path(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Path)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetLink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsLink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsFolder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsFileSystem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsBrowsable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ModifyDate)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetModifyDate)(::windows::core::Vtable::as_raw(self), dt).ok()
    }
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Size)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn Type(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Type)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Verbs)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, P0>(&self, vverb: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.InvokeVerb)(::windows::core::Vtable::as_raw(self), vverb.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).InvokeVerbEx)(::windows::core::Vtable::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ExtendedProperty(&self, bstrpropname: &::windows::core::BSTR) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ExtendedProperty)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute_copy(bstrpropname), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItem2, ::windows::core::IUnknown, super::super::System::Com::IDispatch, FolderItem);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItem2 {
    type Vtable = FolderItem2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc817aa_92b8_11d1_b075_00c04fc33aa5);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem2_Vtbl {
    pub base__: FolderItem_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ExtendedProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrpropname: ::core::mem::ManuallyDrop<::windows::core::BSTR>, pvret: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ExtendedProperty: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerb(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerb {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    pub unsafe fn DoIt(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DoIt)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItemVerb, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerb {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerb {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerb {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerb {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerb").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItemVerb {
    type Vtable = FolderItemVerb_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerb {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x08ec3e00_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerb_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub DoIt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerbs(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerbs {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Count)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItemVerb>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Item)(::windows::core::Vtable::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerb>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self)._NewEnum)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItemVerbs, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerbs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerbs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerbs {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerbs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerbs").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItemVerbs {
    type Vtable = FolderItemVerbs_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerbs {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f8352c0_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerbs_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Count)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Item)(::windows::core::Vtable::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self)._NewEnum)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItems, ::windows::core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItems {
    type Vtable = FolderItems_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x744129e0_cbe5_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems2 {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Count)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Item)(::windows::core::Vtable::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__._NewEnum)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).InvokeVerbEx)(::windows::core::Vtable::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItems2, ::windows::core::IUnknown, super::super::System::Com::IDispatch, FolderItems);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItems2 {
    type Vtable = FolderItems2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc94f0ad0_f363_11d2_a327_00c04f8eec7f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems2_Vtbl {
    pub base__: FolderItems_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems3 {
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Count)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Application)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Parent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, P0>(&self, index: P0) -> ::windows::core::Result<FolderItem>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.Item)(::windows::core::Vtable::as_raw(self), index.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__._NewEnum)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, P0, P1>(&self, vverb: P0, vargs: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).base__.InvokeVerbEx)(::windows::core::Vtable::as_raw(self), vverb.into().abi(), vargs.into().abi()).ok()
    }
    pub unsafe fn Filter(&self, grfflags: i32, bstrfilespec: &::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Filter)(::windows::core::Vtable::as_raw(self), grfflags, ::core::mem::transmute_copy(bstrfilespec)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Verbs)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<FolderItemVerbs>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(FolderItems3, ::windows::core::IUnknown, super::super::System::Com::IDispatch, FolderItems, FolderItems2);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for FolderItems3 {
    type Vtable = FolderItems3_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeaa7c309_bbec_49d5_821d_64d966cb667f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems3_Vtbl {
    pub base__: FolderItems2_Vtbl,
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, grfflags: i32, bstrfilespec: ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IACList(::windows::core::IUnknown);
impl IACList {
    pub unsafe fn Expand<'a, P0>(&self, pszexpand: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).Expand)(::windows::core::Vtable::as_raw(self), pszexpand.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IACList, ::windows::core::IUnknown);
impl ::core::clone::Clone for IACList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList {}
impl ::core::fmt::Debug for IACList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IACList {
    type Vtable = IACList_Vtbl;
}
unsafe impl ::windows::core::Interface for IACList {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77a130b0_94fd_11d0_a544_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Expand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszexpand: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IACList2(::windows::core::IUnknown);
impl IACList2 {
    pub unsafe fn Expand<'a, P0>(&self, pszexpand: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.Expand)(::windows::core::Vtable::as_raw(self), pszexpand.into()).ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetOptions)(::windows::core::Vtable::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOptions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IACList2, ::windows::core::IUnknown, IACList);
impl ::core::clone::Clone for IACList2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList2 {}
impl ::core::fmt::Debug for IACList2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IACList2 {
    type Vtable = IACList2_Vtbl;
}
unsafe impl ::windows::core::Interface for IACList2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x470141a0_5186_11d2_bbb6_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList2_Vtbl {
    pub base__: IACList_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibilityDockingService(::windows::core::IUnknown);
impl IAccessibilityDockingService {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableSize<'a, P0>(&self, hmonitor: P0, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Vtable::vtable(self).GetAvailableSize)(::windows::core::Vtable::as_raw(self), hmonitor.into(), ::core::mem::transmute(pcxfixed), ::core::mem::transmute(pcymax)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn DockWindow<'a, P0, P1, P2>(&self, hwnd: P0, hmonitor: P1, cyrequested: u32, pcallback: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IAccessibilityDockingServiceCallback>>,
    {
        (::windows::core::Vtable::vtable(self).DockWindow)(::windows::core::Vtable::as_raw(self), hwnd.into(), hmonitor.into(), cyrequested, pcallback.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UndockWindow<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).UndockWindow)(::windows::core::Vtable::as_raw(self), hwnd.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IAccessibilityDockingService, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAccessibilityDockingService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingService {}
impl ::core::fmt::Debug for IAccessibilityDockingService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAccessibilityDockingService {
    type Vtable = IAccessibilityDockingService_Vtbl;
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingService {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8849dc22_cedf_4c95_998d_051419dd3f76);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingService_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub DockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    DockWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub UndockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UndockWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibilityDockingServiceCallback(::windows::core::IUnknown);
impl IAccessibilityDockingServiceCallback {
    pub unsafe fn Undocked(&self, undockreason: UNDOCK_REASON) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Undocked)(::windows::core::Vtable::as_raw(self), undockreason).ok()
    }
}
::windows::core::interface_hierarchy!(IAccessibilityDockingServiceCallback, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAccessibilityDockingServiceCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingServiceCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingServiceCallback {}
impl ::core::fmt::Debug for IAccessibilityDockingServiceCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingServiceCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAccessibilityDockingServiceCallback {
    type Vtable = IAccessibilityDockingServiceCallback_Vtbl;
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingServiceCallback {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x157733fd_a592_42e5_b594_248468c5a81b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingServiceCallback_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Undocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, undockreason: UNDOCK_REASON) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAccessibleObject(::windows::core::IUnknown);
impl IAccessibleObject {
    pub unsafe fn SetAccessibleName<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAccessibleName)(::windows::core::Vtable::as_raw(self), pszname.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IAccessibleObject, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAccessibleObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibleObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibleObject {}
impl ::core::fmt::Debug for IAccessibleObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibleObject").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAccessibleObject {
    type Vtable = IAccessibleObject_Vtbl;
}
unsafe impl ::windows::core::Interface for IAccessibleObject {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x95a391c5_9ed4_4c28_8401_ab9e06719e11);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleObject_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetAccessibleName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IActionProgress(::windows::core::IUnknown);
impl IActionProgress {
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Begin)(::windows::core::Vtable::as_raw(self), action, flags).ok()
    }
    pub unsafe fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateProgress)(::windows::core::Vtable::as_raw(self), ulcompleted, ultotal).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateText<'a, P0, P1>(&self, sptext: SPTEXT, psztext: P0, fmaycompact: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).UpdateText)(::windows::core::Vtable::as_raw(self), sptext, psztext.into(), fmaycompact.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCancel(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryCancel)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ResetCancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ResetCancel)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn End(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).End)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IActionProgress, ::windows::core::IUnknown);
impl ::core::clone::Clone for IActionProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgress {}
impl ::core::fmt::Debug for IActionProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IActionProgress {
    type Vtable = IActionProgress_Vtbl;
}
unsafe impl ::windows::core::Interface for IActionProgress {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1173_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgress_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Begin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, action: SPACTION, flags: u32) -> ::windows::core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcompleted: u64, ultotal: u64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UpdateText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sptext: SPTEXT, psztext: ::windows::core::PCWSTR, fmaycompact: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UpdateText: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfcancelled: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryCancel: usize,
    pub ResetCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub End: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IActionProgressDialog(::windows::core::IUnknown);
impl IActionProgressDialog {
    pub unsafe fn Initialize<'a, P0, P1>(&self, flags: u32, psztitle: P0, pszcancel: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), flags, psztitle.into(), pszcancel.into()).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Stop)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IActionProgressDialog, ::windows::core::IUnknown);
impl ::core::clone::Clone for IActionProgressDialog {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgressDialog {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgressDialog {}
impl ::core::fmt::Debug for IActionProgressDialog {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgressDialog").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IActionProgressDialog {
    type Vtable = IActionProgressDialog_Vtbl;
}
unsafe impl ::windows::core::Interface for IActionProgressDialog {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1172_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgressDialog_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, psztitle: ::windows::core::PCWSTR, pszcancel: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppActivationUIInfo(::windows::core::IUnknown);
impl IAppActivationUIInfo {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMonitor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HMONITOR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInvokePoint(&self) -> ::windows::core::Result<super::super::Foundation::POINT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetInvokePoint)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::POINT>(result__)
    }
    pub unsafe fn GetShowCommand(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetShowCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetShowUI(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetShowUI)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetKeyState(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetKeyState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IAppActivationUIInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAppActivationUIInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppActivationUIInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppActivationUIInfo {}
impl ::core::fmt::Debug for IAppActivationUIInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppActivationUIInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAppActivationUIInfo {
    type Vtable = IAppActivationUIInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IAppActivationUIInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabad189d_9fa3_4278_b3ca_8ca448a88dcb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppActivationUIInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetInvokePoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::POINT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetInvokePoint: usize,
    pub GetShowCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetShowUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetShowUI: usize,
    pub GetKeyState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppPublisher(::windows::core::IUnknown);
impl IAppPublisher {
    pub unsafe fn GetNumberOfCategories(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetNumberOfCategories)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetCategories(&self) -> ::windows::core::Result<APPCATEGORYINFOLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCategories)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<APPCATEGORYINFOLIST>(result__)
    }
    pub unsafe fn GetNumberOfApps(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetNumberOfApps)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn EnumApps(&self, pappcategoryid: *const ::windows::core::GUID) -> ::windows::core::Result<IEnumPublishedApps> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumApps)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pappcategoryid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumPublishedApps>(result__)
    }
}
::windows::core::interface_hierarchy!(IAppPublisher, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAppPublisher {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppPublisher {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppPublisher {}
impl ::core::fmt::Debug for IAppPublisher {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppPublisher").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAppPublisher {
    type Vtable = IAppPublisher_Vtbl;
}
unsafe impl ::windows::core::Interface for IAppPublisher {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x07250a10_9cf9_11d1_9076_006008059382);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppPublisher_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetNumberOfCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcat: *mut u32) -> ::windows::core::HRESULT,
    pub GetCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategorylist: *mut APPCATEGORYINFOLIST) -> ::windows::core::HRESULT,
    pub GetNumberOfApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwapps: *mut u32) -> ::windows::core::HRESULT,
    pub EnumApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategoryid: *const ::windows::core::GUID, ppepa: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppVisibility(::windows::core::IUnknown);
impl IAppVisibility {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor<'a, P0>(&self, hmonitor: P0) -> ::windows::core::Result<MONITOR_APP_VISIBILITY>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetAppVisibilityOnMonitor)(::windows::core::Vtable::as_raw(self), hmonitor.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<MONITOR_APP_VISIBILITY>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsLauncherVisible(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsLauncherVisible)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Advise<'a, P0>(&self, pcallback: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IAppVisibilityEvents>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Advise)(::windows::core::Vtable::as_raw(self), pcallback.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Unadvise)(::windows::core::Vtable::as_raw(self), dwcookie).ok()
    }
}
::windows::core::interface_hierarchy!(IAppVisibility, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAppVisibility {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibility {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibility {}
impl ::core::fmt::Debug for IAppVisibility {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibility").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAppVisibility {
    type Vtable = IAppVisibility_Vtbl;
}
unsafe impl ::windows::core::Interface for IAppVisibility {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2246ea2d_caea_4444_a3c4_6de827e44313);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibility_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAppVisibilityOnMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pmode: *mut MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAppVisibilityOnMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsLauncherVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfvisible: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsLauncherVisible: usize,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAppVisibilityEvents(::windows::core::IUnknown);
impl IAppVisibilityEvents {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged<'a, P0>(&self, hmonitor: P0, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Vtable::vtable(self).AppVisibilityOnMonitorChanged)(::windows::core::Vtable::as_raw(self), hmonitor.into(), previousmode, currentmode).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LauncherVisibilityChange<'a, P0>(&self, currentvisiblestate: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).LauncherVisibilityChange)(::windows::core::Vtable::as_raw(self), currentvisiblestate.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IAppVisibilityEvents, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAppVisibilityEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibilityEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibilityEvents {}
impl ::core::fmt::Debug for IAppVisibilityEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibilityEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAppVisibilityEvents {
    type Vtable = IAppVisibilityEvents_Vtbl;
}
unsafe impl ::windows::core::Interface for IAppVisibilityEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6584ce6b_7d82_49c2_89c9_c6bc02ba8c38);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibilityEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub AppVisibilityOnMonitorChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    AppVisibilityOnMonitorChanged: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub LauncherVisibilityChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, currentvisiblestate: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LauncherVisibilityChange: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationActivationManager(::windows::core::IUnknown);
impl IApplicationActivationManager {
    pub unsafe fn ActivateApplication<'a, P0, P1>(&self, appusermodelid: P0, arguments: P1, options: ACTIVATEOPTIONS) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ActivateApplication)(::windows::core::Vtable::as_raw(self), appusermodelid.into(), arguments.into(), options, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn ActivateForFile<'a, P0, P1, P2>(&self, appusermodelid: P0, itemarray: P1, verb: P2) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellItemArray>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ActivateForFile)(::windows::core::Vtable::as_raw(self), appusermodelid.into(), itemarray.into().abi(), verb.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn ActivateForProtocol<'a, P0, P1>(&self, appusermodelid: P0, itemarray: P1) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellItemArray>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ActivateForProtocol)(::windows::core::Vtable::as_raw(self), appusermodelid.into(), itemarray.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IApplicationActivationManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationActivationManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationActivationManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationActivationManager {}
impl ::core::fmt::Debug for IApplicationActivationManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationActivationManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationActivationManager {
    type Vtable = IApplicationActivationManager_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationActivationManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2e941141_7f97_4756_ba1d_9decde894a3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationActivationManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ActivateApplication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, arguments: ::windows::core::PCWSTR, options: ACTIVATEOPTIONS, processid: *mut u32) -> ::windows::core::HRESULT,
    pub ActivateForFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, itemarray: *mut ::core::ffi::c_void, verb: ::windows::core::PCWSTR, processid: *mut u32) -> ::windows::core::HRESULT,
    pub ActivateForProtocol: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: ::windows::core::PCWSTR, itemarray: *mut ::core::ffi::c_void, processid: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistration(::windows::core::IUnknown);
impl IApplicationAssociationRegistration {
    pub unsafe fn QueryCurrentDefault<'a, P0>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryCurrentDefault)(::windows::core::Vtable::as_raw(self), pszquery.into(), atquerytype, alquerylevel, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefault<'a, P0, P1>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P1) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryAppIsDefault)(::windows::core::Vtable::as_raw(self), pszquery.into(), atquerytype, alquerylevel, pszappregistryname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefaultAll<'a, P0>(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryAppIsDefaultAll)(::windows::core::Vtable::as_raw(self), alquerylevel, pszappregistryname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetAppAsDefault<'a, P0, P1>(&self, pszappregistryname: P0, pszset: P1, atsettype: ASSOCIATIONTYPE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAppAsDefault)(::windows::core::Vtable::as_raw(self), pszappregistryname.into(), pszset.into(), atsettype).ok()
    }
    pub unsafe fn SetAppAsDefaultAll<'a, P0>(&self, pszappregistryname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAppAsDefaultAll)(::windows::core::Vtable::as_raw(self), pszappregistryname.into()).ok()
    }
    pub unsafe fn ClearUserAssociations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ClearUserAssociations)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IApplicationAssociationRegistration, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationAssociationRegistration {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistration {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistration {}
impl ::core::fmt::Debug for IApplicationAssociationRegistration {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistration").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationAssociationRegistration {
    type Vtable = IApplicationAssociationRegistration_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistration {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4e530b0a_e611_4c77_a3ac_9031d022281b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistration_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub QueryCurrentDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: ::windows::core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, ppszassociation: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: ::windows::core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: ::windows::core::PCWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefault: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: ::windows::core::PCWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefaultAll: usize,
    pub SetAppAsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR, pszset: ::windows::core::PCWSTR, atsettype: ASSOCIATIONTYPE) -> ::windows::core::HRESULT,
    pub SetAppAsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ClearUserAssociations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistrationUI(::windows::core::IUnknown);
impl IApplicationAssociationRegistrationUI {
    pub unsafe fn LaunchAdvancedAssociationUI<'a, P0>(&self, pszappregistryname: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).LaunchAdvancedAssociationUI)(::windows::core::Vtable::as_raw(self), pszappregistryname.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IApplicationAssociationRegistrationUI, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationAssociationRegistrationUI {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistrationUI {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistrationUI {}
impl ::core::fmt::Debug for IApplicationAssociationRegistrationUI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistrationUI").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationAssociationRegistrationUI {
    type Vtable = IApplicationAssociationRegistrationUI_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistrationUI {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f76a169_f994_40ac_8fc8_0959e8874710);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistrationUI_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub LaunchAdvancedAssociationUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings(::windows::core::IUnknown);
impl IApplicationDesignModeSettings {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetNativeDisplaySize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(nativedisplaysizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetScaleFactor)(::windows::core::Vtable::as_raw(self), scalefactor).ok()
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetApplicationViewState)(::windows::core::Vtable::as_raw(self), viewstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ComputeApplicationSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsApplicationViewStateSupported)(::windows::core::Vtable::as_raw(self), viewstate, ::core::mem::transmute(nativedisplaysizepixels), scalefactor, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).TriggerEdgeGesture)(::windows::core::Vtable::as_raw(self), edgegesturekind).ok()
    }
}
::windows::core::interface_hierarchy!(IApplicationDesignModeSettings, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationDesignModeSettings {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationDesignModeSettings {
    type Vtable = IApplicationDesignModeSettings_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a3dee9a_e31d_46d6_8508_bcc597db3557);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNativeDisplaySize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNativeDisplaySize: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetScaleFactor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetScaleFactor: usize,
    pub SetApplicationViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ComputeApplicationSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ComputeApplicationSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IsApplicationViewStateSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR, supported: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IsApplicationViewStateSupported: usize,
    pub TriggerEdgeGesture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings2(::windows::core::IUnknown);
impl IApplicationDesignModeSettings2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetNativeDisplaySize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(nativedisplaysizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetScaleFactor)(::windows::core::Vtable::as_raw(self), scalefactor).ok()
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetApplicationViewState)(::windows::core::Vtable::as_raw(self), viewstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ComputeApplicationSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsApplicationViewStateSupported)(::windows::core::Vtable::as_raw(self), viewstate, ::core::mem::transmute(nativedisplaysizepixels), scalefactor, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.TriggerEdgeGesture)(::windows::core::Vtable::as_raw(self), edgegesturekind).ok()
    }
    pub unsafe fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetNativeDisplayOrientation)(::windows::core::Vtable::as_raw(self), nativedisplayorientation).ok()
    }
    pub unsafe fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetApplicationViewOrientation)(::windows::core::Vtable::as_raw(self), vieworientation).ok()
    }
    pub unsafe fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetAdjacentDisplayEdges)(::windows::core::Vtable::as_raw(self), adjacentdisplayedges).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIsOnLockScreen<'a, P0>(&self, isonlockscreen: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetIsOnLockScreen)(::windows::core::Vtable::as_raw(self), isonlockscreen.into()).ok()
    }
    pub unsafe fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetApplicationViewMinWidth)(::windows::core::Vtable::as_raw(self), viewminwidth).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetApplicationSizeBounds)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(minapplicationsizepixels), ::core::mem::transmute(maxapplicationsizepixels)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationViewOrientation(&self, applicationsizepixels: super::super::Foundation::SIZE) -> ::windows::core::Result<APPLICATION_VIEW_ORIENTATION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetApplicationViewOrientation)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(applicationsizepixels), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<APPLICATION_VIEW_ORIENTATION>(result__)
    }
}
::windows::core::interface_hierarchy!(IApplicationDesignModeSettings2, ::windows::core::IUnknown, IApplicationDesignModeSettings);
impl ::core::clone::Clone for IApplicationDesignModeSettings2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings2 {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationDesignModeSettings2 {
    type Vtable = IApplicationDesignModeSettings2_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x490514e1_675a_4d6e_a58d_e54901b4ca2f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings2_Vtbl {
    pub base__: IApplicationDesignModeSettings_Vtbl,
    pub SetNativeDisplayOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetAdjacentDisplayEdges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIsOnLockScreen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isonlockscreen: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIsOnLockScreen: usize,
    pub SetApplicationViewMinWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationSizeBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationSizeBounds: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: super::super::Foundation::SIZE, vieworientation: *mut APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationViewOrientation: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDestinations(::windows::core::IUnknown);
impl IApplicationDestinations {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAppID)(::windows::core::Vtable::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn RemoveDestination<'a, P0>(&self, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).RemoveDestination)(::windows::core::Vtable::as_raw(self), punk.into().abi()).ok()
    }
    pub unsafe fn RemoveAllDestinations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RemoveAllDestinations)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IApplicationDestinations, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationDestinations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDestinations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDestinations {}
impl ::core::fmt::Debug for IApplicationDestinations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDestinations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationDestinations {
    type Vtable = IApplicationDestinations_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationDestinations {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12337d35_94c6_48a0_bce7_6a9c69d4d600);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDestinations_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RemoveDestination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RemoveAllDestinations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IApplicationDocumentLists(::windows::core::IUnknown);
impl IApplicationDocumentLists {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAppID)(::windows::core::Vtable::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn GetList<T>(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetList)(::windows::core::Vtable::as_raw(self), listtype, citemsdesired, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
::windows::core::interface_hierarchy!(IApplicationDocumentLists, ::windows::core::IUnknown);
impl ::core::clone::Clone for IApplicationDocumentLists {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDocumentLists {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDocumentLists {}
impl ::core::fmt::Debug for IApplicationDocumentLists {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDocumentLists").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IApplicationDocumentLists {
    type Vtable = IApplicationDocumentLists_Vtbl;
}
unsafe impl ::windows::core::Interface for IApplicationDocumentLists {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c594f9f_9f30_47a1_979a_c9e83d3d0a06);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDocumentLists_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, listtype: APPDOCLISTTYPE, citemsdesired: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAssocHandler(::windows::core::IUnknown);
impl IAssocHandler {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetUIName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetUIName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetIconLocation(&self, ppszpath: *mut ::windows::core::PWSTR, pindex: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetIconLocation)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppszpath), ::core::mem::transmute(pindex)).ok()
    }
    pub unsafe fn IsRecommended(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsRecommended)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn MakeDefault<'a, P0>(&self, pszdescription: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).MakeDefault)(::windows::core::Vtable::as_raw(self), pszdescription.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<'a, P0>(&self, pdo: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        (::windows::core::Vtable::vtable(self).Invoke)(::windows::core::Vtable::as_raw(self), pdo.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<'a, P0>(&self, pdo: P0) -> ::windows::core::Result<IAssocHandlerInvoker>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateInvoker)(::windows::core::Vtable::as_raw(self), pdo.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IAssocHandlerInvoker>(result__)
    }
}
::windows::core::interface_hierarchy!(IAssocHandler, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAssocHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandler {}
impl ::core::fmt::Debug for IAssocHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAssocHandler {
    type Vtable = IAssocHandler_Vtbl;
}
unsafe impl ::windows::core::Interface for IAssocHandler {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf04061ac_1659_4a3f_a954_775aa57fc083);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandler_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetUIName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetIconLocation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpath: *mut ::windows::core::PWSTR, pindex: *mut i32) -> ::windows::core::HRESULT,
    pub IsRecommended: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub MakeDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdescription: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateInvoker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: *mut ::core::ffi::c_void, ppinvoker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateInvoker: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAssocHandlerInvoker(::windows::core::IUnknown);
impl IAssocHandlerInvoker {
    pub unsafe fn SupportsSelection(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SupportsSelection)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Invoke(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Invoke)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IAssocHandlerInvoker, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAssocHandlerInvoker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandlerInvoker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandlerInvoker {}
impl ::core::fmt::Debug for IAssocHandlerInvoker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandlerInvoker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAssocHandlerInvoker {
    type Vtable = IAssocHandlerInvoker_Vtbl;
}
unsafe impl ::windows::core::Interface for IAssocHandlerInvoker {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92218cab_ecaa_4335_8133_807fd234c2ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandlerInvoker_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SupportsSelection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAttachmentExecute(::windows::core::IUnknown);
impl IAttachmentExecute {
    pub unsafe fn SetClientTitle<'a, P0>(&self, psztitle: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetClientTitle)(::windows::core::Vtable::as_raw(self), psztitle.into()).ok()
    }
    pub unsafe fn SetClientGuid(&self, guid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetClientGuid)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(guid)).ok()
    }
    pub unsafe fn SetLocalPath<'a, P0>(&self, pszlocalpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetLocalPath)(::windows::core::Vtable::as_raw(self), pszlocalpath.into()).ok()
    }
    pub unsafe fn SetFileName<'a, P0>(&self, pszfilename: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetFileName)(::windows::core::Vtable::as_raw(self), pszfilename.into()).ok()
    }
    pub unsafe fn SetSource<'a, P0>(&self, pszsource: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetSource)(::windows::core::Vtable::as_raw(self), pszsource.into()).ok()
    }
    pub unsafe fn SetReferrer<'a, P0>(&self, pszreferrer: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetReferrer)(::windows::core::Vtable::as_raw(self), pszreferrer.into()).ok()
    }
    pub unsafe fn CheckPolicy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CheckPolicy)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Prompt<'a, P0>(&self, hwnd: P0, prompt: ATTACHMENT_PROMPT) -> ::windows::core::Result<ATTACHMENT_ACTION>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Prompt)(::windows::core::Vtable::as_raw(self), hwnd.into(), prompt, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ATTACHMENT_ACTION>(result__)
    }
    pub unsafe fn Save(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Save)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Execute<'a, P0, P1>(&self, hwnd: P0, pszverb: P1) -> ::windows::core::Result<super::super::Foundation::HANDLE>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Execute)(::windows::core::Vtable::as_raw(self), hwnd.into(), pszverb.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SaveWithUI<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).SaveWithUI)(::windows::core::Vtable::as_raw(self), hwnd.into()).ok()
    }
    pub unsafe fn ClearClientState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ClearClientState)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IAttachmentExecute, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAttachmentExecute {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAttachmentExecute {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAttachmentExecute {}
impl ::core::fmt::Debug for IAttachmentExecute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAttachmentExecute").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAttachmentExecute {
    type Vtable = IAttachmentExecute_Vtbl;
}
unsafe impl ::windows::core::Interface for IAttachmentExecute {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73db1241_1e85_4581_8e4f_a81e1d0f8c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttachmentExecute_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetClientTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztitle: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetClientGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub SetLocalPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszlocalpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsource: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszreferrer: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CheckPolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Prompt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT, paction: *mut ATTACHMENT_ACTION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Prompt: usize,
    pub Save: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pszverb: ::windows::core::PCWSTR, phprocess: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Execute: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SaveWithUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SaveWithUI: usize,
    pub ClearClientState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoComplete(::windows::core::IUnknown);
impl IAutoComplete {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0, P1, P2, P3>(&self, hwndedit: P0, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).Init)(::windows::core::Vtable::as_raw(self), hwndedit.into(), punkacl.into().abi(), pwszregkeypath.into(), pwszquickcomplete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, P0>(&self, fenable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).Enable)(::windows::core::Vtable::as_raw(self), fenable.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IAutoComplete, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAutoComplete {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete {}
impl ::core::fmt::Debug for IAutoComplete {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAutoComplete {
    type Vtable = IAutoComplete_Vtbl;
}
unsafe impl ::windows::core::Interface for IAutoComplete {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2762_6a77_11d0_a535_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndedit: super::super::Foundation::HWND, punkacl: *mut ::core::ffi::c_void, pwszregkeypath: ::windows::core::PCWSTR, pwszquickcomplete: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Enable: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoComplete2(::windows::core::IUnknown);
impl IAutoComplete2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0, P1, P2, P3>(&self, hwndedit: P0, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.Init)(::windows::core::Vtable::as_raw(self), hwndedit.into(), punkacl.into().abi(), pwszregkeypath.into(), pwszquickcomplete.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, P0>(&self, fenable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.Enable)(::windows::core::Vtable::as_raw(self), fenable.into()).ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetOptions)(::windows::core::Vtable::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOptions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IAutoComplete2, ::windows::core::IUnknown, IAutoComplete);
impl ::core::clone::Clone for IAutoComplete2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete2 {}
impl ::core::fmt::Debug for IAutoComplete2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAutoComplete2 {
    type Vtable = IAutoComplete2_Vtbl;
}
unsafe impl ::windows::core::Interface for IAutoComplete2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeac04bc0_3791_11d2_bb95_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete2_Vtbl {
    pub base__: IAutoComplete_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IAutoCompleteDropDown(::windows::core::IUnknown);
impl IAutoCompleteDropDown {
    pub unsafe fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDropDownStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwflags), ::core::mem::transmute(ppwszstring)).ok()
    }
    pub unsafe fn ResetEnumerator(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ResetEnumerator)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IAutoCompleteDropDown, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAutoCompleteDropDown {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoCompleteDropDown {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoCompleteDropDown {}
impl ::core::fmt::Debug for IAutoCompleteDropDown {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoCompleteDropDown").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAutoCompleteDropDown {
    type Vtable = IAutoCompleteDropDown_Vtbl;
}
unsafe impl ::windows::core::Interface for IAutoCompleteDropDown {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3cd141f4_3c6a_11d2_bcaa_00c04fd929db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoCompleteDropDown_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDropDownStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32, ppwszstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub ResetEnumerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBandHost(::windows::core::IUnknown);
impl IBandHost {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBand<'a, P0, P1, T>(&self, rclsidband: *const ::windows::core::GUID, favailable: P0, fvisible: P1) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateBand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rclsidband), favailable.into(), fvisible.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBandAvailability<'a, P0>(&self, rclsidband: *const ::windows::core::GUID, favailable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetBandAvailability)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rclsidband), favailable.into()).ok()
    }
    pub unsafe fn DestroyBand(&self, rclsidband: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DestroyBand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rclsidband)).ok()
    }
}
::windows::core::interface_hierarchy!(IBandHost, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBandHost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandHost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandHost {}
impl ::core::fmt::Debug for IBandHost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandHost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBandHost {
    type Vtable = IBandHost_Vtbl;
}
unsafe impl ::windows::core::Interface for IBandHost {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb9075c7c_d48e_403f_ab99_d6c77a1084ac);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandHost_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL, fvisible: super::super::Foundation::BOOL, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateBand: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetBandAvailability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetBandAvailability: usize,
    pub DestroyBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBandSite(::windows::core::IUnknown);
impl IBandSite {
    pub unsafe fn AddBand<'a, P0>(&self, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).AddBand)(::windows::core::Vtable::as_raw(self), punk.into().abi()).ok()
    }
    pub unsafe fn EnumBands(&self, uband: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumBands)(::windows::core::Vtable::as_raw(self), uband, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn QueryBand(&self, dwbandid: u32, ppstb: ::core::option::Option<*mut ::core::option::Option<IDeskBand>>, pdwstate: ::core::option::Option<*mut u32>, pszname: ::core::option::Option<&mut [u16]>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).QueryBand)(::windows::core::Vtable::as_raw(self), dwbandid, ::core::mem::transmute(ppstb.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwstate.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pszname.as_deref().map_or(0, |slice| slice.len() as _)).ok()
    }
    pub unsafe fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetBandState)(::windows::core::Vtable::as_raw(self), dwbandid, dwmask, dwstate).ok()
    }
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RemoveBand)(::windows::core::Vtable::as_raw(self), dwbandid).ok()
    }
    pub unsafe fn GetBandObject<T>(&self, dwbandid: u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetBandObject)(::windows::core::Vtable::as_raw(self), dwbandid, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetBandSiteInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pbsinfo)).ok()
    }
    pub unsafe fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetBandSiteInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pbsinfo)).ok()
    }
}
::windows::core::interface_hierarchy!(IBandSite, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBandSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandSite {}
impl ::core::fmt::Debug for IBandSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBandSite {
    type Vtable = IBandSite_Vtbl;
}
unsafe impl ::windows::core::Interface for IBandSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4cf504b0_de96_11d0_8b3f_00a0c911e8e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AddBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumBands: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uband: u32, pdwbandid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub QueryBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, ppstb: *mut *mut ::core::ffi::c_void, pdwstate: *mut u32, pszname: ::windows::core::PWSTR, cchname: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    QueryBand: usize,
    pub SetBandState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::HRESULT,
    pub RemoveBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32) -> ::windows::core::HRESULT,
    pub GetBandObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *const BANDSITEINFO) -> ::windows::core::HRESULT,
    pub GetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBannerNotificationHandler(::windows::core::IUnknown);
impl IBannerNotificationHandler {
    pub unsafe fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnBannerEvent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(notification)).ok()
    }
}
::windows::core::interface_hierarchy!(IBannerNotificationHandler, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBannerNotificationHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBannerNotificationHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBannerNotificationHandler {}
impl ::core::fmt::Debug for IBannerNotificationHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBannerNotificationHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBannerNotificationHandler {
    type Vtable = IBannerNotificationHandler_Vtbl;
}
unsafe impl ::windows::core::Interface for IBannerNotificationHandler {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8d7b2ba7_db05_46a8_823c_d2b6de08ee91);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBannerNotificationHandler_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnBannerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, notification: *const BANNER_NOTIFICATION) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBanneredBar(::windows::core::IUnknown);
impl IBanneredBar {
    pub unsafe fn SetIconSize(&self, iicon: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetIconSize)(::windows::core::Vtable::as_raw(self), iicon).ok()
    }
    pub unsafe fn GetIconSize(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetIconSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap<'a, P0>(&self, hbitmap: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Vtable::vtable(self).SetBitmap)(::windows::core::Vtable::as_raw(self), hbitmap.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBitmap)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
}
::windows::core::interface_hierarchy!(IBanneredBar, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBanneredBar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBanneredBar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBanneredBar {}
impl ::core::fmt::Debug for IBanneredBar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBanneredBar").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBanneredBar {
    type Vtable = IBanneredBar_Vtbl;
}
unsafe impl ::windows::core::Interface for IBanneredBar {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x596a9a94_013e_11d1_8d34_00a0c90f2719);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBanneredBar_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iicon: u32) -> ::windows::core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piicon: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phbitmap: *mut super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmap: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserFrameOptions(::windows::core::IUnknown);
impl IBrowserFrameOptions {
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFrameOptions)(::windows::core::Vtable::as_raw(self), dwmask, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IBrowserFrameOptions, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBrowserFrameOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserFrameOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserFrameOptions {}
impl ::core::fmt::Debug for IBrowserFrameOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserFrameOptions").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBrowserFrameOptions {
    type Vtable = IBrowserFrameOptions_Vtbl;
}
unsafe impl ::windows::core::Interface for IBrowserFrameOptions {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10df43c8_1dbe_11d3_8b34_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserFrameOptions_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetFrameOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmask: u32, pdwoptions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService(::windows::core::IUnknown);
impl IBrowserService {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetParentSite)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).GetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pszname.as_ptr()), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOleObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetTravelLog)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).ShowControlWindow)(::windows::core::Vtable::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsControlWindowShown)(::windows::core::Vtable::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IEGetDisplayName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IEParseDisplayName)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).DisplayParseError)(::windows::core::Vtable::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).NavigateToPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetNavigateState)(::windows::core::Vtable::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetNavigateState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).NotifyRedirect)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateWindowList)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateBackForwardState)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetFlags)(::windows::core::Vtable::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CanNavigateNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetReferrer)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).GetBrowserIndex)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBrowserByIndex)(::windows::core::Vtable::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetHistoryObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetHistoryObject)(::windows::core::Vtable::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Vtable::vtable(self).CacheOLEServer)(::windows::core::Vtable::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OnHttpEquiv)(::windows::core::Vtable::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetPalette)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).RegisterWindow)(::windows::core::Vtable::as_raw(self), fforceregister.into(), swc).ok()
    }
}
::windows::core::interface_hierarchy!(IBrowserService, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBrowserService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService {}
impl ::core::fmt::Debug for IBrowserService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBrowserService {
    type Vtable = IBrowserService_Vtbl;
}
unsafe impl ::windows::core::Interface for IBrowserService {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x02ba3b52_0547_11d1_b833_00c04fc9b31f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetParentSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppipsite: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetParentSite: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pszname: ::windows::core::PWSTR, cchname: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetOleObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppobjv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetOleObject: usize,
    pub GetTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptl: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowControlWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, fshow: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowControlWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsControlWindowShown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, pfshown: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsControlWindowShown: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEGetDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEGetDisplayName: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: ::windows::core::PCWSTR, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayName: usize,
    pub DisplayParseError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hres: ::windows::core::HRESULT, pwszpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub NavigateToPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    NavigateToPidl: usize,
    pub SetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bnstate: BNSTATE) -> ::windows::core::HRESULT,
    pub GetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbnstate: *mut BNSTATE) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub NotifyRedirect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pfdidbrowse: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    NotifyRedirect: usize,
    pub UpdateWindowList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UpdateBackForwardState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, dwflagmask: u32) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    pub CanNavigateNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetPidl: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetReferrer: usize,
    pub GetBrowserIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub GetBrowserByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwid: u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppole: *mut *mut ::core::ffi::c_void, pstm: *mut *mut ::core::ffi::c_void, ppbc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetHistoryObject: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub SetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: *mut ::core::ffi::c_void, fislocalanchor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    SetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub CacheOLEServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CacheOLEServer: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetSetCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarin: *const ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarout: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetSetCodePage: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OnHttpEquiv: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, fdone: super::super::Foundation::BOOL, pvarargin: *const ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarargout: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OnHttpEquiv: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hpal: *mut super::super::Graphics::Gdi::HPALETTE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RegisterWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fforceregister: super::super::Foundation::BOOL, swc: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RegisterWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService2(::windows::core::IUnknown);
impl IBrowserService2 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetParentSite)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.GetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pszname.as_ptr()), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetOleObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetTravelLog)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ShowControlWindow)(::windows::core::Vtable::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsControlWindowShown)(::windows::core::Vtable::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.IEGetDisplayName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IEParseDisplayName)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.DisplayParseError)(::windows::core::Vtable::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.NavigateToPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetNavigateState)(::windows::core::Vtable::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetNavigateState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.NotifyRedirect)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UpdateWindowList)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UpdateBackForwardState)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetFlags)(::windows::core::Vtable::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.CanNavigateNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetReferrer)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).base__.GetBrowserIndex)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetBrowserByIndex)(::windows::core::Vtable::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetHistoryObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetHistoryObject)(::windows::core::Vtable::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Vtable::vtable(self).base__.CacheOLEServer)(::windows::core::Vtable::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.OnHttpEquiv)(::windows::core::Vtable::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetPalette)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.RegisterWindow)(::windows::core::Vtable::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).WndProcBS)(::windows::core::Vtable::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetAsDefFolderSettings)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetViewRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Vtable::vtable(self).OnSize)(::windows::core::Vtable::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnCreate)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).OnCommand)(::windows::core::Vtable::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnDestroy)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Vtable::vtable(self).OnNotify)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnSetFocus)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).OnFrameWindowActivateBS)(::windows::core::Vtable::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ReleaseShellView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ActivatePendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateViewWindow)(::windows::core::Vtable::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CreateBrowserPropSheetExt)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetViewWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBaseBrowserData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Vtable::vtable(self).PutBaseBrowserData)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Vtable::vtable(self).InitializeTravelLog)(::windows::core::Vtable::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetTopBrowser)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Offline)(::windows::core::Vtable::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).AllowViewResize)(::windows::core::Vtable::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetActivateState)(::windows::core::Vtable::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateSecureLockIcon)(::windows::core::Vtable::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).InitializeDownloadManager)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).InitializeTransitionSite)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self)._Initialize)(::windows::core::Vtable::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._CancelPendingNavigationAsync)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._CancelPendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._MaySaveChanges)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self)._PauseOrResumeView)(::windows::core::Vtable::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._DisableModeless)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._NavigateToPidl2)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self)._TryShell2Rename)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._SwitchActivationNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: ::core::option::Option<*const ::windows::core::GUID>, ncmdid: u32, ncmdexecopt: u32, pvarargin: ::core::option::Option<*const super::super::System::Com::VARIANT>, pvarargout: ::core::option::Option<*mut super::super::System::Com::VARIANT>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self)._ExecChildren)(::windows::core::Vtable::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup.unwrap_or(::std::ptr::null())), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvarargout.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self)._SendChildren)(::windows::core::Vtable::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetFolderSetData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._OnFocusChange)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).v_ShowHideChildWindows)(::windows::core::Vtable::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Vtable::vtable(self)._get_itbLastFocus)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._put_itbLastFocus)(::windows::core::Vtable::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._UIActivateView)(::windows::core::Vtable::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._GetViewBorderRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._UpdateViewRectSize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._ResizeNextBorder)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._ResizeView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Vtable::vtable(self)._GetEffectiveClientArea)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).v_GetViewStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).ForwardViewMsg)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Vtable::vtable(self).SetAcceleratorMenu)(::windows::core::Vtable::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Vtable::vtable(self)._GetToolbarCount)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Vtable::vtable(self)._GetToolbarItem)(::windows::core::Vtable::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self)._SaveToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self)._LoadToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self)._CloseAndReleaseToolbars)(::windows::core::Vtable::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).v_MayGetNextToolbarFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self)._ResizeNextBorderHelper)(::windows::core::Vtable::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self)._FindTBar)(::windows::core::Vtable::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self)._SetFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).v_MayTranslateAccelerator)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self)._GetBorderDWHelper)(::windows::core::Vtable::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).v_CheckZoneCrossing)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
}
::windows::core::interface_hierarchy!(IBrowserService2, ::windows::core::IUnknown, IBrowserService);
impl ::core::clone::Clone for IBrowserService2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService2 {}
impl ::core::fmt::Debug for IBrowserService2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBrowserService2 {
    type Vtable = IBrowserService2_Vtbl;
}
unsafe impl ::windows::core::Interface for IBrowserService2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x68bd21cc_438b_11d2_a560_00a0c92dbfe8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService2_Vtbl {
    pub base__: IBrowserService_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub WndProcBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WndProcBS: usize,
    pub SetAsDefFolderSettings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewRect: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub OnCreate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    OnCreate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCommand: usize,
    pub OnDestroy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub OnNotify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))]
    OnNotify: usize,
    pub OnSetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnFrameWindowActivateBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, factive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnFrameWindowActivateBS: usize,
    pub ReleaseShellView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ActivatePendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub CreateViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psvnew: *mut ::core::ffi::c_void, psvold: *mut ::core::ffi::c_void, prcview: *const super::super::Foundation::RECT, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    CreateViewWindow: usize,
    pub CreateBrowserPropSheetExt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndview: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewWindow: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub GetBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbbd: *mut *mut ::core::mem::ManuallyDrop<BASEBROWSERDATALH>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    GetBaseBrowserData: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub PutBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> *mut BASEBROWSERDATALH,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    PutBaseBrowserData: usize,
    pub InitializeTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptl: *mut ::core::ffi::c_void, dw: u32) -> ::windows::core::HRESULT,
    pub SetTopBrowser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Offline: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, icmd: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AllowViewResize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, f: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AllowViewResize: usize,
    pub SetActivateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, u: u32) -> ::windows::core::HRESULT,
    pub UpdateSecureLockIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, esecurelock: i32) -> ::windows::core::HRESULT,
    pub InitializeDownloadManager: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub InitializeTransitionSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pauto: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _Initialize: usize,
    pub _CancelPendingNavigationAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _CancelPendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _MaySaveChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _PauseOrResumeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpaused: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PauseOrResumeView: usize,
    pub _DisableModeless: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub _NavigateToPidl2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    _NavigateToPidl2: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub _TryShell2Rename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: *mut ::core::ffi::c_void, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    _TryShell2Rename: usize,
    pub _SwitchActivationNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub _ExecChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkbar: *mut ::core::ffi::c_void, fbroadcast: super::super::Foundation::BOOL, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarargout: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    _ExecChildren: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _SendChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndbar: super::super::Foundation::HWND, fbroadcast: super::super::Foundation::BOOL, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _SendChildren: usize,
    pub GetFolderSetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfsd: *mut FOLDERSETDATA) -> ::windows::core::HRESULT,
    pub _OnFocusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub v_ShowHideChildWindows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fchildonly: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    v_ShowHideChildWindows: usize,
    pub _get_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub _put_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itblastfocus: u32) -> ::windows::core::HRESULT,
    pub _UIActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ustate: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetViewBorderRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetViewBorderRect: usize,
    pub _UpdateViewRectSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeNextBorder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    pub _ResizeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub _GetEffectiveClientArea: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    _GetEffectiveClientArea: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub v_GetViewStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: ::windows::core::PCWSTR) -> ::core::option::Option<super::super::System::Com::IStream>,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    v_GetViewStream: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ForwardViewMsg: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ForwardViewMsg: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hacc: super::WindowsAndMessaging::HACCEL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorMenu: usize,
    pub _GetToolbarCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub _GetToolbarItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: i32) -> *mut TOOLBARITEM,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole")))]
    _GetToolbarItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _SaveToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _SaveToolbars: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _LoadToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _LoadToolbars: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _CloseAndReleaseToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fclose: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _CloseAndReleaseToolbars: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayGetNextToolbarFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut ::core::mem::ManuallyDrop<TOOLBARITEM>, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayGetNextToolbarFocus: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _ResizeNextBorderHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _ResizeNextBorderHelper: usize,
    pub _FindTBar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub _SetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptbi: *const ::core::mem::ManuallyDrop<TOOLBARITEM>, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    _SetFocus: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayTranslateAccelerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayTranslateAccelerator: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetBorderDWHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetBorderDWHelper: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub v_CheckZoneCrossing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    v_CheckZoneCrossing: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService3(::windows::core::IUnknown);
impl IBrowserService3 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetParentSite)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.SetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.GetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pszname.as_ptr()), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetOleObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetTravelLog)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.ShowControlWindow)(::windows::core::Vtable::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.IsControlWindowShown)(::windows::core::Vtable::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.IEGetDisplayName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.IEParseDisplayName)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.DisplayParseError)(::windows::core::Vtable::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.NavigateToPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetNavigateState)(::windows::core::Vtable::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetNavigateState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.NotifyRedirect)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.UpdateWindowList)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.UpdateBackForwardState)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetFlags)(::windows::core::Vtable::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.CanNavigateNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetReferrer)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).base__.base__.GetBrowserIndex)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetBrowserByIndex)(::windows::core::Vtable::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetHistoryObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.SetHistoryObject)(::windows::core::Vtable::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.CacheOLEServer)(::windows::core::Vtable::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetSetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.OnHttpEquiv)(::windows::core::Vtable::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetPalette)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.RegisterWindow)(::windows::core::Vtable::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.WndProcBS)(::windows::core::Vtable::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetAsDefFolderSettings)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetViewRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.OnSize)(::windows::core::Vtable::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.OnCreate)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.OnCommand)(::windows::core::Vtable::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.OnDestroy)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Vtable::vtable(self).base__.OnNotify)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.OnSetFocus)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.OnFrameWindowActivateBS)(::windows::core::Vtable::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.ReleaseShellView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.ActivatePendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.CreateViewWindow)(::windows::core::Vtable::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.CreateBrowserPropSheetExt)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetViewWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetBaseBrowserData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Vtable::vtable(self).base__.PutBaseBrowserData)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Vtable::vtable(self).base__.InitializeTravelLog)(::windows::core::Vtable::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetTopBrowser)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Offline)(::windows::core::Vtable::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.AllowViewResize)(::windows::core::Vtable::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetActivateState)(::windows::core::Vtable::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UpdateSecureLockIcon)(::windows::core::Vtable::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.InitializeDownloadManager)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.InitializeTransitionSite)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__._Initialize)(::windows::core::Vtable::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._CancelPendingNavigationAsync)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._CancelPendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._MaySaveChanges)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__._PauseOrResumeView)(::windows::core::Vtable::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._DisableModeless)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._NavigateToPidl2)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__._TryShell2Rename)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._SwitchActivationNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: ::core::option::Option<*const ::windows::core::GUID>, ncmdid: u32, ncmdexecopt: u32, pvarargin: ::core::option::Option<*const super::super::System::Com::VARIANT>, pvarargout: ::core::option::Option<*mut super::super::System::Com::VARIANT>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__._ExecChildren)(::windows::core::Vtable::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup.unwrap_or(::std::ptr::null())), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvarargout.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__._SendChildren)(::windows::core::Vtable::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetFolderSetData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._OnFocusChange)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.v_ShowHideChildWindows)(::windows::core::Vtable::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).base__._get_itbLastFocus)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._put_itbLastFocus)(::windows::core::Vtable::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._UIActivateView)(::windows::core::Vtable::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._GetViewBorderRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._UpdateViewRectSize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._ResizeNextBorder)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__._ResizeView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Vtable::vtable(self).base__._GetEffectiveClientArea)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.v_GetViewStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.ForwardViewMsg)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetAcceleratorMenu)(::windows::core::Vtable::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Vtable::vtable(self).base__._GetToolbarCount)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Vtable::vtable(self).base__._GetToolbarItem)(::windows::core::Vtable::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__._SaveToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__._LoadToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__._CloseAndReleaseToolbars)(::windows::core::Vtable::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.v_MayGetNextToolbarFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__._ResizeNextBorderHelper)(::windows::core::Vtable::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__._FindTBar)(::windows::core::Vtable::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).base__._SetFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.v_MayTranslateAccelerator)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__._GetBorderDWHelper)(::windows::core::Vtable::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.v_CheckZoneCrossing)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self)._PositionViewWindow)(::windows::core::Vtable::as_raw(self), hwnd.into(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<'a, P0>(&self, uicp: u32, pwszpath: P0, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IEParseDisplayNameEx)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
}
::windows::core::interface_hierarchy!(IBrowserService3, ::windows::core::IUnknown, IBrowserService, IBrowserService2);
impl ::core::clone::Clone for IBrowserService3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService3 {}
impl ::core::fmt::Debug for IBrowserService3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBrowserService3 {
    type Vtable = IBrowserService3_Vtbl;
}
unsafe impl ::windows::core::Interface for IBrowserService3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x27d7ce21_762d_48f3_86f3_40e2fd3749c4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService3_Vtbl {
    pub base__: IBrowserService2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub _PositionViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PositionViewWindow: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayNameEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: ::windows::core::PCWSTR, dwflags: u32, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayNameEx: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IBrowserService4(::windows::core::IUnknown);
impl IBrowserService4 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetParentSite)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<'a, P0, P1>(&self, psv: P0, pszname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.SetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), pszname.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<'a, P0>(&self, psv: P0, pszname: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetTitle)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pszname.as_ptr()), pszname.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetOleObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetTravelLog)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, P0>(&self, id: u32, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.ShowControlWindow)(::windows::core::Vtable::as_raw(self), id, fshow.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.IsControlWindowShown)(::windows::core::Vtable::as_raw(self), id, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: ::windows::core::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.IEGetDisplayName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<'a, P0>(&self, uicp: u32, pwszpath: P0) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.IEParseDisplayName)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn DisplayParseError<'a, P0>(&self, hres: ::windows::core::HRESULT, pwszpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.DisplayParseError)(::windows::core::Vtable::as_raw(self), hres, pwszpath.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.NavigateToPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.SetNavigateState)(::windows::core::Vtable::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetNavigateState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.NotifyRedirect)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.UpdateWindowList)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.UpdateBackForwardState)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.SetFlags)(::windows::core::Vtable::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.CanNavigateNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetPidl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.SetReferrer)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetBrowserIndex)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetBrowserByIndex)(::windows::core::Vtable::as_raw(self), dwid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetHistoryObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, P0, P1>(&self, pole: P0, fislocalanchor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.SetHistoryObject)(::windows::core::Vtable::as_raw(self), pole.into().abi(), fislocalanchor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, P0>(&self, pole: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Ole::IOleObject>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.CacheOLEServer)(::windows::core::Vtable::as_raw(self), pole.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetSetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.OnHttpEquiv)(::windows::core::Vtable::as_raw(self), psv.into().abi(), fdone.into(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetPalette)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, P0>(&self, fforceregister: P0, swc: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.RegisterWindow)(::windows::core::Vtable::as_raw(self), fforceregister.into(), swc).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P2: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.WndProcBS)(::windows::core::Vtable::as_raw(self), hwnd.into(), umsg, wparam.into(), lparam.into())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetAsDefFolderSettings)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetViewRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, P0>(&self, wparam: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.OnSize)(::windows::core::Vtable::as_raw(self), wparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.OnCreate)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.OnCommand)(::windows::core::Vtable::as_raw(self), wparam.into(), lparam.into())
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.OnDestroy)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Controls\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (::windows::core::Vtable::vtable(self).base__.base__.OnNotify)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pnm))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.OnSetFocus)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, P0>(&self, factive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.OnFrameWindowActivateBS)(::windows::core::Vtable::as_raw(self), factive.into()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.ReleaseShellView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.ActivatePendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.CreateViewWindow)(::windows::core::Vtable::as_raw(self), psvnew.into().abi(), psvold.into().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.CreateBrowserPropSheetExt)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetViewWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetBaseBrowserData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (::windows::core::Vtable::vtable(self).base__.base__.PutBaseBrowserData)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<'a, P0>(&self, ptl: P0, dw: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ITravelLog>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.InitializeTravelLog)(::windows::core::Vtable::as_raw(self), ptl.into().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetTopBrowser)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.Offline)(::windows::core::Vtable::as_raw(self), icmd).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, P0>(&self, f: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.AllowViewResize)(::windows::core::Vtable::as_raw(self), f.into()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.SetActivateState)(::windows::core::Vtable::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.UpdateSecureLockIcon)(::windows::core::Vtable::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.InitializeDownloadManager)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.InitializeTransitionSite)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, P0, P1>(&self, hwnd: P0, pauto: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._Initialize)(::windows::core::Vtable::as_raw(self), hwnd.into(), pauto.into().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._CancelPendingNavigationAsync)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._CancelPendingView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._MaySaveChanges)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, P0>(&self, fpaused: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._PauseOrResumeView)(::windows::core::Vtable::as_raw(self), fpaused.into()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._DisableModeless)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._NavigateToPidl2)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfhlnf, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._TryShell2Rename)(::windows::core::Vtable::as_raw(self), psv.into().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._SwitchActivationNow)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: ::core::option::Option<*const ::windows::core::GUID>, ncmdid: u32, ncmdexecopt: u32, pvarargin: ::core::option::Option<*const super::super::System::Com::VARIANT>, pvarargout: ::core::option::Option<*mut super::super::System::Com::VARIANT>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._ExecChildren)(::windows::core::Vtable::as_raw(self), punkbar.into().abi(), fbroadcast.into(), ::core::mem::transmute(pguidcmdgroup.unwrap_or(::std::ptr::null())), ncmdid, ncmdexecopt, ::core::mem::transmute(pvarargin.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvarargout.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P3: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._SendChildren)(::windows::core::Vtable::as_raw(self), hwndbar.into(), fbroadcast.into(), umsg, wparam.into(), lparam.into()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetFolderSetData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pfsd)).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._OnFocusChange)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, P0>(&self, fchildonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.v_ShowHideChildWindows)(::windows::core::Vtable::as_raw(self), fchildonly.into()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (::windows::core::Vtable::vtable(self).base__.base__._get_itbLastFocus)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._put_itbLastFocus)(::windows::core::Vtable::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._UIActivateView)(::windows::core::Vtable::as_raw(self), ustate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._GetViewBorderRect)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._UpdateViewRectSize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._ResizeNextBorder)(::windows::core::Vtable::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__._ResizeView)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._GetEffectiveClientArea)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lprectborder), hmon.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> ::core::option::Option<super::super::System::Com::IStream>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.v_GetViewStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl), grfmode, pwszname.into())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.ForwardViewMsg)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into())
    }
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, P0>(&self, hacc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HACCEL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.SetAcceleratorMenu)(::windows::core::Vtable::as_raw(self), hacc.into()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (::windows::core::Vtable::vtable(self).base__.base__._GetToolbarCount)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (::windows::core::Vtable::vtable(self).base__.base__._GetToolbarItem)(::windows::core::Vtable::as_raw(self), itb)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._SaveToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._LoadToolbars)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, P0>(&self, fclose: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._CloseAndReleaseToolbars)(::windows::core::Vtable::as_raw(self), fclose.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.v_MayGetNextToolbarFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(lpmsg), itbnext, citb, ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, P0>(&self, itb: u32, busehmonitor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._ResizeNextBorderHelper)(::windows::core::Vtable::as_raw(self), itb, busehmonitor.into()).ok()
    }
    pub unsafe fn _FindTBar<'a, P0>(&self, punksrc: P0) -> u32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._FindTBar)(::windows::core::Vtable::as_raw(self), punksrc.into().abi())
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._SetFocus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptbi), hwnd.into(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.v_MayTranslateAccelerator)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__._GetBorderDWHelper)(::windows::core::Vtable::as_raw(self), punksrc.into().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.v_CheckZoneCrossing)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).base__._PositionViewWindow)(::windows::core::Vtable::as_raw(self), hwnd.into(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<'a, P0>(&self, uicp: u32, pwszpath: P0, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IEParseDisplayNameEx)(::windows::core::Vtable::as_raw(self), uicp, pwszpath.into(), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateView<'a, P0>(&self, fpendingview: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).ActivateView)(::windows::core::Vtable::as_raw(self), fpendingview.into()).ok()
    }
    pub unsafe fn SaveViewState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SaveViewState)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeAllBorders(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self)._ResizeAllBorders)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IBrowserService4, ::windows::core::IUnknown, IBrowserService, IBrowserService2, IBrowserService3);
impl ::core::clone::Clone for IBrowserService4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService4 {}
impl ::core::fmt::Debug for IBrowserService4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBrowserService4 {
    type Vtable = IBrowserService4_Vtbl;
}
unsafe impl ::windows::core::Interface for IBrowserService4 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x639f1bff_e135_4096_abd8_e0f504d649a4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService4_Vtbl {
    pub base__: IBrowserService3_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpendingview: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateView: usize,
    pub SaveViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeAllBorders: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICDBurn(::windows::core::IUnknown);
impl ICDBurn {
    pub unsafe fn GetRecorderDriveLetter(&self, pszdrive: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRecorderDriveLetter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pszdrive.as_ptr()), pszdrive.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Burn<'a, P0>(&self, hwnd: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).Burn)(::windows::core::Vtable::as_raw(self), hwnd.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasRecordableDrive(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HasRecordableDrive)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
::windows::core::interface_hierarchy!(ICDBurn, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICDBurn {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurn {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurn {}
impl ::core::fmt::Debug for ICDBurn {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurn").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICDBurn {
    type Vtable = ICDBurn_Vtbl;
}
unsafe impl ::windows::core::Interface for ICDBurn {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d73a659_e5d0_4d42_afc0_5121ba425c8d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurn_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetRecorderDriveLetter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdrive: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Burn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Burn: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub HasRecordableDrive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfhasrecorder: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasRecordableDrive: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICDBurnExt(::windows::core::IUnknown);
impl ICDBurnExt {
    pub unsafe fn GetSupportedActionTypes(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSupportedActionTypes)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(ICDBurnExt, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICDBurnExt {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurnExt {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurnExt {}
impl ::core::fmt::Debug for ICDBurnExt {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurnExt").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICDBurnExt {
    type Vtable = ICDBurnExt_Vtbl;
}
unsafe impl ::windows::core::Interface for ICDBurnExt {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2271dcca_74fc_4414_8fb7_c56b05ace2d7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurnExt_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSupportedActionTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwactions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICategorizer(::windows::core::IUnknown);
impl ICategorizer {
    pub unsafe fn GetDescription(&self, pszdesc: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDescription)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pszdesc.as_ptr()), pszdesc.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCategory)(::windows::core::Vtable::as_raw(self), cidl, ::core::mem::transmute(apidl), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetCategoryInfo(&self, dwcategoryid: u32) -> ::windows::core::Result<CATEGORY_INFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCategoryInfo)(::windows::core::Vtable::as_raw(self), dwcategoryid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CATEGORY_INFO>(result__)
    }
    pub unsafe fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CompareCategory)(::windows::core::Vtable::as_raw(self), csfflags, dwcategoryid1, dwcategoryid2).ok()
    }
}
::windows::core::interface_hierarchy!(ICategorizer, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICategorizer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategorizer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategorizer {}
impl ::core::fmt::Debug for ICategorizer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategorizer").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICategorizer {
    type Vtable = ICategorizer_Vtbl;
}
unsafe impl ::windows::core::Interface for ICategorizer {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3b14589_9174_49a8_89a3_06a1ae2b9ba7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategorizer_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdesc: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCategory: usize,
    pub GetCategoryInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> ::windows::core::HRESULT,
    pub CompareCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICategoryProvider(::windows::core::IUnknown);
impl ICategoryProvider {
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn CanCategorizeOnSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CanCategorizeOnSCID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetDefaultCategory(&self, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDefaultCategory)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetCategoryForSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCategoryForSCID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pscid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(&self) -> ::windows::core::Result<super::super::System::Com::IEnumGUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumCategories)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    pub unsafe fn GetCategoryName(&self, pguid: *const ::windows::core::GUID, pszname: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCategoryName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pszname.as_ptr()), pszname.len() as _).ok()
    }
    pub unsafe fn CreateCategory<T>(&self, pguid: *const ::windows::core::GUID) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateCategory)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pguid), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
::windows::core::interface_hierarchy!(ICategoryProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICategoryProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategoryProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategoryProvider {}
impl ::core::fmt::Debug for ICategoryProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategoryProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICategoryProvider {
    type Vtable = ICategoryProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for ICategoryProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9af64809_5864_4c26_a720_c1f78c086ee3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategoryProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub CanCategorizeOnSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    CanCategorizeOnSCID: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetDefaultCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetDefaultCategory: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetCategoryForSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetCategoryForSCID: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCategories: usize,
    pub GetCategoryName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pszname: ::windows::core::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    pub CreateCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IColumnManager(::windows::core::IUnknown);
impl IColumnManager {
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetColumnInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetColumnInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetColumnCount)(::windows::core::Vtable::as_raw(self), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: &mut [PropertiesSystem::PROPERTYKEY]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetColumns)(::windows::core::Vtable::as_raw(self), dwflags, ::core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumns(&self, rgkeyorder: &[PropertiesSystem::PROPERTYKEY]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetColumns)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len() as _).ok()
    }
}
::windows::core::interface_hierarchy!(IColumnManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnManager {}
impl ::core::fmt::Debug for IColumnManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnManager {
    type Vtable = IColumnManager_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8ec27bb_3f3b_4042_b10a_4acfd924d453);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumnInfo: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    pub GetColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, pucount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut PropertiesSystem::PROPERTYKEY, ccolumns: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumns: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rgkeyorder: *const PropertiesSystem::PROPERTYKEY, cvisible: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumns: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IColumnProvider(::windows::core::IUnknown);
impl IColumnProvider {
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psci)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32) -> ::windows::core::Result<SHCOLUMNINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetColumnInfo)(::windows::core::Vtable::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SHCOLUMNINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetItemData(&self, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetItemData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pscid), ::core::mem::transmute(pscd), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
::windows::core::interface_hierarchy!(IColumnProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnProvider {}
impl ::core::fmt::Debug for IColumnProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnProvider {
    type Vtable = IColumnProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8025004_1c42_11d2_be2c_00a0c9a83da1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psci: *const SHCOLUMNINIT) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, psci: *mut SHCOLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetColumnInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetItemData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA, pvardata: *mut ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetItemData: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser(::windows::core::IUnknown);
impl ICommDlgBrowser {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).OnDefaultCommand)(::windows::core::Vtable::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).OnStateChange)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).IncludeObject)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
}
::windows::core::interface_hierarchy!(ICommDlgBrowser, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommDlgBrowser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser {}
impl ::core::fmt::Debug for ICommDlgBrowser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommDlgBrowser {
    type Vtable = ICommDlgBrowser_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214f1_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnDefaultCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnDefaultCommand: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnStateChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, uchange: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnStateChange: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub IncludeObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    IncludeObject: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser2(::windows::core::IUnknown);
impl ICommDlgBrowser2 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.OnDefaultCommand)(::windows::core::Vtable::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.OnStateChange)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.IncludeObject)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, P0>(&self, ppshv: P0, dwnotifytype: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).Notify)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), dwnotifytype).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<'a, P0>(&self, ppshv: P0, psztext: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).GetDefaultMenuText)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(psztext.as_ptr()), psztext.len() as _).ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetViewFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(ICommDlgBrowser2, ::windows::core::IUnknown, ICommDlgBrowser);
impl ::core::clone::Clone for ICommDlgBrowser2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser2 {}
impl ::core::fmt::Debug for ICommDlgBrowser2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommDlgBrowser2 {
    type Vtable = ICommDlgBrowser2_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10339516_2894_11d2_9039_00c04f8eeb3e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser2_Vtbl {
    pub base__: ICommDlgBrowser_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, dwnotifytype: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    Notify: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetDefaultMenuText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, psztext: ::windows::core::PWSTR, cchmax: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetDefaultMenuText: usize,
    pub GetViewFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICommDlgBrowser3(::windows::core::IUnknown);
impl ICommDlgBrowser3 {
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.OnDefaultCommand)(::windows::core::Vtable::as_raw(self), ppshv.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, P0>(&self, ppshv: P0, uchange: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.OnStateChange)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), uchange).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.IncludeObject)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, P0>(&self, ppshv: P0, dwnotifytype: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Notify)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), dwnotifytype).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<'a, P0>(&self, ppshv: P0, psztext: &mut [u16]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).base__.GetDefaultMenuText)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), ::core::mem::transmute(psztext.as_ptr()), psztext.len() as _).ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetViewFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnColumnClicked<'a, P0>(&self, ppshv: P0, icolumn: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).OnColumnClicked)(::windows::core::Vtable::as_raw(self), ppshv.into().abi(), icolumn).ok()
    }
    pub unsafe fn GetCurrentFilter(&self, pszfilespec: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCurrentFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pszfilespec.as_ptr()), pszfilespec.len() as _).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Ole\"`*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnPreViewCreated<'a, P0>(&self, ppshv: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellView>>,
    {
        (::windows::core::Vtable::vtable(self).OnPreViewCreated)(::windows::core::Vtable::as_raw(self), ppshv.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(ICommDlgBrowser3, ::windows::core::IUnknown, ICommDlgBrowser, ICommDlgBrowser2);
impl ::core::clone::Clone for ICommDlgBrowser3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser3 {}
impl ::core::fmt::Debug for ICommDlgBrowser3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommDlgBrowser3 {
    type Vtable = ICommDlgBrowser3_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8ad25a1_3294_41ee_8165_71174bd01c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser3_Vtbl {
    pub base__: ICommDlgBrowser2_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnColumnClicked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void, icolumn: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnColumnClicked: usize,
    pub GetCurrentFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilespec: ::windows::core::PWSTR, cchfilespec: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnPreViewCreated: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnPreViewCreated: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IComputerInfoChangeNotify(::windows::core::IUnknown);
impl IComputerInfoChangeNotify {
    pub unsafe fn ComputerInfoChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ComputerInfoChanged)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IComputerInfoChangeNotify, ::windows::core::IUnknown);
impl ::core::clone::Clone for IComputerInfoChangeNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IComputerInfoChangeNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IComputerInfoChangeNotify {}
impl ::core::fmt::Debug for IComputerInfoChangeNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IComputerInfoChangeNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IComputerInfoChangeNotify {
    type Vtable = IComputerInfoChangeNotify_Vtbl;
}
unsafe impl ::windows::core::Interface for IComputerInfoChangeNotify {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0df60d92_6818_46d6_b358_d66170dde466);
}
#[repr(C)]
#[doc(hidden)]
pub struct IComputerInfoChangeNotify_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ComputerInfoChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IConnectableCredentialProviderCredential(::windows::core::IUnknown);
impl IConnectableCredentialProviderCredential {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Advise)(::windows::core::Vtable::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UnAdvise)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.SetSelected)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetDeselected)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetFieldState)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetBitmapValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSubmitButtonValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetComboBoxValueCount)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetComboBoxValueAt)(::windows::core::Vtable::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetComboBoxSelectedValue)(::windows::core::Vtable::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.CommandLinkClicked)(::windows::core::Vtable::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetSerialization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Vtable::vtable(self).base__.ReportResult)(::windows::core::Vtable::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    pub unsafe fn Connect<'a, P0>(&self, pqcws: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IQueryContinueWithStatus>>,
    {
        (::windows::core::Vtable::vtable(self).Connect)(::windows::core::Vtable::as_raw(self), pqcws.into().abi()).ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Disconnect)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IConnectableCredentialProviderCredential, ::windows::core::IUnknown, ICredentialProviderCredential);
impl ::core::clone::Clone for IConnectableCredentialProviderCredential {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConnectableCredentialProviderCredential {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConnectableCredentialProviderCredential {}
impl ::core::fmt::Debug for IConnectableCredentialProviderCredential {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConnectableCredentialProviderCredential").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IConnectableCredentialProviderCredential {
    type Vtable = IConnectableCredentialProviderCredential_Vtbl;
}
unsafe impl ::windows::core::Interface for IConnectableCredentialProviderCredential {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9387928b_ac75_4bf9_8ab2_2b93c4a55290);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConnectableCredentialProviderCredential_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub Connect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pqcws: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContactManagerInterop(::windows::core::IUnknown);
impl IContactManagerInterop {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowContactCardForWindow<'a, P0, P1>(&self, appwindow: P0, contact: P1, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).ShowContactCardForWindow)(::windows::core::Vtable::as_raw(self), appwindow.into(), contact.into().abi(), ::core::mem::transmute(selection), preferredplacement).ok()
    }
}
::windows::core::interface_hierarchy!(IContactManagerInterop, ::windows::core::IUnknown);
impl ::core::clone::Clone for IContactManagerInterop {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContactManagerInterop {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContactManagerInterop {}
impl ::core::fmt::Debug for IContactManagerInterop {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContactManagerInterop").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContactManagerInterop {
    type Vtable = IContactManagerInterop_Vtbl;
}
unsafe impl ::windows::core::Interface for IContactManagerInterop {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x99eacba7_e073_43b6_a896_55afe48a0833);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContactManagerInterop_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowContactCardForWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appwindow: super::super::Foundation::HWND, contact: *mut ::core::ffi::c_void, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowContactCardForWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu(::windows::core::IUnknown);
impl IContextMenu {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Vtable::vtable(self).QueryContextMenu)(::windows::core::Vtable::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).InvokeCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: ::core::option::Option<*mut u32>, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCommandString)(::windows::core::Vtable::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszname), cchmax).ok()
    }
}
::windows::core::interface_hierarchy!(IContextMenu, ::windows::core::IUnknown);
impl ::core::clone::Clone for IContextMenu {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu {}
impl ::core::fmt::Debug for IContextMenu {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContextMenu {
    type Vtable = IContextMenu_Vtbl;
}
unsafe impl ::windows::core::Interface for IContextMenu {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214e4_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub QueryContextMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmenu: super::WindowsAndMessaging::HMENU, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    QueryContextMenu: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InvokeCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InvokeCommand: usize,
    pub GetCommandString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idcmd: usize, utype: u32, preserved: *mut u32, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu2(::windows::core::IUnknown);
impl IContextMenu2 {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Vtable::vtable(self).base__.QueryContextMenu)(::windows::core::Vtable::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.InvokeCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: ::core::option::Option<*mut u32>, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetCommandString)(::windows::core::Vtable::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszname), cchmax).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).HandleMenuMsg)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IContextMenu2, ::windows::core::IUnknown, IContextMenu);
impl ::core::clone::Clone for IContextMenu2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu2 {}
impl ::core::fmt::Debug for IContextMenu2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContextMenu2 {
    type Vtable = IContextMenu2_Vtbl;
}
unsafe impl ::windows::core::Interface for IContextMenu2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214f4_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu2_Vtbl {
    pub base__: IContextMenu_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleMenuMsg: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleMenuMsg: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenu3(::windows::core::IUnknown);
impl IContextMenu3 {
    #[doc = "*Required features: `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<'a, P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::WindowsAndMessaging::HMENU>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.QueryContextMenu)(::windows::core::Vtable::as_raw(self), hmenu.into(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.InvokeCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pici)).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: ::core::option::Option<*mut u32>, pszname: ::windows::core::PSTR, cchmax: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetCommandString)(::windows::core::Vtable::as_raw(self), idcmd, utype, ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pszname), cchmax).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).base__.HandleMenuMsg)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleMenuMsg2<'a, P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> ::windows::core::Result<super::super::Foundation::LRESULT>
    where
        P0: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P1: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HandleMenuMsg2)(::windows::core::Vtable::as_raw(self), umsg, wparam.into(), lparam.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::LRESULT>(result__)
    }
}
::windows::core::interface_hierarchy!(IContextMenu3, ::windows::core::IUnknown, IContextMenu, IContextMenu2);
impl ::core::clone::Clone for IContextMenu3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenu3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenu3 {}
impl ::core::fmt::Debug for IContextMenu3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenu3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContextMenu3 {
    type Vtable = IContextMenu3_Vtbl;
}
unsafe impl ::windows::core::Interface for IContextMenu3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcfce0a0_ec17_11d0_8d10_00a0c90f2719);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu3_Vtbl {
    pub base__: IContextMenu2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleMenuMsg2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM, plresult: *mut super::super::Foundation::LRESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleMenuMsg2: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenuCB(::windows::core::IUnknown);
impl IContextMenuCB {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CallBack<'a, P0, P1, P2, P3, P4>(&self, psf: P0, hwndowner: P1, pdtobj: P2, umsg: u32, wparam: P3, lparam: P4) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
        P3: ::std::convert::Into<super::super::Foundation::WPARAM>,
        P4: ::std::convert::Into<super::super::Foundation::LPARAM>,
    {
        (::windows::core::Vtable::vtable(self).CallBack)(::windows::core::Vtable::as_raw(self), psf.into().abi(), hwndowner.into(), pdtobj.into().abi(), umsg, wparam.into(), lparam.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IContextMenuCB, ::windows::core::IUnknown);
impl ::core::clone::Clone for IContextMenuCB {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenuCB {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenuCB {}
impl ::core::fmt::Debug for IContextMenuCB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenuCB").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContextMenuCB {
    type Vtable = IContextMenuCB_Vtbl;
}
unsafe impl ::windows::core::Interface for IContextMenuCB {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3409e930_5a39_11d1_83fa_00a0c90dc849);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuCB_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psf: *mut ::core::ffi::c_void, hwndowner: super::super::Foundation::HWND, pdtobj: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CallBack: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IContextMenuSite(::windows::core::IUnknown);
impl IContextMenuSite {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DoContextMenuPopup<'a, P0>(&self, punkcontextmenu: P0, fflags: u32, pt: super::super::Foundation::POINT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).DoContextMenuPopup)(::windows::core::Vtable::as_raw(self), punkcontextmenu.into().abi(), fflags, ::core::mem::transmute(pt)).ok()
    }
}
::windows::core::interface_hierarchy!(IContextMenuSite, ::windows::core::IUnknown);
impl ::core::clone::Clone for IContextMenuSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IContextMenuSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IContextMenuSite {}
impl ::core::fmt::Debug for IContextMenuSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IContextMenuSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IContextMenuSite {
    type Vtable = IContextMenuSite_Vtbl;
}
unsafe impl ::windows::core::Interface for IContextMenuSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0811aebe_0b87_4c54_9e72_548cf649016b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DoContextMenuPopup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkcontextmenu: *mut ::core::ffi::c_void, fflags: u32, pt: super::super::Foundation::POINT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DoContextMenuPopup: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICopyHookA(::windows::core::IUnknown);
impl ICopyHookA {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CopyCallback<'a, P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCSTR>,
        P2: ::std::convert::Into<::windows::core::PCSTR>,
    {
        (::windows::core::Vtable::vtable(self).CopyCallback)(::windows::core::Vtable::as_raw(self), hwnd.into(), wfunc, wflags, pszsrcfile.into(), dwsrcattribs, pszdestfile.into(), dwdestattribs)
    }
}
::windows::core::interface_hierarchy!(ICopyHookA, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICopyHookA {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICopyHookA {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICopyHookA {}
impl ::core::fmt::Debug for ICopyHookA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICopyHookA").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICopyHookA {
    type Vtable = ICopyHookA_Vtbl;
}
unsafe impl ::windows::core::Interface for ICopyHookA {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214ef_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookA_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CopyCallback: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: ::windows::core::PCSTR, dwsrcattribs: u32, pszdestfile: ::windows::core::PCSTR, dwdestattribs: u32) -> u32,
    #[cfg(not(feature = "Win32_Foundation"))]
    CopyCallback: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICopyHookW(::windows::core::IUnknown);
impl ICopyHookW {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CopyCallback<'a, P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).CopyCallback)(::windows::core::Vtable::as_raw(self), hwnd.into(), wfunc, wflags, pszsrcfile.into(), dwsrcattribs, pszdestfile.into(), dwdestattribs)
    }
}
::windows::core::interface_hierarchy!(ICopyHookW, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICopyHookW {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICopyHookW {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICopyHookW {}
impl ::core::fmt::Debug for ICopyHookW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICopyHookW").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICopyHookW {
    type Vtable = ICopyHookW_Vtbl;
}
unsafe impl ::windows::core::Interface for ICopyHookW {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214fc_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookW_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CopyCallback: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: ::windows::core::PCWSTR, dwsrcattribs: u32, pszdestfile: ::windows::core::PCWSTR, dwdestattribs: u32) -> u32,
    #[cfg(not(feature = "Win32_Foundation"))]
    CopyCallback: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICreateProcessInputs(::windows::core::IUnknown);
impl ICreateProcessInputs {
    pub unsafe fn GetCreateFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCreateFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetCreateFlags(&self, dwcreationflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetCreateFlags)(::windows::core::Vtable::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn AddCreateFlags(&self, dwcreationflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddCreateFlags)(::windows::core::Vtable::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn SetHotKey(&self, whotkey: u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetHotKey)(::windows::core::Vtable::as_raw(self), whotkey).ok()
    }
    pub unsafe fn AddStartupFlags(&self, dwstartupinfoflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddStartupFlags)(::windows::core::Vtable::as_raw(self), dwstartupinfoflags).ok()
    }
    pub unsafe fn SetTitle<'a, P0>(&self, psztitle: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetTitle)(::windows::core::Vtable::as_raw(self), psztitle.into()).ok()
    }
    pub unsafe fn SetEnvironmentVariable<'a, P0, P1>(&self, pszname: P0, pszvalue: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetEnvironmentVariable)(::windows::core::Vtable::as_raw(self), pszname.into(), pszvalue.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ICreateProcessInputs, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICreateProcessInputs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreateProcessInputs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateProcessInputs {}
impl ::core::fmt::Debug for ICreateProcessInputs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateProcessInputs").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICreateProcessInputs {
    type Vtable = ICreateProcessInputs_Vtbl;
}
unsafe impl ::windows::core::Interface for ICreateProcessInputs {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf6ef6140_e26f_4d82_bac4_e9ba5fd239a8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateProcessInputs_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcreationflags: *mut u32) -> ::windows::core::HRESULT,
    pub SetCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcreationflags: u32) -> ::windows::core::HRESULT,
    pub AddCreateFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcreationflags: u32) -> ::windows::core::HRESULT,
    pub SetHotKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, whotkey: u16) -> ::windows::core::HRESULT,
    pub AddStartupFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstartupinfoflags: u32) -> ::windows::core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztitle: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetEnvironmentVariable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICreatingProcess(::windows::core::IUnknown);
impl ICreatingProcess {
    pub unsafe fn OnCreating<'a, P0>(&self, pcpi: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICreateProcessInputs>>,
    {
        (::windows::core::Vtable::vtable(self).OnCreating)(::windows::core::Vtable::as_raw(self), pcpi.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(ICreatingProcess, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICreatingProcess {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreatingProcess {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreatingProcess {}
impl ::core::fmt::Debug for ICreatingProcess {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreatingProcess").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICreatingProcess {
    type Vtable = ICreatingProcess_Vtbl;
}
unsafe impl ::windows::core::Interface for ICreatingProcess {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2b937a9_3110_4398_8a56_f34c6342d244);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreatingProcess_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnCreating: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpi: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProvider(::windows::core::IUnknown);
impl ICredentialProvider {
    pub unsafe fn SetUsageScenario(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetUsageScenario)(::windows::core::Vtable::as_raw(self), cpus, dwflags).ok()
    }
    pub unsafe fn SetSerialization(&self, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetSerialization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcpcs)).ok()
    }
    pub unsafe fn Advise<'a, P0>(&self, pcpe: P0, upadvisecontext: usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderEvents>>,
    {
        (::windows::core::Vtable::vtable(self).Advise)(::windows::core::Vtable::as_raw(self), pcpe.into().abi(), upadvisecontext).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UnAdvise)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldDescriptorCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFieldDescriptorCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetFieldDescriptorAt(&self, dwindex: u32) -> ::windows::core::Result<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFieldDescriptorAt)(::windows::core::Vtable::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCredentialCount(&self, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCredentialCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwcount), ::core::mem::transmute(pdwdefault), ::core::mem::transmute(pbautologonwithdefault)).ok()
    }
    pub unsafe fn GetCredentialAt(&self, dwindex: u32) -> ::windows::core::Result<ICredentialProviderCredential> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCredentialAt)(::windows::core::Vtable::as_raw(self), dwindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICredentialProviderCredential>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProvider {}
impl ::core::fmt::Debug for ICredentialProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProvider {
    type Vtable = ICredentialProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd27c3481_5a1c_45b2_8aaa_c20ebbe8229e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetUsageScenario: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> ::windows::core::HRESULT,
    pub SetSerialization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::HRESULT,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpe: *mut ::core::ffi::c_void, upadvisecontext: usize) -> ::windows::core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFieldDescriptorCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetFieldDescriptorAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, ppcpfd: *mut *mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCredentialCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCredentialCount: usize,
    pub GetCredentialAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, ppcpc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredential(::windows::core::IUnknown);
impl ICredentialProviderCredential {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Vtable::vtable(self).Advise)(::windows::core::Vtable::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UnAdvise)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).SetSelected)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetDeselected)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetFieldState)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBitmapValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSubmitButtonValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetComboBoxValueCount)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetComboBoxValueAt)(::windows::core::Vtable::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetComboBoxSelectedValue)(::windows::core::Vtable::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CommandLinkClicked)(::windows::core::Vtable::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSerialization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Vtable::vtable(self).ReportResult)(::windows::core::Vtable::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderCredential, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderCredential {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredential {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredential {}
impl ::core::fmt::Debug for ICredentialProviderCredential {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredential").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderCredential {
    type Vtable = ICredentialProviderCredential_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredential {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63913a93_40c1_481a_818d_4072ff8c70cc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredential_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpce: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSelected: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbautologon: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSelected: usize,
    pub SetDeselected: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFieldState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::HRESULT,
    pub GetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmapValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, phbmp: *mut super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmapValue: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCheckboxValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCheckboxValue: usize,
    pub GetSubmitButtonValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pdwadjacentto: *mut u32) -> ::windows::core::HRESULT,
    pub GetComboBoxValueCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::HRESULT,
    pub GetComboBoxValueAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, dwitem: u32, ppszitem: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, psz: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCheckboxValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, bchecked: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCheckboxValue: usize,
    pub SetComboBoxSelectedValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::HRESULT,
    pub CommandLinkClicked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfieldid: u32) -> ::windows::core::HRESULT,
    pub GetSerialization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ReportResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ntsstatus: super::super::Foundation::NTSTATUS, ntssubstatus: super::super::Foundation::NTSTATUS, ppszoptionalstatustext: *mut ::windows::core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReportResult: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredential2(::windows::core::IUnknown);
impl ICredentialProviderCredential2 {
    pub unsafe fn Advise<'a, P0>(&self, pcpce: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredentialEvents>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Advise)(::windows::core::Vtable::as_raw(self), pcpce.into().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UnAdvise)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.SetSelected)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetDeselected)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetFieldState)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetBitmapValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSubmitButtonValue)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetComboBoxValueCount)(::windows::core::Vtable::as_raw(self), dwfieldid, ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetComboBoxValueAt)(::windows::core::Vtable::as_raw(self), dwfieldid, dwitem, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetStringValue<'a, P0>(&self, dwfieldid: u32, psz: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetStringValue)(::windows::core::Vtable::as_raw(self), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, P0>(&self, dwfieldid: u32, bchecked: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetCheckboxValue)(::windows::core::Vtable::as_raw(self), dwfieldid, bchecked.into()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetComboBoxSelectedValue)(::windows::core::Vtable::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.CommandLinkClicked)(::windows::core::Vtable::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetSerialization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
        P1: ::std::convert::Into<super::super::Foundation::NTSTATUS>,
    {
        (::windows::core::Vtable::vtable(self).base__.ReportResult)(::windows::core::Vtable::as_raw(self), ntsstatus.into(), ntssubstatus.into(), ::core::mem::transmute(ppszoptionalstatustext.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    pub unsafe fn GetUserSid(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetUserSid)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderCredential2, ::windows::core::IUnknown, ICredentialProviderCredential);
impl ::core::clone::Clone for ICredentialProviderCredential2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredential2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredential2 {}
impl ::core::fmt::Debug for ICredentialProviderCredential2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredential2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderCredential2 {
    type Vtable = ICredentialProviderCredential2_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredential2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd672c54_40ea_4d6e_9b49_cfb1a7507bd7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredential2_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub GetUserSid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialEvents(::windows::core::IUnknown);
impl ICredentialProviderCredentialEvents {
    pub unsafe fn SetFieldState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldState)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, cpfs).ok()
    }
    pub unsafe fn SetFieldInteractiveState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldInteractiveState)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, cpfis).ok()
    }
    pub unsafe fn SetFieldString<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, psz: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldString)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFieldCheckbox<'a, P0, P1, P2>(&self, pcpc: P0, dwfieldid: u32, bchecked: P1, pszlabel: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldCheckbox)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, bchecked.into(), pszlabel.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFieldBitmap<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, hbmp: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldBitmap)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, hbmp.into()).ok()
    }
    pub unsafe fn SetFieldComboBoxSelectedItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldComboBoxSelectedItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn DeleteFieldComboBoxItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).DeleteFieldComboBoxItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwitem).ok()
    }
    pub unsafe fn AppendFieldComboBoxItem<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, pszitem: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).AppendFieldComboBoxItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, pszitem.into()).ok()
    }
    pub unsafe fn SetFieldSubmitButton<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldSubmitButton)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwadjacentto).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCreatingWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OnCreatingWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderCredentialEvents, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderCredentialEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialEvents {}
impl ::core::fmt::Debug for ICredentialProviderCredentialEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderCredentialEvents {
    type Vtable = ICredentialProviderCredentialEvents_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfa6fa76b_66b7_4b11_95f1_86171118e816);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetFieldState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::HRESULT,
    pub SetFieldInteractiveState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::HRESULT,
    pub SetFieldString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, psz: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetFieldCheckbox: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, bchecked: super::super::Foundation::BOOL, pszlabel: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetFieldCheckbox: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetFieldBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, hbmp: super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetFieldBitmap: usize,
    pub SetFieldComboBoxSelectedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::HRESULT,
    pub DeleteFieldComboBoxItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwitem: u32) -> ::windows::core::HRESULT,
    pub AppendFieldComboBoxItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, pszitem: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetFieldSubmitButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpc: *mut ::core::ffi::c_void, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCreatingWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndowner: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCreatingWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialEvents2(::windows::core::IUnknown);
impl ICredentialProviderCredentialEvents2 {
    pub unsafe fn SetFieldState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldState)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, cpfs).ok()
    }
    pub unsafe fn SetFieldInteractiveState<'a, P0>(&self, pcpc: P0, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldInteractiveState)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, cpfis).ok()
    }
    pub unsafe fn SetFieldString<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, psz: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldString)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, psz.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFieldCheckbox<'a, P0, P1, P2>(&self, pcpc: P0, dwfieldid: u32, bchecked: P1, pszlabel: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldCheckbox)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, bchecked.into(), pszlabel.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFieldBitmap<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, hbmp: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<super::super::Graphics::Gdi::HBITMAP>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldBitmap)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, hbmp.into()).ok()
    }
    pub unsafe fn SetFieldComboBoxSelectedItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldComboBoxSelectedItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn DeleteFieldComboBoxItem<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).base__.DeleteFieldComboBoxItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwitem).ok()
    }
    pub unsafe fn AppendFieldComboBoxItem<'a, P0, P1>(&self, pcpc: P0, dwfieldid: u32, pszitem: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.AppendFieldComboBoxItem)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, pszitem.into()).ok()
    }
    pub unsafe fn SetFieldSubmitButton<'a, P0>(&self, pcpc: P0, dwfieldid: u32, dwadjacentto: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetFieldSubmitButton)(::windows::core::Vtable::as_raw(self), pcpc.into().abi(), dwfieldid, dwadjacentto).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCreatingWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.OnCreatingWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn BeginFieldUpdates(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).BeginFieldUpdates)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn EndFieldUpdates(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).EndFieldUpdates)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SetFieldOptions<'a, P0>(&self, credential: P0, fieldid: u32, options: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderCredential>>,
    {
        (::windows::core::Vtable::vtable(self).SetFieldOptions)(::windows::core::Vtable::as_raw(self), credential.into().abi(), fieldid, options).ok()
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderCredentialEvents2, ::windows::core::IUnknown, ICredentialProviderCredentialEvents);
impl ::core::clone::Clone for ICredentialProviderCredentialEvents2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialEvents2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialEvents2 {}
impl ::core::fmt::Debug for ICredentialProviderCredentialEvents2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialEvents2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderCredentialEvents2 {
    type Vtable = ICredentialProviderCredentialEvents2_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialEvents2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb53c00b6_9922_4b78_b1f4_ddfe774dc39b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialEvents2_Vtbl {
    pub base__: ICredentialProviderCredentialEvents_Vtbl,
    pub BeginFieldUpdates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndFieldUpdates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetFieldOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, credential: *mut ::core::ffi::c_void, fieldid: u32, options: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderCredentialWithFieldOptions(::windows::core::IUnknown);
impl ICredentialProviderCredentialWithFieldOptions {
    pub unsafe fn GetFieldOptions(&self, fieldid: u32) -> ::windows::core::Result<CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetFieldOptions)(::windows::core::Vtable::as_raw(self), fieldid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderCredentialWithFieldOptions, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderCredentialWithFieldOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderCredentialWithFieldOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderCredentialWithFieldOptions {}
impl ::core::fmt::Debug for ICredentialProviderCredentialWithFieldOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderCredentialWithFieldOptions").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderCredentialWithFieldOptions {
    type Vtable = ICredentialProviderCredentialWithFieldOptions_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderCredentialWithFieldOptions {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdbc6fb30_c843_49e3_a645_573e6f39446a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderCredentialWithFieldOptions_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetFieldOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fieldid: u32, options: *mut CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderEvents(::windows::core::IUnknown);
impl ICredentialProviderEvents {
    pub unsafe fn CredentialsChanged(&self, upadvisecontext: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CredentialsChanged)(::windows::core::Vtable::as_raw(self), upadvisecontext).ok()
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderEvents, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderEvents {}
impl ::core::fmt::Debug for ICredentialProviderEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderEvents {
    type Vtable = ICredentialProviderEvents_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34201e5a_a787_41a3_a5a4_bd6dcf2a854e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CredentialsChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, upadvisecontext: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderFilter(::windows::core::IUnknown);
impl ICredentialProviderFilter {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Filter(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32, rgclsidproviders: *const ::windows::core::GUID, rgballow: *mut super::super::Foundation::BOOL, cproviders: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Filter)(::windows::core::Vtable::as_raw(self), cpus, dwflags, ::core::mem::transmute(rgclsidproviders), ::core::mem::transmute(rgballow), cproviders).ok()
    }
    pub unsafe fn UpdateRemoteCredential(&self, pcpcsin: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::Result<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).UpdateRemoteCredential)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcpcsin), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderFilter, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderFilter {}
impl ::core::fmt::Debug for ICredentialProviderFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderFilter {
    type Vtable = ICredentialProviderFilter_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderFilter {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa5da53f9_d475_4080_a120_910c4a739880);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderFilter_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32, rgclsidproviders: *const ::windows::core::GUID, rgballow: *mut super::super::Foundation::BOOL, cproviders: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Filter: usize,
    pub UpdateRemoteCredential: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcpcsin: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, pcpcsout: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderSetUserArray(::windows::core::IUnknown);
impl ICredentialProviderSetUserArray {
    pub unsafe fn SetUserArray<'a, P0>(&self, users: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICredentialProviderUserArray>>,
    {
        (::windows::core::Vtable::vtable(self).SetUserArray)(::windows::core::Vtable::as_raw(self), users.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderSetUserArray, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderSetUserArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderSetUserArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderSetUserArray {}
impl ::core::fmt::Debug for ICredentialProviderSetUserArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderSetUserArray").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderSetUserArray {
    type Vtable = ICredentialProviderSetUserArray_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderSetUserArray {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x095c1484_1c0c_4388_9c6d_500e61bf84bd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderSetUserArray_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetUserArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, users: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderUser(::windows::core::IUnknown);
impl ICredentialProviderUser {
    pub unsafe fn GetSid(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSid)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetProviderID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetProviderID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetStringValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetStringValue)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(key), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetValue)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(key), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::StructuredStorage::PROPVARIANT>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderUser, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderUser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderUser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderUser {}
impl ::core::fmt::Debug for ICredentialProviderUser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderUser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderUser {
    type Vtable = ICredentialProviderUser_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderUser {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x13793285_3ea6_40fd_b420_15f47da41fbb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderUser_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetProviderID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, providerid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetStringValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: *const PropertiesSystem::PROPERTYKEY, stringvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetStringValue: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: *const PropertiesSystem::PROPERTYKEY, value: *mut ::core::mem::ManuallyDrop<super::super::System::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetValue: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICredentialProviderUserArray(::windows::core::IUnknown);
impl ICredentialProviderUserArray {
    pub unsafe fn SetProviderFilter(&self, guidprovidertofilterto: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetProviderFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(guidprovidertofilterto)).ok()
    }
    pub unsafe fn GetAccountOptions(&self) -> ::windows::core::Result<CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetAccountOptions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetAt(&self, userindex: u32) -> ::windows::core::Result<ICredentialProviderUser> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetAt)(::windows::core::Vtable::as_raw(self), userindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICredentialProviderUser>(result__)
    }
}
::windows::core::interface_hierarchy!(ICredentialProviderUserArray, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICredentialProviderUserArray {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICredentialProviderUserArray {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICredentialProviderUserArray {}
impl ::core::fmt::Debug for ICredentialProviderUserArray {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICredentialProviderUserArray").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICredentialProviderUserArray {
    type Vtable = ICredentialProviderUserArray_Vtbl;
}
unsafe impl ::windows::core::Interface for ICredentialProviderUserArray {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90c119ae_0f18_4520_a1f1_114366a40fe8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProviderUserArray_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetProviderFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidprovidertofilterto: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub GetAccountOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, credentialprovideraccountoptions: *mut CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usercount: *mut u32) -> ::windows::core::HRESULT,
    pub GetAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, userindex: u32, user: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICurrentItem(::windows::core::IUnknown);
impl ICurrentItem {
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetItemIDList(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItemIDList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn GetItem(&self) -> ::windows::core::Result<IShellItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItem>(result__)
    }
}
::windows::core::interface_hierarchy!(ICurrentItem, ::windows::core::IUnknown, IRelatedItem);
impl ::core::clone::Clone for ICurrentItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICurrentItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICurrentItem {}
impl ::core::fmt::Debug for ICurrentItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICurrentItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICurrentItem {
    type Vtable = ICurrentItem_Vtbl;
}
unsafe impl ::windows::core::Interface for ICurrentItem {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x240a7174_d653_4a1d_a6d3_d4943cfbfe3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICurrentItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICurrentWorkingDirectory(::windows::core::IUnknown);
impl ICurrentWorkingDirectory {
    pub unsafe fn GetDirectory(&self, pwzpath: &mut [u16]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDirectory)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pwzpath.as_ptr()), pwzpath.len() as _).ok()
    }
    pub unsafe fn SetDirectory<'a, P0>(&self, pwzpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetDirectory)(::windows::core::Vtable::as_raw(self), pwzpath.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ICurrentWorkingDirectory, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICurrentWorkingDirectory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICurrentWorkingDirectory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICurrentWorkingDirectory {}
impl ::core::fmt::Debug for ICurrentWorkingDirectory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICurrentWorkingDirectory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICurrentWorkingDirectory {
    type Vtable = ICurrentWorkingDirectory_Vtbl;
}
unsafe impl ::windows::core::Interface for ICurrentWorkingDirectory {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91956d21_9276_11d1_921a_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICurrentWorkingDirectory_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwzpath: ::windows::core::PWSTR, cchsize: u32) -> ::windows::core::HRESULT,
    pub SetDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwzpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct ICustomDestinationList(::windows::core::IUnknown);
impl ICustomDestinationList {
    pub unsafe fn SetAppID<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetAppID)(::windows::core::Vtable::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn BeginList<T>(&self, pcminslots: *mut u32) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).BeginList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcminslots), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AppendCategory<'a, P0, P1>(&self, pszcategory: P0, poa: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, Common::IObjectArray>>,
    {
        (::windows::core::Vtable::vtable(self).AppendCategory)(::windows::core::Vtable::as_raw(self), pszcategory.into(), poa.into().abi()).ok()
    }
    pub unsafe fn AppendKnownCategory(&self, category: KNOWNDESTCATEGORY) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AppendKnownCategory)(::windows::core::Vtable::as_raw(self), category).ok()
    }
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AddUserTasks<'a, P0>(&self, poa: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, Common::IObjectArray>>,
    {
        (::windows::core::Vtable::vtable(self).AddUserTasks)(::windows::core::Vtable::as_raw(self), poa.into().abi()).ok()
    }
    pub unsafe fn CommitList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CommitList)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetRemovedDestinations<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetRemovedDestinations)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn DeleteList<'a, P0>(&self, pszappid: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).DeleteList)(::windows::core::Vtable::as_raw(self), pszappid.into()).ok()
    }
    pub unsafe fn AbortList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AbortList)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ICustomDestinationList, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICustomDestinationList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICustomDestinationList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICustomDestinationList {}
impl ::core::fmt::Debug for ICustomDestinationList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICustomDestinationList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICustomDestinationList {
    type Vtable = ICustomDestinationList_Vtbl;
}
unsafe impl ::windows::core::Interface for ICustomDestinationList {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6332debf_87b5_4670_90c0_5e57b408a49e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICustomDestinationList_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub BeginList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcminslots: *mut u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AppendCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcategory: ::windows::core::PCWSTR, poa: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AppendCategory: usize,
    pub AppendKnownCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, category: KNOWNDESTCATEGORY) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AddUserTasks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poa: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AddUserTasks: usize,
    pub CommitList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRemovedDestinations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DeleteList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AbortList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDataObjectAsyncCapability(::windows::core::IUnknown);
impl IDataObjectAsyncCapability {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAsyncMode<'a, P0>(&self, fdoopasync: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetAsyncMode)(::windows::core::Vtable::as_raw(self), fdoopasync.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAsyncMode(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetAsyncMode)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StartOperation<'a, P0>(&self, pbcreserved: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    {
        (::windows::core::Vtable::vtable(self).StartOperation)(::windows::core::Vtable::as_raw(self), pbcreserved.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InOperation(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).InOperation)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EndOperation<'a, P0>(&self, hresult: ::windows::core::HRESULT, pbcreserved: P0, dweffects: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IBindCtx>>,
    {
        (::windows::core::Vtable::vtable(self).EndOperation)(::windows::core::Vtable::as_raw(self), hresult, pbcreserved.into().abi(), dweffects).ok()
    }
}
::windows::core::interface_hierarchy!(IDataObjectAsyncCapability, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDataObjectAsyncCapability {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataObjectAsyncCapability {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataObjectAsyncCapability {}
impl ::core::fmt::Debug for IDataObjectAsyncCapability {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataObjectAsyncCapability").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDataObjectAsyncCapability {
    type Vtable = IDataObjectAsyncCapability_Vtbl;
}
unsafe impl ::windows::core::Interface for IDataObjectAsyncCapability {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d8b0590_f691_11d2_8ea9_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataObjectAsyncCapability_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAsyncMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdoopasync: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAsyncMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetAsyncMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisopasync: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetAsyncMode: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub StartOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbcreserved: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StartOperation: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub InOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfinasyncop: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InOperation: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EndOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hresult: ::windows::core::HRESULT, pbcreserved: *mut ::core::ffi::c_void, dweffects: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EndOperation: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDataObjectProvider(::windows::core::IUnknown);
impl IDataObjectProvider {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDataObject(&self) -> ::windows::core::Result<super::super::System::Com::IDataObject> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDataObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IDataObject>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetDataObject<'a, P0>(&self, dataobject: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IDataObject>>,
    {
        (::windows::core::Vtable::vtable(self).SetDataObject)(::windows::core::Vtable::as_raw(self), dataobject.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(IDataObjectProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDataObjectProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataObjectProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataObjectProvider {}
impl ::core::fmt::Debug for IDataObjectProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataObjectProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDataObjectProvider {
    type Vtable = IDataObjectProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for IDataObjectProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d25f6d6_4b2a_433c_9184_7c33ad35d001);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataObjectProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetDataObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dataobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetDataObject: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetDataObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dataobject: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetDataObject: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDataTransferManagerInterop(::windows::core::IUnknown);
impl IDataTransferManagerInterop {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetForWindow<'a, P0, T>(&self, appwindow: P0) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetForWindow)(::windows::core::Vtable::as_raw(self), appwindow.into(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowShareUIForWindow<'a, P0>(&self, appwindow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).ShowShareUIForWindow)(::windows::core::Vtable::as_raw(self), appwindow.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IDataTransferManagerInterop, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDataTransferManagerInterop {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataTransferManagerInterop {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataTransferManagerInterop {}
impl ::core::fmt::Debug for IDataTransferManagerInterop {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataTransferManagerInterop").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDataTransferManagerInterop {
    type Vtable = IDataTransferManagerInterop_Vtbl;
}
unsafe impl ::windows::core::Interface for IDataTransferManagerInterop {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3a3dcd6c_3eab_43dc_bcde_45671ce800c8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataTransferManagerInterop_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetForWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appwindow: super::super::Foundation::HWND, riid: *const ::windows::core::GUID, datatransfermanager: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetForWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowShareUIForWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appwindow: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowShareUIForWindow: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDefaultExtractIconInit(::windows::core::IUnknown);
impl IDefaultExtractIconInit {
    pub unsafe fn SetFlags(&self, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetFlags)(::windows::core::Vtable::as_raw(self), uflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Registry\"`*"]
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn SetKey<'a, P0>(&self, hkey: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::System::Registry::HKEY>,
    {
        (::windows::core::Vtable::vtable(self).SetKey)(::windows::core::Vtable::as_raw(self), hkey.into()).ok()
    }
    pub unsafe fn SetNormalIcon<'a, P0>(&self, pszfile: P0, iicon: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetNormalIcon)(::windows::core::Vtable::as_raw(self), pszfile.into(), iicon).ok()
    }
    pub unsafe fn SetOpenIcon<'a, P0>(&self, pszfile: P0, iicon: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetOpenIcon)(::windows::core::Vtable::as_raw(self), pszfile.into(), iicon).ok()
    }
    pub unsafe fn SetShortcutIcon<'a, P0>(&self, pszfile: P0, iicon: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetShortcutIcon)(::windows::core::Vtable::as_raw(self), pszfile.into(), iicon).ok()
    }
    pub unsafe fn SetDefaultIcon<'a, P0>(&self, pszfile: P0, iicon: i32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetDefaultIcon)(::windows::core::Vtable::as_raw(self), pszfile.into(), iicon).ok()
    }
}
::windows::core::interface_hierarchy!(IDefaultExtractIconInit, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDefaultExtractIconInit {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDefaultExtractIconInit {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDefaultExtractIconInit {}
impl ::core::fmt::Debug for IDefaultExtractIconInit {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDefaultExtractIconInit").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDefaultExtractIconInit {
    type Vtable = IDefaultExtractIconInit_Vtbl;
}
unsafe impl ::windows::core::Interface for IDefaultExtractIconInit {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x41ded17d_d6b3_4261_997d_88c60e4b1d58);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDefaultExtractIconInit_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Registry")]
    pub SetKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hkey: super::super::System::Registry::HKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    SetKey: usize,
    pub SetNormalIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfile: ::windows::core::PCWSTR, iicon: i32) -> ::windows::core::HRESULT,
    pub SetOpenIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfile: ::windows::core::PCWSTR, iicon: i32) -> ::windows::core::HRESULT,
    pub SetShortcutIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfile: ::windows::core::PCWSTR, iicon: i32) -> ::windows::core::HRESULT,
    pub SetDefaultIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfile: ::windows::core::PCWSTR, iicon: i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDefaultFolderMenuInitialize(::windows::core::IUnknown);
impl IDefaultFolderMenuInitialize {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn Initialize<'a, P0, P1, P2, P3>(&self, hwnd: P0, pcmcb: P1, pidlfolder: ::core::option::Option<*const Common::ITEMIDLIST>, psf: P2, apidl: &[*const Common::ITEMIDLIST], punkassociation: P3, ckeys: u32, akeys: ::core::option::Option<*const super::super::System::Registry::HKEY>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IContextMenuCB>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IShellFolder>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), hwnd.into(), pcmcb.into().abi(), ::core::mem::transmute(pidlfolder.unwrap_or(::std::ptr::null())), psf.into().abi(), apidl.len() as _, ::core::mem::transmute(apidl.as_ptr()), punkassociation.into().abi(), ckeys, ::core::mem::transmute(akeys.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn SetMenuRestrictions(&self, dfmrvalues: DEFAULT_FOLDER_MENU_RESTRICTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetMenuRestrictions)(::windows::core::Vtable::as_raw(self), dfmrvalues).ok()
    }
    pub unsafe fn GetMenuRestrictions(&self, dfmrmask: DEFAULT_FOLDER_MENU_RESTRICTIONS) -> ::windows::core::Result<DEFAULT_FOLDER_MENU_RESTRICTIONS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMenuRestrictions)(::windows::core::Vtable::as_raw(self), dfmrmask, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<DEFAULT_FOLDER_MENU_RESTRICTIONS>(result__)
    }
    pub unsafe fn SetHandlerClsid(&self, rclsid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetHandlerClsid)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rclsid)).ok()
    }
}
::windows::core::interface_hierarchy!(IDefaultFolderMenuInitialize, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDefaultFolderMenuInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDefaultFolderMenuInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDefaultFolderMenuInitialize {}
impl ::core::fmt::Debug for IDefaultFolderMenuInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDefaultFolderMenuInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDefaultFolderMenuInitialize {
    type Vtable = IDefaultFolderMenuInitialize_Vtbl;
}
unsafe impl ::windows::core::Interface for IDefaultFolderMenuInitialize {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7690aa79_f8fc_4615_a327_36f7d18f5d91);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDefaultFolderMenuInitialize_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pcmcb: *mut ::core::ffi::c_void, pidlfolder: *const Common::ITEMIDLIST, psf: *mut ::core::ffi::c_void, cidl: u32, apidl: *const *const Common::ITEMIDLIST, punkassociation: *mut ::core::ffi::c_void, ckeys: u32, akeys: *const super::super::System::Registry::HKEY) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common")))]
    Initialize: usize,
    pub SetMenuRestrictions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dfmrvalues: DEFAULT_FOLDER_MENU_RESTRICTIONS) -> ::windows::core::HRESULT,
    pub GetMenuRestrictions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dfmrmask: DEFAULT_FOLDER_MENU_RESTRICTIONS, pdfmrvalues: *mut DEFAULT_FOLDER_MENU_RESTRICTIONS) -> ::windows::core::HRESULT,
    pub SetHandlerClsid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDelegateFolder(::windows::core::IUnknown);
impl IDelegateFolder {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetItemAlloc<'a, P0>(&self, pmalloc: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::System::Com::IMalloc>>,
    {
        (::windows::core::Vtable::vtable(self).SetItemAlloc)(::windows::core::Vtable::as_raw(self), pmalloc.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(IDelegateFolder, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDelegateFolder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDelegateFolder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDelegateFolder {}
impl ::core::fmt::Debug for IDelegateFolder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDelegateFolder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDelegateFolder {
    type Vtable = IDelegateFolder_Vtbl;
}
unsafe impl ::windows::core::Interface for IDelegateFolder {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xadd8ba80_002b_11d0_8f0f_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDelegateFolder_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SetItemAlloc: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmalloc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetItemAlloc: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDelegateItem(::windows::core::IUnknown);
impl IDelegateItem {
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetItemIDList(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItemIDList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn GetItem(&self) -> ::windows::core::Result<IShellItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItem>(result__)
    }
}
::windows::core::interface_hierarchy!(IDelegateItem, ::windows::core::IUnknown, IRelatedItem);
impl ::core::clone::Clone for IDelegateItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDelegateItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDelegateItem {}
impl ::core::fmt::Debug for IDelegateItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDelegateItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDelegateItem {
    type Vtable = IDelegateItem_Vtbl;
}
unsafe impl ::windows::core::Interface for IDelegateItem {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c5a1c94_c951_4cb7_bb6d_3b93f30cce93);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDelegateItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[repr(transparent)]
pub struct IDeskBand(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBand {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn ContextSensitiveHelp<'a, P0>(&self, fentermode: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.ContextSensitiveHelp)(::windows::core::Vtable::as_raw(self), fentermode.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDW<'a, P0>(&self, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ShowDW)(::windows::core::Vtable::as_raw(self), fshow.into()).ok()
    }
    pub unsafe fn CloseDW(&self, dwreserved: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.CloseDW)(::windows::core::Vtable::as_raw(self), dwreserved).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResizeBorderDW<'a, P0, P1>(&self, prcborder: *const super::super::Foundation::RECT, punktoolbarsite: P0, freserved: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ResizeBorderDW)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prcborder), punktoolbarsite.into().abi(), freserved.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBandInfo(&self, dwbandid: u32, dwviewmode: u32, pdbi: *mut DESKBANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetBandInfo)(::windows::core::Vtable::as_raw(self), dwbandid, dwviewmode, ::core::mem::transmute(pdbi)).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
::windows::core::interface_hierarchy!(IDeskBand, ::windows::core::IUnknown, super::super::System::Ole::IOleWindow, IDockingWindow);
#[cfg(feature = "Win32_System_Ole")]
impl ::core::clone::Clone for IDeskBand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::PartialEq for IDeskBand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::Eq for IDeskBand {}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::fmt::Debug for IDeskBand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeskBand").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Vtable for IDeskBand {
    type Vtable = IDeskBand_Vtbl;
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Interface for IDeskBand {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeb0fe172_1a3a_11d0_89b3_00a0c90a90ac);
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
#[doc(hidden)]
pub struct IDeskBand_Vtbl {
    pub base__: IDockingWindow_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetBandInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, dwviewmode: u32, pdbi: *mut DESKBANDINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetBandInfo: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[repr(transparent)]
pub struct IDeskBand2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBand2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn ContextSensitiveHelp<'a, P0>(&self, fentermode: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.ContextSensitiveHelp)(::windows::core::Vtable::as_raw(self), fentermode.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDW<'a, P0>(&self, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.ShowDW)(::windows::core::Vtable::as_raw(self), fshow.into()).ok()
    }
    pub unsafe fn CloseDW(&self, dwreserved: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.CloseDW)(::windows::core::Vtable::as_raw(self), dwreserved).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResizeBorderDW<'a, P0, P1>(&self, prcborder: *const super::super::Foundation::RECT, punktoolbarsite: P0, freserved: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.ResizeBorderDW)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prcborder), punktoolbarsite.into().abi(), freserved.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBandInfo(&self, dwbandid: u32, dwviewmode: u32, pdbi: *mut DESKBANDINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetBandInfo)(::windows::core::Vtable::as_raw(self), dwbandid, dwviewmode, ::core::mem::transmute(pdbi)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanRenderComposited(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CanRenderComposited)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCompositionState<'a, P0>(&self, fcompositionenabled: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetCompositionState)(::windows::core::Vtable::as_raw(self), fcompositionenabled.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCompositionState(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCompositionState)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
#[cfg(feature = "Win32_System_Ole")]
::windows::core::interface_hierarchy!(IDeskBand2, ::windows::core::IUnknown, super::super::System::Ole::IOleWindow, IDockingWindow, IDeskBand);
#[cfg(feature = "Win32_System_Ole")]
impl ::core::clone::Clone for IDeskBand2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::PartialEq for IDeskBand2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::Eq for IDeskBand2 {}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::fmt::Debug for IDeskBand2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeskBand2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Vtable for IDeskBand2 {
    type Vtable = IDeskBand2_Vtbl;
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Interface for IDeskBand2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x79d16de4_abee_4021_8d9d_9169b261d657);
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
#[doc(hidden)]
pub struct IDeskBand2_Vtbl {
    pub base__: IDeskBand_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CanRenderComposited: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfcanrendercomposited: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CanRenderComposited: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCompositionState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fcompositionenabled: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCompositionState: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCompositionState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfcompositionenabled: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCompositionState: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDeskBandInfo(::windows::core::IUnknown);
impl IDeskBandInfo {
    pub unsafe fn GetDefaultBandWidth(&self, dwbandid: u32, dwviewmode: u32) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDefaultBandWidth)(::windows::core::Vtable::as_raw(self), dwbandid, dwviewmode, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
}
::windows::core::interface_hierarchy!(IDeskBandInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDeskBandInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDeskBandInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDeskBandInfo {}
impl ::core::fmt::Debug for IDeskBandInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeskBandInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDeskBandInfo {
    type Vtable = IDeskBandInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IDeskBandInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77e425fc_cbf9_4307_ba6a_bb5727745661);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDeskBandInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDefaultBandWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, dwviewmode: u32, pnwidth: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[repr(transparent)]
pub struct IDeskBar(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBar {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn ContextSensitiveHelp<'a, P0>(&self, fentermode: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ContextSensitiveHelp)(::windows::core::Vtable::as_raw(self), fentermode.into()).ok()
    }
    pub unsafe fn SetClient<'a, P0>(&self, punkclient: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).SetClient)(::windows::core::Vtable::as_raw(self), punkclient.into().abi()).ok()
    }
    pub unsafe fn GetClient(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetClient)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnPosRectChangeDB(&self, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnPosRectChangeDB)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prc)).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
::windows::core::interface_hierarchy!(IDeskBar, ::windows::core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl ::core::clone::Clone for IDeskBar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::PartialEq for IDeskBar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::Eq for IDeskBar {}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::fmt::Debug for IDeskBar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeskBar").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Vtable for IDeskBar {
    type Vtable = IDeskBar_Vtbl;
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Interface for IDeskBar {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeb0fe173_1a3a_11d0_89b3_00a0c90a90ac);
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
#[doc(hidden)]
pub struct IDeskBar_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub SetClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkclient: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunkclient: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnPosRectChangeDB: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *const super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnPosRectChangeDB: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[repr(transparent)]
pub struct IDeskBarClient(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBarClient {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn ContextSensitiveHelp<'a, P0>(&self, fentermode: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ContextSensitiveHelp)(::windows::core::Vtable::as_raw(self), fentermode.into()).ok()
    }
    pub unsafe fn SetDeskBarSite<'a, P0>(&self, punksite: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).SetDeskBarSite)(::windows::core::Vtable::as_raw(self), punksite.into().abi()).ok()
    }
    pub unsafe fn SetModeDBC(&self, dwmode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetModeDBC)(::windows::core::Vtable::as_raw(self), dwmode).ok()
    }
    pub unsafe fn UIActivateDBC(&self, dwstate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UIActivateDBC)(::windows::core::Vtable::as_raw(self), dwstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSize(&self, dwwhich: u32) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSize)(::windows::core::Vtable::as_raw(self), dwwhich, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
}
#[cfg(feature = "Win32_System_Ole")]
::windows::core::interface_hierarchy!(IDeskBarClient, ::windows::core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl ::core::clone::Clone for IDeskBarClient {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::PartialEq for IDeskBarClient {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::cmp::Eq for IDeskBarClient {}
#[cfg(feature = "Win32_System_Ole")]
impl ::core::fmt::Debug for IDeskBarClient {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeskBarClient").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Vtable for IDeskBarClient {
    type Vtable = IDeskBarClient_Vtbl;
}
#[cfg(feature = "Win32_System_Ole")]
unsafe impl ::windows::core::Interface for IDeskBarClient {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeb0fe175_1a3a_11d0_89b3_00a0c90a90ac);
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
#[doc(hidden)]
pub struct IDeskBarClient_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub SetDeskBarSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksite: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetModeDBC: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmode: u32) -> ::windows::core::HRESULT,
    pub UIActivateDBC: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwhich: u32, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetSize: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDesktopGadget(::windows::core::IUnknown);
impl IDesktopGadget {
    pub unsafe fn RunGadget<'a, P0>(&self, gadgetpath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).RunGadget)(::windows::core::Vtable::as_raw(self), gadgetpath.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IDesktopGadget, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDesktopGadget {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDesktopGadget {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDesktopGadget {}
impl ::core::fmt::Debug for IDesktopGadget {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDesktopGadget").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDesktopGadget {
    type Vtable = IDesktopGadget_Vtbl;
}
unsafe impl ::windows::core::Interface for IDesktopGadget {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc1646bc4_f298_4f91_a204_eb2dd1709d1a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDesktopGadget_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub RunGadget: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gadgetpath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDesktopWallpaper(::windows::core::IUnknown);
impl IDesktopWallpaper {
    pub unsafe fn SetWallpaper<'a, P0, P1>(&self, monitorid: P0, wallpaper: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetWallpaper)(::windows::core::Vtable::as_raw(self), monitorid.into(), wallpaper.into()).ok()
    }
    pub unsafe fn GetWallpaper<'a, P0>(&self, monitorid: P0) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetWallpaper)(::windows::core::Vtable::as_raw(self), monitorid.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetMonitorDevicePathAt(&self, monitorindex: u32) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMonitorDevicePathAt)(::windows::core::Vtable::as_raw(self), monitorindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetMonitorDevicePathCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMonitorDevicePathCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMonitorRECT<'a, P0>(&self, monitorid: P0) -> ::windows::core::Result<super::super::Foundation::RECT>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMonitorRECT)(::windows::core::Vtable::as_raw(self), monitorid.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBackgroundColor<'a, P0>(&self, color: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::COLORREF>,
    {
        (::windows::core::Vtable::vtable(self).SetBackgroundColor)(::windows::core::Vtable::as_raw(self), color.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBackgroundColor(&self) -> ::windows::core::Result<super::super::Foundation::COLORREF> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBackgroundColor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::COLORREF>(result__)
    }
    pub unsafe fn SetPosition(&self, position: DESKTOP_WALLPAPER_POSITION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetPosition)(::windows::core::Vtable::as_raw(self), position).ok()
    }
    pub unsafe fn GetPosition(&self) -> ::windows::core::Result<DESKTOP_WALLPAPER_POSITION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetPosition)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<DESKTOP_WALLPAPER_POSITION>(result__)
    }
    pub unsafe fn SetSlideshow<'a, P0>(&self, items: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IShellItemArray>>,
    {
        (::windows::core::Vtable::vtable(self).SetSlideshow)(::windows::core::Vtable::as_raw(self), items.into().abi()).ok()
    }
    pub unsafe fn GetSlideshow(&self) -> ::windows::core::Result<IShellItemArray> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSlideshow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItemArray>(result__)
    }
    pub unsafe fn SetSlideshowOptions(&self, options: DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetSlideshowOptions)(::windows::core::Vtable::as_raw(self), options, slideshowtick).ok()
    }
    pub unsafe fn GetSlideshowOptions(&self, options: *mut DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSlideshowOptions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(options), ::core::mem::transmute(slideshowtick)).ok()
    }
    pub unsafe fn AdvanceSlideshow<'a, P0>(&self, monitorid: P0, direction: DESKTOP_SLIDESHOW_DIRECTION) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).AdvanceSlideshow)(::windows::core::Vtable::as_raw(self), monitorid.into(), direction).ok()
    }
    pub unsafe fn GetStatus(&self) -> ::windows::core::Result<DESKTOP_SLIDESHOW_STATE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<DESKTOP_SLIDESHOW_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, P0>(&self, enable: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).Enable)(::windows::core::Vtable::as_raw(self), enable.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IDesktopWallpaper, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDesktopWallpaper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDesktopWallpaper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDesktopWallpaper {}
impl ::core::fmt::Debug for IDesktopWallpaper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDesktopWallpaper").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDesktopWallpaper {
    type Vtable = IDesktopWallpaper_Vtbl;
}
unsafe impl ::windows::core::Interface for IDesktopWallpaper {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb92b56a9_8b55_4e14_9a89_0199bbb6f93b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDesktopWallpaper_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetWallpaper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitorid: ::windows::core::PCWSTR, wallpaper: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetWallpaper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitorid: ::windows::core::PCWSTR, wallpaper: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetMonitorDevicePathAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitorindex: u32, monitorid: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetMonitorDevicePathCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetMonitorRECT: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitorid: ::windows::core::PCWSTR, displayrect: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetMonitorRECT: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, color: super::super::Foundation::COLORREF) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetBackgroundColor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, color: *mut super::super::Foundation::COLORREF) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetBackgroundColor: usize,
    pub SetPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: DESKTOP_WALLPAPER_POSITION) -> ::windows::core::HRESULT,
    pub GetPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: *mut DESKTOP_WALLPAPER_POSITION) -> ::windows::core::HRESULT,
    pub SetSlideshow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, items: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSlideshow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, items: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetSlideshowOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: u32) -> ::windows::core::HRESULT,
    pub GetSlideshowOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: *mut u32) -> ::windows::core::HRESULT,
    pub AdvanceSlideshow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitorid: ::windows::core::PCWSTR, direction: DESKTOP_SLIDESHOW_DIRECTION) -> ::windows::core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: *mut DESKTOP_SLIDESHOW_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Enable: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDestinationStreamFactory(::windows::core::IUnknown);
impl IDestinationStreamFactory {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDestinationStream(&self) -> ::windows::core::Result<super::super::System::Com::IStream> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDestinationStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::System::Com::IStream>(result__)
    }
}
::windows::core::interface_hierarchy!(IDestinationStreamFactory, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDestinationStreamFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDestinationStreamFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDestinationStreamFactory {}
impl ::core::fmt::Debug for IDestinationStreamFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDestinationStreamFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDestinationStreamFactory {
    type Vtable = IDestinationStreamFactory_Vtbl;
}
unsafe impl ::windows::core::Interface for IDestinationStreamFactory {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8a87781b_39a7_4a1f_aab3_a39b9c34a7d9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDestinationStreamFactory_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetDestinationStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppstm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetDestinationStream: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDisplayItem(::windows::core::IUnknown);
impl IDisplayItem {
    #[doc = "*Required features: `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetItemIDList(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItemIDList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    pub unsafe fn GetItem(&self) -> ::windows::core::Result<IShellItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IShellItem>(result__)
    }
}
::windows::core::interface_hierarchy!(IDisplayItem, ::windows::core::IUnknown, IRelatedItem);
impl ::core::clone::Clone for IDisplayItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDisplayItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDisplayItem {}
impl ::core::fmt::Debug for IDisplayItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDisplayItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDisplayItem {
    type Vtable = IDisplayItem_Vtbl;
}
unsafe impl ::windows::core::Interface for IDisplayItem {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc6fd5997_9f6b_4888_8703_94e80e8cde3f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDisplayItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`*"]
#[repr(transparent)]
pub struct IDocViewSite(::windows::core::IUnknown);
impl IDocViewSite {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnSetTitle(&self, pvtitle: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnSetTitle)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pvtitle)).ok()
    }
}
::windows::core::interface_hierarchy!(IDocViewSite, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDocViewSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDocViewSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDocViewSite {}
impl ::core::fmt::Debug for IDocViewSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDocViewSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDocViewSite {
    type Vtable = IDocViewSite_Vtbl;
}
unsafe impl ::windows::core::Interface for IDocViewSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x87d605e0_c511_11cf_89a9_00a0c9054129);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDocViewSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OnSetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvtitle: *const ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OnSetTitle: usize,
}
#[doc = "*Required features: `\"Win32_UI_Shell\"`, `\"Win32_System_Ole\"`*"]
#[cfg(feature = "Win32_System_Ole")]
#[repr(transparent)]
pub struct IDockingWindow(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Ole")]
impl IDockingWindow {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetWindow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn ContextSensitiveHelp<'a, P0>(&self, fentermode: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.ContextSensitiveHelp)(::windows::core::Vtable::as_raw(self), fentermode.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDW<'a, P0>(&self, fshow: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).ShowDW)(::windows::core::Vtable::as_raw(self), fshow.into()).ok()
    }
    pub unsafe fn CloseDW(&self, dwreserved: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CloseDW)(::windows::core::Vtable::as_raw(self), dwreserved).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ResizeBorderDW<'a, P0, P1>(&self, prcborder: *const super::super::Foundation::RECT, punktoolbarsite: P0, freserved: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).ResizeBorderDW)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(prcborder), punktoolbarsite.into().abi(), freserved.into()).ok()
    }
}
#[c