#!/bin/sh

MULTIARCH=$(dpkg-architecture -qDEB_HOST_MULTIARCH)

case $1 in
apply)
	for FILE in debian/*.postinst debian/*prerm ; do
		echo "replacing #MULTIARCH# with $MULTIARCH in $FILE."
		sed --in-place=.before-multiarchify s/#MULTIARCH#/$MULTIARCH/g $FILE
	done
	;;
revert)
	for FILE in debian/*.postinst debian/*prerm ; do
		if [ -e $FILE.before-multiarchify ]; then
			echo "revert #MULTIARCH# replacement in $FILE"
			mv $FILE.before-multiarchify $FILE
		fi
	done
	;;
*)
	echo "usage: $0 <apply|revert>"
	;;
esac
