/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <errno.h>

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_availableProcessors
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    availableProcessors
 * Signature: ()I
 */

JNIEXPORT static jint JNICALL
Java_java_lang_VMRuntime_availableProcessors (JNIEnv *_env, jclass class)
{
  /* to do */
  return 1;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_freeMemory
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    freeMemory
 * Signature: ()J
 */

JNIEXPORT static jlong JNICALL
Java_java_lang_VMRuntime_freeMemory (JNIEnv *_env, jclass class)
{
  /* to do */
  return 0;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_totalMemory
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    totalMemory
 * Signature: ()J
 */

JNIEXPORT static jlong JNICALL
Java_java_lang_VMRuntime_totalMemory (JNIEnv *_env, jclass class)
{
  /* to do */
  return 0;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_maxMemory
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    maxMemory
 * Signature: ()J
 */

JNIEXPORT static jlong JNICALL
Java_java_lang_VMRuntime_maxMemory (JNIEnv *_env, jclass class)
{
  /* to do */
  return 0;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_gc
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    gc
 * Signature: ()V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_gc (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

#ifdef _SABLEVM_NO_GC

  /* do nothing ;-) */

#elif defined (_SABLEVM_COPY_GC)

  {
    _svmt_JavaVM *vm = env->vm;
    jint status = JNI_OK;

    _svmm_mutex_lock (vm->global_mutex);

    _svmf_halt_if_requested (env);

    status = _svmf_copy_gc_no_exception (env, 0);

    _svmm_mutex_unlock ();

    if (status != JNI_OK)
      {
	_svmm_fatal_error ("impossible control flow");
      }
  }

#else
#error todo
#endif

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_runFinalization
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    runFinalization
 * Signature: ()V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_runFinalization (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

  /* todo */

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_runFinalizationForExit
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    runFinalizationForExit
 * Signature: ()V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_runFinalizationForExit (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

  /* todo */

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_traceInstructions
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    traceInstructions
 * Signature: (Z)V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_traceInstructions (JNIEnv *_env, jclass class,
					    jboolean on)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

#if !defined(NDEBUG)

  env->vm->verbose_instructions = on;

#endif

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_traceMethodCalls
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    traceMethodCalls
 * Signature: (Z)V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_traceMethodCalls (JNIEnv *_env, jclass class,
					   jboolean on)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

#if !defined(NDEBUG)

  env->vm->verbose_methods = on;

#endif

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_runFinalizersOnExit
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    runFinalizersOnExit
 * Signature: (Z)V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_runFinalizersOnExit (JNIEnv *_env, jclass class,
					      jboolean value)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

  _svmf_resuming_java (env);

  /* todo */

  _svmf_stopping_java (env);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_exit
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    exit
 * Signature: (I)V
 */

JNIEXPORT static void JNICALL
Java_java_lang_VMRuntime_exit (JNIEnv *_env, jclass class, jint status)
{

  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);

#ifdef STATISTICS
  _svmf_print_statistics (env);
#endif /* STATISTICS */

  /* this one is simple! */
  exit (status);
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_nativeLoad
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    nativeLoad
 * Signature: (Ljava/lang/String;)Ljava/lang/String;
 */

JNIEXPORT static jint JNICALL
Java_java_lang_VMRuntime_nativeLoad (JNIEnv *_env, jclass class,
				     jstring _filename)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  _svmt_JavaVM *vm = env->vm;
  const char *errmsg = "unknown error";

  _svmf_resuming_java (env);

  {
    char *filename;
    _svmt_class_loader_info *class_loader_info =
      _svmf_get_current_class_loader (env);
    _svmt_native_library *native_library =
      class_loader_info->native_library_list;
    lt_dlhandle handle;
    jboolean monitor_acquired = JNI_FALSE;

    if (_svmf_enter_object_monitor
	(env,
	 *(vm->class_loading.boot_loader.classes.virtualmachine->
	   class_instance)) != JNI_OK)
      {
	goto end;
      }

    monitor_acquired = JNI_TRUE;

    if (_svmm_galloc_utf_chars (env, _filename, filename) != JNI_OK)
      {
	goto end;
      }

    handle = lt_dlopenext (filename);

    if (handle == NULL)
      {
	errmsg = lt_dlerror ();
	_svmm_gfree_utf_chars (filename);
	goto end;
      }

    while (native_library != NULL)
      {
	if (native_library->handle == handle)
	  {
	    errmsg = NULL;
	    _svmm_gfree_utf_chars (filename);
	    goto end;
	  }

	native_library = native_library->next;
      }

    /* Call JNI_OnLoad */
    {
      JNIEXPORT jint (JNICALL *JNI_OnLoad) (JavaVM *, void *);

      JNI_OnLoad =
	(JNIEXPORT jint (JNICALL *)(JavaVM *, void *)) lt_dlsym (handle,
								 "JNI_OnLoad");

      if (JNI_OnLoad != NULL)
	{
	  jint version = JNI_OnLoad (_svmf_cast_JavaVM (vm), NULL);

	  if (version != JNI_VERSION_1_2)
	    {
	      lt_dlclose (handle);
	      goto end;
	    }
	}
    }

    if (_svmm_cl_zalloc_native_library
	(env, class_loader_info,
	 *(class_loader_info->native_library_list_tail)) != JNI_OK)
      {
	_svmm_gfree_utf_chars (filename);
	goto end;
      }

    (*(class_loader_info->native_library_list_tail))->name = filename;
    (*(class_loader_info->native_library_list_tail))->handle = handle;

    class_loader_info->native_library_list_tail =
      &(*(class_loader_info->native_library_list_tail))->next;

    errmsg = NULL;

  end:

    if (monitor_acquired)
      {
	monitor_acquired = JNI_FALSE;

	if (_svmf_exit_object_monitor
	    (env,
	     *(vm->class_loading.boot_loader.classes.virtualmachine->
	       class_instance)) != JNI_OK)
	  {
	    goto end;
	  }
      }

  }

  _svmf_stopping_java (env);

  return errmsg == NULL ? 1 : 0;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getSableVMVersion
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getSableVMVersion
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getSableVMVersion (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, _SABLEVM_PACKAGE_VERSION, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getFileSeparator
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getFileSeparator
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getFileSeparator (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, "/", string);
  }

  _svmf_stopping_java (env);

  return string;
}


/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getPathSeparator
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getPathSeparator
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getPathSeparator (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, ":", string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getLineSeparator
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getLineSeparator
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getLineSeparator (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, "\n", string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getUserName
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getUserName
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getUserName (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    const char *value = getenv ("USER");

    if (value == NULL)
      {
	value = "";
      }

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, value, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getUserHome
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getUserHome
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getUserHome (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    const char *value = getenv ("HOME");

    if (value == NULL)
      {
	value = "";
      }

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, value, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getWorkDir
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getWorkDir
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getWorkDir (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;
    const char *value = vm->boot_working_directory;

    if (value == NULL)
      {
	value = "";
      }

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, value, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getBootstrapLibraryPath
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getBootstrapLibraryPath
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getBootstrapLibraryPath (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;
    const char *value = vm->class_loading.boot_loader.boot_library_path;

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, value, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getBootstrapClassPath
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getBootstrapClassPath
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getBootstrapClassPath (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;
    const char *value = vm->class_loading.boot_loader.boot_class_path;

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env, value, string);
  }

  _svmf_stopping_java (env);

  return string;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getPropertyCount
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getPropertyCount
 * Signature: ()I
 */

JNIEXPORT static jint JNICALL
Java_java_lang_VMRuntime_getPropertyCount (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jint count;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;

    count = vm->class_loading.boot_loader.system_properties.count;
  }

  _svmf_stopping_java (env);

  return count;
}

/*
----------------------------------------------------------------------
Java_java_lang_VMRuntime_getProperty
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMRuntime
 * Method:    getProperty
 * Signature: (I)Ljava/lang/String;
 */

JNIEXPORT static jstring JNICALL
Java_java_lang_VMRuntime_getProperty (JNIEnv *_env, jclass class, jint index)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jstring string;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;

    /* as we do nothing else after, we can safely ignore the return
       value (any exception being also set in the environment) */
    string = _svmf_get_jni_frame_native_local (env);
    _svmf_get_string (env,
		      vm->class_loading.boot_loader.system_properties.
		      properties[index], string);
  }

  _svmf_stopping_java (env);

  return string;
}
