/* header auto-generated by pidl */

#include <stdint.h>

#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/samr.h"
#ifndef _HEADER_drsuapi
#define _HEADER_drsuapi

#define DRSUAPI_DS_BIND_GUID	( "e24d201a-4fd6-11d1-a3da-0000f875ae0d" )
#define DRSUAPI_DS_BIND_GUID_W2K	( "6abec3d1-3054-41c8-a362-5a0c5b7d5d71" )
#define DRSUAPI_DS_BIND_GUID_W2K3	( "6afab99c-6e26-464a-975f-f58f105218bc" )
#define DRSUAPI_DS_MEMBERSHIP_FLAG_GROUP_ATTR	( 0x1 )
#define DRSUAPI_NTDSDSA_KRB5_SERVICE_GUID	( "E3514235-4B06-11D1-AB04-00C04FC2DCD2" )
/* bitmap drsuapi_SupportedExtensions */
#define DRSUAPI_SUPPORTED_EXTENSION_BASE ( 0x00000001 )
#define DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION ( 0x00000002 )
#define DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI ( 0x00000004 )
#define DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2 ( 0x00000008 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS ( 0x00000010 )
#define DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1 ( 0x00000020 )
#define DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION ( 0x00000040 )
#define DRSUAPI_SUPPORTED_EXTENSION_00000080 ( 0x00000080 )
#define DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE ( 0x00000100 )
#define DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2 ( 0x00000200 )
#define DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION ( 0x00000400 )
#define DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2 ( 0x00000800 )
#define DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD ( 0x00001000 )
#define DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND ( 0x00002000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO ( 0x00004000 )
#define DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION ( 0x00008000 )
#define DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01 ( 0x00010000 )
#define DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP ( 0x00020000 )
#define DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY ( 0x00040000 )
#define DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3 ( 0x00080000 )
#define DRSUAPI_SUPPORTED_EXTENSION_00100000 ( 0x00100000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2 ( 0x00200000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6 ( 0x00400000 )
#define DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS ( 0x00800000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8 ( 0x01000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5 ( 0x02000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6 ( 0x04000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3 ( 0x08000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7 ( 0x08000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT ( 0x08000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS ( 0x10000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_20000000 ( 0x20000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_40000000 ( 0x40000000 )
#define DRSUAPI_SUPPORTED_EXTENSION_80000000 ( 0x80000000 )

/* bitmap drsuapi_SupportedExtensionsExt */
#define DRSUAPI_SUPPORTED_EXTENSION_ADAM ( 0x00000001 )
#define DRSUAPI_SUPPORTED_EXTENSION_LH_BETA2 ( 0x00000002 )

struct drsuapi_DsBindInfo24 {
	uint32_t supported_extensions;
	struct GUID site_guid;
	uint32_t pid;
};

struct drsuapi_DsBindInfo28 {
	uint32_t supported_extensions;
	struct GUID site_guid;
	uint32_t pid;
	uint32_t repl_epoch;
};

struct drsuapi_DsBindInfo48 {
	uint32_t supported_extensions;
	struct GUID site_guid;
	uint32_t pid;
	uint32_t repl_epoch;
	uint32_t supported_extensions_ext;
	struct GUID config_dn_guid;
};

struct drsuapi_DsBindInfoFallBack {
	DATA_BLOB info;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

union drsuapi_DsBindInfo {
	struct drsuapi_DsBindInfo24 info24;/* [subcontext(4),case(24)] */
	struct drsuapi_DsBindInfo28 info28;/* [subcontext(4),case(28)] */
	struct drsuapi_DsBindInfo48 info48;/* [subcontext(4),case(48)] */
	struct drsuapi_DsBindInfoFallBack FallBack;/* [subcontext(4),default] */
}/* [nodiscriminant] */;

struct drsuapi_DsBindInfoCtr {
	uint32_t length;/* [range(1,10000)] */
	union drsuapi_DsBindInfo info;/* [switch_is(length)] */
};

struct drsuapi_DsReplicaObjectIdentifier {
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsReplicaObjectIdentifier(r,ndr->flags)-4)] */
	uint32_t __ndr_size_sid;/* [value(ndr_size_dom_sid28(&sid,ndr->flags))] */
	struct GUID guid;
	struct dom_sid28 sid;
	uint32_t __ndr_size_dn;/* [value(strlen_m(dn))] */
	const char *dn;/* [charset(UTF16),size_is(__ndr_size_dn+1)] */
}/* [gensize,public] */;

/* bitmap drsuapi_DsReplicaSyncOptions */
#define DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_SYNC_WRITEABLE ( 0x00000002 )
#define DRSUAPI_DS_REPLICA_SYNC_PERIODIC ( 0x00000004 )
#define DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING ( 0x00000008 )
#define DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES ( 0x00000010 )
#define DRSUAPI_DS_REPLICA_SYNC_FULL ( 0x00000020 )
#define DRSUAPI_DS_REPLICA_SYNC_URGENT ( 0x00000040 )
#define DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD ( 0x00000080 )
#define DRSUAPI_DS_REPLICA_SYNC_FORCE ( 0x00000100 )
#define DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE ( 0x00000200 )
#define DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED ( 0x00000400 )
#define DRSUAPI_DS_REPLICA_SYNC_TWO_WAY ( 0x00000800 )
#define DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY ( 0x00001000 )
#define DRSUAPI_DS_REPLICA_SYNC_INITIAL ( 0x00002000 )
#define DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION ( 0x00004000 )
#define DRSUAPI_DS_REPLICA_SYNC_ABANDONED ( 0x00008000 )
#define DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS ( 0x00010000 )
#define DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET ( 0x00020000 )
#define DRSUAPI_DS_REPLICA_SYNC_REQUEUE ( 0x00040000 )
#define DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION ( 0x00080000 )
#define DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA ( 0x00100000 )
#define DRSUAPI_DS_REPLICA_SYNC_CRITICAL ( 0x00200000 )
#define DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS ( 0x00400000 )
#define DRSUAPI_DS_REPLICA_SYNC_PREEMPTED ( 0x00800000 )

struct drsuapi_DsReplicaSyncRequest1 {
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [unique] */
	struct GUID source_dsa_guid;
	const char * other_info;/* [unique,flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t options;
};

union drsuapi_DsReplicaSyncRequest {
	struct drsuapi_DsReplicaSyncRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsReplicaHighWaterMark {
	uint64_t tmp_highest_usn;
	uint64_t reserved_usn;
	uint64_t highest_usn;
}/* [public] */;

struct drsuapi_DsReplicaCursor {
	struct GUID source_dsa_invocation_id;
	uint64_t highest_usn;
}/* [public] */;

struct drsuapi_DsReplicaCursorCtrEx {
	uint32_t version;/* [value] */
	uint32_t reserved1;/* [value(0)] */
	uint32_t count;/* [range(0,0x100000)] */
	uint32_t reserved2;/* [value(0)] */
	struct drsuapi_DsReplicaCursor *cursors;/* [size_is(count)] */
};

/* bitmap drsuapi_DsReplicaNeighbourFlags */
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_WRITEABLE ( 0x00000010 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_SYNC_ON_STARTUP ( 0x00000020 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_DO_SCHEDULED_SYNCS ( 0x00000040 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_USE_ASYNC_INTERSIDE_TRANSPORT ( 0x00000080 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_TWO_WAY_SYNC ( 0x00000200 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_RETURN_OBJECT_PARENTS ( 0x00000800 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_IN_PROGRESS ( 0x00001000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_NEXT_PACKET ( 0x00002000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_NEVER_SYNCED ( 0x00200000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_PREEMPTED ( 0x01000000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_IGNORE_CHANGE_NOTIFICATIONS ( 0x04000000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_DISABLE_SCHEDULED_SYNC ( 0x08000000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_COMPRESS_CHANGES ( 0x10000000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_NO_CHANGE_NOTIFICATIONS ( 0x20000000 )
#define DRSUAPI_DS_REPLICA_NEIGHBOUR_PARTIAL_ATTRIBUTE_SET ( 0x40000000 )

enum drsuapi_DsExtendedOperation
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_EXOP_NONE=0x00000000,
	DRSUAPI_EXOP_FSMO_REQ_ROLE=0x00000001,
	DRSUAPI_EXOP_FSMO_RID_ALLOC=0x00000002,
	DRSUAPI_EXOP_FSMO_RID_REQ_ROLE=0x00000003,
	DRSUAPI_EXOP_FSMO_REQ_PDC=0x00000004,
	DRSUAPI_EXOP_FSMO_ABANDON_ROLE=0x00000005,
	DRSUAPI_EXOP_REPL_OBJ=0x00000006,
	DRSUAPI_EXOP_REPL_SECRET=0x00000007
}
#else
 { __donnot_use_enum_drsuapi_DsExtendedOperation=0x7FFFFFFF}
#define DRSUAPI_EXOP_NONE ( 0x00000000 )
#define DRSUAPI_EXOP_FSMO_REQ_ROLE ( 0x00000001 )
#define DRSUAPI_EXOP_FSMO_RID_ALLOC ( 0x00000002 )
#define DRSUAPI_EXOP_FSMO_RID_REQ_ROLE ( 0x00000003 )
#define DRSUAPI_EXOP_FSMO_REQ_PDC ( 0x00000004 )
#define DRSUAPI_EXOP_FSMO_ABANDON_ROLE ( 0x00000005 )
#define DRSUAPI_EXOP_REPL_OBJ ( 0x00000006 )
#define DRSUAPI_EXOP_REPL_SECRET ( 0x00000007 )
#endif
;

enum drsuapi_DsExtendedError
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_EXOP_ERR_NONE=0x00000000,
	DRSUAPI_EXOP_ERR_SUCCESS=0x00000001,
	DRSUAPI_EXOP_ERR_UNKNOWN_OP=0x00000002,
	DRSUAPI_EXOP_ERR_FSMO_NOT_OWNER=0x00000003,
	DRSUAPI_EXOP_ERR_UPDATE_ERR=0x00000004,
	DRSUAPI_EXOP_ERR_EXCEPTION=0x00000005,
	DRSUAPI_EXOP_ERR_UNKNOWN_CALLER=0x00000006,
	DRSUAPI_EXOP_ERR_RID_ALLOC=0x00000007,
	DRSUAPI_EXOP_ERR_FSMO_OWNER_DELETED=0x00000008,
	DRSUAPI_EXOP_ERR_FMSO_PENDING_OP=0x00000009,
	DRSUAPI_EXOP_ERR_MISMATCH=0x0000000A,
	DRSUAPI_EXOP_ERR_COULDNT_CONTACT=0x0000000B,
	DRSUAPI_EXOP_ERR_FSMO_REFUSING_ROLES=0x0000000C,
	DRSUAPI_EXOP_ERR_DIR_ERROR=0x0000000D,
	DRSUAPI_EXOP_ERR_FSMO_MISSING_SETTINGS=0x0000000E,
	DRSUAPI_EXOP_ERR_ACCESS_DENIED=0x0000000F,
	DRSUAPI_EXOP_ERR_PARAM_ERROR=0x00000010
}
#else
 { __donnot_use_enum_drsuapi_DsExtendedError=0x7FFFFFFF}
#define DRSUAPI_EXOP_ERR_NONE ( 0x00000000 )
#define DRSUAPI_EXOP_ERR_SUCCESS ( 0x00000001 )
#define DRSUAPI_EXOP_ERR_UNKNOWN_OP ( 0x00000002 )
#define DRSUAPI_EXOP_ERR_FSMO_NOT_OWNER ( 0x00000003 )
#define DRSUAPI_EXOP_ERR_UPDATE_ERR ( 0x00000004 )
#define DRSUAPI_EXOP_ERR_EXCEPTION ( 0x00000005 )
#define DRSUAPI_EXOP_ERR_UNKNOWN_CALLER ( 0x00000006 )
#define DRSUAPI_EXOP_ERR_RID_ALLOC ( 0x00000007 )
#define DRSUAPI_EXOP_ERR_FSMO_OWNER_DELETED ( 0x00000008 )
#define DRSUAPI_EXOP_ERR_FMSO_PENDING_OP ( 0x00000009 )
#define DRSUAPI_EXOP_ERR_MISMATCH ( 0x0000000A )
#define DRSUAPI_EXOP_ERR_COULDNT_CONTACT ( 0x0000000B )
#define DRSUAPI_EXOP_ERR_FSMO_REFUSING_ROLES ( 0x0000000C )
#define DRSUAPI_EXOP_ERR_DIR_ERROR ( 0x0000000D )
#define DRSUAPI_EXOP_ERR_FSMO_MISSING_SETTINGS ( 0x0000000E )
#define DRSUAPI_EXOP_ERR_ACCESS_DENIED ( 0x0000000F )
#define DRSUAPI_EXOP_ERR_PARAM_ERROR ( 0x00000010 )
#endif
;

struct drsuapi_DsGetNCChangesRequest5 {
	struct GUID destination_dsa_guid;
	struct GUID source_dsa_invocation_id;
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [ref] */
	struct drsuapi_DsReplicaHighWaterMark highwatermark;
	struct drsuapi_DsReplicaCursorCtrEx *uptodateness_vector;/* [unique] */
	uint32_t replica_flags;
	uint32_t max_object_count;
	uint32_t max_ndr_size;
	enum drsuapi_DsExtendedOperation extended_op;
	uint64_t fsmo_info;
};

struct drsuapi_DsReplicaOID {
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsReplicaOID_oid(oid,0)),range(0,10000)] */
	const char *oid;/* [unique,charset(DOS),size_is(__ndr_size)] */
}/* [nopush,nopull] */;

struct drsuapi_DsReplicaOIDMapping {
	uint32_t id_prefix;
	struct drsuapi_DsReplicaOID oid;
};

struct drsuapi_DsReplicaOIDMapping_Ctr {
	uint32_t num_mappings;/* [range(0,0x100000)] */
	struct drsuapi_DsReplicaOIDMapping *mappings;/* [unique,size_is(num_mappings)] */
}/* [public] */;

enum drsuapi_DsObjectClassId
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_OBJECTCLASS_top=0x00010000,
	DRSUAPI_OBJECTCLASS_classSchema=0x0003000d,
	DRSUAPI_OBJECTCLASS_attributeSchema=0x0003000e
}
#else
 { __donnot_use_enum_drsuapi_DsObjectClassId=0x7FFFFFFF}
#define DRSUAPI_OBJECTCLASS_top ( 0x00010000 )
#define DRSUAPI_OBJECTCLASS_classSchema ( 0x0003000d )
#define DRSUAPI_OBJECTCLASS_attributeSchema ( 0x0003000e )
#endif
;

enum drsuapi_DsAttributeId
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_ATTRIBUTE_objectClass=0x00000000,
	DRSUAPI_ATTRIBUTE_description=0x0000000d,
	DRSUAPI_ATTRIBUTE_member=0x0000001f,
	DRSUAPI_ATTRIBUTE_instanceType=0x00020001,
	DRSUAPI_ATTRIBUTE_whenCreated=0x00020002,
	DRSUAPI_ATTRIBUTE_hasMasterNCs=0x0002000e,
	DRSUAPI_ATTRIBUTE_governsID=0x00020016,
	DRSUAPI_ATTRIBUTE_attributeID=0x0002001e,
	DRSUAPI_ATTRIBUTE_attributeSyntax=0x00020020,
	DRSUAPI_ATTRIBUTE_isSingleValued=0x00020021,
	DRSUAPI_ATTRIBUTE_rangeLower=0x00020022,
	DRSUAPI_ATTRIBUTE_rangeUpper=0x00020023,
	DRSUAPI_ATTRIBUTE_dMDLocation=0x00020024,
	DRSUAPI_ATTRIBUTE_objectVersion=0x0002004c,
	DRSUAPI_ATTRIBUTE_invocationId=0x00020073,
	DRSUAPI_ATTRIBUTE_showInAdvancedViewOnly=0x000200a9,
	DRSUAPI_ATTRIBUTE_adminDisplayName=0x000200c2,
	DRSUAPI_ATTRIBUTE_adminDescription=0x000200e2,
	DRSUAPI_ATTRIBUTE_oMSyntax=0x000200e7,
	DRSUAPI_ATTRIBUTE_ntSecurityDescriptor=0x00020119,
	DRSUAPI_ATTRIBUTE_searchFlags=0x0002014e,
	DRSUAPI_ATTRIBUTE_lDAPDisplayName=0x000201cc,
	DRSUAPI_ATTRIBUTE_name=0x00090001,
	DRSUAPI_ATTRIBUTE_userAccountControl=0x00090008,
	DRSUAPI_ATTRIBUTE_currentValue=0x0009001b,
	DRSUAPI_ATTRIBUTE_homeDirectory=0x0009002c,
	DRSUAPI_ATTRIBUTE_homeDrive=0x0009002d,
	DRSUAPI_ATTRIBUTE_scriptPath=0x0009003e,
	DRSUAPI_ATTRIBUTE_profilePath=0x0009008b,
	DRSUAPI_ATTRIBUTE_objectSid=0x00090092,
	DRSUAPI_ATTRIBUTE_schemaIDGUID=0x00090094,
	DRSUAPI_ATTRIBUTE_dBCSPwd=0x00090037,
	DRSUAPI_ATTRIBUTE_logonHours=0x00090040,
	DRSUAPI_ATTRIBUTE_userWorkstations=0x00090056,
	DRSUAPI_ATTRIBUTE_unicodePwd=0x0009005a,
	DRSUAPI_ATTRIBUTE_ntPwdHistory=0x0009005e,
	DRSUAPI_ATTRIBUTE_priorValue=0x00090064,
	DRSUAPI_ATTRIBUTE_supplementalCredentials=0x0009007d,
	DRSUAPI_ATTRIBUTE_trustAuthIncoming=0x00090081,
	DRSUAPI_ATTRIBUTE_trustAuthOutgoing=0x00090087,
	DRSUAPI_ATTRIBUTE_lmPwdHistory=0x000900a0,
	DRSUAPI_ATTRIBUTE_sAMAccountName=0x000900dd,
	DRSUAPI_ATTRIBUTE_sAMAccountType=0x0009012e,
	DRSUAPI_ATTRIBUTE_fSMORoleOwner=0x00090171,
	DRSUAPI_ATTRIBUTE_systemFlags=0x00090177,
	DRSUAPI_ATTRIBUTE_serverReference=0x00090203,
	DRSUAPI_ATTRIBUTE_serverReferenceBL=0x00090204,
	DRSUAPI_ATTRIBUTE_initialAuthIncoming=0x0009021b,
	DRSUAPI_ATTRIBUTE_initialAuthOutgoing=0x0009021c,
	DRSUAPI_ATTRIBUTE_wellKnownObjects=0x0009026a,
	DRSUAPI_ATTRIBUTE_dNSHostName=0x0009026b,
	DRSUAPI_ATTRIBUTE_isMemberOfPartialAttributeSet=0x0009027f,
	DRSUAPI_ATTRIBUTE_userPrincipalName=0x00090290,
	DRSUAPI_ATTRIBUTE_groupType=0x000902ee,
	DRSUAPI_ATTRIBUTE_servicePrincipalName=0x00090303,
	DRSUAPI_ATTRIBUTE_objectCategory=0x0009030e,
	DRSUAPI_ATTRIBUTE_gPLink=0x0009037b,
	DRSUAPI_ATTRIBUTE_msDS_Behavior_Version=0x000905b3,
	DRSUAPI_ATTRIBUTE_msDS_KeyVersionNumber=0x000906f6,
	DRSUAPI_ATTRIBUTE_msDS_HasDomainNCs=0x0009071c,
	DRSUAPI_ATTRIBUTE_msDS_hasMasterNCs=0x0009072c
}
#else
 { __donnot_use_enum_drsuapi_DsAttributeId=0x7FFFFFFF}
#define DRSUAPI_ATTRIBUTE_objectClass ( 0x00000000 )
#define DRSUAPI_ATTRIBUTE_description ( 0x0000000d )
#define DRSUAPI_ATTRIBUTE_member ( 0x0000001f )
#define DRSUAPI_ATTRIBUTE_instanceType ( 0x00020001 )
#define DRSUAPI_ATTRIBUTE_whenCreated ( 0x00020002 )
#define DRSUAPI_ATTRIBUTE_hasMasterNCs ( 0x0002000e )
#define DRSUAPI_ATTRIBUTE_governsID ( 0x00020016 )
#define DRSUAPI_ATTRIBUTE_attributeID ( 0x0002001e )
#define DRSUAPI_ATTRIBUTE_attributeSyntax ( 0x00020020 )
#define DRSUAPI_ATTRIBUTE_isSingleValued ( 0x00020021 )
#define DRSUAPI_ATTRIBUTE_rangeLower ( 0x00020022 )
#define DRSUAPI_ATTRIBUTE_rangeUpper ( 0x00020023 )
#define DRSUAPI_ATTRIBUTE_dMDLocation ( 0x00020024 )
#define DRSUAPI_ATTRIBUTE_objectVersion ( 0x0002004c )
#define DRSUAPI_ATTRIBUTE_invocationId ( 0x00020073 )
#define DRSUAPI_ATTRIBUTE_showInAdvancedViewOnly ( 0x000200a9 )
#define DRSUAPI_ATTRIBUTE_adminDisplayName ( 0x000200c2 )
#define DRSUAPI_ATTRIBUTE_adminDescription ( 0x000200e2 )
#define DRSUAPI_ATTRIBUTE_oMSyntax ( 0x000200e7 )
#define DRSUAPI_ATTRIBUTE_ntSecurityDescriptor ( 0x00020119 )
#define DRSUAPI_ATTRIBUTE_searchFlags ( 0x0002014e )
#define DRSUAPI_ATTRIBUTE_lDAPDisplayName ( 0x000201cc )
#define DRSUAPI_ATTRIBUTE_name ( 0x00090001 )
#define DRSUAPI_ATTRIBUTE_userAccountControl ( 0x00090008 )
#define DRSUAPI_ATTRIBUTE_currentValue ( 0x0009001b )
#define DRSUAPI_ATTRIBUTE_homeDirectory ( 0x0009002c )
#define DRSUAPI_ATTRIBUTE_homeDrive ( 0x0009002d )
#define DRSUAPI_ATTRIBUTE_scriptPath ( 0x0009003e )
#define DRSUAPI_ATTRIBUTE_profilePath ( 0x0009008b )
#define DRSUAPI_ATTRIBUTE_objectSid ( 0x00090092 )
#define DRSUAPI_ATTRIBUTE_schemaIDGUID ( 0x00090094 )
#define DRSUAPI_ATTRIBUTE_dBCSPwd ( 0x00090037 )
#define DRSUAPI_ATTRIBUTE_logonHours ( 0x00090040 )
#define DRSUAPI_ATTRIBUTE_userWorkstations ( 0x00090056 )
#define DRSUAPI_ATTRIBUTE_unicodePwd ( 0x0009005a )
#define DRSUAPI_ATTRIBUTE_ntPwdHistory ( 0x0009005e )
#define DRSUAPI_ATTRIBUTE_priorValue ( 0x00090064 )
#define DRSUAPI_ATTRIBUTE_supplementalCredentials ( 0x0009007d )
#define DRSUAPI_ATTRIBUTE_trustAuthIncoming ( 0x00090081 )
#define DRSUAPI_ATTRIBUTE_trustAuthOutgoing ( 0x00090087 )
#define DRSUAPI_ATTRIBUTE_lmPwdHistory ( 0x000900a0 )
#define DRSUAPI_ATTRIBUTE_sAMAccountName ( 0x000900dd )
#define DRSUAPI_ATTRIBUTE_sAMAccountType ( 0x0009012e )
#define DRSUAPI_ATTRIBUTE_fSMORoleOwner ( 0x00090171 )
#define DRSUAPI_ATTRIBUTE_systemFlags ( 0x00090177 )
#define DRSUAPI_ATTRIBUTE_serverReference ( 0x00090203 )
#define DRSUAPI_ATTRIBUTE_serverReferenceBL ( 0x00090204 )
#define DRSUAPI_ATTRIBUTE_initialAuthIncoming ( 0x0009021b )
#define DRSUAPI_ATTRIBUTE_initialAuthOutgoing ( 0x0009021c )
#define DRSUAPI_ATTRIBUTE_wellKnownObjects ( 0x0009026a )
#define DRSUAPI_ATTRIBUTE_dNSHostName ( 0x0009026b )
#define DRSUAPI_ATTRIBUTE_isMemberOfPartialAttributeSet ( 0x0009027f )
#define DRSUAPI_ATTRIBUTE_userPrincipalName ( 0x00090290 )
#define DRSUAPI_ATTRIBUTE_groupType ( 0x000902ee )
#define DRSUAPI_ATTRIBUTE_servicePrincipalName ( 0x00090303 )
#define DRSUAPI_ATTRIBUTE_objectCategory ( 0x0009030e )
#define DRSUAPI_ATTRIBUTE_gPLink ( 0x0009037b )
#define DRSUAPI_ATTRIBUTE_msDS_Behavior_Version ( 0x000905b3 )
#define DRSUAPI_ATTRIBUTE_msDS_KeyVersionNumber ( 0x000906f6 )
#define DRSUAPI_ATTRIBUTE_msDS_HasDomainNCs ( 0x0009071c )
#define DRSUAPI_ATTRIBUTE_msDS_hasMasterNCs ( 0x0009072c )
#endif
;

struct drsuapi_DsPartialAttributeSet {
	uint32_t version;/* [value] */
	uint32_t reserved1;/* [value(0)] */
	uint32_t num_attids;/* [range(1,0x100000)] */
	enum drsuapi_DsAttributeId *attids;/* [size_is(num_attids)] */
};

struct drsuapi_DsGetNCChangesRequest8 {
	struct GUID destination_dsa_guid;
	struct GUID source_dsa_invocation_id;
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [ref] */
	struct drsuapi_DsReplicaHighWaterMark highwatermark;
	struct drsuapi_DsReplicaCursorCtrEx *uptodateness_vector;/* [unique] */
	uint32_t replica_flags;
	uint32_t max_object_count;
	uint32_t max_ndr_size;
	enum drsuapi_DsExtendedOperation extended_op;
	uint64_t fsmo_info;
	struct drsuapi_DsPartialAttributeSet *partial_attribute_set;/* [unique] */
	struct drsuapi_DsPartialAttributeSet *partial_attribute_set_ex;/* [unique] */
	struct drsuapi_DsReplicaOIDMapping_Ctr mapping_ctr;
};

union drsuapi_DsGetNCChangesRequest {
	struct drsuapi_DsGetNCChangesRequest5 req5;/* [case(5)] */
	struct drsuapi_DsGetNCChangesRequest8 req8;/* [case(8)] */
}/* [switch_type(int32)] */;

struct drsuapi_DsReplicaCursor2 {
	struct GUID source_dsa_invocation_id;
	uint64_t highest_usn;
	NTTIME last_sync_success;
}/* [public] */;

struct drsuapi_DsReplicaCursor2CtrEx {
	uint32_t version;/* [value(2)] */
	uint32_t reserved1;/* [value(0)] */
	uint32_t count;/* [range(0,0x100000)] */
	uint32_t reserved2;/* [value(0)] */
	struct drsuapi_DsReplicaCursor2 *cursors;/* [size_is(count)] */
};

struct drsuapi_DsAttributeValue {
	uint32_t __ndr_size;/* [value(ndr_size_DATA_BLOB(0,blob,0)),range(0,10485760)] */
	DATA_BLOB *blob;/* [unique] */
};

struct drsuapi_DsAttributeValueCtr {
	uint32_t num_values;/* [range(0,10485760)] */
	struct drsuapi_DsAttributeValue *values;/* [unique,size_is(num_values)] */
};

struct drsuapi_DsReplicaObjectIdentifier3 {
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsReplicaObjectIdentifier3(r,ndr->flags))] */
	uint32_t __ndr_size_sid;/* [value(ndr_size_dom_sid28(&sid,ndr->flags))] */
	struct GUID guid;
	struct dom_sid28 sid;
	uint32_t __ndr_size_dn;/* [value(strlen_m(dn))] */
	const char *dn;/* [charset(UTF16)] */
}/* [gensize,public] */;

struct drsuapi_DsReplicaObjectIdentifier3Binary {
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary(r,ndr->flags))] */
	uint32_t __ndr_size_sid;/* [value(ndr_size_dom_sid28(&sid,ndr->flags))] */
	struct GUID guid;
	struct dom_sid28 sid;
	uint32_t __ndr_size_dn;/* [value(strlen_m(dn))] */
	const char *dn;/* [charset(UTF16)] */
	uint32_t __ndr_size_binary;/* [value(binary.length+4)] */
	DATA_BLOB binary;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [gensize,public] */;

struct drsuapi_DsReplicaAttribute {
	enum drsuapi_DsAttributeId attid;
	struct drsuapi_DsAttributeValueCtr value_ctr;
}/* [public] */;

struct drsuapi_DsReplicaAttributeCtr {
	uint32_t num_attributes;/* [range(0,1048576)] */
	struct drsuapi_DsReplicaAttribute *attributes;/* [unique,size_is(num_attributes)] */
};

/* bitmap drsuapi_DsReplicaObjectFlags */
#define DRSUAPI_DS_REPLICA_OBJECT_FROM_MASTER ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_OBJECT_DYNAMIC ( 0x00000002 )
#define DRSUAPI_DS_REPLICA_OBJECT_REMOTE_MODIFY ( 0x00010000 )

struct drsuapi_DsReplicaObject {
	struct drsuapi_DsReplicaObjectIdentifier *identifier;/* [unique] */
	uint32_t flags;
	struct drsuapi_DsReplicaAttributeCtr attribute_ctr;
}/* [public] */;

struct drsuapi_DsReplicaMetaData {
	uint32_t version;
	NTTIME originating_change_time;
	struct GUID originating_invocation_id;
	uint64_t originating_usn;
};

struct drsuapi_DsReplicaMetaDataCtr {
	uint32_t count;/* [range(0,1048576)] */
	struct drsuapi_DsReplicaMetaData *meta_data;/* [size_is(count)] */
}/* [public] */;

struct drsuapi_DsReplicaObjectListItemEx {
	struct drsuapi_DsReplicaObjectListItemEx *next_object;/* [unique] */
	struct drsuapi_DsReplicaObject object;
	uint32_t is_nc_prefix;
	struct GUID *parent_object_guid;/* [unique] */
	struct drsuapi_DsReplicaMetaDataCtr *meta_data_ctr;/* [unique] */
}/* [noprint,public] */;

struct drsuapi_DsGetNCChangesCtr1 {
	struct GUID source_dsa_guid;
	struct GUID source_dsa_invocation_id;
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [unique] */
	struct drsuapi_DsReplicaHighWaterMark old_highwatermark;
	struct drsuapi_DsReplicaHighWaterMark new_highwatermark;
	struct drsuapi_DsReplicaCursorCtrEx *uptodateness_vector;/* [unique] */
	struct drsuapi_DsReplicaOIDMapping_Ctr mapping_ctr;
	enum drsuapi_DsExtendedError extended_ret;
	uint32_t object_count;
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsGetNCChangesCtr1(r,ndr->flags)+55)] */
	struct drsuapi_DsReplicaObjectListItemEx *first_object;/* [unique] */
	uint32_t more_data;
}/* [gensize,public] */;

/* bitmap drsuapi_DsLinkedAttributeFlags */
#define DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE ( 0x00000001 )

struct drsuapi_DsReplicaLinkedAttribute {
	struct drsuapi_DsReplicaObjectIdentifier *identifier;/* [unique] */
	enum drsuapi_DsAttributeId attid;
	struct drsuapi_DsAttributeValue value;
	uint32_t flags;
	NTTIME originating_add_time;
	struct drsuapi_DsReplicaMetaData meta_data;
}/* [public] */;

struct drsuapi_DsGetNCChangesCtr6 {
	struct GUID source_dsa_guid;
	struct GUID source_dsa_invocation_id;
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [unique] */
	struct drsuapi_DsReplicaHighWaterMark old_highwatermark;
	struct drsuapi_DsReplicaHighWaterMark new_highwatermark;
	struct drsuapi_DsReplicaCursor2CtrEx *uptodateness_vector;/* [unique] */
	struct drsuapi_DsReplicaOIDMapping_Ctr mapping_ctr;
	enum drsuapi_DsExtendedError extended_ret;
	uint32_t object_count;
	uint32_t __ndr_size;/* [value(ndr_size_drsuapi_DsGetNCChangesCtr6(r,ndr->flags)+55)] */
	struct drsuapi_DsReplicaObjectListItemEx *first_object;/* [unique] */
	uint32_t more_data;
	uint32_t nc_object_count;
	uint32_t nc_linked_attributes_count;
	uint32_t linked_attributes_count;/* [range(0,1048576)] */
	struct drsuapi_DsReplicaLinkedAttribute *linked_attributes;/* [unique,size_is(linked_attributes_count)] */
	WERROR drs_error;
}/* [gensize,public] */;

struct drsuapi_DsGetNCChangesMSZIPCtr1 {
	uint32_t decompressed_length;
	uint32_t compressed_length;
	struct drsuapi_DsGetNCChangesCtr1 *ctr1;/* [unique,compression(NDR_COMPRESSION_MSZIP,compressed_length,decompressed_length),subcontext_size(compressed_length),subcontext(4)] */
};

struct drsuapi_DsGetNCChangesMSZIPCtr6 {
	uint32_t decompressed_length;
	uint32_t compressed_length;
	struct drsuapi_DsGetNCChangesCtr6 *ctr6;/* [unique,compression(NDR_COMPRESSION_MSZIP,compressed_length,decompressed_length),subcontext_size(compressed_length),subcontext(4)] */
};

struct drsuapi_DsGetNCChangesXPRESSCtr1 {
	uint32_t decompressed_length;
	uint32_t compressed_length;
	struct drsuapi_DsGetNCChangesCtr1 *ctr1;/* [unique,compression(NDR_COMPRESSION_XPRESS,compressed_length,decompressed_length),subcontext_size(compressed_length),subcontext(4)] */
};

struct drsuapi_DsGetNCChangesXPRESSCtr6 {
	uint32_t decompressed_length;
	uint32_t compressed_length;
	struct drsuapi_DsGetNCChangesCtr6 *ctr6;/* [unique,compression(NDR_COMPRESSION_XPRESS,compressed_length,decompressed_length),subcontext_size(compressed_length),subcontext(4)] */
};

enum drsuapi_DsGetNCChangesCompressionType
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_COMPRESSION_TYPE_MSZIP=2,
	DRSUAPI_COMPRESSION_TYPE_XPRESS=3
}
#else
 { __donnot_use_enum_drsuapi_DsGetNCChangesCompressionType=0x7FFFFFFF}
#define DRSUAPI_COMPRESSION_TYPE_MSZIP ( 2 )
#define DRSUAPI_COMPRESSION_TYPE_XPRESS ( 3 )
#endif
;

union drsuapi_DsGetNCChangesCompressedCtr {
	struct drsuapi_DsGetNCChangesMSZIPCtr1 mszip1;/* [case(1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16))] */
	struct drsuapi_DsGetNCChangesMSZIPCtr6 mszip6;/* [case(6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16))] */
	struct drsuapi_DsGetNCChangesXPRESSCtr1 xpress1;/* [case(1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16))] */
	struct drsuapi_DsGetNCChangesXPRESSCtr6 xpress6;/* [case(6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16))] */
}/* [nodiscriminant,flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct drsuapi_DsGetNCChangesCtr2 {
	union drsuapi_DsGetNCChangesCompressedCtr ctr;/* [switch_is(1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16))] */
};

struct drsuapi_DsGetNCChangesCtr7 {
	int32_t level;/* [range(0,6)] */
	enum drsuapi_DsGetNCChangesCompressionType type;/* [range(2,3)] */
	union drsuapi_DsGetNCChangesCompressedCtr ctr;/* [switch_is(level|(type<<16))] */
};

union drsuapi_DsGetNCChangesCtr {
	struct drsuapi_DsGetNCChangesCtr1 ctr1;/* [case] */
	struct drsuapi_DsGetNCChangesCtr2 ctr2;/* [case(2)] */
	struct drsuapi_DsGetNCChangesCtr6 ctr6;/* [case(6)] */
	struct drsuapi_DsGetNCChangesCtr7 ctr7;/* [case(7)] */
}/* [switch_type(int32)] */;

/* bitmap drsuapi_DsReplicaUpdateRefsOptions */
#define DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE ( 0x00000002 )
#define DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE ( 0x00000004 )
#define DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE ( 0x00000008 )
#define DRSUAPI_DS_REPLICA_UPDATE_0x00000010 ( 0x00000010 )

struct drsuapi_DsReplicaUpdateRefsRequest1 {
	struct drsuapi_DsReplicaObjectIdentifier *naming_context;/* [ref] */
	const char *dest_dsa_dns_name;/* [ref,charset(DOS)] */
	struct GUID dest_dsa_guid;
	uint32_t options;
};

union drsuapi_DsReplicaUpdateRefsRequest {
	struct drsuapi_DsReplicaUpdateRefsRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

/* bitmap drsuapi_DsReplicaAddOptions */
#define DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_ADD_WRITEABLE ( 0x00000002 )

/* bitmap drsuapi_DsReplicaDeleteOptions */
#define DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_DELETE_WRITEABLE ( 0x00000002 )

/* bitmap drsuapi_DsReplicaModifyOptions */
#define DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION ( 0x00000001 )
#define DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE ( 0x00000002 )

enum drsuapi_DsMembershipType
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS=1,
	DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS=2,
	DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS=3,
	DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2=4,
	DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS=5,
	DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS=6,
	DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2=7
}
#else
 { __donnot_use_enum_drsuapi_DsMembershipType=0x7FFFFFFF}
#define DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS ( 1 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS ( 2 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS ( 3 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2 ( 4 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS ( 5 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS ( 6 )
#define DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2 ( 7 )
#endif
;

struct drsuapi_DsGetMembershipsCtr1 {
	NTSTATUS status;
	uint32_t num_memberships;/* [range(0,10000)] */
	uint32_t num_sids;/* [range(0,10000)] */
	struct drsuapi_DsReplicaObjectIdentifier **info_array;/* [unique,size_is(num_memberships)] */
	uint32_t *group_attrs;/* [unique,size_is(num_memberships)] */
	struct dom_sid28 **sids;/* [unique,size_is(num_sids)] */
};

union drsuapi_DsGetMembershipsCtr {
	struct drsuapi_DsGetMembershipsCtr1 ctr1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsGetMembershipsRequest1 {
	uint32_t count;/* [range(1,10000)] */
	struct drsuapi_DsReplicaObjectIdentifier **info_array;/* [unique,size_is(count)] */
	uint32_t flags;
	enum drsuapi_DsMembershipType type;
	struct drsuapi_DsReplicaObjectIdentifier *domain;/* [unique] */
};

union drsuapi_DsGetMembershipsRequest {
	struct drsuapi_DsGetMembershipsRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsGetNT4ChangeLogRequest1 {
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t length;/* [range(0,0x00A00000)] */
	uint8_t *data;/* [unique,size_is(length)] */
};

union drsuapi_DsGetNT4ChangeLogRequest {
	struct drsuapi_DsGetNT4ChangeLogRequest1 req1;/* [case] */
}/* [switch_type(uint32)] */;

struct drsuapi_DsGetNT4ChangeLogInfo1 {
	uint32_t length1;/* [range(0,0x00A00000)] */
	uint32_t length2;/* [range(0,0x00A00000)] */
	uint64_t unknown1;
	NTTIME time2;
	uint64_t unknown3;
	NTTIME time4;
	uint64_t unknown5;
	NTTIME time6;
	NTSTATUS status;
	uint8_t *data1;/* [unique,size_is(length1)] */
	uint8_t *data2;/* [unique,size_is(length2)] */
};

union drsuapi_DsGetNT4ChangeLogInfo {
	struct drsuapi_DsGetNT4ChangeLogInfo1 info1;/* [case] */
}/* [switch_type(uint32)] */;

enum drsuapi_DsNameStatus
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_NAME_STATUS_OK=0,
	DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR=1,
	DRSUAPI_DS_NAME_STATUS_NOT_FOUND=2,
	DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE=3,
	DRSUAPI_DS_NAME_STATUS_NO_MAPPING=4,
	DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY=5,
	DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING=6,
	DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL=7
}
#else
 { __donnot_use_enum_drsuapi_DsNameStatus=0x7FFFFFFF}
#define DRSUAPI_DS_NAME_STATUS_OK ( 0 )
#define DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR ( 1 )
#define DRSUAPI_DS_NAME_STATUS_NOT_FOUND ( 2 )
#define DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE ( 3 )
#define DRSUAPI_DS_NAME_STATUS_NO_MAPPING ( 4 )
#define DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY ( 5 )
#define DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING ( 6 )
#define DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL ( 7 )
#endif
;

enum drsuapi_DsNameFlags
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_NAME_FLAG_NO_FLAGS=0x0,
	DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY=0x1,
	DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC=0x2,
	DRSUAPI_DS_NAME_FLAG_GCVERIFY=0x4,
	DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL=0x8
}
#else
 { __donnot_use_enum_drsuapi_DsNameFlags=0x7FFFFFFF}
#define DRSUAPI_DS_NAME_FLAG_NO_FLAGS ( 0x0 )
#define DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY ( 0x1 )
#define DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC ( 0x2 )
#define DRSUAPI_DS_NAME_FLAG_GCVERIFY ( 0x4 )
#define DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL ( 0x8 )
#endif
;

enum drsuapi_DsNameFormat
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_NAME_FORMAT_UKNOWN=0,
	DRSUAPI_DS_NAME_FORMAT_FQDN_1779=1,
	DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT=2,
	DRSUAPI_DS_NAME_FORMAT_DISPLAY=3,
	DRSUAPI_DS_NAME_FORMAT_GUID=6,
	DRSUAPI_DS_NAME_FORMAT_CANONICAL=7,
	DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL=8,
	DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX=9,
	DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL=10,
	DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY=11,
	DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN=12
}
#else
 { __donnot_use_enum_drsuapi_DsNameFormat=0x7FFFFFFF}
#define DRSUAPI_DS_NAME_FORMAT_UKNOWN ( 0 )
#define DRSUAPI_DS_NAME_FORMAT_FQDN_1779 ( 1 )
#define DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT ( 2 )
#define DRSUAPI_DS_NAME_FORMAT_DISPLAY ( 3 )
#define DRSUAPI_DS_NAME_FORMAT_GUID ( 6 )
#define DRSUAPI_DS_NAME_FORMAT_CANONICAL ( 7 )
#define DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL ( 8 )
#define DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX ( 9 )
#define DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL ( 10 )
#define DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY ( 11 )
#define DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN ( 12 )
#endif
;

struct drsuapi_DsNameString {
	const char *str;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsNameRequest1 {
	uint32_t codepage;
	uint32_t language;
	enum drsuapi_DsNameFlags format_flags;
	enum drsuapi_DsNameFormat format_offered;
	enum drsuapi_DsNameFormat format_desired;
	uint32_t count;/* [range(1,10000)] */
	struct drsuapi_DsNameString *names;/* [unique,size_is(count)] */
};

union drsuapi_DsNameRequest {
	struct drsuapi_DsNameRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsNameInfo1 {
	enum drsuapi_DsNameStatus status;
	const char *dns_domain_name;/* [unique,charset(UTF16)] */
	const char *result_name;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsNameCtr1 {
	uint32_t count;
	struct drsuapi_DsNameInfo1 *array;/* [unique,size_is(count)] */
};

union drsuapi_DsNameCtr {
	struct drsuapi_DsNameCtr1 *ctr1;/* [unique,case] */
}/* [switch_type(int32)] */;

enum drsuapi_DsSpnOperation
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_SPN_OPERATION_ADD=0,
	DRSUAPI_DS_SPN_OPERATION_REPLACE=1,
	DRSUAPI_DS_SPN_OPERATION_DELETE=2
}
#else
 { __donnot_use_enum_drsuapi_DsSpnOperation=0x7FFFFFFF}
#define DRSUAPI_DS_SPN_OPERATION_ADD ( 0 )
#define DRSUAPI_DS_SPN_OPERATION_REPLACE ( 1 )
#define DRSUAPI_DS_SPN_OPERATION_DELETE ( 2 )
#endif
;

struct drsuapi_DsWriteAccountSpnRequest1 {
	enum drsuapi_DsSpnOperation operation;
	uint32_t unknown1;
	const char *object_dn;/* [unique,charset(UTF16)] */
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsNameString *spn_names;/* [unique,size_is(count)] */
};

union drsuapi_DsWriteAccountSpnRequest {
	struct drsuapi_DsWriteAccountSpnRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsWriteAccountSpnResult1 {
	WERROR status;
};

union drsuapi_DsWriteAccountSpnResult {
	struct drsuapi_DsWriteAccountSpnResult1 res1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsRemoveDSServerRequest1 {
	const char *server_dn;/* [unique,charset(UTF16)] */
	const char *domain_dn;/* [unique,charset(UTF16)] */
	uint32_t unknown;
};

union drsuapi_DsRemoveDSServerRequest {
	struct drsuapi_DsRemoveDSServerRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsRemoveDSServerResult1 {
	WERROR status;
};

union drsuapi_DsRemoveDSServerResult {
	struct drsuapi_DsRemoveDSServerResult1 res1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsGetDCInfoRequest1 {
	const char *domain_name;/* [unique,charset(UTF16)] */
	int32_t level;
};

union drsuapi_DsGetDCInfoRequest {
	struct drsuapi_DsGetDCInfoRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsGetDCInfo1 {
	const char *netbios_name;/* [unique,charset(UTF16)] */
	const char *dns_name;/* [unique,charset(UTF16)] */
	const char *site_name;/* [unique,charset(UTF16)] */
	const char *computer_dn;/* [unique,charset(UTF16)] */
	const char *server_dn;/* [unique,charset(UTF16)] */
	uint32_t is_pdc;
	uint32_t is_enabled;
};

struct drsuapi_DsGetDCInfoCtr1 {
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsGetDCInfo1 *array;/* [unique,size_is(count)] */
};

struct drsuapi_DsGetDCInfo2 {
	const char *netbios_name;/* [unique,charset(UTF16)] */
	const char *dns_name;/* [unique,charset(UTF16)] */
	const char *site_name;/* [unique,charset(UTF16)] */
	const char *site_dn;/* [unique,charset(UTF16)] */
	const char *computer_dn;/* [unique,charset(UTF16)] */
	const char *server_dn;/* [unique,charset(UTF16)] */
	const char *ntds_dn;/* [unique,charset(UTF16)] */
	uint32_t is_pdc;
	uint32_t is_enabled;
	uint32_t is_gc;
	struct GUID site_guid;
	struct GUID computer_guid;
	struct GUID server_guid;
	struct GUID ntds_guid;
};

struct drsuapi_DsGetDCInfoCtr2 {
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsGetDCInfo2 *array;/* [unique,size_is(count)] */
};

struct drsuapi_DsGetDCInfo3 {
	const char *netbios_name;/* [unique,charset(UTF16)] */
	const char *dns_name;/* [unique,charset(UTF16)] */
	const char *site_name;/* [unique,charset(UTF16)] */
	const char *site_dn;/* [unique,charset(UTF16)] */
	const char *computer_dn;/* [unique,charset(UTF16)] */
	const char *server_dn;/* [unique,charset(UTF16)] */
	const char *ntds_dn;/* [unique,charset(UTF16)] */
	uint32_t is_pdc;
	uint32_t is_enabled;
	uint32_t is_gc;
	uint32_t is_rodc;
	struct GUID site_guid;
	struct GUID computer_guid;
	struct GUID server_guid;
	struct GUID ntds_guid;
};

struct drsuapi_DsGetDCInfoCtr3 {
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsGetDCInfo3 *array;/* [unique,size_is(count)] */
};

struct drsuapi_DsGetDCConnection01 {
	const char * client_ip_address;/* [flag(LIBNDR_FLAG_BIGENDIAN)] */
	uint32_t unknown2;
	uint32_t connection_time;
	uint32_t unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	const char *client_account;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsGetDCConnectionCtr01 {
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsGetDCConnection01 *array;/* [unique,size_is(count)] */
};

enum drsuapi_DsGetDCInfoCtrLevels
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DC_INFO_CTR_1=1,
	DRSUAPI_DC_INFO_CTR_2=2,
	DRSUAPI_DC_INFO_CTR_3=3,
	DRSUAPI_DC_CONNECTION_CTR_01=-1
}
#else
 { __donnot_use_enum_drsuapi_DsGetDCInfoCtrLevels=0x7FFFFFFF}
#define DRSUAPI_DC_INFO_CTR_1 ( 1 )
#define DRSUAPI_DC_INFO_CTR_2 ( 2 )
#define DRSUAPI_DC_INFO_CTR_3 ( 3 )
#define DRSUAPI_DC_CONNECTION_CTR_01 ( -1 )
#endif
;

union drsuapi_DsGetDCInfoCtr {
	struct drsuapi_DsGetDCInfoCtr1 ctr1;/* [case(DRSUAPI_DC_INFO_CTR_1)] */
	struct drsuapi_DsGetDCInfoCtr2 ctr2;/* [case(DRSUAPI_DC_INFO_CTR_2)] */
	struct drsuapi_DsGetDCInfoCtr3 ctr3;/* [case(DRSUAPI_DC_INFO_CTR_3)] */
	struct drsuapi_DsGetDCConnectionCtr01 ctr01;/* [case(DRSUAPI_DC_CONNECTION_CTR_01)] */
}/* [switch_type(int32)] */;

struct drsuapi_DsReplicaObjectListItem {
	struct drsuapi_DsReplicaObjectListItem *next_object;/* [unique] */
	struct drsuapi_DsReplicaObject object;
}/* [noprint,public] */;

struct drsuapi_DsAddEntryRequest2 {
	struct drsuapi_DsReplicaObjectListItem first_object;
};

union drsuapi_DsAddEntryRequest {
	struct drsuapi_DsAddEntryRequest2 req2;/* [case(2)] */
}/* [switch_type(int32)] */;

struct drsuapi_DsAddEntryErrorInfoX {
	uint32_t unknown1;
	WERROR status;
	uint32_t unknown2;
	uint16_t unknown3;
};

struct drsuapi_DsAddEntryExtraErrorBuffer {
	uint32_t size;/* [range(0,10485760)] */
	uint8_t *data;/* [unique,size_is(size)] */
};

struct drsuapi_DsAddEntryExtraError1 {
	struct drsuapi_DsAddEntryErrorInfoX error;
	enum drsuapi_DsAttributeId attid;
	uint32_t unknown2;
	struct drsuapi_DsAddEntryExtraErrorBuffer buffer;
};

struct drsuapi_DsAddEntryErrorListItem1 {
	struct drsuapi_DsAddEntryErrorListItem1 *next;/* [unique] */
	struct drsuapi_DsAddEntryExtraError1 error;
};

struct drsuapi_DsAddEntryErrorInfo1 {
	struct drsuapi_DsReplicaObjectIdentifier *id;/* [unique] */
	WERROR status;
	struct drsuapi_DsAddEntryErrorListItem1 first;
};

union drsuapi_DsAddEntryErrorInfo {
	struct drsuapi_DsAddEntryErrorInfo1 error1;/* [case] */
	struct drsuapi_DsAddEntryErrorInfoX errorX;/* [case(4)] */
}/* [switch_type(uint32)] */;

struct drsuapi_DsAddEntryError1 {
	WERROR status;
	uint32_t level;
	union drsuapi_DsAddEntryErrorInfo *info;/* [unique,switch_is(level)] */
};

union drsuapi_DsAddEntryError {
	struct drsuapi_DsAddEntryError1 info1;/* [case] */
}/* [switch_type(uint32)] */;

struct drsuapi_DsReplicaObjectIdentifier2 {
	struct GUID guid;
	struct dom_sid28 sid;
};

struct drsuapi_DsAddEntryCtr2 {
	struct drsuapi_DsReplicaObjectIdentifier *id;/* [unique] */
	uint32_t unknown1;
	struct drsuapi_DsAddEntryErrorInfoX error;
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsReplicaObjectIdentifier2 *objects;/* [unique,size_is(count)] */
};

struct drsuapi_DsAddEntryCtr3 {
	struct drsuapi_DsReplicaObjectIdentifier *id;/* [unique] */
	uint32_t level;
	union drsuapi_DsAddEntryError *error;/* [unique,switch_is(level)] */
	uint32_t count;/* [range(0,10000)] */
	struct drsuapi_DsReplicaObjectIdentifier2 *objects;/* [unique,size_is(count)] */
};

union drsuapi_DsAddEntryCtr {
	struct drsuapi_DsAddEntryCtr2 ctr2;/* [case(2)] */
	struct drsuapi_DsAddEntryCtr3 ctr3;/* [case(3)] */
}/* [switch_type(int32)] */;

enum drsuapi_DsReplicaGetInfoLevel
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_REPLICA_GET_INFO=1,
	DRSUAPI_DS_REPLICA_GET_INFO2=2
}
#else
 { __donnot_use_enum_drsuapi_DsReplicaGetInfoLevel=0x7FFFFFFF}
#define DRSUAPI_DS_REPLICA_GET_INFO ( 1 )
#define DRSUAPI_DS_REPLICA_GET_INFO2 ( 2 )
#endif
;

enum drsuapi_DsReplicaInfoType
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_REPLICA_INFO_NEIGHBORS=0,
	DRSUAPI_DS_REPLICA_INFO_CURSORS=1,
	DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA=2,
	DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES=3,
	DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES=4,
	DRSUAPI_DS_REPLICA_INFO_PENDING_OPS=5,
	DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA=6,
	DRSUAPI_DS_REPLICA_INFO_CURSORS2=7,
	DRSUAPI_DS_REPLICA_INFO_CURSORS3=8,
	DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2=9,
	DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2=10,
	DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02=-2,
	DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04=-4,
	DRSUAPI_DS_REPLICA_INFO_CURSORS05=-5,
	DRSUAPI_DS_REPLICA_INFO_06=-6
}
#else
 { __donnot_use_enum_drsuapi_DsReplicaInfoType=0x7FFFFFFF}
#define DRSUAPI_DS_REPLICA_INFO_NEIGHBORS ( 0 )
#define DRSUAPI_DS_REPLICA_INFO_CURSORS ( 1 )
#define DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA ( 2 )
#define DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES ( 3 )
#define DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES ( 4 )
#define DRSUAPI_DS_REPLICA_INFO_PENDING_OPS ( 5 )
#define DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA ( 6 )
#define DRSUAPI_DS_REPLICA_INFO_CURSORS2 ( 7 )
#define DRSUAPI_DS_REPLICA_INFO_CURSORS3 ( 8 )
#define DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2 ( 9 )
#define DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2 ( 10 )
#define DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02 ( -2 )
#define DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04 ( -4 )
#define DRSUAPI_DS_REPLICA_INFO_CURSORS05 ( -5 )
#define DRSUAPI_DS_REPLICA_INFO_06 ( -6 )
#endif
;

struct drsuapi_DsReplicaGetInfoRequest1 {
	enum drsuapi_DsReplicaInfoType info_type;
	const char *object_dn;/* [unique,charset(UTF16)] */
	struct GUID guid1;
};

struct drsuapi_DsReplicaGetInfoRequest2 {
	enum drsuapi_DsReplicaInfoType info_type;
	const char *object_dn;/* [unique,charset(UTF16)] */
	struct GUID guid1;
	uint32_t unknown1;
	const char *string1;/* [unique,charset(UTF16)] */
	const char *string2;/* [unique,charset(UTF16)] */
	uint32_t unknown2;
};

union drsuapi_DsReplicaGetInfoRequest {
	struct drsuapi_DsReplicaGetInfoRequest1 req1;/* [case(DRSUAPI_DS_REPLICA_GET_INFO)] */
	struct drsuapi_DsReplicaGetInfoRequest2 req2;/* [case(DRSUAPI_DS_REPLICA_GET_INFO2)] */
}/* [switch_type(drsuapi_DsReplicaGetInfoLevel)] */;

struct drsuapi_DsReplicaNeighbour {
	const char *naming_context_dn;/* [unique,charset(UTF16)] */
	const char *source_dsa_obj_dn;/* [unique,charset(UTF16)] */
	const char *source_dsa_address;/* [unique,charset(UTF16)] */
	const char *transport_obj_dn;/* [unique,charset(UTF16)] */
	uint32_t replica_flags;
	uint32_t reserved;
	struct GUID naming_context_obj_guid;
	struct GUID source_dsa_obj_guid;
	struct GUID source_dsa_invocation_id;
	struct GUID transport_obj_guid;
	uint64_t tmp_highest_usn;
	uint64_t highest_usn;
	NTTIME last_success;
	NTTIME last_attempt;
	WERROR result_last_attempt;
	uint32_t consecutive_sync_failures;
};

struct drsuapi_DsReplicaNeighbourCtr {
	uint32_t count;
	uint32_t reserved;
	struct drsuapi_DsReplicaNeighbour *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaCursorCtr {
	uint32_t count;
	uint32_t reserved;
	struct drsuapi_DsReplicaCursor *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaObjMetaData {
	const char *attribute_name;/* [unique,charset(UTF16)] */
	uint32_t version;
	NTTIME originating_change_time;
	struct GUID originating_invocation_id;
	uint64_t originating_usn;
	uint64_t local_usn;
};

struct drsuapi_DsReplicaObjMetaDataCtr {
	uint32_t count;
	uint32_t reserved;
	struct drsuapi_DsReplicaObjMetaData *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaKccDsaFailure {
	const char *dsa_obj_dn;/* [unique,charset(UTF16)] */
	struct GUID dsa_obj_guid;
	NTTIME first_failure;
	uint32_t num_failures;
	WERROR last_result;
};

struct drsuapi_DsReplicaKccDsaFailuresCtr {
	uint32_t count;
	uint32_t reserved;
	struct drsuapi_DsReplicaKccDsaFailure *array;/* [size_is(count)] */
};

enum drsuapi_DsReplicaOpType
#ifndef USE_UINT_ENUMS
 {
	DRSUAPI_DS_REPLICA_OP_TYPE_SYNC=0,
	DRSUAPI_DS_REPLICA_OP_TYPE_ADD=1,
	DRSUAPI_DS_REPLICA_OP_TYPE_DELETE=2,
	DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY=3,
	DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS=4
}
#else
 { __donnot_use_enum_drsuapi_DsReplicaOpType=0x7FFFFFFF}
#define DRSUAPI_DS_REPLICA_OP_TYPE_SYNC ( 0 )
#define DRSUAPI_DS_REPLICA_OP_TYPE_ADD ( 1 )
#define DRSUAPI_DS_REPLICA_OP_TYPE_DELETE ( 2 )
#define DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY ( 3 )
#define DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS ( 4 )
#endif
;

union drsuapi_DsRplicaOpOptions {
	uint32_t sync;/* [case(DRSUAPI_DS_REPLICA_OP_TYPE_SYNC)] */
	uint32_t add;/* [case(DRSUAPI_DS_REPLICA_OP_TYPE_ADD)] */
	uint32_t op_delete;/* [case(DRSUAPI_DS_REPLICA_OP_TYPE_DELETE)] */
	uint32_t modify;/* [case(DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY)] */
	uint32_t update_refs;/* [case(DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS)] */
	uint32_t unknown;/* [default] */
}/* [switch_type(drsuapi_DsReplicaOpType)] */;

struct drsuapi_DsReplicaOp {
	NTTIME operation_start;
	uint32_t serial_num;
	uint32_t priority;
	enum drsuapi_DsReplicaOpType operation_type;
	union drsuapi_DsRplicaOpOptions options;/* [switch_is(operation_type)] */
	const char *nc_dn;/* [unique,charset(UTF16)] */
	const char *remote_dsa_obj_dn;/* [unique,charset(UTF16)] */
	const char *remote_dsa_address;/* [unique,charset(UTF16)] */
	struct GUID nc_obj_guid;
	struct GUID remote_dsa_obj_guid;
};

struct drsuapi_DsReplicaOpCtr {
	NTTIME time;
	uint32_t count;
	struct drsuapi_DsReplicaOp *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaAttrValMetaData {
	const char *attribute_name;/* [unique,charset(UTF16)] */
	const char *object_dn;/* [unique,charset(UTF16)] */
	uint32_t __ndr_size_binary;/* [value(ndr_size_DATA_BLOB(0,binary,0))] */
	DATA_BLOB *binary;/* [unique] */
	NTTIME deleted;
	NTTIME created;
	uint32_t version;
	NTTIME originating_change_time;
	struct GUID originating_invocation_id;
	uint64_t originating_usn;
	uint64_t local_usn;
};

struct drsuapi_DsReplicaAttrValMetaDataCtr {
	uint32_t count;
	int32_t enumeration_context;
	struct drsuapi_DsReplicaAttrValMetaData *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaCursor2Ctr {
	uint32_t count;
	int32_t enumeration_context;
	struct drsuapi_DsReplicaCursor2 *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaCursor3 {
	struct GUID source_dsa_invocation_id;
	uint64_t highest_usn;
	NTTIME last_sync_success;
	const char *source_dsa_obj_dn;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsReplicaCursor3Ctr {
	uint32_t count;
	int32_t enumeration_context;
	struct drsuapi_DsReplicaCursor3 *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaObjMetaData2 {
	const char *attribute_name;/* [unique,charset(UTF16)] */
	uint32_t version;
	NTTIME originating_change_time;
	struct GUID originating_invocation_id;
	uint64_t originating_usn;
	uint64_t local_usn;
	const char *originating_dsa_dn;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsReplicaObjMetaData2Ctr {
	uint32_t count;
	int32_t enumeration_context;
	struct drsuapi_DsReplicaObjMetaData2 *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaAttrValMetaData2 {
	const char *attribute_name;/* [unique,charset(UTF16)] */
	const char *object_dn;/* [unique,charset(UTF16)] */
	uint32_t __ndr_size_binary;/* [value(ndr_size_DATA_BLOB(0,binary,0))] */
	DATA_BLOB *binary;/* [unique] */
	NTTIME deleted;
	NTTIME created;
	uint32_t version;
	NTTIME originating_change_time;
	struct GUID originating_invocation_id;
	uint64_t originating_usn;
	uint64_t local_usn;
	const char *originating_dsa_dn;/* [unique,charset(UTF16)] */
};

struct drsuapi_DsReplicaAttrValMetaData2Ctr {
	uint32_t count;
	int32_t enumeration_context;
	struct drsuapi_DsReplicaAttrValMetaData2 *array;/* [size_is(count)] */
};

struct drsuapi_DsReplicaConnection04 {
	uint64_t u1;
	uint32_t u2;
	uint32_t u3;
	struct GUID bind_guid;
	NTTIME bind_time;
	const char * client_ip_address;/* [flag(LIBNDR_FLAG_BIGENDIAN)] */
	uint32_t u5;
};

struct drsuapi_DsReplicaConnection04Ctr {
	uint32_t count;/* [range(0,10000)] */
	uint32_t reserved;
	struct drsuapi_DsReplicaConnection04 *array;/* [size_is(count)] */
};

struct drsuapi_DsReplica06 {
	const char *str1;/* [unique,charset(UTF16)] */
	uint32_t u1;
	uint32_t u2;
	uint32_t u3;
	uint32_t u4;
	uint32_t u5;
	uint64_t u6;
	uint32_t u7;
};

struct drsuapi_DsReplica06Ctr {
	uint32_t count;/* [range(0,256)] */
	uint32_t reserved;
	struct drsuapi_DsReplica06 *array;/* [size_is(count)] */
};

union drsuapi_DsReplicaInfo {
	struct drsuapi_DsReplicaNeighbourCtr *neighbours;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_NEIGHBORS)] */
	struct drsuapi_DsReplicaCursorCtr *cursors;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_CURSORS)] */
	struct drsuapi_DsReplicaObjMetaDataCtr *objmetadata;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA)] */
	struct drsuapi_DsReplicaKccDsaFailuresCtr *connectfailures;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES)] */
	struct drsuapi_DsReplicaKccDsaFailuresCtr *linkfailures;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES)] */
	struct drsuapi_DsReplicaOpCtr *pendingops;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_PENDING_OPS)] */
	struct drsuapi_DsReplicaAttrValMetaDataCtr *attrvalmetadata;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA)] */
	struct drsuapi_DsReplicaCursor2Ctr *cursors2;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_CURSORS2)] */
	struct drsuapi_DsReplicaCursor3Ctr *cursors3;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_CURSORS3)] */
	struct drsuapi_DsReplicaObjMetaData2Ctr *objmetadata2;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2)] */
	struct drsuapi_DsReplicaAttrValMetaData2Ctr *attrvalmetadata2;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2)] */
	struct drsuapi_DsReplicaNeighbourCtr *neighbours02;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02)] */
	struct drsuapi_DsReplicaConnection04Ctr *connections04;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04)] */
	struct drsuapi_DsReplicaCursorCtrEx *cursors05;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_CURSORS05)] */
	struct drsuapi_DsReplica06Ctr *i06;/* [unique,case(DRSUAPI_DS_REPLICA_INFO_06)] */
}/* [switch_type(drsuapi_DsReplicaInfoType)] */;

struct drsuapi_DsGetMemberships2Ctr1 {
	uint32_t num_entries;/* [range(0,10000)] */
	struct drsuapi_DsGetMembershipsCtr1 **ctrl_array;/* [unique,size_is(num_entries)] */
};

union drsuapi_DsGetMemberships2Ctr {
	struct drsuapi_DsGetMembershipsCtr1 ctr1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsGetMemberships2Request1 {
	uint32_t num_req;/* [range(1,10000)] */
	struct drsuapi_DsGetMembershipsRequest1 **req_array;/* [unique,size_is(num_req)] */
};

union drsuapi_DsGetMemberships2Request {
	struct drsuapi_DsGetMemberships2Request1 req1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_DsSiteCostInfo {
	WERROR error_code;
	uint32_t site_cost;
};

struct drsuapi_QuerySitesByCostCtr1 {
	uint32_t num_info;/* [range(0,10000)] */
	struct drsuapi_DsSiteCostInfo *info;/* [unique,size_is(num_info)] */
	uint32_t unknown;
};

union drsuapi_QuerySitesByCostCtr {
	struct drsuapi_QuerySitesByCostCtr1 ctr1;/* [case] */
}/* [switch_type(int32)] */;

struct drsuapi_QuerySitesByCostRequest1 {
	const char *site_from;/* [unique,charset(UTF16)] */
	uint32_t num_req;/* [range(1,10000)] */
	const char **site_to;/* [unique,charset(UTF16),size_is(num_req)] */
	uint32_t flags;
};

union drsuapi_QuerySitesByCostRequest {
	struct drsuapi_QuerySitesByCostRequest1 req1;/* [case] */
}/* [switch_type(int32)] */;


struct drsuapi_DsBind {
	struct {
		struct GUID *bind_guid;/* [unique] */
		struct drsuapi_DsBindInfoCtr *bind_info;/* [unique] */
	} in;

	struct {
		struct policy_handle *bind_handle;/* [ref] */
		struct drsuapi_DsBindInfoCtr *bind_info;/* [unique] */
		WERROR result;
	} out;

};


struct drsuapi_DsUnbind {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *bind_handle;/* [ref] */
		WERROR result;
	} out;

};


struct drsuapi_DsReplicaSync {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsReplicaSyncRequest req;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsGetNCChanges {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsGetNCChangesRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsGetNCChangesCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct drsuapi_DsReplicaUpdateRefs {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsReplicaUpdateRefsRequest req;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct DRSUAPI_REPLICA_ADD {
	struct {
		WERROR result;
	} out;

};


struct DRSUAPI_REPLICA_DEL {
	struct {
		WERROR result;
	} out;

};


struct DRSUAPI_REPLICA_MODIFY {
	struct {
		WERROR result;
	} out;

};


struct DRSUAPI_VERIFY_NAMES {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsGetMemberships {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsGetMembershipsRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsGetMembershipsCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct DRSUAPI_INTER_DOMAIN_MOVE {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsGetNT4ChangeLog {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		uint32_t level;
		union drsuapi_DsGetNT4ChangeLogRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		uint32_t *level_out;/* [ref] */
		union drsuapi_DsGetNT4ChangeLogInfo *info;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct drsuapi_DsCrackNames {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsNameRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsNameCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct drsuapi_DsWriteAccountSpn {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsWriteAccountSpnRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsWriteAccountSpnResult *res;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct drsuapi_DsRemoveDSServer {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsRemoveDSServerRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsRemoveDSServerResult *res;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct DRSUAPI_REMOVE_DS_DOMAIN {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsGetDomainControllerInfo {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsGetDCInfoRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsGetDCInfoCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct drsuapi_DsAddEntry {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsAddEntryRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsAddEntryCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct DRSUAPI_EXECUTE_KCC {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsReplicaGetInfo {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		enum drsuapi_DsReplicaGetInfoLevel level;
		union drsuapi_DsReplicaGetInfoRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		enum drsuapi_DsReplicaInfoType *info_type;/* [ref] */
		union drsuapi_DsReplicaInfo *info;/* [ref,switch_is(*info_type)] */
		WERROR result;
	} out;

};


struct DRSUAPI_ADD_SID_HISTORY {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_DsGetMemberships2 {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_DsGetMemberships2Request *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_DsGetMemberships2Ctr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};


struct DRSUAPI_REPLICA_VERIFY_OBJECTS {
	struct {
		WERROR result;
	} out;

};


struct DRSUAPI_GET_OBJECT_EXISTENCE {
	struct {
		WERROR result;
	} out;

};


struct drsuapi_QuerySitesByCost {
	struct {
		struct policy_handle *bind_handle;/* [ref] */
		int32_t level;
		union drsuapi_QuerySitesByCostRequest *req;/* [ref,switch_is(level)] */
	} in;

	struct {
		int32_t *level_out;/* [ref] */
		union drsuapi_QuerySitesByCostCtr *ctr;/* [ref,switch_is(*level_out)] */
		WERROR result;
	} out;

};

#endif /* _HEADER_drsuapi */
