/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "librpc/gen_ndr/srv_frstrans.h"

static bool api_frstrans_CheckConnectivity(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_CheckConnectivity *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_CHECKCONNECTIVITY];

	r = talloc(talloc_tos(), struct frstrans_CheckConnectivity);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_CheckConnectivity, NDR_IN, r);
	}

	r->out.result = _frstrans_CheckConnectivity(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_CheckConnectivity, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_EstablishConnection(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_EstablishConnection *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ESTABLISHCONNECTION];

	r = talloc(talloc_tos(), struct frstrans_EstablishConnection);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_EstablishConnection, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.upstream_protocol_version = talloc_zero(r, enum frstrans_ProtocolVersion);
	if (r->out.upstream_protocol_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.upstream_flags = talloc_zero(r, uint32_t);
	if (r->out.upstream_flags == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_EstablishConnection(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_EstablishConnection, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_EstablishSession(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_EstablishSession *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ESTABLISHSESSION];

	r = talloc(talloc_tos(), struct frstrans_EstablishSession);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_EstablishSession, NDR_IN, r);
	}

	r->out.result = _frstrans_EstablishSession(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_EstablishSession, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_RequestUpdates(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_RequestUpdates *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUESTUPDATES];

	r = talloc(talloc_tos(), struct frstrans_RequestUpdates);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RequestUpdates, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.frs_update = talloc_zero_array(r, struct frstrans_Update, r->in.credits_available);
	if (r->out.frs_update == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.update_count = talloc_zero(r, uint32_t);
	if (r->out.update_count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.update_status = talloc_zero(r, enum frstrans_UpdateStatus);
	if (r->out.update_status == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.gvsn_db_guid = talloc_zero(r, struct GUID);
	if (r->out.gvsn_db_guid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.gvsn_version = talloc_zero(r, uint64_t);
	if (r->out.gvsn_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_RequestUpdates(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RequestUpdates, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_RequestVersionVector(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_RequestVersionVector *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUESTVERSIONVECTOR];

	r = talloc(talloc_tos(), struct frstrans_RequestVersionVector);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RequestVersionVector, NDR_IN, r);
	}

	r->out.result = _frstrans_RequestVersionVector(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RequestVersionVector, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_AsyncPoll(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_AsyncPoll *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ASYNCPOLL];

	r = talloc(talloc_tos(), struct frstrans_AsyncPoll);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_AsyncPoll, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.response = talloc_zero(r, struct frstrans_AsyncResponseContext);
	if (r->out.response == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_AsyncPoll(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_AsyncPoll, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_REQUEST_RECORDS(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_REQUEST_RECORDS *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUEST_RECORDS];

	r = talloc(talloc_tos(), struct FRSTRANS_REQUEST_RECORDS);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_REQUEST_RECORDS, NDR_IN, r);
	}

	_FRSTRANS_REQUEST_RECORDS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_REQUEST_RECORDS, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_UPDATE_CANCEL(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_UPDATE_CANCEL *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_UPDATE_CANCEL];

	r = talloc(talloc_tos(), struct FRSTRANS_UPDATE_CANCEL);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_UPDATE_CANCEL, NDR_IN, r);
	}

	_FRSTRANS_UPDATE_CANCEL(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_UPDATE_CANCEL, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RAW_GET_FILE_DATA(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_RAW_GET_FILE_DATA *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RAW_GET_FILE_DATA];

	r = talloc(talloc_tos(), struct FRSTRANS_RAW_GET_FILE_DATA);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RAW_GET_FILE_DATA, NDR_IN, r);
	}

	_FRSTRANS_RAW_GET_FILE_DATA(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RAW_GET_FILE_DATA, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_GET_SIGNATURES(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_RDC_GET_SIGNATURES *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_GET_SIGNATURES];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_GET_SIGNATURES);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_GET_SIGNATURES, NDR_IN, r);
	}

	_FRSTRANS_RDC_GET_SIGNATURES(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_GET_SIGNATURES, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_PUSH_SOURCE_NEEDS, NDR_IN, r);
	}

	_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_PUSH_SOURCE_NEEDS, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_GET_FILE_DATA(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_RDC_GET_FILE_DATA *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_GET_FILE_DATA];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_GET_FILE_DATA);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_GET_FILE_DATA, NDR_IN, r);
	}

	_FRSTRANS_RDC_GET_FILE_DATA(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_GET_FILE_DATA, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_CLOSE(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_RDC_CLOSE *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_CLOSE];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_CLOSE);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_CLOSE, NDR_IN, r);
	}

	_FRSTRANS_RDC_CLOSE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_RDC_CLOSE, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_InitializeFileTransferAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_InitializeFileTransferAsync *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC];

	r = talloc(talloc_tos(), struct frstrans_InitializeFileTransferAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_InitializeFileTransferAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.frs_update = r->in.frs_update;
	r->out.staging_policy = r->in.staging_policy;
	r->out.server_context = talloc_zero(r, struct policy_handle);
	if (r->out.server_context == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rdc_file_info = talloc_zero(r, struct frstrans_RdcFileInfo *);
	if (r->out.rdc_file_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data_buffer = talloc_zero_array(r, uint8_t, r->in.buffer_size);
	if (r->out.data_buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.size_read = talloc_zero(r, uint32_t);
	if (r->out.size_read == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.is_end_of_file = talloc_zero(r, uint32_t);
	if (r->out.is_end_of_file == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_InitializeFileTransferAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_InitializeFileTransferAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE];

	r = talloc(talloc_tos(), struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, NDR_IN, r);
	}

	_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_RawGetFileDataAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_RawGetFileDataAsync *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RAWGETFILEDATAASYNC];

	r = talloc(talloc_tos(), struct frstrans_RawGetFileDataAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RawGetFileDataAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.byte_pipe = talloc_zero(r, struct frstrans_BytePipe);
	if (r->out.byte_pipe == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_RawGetFileDataAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RawGetFileDataAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_frstrans_RdcGetFileDataAsync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct frstrans_RdcGetFileDataAsync *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDCGETFILEDATAASYNC];

	r = talloc(talloc_tos(), struct frstrans_RdcGetFileDataAsync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RdcGetFileDataAsync, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.byte_pipe = talloc_zero(r, struct frstrans_BytePipe);
	if (r->out.byte_pipe == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_RdcGetFileDataAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(frstrans_RdcGetFileDataAsync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_frstrans_cmds[] = 
{
	{"FRSTRANS_CHECKCONNECTIVITY", NDR_FRSTRANS_CHECKCONNECTIVITY, api_frstrans_CheckConnectivity},
	{"FRSTRANS_ESTABLISHCONNECTION", NDR_FRSTRANS_ESTABLISHCONNECTION, api_frstrans_EstablishConnection},
	{"FRSTRANS_ESTABLISHSESSION", NDR_FRSTRANS_ESTABLISHSESSION, api_frstrans_EstablishSession},
	{"FRSTRANS_REQUESTUPDATES", NDR_FRSTRANS_REQUESTUPDATES, api_frstrans_RequestUpdates},
	{"FRSTRANS_REQUESTVERSIONVECTOR", NDR_FRSTRANS_REQUESTVERSIONVECTOR, api_frstrans_RequestVersionVector},
	{"FRSTRANS_ASYNCPOLL", NDR_FRSTRANS_ASYNCPOLL, api_frstrans_AsyncPoll},
	{"FRSTRANS_REQUEST_RECORDS", NDR_FRSTRANS_REQUEST_RECORDS, api_FRSTRANS_REQUEST_RECORDS},
	{"FRSTRANS_UPDATE_CANCEL", NDR_FRSTRANS_UPDATE_CANCEL, api_FRSTRANS_UPDATE_CANCEL},
	{"FRSTRANS_RAW_GET_FILE_DATA", NDR_FRSTRANS_RAW_GET_FILE_DATA, api_FRSTRANS_RAW_GET_FILE_DATA},
	{"FRSTRANS_RDC_GET_SIGNATURES", NDR_FRSTRANS_RDC_GET_SIGNATURES, api_FRSTRANS_RDC_GET_SIGNATURES},
	{"FRSTRANS_RDC_PUSH_SOURCE_NEEDS", NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS, api_FRSTRANS_RDC_PUSH_SOURCE_NEEDS},
	{"FRSTRANS_RDC_GET_FILE_DATA", NDR_FRSTRANS_RDC_GET_FILE_DATA, api_FRSTRANS_RDC_GET_FILE_DATA},
	{"FRSTRANS_RDC_CLOSE", NDR_FRSTRANS_RDC_CLOSE, api_FRSTRANS_RDC_CLOSE},
	{"FRSTRANS_INITIALIZEFILETRANSFERASYNC", NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC, api_frstrans_InitializeFileTransferAsync},
	{"FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE", NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, api_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE},
	{"FRSTRANS_RAWGETFILEDATAASYNC", NDR_FRSTRANS_RAWGETFILEDATAASYNC, api_frstrans_RawGetFileDataAsync},
	{"FRSTRANS_RDCGETFILEDATAASYNC", NDR_FRSTRANS_RDCGETFILEDATAASYNC, api_frstrans_RdcGetFileDataAsync},
};

void frstrans_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_frstrans_cmds;
	*n_fns = sizeof(api_frstrans_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_frstrans_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "frstrans", "frstrans", &ndr_table_frstrans, api_frstrans_cmds, sizeof(api_frstrans_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_frstrans_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_frstrans);
}
