#include "includes.h"
#include "lib/com/dcom/dcom.h"
#include "librpc/gen_ndr/com_wmi.h"
#include "librpc/rpc/dcerpc.h"
/* DCOM proxy for IWbemServices generated by pidl */


static WERROR dcom_proxy_IWbemServices_OpenNamespace(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strNamespace, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemServices **ppWorkingNamespace, struct IWbemCallResult **ppResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct OpenNamespace r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strNamespace = strNamespace;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppWorkingNamespace.obj, ppWorkingNamespace));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppResult.obj, ppResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(OpenNamespace, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_OPENNAMESPACE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(OpenNamespace, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppWorkingNamespace, r.out.ppWorkingNamespace.obj));
	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppResult, r.out.ppResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_CancelAsyncCall(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct IWbemObjectSink *pSink)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct CancelAsyncCall r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pSink.obj, pSink));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(CancelAsyncCall, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_CANCELASYNCCALL, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(CancelAsyncCall, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_QueryObjectSink(struct IWbemServices *d, TALLOC_CTX *mem_ctx, int32_t lFlags, struct IWbemObjectSink **ppResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct QueryObjectSink r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lFlags = lFlags;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(QueryObjectSink, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_QUERYOBJECTSINK, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(QueryObjectSink, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppResponseHandler, r.out.ppResponseHandler.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_GetObject(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemClassObject **ppObject, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetObject r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppObject.obj, ppObject));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetObject, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_GETOBJECT, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetObject, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppObject, r.out.ppObject.obj));
	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_GetObjectAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetObjectAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetObjectAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_GETOBJECTASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetObjectAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_PutClass(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct IWbemClassObject *pObject, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct PutClass r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pObject.obj, pObject));
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(PutClass, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_PUTCLASS, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(PutClass, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_PutClassAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct IWbemClassObject *pObject, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct PutClassAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pObject.obj, pObject));
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(PutClassAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_PUTCLASSASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(PutClassAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_DeleteClass(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strClass, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct DeleteClass r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(DeleteClass, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_DELETECLASS, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(DeleteClass, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_DeleteClassAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strClass, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct DeleteClassAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strClass = strClass;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(DeleteClassAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_DELETECLASSASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(DeleteClassAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_CreateClassEnum(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strSuperclass, int32_t lFlags, struct IWbemContext *pCtx, struct IEnumWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct CreateClassEnum r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(CreateClassEnum, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_CREATECLASSENUM, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnum, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_CreateClassEnumAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strSuperclass, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct CreateClassEnumAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strSuperclass = strSuperclass;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(CreateClassEnumAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_CREATECLASSENUMASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(CreateClassEnumAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_PutInstance(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct IWbemClassObject *pInst, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct PutInstance r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pInst.obj, pInst));
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(PutInstance, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_PUTINSTANCE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(PutInstance, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_PutInstanceAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct IWbemClassObject *pInst, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct PutInstanceAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pInst.obj, pInst));
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(PutInstanceAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_PUTINSTANCEASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(PutInstanceAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_DeleteInstance(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct DeleteInstance r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(DeleteInstance, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_DELETEINSTANCE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(DeleteInstance, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_DeleteInstanceAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct DeleteInstanceAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(DeleteInstanceAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_DELETEINSTANCEASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(DeleteInstanceAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_CreateInstanceEnum(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strFilter, int32_t lFlags, struct IWbemContext *pCtx, struct IEnumWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct CreateInstanceEnum r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strFilter = strFilter;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnum, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_CREATEINSTANCEENUM, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnum, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_CreateInstanceEnumAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strSuperClass, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct CreateInstanceEnumAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strSuperClass = strSuperClass;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(CreateInstanceEnumAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_CREATEINSTANCEENUMASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(CreateInstanceEnumAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecQuery(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strQueryLanguage, struct BSTR strQuery, int32_t lFlags, struct IWbemContext *pCtx, struct IEnumWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecQuery r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecQuery, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECQUERY, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecQuery, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecQueryAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strQueryLanguage, struct BSTR strQuery, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecQueryAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecQueryAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECQUERYASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecQueryAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecNotificationQuery(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strQueryLanguage, struct BSTR strQuery, int32_t lFlags, struct IWbemContext *pCtx, struct IEnumWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecNotificationQuery r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQuery, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECNOTIFICATIONQUERY, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQuery, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecNotificationQueryAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strQueryLanguage, struct BSTR strQuery, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecNotificationQueryAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strQueryLanguage = strQueryLanguage;
	r.in.strQuery = strQuery;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecNotificationQueryAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECNOTIFICATIONQUERYASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecNotificationQueryAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecMethod(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, struct BSTR strMethodName, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemClassObject *pInParams, struct IWbemClassObject **ppOutParams, struct IWbemCallResult **ppCallResult)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecMethod r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pInParams.obj, pInParams));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppOutParams.obj, ppOutParams));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.ppCallResult.obj, ppCallResult));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecMethod, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECMETHOD, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecMethod, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppOutParams, r.out.ppOutParams.obj));
	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppCallResult, r.out.ppCallResult.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemServices_ExecMethodAsync(struct IWbemServices *d, TALLOC_CTX *mem_ctx, struct BSTR strObjectPath, struct BSTR strMethodName, uint32_t lFlags, struct IWbemContext *pCtx, struct IWbemClassObject *pInParams, struct IWbemObjectSink *pResponseHandler)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct ExecMethodAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.strObjectPath = strObjectPath;
	r.in.strMethodName = strMethodName;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pInParams.obj, pInParams));
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pResponseHandler.obj, pResponseHandler));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(ExecMethodAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemServices, NDR_EXECMETHODASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(ExecMethodAsync, r);		
	}


	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemServices_init(void)
{
	struct IWbemServices_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemServices_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->OpenNamespace = dcom_proxy_IWbemServices_OpenNamespace;
	proxy_vtable->CancelAsyncCall = dcom_proxy_IWbemServices_CancelAsyncCall;
	proxy_vtable->QueryObjectSink = dcom_proxy_IWbemServices_QueryObjectSink;
	proxy_vtable->GetObject = dcom_proxy_IWbemServices_GetObject;
	proxy_vtable->GetObjectAsync = dcom_proxy_IWbemServices_GetObjectAsync;
	proxy_vtable->PutClass = dcom_proxy_IWbemServices_PutClass;
	proxy_vtable->PutClassAsync = dcom_proxy_IWbemServices_PutClassAsync;
	proxy_vtable->DeleteClass = dcom_proxy_IWbemServices_DeleteClass;
	proxy_vtable->DeleteClassAsync = dcom_proxy_IWbemServices_DeleteClassAsync;
	proxy_vtable->CreateClassEnum = dcom_proxy_IWbemServices_CreateClassEnum;
	proxy_vtable->CreateClassEnumAsync = dcom_proxy_IWbemServices_CreateClassEnumAsync;
	proxy_vtable->PutInstance = dcom_proxy_IWbemServices_PutInstance;
	proxy_vtable->PutInstanceAsync = dcom_proxy_IWbemServices_PutInstanceAsync;
	proxy_vtable->DeleteInstance = dcom_proxy_IWbemServices_DeleteInstance;
	proxy_vtable->DeleteInstanceAsync = dcom_proxy_IWbemServices_DeleteInstanceAsync;
	proxy_vtable->CreateInstanceEnum = dcom_proxy_IWbemServices_CreateInstanceEnum;
	proxy_vtable->CreateInstanceEnumAsync = dcom_proxy_IWbemServices_CreateInstanceEnumAsync;
	proxy_vtable->ExecQuery = dcom_proxy_IWbemServices_ExecQuery;
	proxy_vtable->ExecQueryAsync = dcom_proxy_IWbemServices_ExecQueryAsync;
	proxy_vtable->ExecNotificationQuery = dcom_proxy_IWbemServices_ExecNotificationQuery;
	proxy_vtable->ExecNotificationQueryAsync = dcom_proxy_IWbemServices_ExecNotificationQueryAsync;
	proxy_vtable->ExecMethod = dcom_proxy_IWbemServices_ExecMethod;
	proxy_vtable->ExecMethodAsync = dcom_proxy_IWbemServices_ExecMethodAsync;

	proxy_vtable->iid = ndr_table_IWbemServices.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IEnumWbemClassObject generated by pidl */


static WERROR dcom_proxy_IEnumWbemClassObject_Reset(struct IEnumWbemClassObject *d, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct Reset r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(Reset, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IEnumWbemClassObject, NDR_RESET, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(Reset, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IEnumWbemClassObject_IEnumWbemClassObject_Next(struct IEnumWbemClassObject *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, uint32_t uCount, struct IWbemClassObject **apObjects, uint32_t *puReturned)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct IEnumWbemClassObject_Next r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;
	r.in.uCount = uCount;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Next, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IEnumWbemClassObject, NDR_IENUMWBEMCLASSOBJECT_NEXT, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Next, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &apObjects, r.out.apObjects.obj));
	*puReturned = r.out.puReturned;

	return r.out.result;
}


static WERROR dcom_proxy_IEnumWbemClassObject_NextAsync(struct IEnumWbemClassObject *d, TALLOC_CTX *mem_ctx, uint32_t uCount, struct IWbemObjectSink *pSink)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct NextAsync r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.uCount = uCount;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pSink.obj, pSink));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(NextAsync, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IEnumWbemClassObject, NDR_NEXTASYNC, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(NextAsync, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IEnumWbemClassObject_IEnumWbemClassObject_Clone(struct IEnumWbemClassObject *d, TALLOC_CTX *mem_ctx, struct IEnumWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct IEnumWbemClassObject_Clone r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(IEnumWbemClassObject_Clone, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IEnumWbemClassObject, NDR_IENUMWBEMCLASSOBJECT_CLONE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(IEnumWbemClassObject_Clone, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IEnumWbemClassObject_Skip(struct IEnumWbemClassObject *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, uint32_t nCount)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct Skip r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;
	r.in.nCount = nCount;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(Skip, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IEnumWbemClassObject, NDR_SKIP, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(Skip, r);		
	}


	return r.out.result;
}

static NTSTATUS dcom_proxy_IEnumWbemClassObject_init(void)
{
	struct IEnumWbemClassObject_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IEnumWbemClassObject_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->Reset = dcom_proxy_IEnumWbemClassObject_Reset;
	proxy_vtable->IEnumWbemClassObject_Next = dcom_proxy_IEnumWbemClassObject_IEnumWbemClassObject_Next;
	proxy_vtable->NextAsync = dcom_proxy_IEnumWbemClassObject_NextAsync;
	proxy_vtable->IEnumWbemClassObject_Clone = dcom_proxy_IEnumWbemClassObject_IEnumWbemClassObject_Clone;
	proxy_vtable->Skip = dcom_proxy_IEnumWbemClassObject_Skip;

	proxy_vtable->iid = ndr_table_IEnumWbemClassObject.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IWbemLevel1Login generated by pidl */


static WERROR dcom_proxy_IWbemLevel1Login_EstablishPosition(struct IWbemLevel1Login *d, TALLOC_CTX *mem_ctx, uint16_t *wszLocaleList, uint32_t dwNumLocales, uint32_t *reserved)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct EstablishPosition r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.wszLocaleList = wszLocaleList;
	r.in.dwNumLocales = dwNumLocales;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(EstablishPosition, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemLevel1Login, NDR_ESTABLISHPOSITION, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(EstablishPosition, r);		
	}

	*reserved = r.out.reserved;

	return r.out.result;
}


static WERROR dcom_proxy_IWbemLevel1Login_RequestChallenge(struct IWbemLevel1Login *d, TALLOC_CTX *mem_ctx, uint16_t *wszNetworkResource, uint16_t *wszUser, uint8_t *Nonce)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct RequestChallenge r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszUser = wszUser;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(RequestChallenge, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemLevel1Login, NDR_REQUESTCHALLENGE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(RequestChallenge, r);		
	}

	*Nonce = r.out.Nonce;

	return r.out.result;
}


static WERROR dcom_proxy_IWbemLevel1Login_WBEMLogin(struct IWbemLevel1Login *d, TALLOC_CTX *mem_ctx, uint16_t *wszPreferredLocale, uint8_t *AccessToken, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemServices **ppNamespace)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct WBEMLogin r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.AccessToken = AccessToken;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(WBEMLogin, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemLevel1Login, NDR_WBEMLOGIN, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(WBEMLogin, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppNamespace, r.out.ppNamespace.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemLevel1Login_NTLMLogin(struct IWbemLevel1Login *d, TALLOC_CTX *mem_ctx, uint16_t *wszNetworkResource, uint16_t *wszPreferredLocale, int32_t lFlags, struct IWbemContext *pCtx, struct IWbemServices **ppNamespace)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct NTLMLogin r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.wszNetworkResource = wszNetworkResource;
	r.in.wszPreferredLocale = wszPreferredLocale;
	r.in.lFlags = lFlags;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pCtx.obj, pCtx));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(NTLMLogin, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemLevel1Login, NDR_NTLMLOGIN, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(NTLMLogin, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppNamespace, r.out.ppNamespace.obj));

	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemLevel1Login_init(void)
{
	struct IWbemLevel1Login_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemLevel1Login_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->EstablishPosition = dcom_proxy_IWbemLevel1Login_EstablishPosition;
	proxy_vtable->RequestChallenge = dcom_proxy_IWbemLevel1Login_RequestChallenge;
	proxy_vtable->WBEMLogin = dcom_proxy_IWbemLevel1Login_WBEMLogin;
	proxy_vtable->NTLMLogin = dcom_proxy_IWbemLevel1Login_NTLMLogin;

	proxy_vtable->iid = ndr_table_IWbemLevel1Login.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IWbemWCOSmartEnum generated by pidl */


static WERROR dcom_proxy_IWbemWCOSmartEnum_IWbemWCOSmartEnum_Next(struct IWbemWCOSmartEnum *d, TALLOC_CTX *mem_ctx, struct GUID *gEWCO, uint32_t lTimeOut, uint32_t uCount, uint32_t unknown, struct GUID *gWCO, uint32_t *puReturned, uint32_t *pSize, uint8_t **pData)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct IWbemWCOSmartEnum_Next r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.gEWCO = gEWCO;
	r.in.lTimeOut = lTimeOut;
	r.in.uCount = uCount;
	r.in.unknown = unknown;
	r.in.gWCO = gWCO;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(IWbemWCOSmartEnum_Next, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemWCOSmartEnum, NDR_IWBEMWCOSMARTENUM_NEXT, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(IWbemWCOSmartEnum_Next, r);		
	}

	*puReturned = r.out.puReturned;
	*pSize = r.out.pSize;
	*pData = r.out.pData;

	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemWCOSmartEnum_init(void)
{
	struct IWbemWCOSmartEnum_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemWCOSmartEnum_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->IWbemWCOSmartEnum_Next = dcom_proxy_IWbemWCOSmartEnum_IWbemWCOSmartEnum_Next;

	proxy_vtable->iid = ndr_table_IWbemWCOSmartEnum.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IWbemFetchSmartEnum generated by pidl */


static WERROR dcom_proxy_IWbemFetchSmartEnum_Fetch(struct IWbemFetchSmartEnum *d, TALLOC_CTX *mem_ctx, struct IWbemWCOSmartEnum **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct Fetch r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(Fetch, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemFetchSmartEnum, NDR_FETCH, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(Fetch, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemFetchSmartEnum_Test(struct IWbemFetchSmartEnum *d, TALLOC_CTX *mem_ctx, struct IWbemClassObject **ppEnum)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct Test r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(Test, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemFetchSmartEnum, NDR_TEST, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(Test, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppEnum, r.out.ppEnum.obj));

	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemFetchSmartEnum_init(void)
{
	struct IWbemFetchSmartEnum_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemFetchSmartEnum_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->Fetch = dcom_proxy_IWbemFetchSmartEnum_Fetch;
	proxy_vtable->Test = dcom_proxy_IWbemFetchSmartEnum_Test;

	proxy_vtable->iid = ndr_table_IWbemFetchSmartEnum.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IWbemCallResult generated by pidl */


static WERROR dcom_proxy_IWbemCallResult_GetResultObject(struct IWbemCallResult *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, struct IWbemClassObject **ppResultObject)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetResultObject r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetResultObject, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemCallResult, NDR_GETRESULTOBJECT, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetResultObject, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppResultObject, r.out.ppResultObject.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemCallResult_GetResultString(struct IWbemCallResult *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, struct BSTR *pstrResultString)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetResultString r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetResultString, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemCallResult, NDR_GETRESULTSTRING, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetResultString, r);		
	}

	*pstrResultString = r.out.pstrResultString;

	return r.out.result;
}


static WERROR dcom_proxy_IWbemCallResult_GetResultServices(struct IWbemCallResult *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, struct IWbemServices **ppServices)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetResultServices r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetResultServices, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemCallResult, NDR_GETRESULTSERVICES, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetResultServices, r);		
	}

	NDR_CHECK(dcom_IUnknown_from_OBJREF(d->ctx, &ppServices, r.out.ppServices.obj));

	return r.out.result;
}


static WERROR dcom_proxy_IWbemCallResult_GetCallStatus(struct IWbemCallResult *d, TALLOC_CTX *mem_ctx, int32_t lTimeout, int32_t *plStatus)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct GetCallStatus r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lTimeout = lTimeout;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(GetCallStatus, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemCallResult, NDR_GETCALLSTATUS, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(GetCallStatus, r);		
	}

	*plStatus = r.out.plStatus;

	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemCallResult_init(void)
{
	struct IWbemCallResult_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemCallResult_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->GetResultObject = dcom_proxy_IWbemCallResult_GetResultObject;
	proxy_vtable->GetResultString = dcom_proxy_IWbemCallResult_GetResultString;
	proxy_vtable->GetResultServices = dcom_proxy_IWbemCallResult_GetResultServices;
	proxy_vtable->GetCallStatus = dcom_proxy_IWbemCallResult_GetCallStatus;

	proxy_vtable->iid = ndr_table_IWbemCallResult.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

/* DCOM proxy for IWbemObjectSink generated by pidl */


static WERROR dcom_proxy_IWbemObjectSink_SetStatus(struct IWbemObjectSink *d, TALLOC_CTX *mem_ctx, int32_t lFlags, WERROR hResult, struct BSTR strParam, struct IWbemClassObject *pObjParam)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct SetStatus r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lFlags = lFlags;
	r.in.hResult = hResult;
	r.in.strParam = strParam;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.pObjParam.obj, pObjParam));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(SetStatus, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemObjectSink, NDR_SETSTATUS, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(SetStatus, r);		
	}


	return r.out.result;
}


static WERROR dcom_proxy_IWbemObjectSink_Indicate(struct IWbemObjectSink *d, TALLOC_CTX *mem_ctx, int32_t lObjectCount, struct IWbemClassObject **apObjArray)
{
	struct dcerpc_pipe *p;
	NTSTATUS status = dcom_get_pipe(d, &p);
	struct Indicate r;
	struct rpc_request *req;

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	ZERO_STRUCT(r.in.ORPCthis);
	r.in.ORPCthis.version.MajorVersion = COM_MAJOR_VERSION;
	r.in.ORPCthis.version.MinorVersion = COM_MINOR_VERSION;
	r.in.lObjectCount = lObjectCount;
	NDR_CHECK(dcom_OBJREF_from_IUnknown(mem_ctx, &r.in.apObjArray.obj, apObjArray));

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG(Indicate, &r);		
	}

	status = dcerpc_ndr_request(p, &d->ipid, &ndr_table_IWbemObjectSink, NDR_INDICATE, mem_ctx, &r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG(Indicate, r);		
	}


	return r.out.result;
}

static NTSTATUS dcom_proxy_IWbemObjectSink_init(void)
{
	struct IWbemObjectSink_vtable *proxy_vtable = talloc(talloc_autofree_context(), struct IWbemObjectSink_vtable);

	struct GUID base_iid;
	const void *base_vtable;

	base_iid = ndr_table_IUnknown.syntax_id.uuid;

	base_vtable = dcom_proxy_vtable_by_iid(&base_iid);
	if (base_vtable == NULL) {
		DEBUG(0, ("No proxy registered for base interface 'IUnknown'\n"));
		return NT_STATUS_FOOBAR;
	}
	
	memcpy(&proxy_vtable, base_vtable, sizeof(struct IUnknown_vtable));

	proxy_vtable->SetStatus = dcom_proxy_IWbemObjectSink_SetStatus;
	proxy_vtable->Indicate = dcom_proxy_IWbemObjectSink_Indicate;

	proxy_vtable->iid = ndr_table_IWbemObjectSink.syntax_id.uuid;

	return dcom_register_proxy((struct IUnknown_vtable *)proxy_vtable);
}

